//
// C++ Implementation: searchwidget
//
// Description:
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "searchwidget.h"
#include "../backend/CommonTypes.h"
#include "log.h"
#include <stdexcept>
#include <QtGui>

SearchWidget::SearchWidget(QWidget *parent)
        : QWidget(parent)
{

    ui.setupUi(this);
    ui.searchView->setModel(&model);
	ui.searchView->header()->setClickable(true);
	ui.searchView->header()->setSortIndicatorShown(true);
	ui.searchView->setContextMenuPolicy(Qt::CustomContextMenu);
	connect(ui.searchView,SIGNAL(customContextMenuRequested ( const QPoint&)),SLOT(onContextMenu(const QPoint&)));
	contextMenu = new QMenu(this);
	/*QAction* dlAction = */contextMenu->addAction(QIcon(":/images/download.png"), tr("Download"),this,SLOT(onContextDownload()));
	/*QAction* dltoAction = */contextMenu->addAction(QIcon(":/images/downloadto.png"),  tr("Download to..."),this,SLOT(onContextDownloadTo()));
	/*QAction* dldirAction = */contextMenu->addAction(QIcon(":/images/dldir.png"),  tr("Download whole directory"),this,SLOT(onContextDownloadDir() ));
	/*QAction* dldirtoAction = */contextMenu->addAction(QIcon(":/images/dldirto.png"),  tr("Download directory to..."),this,SLOT(onContextDownloadDirTo() ));
	/*QAction* tthSearchAction = */contextMenu->addAction(QIcon(":/images/tthsearch.png"),  tr("Search for alternates" ),this, SLOT(onContextTTHSearch()));
	/*QAction* getFileListAction = */contextMenu->addAction(QIcon(":/images/filelist.png"),  tr("Get file list" ), this, SLOT(onContextGetFileList()));
}


SearchWidget::~SearchWidget()
{
	logger->debug("SearchWidget dtor");
}

void SearchWidget::on_searchButton_pressed( )
{
    qint64 size = ui.sizeSpin->value();
    switch(ui.sizeTypeCombo->currentIndex())
    {
    case 3: // gib
        size*=1024;
    case 2: //mb
        size*=1024;
    case 1:
        size*=1024;
    default:
        ;
    }
    int sizemode = ui.sizeModeCombo->currentIndex()==0 ? backend::SIZE_ATLEAST : backend::SIZE_ATMOST;
    int typemode = ui.typeCombo->currentIndex();

    logger->info(QString("emitting search with size: %1 sizemode: %2 typemode: %3 text: %4").
                 arg(size).arg(sizemode).arg(typemode).arg(ui.searchCombo->currentText()));
	
	model.clear();
	
    emit search(0,size,sizemode,typemode,ui.searchCombo->currentText(),this);
}

void SearchWidget::on_searchCombo_activated( const QString &)
{
	on_searchButton_pressed();
}

void SearchWidget::searchResults( int session, const QList< SearchEntry > sr)
{
    model.onSearchResult( session, sr );
}

void SearchWidget::on_searchView_doubleClicked( const QModelIndex &index )
{
    download(index);
}

void SearchWidget::download( const QModelIndex &index )
{
    try
    {
        if (index.isValid())
        {
            SearchEntry entry = model.getEntry( index.row() );
            logger->debug( "Downloading file:" + entry.getFileName() );
            emit downloadFile( entry );
        }
        else
            logger->error("SearchWidget::download() : index.isValid() == false \n");
    }
    catch(const std::out_of_range& e)
    {
        logger->error("SearchWidget::download() : out_of_range exception\n");
    }
}


void SearchWidget::downloadTo( const QModelIndex &index )
{
	if(!index.isValid()) return;
	SearchEntry entry = model.getEntry(index.row());
	QString dir = QFileDialog::getExistingDirectory ( this, tr("Select destination directory"), QString());
	if(!dir.isEmpty())
		emit downloadFileTo(entry, dir);
}

void SearchWidget::onContextMenu( const QPoint &p )
{
	if( ui.searchView->indexAt(p).isValid() ) {
		contextMenu->exec(QCursor::pos());
	}
}

void SearchWidget::onContextDownload( )
{
	download( ui.searchView->currentIndex() );
}

void SearchWidget::onContextDownloadTo( )
{
	downloadTo( ui.searchView->currentIndex() );
}

void SearchWidget::onContextDownloadDir( )
{
	QModelIndex index = ui.searchView->currentIndex();
	SearchEntry entry = model.getEntry( index.row() );
	emit downloadFile( entry.getUserId(), entry.getPath(), -1, QString() );
}

void SearchWidget::onContextDownloadDirTo( )
{
	QModelIndex index = ui.searchView->currentIndex();
	SearchEntry entry = model.getEntry( index.row() );
	QString dir = QFileDialog::getExistingDirectory ( this, tr("Select destination directory"), QString());
	if(!dir.isEmpty()) 
		emit downloadFileTo(entry.getUserId(), entry.getPath(), -1, QString(), dir);
}

void SearchWidget::onContextTTHSearch( )
{
	QModelIndex index = ui.searchView->currentIndex();
	SearchEntry entry = model.getEntry( index.row() );
	if(!entry.getTTH().isEmpty())
		emit search(0,entry.getFileSize(),backend::SIZE_ATLEAST,backend::TYPE_TTH,entry.getTTH(),NULL);
	else 
		emit search(0,entry.getFileSize(),backend::SIZE_ATLEAST,backend::TYPE_ANY,entry.getFileName(),NULL);
}

void SearchWidget::onContextGetFileList( )
{
	QModelIndex index = ui.searchView->currentIndex();
	SearchEntry entry = model.getEntry( index.row() );
	emit getUserFileList( entry.getUserId() );
}

void SearchWidget::on_hideZeroSlots_stateChanged( int state )
{
	model.enableFilter( state == Qt::Checked );
}
