/*
 * Copyright (C) 1999-2020 David Schweinsberg.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.steadystate.css.parser.selectors;

import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.PositionalCondition;

import com.steadystate.css.sac.ConditionFactoryExt;

/**
 *
 * @author <a href="mailto:davidsch@users.sourceforge.net">David Schweinsberg</a>
 * @author Ronald Brill
 */
public class ConditionFactoryImpl implements ConditionFactoryExt {

    @Override
    public CombinatorCondition createAndCondition(final Condition first, final Condition second) throws CSSException {
        return new AndConditionImpl(first, second);
    }

    @Override
    public CombinatorCondition createOrCondition(final Condition first, final Condition second) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    @Override
    public NegativeCondition createNegativeCondition(final Condition condition) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    @Override
    public PositionalCondition createPositionalCondition(
            final int position,
            final boolean typeNode,
            final boolean type) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    @Override
    public AttributeCondition createAttributeCondition(
            final String localName,
            final String namespaceURI,
            final boolean specified,
            final String value) throws CSSException {
        return new AttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createIdCondition(final String value) throws CSSException {
        return createIdCondition(value, null);
    }

    @Override
    public AttributeCondition createIdCondition(final String value, final Locator locator) throws CSSException {
        final IdConditionImpl cond = new IdConditionImpl(value);
        cond.setLocator(locator);
        return cond;
    }

    @Override
    public LangCondition createLangCondition(final String lang) throws CSSException {
        return createLangCondition(lang, null);
    }
    @Override
    public LangCondition createLangCondition(final String lang, final Locator locator) throws CSSException {
        final LangConditionImpl cond = new LangConditionImpl(lang);
        cond.setLocator(locator);
        return cond;
    }

    @Override
    public AttributeCondition createOneOfAttributeCondition(
            final String localName,
            final String namespaceURI,
            final boolean specified,
            final String value) throws CSSException {
        return new OneOfAttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createBeginHyphenAttributeCondition(
            final String localName,
            final String namespaceURI,
            final boolean specified,
            final String value) throws CSSException {
        return new BeginHyphenAttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createPrefixAttributeCondition(
            final String localName,
            final String namespaceURI,
            final boolean specified,
            final String value) throws CSSException {
        return new PrefixAttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createSuffixAttributeCondition(
            final String localName,
            final String namespaceURI,
            final boolean specified,
            final String value) throws CSSException {
        return new SuffixAttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createSubstringAttributeCondition(
            final String localName,
            final String namespaceURI,
            final boolean specified,
            final String value) throws CSSException {
        return new SubstringAttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createClassCondition(
            final String namespaceURI,
            final String value) throws CSSException {
        return createClassCondition(namespaceURI, value, null);
    }

    @Override
    public AttributeCondition createClassCondition(final String namespaceURI, final String value,
            final Locator locator) throws CSSException {
        final ClassConditionImpl cond = new ClassConditionImpl(value);
        cond.setLocator(locator);
        return cond;
    }

    @Override
    public AttributeCondition createPseudoClassCondition(
            final String namespaceURI,
            final String value) throws CSSException {
        return createPseudoClassCondition(namespaceURI, value, null, false);
    }

    @Override
    public AttributeCondition createPseudoClassCondition(final String namespaceURI, final String value,
            final Locator locator, final boolean doubleColon) throws CSSException {
        final PseudoClassConditionImpl cond = new PseudoClassConditionImpl(value);
        cond.setLocator(locator);
        if (doubleColon) {
            cond.prefixedWithDoubleColon();
        }
        return cond;
    }

    @Override
    public Condition createOnlyChildCondition() throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    @Override
    public Condition createOnlyTypeCondition() throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    @Override
    public ContentCondition createContentCondition(final String data)
        throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }
}
