#!/bin/sh
#
# Script to generate svn_revision.c
#

ECHO=/usr/bin/printf


SCRIPT_DIR=`dirname $0`
SRC_DIR=`dirname $SCRIPT_DIR`
CUR_DIR=`pwd`
C_FILE="$CUR_DIR/svn_revision.c"
H_FILE="$CUR_DIR/svn_revision.h"

# determine if this code base came from subversion.
if test -d $SRC_DIR/.svn  ; then
	echo "have subversion repository"
	SVNVERSION=`which svnversion`
	if test -x $SVNVERSION  ; then
		echo "have svnversion at $SVNVERSION"
		BUILD=`svnversion -n .`
		echo "This code base svn-revision: $BUILD"
		CAN_BUILD_SVN_REVISION="yes"
	fi
else 
    if test -d $SRC_DIR/../.git  ; then
	echo "have Git repository."
	BUILD=`/usr/bin/git log -1 --pretty=%h . `
	echo "This code base git-revision: $BUILD"
	CAN_BUILD_SVN_REVISION="yes"
    else
	if test -f $C_FILE; then
	    exit
	fi
    fi
fi

if [ "$CAN_BUILD_SVN_REVISION" = "yes" ] ; then

cat <<EOF > $C_FILE
/*
 * Subversion / GIT revision functions
 *
 * Autogenerated at make/release time
 *
 * Do not modify this file
 *
 */
 
const char *svn_revision (void)
{
	const char *SVN_Version = "$BUILD";
	return SVN_Version;
}
EOF

elif test ! -f $C_FILE  ; then

cat <<EOF > $C_FILE
/*
 * Subversion / GIT revision functions
 *
 * Autogenerated at make time
 *
 * There should have been one with your source distribution
 *
 * Do not modify this file
 *
 */
 
const char *svn_revision (void)
{
	const char *SVN_Version = "(unknown)";
	return SVN_Version;
}
EOF

fi
