{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAutoOffset: Boolean;
    procedure SetAutoOffset(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAutoOffset: TSFBool;
    { Internal wrapper for property @code(AutoOffset). This wrapper API may change, we advise to access simpler @code(AutoOffset) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAutoOffset: TSFBool read FFdAutoOffset;
    {  }
    property AutoOffset: Boolean read GetAutoOffset write SetAutoOffset;

    strict private FEventTrackPoint_changed: TSFVec3fEvent;
    {  }
    public property EventTrackPoint_changed: TSFVec3fEvent read FEventTrackPoint_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractDragSensorNode ----------------------------------------------- }

function TAbstractDragSensorNode.GetAutoOffset: Boolean;
begin
  Result := FdAutoOffset.Value;
end;

procedure TAbstractDragSensorNode.SetAutoOffset(const Value: Boolean);
begin
  FdAutoOffset.Send(Value);
end;

class function TAbstractDragSensorNode.ClassX3DType: String;
begin
  Result := 'X3DDragSensorNode';
end;

procedure TAbstractDragSensorNode.CreateNode;
begin
  inherited;

  FFdAutoOffset := TSFBool.Create(Self, True, 'autoOffset', true);
   FdAutoOffset.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAutoOffset);

  FEventTrackPoint_changed := TSFVec3fEvent.Create(Self, 'trackPoint_changed', false);
  AddEvent(FEventTrackPoint_changed);
end;

{$endif read_implementation}
