{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetHeadlight: Boolean;
    procedure SetHeadlight(const Value: Boolean);
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetTransitionTime: TFloatTime;
    procedure SetTransitionTime(const Value: TFloatTime);
    function GetVisibilityLimit: Single;
    procedure SetVisibilityLimit(const Value: Single);
    function GetBlendingSort: TShapeSort;
    procedure SetBlendingSort(const Value: TShapeSort);
    function GetTimeOriginAtLoad: Boolean;
    procedure SetTimeOriginAtLoad(const Value: Boolean);
    function GetHeadBobbing: Single;
    procedure SetHeadBobbing(const Value: Single);
    function GetHeadBobbingTime: Single;
    procedure SetHeadBobbingTime(const Value: Single);
    function GetHeadlightNode: TAbstractLightNode;
    procedure SetHeadlightNode(const Value: TAbstractLightNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAvatarSize: TMFFloat;
    { Internal wrapper for property @code(AvatarSize). This wrapper API may change, we advise to access simpler @code(AvatarSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAvatarSize: TMFFloat read FFdAvatarSize;
    {  }
    procedure SetAvatarSize(const Value: array of Single); overload;
    {  }
    procedure SetAvatarSize(const Value: TSingleList); overload;

    strict private FFdHeadlight: TSFBool;
    { Internal wrapper for property @code(Headlight). This wrapper API may change, we advise to access simpler @code(Headlight) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeadlight: TSFBool read FFdHeadlight;
    { Control the headlight. @deprecated Instead of this, control the headlight by placing light component (like TCastleDirectionalLight or TCastleSpotLight) as child of TCastleCamera. }
    property Headlight: Boolean read GetHeadlight write SetHeadlight;

    strict private FFdSpeed: TSFFloat;
    { Internal wrapper for property @code(Speed). This wrapper API may change, we advise to access simpler @code(Speed) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpeed: TSFFloat read FFdSpeed;
    { Movement speed. @deprecated Instead of this, control the move speed using @link(TCastleWalkNavigation.MoveSpeed). }
    property Speed: Single read GetSpeed write SetSpeed;

    strict private FFdTransitionTime: TSFTime;
    { Internal wrapper for property @code(TransitionTime). This wrapper API may change, we advise to access simpler @code(TransitionTime) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransitionTime: TSFTime read FFdTransitionTime;
    {  }
    property TransitionTime: TFloatTime read GetTransitionTime write SetTransitionTime;

    strict private FFdTransitionType: TMFString;
    { Internal wrapper for property @code(TransitionType). This wrapper API may change, we advise to access simpler @code(TransitionType) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransitionType: TMFString read FFdTransitionType;
    {  }
    procedure SetTransitionType(const Value: array of string); overload;
    {  }
    procedure SetTransitionType(const Value: TCastleStringList); overload;

    strict private FFdType: TMFString;
    { Internal wrapper for property @code(Type). This wrapper API may change, we advise to access simpler @code(Type) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdType: TMFString read FFdType;
    {  }
    procedure SetType(const Value: array of string); overload;
    {  }
    procedure SetType(const Value: TCastleStringList); overload;

    strict private FFdVisibilityLimit: TSFFloat;
    { Internal wrapper for property @code(VisibilityLimit). This wrapper API may change, we advise to access simpler @code(VisibilityLimit) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdVisibilityLimit: TSFFloat read FFdVisibilityLimit;
    {  }
    property VisibilityLimit: Single read GetVisibilityLimit write SetVisibilityLimit;

    strict private FEventTransitionComplete: TSFBoolEvent;
    {  }
    public property EventTransitionComplete: TSFBoolEvent read FEventTransitionComplete;

    strict private FFdBlendingSort: TSFStringEnum;
    { Internal wrapper for property @code(BlendingSort). This wrapper API may change, we advise to access simpler @code(BlendingSort) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBlendingSort: TSFStringEnum read FFdBlendingSort;
    { Best blending sort for this scene. It may be honored by some model viewers, e.g. castle-model-viewer honors this to display currently loaded scene.

      Note: In CGE applications, the blending sort is determined by @link(TCastleViewport.BlendingSort). It is up to each particular application if, and how, to honor this value on @className. In general, CGE applications may display multiple models (multiple TCastleScene) and there's not necessarily any scene that is "central" or "main", so most CGE applications will just ignore this, at least on most loaded models.

      If an application wants to honor this property of @className, then set @link(TCastleViewport.BlendingSort) based on the bound navigation info node. For example like this:

      @longCode(#
      if (Scene.NavigationInfoStack.Top <> nil) and
         (Scene.NavigationInfoStack.Top.BlendingSort <> sortAuto) then
        MainViewport.BlendingSort :=
          Scene.NavigationInfoStack.Top.BlendingSort;
      #)

      The value sortAuto (specified as string "AUTO" in X3D file)
      says to not change @link(TCastleViewport.BlendingSort).
      The @link(TCastleViewport.BlendingSort) may be, in turn, also sortAuto,
      which means that we will detect whether to use sort2D or sort3D depending
      on camera. }
    property BlendingSort: TShapeSort read GetBlendingSort write SetBlendingSort;

    strict private FFdTimeOriginAtLoad: TSFBool;
    { Internal wrapper for property @code(TimeOriginAtLoad). This wrapper API may change, we advise to access simpler @code(TimeOriginAtLoad) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTimeOriginAtLoad: TSFBool read FFdTimeOriginAtLoad;
    { @deprecated When this is @true, world time @link(TCastleSceneCore.Time) equals 0 when the scene is loaded. Otherwise (when this is @false, by default) world time 0 means "January 1, 1970" and when the scene is loaded the world time is a big number (and should only be processed as Double, not Single floating-point value). See https://castle-engine.io/x3d_time_origin_considered_uncomfortable.php for discussion. }
    property TimeOriginAtLoad: Boolean read GetTimeOriginAtLoad write SetTimeOriginAtLoad;

    strict private FFdHeadBobbing: TSFFloat;
    { Internal wrapper for property @code(HeadBobbing). This wrapper API may change, we advise to access simpler @code(HeadBobbing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeadBobbing: TSFFloat read FFdHeadBobbing;
    { Intensity of head bobbing. 0 means to not do head bobbing. Must be >= 0 and < 1, but sensible values are close to 0 (while any values < 1 are technically allowed, but they make the head bobbing effect crazily exaggerated). See https://castle-engine.io/x3d_implementation_navigation_extensions.php }
    property HeadBobbing: Single read GetHeadBobbing write SetHeadBobbing;

    strict private FFdHeadBobbingTime: TSFFloat;
    { Internal wrapper for property @code(HeadBobbingTime). This wrapper API may change, we advise to access simpler @code(HeadBobbingTime) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeadBobbingTime: TSFFloat read FFdHeadBobbingTime;
    { How much time passes to make full head bobbing sequence (camera swing up and then down back to original height). See https://castle-engine.io/x3d_implementation_navigation_extensions.php }
    property HeadBobbingTime: Single read GetHeadBobbingTime write SetHeadBobbingTime;

    strict private FFdHeadlightNode: TSFNode;
    { Internal wrapper for property @code(HeadlightNode). This wrapper API may change, we advise to access simpler @code(HeadlightNode) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeadlightNode: TSFNode read FFdHeadlightNode;
    { Headlight to shine, if @link(Headlight) is @true. See https://castle-engine.io/x3d_implementation_navigation_extensions.php }
    property HeadlightNode: TAbstractLightNode read GetHeadlightNode write SetHeadlightNode;

{$endif read_interface}

{$ifdef read_implementation}

{ TNavigationInfoNode ----------------------------------------------- }

procedure TNavigationInfoNode.SetAvatarSize(const Value: array of Single);
begin
  FdAvatarSize.Send(Value);
end;

procedure TNavigationInfoNode.SetAvatarSize(const Value: TSingleList);
begin
  FdAvatarSize.Send(Value);
end;

function TNavigationInfoNode.GetHeadlight: Boolean;
begin
  Result := FdHeadlight.Value;
end;

procedure TNavigationInfoNode.SetHeadlight(const Value: Boolean);
begin
  FdHeadlight.Send(Value);
end;

function TNavigationInfoNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TNavigationInfoNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TNavigationInfoNode.GetTransitionTime: TFloatTime;
begin
  Result := FdTransitionTime.Value;
end;

procedure TNavigationInfoNode.SetTransitionTime(const Value: TFloatTime);
begin
  FdTransitionTime.Send(Value);
end;

procedure TNavigationInfoNode.SetTransitionType(const Value: array of string);
begin
  FdTransitionType.Send(Value);
end;

procedure TNavigationInfoNode.SetTransitionType(const Value: TCastleStringList);
begin
  FdTransitionType.Send(Value);
end;

procedure TNavigationInfoNode.SetType(const Value: array of string);
begin
  FdType.Send(Value);
end;

procedure TNavigationInfoNode.SetType(const Value: TCastleStringList);
begin
  FdType.Send(Value);
end;

function TNavigationInfoNode.GetVisibilityLimit: Single;
begin
  Result := FdVisibilityLimit.Value;
end;

procedure TNavigationInfoNode.SetVisibilityLimit(const Value: Single);
begin
  FdVisibilityLimit.Send(Value);
end;

function TNavigationInfoNode.GetBlendingSort: TShapeSort;
begin
  Result := TShapeSort(FdBlendingSort.EnumValue);
end;

procedure TNavigationInfoNode.SetBlendingSort(const Value: TShapeSort);
begin
  FdBlendingSort.SendEnumValue(Ord(Value));
end;

function TNavigationInfoNode.GetTimeOriginAtLoad: Boolean;
begin
  Result := FdTimeOriginAtLoad.Value;
end;

procedure TNavigationInfoNode.SetTimeOriginAtLoad(const Value: Boolean);
begin
  FdTimeOriginAtLoad.Send(Value);
end;

function TNavigationInfoNode.GetHeadBobbing: Single;
begin
  Result := FdHeadBobbing.Value;
end;

procedure TNavigationInfoNode.SetHeadBobbing(const Value: Single);
begin
  FdHeadBobbing.Send(Value);
end;

function TNavigationInfoNode.GetHeadBobbingTime: Single;
begin
  Result := FdHeadBobbingTime.Value;
end;

procedure TNavigationInfoNode.SetHeadBobbingTime(const Value: Single);
begin
  FdHeadBobbingTime.Send(Value);
end;

function TNavigationInfoNode.GetHeadlightNode: TAbstractLightNode;
begin
  if FdHeadlightNode.Value is TAbstractLightNode then
    Result := TAbstractLightNode(FdHeadlightNode.Value)
  else
    Result := nil;
end;

procedure TNavigationInfoNode.SetHeadlightNode(const Value: TAbstractLightNode);
begin
  FdHeadlightNode.Send(Value);
end;

class function TNavigationInfoNode.ClassX3DType: String;
begin
  Result := 'NavigationInfo';
end;

procedure TNavigationInfoNode.CreateNode;
begin
  inherited;

  FFdAvatarSize := TMFFloat.Create(Self, True, 'avatarSize', [0.25, 1.6, 0.75]);
   FdAvatarSize.ChangeAlways := chNavigationInfo;
  AddField(FFdAvatarSize);

  FFdHeadlight := TSFBool.Create(Self, True, 'headlight', true);
   FdHeadlight.ChangeAlways := chHeadLightOn;
  AddField(FFdHeadlight);

  FFdSpeed := TSFFloat.Create(Self, True, 'speed', 1.0);
   FdSpeed.ChangeAlways := chNavigationInfo;
   FdSpeed.MustBeNonnegative := true;
  AddField(FFdSpeed);

  FFdTransitionTime := TSFTime.Create(Self, True, 'transitionTime', 1.0);
   FdTransitionTime.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransitionTime);

  FFdTransitionType := TMFString.Create(Self, True, 'transitionType', ['LINEAR']);
   FdTransitionType.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransitionType);

  FFdType := TMFString.Create(Self, True, 'type', ['EXAMINE', 'ANY']);
   FdType.ChangeAlways := chNavigationInfo;
  AddField(FFdType);

  FFdVisibilityLimit := TSFFloat.Create(Self, True, 'visibilityLimit', 0.0);
   FdVisibilityLimit.ChangeAlways := chVisibleNonGeometry;
   FdVisibilityLimit.MustBeNonnegative := true;
  AddField(FFdVisibilityLimit);

  FEventTransitionComplete := TSFBoolEvent.Create(Self, 'transitionComplete', false);
  AddEvent(FEventTransitionComplete);

  FFdBlendingSort := TSFStringEnum.Create(Self, True, 'blendingSort', @ShapeSortNames, Ord(High(ShapeSortNames)) + 1, Ord(sortAuto));
   FdBlendingSort.ChangeAlways := chRedisplay;
  AddField(FFdBlendingSort);

  FFdTimeOriginAtLoad := TSFBool.Create(Self, False, 'timeOriginAtLoad', false);
   FdTimeOriginAtLoad.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTimeOriginAtLoad);

  FFdHeadBobbing := TSFFloat.Create(Self, True, 'headBobbing', TCastleWalkNavigation.DefaultHeadBobbing);
   FdHeadBobbing.ChangeAlways := chNavigationInfo;
   FdHeadBobbing.MustBeNonnegative := true;
  AddField(FFdHeadBobbing);

  FFdHeadBobbingTime := TSFFloat.Create(Self, True, 'headBobbingTime', TCastleWalkNavigation.DefaultHeadBobbingTime);
   FdHeadBobbingTime.ChangeAlways := chNavigationInfo;
   FdHeadBobbingTime.MustBeNonnegative := true;
  AddField(FFdHeadBobbingTime);

  FFdHeadlightNode := TSFNode.Create(Self, True, 'headlightNode', [TAbstractLightNode]);
   FdHeadlightNode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHeadlightNode);
end;

{$endif read_implementation}
