{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAnchorPoint: TVector3;
    procedure SetAnchorPoint(const Value: TVector3);
    function GetAxis: TVector3;
    procedure SetAxis(const Value: TVector3);
    function GetMaxAngle: Single;
    procedure SetMaxAngle(const Value: Single);
    function GetMinAngle: Single;
    procedure SetMinAngle(const Value: Single);
    function GetStopBounce: Single;
    procedure SetStopBounce(const Value: Single);
    function GetStopErrorCorrection: Single;
    procedure SetStopErrorCorrection(const Value: Single);
  public
    property AnchorPoint: TVector3 read GetAnchorPoint write SetAnchorPoint;
    property Axis: TVector3 read GetAxis write SetAxis;
    property MaxAngle: Single read GetMaxAngle write SetMaxAngle;
    property MinAngle: Single read GetMinAngle write SetMinAngle;
    property StopBounce: Single read GetStopBounce write SetStopBounce;
    property StopErrorCorrection: Single read GetStopErrorCorrection write SetStopErrorCorrection;

{$endif read_interface}

{$ifdef read_implementation}

{ TSingleAxisHingeJointNode ----------------------------------------------- }

function TSingleAxisHingeJointNode.GetAnchorPoint: TVector3;
begin
  Result := FdAnchorPoint.Value;
end;

procedure TSingleAxisHingeJointNode.SetAnchorPoint(const Value: TVector3);
begin
  FdAnchorPoint.Send(Value);
end;

function TSingleAxisHingeJointNode.GetAxis: TVector3;
begin
  Result := FdAxis.Value;
end;

procedure TSingleAxisHingeJointNode.SetAxis(const Value: TVector3);
begin
  FdAxis.Send(Value);
end;

function TSingleAxisHingeJointNode.GetMaxAngle: Single;
begin
  Result := FdMaxAngle.Value;
end;

procedure TSingleAxisHingeJointNode.SetMaxAngle(const Value: Single);
begin
  FdMaxAngle.Send(Value);
end;

function TSingleAxisHingeJointNode.GetMinAngle: Single;
begin
  Result := FdMinAngle.Value;
end;

procedure TSingleAxisHingeJointNode.SetMinAngle(const Value: Single);
begin
  FdMinAngle.Send(Value);
end;

function TSingleAxisHingeJointNode.GetStopBounce: Single;
begin
  Result := FdStopBounce.Value;
end;

procedure TSingleAxisHingeJointNode.SetStopBounce(const Value: Single);
begin
  FdStopBounce.Send(Value);
end;

function TSingleAxisHingeJointNode.GetStopErrorCorrection: Single;
begin
  Result := FdStopErrorCorrection.Value;
end;

procedure TSingleAxisHingeJointNode.SetStopErrorCorrection(const Value: Single);
begin
  FdStopErrorCorrection.Send(Value);
end;

{$endif read_implementation}
