#!/usr/bin/env python3

import os
import sys
import subprocess

if len(sys.argv) < 3:
    print("usage: " + sys.argv[0] + " <program-name> <po directory>")
    sys.exit(1)

po_dir = sys.argv[-1]
prg_name = sys.argv[-2]

po_files = []
for dirpath, dirnames, filenames in os.walk(po_dir):
    for file in filenames:
        if file.split('.')[-1] == "po":
            po_files.append(os.path.join(dirpath, file))

for po in po_files:
    lang = po.split('/')[-1]
    print("Compiling for Locale: "+"".join(lang.split(".")[:-1]))
    lang = lang.split('-')[-1]
    lang = lang.split('.')[0]
    lang = lang.strip()
    if not lang:
        continue

    lang_lc_dir = os.path.join('share', 'locale', lang, 'LC_MESSAGES')
    if not os.path.isdir(lang_lc_dir):
        os.makedirs(lang_lc_dir)
    
    subprocess.check_call(["msgfmt", po, "-o", os.path.join(lang_lc_dir,prg_name+".mo")])
