//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Job/FitParameterLinkItem.cpp
//! @brief     Implements class FitParameterLinkItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Job/FitParameterLinkItem.h"
#include "GUI/Support/XML/UtilXML.h"

namespace {
namespace Tag {

const QString Link("Link");
const QString Title("Title");
const QString LinkItem("LinkItem");

} // namespace Tag
} // namespace


LinkItem::LinkItem(QObject* parent)
    : QObject(parent)
    , m_link("")
{
    setObjectName("Link");
}

void LinkItem::writeTo(QXmlStreamWriter* w) const
{
    XML::writeAttribute(w, XML::Attrib::version, uint(1));

    // link
    w->writeStartElement(Tag::Link);
    XML::writeAttribute(w, XML::Attrib::value, m_link);
    w->writeEndElement();
}

void LinkItem::readFrom(QXmlStreamReader* r)
{
    const uint version = XML::readUIntAttribute(r, XML::Attrib::version);
    Q_UNUSED(version)

    while (r->readNextStartElement()) {
        QString tag = r->name().toString();

        // link
        if (tag == Tag::Link) {
            XML::readAttribute(r, XML::Attrib::value, &m_link);
            XML::gotoEndElementOfTag(r, tag);

        } else
            r->skipCurrentElement();
    }
}

//------------------------------------------------------------------------------------------------

FitParameterLinkItem::FitParameterLinkItem(QObject* parent)
    : QObject(parent)
    , m_title("")
    , m_linkItem(new LinkItem(this))
{
    setObjectName("FitParameterLink");
}

void FitParameterLinkItem::writeTo(QXmlStreamWriter* w) const
{
    XML::writeAttribute(w, XML::Attrib::version, uint(1));

    // title
    w->writeStartElement(Tag::Title);
    XML::writeAttribute(w, XML::Attrib::value, m_title);
    w->writeEndElement();

    // link item
    w->writeStartElement(Tag::LinkItem);
    m_linkItem->writeTo(w);
    w->writeEndElement();
}

void FitParameterLinkItem::readFrom(QXmlStreamReader* r)
{
    const uint version = XML::readUIntAttribute(r, XML::Attrib::version);
    Q_UNUSED(version)

    while (r->readNextStartElement()) {
        QString tag = r->name().toString();

        // title
        if (tag == Tag::Title) {
            XML::readAttribute(r, XML::Attrib::value, &m_title);
            XML::gotoEndElementOfTag(r, tag);

            // link item
        } else if (tag == Tag::LinkItem) {
            m_linkItem->readFrom(r);
            XML::gotoEndElementOfTag(r, tag);

        } else
            r->skipCurrentElement();
    }
}
