;          MINMAXI.ASM                                          Agner Fog 2004

;  2004 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.model flat

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

; ********** MinI function **********
; C++ prototype:
; extern "C" int MinI (int a, int b);

; Returns the lowest of the signed integers a and b.

MinI PROC NEAR
PUBLIC MinI
PublicAlias _MinI               ; Underscore needed when called from Windows
        mov     eax, [esp+4]    ; a
        mov     ecx, [esp+8]    ; b
        sub     eax, ecx        ; a-b
        cdq                     ; -1 if b > a, 0 if b <= a
        and     eax, edx        ; a-b if b > a, 0 if b <= a
        add     eax, ecx        ; min(a,b)
        ret
MinI ENDP


; ********** MaxI function **********
; C++ prototype:
; extern "C" int MaxI (int a, int b);

; Returns the highest of the signed integers a and b.

MaxI PROC NEAR
PUBLIC MaxI
PublicAlias _MaxI               ; Underscore needed when called from Windows
        mov     eax, [esp+4]    ; a
        mov     ecx, [esp+8]    ; b
        sub     eax, ecx        ; a-b
        cdq                     ; -1 if b > a,   0 if b <= a
        not     edx             ; 0  if b > a,  -1 if b <= a
        and     eax, edx        ; 0  if b > a, a-b if b <= a
        add     eax, ecx        ; max(a,b)
        ret
MaxI ENDP

END
