#include "Bdef.h"
void sgupk_amx2(MatInf, buff)
MATINFO  *MatInf;
char  *buff;
{
   int m, n, lda, i, j;
   float *A, *v, diff;

   m = MatInf->M;
   n = MatInf->N;
   lda = MatInf->lda;
   A = (float *) MatInf->A;
   v = (float *) buff;

   if (m != 1)
   {
      for(j=n; j; j--)
      {
	 i = pvm_upkfloat(v, m, 1);
	 Mpvmerror(i, "pvm_upkfloat", __LINE__, __FILE__);
         for (i=0; i != m; i++)
         {
            diff = Rabs(A[i]) - Rabs(v[i]);
            if (diff < 0) A[i] = v[i];
            else if (diff == 0) if (A[i] < v[i]) A[i] = v[i];
         }
	 A += lda;
      }
   }
   else
   {
      i = pvm_upkfloat(v, n, 1);
      Mpvmerror(i, "pvm_upkfloat", __LINE__, __FILE__);
      for (i=j=0; j != n; j++, i += lda)
      {
         diff = Rabs(A[i]) - Rabs(v[j]);
         if (diff < 0) A[i] = v[j];
         else if (diff == 0) if (A[i] < v[j]) A[i] = v[j];
      }
   }
}
