/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "src/conf.y" /* yacc.c:339  */

/*
 * $Id: conf.y,v 1.26 2005/04/17 15:20:32 nohar Exp $
 *
 * This file is part of the bip proproject
 * Copyright (C) 2004 Arnaud Cornet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdlib.h>
#include "util.h"
#include "irc.h"
#include "tuple.h"
extern int yylex (void);
extern char *yytext;
extern int linec;

#define YYMALLOC bip_malloc

extern int yyerror(char *);

int yywrap()
{
	return 1;
}

//int yydebug = 1;

list_t *root_list;

struct tuple *tuple_i_new(int type, int i)
{
	struct tuple *t;
	t = bip_malloc(sizeof(struct tuple));
	t->type = type;
	t->ndata = i;
	t->tuple_type = TUPLE_INT;
	return t;
}

struct tuple *tuple_p_new(int type, void *p)
{
	struct tuple *t;
	t = bip_malloc(sizeof(struct tuple));
	t->type = type;
	t->pdata = p;
	return t;
}

struct tuple *tuple_s_new(int type, void *p)
{
	struct tuple *t = tuple_p_new(type, p);
	t->tuple_type = TUPLE_STR;
	return t;
}

struct tuple *tuple_l_new(int type, void *p)
{
	struct tuple *t = tuple_p_new(type, p);
	t->tuple_type = TUPLE_LIST;
	return t;
}


#line 136 "src/conf.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_SRC_CONF_H_INCLUDED
# define YY_YY_SRC_CONF_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    LEX_IP = 258,
    LEX_EQ = 259,
    LEX_PORT = 260,
    LEX_CSS = 261,
    LEX_SEMICOLON = 262,
    LEX_CONNECTION = 263,
    LEX_NETWORK = 264,
    LEX_LBRA = 265,
    LEX_RBRA = 266,
    LEX_USER = 267,
    LEX_NAME = 268,
    LEX_NICK = 269,
    LEX_SERVER = 270,
    LEX_PASSWORD = 271,
    LEX_SRCIP = 272,
    LEX_HOST = 273,
    LEX_VHOST = 274,
    LEX_SOURCE_PORT = 275,
    LEX_NONE = 276,
    LEX_COMMENT = 277,
    LEX_BUNCH = 278,
    LEX_REALNAME = 279,
    LEX_SSL = 280,
    LEX_SSL_CHECK_MODE = 281,
    LEX_SSL_CHECK_STORE = 282,
    LEX_SSL_CLIENT_CERTFILE = 283,
    LEX_CIPHERS = 284,
    LEX_CSS_CIPHERS = 285,
    LEX_DEFAULT_CIPHERS = 286,
    LEX_DH_PARAM = 287,
    LEX_CHANNEL = 288,
    LEX_KEY = 289,
    LEX_LOG_ROOT = 290,
    LEX_LOG_FORMAT = 291,
    LEX_LOG_LEVEL = 292,
    LEX_BACKLOG_LINES = 293,
    LEX_BACKLOG_NO_TIMESTAMP = 294,
    LEX_BACKLOG = 295,
    LEX_LOG = 296,
    LEX_LOG_SYSTEM = 297,
    LEX_LOG_SYNC_INTERVAL = 298,
    LEX_FOLLOW_NICK = 299,
    LEX_ON_CONNECT_SEND = 300,
    LEX_AWAY_NICK = 301,
    LEX_PID_FILE = 302,
    LEX_OIDENTD_FILE = 303,
    LEX_IGN_FIRST_NICK = 304,
    LEX_ALWAYS_BACKLOG = 305,
    LEX_BLRESET_ON_TALK = 306,
    LEX_BLRESET_CONNECTION = 307,
    LEX_DEFAULT_USER = 308,
    LEX_DEFAULT_NICK = 309,
    LEX_DEFAULT_REALNAME = 310,
    LEX_NO_CLIENT_AWAY_MSG = 311,
    LEX_BL_MSG_ONLY = 312,
    LEX_ADMIN = 313,
    LEX_BIP_USE_NOTICE = 314,
    LEX_CSS_PEM = 315,
    LEX_AUTOJOIN_ON_KICK = 316,
    LEX_IGNORE_CAPAB = 317,
    LEX_RECONN_TIMER = 318,
    LEX_BOOL = 319,
    LEX_INT = 320,
    LEX_STRING = 321
  };
#endif
/* Tokens.  */
#define LEX_IP 258
#define LEX_EQ 259
#define LEX_PORT 260
#define LEX_CSS 261
#define LEX_SEMICOLON 262
#define LEX_CONNECTION 263
#define LEX_NETWORK 264
#define LEX_LBRA 265
#define LEX_RBRA 266
#define LEX_USER 267
#define LEX_NAME 268
#define LEX_NICK 269
#define LEX_SERVER 270
#define LEX_PASSWORD 271
#define LEX_SRCIP 272
#define LEX_HOST 273
#define LEX_VHOST 274
#define LEX_SOURCE_PORT 275
#define LEX_NONE 276
#define LEX_COMMENT 277
#define LEX_BUNCH 278
#define LEX_REALNAME 279
#define LEX_SSL 280
#define LEX_SSL_CHECK_MODE 281
#define LEX_SSL_CHECK_STORE 282
#define LEX_SSL_CLIENT_CERTFILE 283
#define LEX_CIPHERS 284
#define LEX_CSS_CIPHERS 285
#define LEX_DEFAULT_CIPHERS 286
#define LEX_DH_PARAM 287
#define LEX_CHANNEL 288
#define LEX_KEY 289
#define LEX_LOG_ROOT 290
#define LEX_LOG_FORMAT 291
#define LEX_LOG_LEVEL 292
#define LEX_BACKLOG_LINES 293
#define LEX_BACKLOG_NO_TIMESTAMP 294
#define LEX_BACKLOG 295
#define LEX_LOG 296
#define LEX_LOG_SYSTEM 297
#define LEX_LOG_SYNC_INTERVAL 298
#define LEX_FOLLOW_NICK 299
#define LEX_ON_CONNECT_SEND 300
#define LEX_AWAY_NICK 301
#define LEX_PID_FILE 302
#define LEX_OIDENTD_FILE 303
#define LEX_IGN_FIRST_NICK 304
#define LEX_ALWAYS_BACKLOG 305
#define LEX_BLRESET_ON_TALK 306
#define LEX_BLRESET_CONNECTION 307
#define LEX_DEFAULT_USER 308
#define LEX_DEFAULT_NICK 309
#define LEX_DEFAULT_REALNAME 310
#define LEX_NO_CLIENT_AWAY_MSG 311
#define LEX_BL_MSG_ONLY 312
#define LEX_ADMIN 313
#define LEX_BIP_USE_NOTICE 314
#define LEX_CSS_PEM 315
#define LEX_AUTOJOIN_ON_KICK 316
#define LEX_IGNORE_CAPAB 317
#define LEX_RECONN_TIMER 318
#define LEX_BOOL 319
#define LEX_INT 320
#define LEX_STRING 321

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 73 "src/conf.y" /* yacc.c:355  */

	int number;
	char *string;
	void *list;
	struct tuple *tuple;

#line 315 "src/conf.c" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_SRC_CONF_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 332 "src/conf.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   220

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  67
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  13
/* YYNRULES -- Number of rules.  */
#define YYNRULES  82
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  227

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   321

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint8 yyrline[] =
{
       0,    88,    88,    89,    93,    94,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   109,   110,
     112,   115,   118,   119,   122,   125,   128,   130,   133,   134,
     137,   138,   139,   140,   144,   145,   148,   150,   152,   153,
     155,   157,   159,   161,   163,   165,   167,   170,   173,   174,
     177,   180,   183,   185,   189,   190,   194,   195,   197,   198,
     199,   200,   202,   204,   205,   207,   209,   211,   213,   215,
     217,   219,   221,   223,   226,   227,   230,   231,   232,   235,
     236,   239,   240
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "LEX_IP", "LEX_EQ", "LEX_PORT",
  "LEX_CSS", "LEX_SEMICOLON", "LEX_CONNECTION", "LEX_NETWORK", "LEX_LBRA",
  "LEX_RBRA", "LEX_USER", "LEX_NAME", "LEX_NICK", "LEX_SERVER",
  "LEX_PASSWORD", "LEX_SRCIP", "LEX_HOST", "LEX_VHOST", "LEX_SOURCE_PORT",
  "LEX_NONE", "LEX_COMMENT", "LEX_BUNCH", "LEX_REALNAME", "LEX_SSL",
  "LEX_SSL_CHECK_MODE", "LEX_SSL_CHECK_STORE", "LEX_SSL_CLIENT_CERTFILE",
  "LEX_CIPHERS", "LEX_CSS_CIPHERS", "LEX_DEFAULT_CIPHERS", "LEX_DH_PARAM",
  "LEX_CHANNEL", "LEX_KEY", "LEX_LOG_ROOT", "LEX_LOG_FORMAT",
  "LEX_LOG_LEVEL", "LEX_BACKLOG_LINES", "LEX_BACKLOG_NO_TIMESTAMP",
  "LEX_BACKLOG", "LEX_LOG", "LEX_LOG_SYSTEM", "LEX_LOG_SYNC_INTERVAL",
  "LEX_FOLLOW_NICK", "LEX_ON_CONNECT_SEND", "LEX_AWAY_NICK",
  "LEX_PID_FILE", "LEX_OIDENTD_FILE", "LEX_IGN_FIRST_NICK",
  "LEX_ALWAYS_BACKLOG", "LEX_BLRESET_ON_TALK", "LEX_BLRESET_CONNECTION",
  "LEX_DEFAULT_USER", "LEX_DEFAULT_NICK", "LEX_DEFAULT_REALNAME",
  "LEX_NO_CLIENT_AWAY_MSG", "LEX_BL_MSG_ONLY", "LEX_ADMIN",
  "LEX_BIP_USE_NOTICE", "LEX_CSS_PEM", "LEX_AUTOJOIN_ON_KICK",
  "LEX_IGNORE_CAPAB", "LEX_RECONN_TIMER", "LEX_BOOL", "LEX_INT",
  "LEX_STRING", "$accept", "commands", "command", "network", "net_command",
  "user", "usr_command", "connection", "con_command", "channel",
  "cha_command", "server", "ser_command", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321
};
# endif

#define YYPACT_NINF -51

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-51)))

#define YYTABLE_NINF -1

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -51,     0,   -51,    -2,     6,     7,    -6,     3,    14,    16,
      17,    18,    20,    22,    23,    24,    30,    40,    41,    45,
      49,    50,    51,    52,    54,    55,    57,     1,   -50,     5,
      10,   -51,   -51,     2,     9,    15,    19,    25,    11,    13,
      29,    32,    36,    37,    38,    42,    44,    47,    48,    56,
      58,    39,   -51,   -51,   -51,   -51,     4,    79,   -51,   -51,
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,    67,    70,
      78,    80,    76,   103,   -51,    84,    85,   112,   117,   118,
     119,   121,   122,   123,   124,   131,   135,   136,   137,   138,
     139,   140,   141,    81,   -51,    82,    83,   -51,   -51,    86,
      87,    88,    89,    90,    92,    94,    95,    96,    97,    98,
      99,   100,   101,   104,   105,   106,   -51,   -51,    -4,   -51,
     -51,    53,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   146,
     -51,   147,   156,   160,   -51,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   182,
     183,   184,   185,   114,   125,   -51,   127,   128,   129,   130,
     132,   133,   142,   134,   143,   -51,   126,   144,   145,   148,
     149,   150,   151,   153,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,   -51,   -51,    12,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,   -51,   -51,   193,   197,   198,   196,
     152,   154,   155,   -51,   -51,   -51,   -51
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       2,     0,     1,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    28,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     8,     9,    10,     0,     0,    12,    13,
      14,     4,     5,     6,    20,    21,    22,    15,    16,    17,
      18,    19,    25,    23,    24,    11,     7,    26,     0,     0,
       0,     0,     0,     0,    27,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    79,     0,     0,    29,    54,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    30,     0,    31,
      32,     0,    36,    37,    40,    41,    42,    46,    47,    48,
      52,    49,    50,    43,    44,    45,    51,    38,    39,     0,
      33,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    74,     0,     0,     0,     0,
       0,     0,     0,     0,    55,    82,    81,    57,    60,    56,
      59,    62,    63,    64,    61,    73,     0,    58,    66,    71,
      65,    67,    72,    68,    69,    70,     0,     0,     0,     0,
       0,     0,     0,    75,    76,    77,    78
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,    27,    56,    82,    57,   102,   131,   172,   206,
     219,   128,   152
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
       2,   149,    28,     3,    31,     4,     5,   150,    52,     6,
      29,    30,     7,    32,   151,    77,    53,    78,    33,    79,
      34,    35,    36,   215,    37,   216,    38,    39,    40,    80,
       8,     9,    10,    81,    41,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    42,    43,   217,    20,    21,    44,
      22,    23,   218,    45,    46,    47,    48,    24,    49,    50,
      25,    51,   153,    26,   154,   155,   156,   157,    58,   158,
      54,   103,   159,   160,    55,    59,    63,   161,    64,   162,
     104,    60,   105,   107,   106,    61,   163,    83,   109,   110,
      84,    62,    85,    65,   164,    86,    66,   165,   166,   167,
      67,    68,   168,    69,    76,    87,    88,    89,    70,   169,
      71,    72,    73,   108,   170,   171,   111,    90,    91,    92,
      74,   112,   113,   114,    75,   115,   116,   117,   118,    93,
      94,    95,    96,    97,    98,   119,    99,   100,   101,   120,
     121,   122,   123,   124,   125,     0,   129,   127,   126,   130,
     173,   174,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   175,   176,   143,   144,   145,   146,   147,
     148,   177,   178,   179,   180,   181,   182,   183,   184,   195,
     186,   187,   188,   189,   190,   185,   191,   192,   193,     0,
     207,   196,   194,   197,   198,   199,   200,   220,   201,   202,
     204,   221,   222,   223,     0,     0,     0,   203,   208,   205,
       0,   209,     0,   211,   210,   213,   212,   214,   224,   226,
     225
};

static const yytype_int8 yycheck[] =
{
       0,     5,     4,     3,    10,     5,     6,    11,     7,     9,
       4,     4,    12,    10,    18,    11,    66,    13,     4,    15,
       4,     4,     4,    11,     4,    13,     4,     4,     4,    25,
      30,    31,    32,    29,     4,    35,    36,    37,    38,    39,
      40,    41,    42,    43,     4,     4,    34,    47,    48,     4,
      50,    51,    40,     4,     4,     4,     4,    57,     4,     4,
      60,     4,     9,    63,    11,    12,    13,    14,    66,    16,
      65,     4,    19,    20,    64,    66,    65,    24,    65,    26,
      10,    66,     4,     7,     4,    66,    33,     8,     4,     4,
      11,    66,    13,    64,    41,    16,    64,    44,    45,    46,
      64,    64,    49,    65,    65,    26,    27,    28,    66,    56,
      66,    64,    64,    10,    61,    62,     4,    38,    39,    40,
      64,     4,     4,     4,    66,     4,     4,     4,     4,    50,
      51,    52,    53,    54,    55,     4,    57,    58,    59,     4,
       4,     4,     4,     4,     4,    -1,    64,    66,     7,    66,
       4,     4,    66,    66,    66,    66,    66,    65,    64,    64,
      64,    64,    64,     7,     4,    66,    66,    66,    64,    64,
      64,     4,     4,     4,     4,     4,     4,     4,     4,    65,
       4,     4,     4,     4,     4,    10,     4,     4,     4,    -1,
      64,    66,     7,    66,    66,    66,    66,     4,    66,    66,
      66,     4,     4,     7,    -1,    -1,    -1,    65,    64,    66,
      -1,    66,    -1,    64,    66,    64,    66,    64,    66,    64,
      66
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    68,     0,     3,     5,     6,     9,    12,    30,    31,
      32,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      47,    48,    50,    51,    57,    60,    63,    69,     4,     4,
       4,    10,    10,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     7,    66,    65,    64,    70,    72,    66,    66,
      66,    66,    66,    65,    65,    64,    64,    64,    64,    65,
      66,    66,    64,    64,    64,    66,    65,    11,    13,    15,
      25,    29,    71,     8,    11,    13,    16,    26,    27,    28,
      38,    39,    40,    50,    51,    52,    53,    54,    55,    57,
      58,    59,    73,     4,    10,     4,     4,     7,    10,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     7,    66,    78,    64,
      66,    74,    66,    66,    66,    66,    66,    65,    64,    64,
      64,    64,    64,    66,    66,    66,    64,    64,    64,     5,
      11,    18,    79,     9,    11,    12,    13,    14,    16,    19,
      20,    24,    26,    33,    41,    44,    45,    46,    49,    56,
      61,    62,    75,     4,     4,     7,     4,     4,     4,     4,
       4,     4,     4,     4,     4,    10,     4,     4,     4,     4,
       4,     4,     4,     4,     7,    65,    66,    66,    66,    66,
      66,    66,    66,    65,    66,    66,    76,    64,    64,    66,
      66,    64,    66,    64,    64,    11,    13,    34,    40,    77,
       4,     4,     4,     7,    66,    66,    64
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    67,    68,    68,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    70,    70,
      71,    71,    71,    71,    72,    72,    73,    73,    73,    73,
      73,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    73,    73,    73,    74,    74,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    76,    76,    77,    77,    77,    78,
      78,    79,    79
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     4,     0,     3,
       3,     3,     3,     4,     0,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     4,     0,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       4,     3,     3,     3,     0,     3,     3,     3,     3,     0,
       3,     3,     3
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 88 "src/conf.y" /* yacc.c:1646  */
    { (yyval.list) = root_list = list_new(NULL); }
#line 1564 "src/conf.c" /* yacc.c:1646  */
    break;

  case 3:
#line 89 "src/conf.y" /* yacc.c:1646  */
    { list_add_last((yyvsp[-2].list), (yyvsp[-1].tuple)); (yyval.list) = (yyvsp[-2].list); }
#line 1570 "src/conf.c" /* yacc.c:1646  */
    break;

  case 4:
#line 93 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_LOG_ROOT, (yyvsp[0].string)); }
#line 1576 "src/conf.c" /* yacc.c:1646  */
    break;

  case 5:
#line 94 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_LOG_FORMAT,
						(yyvsp[0].string)); }
#line 1583 "src/conf.c" /* yacc.c:1646  */
    break;

  case 6:
#line 96 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_LOG_LEVEL, (yyvsp[0].number)); }
#line 1589 "src/conf.c" /* yacc.c:1646  */
    break;

  case 7:
#line 97 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_RECONN_TIMER, (yyvsp[0].number)); }
#line 1595 "src/conf.c" /* yacc.c:1646  */
    break;

  case 8:
#line 98 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_IP, (yyvsp[0].string)); }
#line 1601 "src/conf.c" /* yacc.c:1646  */
    break;

  case 9:
#line 99 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_PORT, (yyvsp[0].number)); }
#line 1607 "src/conf.c" /* yacc.c:1646  */
    break;

  case 10:
#line 100 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_CSS, (yyvsp[0].number)); }
#line 1613 "src/conf.c" /* yacc.c:1646  */
    break;

  case 11:
#line 101 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_CSS_PEM, (yyvsp[0].string)); }
#line 1619 "src/conf.c" /* yacc.c:1646  */
    break;

  case 12:
#line 102 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_CSS_CIPHERS, (yyvsp[0].string)); }
#line 1625 "src/conf.c" /* yacc.c:1646  */
    break;

  case 13:
#line 103 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_DEFAULT_CIPHERS, (yyvsp[0].string)); }
#line 1631 "src/conf.c" /* yacc.c:1646  */
    break;

  case 14:
#line 104 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_DH_PARAM, (yyvsp[0].string)); }
#line 1637 "src/conf.c" /* yacc.c:1646  */
    break;

  case 15:
#line 105 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_LOG, (yyvsp[0].number)); }
#line 1643 "src/conf.c" /* yacc.c:1646  */
    break;

  case 16:
#line 106 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_LOG_SYSTEM, (yyvsp[0].number)); }
#line 1649 "src/conf.c" /* yacc.c:1646  */
    break;

  case 17:
#line 107 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(
						LEX_LOG_SYNC_INTERVAL, (yyvsp[0].number)); }
#line 1656 "src/conf.c" /* yacc.c:1646  */
    break;

  case 18:
#line 109 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_PID_FILE, (yyvsp[0].string)); }
#line 1662 "src/conf.c" /* yacc.c:1646  */
    break;

  case 19:
#line 110 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_OIDENTD_FILE, (yyvsp[0].string)); }
#line 1668 "src/conf.c" /* yacc.c:1646  */
    break;

  case 20:
#line 112 "src/conf.y" /* yacc.c:1646  */
    {
	           (yyval.tuple) = tuple_i_new(LEX_BACKLOG_LINES, (yyvsp[0].number));
		  }
#line 1676 "src/conf.c" /* yacc.c:1646  */
    break;

  case 21:
#line 115 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BACKLOG_NO_TIMESTAMP, (yyvsp[0].number));
	       }
#line 1684 "src/conf.c" /* yacc.c:1646  */
    break;

  case 22:
#line 118 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_BACKLOG, (yyvsp[0].number)); }
#line 1690 "src/conf.c" /* yacc.c:1646  */
    break;

  case 23:
#line 119 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BLRESET_ON_TALK, (yyvsp[0].number));
	       }
#line 1698 "src/conf.c" /* yacc.c:1646  */
    break;

  case 24:
#line 122 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BL_MSG_ONLY, (yyvsp[0].number));
	       }
#line 1706 "src/conf.c" /* yacc.c:1646  */
    break;

  case 25:
#line 125 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(
						LEX_ALWAYS_BACKLOG, (yyvsp[0].number)); }
#line 1713 "src/conf.c" /* yacc.c:1646  */
    break;

  case 26:
#line 128 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_l_new(LEX_NETWORK,
						(yyvsp[-1].list)); }
#line 1720 "src/conf.c" /* yacc.c:1646  */
    break;

  case 27:
#line 130 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_l_new(LEX_USER, (yyvsp[-1].list)); }
#line 1726 "src/conf.c" /* yacc.c:1646  */
    break;

  case 28:
#line 133 "src/conf.y" /* yacc.c:1646  */
    { (yyval.list) = list_new(NULL); }
#line 1732 "src/conf.c" /* yacc.c:1646  */
    break;

  case 29:
#line 134 "src/conf.y" /* yacc.c:1646  */
    { list_add_last((yyvsp[-2].list), (yyvsp[-1].tuple)); (yyval.list) = (yyvsp[-2].list); }
#line 1738 "src/conf.c" /* yacc.c:1646  */
    break;

  case 30:
#line 137 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_NAME, (yyvsp[0].string)); }
#line 1744 "src/conf.c" /* yacc.c:1646  */
    break;

  case 31:
#line 138 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_SSL, (yyvsp[0].number)); }
#line 1750 "src/conf.c" /* yacc.c:1646  */
    break;

  case 32:
#line 139 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_CIPHERS, (yyvsp[0].string)); }
#line 1756 "src/conf.c" /* yacc.c:1646  */
    break;

  case 33:
#line 140 "src/conf.y" /* yacc.c:1646  */
    {
			(yyval.tuple) = tuple_l_new(LEX_SERVER, (yyvsp[-1].list)); }
#line 1763 "src/conf.c" /* yacc.c:1646  */
    break;

  case 34:
#line 144 "src/conf.y" /* yacc.c:1646  */
    { (yyval.list) = list_new(NULL); }
#line 1769 "src/conf.c" /* yacc.c:1646  */
    break;

  case 35:
#line 145 "src/conf.y" /* yacc.c:1646  */
    { list_add_last((yyvsp[-2].list), (yyvsp[-1].tuple)); (yyval.list) = (yyvsp[-2].list); }
#line 1775 "src/conf.c" /* yacc.c:1646  */
    break;

  case 36:
#line 148 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_s_new(LEX_NAME, (yyvsp[0].string)); }
#line 1782 "src/conf.c" /* yacc.c:1646  */
    break;

  case 37:
#line 150 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_PASSWORD,
		(yyvsp[0].string)); }
#line 1789 "src/conf.c" /* yacc.c:1646  */
    break;

  case 38:
#line 152 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_ADMIN, (yyvsp[0].number)); }
#line 1795 "src/conf.c" /* yacc.c:1646  */
    break;

  case 39:
#line 153 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_i_new(LEX_BIP_USE_NOTICE, (yyvsp[0].number)); }
#line 1802 "src/conf.c" /* yacc.c:1646  */
    break;

  case 40:
#line 155 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(
			LEX_SSL_CHECK_MODE, (yyvsp[0].string)); }
#line 1809 "src/conf.c" /* yacc.c:1646  */
    break;

  case 41:
#line 157 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(
			LEX_SSL_CHECK_STORE, (yyvsp[0].string)); }
#line 1816 "src/conf.c" /* yacc.c:1646  */
    break;

  case 42:
#line 159 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(
			LEX_SSL_CLIENT_CERTFILE, (yyvsp[0].string)); }
#line 1823 "src/conf.c" /* yacc.c:1646  */
    break;

  case 43:
#line 161 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_s_new(LEX_DEFAULT_USER, (yyvsp[0].string)); }
#line 1830 "src/conf.c" /* yacc.c:1646  */
    break;

  case 44:
#line 163 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_s_new(LEX_DEFAULT_NICK, (yyvsp[0].string)); }
#line 1837 "src/conf.c" /* yacc.c:1646  */
    break;

  case 45:
#line 165 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_s_new(LEX_DEFAULT_REALNAME, (yyvsp[0].string)); }
#line 1844 "src/conf.c" /* yacc.c:1646  */
    break;

  case 46:
#line 167 "src/conf.y" /* yacc.c:1646  */
    {
	           (yyval.tuple) = tuple_i_new(LEX_BACKLOG_LINES, (yyvsp[0].number));
		  }
#line 1852 "src/conf.c" /* yacc.c:1646  */
    break;

  case 47:
#line 170 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BACKLOG_NO_TIMESTAMP, (yyvsp[0].number));
	       }
#line 1860 "src/conf.c" /* yacc.c:1646  */
    break;

  case 48:
#line 173 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_BACKLOG, (yyvsp[0].number)); }
#line 1866 "src/conf.c" /* yacc.c:1646  */
    break;

  case 49:
#line 174 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BLRESET_ON_TALK, (yyvsp[0].number));
	       }
#line 1874 "src/conf.c" /* yacc.c:1646  */
    break;

  case 50:
#line 177 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BLRESET_CONNECTION, (yyvsp[0].number));
	       }
#line 1882 "src/conf.c" /* yacc.c:1646  */
    break;

  case 51:
#line 180 "src/conf.y" /* yacc.c:1646  */
    {
	       (yyval.tuple) = tuple_i_new(LEX_BL_MSG_ONLY, (yyvsp[0].number));
	       }
#line 1890 "src/conf.c" /* yacc.c:1646  */
    break;

  case 52:
#line 183 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(
						LEX_ALWAYS_BACKLOG, (yyvsp[0].number)); }
#line 1897 "src/conf.c" /* yacc.c:1646  */
    break;

  case 53:
#line 185 "src/conf.y" /* yacc.c:1646  */
    {
				 (yyval.tuple) = tuple_l_new(LEX_CONNECTION, (yyvsp[-1].list)); }
#line 1904 "src/conf.c" /* yacc.c:1646  */
    break;

  case 54:
#line 189 "src/conf.y" /* yacc.c:1646  */
    { (yyval.list) = list_new(NULL); }
#line 1910 "src/conf.c" /* yacc.c:1646  */
    break;

  case 55:
#line 190 "src/conf.y" /* yacc.c:1646  */
    {
	       list_add_last((yyvsp[-2].list), (yyvsp[-1].tuple)); (yyval.list) = (yyvsp[-2].list); }
#line 1917 "src/conf.c" /* yacc.c:1646  */
    break;

  case 56:
#line 194 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_NAME, (yyvsp[0].string)); }
#line 1923 "src/conf.c" /* yacc.c:1646  */
    break;

  case 57:
#line 195 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_NETWORK,
			 (yyvsp[0].string)); }
#line 1930 "src/conf.c" /* yacc.c:1646  */
    break;

  case 58:
#line 197 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_LOG, (yyvsp[0].number)); }
#line 1936 "src/conf.c" /* yacc.c:1646  */
    break;

  case 59:
#line 198 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_NICK, (yyvsp[0].string)); }
#line 1942 "src/conf.c" /* yacc.c:1646  */
    break;

  case 60:
#line 199 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_USER, (yyvsp[0].string)); }
#line 1948 "src/conf.c" /* yacc.c:1646  */
    break;

  case 61:
#line 200 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_REALNAME,
		 (yyvsp[0].string)); }
#line 1955 "src/conf.c" /* yacc.c:1646  */
    break;

  case 62:
#line 202 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_PASSWORD,
		 (yyvsp[0].string)); }
#line 1962 "src/conf.c" /* yacc.c:1646  */
    break;

  case 63:
#line 204 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_VHOST, (yyvsp[0].string)); }
#line 1968 "src/conf.c" /* yacc.c:1646  */
    break;

  case 64:
#line 205 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_i_new(LEX_SOURCE_PORT, (yyvsp[0].number)); }
#line 1975 "src/conf.c" /* yacc.c:1646  */
    break;

  case 65:
#line 207 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_AWAY_NICK,
						(yyvsp[0].string)); }
#line 1982 "src/conf.c" /* yacc.c:1646  */
    break;

  case 66:
#line 209 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_i_new(LEX_FOLLOW_NICK, (yyvsp[0].number)); }
#line 1989 "src/conf.c" /* yacc.c:1646  */
    break;

  case 67:
#line 211 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(
					   LEX_IGN_FIRST_NICK, (yyvsp[0].number)); }
#line 1996 "src/conf.c" /* yacc.c:1646  */
    break;

  case 68:
#line 213 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_i_new(LEX_AUTOJOIN_ON_KICK, (yyvsp[0].number)); }
#line 2003 "src/conf.c" /* yacc.c:1646  */
    break;

  case 69:
#line 215 "src/conf.y" /* yacc.c:1646  */
    {
		   (yyval.tuple) = tuple_i_new(LEX_IGNORE_CAPAB, (yyvsp[0].number)); }
#line 2010 "src/conf.c" /* yacc.c:1646  */
    break;

  case 70:
#line 217 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_l_new(
						LEX_CHANNEL, (yyvsp[-1].list)); }
#line 2017 "src/conf.c" /* yacc.c:1646  */
    break;

  case 71:
#line 219 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(
						LEX_ON_CONNECT_SEND, (yyvsp[0].string)); }
#line 2024 "src/conf.c" /* yacc.c:1646  */
    break;

  case 72:
#line 221 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(
						LEX_NO_CLIENT_AWAY_MSG, (yyvsp[0].string)); }
#line 2031 "src/conf.c" /* yacc.c:1646  */
    break;

  case 73:
#line 223 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(
			LEX_SSL_CHECK_MODE, (yyvsp[0].string)); }
#line 2038 "src/conf.c" /* yacc.c:1646  */
    break;

  case 74:
#line 226 "src/conf.y" /* yacc.c:1646  */
    { (yyval.list) = list_new(NULL); }
#line 2044 "src/conf.c" /* yacc.c:1646  */
    break;

  case 75:
#line 227 "src/conf.y" /* yacc.c:1646  */
    { list_add_last((yyvsp[-2].list), (yyvsp[-1].tuple)); (yyval.list) = (yyvsp[-2].list); }
#line 2050 "src/conf.c" /* yacc.c:1646  */
    break;

  case 76:
#line 230 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_NAME, (yyvsp[0].string)); }
#line 2056 "src/conf.c" /* yacc.c:1646  */
    break;

  case 77:
#line 231 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_KEY, (yyvsp[0].string)); }
#line 2062 "src/conf.c" /* yacc.c:1646  */
    break;

  case 78:
#line 232 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_BACKLOG, (yyvsp[0].number)); }
#line 2068 "src/conf.c" /* yacc.c:1646  */
    break;

  case 79:
#line 235 "src/conf.y" /* yacc.c:1646  */
    { (yyval.list) = list_new(NULL); }
#line 2074 "src/conf.c" /* yacc.c:1646  */
    break;

  case 80:
#line 236 "src/conf.y" /* yacc.c:1646  */
    { list_add_last((yyvsp[-2].list), (yyvsp[-1].tuple)); (yyval.list) = (yyvsp[-2].list); }
#line 2080 "src/conf.c" /* yacc.c:1646  */
    break;

  case 81:
#line 239 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_s_new(LEX_HOST, (yyvsp[0].string)); }
#line 2086 "src/conf.c" /* yacc.c:1646  */
    break;

  case 82:
#line 240 "src/conf.y" /* yacc.c:1646  */
    { (yyval.tuple) = tuple_i_new(LEX_PORT, (yyvsp[0].number)); }
#line 2092 "src/conf.c" /* yacc.c:1646  */
    break;


#line 2096 "src/conf.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
