
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesource.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsesource.hh>
#include <bse/bseundostack.hh>
#include <bse/bseieee754.hh>
#include <bse/bsemidievent.hh>
#include "bsecxxplugin.hh"
/* --- set-input-by-id --- */
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 11 "bsesource.proc"
 {
#line 13 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 25 "bsesource.proc"
 }
static BseErrorType
#line 25 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 28 "bsesource.proc"
{
#line 29 "bsesource.proc"
  
  BseSource *isource = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = (BseSource*) bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error;
#line 35 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 39 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
#line 43 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- set-input --- */
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 47 "bsesource.proc"
 {
#line 49 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 61 "bsesource.proc"
 }
static BseErrorType
#line 61 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 64 "bsesource.proc"
{
#line 65 "bsesource.proc"
  
  BseSource *isource = (BseSource*) bse_value_get_object (in_values++);
  const char *ichannel_ident = sfi_value_get_string (in_values++);
  BseSource *osource = (BseSource*) bse_value_get_object (in_values++);
  const char *ochannel_ident = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error;
#line 72 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel_ident || !ochannel_ident)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 77 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_ident);
  ochannel = bse_source_find_ochannel (osource, ochannel_ident);
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
#line 83 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- unset-input-by-id --- */
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 87 "bsesource.proc"
 {
#line 89 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 101 "bsesource.proc"
 }
static BseErrorType
#line 101 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 104 "bsesource.proc"
{
#line 105 "bsesource.proc"
  
  BseSource *isource = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = (BseSource*) bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 111 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 114 "bsesource.proc"
  
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }
#line 124 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- unset-input --- */
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 128 "bsesource.proc"
 {
#line 130 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 142 "bsesource.proc"
 }
static BseErrorType
#line 142 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 145 "bsesource.proc"
{
#line 146 "bsesource.proc"
  
  BseSource *isource = (BseSource*) bse_value_get_object (in_values++);
  const char *ichannel_ident = sfi_value_get_string (in_values++);
  BseSource *osource = (BseSource*) bse_value_get_object (in_values++);
  const char *ochannel_ident = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error = BSE_ERROR_NONE;
#line 153 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      !ichannel_ident || !ochannel_ident)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 157 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_ident);
  ochannel = bse_source_find_ochannel (osource, ochannel_ident);
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }
#line 169 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- clear-inputs --- */
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 173 "bsesource.proc"
 {
#line 175 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 178 "bsesource.proc"
 }
static BseErrorType
#line 178 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 181 "bsesource.proc"
{
#line 182 "bsesource.proc"
  
  BseSource *isource = (BseSource*) bse_value_get_object (in_values++);
  BseUndoStack *ustack;
#line 185 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 188 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-inputs %s", bse_object_debug_name (isource));
  bse_source_backup_ichannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-inputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ichannels (isource);
  return BSE_ERROR_NONE;
}
/* --- clear-outputs --- */
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 196 "bsesource.proc"
 {
#line 198 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 201 "bsesource.proc"
 }
static BseErrorType
#line 201 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 204 "bsesource.proc"
{
#line 205 "bsesource.proc"
  
  BseSource *isource = (BseSource*) bse_value_get_object (in_values++);
  BseUndoStack *ustack;
#line 208 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 211 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-outputs %s", bse_object_debug_name (isource));
  bse_source_backup_ochannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-outputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ochannels (isource);
  return BSE_ERROR_NONE;
}
/* --- has-output --- */
static void
has_output_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 219 "bsesource.proc"
 {
#line 221 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", NULL, NULL, BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("ochannel", NULL, NULL, 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", NULL, NULL, FALSE, SFI_PARAM_STANDARD);
}
#line 225 "bsesource.proc"
 }
static BseErrorType
#line 225 "bsesource.proc"
has_output_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 228 "bsesource.proc"
{
#line 229 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
#line 232 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 235 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, bse_source_has_output (source, ochannel));
  return BSE_ERROR_NONE;
}
/* --- has-outputs --- */
static void
has_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 239 "bsesource.proc"
 {
#line 241 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", "Has Outputs", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 246 "bsesource.proc"
 }
static BseErrorType
#line 246 "bsesource.proc"
has_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 249 "bsesource.proc"
{
#line 250 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
#line 252 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 255 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, source->outputs != NULL);
  return BSE_ERROR_NONE;
}
/* --- n-ichannels --- */
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 259 "bsesource.proc"
 {
#line 261 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 266 "bsesource.proc"
 }
static BseErrorType
#line 266 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 269 "bsesource.proc"
{
#line 270 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
#line 272 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 275 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  return BSE_ERROR_NONE;
}
/* --- ichannel-label --- */
static void
ichannel_label_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 279 "bsesource.proc"
 {
#line 281 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_label", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 288 "bsesource.proc"
 }
static BseErrorType
#line 288 "bsesource.proc"
ichannel_label_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 291 "bsesource.proc"
{
#line 292 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
#line 295 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 298 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_LABEL (source, ichannel));
  return BSE_ERROR_NONE;
}
/* --- ichannel-ident --- */
static void
ichannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 302 "bsesource.proc"
 {
#line 304 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_ident", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 311 "bsesource.proc"
 }
static BseErrorType
#line 311 "bsesource.proc"
ichannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 314 "bsesource.proc"
{
#line 315 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
#line 318 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 321 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_IDENT (source, ichannel));
  return BSE_ERROR_NONE;
}
/* --- ichannel-blurb --- */
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 325 "bsesource.proc"
 {
#line 327 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 334 "bsesource.proc"
 }
static BseErrorType
#line 334 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 337 "bsesource.proc"
{
#line 338 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
#line 341 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 344 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  return BSE_ERROR_NONE;
}
/* --- is-joint-ichannel-by-id --- */
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 348 "bsesource.proc"
 {
#line 350 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 357 "bsesource.proc"
 }
static BseErrorType
#line 357 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 360 "bsesource.proc"
{
#line 361 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
#line 364 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 367 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  return BSE_ERROR_NONE;
}
/* --- is-joint-ichannel --- */
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 371 "bsesource.proc"
 {
#line 373 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 380 "bsesource.proc"
 }
static BseErrorType
#line 380 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 383 "bsesource.proc"
{
#line 384 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  const char *ichannel   = sfi_value_get_string (in_values++);
  guint id;
#line 388 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 391 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  sfi_value_set_bool (out_values++,
		      id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  return BSE_ERROR_NONE;
}
/* --- ichannel-get-n-joints --- */
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 397 "bsesource.proc"
 {
#line 399 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_joints", "Number of Connections", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 406 "bsesource.proc"
 }
static BseErrorType
#line 406 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 409 "bsesource.proc"
{
#line 410 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  BseSourceInput *input;
#line 414 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 417 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    sfi_value_set_int (out_values++, input->jdata.n_joints);
  else
    sfi_value_set_int (out_values++, input->idata.osource ? 1 : 0);
  return BSE_ERROR_NONE;
}
/* --- ichannel-get-osource --- */
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 425 "bsesource.proc"
 {
#line 427 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("osource", "Output Source", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 436 "bsesource.proc"
 }
static BseErrorType
#line 436 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 439 "bsesource.proc"
{
#line 440 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
#line 445 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 448 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    bse_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    bse_value_set_object (out_values++, input->idata.osource);
  else
    bse_value_set_object (out_values++, NULL);
  return BSE_ERROR_NONE;
}
/* --- ichannel-get-ochannel --- */
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 458 "bsesource.proc"
 {
#line 460 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("ochannel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 469 "bsesource.proc"
 }
static BseErrorType
#line 469 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 472 "bsesource.proc"
{
#line 473 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
#line 478 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 481 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    sfi_value_set_int (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    sfi_value_set_int (out_values++, input->idata.ochannel);
  else
    sfi_value_set_int (out_values++, G_MAXINT);
  return BSE_ERROR_NONE;
}
/* --- n-ochannels --- */
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 491 "bsesource.proc"
 {
#line 493 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 498 "bsesource.proc"
 }
static BseErrorType
#line 498 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 501 "bsesource.proc"
{
#line 502 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
#line 504 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 507 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  return BSE_ERROR_NONE;
}
/* --- ochannel-label --- */
static void
ochannel_label_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 511 "bsesource.proc"
 {
#line 513 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_label", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 520 "bsesource.proc"
 }
static BseErrorType
#line 520 "bsesource.proc"
ochannel_label_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 523 "bsesource.proc"
{
#line 524 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
#line 527 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 530 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_LABEL (source, ochannel));
  return BSE_ERROR_NONE;
}
/* --- ochannel-ident --- */
static void
ochannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 534 "bsesource.proc"
 {
#line 536 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_ident", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 543 "bsesource.proc"
 }
static BseErrorType
#line 543 "bsesource.proc"
ochannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 546 "bsesource.proc"
{
#line 547 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
#line 550 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 553 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_IDENT (source, ochannel));
  return BSE_ERROR_NONE;
}
/* --- ochannel-blurb --- */
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 557 "bsesource.proc"
 {
#line 559 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 566 "bsesource.proc"
 }
static BseErrorType
#line 566 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 569 "bsesource.proc"
{
#line 570 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
#line 573 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 576 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  return BSE_ERROR_NONE;
}
/* --- set-pos --- */
static void
set_pos_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 580 "bsesource.proc"
 {
#line 587 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("x-pos", "X Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("y-pos", "Y Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
}
#line 594 "bsesource.proc"
 }
static BseErrorType
#line 594 "bsesource.proc"
set_pos_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 597 "bsesource.proc"
{
#line 598 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  SfiReal xpos      = sfi_value_get_real (in_values++);
  SfiReal ypos      = sfi_value_get_real (in_values++);
  SfiReal epsilon = 1e-5;
#line 603 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || BSE_DOUBLE_IS_NANINF (xpos) || BSE_DOUBLE_IS_NANINF (ypos))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 606 "bsesource.proc"
  
  if (fabs (xpos - source->pos_x) > epsilon ||
      fabs (ypos - source->pos_y) > epsilon)
    {
      BseUndoStack *ustack = bse_item_undo_open (source, "set-xy-pos");
      bse_item_set (source,
                    "pos_x", xpos,
                    "pos_y", ypos,
                    NULL);
      bse_item_undo_close (ustack);
    }
  return BSE_ERROR_NONE;
}
/* --- set-automation --- */
static void
set_automation_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 619 "bsesource.proc"
 {
#line 621 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("midi_channel", _("MIDI Channel"), _("The MIDI Channel from which automation events should be received, 0 designates the default MIDI channel"),
                         0, 0, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD ":scale:unprepared");
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", _("Control Type"), _("The type of control events used for automation"),
                                BSE_TYPE_MIDI_CONTROL_TYPE, BSE_MIDI_CONTROL_CONTINUOUS_16, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL, BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 631 "bsesource.proc"
 }
static BseErrorType
#line 631 "bsesource.proc"
set_automation_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 634 "bsesource.proc"
{
#line 635 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  const char *property = sfi_value_get_string (in_values++);
  guint      midi_channel = sfi_value_get_int (in_values++);
  BseMidiSignalType control_type = (BseMidiSignalType) g_value_get_enum (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
#line 641 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 644 "bsesource.proc"
  
  guint old_midi_channel = 0;
  BseMidiSignalType old_control_type = BseMidiSignalType (0);
  bse_source_get_automation_property (source, property, &old_midi_channel, &old_control_type);
  if (old_midi_channel != midi_channel || old_control_type != control_type)
    {
      error = bse_source_set_automation_property (source, property, midi_channel, control_type);
      if (error == BSE_ERROR_NONE)
        bse_item_push_undo_proc (source, "set-automation", property, old_midi_channel, old_control_type);
    }
#line 654 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- get-automation-channel --- */
static void
get_automation_channel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 658 "bsesource.proc"
 {
#line 660 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("midi_channel", NULL, NULL, 0, 0, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD ":scale:unprepared");
}
#line 666 "bsesource.proc"
 }
static BseErrorType
#line 666 "bsesource.proc"
get_automation_channel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 669 "bsesource.proc"
{
#line 670 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  const char *property = sfi_value_get_string (in_values++);
#line 673 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 676 "bsesource.proc"
  
  guint midi_channel = 0;
  bse_source_get_automation_property (source, property, &midi_channel, NULL);
#line 679 "bsesource.proc"
  
  g_value_set_int (out_values++, midi_channel);
  return BSE_ERROR_NONE;
}
/* --- get-automation-control --- */
static void
get_automation_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 683 "bsesource.proc"
 {
#line 685 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("control_type", NULL, NULL, BSE_TYPE_MIDI_CONTROL_TYPE, BSE_MIDI_CONTROL_CONTINUOUS_16, SFI_PARAM_STANDARD);
}
#line 691 "bsesource.proc"
 }
static BseErrorType
#line 691 "bsesource.proc"
get_automation_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 694 "bsesource.proc"
{
#line 695 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
  const char *property = sfi_value_get_string (in_values++);
#line 698 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 701 "bsesource.proc"
  
  BseMidiSignalType control_type = BseMidiSignalType (0);
  bse_source_get_automation_property (source, property, NULL, &control_type);
#line 704 "bsesource.proc"
  
  g_value_set_enum (out_values++, control_type);
  return BSE_ERROR_NONE;
}
/* --- is-prepared --- */
static void
is_prepared_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 708 "bsesource.proc"
 {
#line 710 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_prepared", NULL, NULL, FALSE, SFI_PARAM_STANDARD);
#line 713 "bsesource.proc"
}  }
static BseErrorType
#line 713 "bsesource.proc"
is_prepared_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 716 "bsesource.proc"
{
#line 717 "bsesource.proc"
  
  BseSource *source = (BseSource*) bse_value_get_object (in_values++);
#line 719 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 722 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_PREPARED (source));
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_set_input_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Connect a module input to another module's output.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 12;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_input_by_id = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Set Input By Id",
    NULL,
    __enode_set_input_by_id__fill_strings,
  },
  0, set_input_by_id_setup, set_input_by_id_exec, 
};
static void
__enode_set_input__fill_strings (BseExportStrings *es)
{
  es->blurb = "Connect a module input to another module's output.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 48;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_input = {
  { (BseExportNode*) &__enode_set_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input", 
    NULL,
    "/Methods/BseSource/General/Set Input",
    NULL,
    __enode_set_input__fill_strings,
  },
  0, set_input_setup, set_input_exec, 
};
static void
__enode_unset_input_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect a module input.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 88;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_unset_input_by_id = {
  { (BseExportNode*) &__enode_set_input, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Unset Input By Id",
    NULL,
    __enode_unset_input_by_id__fill_strings,
  },
  0, unset_input_by_id_setup, unset_input_by_id_exec, 
};
static void
__enode_unset_input__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect a module input.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 129;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_unset_input = {
  { (BseExportNode*) &__enode_unset_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input", 
    NULL,
    "/Methods/BseSource/General/Unset Input",
    NULL,
    __enode_unset_input__fill_strings,
  },
  0, unset_input_setup, unset_input_exec, 
};
static void
__enode_clear_inputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect all module inputs.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 174;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_clear_inputs = {
  { (BseExportNode*) &__enode_unset_input, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-inputs", 
    NULL,
    "/Methods/BseSource/General/Clear Inputs",
    NULL,
    __enode_clear_inputs__fill_strings,
  },
  0, clear_inputs_setup, clear_inputs_exec, 
};
static void
__enode_clear_outputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect all module outputs.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 197;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_clear_outputs = {
  { (BseExportNode*) &__enode_clear_inputs, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-outputs", 
    NULL,
    "/Methods/BseSource/General/Clear Outputs",
    NULL,
    __enode_clear_outputs__fill_strings,
  },
  0, clear_outputs_setup, clear_outputs_exec, 
};
static void
__enode_has_output__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a module's output channel is connected.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 220;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_has_output = {
  { (BseExportNode*) &__enode_clear_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+has-output", 
    NULL,
    "/Methods/BseSource/General/Has Output",
    NULL,
    __enode_has_output__fill_strings,
  },
  0, has_output_setup, has_output_exec, 
};
static void
__enode_has_outputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a module has output channel connections.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 240;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_has_outputs = {
  { (BseExportNode*) &__enode_has_output, BSE_EXPORT_NODE_PROC,
    "BseSource+has-outputs", 
    NULL,
    "/Methods/BseSource/General/Has Outputs",
    NULL,
    __enode_has_outputs__fill_strings,
  },
  0, has_outputs_setup, has_outputs_exec, 
};
static void
__enode_n_ichannels__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of input channels of a module.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 260;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_ichannels = {
  { (BseExportNode*) &__enode_has_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ichannels", 
    NULL,
    "/Methods/BseSource/General/N Ichannels",
    NULL,
    __enode_n_ichannels__fill_strings,
  },
  0, n_ichannels_setup, n_ichannels_exec, 
};
static void
__enode_ichannel_label__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get input channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 280;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_label = {
  { (BseExportNode*) &__enode_n_ichannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-label", 
    NULL,
    "/Methods/BseSource/General/Ichannel Label",
    NULL,
    __enode_ichannel_label__fill_strings,
  },
  0, ichannel_label_setup, ichannel_label_exec, 
};
static void
__enode_ichannel_ident__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get canonical input channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 303;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_ident = {
  { (BseExportNode*) &__enode_ichannel_label, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ichannel Ident",
    NULL,
    __enode_ichannel_ident__fill_strings,
  },
  0, ichannel_ident_setup, ichannel_ident_exec, 
};
static void
__enode_ichannel_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get input channel description.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 326;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_blurb = {
  { (BseExportNode*) &__enode_ichannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ichannel Blurb",
    NULL,
    __enode_ichannel_blurb__fill_strings,
  },
  0, ichannel_blurb_setup, ichannel_blurb_exec, 
};
static void
__enode_is_joint_ichannel_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check if an input channel is a joint (multi-connect) channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 349;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_joint_ichannel_by_id = {
  { (BseExportNode*) &__enode_ichannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel-by-id", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel By Id",
    NULL,
    __enode_is_joint_ichannel_by_id__fill_strings,
  },
  0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, 
};
static void
__enode_is_joint_ichannel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check if an input channel is a joint (multi-connect) channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 372;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_joint_ichannel = {
  { (BseExportNode*) &__enode_is_joint_ichannel_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel",
    NULL,
    __enode_is_joint_ichannel__fill_strings,
  },
  0, is_joint_ichannel_setup, is_joint_ichannel_exec, 
};
static void
__enode_ichannel_get_n_joints__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the number of inputs connected to an input channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 398;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_n_joints = {
  { (BseExportNode*) &__enode_is_joint_ichannel, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-n-joints", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get N Joints",
    NULL,
    __enode_ichannel_get_n_joints__fill_strings,
  },
  0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, 
};
static void
__enode_ichannel_get_osource__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve output module connected to a specific joint of an input channel";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 426;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_osource = {
  { (BseExportNode*) &__enode_ichannel_get_n_joints, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-osource", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Osource",
    NULL,
    __enode_ichannel_get_osource__fill_strings,
  },
  0, ichannel_get_osource_setup, ichannel_get_osource_exec, 
};
static void
__enode_ichannel_get_ochannel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve output channel of the module connected to a specific joint of an input channel.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 459;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_ochannel = {
  { (BseExportNode*) &__enode_ichannel_get_osource, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-ochannel", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Ochannel",
    NULL,
    __enode_ichannel_get_ochannel__fill_strings,
  },
  0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, 
};
static void
__enode_n_ochannels__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of output channels of a module.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 492;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_ochannels = {
  { (BseExportNode*) &__enode_ichannel_get_ochannel, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ochannels", 
    NULL,
    "/Methods/BseSource/General/N Ochannels",
    NULL,
    __enode_n_ochannels__fill_strings,
  },
  0, n_ochannels_setup, n_ochannels_exec, 
};
static void
__enode_ochannel_label__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get output channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 512;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_label = {
  { (BseExportNode*) &__enode_n_ochannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-label", 
    NULL,
    "/Methods/BseSource/General/Ochannel Label",
    NULL,
    __enode_ochannel_label__fill_strings,
  },
  0, ochannel_label_setup, ochannel_label_exec, 
};
static void
__enode_ochannel_ident__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get canonical output channel name.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 535;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_ident = {
  { (BseExportNode*) &__enode_ochannel_label, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ochannel Ident",
    NULL,
    __enode_ochannel_ident__fill_strings,
  },
  0, ochannel_ident_setup, ochannel_ident_exec, 
};
static void
__enode_ochannel_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get output channel description.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 558;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_blurb = {
  { (BseExportNode*) &__enode_ochannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ochannel Blurb",
    NULL,
    __enode_ochannel_blurb__fill_strings,
  },
  0, ochannel_blurb_setup, ochannel_blurb_exec, 
};
static void
__enode_set_pos__fill_strings (BseExportStrings *es)
{
  es->blurb = "Set the x and y position of a module. In contrast to setting the position "
          "through ordinary object property setters, this function will not update "
          "the module position if the passed in arguments are sufficiently equal to "
          "the values already set on the object. As such, it does not record an extra "
          "undo step for setting properties to values they already have and if necessary "
          "turns setting of x and y positions into an atomic undo operation.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 581;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_pos = {
  { (BseExportNode*) &__enode_ochannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+set-pos", 
    NULL,
    "/Methods/BseSource/General/Set Pos",
    NULL,
    __enode_set_pos__fill_strings,
  },
  0, set_pos_setup, set_pos_exec, 
};
static void
__enode_set_automation__fill_strings (BseExportStrings *es)
{
  es->blurb = "Setup automation parameters for a property.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 620;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_automation = {
  { (BseExportNode*) &__enode_set_pos, BSE_EXPORT_NODE_PROC,
    "BseSource+set-automation", 
    NULL,
    "/Methods/BseSource/General/Set Automation",
    NULL,
    __enode_set_automation__fill_strings,
  },
  0, set_automation_setup, set_automation_exec, 
};
static void
__enode_get_automation_channel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get MIDI channel from an automation property.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 659;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_automation_channel = {
  { (BseExportNode*) &__enode_set_automation, BSE_EXPORT_NODE_PROC,
    "BseSource+get-automation-channel", 
    NULL,
    "/Methods/BseSource/General/Get Automation Channel",
    NULL,
    __enode_get_automation_channel__fill_strings,
  },
  0, get_automation_channel_setup, get_automation_channel_exec, 
};
static void
__enode_get_automation_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get control type from an automation property.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 684;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_automation_control = {
  { (BseExportNode*) &__enode_get_automation_channel, BSE_EXPORT_NODE_PROC,
    "BseSource+get-automation-control", 
    NULL,
    "/Methods/BseSource/General/Get Automation Control",
    NULL,
    __enode_get_automation_control__fill_strings,
  },
  0, get_automation_control_setup, get_automation_control_exec, 
};
static void
__enode_is_prepared__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a source is prepared for synthesis processing.";
  es->file = "/opt/src/beast/bse/bsesource.proc";
  es->line = 709;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_prepared = {
  { (BseExportNode*) &__enode_get_automation_control, BSE_EXPORT_NODE_PROC,
    "BseSource+is-prepared", 
    NULL,
    "/Methods/BseSource/General/Is Prepared",
    NULL,
    __enode_is_prepared__fill_strings,
  },
  0, is_prepared_setup, is_prepared_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsesource_genprc_cc (void)
{
  return (BseExportNode*) &__enode_is_prepared;
}

/*
 * Generated data ends here
 */
