#!/usr/bin/perl

use strict;
use warnings;

use Benchmark qw(:all);


my $file = '/var/log/syslog';

cmpthese(-1, {
	      'PerlIO' =>
	      sub {
		  open(my $fh, '<', $file) || die $1;
		  while (<$fh>) {
		      /^t/;
		  }
	      },

	      'Pragma mmap' =>
	      sub {
		  use open IO => ':mmap';
		  open(my $fh, '<', $file) || die $1;
		  while (<$fh>) {
		      /^t/;
		  }
	      },

	      'Pragma mmap repeat' =>
	      sub {
		  use open IO => 'mmap';
		  open(my $fh, '<', $file) || die $1;
#		  print "$_\n" foreach PerlIO::get_layers($fh);
		  while (<$fh>) {
		      /^t/;
		  }
	      },

	      'mmap' =>
	      sub {
		  open(my $fh, '<:mmap', $file) || die $1;
#		  print "$_\n" foreach PerlIO::get_layers($fh);
		  while (<$fh>) {
		      /^t/;
		  }
	      },

	      'PerlIO repeat' =>
	      sub {
		  open(my $fh, '<', $file) || die $1;
#		  print "$_\n" foreach PerlIO::get_layers($fh);
		  while (<$fh>) {
		      /^t/;
		  }
	      },

	     });
