//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2008 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//


#if !defined(_KADUSETTINGS_H)
#define _KADUSETTINGS_H

#include "Types.h"

class CRemoteSettings;
class CamuleApp;

class CKADUSettings
/*!
 * brief CKADUSettings class used to manage KADU constant values
 */
{
	friend class CRemoteSettings;
	friend class CamuleAppCommon /*CamuleApp*/ ;

	/*
	 * OCCHIO: dichiarare statc const valori di default e usarli per il costruttore di default!
	 *
	 * Se lo scopo della CRemoteSettings e' solo scaricare da remoto il file e scivere alla fine
	 * i valori nel file di testo allora mi sa che NON serve avere "fissa" una CRemoteSettings
	 * (propongo la sua eliminazione, almeno x quello che riguarda la gestione con memoria dinamica)
	 *
	 * I valori di KADU in realta' servono:
	 * - nell'applicazione principale (ereditata da CamuleApp)
	 * - nei thread vari
	 *
	 * Verificare se non sia meglio usare una GLOBALE CKADUSettings (e, ovviamente, arbitrare gli accessi a questa classe)
	 *
	 * DUE POSSIBILITA':
	 * 1) una copia all'interno di camuleApp con accesso arbitrato SOLO nei metodi che sincronizzano con il rmoto
	 * 2) una sola copia (la globale) con semaforo per regolare OGNI accesso (mi sa pero' che questo non e'eff.)
	 *
	 * OCCHIO: sarebbe bello un meccanismo di sincronizzazione che facesse si' che NON PARTONO i vari thread fino a
	 * che non ho terminato di leggere il file / ho aggiornato la CKADUSettings
	 *
	 */ 

	private:
			
		long          m_kadRepublishTimeK;
		long          m_kadRepublishTimeS;
		long          m_kadRepublishTimeN;

		long          m_kadIndexLifeK; // Mr Hyde per allineamento a eMule 3.15b74
		long          m_kadIndexLifeS; // Mr Hyde per allineamento a eMule 3.15b74

		uint32_t      m_kadTotalStoreKey;   // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h
		uint32_t      m_kadTotalStoreSrc;   // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h
		uint32_t      m_kadTotalStoreNotes; // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h

		long          m_kadTotalSearchFile;

		long          m_kadMaxSrcFile;
		long          m_kadMaxNotFile;

		double        m_kadFreshGuess_Tol;
		double        m_kadFreshGuess_Weight;
		long          m_kadFreshGuess_NoNorm;
		long          m_kadFreshGuess_LowNorm;

		long          m_kadFindValue;
		long          m_kadStore;
		long          m_kadFindNode;

		long          m_kadReaskTime;
		long          m_kadPubTime;

		long          m_kadReaskIncs;

		long          m_mVer;

		unsigned char m_kadOpcode;
		unsigned char m_kadZOpcode;

	public:
		void assign(
				long          kadRepublishTimeK,
				long          kadRepublishTimeS,
				long          kadRepublishTimeN,

				long          kadIndexLifeK,
				long          kadIndexLifeS,

				uint32_t      kadTotalStoreKey,
				uint32_t      kadTotalStoreSrc,
				uint32_t      kadTotalStoreNotes,

				long          kadTotalSearchFile,

				long          kadMaxSrcFile,
				long          kadMaxNotFile,

				double        kadFreshGuess_Tol,
				double        kadFreshGuess_Weight,
				long          kadFreshGuess_NoNorm,
				long          kadFreshGuess_LowNorm,

				long          kadFindValue,
				long          kadStore,
				long          kadFindNode,

				long          kadReaskTime,
				long          kadPubTime,

				long          kadReaskIncs,

				long          mVer,

				unsigned char kadOpcode,
				unsigned char kadZOpcode
			   );

		CKADUSettings(); // questo mi sa che lo tolgo...

		CKADUSettings(
				long          kadRepublishTimeK,
				long          kadRepublishTimeS,
				long          kadRepublishTimeN,

				long          kadIndexLifeK,
				long          kadIndexLifeS,

				uint32_t      kadTotalStoreKey,
				uint32_t      kadTotalStoreSrc,
				uint32_t      kadTotalStoreNotes,

				long          kadTotalSearchFile,

				long          kadMaxSrcFile,
				long          kadMaxNotFile,

				double        kadFreshGuess_Tol,
				double        kadFreshGuess_Weight,
				long          kadFreshGuess_NoNorm,
				long          kadFreshGuess_LowNorm,

				long          kadFindValue,
				long          kadStore,
				long          kadFindNode,

				long          kadReaskTime,
				long          kadPubTime,

				long          kadReaskIncs,

				long          mVer,

				unsigned char kadOpcode,
				unsigned char kadZOpcode
			     )
		{
			assign(kadRepublishTimeK,
				kadRepublishTimeS,
				kadRepublishTimeN,
				kadIndexLifeK,
				kadIndexLifeS,
				kadTotalStoreKey,
				kadTotalStoreSrc,
				kadTotalStoreNotes,
				kadTotalSearchFile,
				kadMaxSrcFile,
				kadMaxNotFile,
				kadFreshGuess_Tol,
				kadFreshGuess_Weight,
				kadFreshGuess_NoNorm,
				kadFreshGuess_LowNorm,
				kadFindValue,
				kadStore,
				kadFindNode,
				kadReaskTime,
				kadPubTime,
				kadReaskIncs,
				mVer,
				kadOpcode,
				kadZOpcode
			      );
		}

		virtual ~CKADUSettings() {};

		void assign(const CKADUSettings& k)
		{
			assign(k.m_kadRepublishTimeK,
				k.m_kadRepublishTimeS,
				k.m_kadRepublishTimeN,
				k.m_kadIndexLifeK,
				k.m_kadIndexLifeS,
				k.m_kadTotalStoreKey,
				k.m_kadTotalStoreSrc,
				k.m_kadTotalStoreNotes,
				k.m_kadTotalSearchFile,
				k.m_kadMaxSrcFile,
				k.m_kadMaxNotFile,
				k.m_kadFreshGuess_Tol,
				k.m_kadFreshGuess_Weight,
				k.m_kadFreshGuess_NoNorm,
				k.m_kadFreshGuess_LowNorm,
				k.m_kadFindValue,
				k.m_kadStore,
				k.m_kadFindNode,
				k.m_kadReaskTime,
				k.m_kadPubTime,
				k.m_kadReaskIncs,
				k.m_mVer,
				k.m_kadOpcode,
				k.m_kadZOpcode
			      );
		}

		CKADUSettings(const CKADUSettings& k) {assign(k);}

		CKADUSettings operator=(const CKADUSettings& k)
		{
			if (this != &k) assign(k);
			return *this;
		}

		inline long          get_kadRepublishTimeK() const {return m_kadRepublishTimeK;}
		inline long          get_kadRepublishTimeS() const {return m_kadRepublishTimeS;}
		inline long          get_kadRepublishTimeN() const {return m_kadRepublishTimeN;}

		inline long          get_kadIndexLifeK() const {return m_kadIndexLifeK;}
		inline long          get_kadIndexLifeS() const {return m_kadIndexLifeS;}

		inline uint32_t      get_kadTotalStoreKey()   const {return m_kadTotalStoreKey;}
		inline uint32_t      get_kadTotalStoreSrc()   const {return m_kadTotalStoreSrc;}
		inline uint32_t      get_kadTotalStoreNotes() const {return m_kadTotalStoreNotes;}

		inline long          get_kadTotalSearchFile() const {return m_kadTotalSearchFile;}

		inline long          get_kadMaxSrcFile() const {return m_kadMaxSrcFile;}
		inline long          get_kadMaxNotFile() const {return m_kadMaxNotFile;}

		inline double        get_kadFreshGuess_Tol()     const {return m_kadFreshGuess_Tol;}
		inline double        get_kadFreshGuess_Weight()  const {return m_kadFreshGuess_Weight;}
		inline long          get_kadFreshGuess_NoNorm()  const {return m_kadFreshGuess_NoNorm;}
		inline long          get_kadFreshGuess_LowNorm() const {return m_kadFreshGuess_LowNorm;}

		inline long          get_kadFindValue() const {return m_kadFindValue;}
		inline long          get_kadStore()     const {return m_kadStore;}
		inline long          get_kadFindNode()  const {return m_kadFindNode;}

		inline long          get_kadReaskTime() const {return m_kadReaskTime;}
		inline long          get_kadPubTime()   const {return m_kadPubTime;}

		inline long          get_kadReaskIncs() const {return m_kadReaskIncs;}

		inline long          get_mVer() const {return m_mVer;}

		inline unsigned char get_kadOpcode()  const {return m_kadOpcode;}
		inline unsigned char get_kadZOpcode() const {return m_kadZOpcode;}

};

#endif

