(require 'cl)


(defun save-lemmas ()
  (with-temp-file (concat *home-dir* "lemmas.txt") (insert (format "%s" lemmas)))
  )




(defun print-list (list)
  (do ((temp list (cdr temp))
       (temp2 ""))
      ((endp temp) (subseq temp2 0 (1- (length temp2))))
    (setf temp2 (concat temp2 (format "%s;" (car temp))) )))


(defun last-part-of-lists (list)
  (do ((temp list (cdr temp))
       (temp2 nil))
      ((endp temp) temp2)
      (setf temp2 (append temp2 (list (cadar temp))))))

(defun print-lemmas-format ()
  (do ((temp (last-part-of-lists lemma-vectors) (cdr temp))
	 (temp2 ""))
	((endp temp) temp2)
    (setf temp2 (concat temp2 
			(format "%s\n"
				(print-list (car temp)))))))


(defun extract-features-to-file ()
  
  (extract-recursive-beg-to-end)
  (convert-recursive)
  (with-temp-file (concat *home-dir* "output.csv") (insert (format "%s" (print-lemmas-format))))
  )


(defun add-libraryname-to-lemmas (name)
  (do ((temp lemmas (cdr temp))
       (temp2 nil))
      ((endp temp) temp2)
    (setf temp2 (append temp2 
			(list 
			 (append (list(car (read-from-string (format "%s::%s" name (caar temp)))))
			       (cdr (car temp))))))))



(defun add-libraryname-to-definitions (name)
  (do ((temp definitions (cdr temp))
       (temp2 nil))
      ((endp temp) temp2)
    (setf temp2 (append temp2 
			(list 
			 (append (list(car (read-from-string (format "%s::%s" name (caar temp)))))
			       (cdr (car temp))))))))


(defun add-libraryname-to-deps (name)
  (do ((temp lemma-dependencies (cdr temp))
       (temp2 nil))
      ((endp temp) temp2)
    (setf temp2 (append temp2 
			(list 
			 (append (list(car (read-from-string (format "%s::%s" name (caar temp)))))
			       (cdr (car temp)))))))
  )


(defun export-library ()
  
  (setf lemmas nil)
  (setf lemmaanalogy? t)
  (extract-recursive-beg-to-end2)
  (let* ((buf (buffer-name))
	 (name (if (search "." buf) (subseq buf 0 (search "." buf)) buf)))
    (with-temp-file (concat *home-dir* "/libs/" name) 
      (insert (format "%s" (add-libraryname-to-lemmas name))))
    (with-temp-file (concat *home-dir* "/definitions/" name) 
      (insert (format "%s" (add-libraryname-to-definitions name))))
    (with-temp-file (concat *home-dir* "/guards/" name) 
      (insert (format "%s" (nested-lists-to-string acl2guards))))
    
    )
  (setf lemmaanalogy? nil)
  t)



(defvar imported-libraries nil)


(defun import-library (name)
  (with-temp-buffer
  (insert-file-contents (concat *home-dir* "/libs/" name))
  (car (read-from-string (format "%s" (read (current-buffer)))))
  ))

(defun import-deps (name)
  (with-temp-buffer
  (insert-file-contents (concat *home-dir* "/dependencies/" name))
  (car (read-from-string (format "%s" (read (current-buffer)))))
  ))


(defun import-definitions (name)
  (with-temp-buffer
  (insert-file-contents (concat *home-dir* "/definitions/" name))
  (car (read-from-string (format "%s" (read (current-buffer)))))
  ))


(defun import-guards (name)
  (with-temp-buffer
  (insert-file-contents (concat *home-dir* "/guards/" name))
  (car (read-from-string (format "%s" (read (current-buffer)))))
  ))

(defun add-several-libraries ()
  
  (setf lemmas-libraries lemmas)
  (setf definitions-libraries definitions)
  (do ((temp libs-menus (cdr temp)))
      ((endp temp) nil)
      (progn (setf lemmas-libraries (append lemmas-libraries (import-library (car temp))))
	     ;(setf definitions-libraries (append definitions-libraries
	;					 (import-definitions (car temp))))
	     ;(setf lemma-dependencies (append lemma-dependencies (import-deps (car temp))))
	     )))


(defun change-symbol (str s1 s2)
  (let ((s (search s1 str)))
    (if (not s)
	str
      (change-symbol (concat (subseq str 0 s) s2 (subseq str (1+ s))) s1 s2))))



(defvar option-libs-defs nil)

(defun add-several-libraries-defs ()
  
  (setf definitions-libraries definitions)
  (cond ((equal option-libs-defs "g")
	 (do ((temp1 acl2files (cdr temp1)))
	     ((endp temp1) nil)
	     (ignore-errors  (setf definitions-libraries (append definitions-libraries
								 (import-definitions (concat "global/" 
											     (change-symbol (subseq (car temp1) 0 (search "." (car temp1) :from-end t)) "/" "___"))))))))
	
	((equal option-libs-defs "l")
	 (progn (do ((temp1 included-libraries-system (cdr temp1)))
	     ((endp temp1) nil)
	     (ignore-errors  (setf definitions-libraries (append definitions-libraries
								 (import-definitions (concat "global/" 
											     (change-symbol (car temp1) "/" "___")))))))
		(do ((temp1 included-libraries (cdr temp1)))
	     ((endp temp1) nil)
	     (ignore-errors  (setf definitions-libraries (append definitions-libraries
								 (import-definitions (car temp1))))))))

	((equal option-libs-defs "m")
	 (do ((temp1 libs (cdr temp1)))
	     ((endp temp1) nil)
	     (ignore-errors  (setf definitions-libraries (append definitions-libraries
								 (import-definitions (car temp1)))))))
	
	 
	((equal option-libs-defs "s")
	 (do ((temp libs-menus (cdr temp)))
	     ((endp temp) nil)
	     (setf definitions-libraries (append definitions-libraries
						 (import-definitions (car temp))))))
	(t nil))
    
  )


(defun remove-nil2 (l)
  (do ((temp l (cdr temp))
       (res nil))
      ((endp temp) res)
    (if (car temp)
	(setf res (append res (list (car temp)))))))









(defvar acl2files
  '("/leftist-trees/leftist-tree-sort.lisp"
"/leftist-trees/leftist-tree-defuns.lisp"
"/deduction/passmore/paramod.lisp"
"/deduction/passmore/bewijs.lisp"
"/deduction/passmore/unification.lisp"
"/deduction/passmore/weighting.lisp"
"/deduction/passmore/prover.lisp"
"/deduction/passmore/general.lisp"
"/deduction/passmore/resolution.lisp"
"/misc/simplify-thm.lisp"
"/misc/integer-type-set-test.lisp"
"/misc/file-io.lisp"
"/misc/how-to-prove-thms.lisp"
"/misc/evalable-printing.lisp"
"/misc/defp.lisp"
"/misc/defabsstobj-example-2.lisp"
"/misc/grcd.lisp"
"/misc/sticky-disable.lisp"
"/misc/assert.lisp"
"/misc/defattach-bang.lisp"
"/misc/process-book-readme.lisp"
"/misc/save-time.lisp"
"/misc/qi-correct.lisp"
"/misc/definline.lisp"
"/misc/congruent-stobjs-test.lisp"
"/misc/random.lisp"
"/misc/check-acl2-exports.lisp"
"/misc/defabsstobj-example-3.lisp"
"/misc/seq.lisp"
"/misc/gentle.lisp"
"/misc/misc2/reverse-by-separation.lisp"
"/misc/misc2/misc.lisp"
"/misc/misc2/ruler-extenders-tests.lisp"
"/misc/defmac.lisp"
"/misc/computed-hint.lisp"
"/misc/meta-lemmas.lisp"
"/misc/symbol-btree.lisp"
"/misc/seqw.lisp"
"/misc/bash.lisp"
"/misc/sort-symbols.lisp"
"/misc/trace-star.lisp"
"/misc/goodstein.lisp"
"/misc/callers-and-ancestors.lisp"
"/misc/dijkstra-shortest-path.lisp"
"/misc/find-lemmas.lisp"
"/misc/records.lisp"
"/misc/defabsstobj-example-4.lisp"
"/misc/getprop.lisp"
"/misc/hons-help.lisp"
"/misc/dft.lisp"
"/misc/equal-by-g.lisp"
"/misc/transfinite.lisp"
"/misc/wet.lisp"
"/misc/beta-reduce.lisp"
"/misc/radix.lisp"
"/misc/total-order.lisp"
"/misc/fast-coerce.lisp"
"/misc/defproxy-test.lisp"
"/misc/mult.lisp"
"/misc/sin-cos.lisp"
"/misc/oprof.lisp"
"/misc/hons-tests.lisp"
"/misc/defpun.lisp"
"/misc/equal-by-g-help.lisp"
"/misc/expander.lisp"
"/misc/csort.lisp"
"/misc/defun-plus.lisp"
"/misc/untranslate-patterns.lisp"
"/misc/hanoi.lisp"
"/misc/invariants.lisp"
"/misc/disassemble.lisp"
"/misc/defattach-example.lisp"
"/misc/fibonacci.lisp"
"/misc/character-encoding-test.lisp"
"/misc/redef-pkg.lisp"
"/misc/priorities.lisp"
"/misc/int-division.lisp"
"/misc/rtl-untranslate.lisp"
"/misc/defopener.lisp"
"/misc/records0.lisp"
"/misc/problem13.lisp"
"/misc/computed-hint-rewrite.lisp"
"/misc/dump-events.lisp"
"/misc/simplify-defuns.lisp"
"/misc/qi.lisp"
"/misc/dead-events.lisp"
"/misc/take.lisp"
"/misc/defabsstobj-example-1.lisp"
"/wp-gen/wp-gen.lisp"
"/wp-gen/examples/pcode.lisp"
"/wp-gen/shared.lisp"
"/wp-gen/mutrec/mutrec.lisp"
"/security/util/byte-operations.lisp"
"/security/jfkr/random.lisp"
"/security/jfkr/diffie-helman.lisp"
"/security/jfkr/jfkr.lisp"
"/security/jfkr/encryption.lisp"
"/security/des/des.lisp"
"/security/suite-b/sha-2.lisp"
"/make-event/macros-skip-proofs.lisp"
"/make-event/stobj-test.lisp"
"/make-event/nested.lisp"
"/make-event/local-requires-skip-check-include.lisp"
"/make-event/portcullis-expansion-include.lisp"
"/make-event/macros.lisp"
"/make-event/read-from-file.lisp"
"/make-event/inline-book.lisp"
"/make-event/assert-check.lisp"
"/make-event/eval-check-tests.lisp"
"/make-event/defrule.lisp"
"/make-event/make-redundant.lisp"
"/make-event/basic.lisp"
"/make-event/defrefine.lisp"
"/make-event/proof-by-arith.lisp"
"/make-event/gen-defun-check.lisp"
"/make-event/gen-defun.lisp"
"/make-event/local-elided.lisp"
"/make-event/require-book.lisp"
"/make-event/nested-check.lisp"
"/make-event/defspec.lisp"
"/make-event/acl2x-help.lisp"
"/make-event/basic-pkg-check.lisp"
"/make-event/portcullis-expansion.lisp"
"/make-event/local-requires-skip-check.lisp"
"/make-event/basic-pkg.lisp"
"/make-event/eval-tests.lisp"
"/make-event/basic-check.lisp"
"/make-event/dotimes.lisp"
"/sorting/qsort.lisp"
"/sorting/no-dups-qsort.lisp"
"/sorting/perm.lisp"
"/sorting/equisort.lisp"
"/sorting/isort.lisp"
"/sorting/equisort2.lisp"
"/sorting/bsort.lisp"
"/sorting/msort.lisp"
"/sorting/convert-perm-to-how-many.lisp"
"/sorting/ordered-perms.lisp"
"/system/subst-expr.lisp"
"/system/f-put-global.lisp"
"/system/pcert/mid.lisp"
"/system/pcert/acl2x-pcert-test-1.lisp"
"/system/pcert/top.lisp"
"/system/pcert/acl2x-pcert-test-2.lisp"
"/system/pcert/sub.lisp"
"/system/pcert/pkg-test.lisp"
"/system/worldp-check.lisp"
"/system/sublis-var.lisp"
"/system/convert-normalized-term-to-pairs.lisp"
"/system/pseudo-good-worldp.lisp"
"/system/subcor-var.lisp"
"/system/subst-var.lisp"
"/system/hl-addr-combine.lisp"
"/system/io.lisp"
"/cutil/defalist-tests.lisp"
"/cutil/defmvtypes.lisp"
"/cutil/deflist.lisp"
"/cutil/deflist-tests.lisp"
"/cutil/wizard.lisp"
"/cutil/support.lisp"
"/cutil/defmapappend-tests.lisp"
"/cutil/define.lisp"
"/cutil/defalist.lisp"
"/cutil/deflist-aux.lisp"
"/cutil/defaggregate.lisp"
"/cutil/defprojection-tests.lisp"
"/cutil/defmapappend.lisp"
"/cutil/defprojection.lisp"
"/cutil/defenum.lisp"
"/unicode/list-defuns.lisp"
"/unicode/explode-nonnegative-integer.lisp"
"/unicode/nthcdr-bytes.lisp"
"/unicode/consless-listp.lisp"
"/unicode/flatten.lisp"
"/unicode/utf8-table36.lisp"
"/unicode/signed-byte-listp.lisp"
"/unicode/utf8-table35.lisp"
"/unicode/utf8-decode.lisp"
"/unicode/utf8-encode.lisp"
"/unicode/final-cdr.lisp"
"/unicode/open-input-channel.lisp"
"/unicode/read-file-lines.lisp"
"/unicode/test-performance/timing.lisp"
"/unicode/two-nats-measure.lisp"
"/unicode/sign-byte.lisp"
"/unicode/read-ints.lisp"
"/unicode/list-fix.lisp"
"/unicode/read-file-characters.lisp"
"/unicode/prefixp.lisp"
"/unicode/unsigned-byte-listp.lisp"
"/unicode/take-bytes.lisp"
"/unicode/app.lisp"
"/unicode/revappend.lisp"
"/unicode/sum-list.lisp"
"/unicode/z-listp.lisp"
"/unicode/read-file-objects.lisp"
"/unicode/combine.lisp"
"/unicode/rev.lisp"
"/unicode/uchar.lisp"
"/unicode/partition.lisp"
"/unicode/read-utf8.lisp"
"/unicode/read-file-bytes.lisp"
"/unicode/append.lisp"
"/unicode/base10-digit-charp.lisp"
"/unicode/repeat.lisp"
"/arithmetic-4/lib/basic-ops/building-blocks-helper.lisp"
"/arithmetic-4/lib/basic-ops/elim-hint.lisp"
"/arithmetic-4/lib/basic-ops/integerp-meta.lisp"
"/arithmetic-4/lib/basic-ops/default-hint.lisp"
"/arithmetic-4/lib/basic-ops/collect.lisp"
"/arithmetic-4/lib/basic-ops/simple-equalities-and-inequalities.lisp"
"/arithmetic-4/lib/basic-ops/normalize.lisp"
"/arithmetic-4/lib/basic-ops/common.lisp"
"/arithmetic-4/lib/basic-ops/remove-weak-inequalities.lisp"
"/arithmetic-4/lib/basic-ops/integerp-helper.lisp"
"/arithmetic-4/lib/basic-ops/mini-theories.lisp"
"/arithmetic-4/lib/basic-ops/dynamic-e-d.lisp"
"/arithmetic-4/lib/basic-ops/building-blocks.lisp"
"/arithmetic-4/lib/basic-ops/integerp.lisp"
"/arithmetic-4/lib/basic-ops/simplify.lisp"
"/arithmetic-4/lib/basic-ops/expt.lisp"
"/arithmetic-4/lib/basic-ops/expt-helper.lisp"
"/arithmetic-4/lib/basic-ops/simple-equalities-and-inequalities-helper.lisp"
"/arithmetic-4/lib/basic-ops/arithmetic-theory.lisp"
"/arithmetic-4/lib/floor-mod/logand-helper.lisp"
"/arithmetic-4/lib/floor-mod/mod-expt-fast.lisp"
"/arithmetic-4/lib/floor-mod/more-floor-mod.lisp"
"/arithmetic-4/lib/floor-mod/floor-mod.lisp"
"/arithmetic-4/lib/floor-mod/logand.lisp"
"/arithmetic-4/support/expt-helper.lisp"
"/arithmetic-4/support/basic-arithmetic.lisp"
"/arithmetic-4/support/num-and-denom-helper.lisp"
"/hacking/bridge.lisp"
"/hacking/raw.lisp"
"/hacking/defstruct-parsing.lisp"
"/hacking/dynamic-make-event.lisp"
"/hacking/dynamic-make-event-test.lisp"
"/hacking/redefun.lisp"
"/hacking/evalable-ld-printing.lisp"
"/hacking/subsumption.lisp"
"/hacking/defcode.lisp"
"/hacking/rewrite-code.lisp"
"/hacking/hacker.lisp"
"/rtl/rel1/support/rnd.lisp"
"/rtl/rel1/support/sticky.lisp"
"/rtl/rel1/support/divsqrt.lisp"
"/rtl/rel1/support/x-2xx.lisp"
"/rtl/rel1/support/fadd/add3.lisp"
"/rtl/rel1/support/fadd/lop3.lisp"
"/rtl/rel1/support/fadd/top.lisp"
"/rtl/rel1/support/fadd/lop2.lisp"
"/rtl/rel1/support/fadd/stick.lisp"
"/rtl/rel1/support/fadd/lop1.lisp"
"/rtl/rel1/support/rewrite-theory.lisp"
"/rtl/rel1/support/fp.lisp"
"/rtl/rel1/support/odd.lisp"
"/rtl/rel1/support/trunc.lisp"
"/rtl/rel1/support/logdefs.lisp"
"/rtl/rel1/support/logxor-def.lisp"
"/rtl/rel1/support/loglemmas.lisp"
"/rtl/rel1/support/away.lisp"
"/rtl/rel1/support/basic.lisp"
"/rtl/rel1/support/logxor-lemmas.lisp"
"/rtl/rel1/support/merge.lisp"
"/rtl/rel1/support/float.lisp"
"/rtl/rel1/support/add.lisp"
"/rtl/rel1/support/near.lisp"
"/rtl/rel1/support/reps.lisp"
"/rtl/rel1/lib1/brat.lisp"
"/rtl/rel1/lib1/round.lisp"
"/rtl/rel1/lib1/basic.lisp"
"/rtl/rel1/lib1/float.lisp"
"/rtl/rel1/lib1/bits.lisp"
"/rtl/rel1/lib1/reps.lisp"
"/rtl/rel1/lib3/brat.lisp"
"/rtl/rel1/lib3/round.lisp"
"/rtl/rel1/lib3/fadd.lisp"
"/rtl/rel1/lib3/basic.lisp"
"/rtl/rel1/lib3/float.lisp"
"/rtl/rel1/lib3/bits.lisp"
"/rtl/rel1/lib3/reps.lisp"
"/rtl/rel7/lib/clocks.lisp"
"/rtl/rel7/lib/arith.lisp"
"/rtl/rel7/lib/openers.lisp"
"/rtl/rel7/lib/round.lisp"
"/rtl/rel7/lib/bvecp-raw-helpers.lisp"
"/rtl/rel7/lib/bvecp-helpers.lisp"
"/rtl/rel7/lib/rom-helpers.lisp"
"/rtl/rel7/lib/util.lisp"
"/rtl/rel7/lib/rtl.lisp"
"/rtl/rel7/lib/basic.lisp"
"/rtl/rel7/lib/float.lisp"
"/rtl/rel7/lib/mult.lisp"
"/rtl/rel7/lib/bits.lisp"
"/rtl/rel7/lib/rtlarr.lisp"
"/rtl/rel7/lib/add.lisp"
"/rtl/rel7/lib/reps.lisp"
"/rtl/rel7/lib/log.lisp"
"/rtl/rel7/support/lib1.delta1/arith.lisp"
"/rtl/rel7/support/lib1.delta1/round.lisp"
"/rtl/rel7/support/lib1.delta1/float-extra2.lisp"
"/rtl/rel7/support/lib1.delta1/basic.lisp"
"/rtl/rel7/support/lib1.delta1/float.lisp"
"/rtl/rel7/support/lib1.delta1/mult.lisp"
"/rtl/rel7/support/lib1.delta1/mult-proofs.lisp"
"/rtl/rel7/support/lib1.delta1/round-extra2.lisp"
"/rtl/rel7/support/support/decode.lisp"
"/rtl/rel7/support/support/setbits-proofs.lisp"
"/rtl/rel7/support/support/ocat.lisp"
"/rtl/rel7/support/support/rnd.lisp"
"/rtl/rel7/support/support/add3.lisp"
"/rtl/rel7/support/support/sticky.lisp"
"/rtl/rel7/support/support/lior0-proofs.lisp"
"/rtl/rel7/support/support/shft.lisp"
"/rtl/rel7/support/support/clocks.lisp"
"/rtl/rel7/support/support/encode.lisp"
"/rtl/rel7/support/support/bias-proofs.lisp"
"/rtl/rel7/support/support/openers.lisp"
"/rtl/rel7/support/support/sticky-proofs.lisp"
"/rtl/rel7/support/support/near-proofs.lisp"
"/rtl/rel7/support/support/all-ones.lisp"
"/rtl/rel7/support/support/setbitn.lisp"
"/rtl/rel7/support/support/land0.lisp"
"/rtl/rel7/support/support/away-proofs.lisp"
"/rtl/rel7/support/support/log-equal.lisp"
"/rtl/rel7/support/support/badguys.lisp"
"/rtl/rel7/support/support/mod4.lisp"
"/rtl/rel7/support/support/land.lisp"
"/rtl/rel7/support/support/lxor.lisp"
"/rtl/rel7/support/support/lop3.lisp"
"/rtl/rel7/support/support/near+-proofs.lisp"
"/rtl/rel7/support/support/trunc-proofs.lisp"
"/rtl/rel7/support/support/logs.lisp"
"/rtl/rel7/support/support/fadd.lisp"
"/rtl/rel7/support/support/ereps.lisp"
"/rtl/rel7/support/support/fast-and.lisp"
"/rtl/rel7/support/support/lior.lisp"
"/rtl/rel7/support/support/rewrite-theory.lisp"
"/rtl/rel7/support/support/bitn-proofs.lisp"
"/rtl/rel7/support/support/decode-proofs.lisp"
"/rtl/rel7/support/support/sgn.lisp"
"/rtl/rel7/support/support/rom-helpers.lisp"
"/rtl/rel7/support/support/drnd-original.lisp"
"/rtl/rel7/support/support/oddr.lisp"
"/rtl/rel7/support/support/logior.lisp"
"/rtl/rel7/support/support/lognot.lisp"
"/rtl/rel7/support/support/near+.lisp"
"/rtl/rel7/support/support/logior1-proofs.lisp"
"/rtl/rel7/support/support/trunc.lisp"
"/rtl/rel7/support/support/util.lisp"
"/rtl/rel7/support/support/bias.lisp"
"/rtl/rel7/support/support/mulcat-proofs.lisp"
"/rtl/rel7/support/support/rtl.lisp"
"/rtl/rel7/support/support/lnot-proofs.lisp"
"/rtl/rel7/support/support/lior0.lisp"
"/rtl/rel7/support/support/logior-proofs.lisp"
"/rtl/rel7/support/support/lnot.lisp"
"/rtl/rel7/support/support/stick.lisp"
"/rtl/rel7/support/support/logeqv.lisp"
"/rtl/rel7/support/support/logand-proofs.lisp"
"/rtl/rel7/support/support/mulcat.lisp"
"/rtl/rel7/support/support/bvecp.lisp"
"/rtl/rel7/support/support/bits-proofs.lisp"
"/rtl/rel7/support/support/away.lisp"
"/rtl/rel7/support/support/lop3-proofs.lisp"
"/rtl/rel7/support/support/stick-proofs.lisp"
"/rtl/rel7/support/support/ash.lisp"
"/rtl/rel7/support/support/merge.lisp"
"/rtl/rel7/support/support/logior1.lisp"
"/rtl/rel7/support/support/float.lisp"
"/rtl/rel7/support/support/lop1-proofs.lisp"
"/rtl/rel7/support/support/cat-def.lisp"
"/rtl/rel7/support/support/lxor0-proofs.lisp"
"/rtl/rel7/support/support/fadd-extra.lisp"
"/rtl/rel7/support/support/lop1.lisp"
"/rtl/rel7/support/support/bits.lisp"
"/rtl/rel7/support/support/bitn.lisp"
"/rtl/rel7/support/support/add3-proofs.lisp"
"/rtl/rel7/support/support/setbitn-proofs.lisp"
"/rtl/rel7/support/support/lextra.lisp"
"/rtl/rel7/support/support/lop2-proofs.lisp"
"/rtl/rel7/support/support/float-extra.lisp"
"/rtl/rel7/support/support/bvecp-proofs.lisp"
"/rtl/rel7/support/support/land0-proofs.lisp"
"/rtl/rel7/support/support/rtlarr.lisp"
"/rtl/rel7/support/support/logorc1.lisp"
"/rtl/rel7/support/support/near.lisp"
"/rtl/rel7/support/support/sumbits.lisp"
"/rtl/rel7/support/support/setbits.lisp"
"/rtl/rel7/support/support/log-proofs.lisp"
"/rtl/rel7/support/support/cat.lisp"
"/rtl/rel7/support/support/logxor.lisp"
"/rtl/rel7/support/support/oddr-proofs.lisp"
"/rtl/rel7/support/support/ireps.lisp"
"/rtl/rel7/support/support/lxor0.lisp"
"/rtl/rel7/support/support/cat-proofs.lisp"
"/rtl/rel7/support/support/ereps-proofs.lisp"
"/rtl/rel7/support/support/logand.lisp"
"/rtl/rel7/support/support/bvecp-lemmas.lisp"
"/rtl/rel7/support/support/log.lisp"
"/rtl/rel7/support/lib1/clocks.lisp"
"/rtl/rel7/support/lib1/arith.lisp"
"/rtl/rel7/support/lib1/openers.lisp"
"/rtl/rel7/support/lib1/round.lisp"
"/rtl/rel7/support/lib1/bvecp-raw-helpers.lisp"
"/rtl/rel7/support/lib1/bvecp-helpers.lisp"
"/rtl/rel7/support/lib1/rom-helpers.lisp"
"/rtl/rel7/support/lib1/util.lisp"
"/rtl/rel7/support/lib1/rtl.lisp"
"/rtl/rel7/support/lib1/basic.lisp"
"/rtl/rel7/support/lib1/float.lisp"
"/rtl/rel7/support/lib1/bits.lisp"
"/rtl/rel7/support/lib1/rtlarr.lisp"
"/rtl/rel7/support/lib1/add.lisp"
"/rtl/rel7/support/lib1/reps.lisp"
"/rtl/rel7/support/lib1/log.lisp"
"/rtl/rel7/arithmetic/fl.lisp"
"/rtl/rel7/arithmetic/mod.lisp"
"/rtl/rel7/arithmetic/common-factor-defuns.lisp"
"/rtl/rel7/arithmetic/induct.lisp"
"/rtl/rel7/arithmetic/inverted-factor.lisp"
"/rtl/rel7/arithmetic/fl-proofs.lisp"
"/rtl/rel7/arithmetic/negative-syntaxp.lisp"
"/rtl/rel7/arithmetic/predicate.lisp"
"/rtl/rel7/arithmetic/expt-proofs.lisp"
"/rtl/rel7/arithmetic/even-odd2-proofs.lisp"
"/rtl/rel7/arithmetic/fp2.lisp"
"/rtl/rel7/arithmetic/mod-expt.lisp"
"/rtl/rel7/arithmetic/common-factor.lisp"
"/rtl/rel7/arithmetic/nniq.lisp"
"/rtl/rel7/arithmetic/cg.lisp"
"/rtl/rel7/arithmetic/basic.lisp"
"/rtl/rel7/arithmetic/fl-hacks.lisp"
"/rtl/rel7/arithmetic/expt.lisp"
"/rtl/rel7/arithmetic/hacks.lisp"
"/rtl/rel7/arithmetic/power2p.lisp"
"/rtl/rel7/arithmetic/expo.lisp"
"/rtl/rel7/arithmetic/fl-expt.lisp"
"/rtl/rel7/arithmetic/mod-proofs.lisp"
"/rtl/rel7/arithmetic/even-odd.lisp"
"/rtl/rel7/arithmetic/expo-proofs.lisp"
"/rtl/rel7/arithmetic/even-odd2.lisp"
"/rtl/rel7/arithmetic/arith2.lisp"
"/rtl/rel7/user/decode.lisp"
"/rtl/rel7/user/bits-trunc.lisp"
"/rtl/rel7/user/brat.lisp"
"/rtl/rel7/user/setbitn.lisp"
"/rtl/rel7/user/land.lisp"
"/rtl/rel7/user/lxor.lisp"
"/rtl/rel7/user/ereps.lisp"
"/rtl/rel7/user/lior.lisp"
"/rtl/rel7/user/trunc.lisp"
"/rtl/rel7/user/bias.lisp"
"/rtl/rel7/user/lnot.lisp"
"/rtl/rel7/user/stick.lisp"
"/rtl/rel7/user/mulcat.lisp"
"/rtl/rel7/user/bvecp.lisp"
"/rtl/rel7/user/away.lisp"
"/rtl/rel7/user/logior1.lisp"
"/rtl/rel7/user/bits.lisp"
"/rtl/rel7/user/bitn.lisp"
"/rtl/rel7/user/near.lisp"
"/rtl/rel7/user/sumbits.lisp"
"/rtl/rel7/user/setbits.lisp"
"/rtl/rel7/user/cat.lisp"
"/rtl/rel8/lib/clocks.lisp"
"/rtl/rel8/lib/arith.lisp"
"/rtl/rel8/lib/openers.lisp"
"/rtl/rel8/lib/round.lisp"
"/rtl/rel8/lib/logn.lisp"
"/rtl/rel8/lib/bvecp-raw-helpers.lisp"
"/rtl/rel8/lib/bvecp-helpers.lisp"
"/rtl/rel8/lib/rom-helpers.lisp"
"/rtl/rel8/lib/util.lisp"
"/rtl/rel8/lib/rtl.lisp"
"/rtl/rel8/lib/basic.lisp"
"/rtl/rel8/lib/float.lisp"
"/rtl/rel8/lib/mult.lisp"
"/rtl/rel8/lib/bits.lisp"
"/rtl/rel8/lib/rtlarr.lisp"
"/rtl/rel8/lib/add.lisp"
"/rtl/rel8/lib/reps.lisp"
"/rtl/rel8/lib/log.lisp"
"/rtl/rel8/support/lib2.delta1/bits-new.lisp"
"/rtl/rel8/support/lib2.delta1/add-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/reps-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/arith.lisp"
"/rtl/rel8/support/lib2.delta1/round.lisp"
"/rtl/rel8/support/lib2.delta1/bvecp-raw-helpers-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/logn.lisp"
"/rtl/rel8/support/lib2.delta1/float-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/add-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/add-new.lisp"
"/rtl/rel8/support/lib2.delta1/log-new.lisp"
"/rtl/rel8/support/lib2.delta1/log-support-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/bvecp-raw-helpers.lisp"
"/rtl/rel8/support/lib2.delta1/bvecp-helpers.lisp"
"/rtl/rel8/support/lib2.delta1/round-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/util.lisp"
"/rtl/rel8/support/lib2.delta1/rtl.lisp"
"/rtl/rel8/support/lib2.delta1/reps-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/log-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/reps-new.lisp"
"/rtl/rel8/support/lib2.delta1/rtlarr-new.lisp"
"/rtl/rel8/support/lib2.delta1/round-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/bits-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/mult-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/mult-new.lisp"
"/rtl/rel8/support/lib2.delta1/float.lisp"
"/rtl/rel8/support/lib2.delta1/logn-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/mult.lisp"
"/rtl/rel8/support/lib2.delta1/bits.lisp"
"/rtl/rel8/support/lib2.delta1/rtl-new.lisp"
"/rtl/rel8/support/lib2.delta1/float-new.lisp"
"/rtl/rel8/support/lib2.delta1/rtlarr.lisp"
"/rtl/rel8/support/lib2.delta1/add.lisp"
"/rtl/rel8/support/lib2.delta1/round-new.lisp"
"/rtl/rel8/support/lib2.delta1/reps.lisp"
"/rtl/rel8/support/lib2.delta1/log-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/float-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/mult-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/bits-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/logn-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/logn-new.lisp"
"/rtl/rel8/support/lib2.delta1/rtl-new-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/rtl-proofs.lisp"
"/rtl/rel8/support/lib2.delta1/log.lisp"
"/rtl/rel8/support/lib1.delta1/arith.lisp"
"/rtl/rel8/support/lib1.delta1/round.lisp"
"/rtl/rel8/support/lib1.delta1/bvecp-raw-helpers.lisp"
"/rtl/rel8/support/lib1.delta1/float-extra2.lisp"
"/rtl/rel8/support/lib1.delta1/basic.lisp"
"/rtl/rel8/support/lib1.delta1/float.lisp"
"/rtl/rel8/support/lib1.delta1/mult.lisp"
"/rtl/rel8/support/lib1.delta1/bits.lisp"
"/rtl/rel8/support/lib1.delta1/bits-extra.lisp"
"/rtl/rel8/support/lib1.delta1/mult-proofs.lisp"
"/rtl/rel8/support/lib1.delta1/round-extra2.lisp"
"/rtl/rel8/support/support/decode.lisp"
"/rtl/rel8/support/support/setbits-proofs.lisp"
"/rtl/rel8/support/support/ocat.lisp"
"/rtl/rel8/support/support/rnd.lisp"
"/rtl/rel8/support/support/add3.lisp"
"/rtl/rel8/support/support/sticky.lisp"
"/rtl/rel8/support/support/lior0-proofs.lisp"
"/rtl/rel8/support/support/shft.lisp"
"/rtl/rel8/support/support/clocks.lisp"
"/rtl/rel8/support/support/encode.lisp"
"/rtl/rel8/support/support/bias-proofs.lisp"
"/rtl/rel8/support/support/openers.lisp"
"/rtl/rel8/support/support/sticky-proofs.lisp"
"/rtl/rel8/support/support/near-proofs.lisp"
"/rtl/rel8/support/support/all-ones.lisp"
"/rtl/rel8/support/support/setbitn.lisp"
"/rtl/rel8/support/support/land0.lisp"
"/rtl/rel8/support/support/away-proofs.lisp"
"/rtl/rel8/support/support/log-equal.lisp"
"/rtl/rel8/support/support/badguys.lisp"
"/rtl/rel8/support/support/mod4.lisp"
"/rtl/rel8/support/support/land.lisp"
"/rtl/rel8/support/support/lxor.lisp"
"/rtl/rel8/support/support/lop3.lisp"
"/rtl/rel8/support/support/near+-proofs.lisp"
"/rtl/rel8/support/support/trunc-proofs.lisp"
"/rtl/rel8/support/support/logs.lisp"
"/rtl/rel8/support/support/fadd.lisp"
"/rtl/rel8/support/support/ereps.lisp"
"/rtl/rel8/support/support/fast-and.lisp"
"/rtl/rel8/support/support/lior.lisp"
"/rtl/rel8/support/support/rewrite-theory.lisp"
"/rtl/rel8/support/support/bitn-proofs.lisp"
"/rtl/rel8/support/support/decode-proofs.lisp"
"/rtl/rel8/support/support/sgn.lisp"
"/rtl/rel8/support/support/rom-helpers.lisp"
"/rtl/rel8/support/support/drnd-original.lisp"
"/rtl/rel8/support/support/oddr.lisp"
"/rtl/rel8/support/support/logior.lisp"
"/rtl/rel8/support/support/lognot.lisp"
"/rtl/rel8/support/support/near+.lisp"
"/rtl/rel8/support/support/logior1-proofs.lisp"
"/rtl/rel8/support/support/trunc.lisp"
"/rtl/rel8/support/support/util.lisp"
"/rtl/rel8/support/support/bias.lisp"
"/rtl/rel8/support/support/mulcat-proofs.lisp"
"/rtl/rel8/support/support/rtl.lisp"
"/rtl/rel8/support/support/lnot-proofs.lisp"
"/rtl/rel8/support/support/lior0.lisp"
"/rtl/rel8/support/support/logior-proofs.lisp"
"/rtl/rel8/support/support/lnot.lisp"
"/rtl/rel8/support/support/stick.lisp"
"/rtl/rel8/support/support/logeqv.lisp"
"/rtl/rel8/support/support/logand-proofs.lisp"
"/rtl/rel8/support/support/mulcat.lisp"
"/rtl/rel8/support/support/bvecp.lisp"
"/rtl/rel8/support/support/bits-proofs.lisp"
"/rtl/rel8/support/support/away.lisp"
"/rtl/rel8/support/support/lop3-proofs.lisp"
"/rtl/rel8/support/support/stick-proofs.lisp"
"/rtl/rel8/support/support/ash.lisp"
"/rtl/rel8/support/support/merge.lisp"
"/rtl/rel8/support/support/logior1.lisp"
"/rtl/rel8/support/support/float.lisp"
"/rtl/rel8/support/support/lop1-proofs.lisp"
"/rtl/rel8/support/support/cat-def.lisp"
"/rtl/rel8/support/support/lxor0-proofs.lisp"
"/rtl/rel8/support/support/fadd-extra.lisp"
"/rtl/rel8/support/support/lop1.lisp"
"/rtl/rel8/support/support/bits.lisp"
"/rtl/rel8/support/support/bitn.lisp"
"/rtl/rel8/support/support/add3-proofs.lisp"
"/rtl/rel8/support/support/setbitn-proofs.lisp"
"/rtl/rel8/support/support/lextra.lisp"
"/rtl/rel8/support/support/lop2-proofs.lisp"
"/rtl/rel8/support/support/float-extra.lisp"
"/rtl/rel8/support/support/bvecp-proofs.lisp"
"/rtl/rel8/support/support/land0-proofs.lisp"
"/rtl/rel8/support/support/rtlarr.lisp"
"/rtl/rel8/support/support/logorc1.lisp"
"/rtl/rel8/support/support/near.lisp"
"/rtl/rel8/support/support/sumbits.lisp"
"/rtl/rel8/support/support/setbits.lisp"
"/rtl/rel8/support/support/log-proofs.lisp"
"/rtl/rel8/support/support/cat.lisp"
"/rtl/rel8/support/support/logxor.lisp"
"/rtl/rel8/support/support/oddr-proofs.lisp"
"/rtl/rel8/support/support/ireps.lisp"
"/rtl/rel8/support/support/lxor0.lisp"
"/rtl/rel8/support/support/cat-proofs.lisp"
"/rtl/rel8/support/support/ereps-proofs.lisp"
"/rtl/rel8/support/support/logand.lisp"
"/rtl/rel8/support/support/bvecp-lemmas.lisp"
"/rtl/rel8/support/support/log.lisp"
"/rtl/rel8/support/lib1/clocks.lisp"
"/rtl/rel8/support/lib1/arith.lisp"
"/rtl/rel8/support/lib1/openers.lisp"
"/rtl/rel8/support/lib1/round.lisp"
"/rtl/rel8/support/lib1/bvecp-raw-helpers.lisp"
"/rtl/rel8/support/lib1/bvecp-helpers.lisp"
"/rtl/rel8/support/lib1/rom-helpers.lisp"
"/rtl/rel8/support/lib1/util.lisp"
"/rtl/rel8/support/lib1/rtl.lisp"
"/rtl/rel8/support/lib1/basic.lisp"
"/rtl/rel8/support/lib1/float.lisp"
"/rtl/rel8/support/lib1/bits.lisp"
"/rtl/rel8/support/lib1/rtlarr.lisp"
"/rtl/rel8/support/lib1/add.lisp"
"/rtl/rel8/support/lib1/reps.lisp"
"/rtl/rel8/support/lib1/log.lisp"
"/rtl/rel8/support/lib1.delta2/float.lisp"
"/rtl/rel8/support/lib2.delta2/add-lib.lisp"
"/rtl/rel8/support/lib2.delta2/bits.lisp"
"/rtl/rel8/support/lib2.delta2/add.lisp"
"/rtl/rel8/support/lib2.delta2/log.lisp"
"/rtl/rel8/support/lib2/clocks.lisp"
"/rtl/rel8/support/lib2/arith.lisp"
"/rtl/rel8/support/lib2/openers.lisp"
"/rtl/rel8/support/lib2/round.lisp"
"/rtl/rel8/support/lib2/bvecp-raw-helpers.lisp"
"/rtl/rel8/support/lib2/bvecp-helpers.lisp"
"/rtl/rel8/support/lib2/rom-helpers.lisp"
"/rtl/rel8/support/lib2/util.lisp"
"/rtl/rel8/support/lib2/rtl.lisp"
"/rtl/rel8/support/lib2/basic.lisp"
"/rtl/rel8/support/lib2/float.lisp"
"/rtl/rel8/support/lib2/mult.lisp"
"/rtl/rel8/support/lib2/bits.lisp"
"/rtl/rel8/support/lib2/rtlarr.lisp"
"/rtl/rel8/support/lib2/add.lisp"
"/rtl/rel8/support/lib2/reps.lisp"
"/rtl/rel8/support/lib2/log.lisp"
"/rtl/rel8/arithmetic/fl.lisp"
"/rtl/rel8/arithmetic/mod.lisp"
"/rtl/rel8/arithmetic/common-factor-defuns.lisp"
"/rtl/rel8/arithmetic/induct.lisp"
"/rtl/rel8/arithmetic/inverted-factor.lisp"
"/rtl/rel8/arithmetic/fl-proofs.lisp"
"/rtl/rel8/arithmetic/negative-syntaxp.lisp"
"/rtl/rel8/arithmetic/predicate.lisp"
"/rtl/rel8/arithmetic/expt-proofs.lisp"
"/rtl/rel8/arithmetic/even-odd2-proofs.lisp"
"/rtl/rel8/arithmetic/fp2.lisp"
"/rtl/rel8/arithmetic/mod-expt.lisp"
"/rtl/rel8/arithmetic/common-factor.lisp"
"/rtl/rel8/arithmetic/nniq.lisp"
"/rtl/rel8/arithmetic/cg.lisp"
"/rtl/rel8/arithmetic/basic.lisp"
"/rtl/rel8/arithmetic/fl-hacks.lisp"
"/rtl/rel8/arithmetic/expt.lisp"
"/rtl/rel8/arithmetic/hacks.lisp"
"/rtl/rel8/arithmetic/power2p.lisp"
"/rtl/rel8/arithmetic/expo.lisp"
"/rtl/rel8/arithmetic/fl-expt.lisp"
"/rtl/rel8/arithmetic/mod-proofs.lisp"
"/rtl/rel8/arithmetic/even-odd.lisp"
"/rtl/rel8/arithmetic/expo-proofs.lisp"
"/rtl/rel8/arithmetic/even-odd2.lisp"
"/rtl/rel8/arithmetic/arith2.lisp"
"/rtl/rel5/lib/clocks.lisp"
"/rtl/rel5/lib/arith.lisp"
"/rtl/rel5/lib/openers.lisp"
"/rtl/rel5/lib/round.lisp"
"/rtl/rel5/lib/bvecp-raw-helpers.lisp"
"/rtl/rel5/lib/bvecp-helpers.lisp"
"/rtl/rel5/lib/rom-helpers.lisp"
"/rtl/rel5/lib/util.lisp"
"/rtl/rel5/lib/rtl.lisp"
"/rtl/rel5/lib/basic.lisp"
"/rtl/rel5/lib/float.lisp"
"/rtl/rel5/lib/bits.lisp"
"/rtl/rel5/lib/rtlarr.lisp"
"/rtl/rel5/lib/add.lisp"
"/rtl/rel5/lib/reps.lisp"
"/rtl/rel5/lib/log.lisp"
"/rtl/rel5/support/decode.lisp"
"/rtl/rel5/support/setbits-proofs.lisp"
"/rtl/rel5/support/ocat.lisp"
"/rtl/rel5/support/rnd.lisp"
"/rtl/rel5/support/add3.lisp"
"/rtl/rel5/support/sticky.lisp"
"/rtl/rel5/support/lior0-proofs.lisp"
"/rtl/rel5/support/shft.lisp"
"/rtl/rel5/support/clocks.lisp"
"/rtl/rel5/support/encode.lisp"
"/rtl/rel5/support/bias-proofs.lisp"
"/rtl/rel5/support/openers.lisp"
"/rtl/rel5/support/sticky-proofs.lisp"
"/rtl/rel5/support/near-proofs.lisp"
"/rtl/rel5/support/all-ones.lisp"
"/rtl/rel5/support/setbitn.lisp"
"/rtl/rel5/support/land0.lisp"
"/rtl/rel5/support/away-proofs.lisp"
"/rtl/rel5/support/log-equal.lisp"
"/rtl/rel5/support/badguys.lisp"
"/rtl/rel5/support/mod4.lisp"
"/rtl/rel5/support/land.lisp"
"/rtl/rel5/support/lxor.lisp"
"/rtl/rel5/support/lop3.lisp"
"/rtl/rel5/support/near+-proofs.lisp"
"/rtl/rel5/support/trunc-proofs.lisp"
"/rtl/rel5/support/logs.lisp"
"/rtl/rel5/support/fadd.lisp"
"/rtl/rel5/support/ereps.lisp"
"/rtl/rel5/support/fast-and.lisp"
"/rtl/rel5/support/lior.lisp"
"/rtl/rel5/support/rewrite-theory.lisp"
"/rtl/rel5/support/bitn-proofs.lisp"
"/rtl/rel5/support/decode-proofs.lisp"
"/rtl/rel5/support/sgn.lisp"
"/rtl/rel5/support/rom-helpers.lisp"
"/rtl/rel5/support/oddr.lisp"
"/rtl/rel5/support/logior.lisp"
"/rtl/rel5/support/lognot.lisp"
"/rtl/rel5/support/near+.lisp"
"/rtl/rel5/support/logior1-proofs.lisp"
"/rtl/rel5/support/trunc.lisp"
"/rtl/rel5/support/util.lisp"
"/rtl/rel5/support/bias.lisp"
"/rtl/rel5/support/mulcat-proofs.lisp"
"/rtl/rel5/support/rtl.lisp"
"/rtl/rel5/support/lnot-proofs.lisp"
"/rtl/rel5/support/lior0.lisp"
"/rtl/rel5/support/logior-proofs.lisp"
"/rtl/rel5/support/lnot.lisp"
"/rtl/rel5/support/stick.lisp"
"/rtl/rel5/support/logeqv.lisp"
"/rtl/rel5/support/logand-proofs.lisp"
"/rtl/rel5/support/mulcat.lisp"
"/rtl/rel5/support/bvecp.lisp"
"/rtl/rel5/support/bits-proofs.lisp"
"/rtl/rel5/support/away.lisp"
"/rtl/rel5/support/lop3-proofs.lisp"
"/rtl/rel5/support/stick-proofs.lisp"
"/rtl/rel5/support/ash.lisp"
"/rtl/rel5/support/merge.lisp"
"/rtl/rel5/support/logior1.lisp"
"/rtl/rel5/support/float.lisp"
"/rtl/rel5/support/lop1-proofs.lisp"
"/rtl/rel5/support/cat-def.lisp"
"/rtl/rel5/support/lxor0-proofs.lisp"
"/rtl/rel5/support/fadd-extra.lisp"
"/rtl/rel5/support/lop1.lisp"
"/rtl/rel5/support/bits.lisp"
"/rtl/rel5/support/bitn.lisp"
"/rtl/rel5/support/add3-proofs.lisp"
"/rtl/rel5/support/setbitn-proofs.lisp"
"/rtl/rel5/support/lextra.lisp"
"/rtl/rel5/support/drnd.lisp"
"/rtl/rel5/support/lop2-proofs.lisp"
"/rtl/rel5/support/float-extra.lisp"
"/rtl/rel5/support/bvecp-proofs.lisp"
"/rtl/rel5/support/land0-proofs.lisp"
"/rtl/rel5/support/rtlarr.lisp"
"/rtl/rel5/support/logorc1.lisp"
"/rtl/rel5/support/near.lisp"
"/rtl/rel5/support/sumbits.lisp"
"/rtl/rel5/support/setbits.lisp"
"/rtl/rel5/support/log-proofs.lisp"
"/rtl/rel5/support/cat.lisp"
"/rtl/rel5/support/logxor.lisp"
"/rtl/rel5/support/oddr-proofs.lisp"
"/rtl/rel5/support/ireps.lisp"
"/rtl/rel5/support/lxor0.lisp"
"/rtl/rel5/support/cat-proofs.lisp"
"/rtl/rel5/support/ereps-proofs.lisp"
"/rtl/rel5/support/logand.lisp"
"/rtl/rel5/support/bvecp-lemmas.lisp"
"/rtl/rel5/support/log.lisp"
"/rtl/rel5/arithmetic/fl.lisp"
"/rtl/rel5/arithmetic/mod.lisp"
"/rtl/rel5/arithmetic/common-factor-defuns.lisp"
"/rtl/rel5/arithmetic/induct.lisp"
"/rtl/rel5/arithmetic/inverted-factor.lisp"
"/rtl/rel5/arithmetic/fl-proofs.lisp"
"/rtl/rel5/arithmetic/negative-syntaxp.lisp"
"/rtl/rel5/arithmetic/predicate.lisp"
"/rtl/rel5/arithmetic/expt-proofs.lisp"
"/rtl/rel5/arithmetic/even-odd2-proofs.lisp"
"/rtl/rel5/arithmetic/fp2.lisp"
"/rtl/rel5/arithmetic/mod-expt.lisp"
"/rtl/rel5/arithmetic/common-factor.lisp"
"/rtl/rel5/arithmetic/nniq.lisp"
"/rtl/rel5/arithmetic/cg.lisp"
"/rtl/rel5/arithmetic/basic.lisp"
"/rtl/rel5/arithmetic/fl-hacks.lisp"
"/rtl/rel5/arithmetic/expt.lisp"
"/rtl/rel5/arithmetic/hacks.lisp"
"/rtl/rel5/arithmetic/power2p.lisp"
"/rtl/rel5/arithmetic/expo.lisp"
"/rtl/rel5/arithmetic/fl-expt.lisp"
"/rtl/rel5/arithmetic/mod-proofs.lisp"
"/rtl/rel5/arithmetic/even-odd.lisp"
"/rtl/rel5/arithmetic/expo-proofs.lisp"
"/rtl/rel5/arithmetic/even-odd2.lisp"
"/rtl/rel5/arithmetic/arith2.lisp"
"/rtl/rel5/user/decode.lisp"
"/rtl/rel5/user/bits-trunc.lisp"
"/rtl/rel5/user/brat.lisp"
"/rtl/rel5/user/setbitn.lisp"
"/rtl/rel5/user/land.lisp"
"/rtl/rel5/user/lxor.lisp"
"/rtl/rel5/user/ereps.lisp"
"/rtl/rel5/user/lior.lisp"
"/rtl/rel5/user/trunc.lisp"
"/rtl/rel5/user/bias.lisp"
"/rtl/rel5/user/lnot.lisp"
"/rtl/rel5/user/stick.lisp"
"/rtl/rel5/user/mulcat.lisp"
"/rtl/rel5/user/bvecp.lisp"
"/rtl/rel5/user/away.lisp"
"/rtl/rel5/user/logior1.lisp"
"/rtl/rel5/user/bits.lisp"
"/rtl/rel5/user/bitn.lisp"
"/rtl/rel5/user/near.lisp"
"/rtl/rel5/user/sumbits.lisp"
"/rtl/rel5/user/setbits.lisp"
"/rtl/rel5/user/cat.lisp"
"/rtl/rel4/lib/clocks.lisp"
"/rtl/rel4/lib/arith.lisp"
"/rtl/rel4/lib/openers.lisp"
"/rtl/rel4/lib/round.lisp"
"/rtl/rel4/lib/fadd.lisp"
"/rtl/rel4/lib/bvecp-raw-helpers.lisp"
"/rtl/rel4/lib/bvecp-helpers.lisp"
"/rtl/rel4/lib/rom-helpers.lisp"
"/rtl/rel4/lib/util.lisp"
"/rtl/rel4/lib/rtl.lisp"
"/rtl/rel4/lib/basic.lisp"
"/rtl/rel4/lib/float.lisp"
"/rtl/rel4/lib/bits.lisp"
"/rtl/rel4/lib/rtlarr.lisp"
"/rtl/rel4/lib/reps.lisp"
"/rtl/rel4/support/decode.lisp"
"/rtl/rel4/support/setbits-proofs.lisp"
"/rtl/rel4/support/ocat.lisp"
"/rtl/rel4/support/rnd.lisp"
"/rtl/rel4/support/add3.lisp"
"/rtl/rel4/support/sticky.lisp"
"/rtl/rel4/support/shft.lisp"
"/rtl/rel4/support/clocks.lisp"
"/rtl/rel4/support/encode.lisp"
"/rtl/rel4/support/bias-proofs.lisp"
"/rtl/rel4/support/openers.lisp"
"/rtl/rel4/support/sticky-proofs.lisp"
"/rtl/rel4/support/near-proofs.lisp"
"/rtl/rel4/support/all-ones.lisp"
"/rtl/rel4/support/setbitn.lisp"
"/rtl/rel4/support/away-proofs.lisp"
"/rtl/rel4/support/log-equal.lisp"
"/rtl/rel4/support/badguys.lisp"
"/rtl/rel4/support/mod4.lisp"
"/rtl/rel4/support/land.lisp"
"/rtl/rel4/support/lxor.lisp"
"/rtl/rel4/support/lxor-proofs.lisp"
"/rtl/rel4/support/lop3.lisp"
"/rtl/rel4/support/near+-proofs.lisp"
"/rtl/rel4/support/trunc-proofs.lisp"
"/rtl/rel4/support/logs.lisp"
"/rtl/rel4/support/land-proofs.lisp"
"/rtl/rel4/support/fadd.lisp"
"/rtl/rel4/support/ereps.lisp"
"/rtl/rel4/support/fast-and.lisp"
"/rtl/rel4/support/lior.lisp"
"/rtl/rel4/support/rewrite-theory.lisp"
"/rtl/rel4/support/bitn-proofs.lisp"
"/rtl/rel4/support/decode-proofs.lisp"
"/rtl/rel4/support/sgn.lisp"
"/rtl/rel4/support/rom-helpers.lisp"
"/rtl/rel4/support/oddr.lisp"
"/rtl/rel4/support/logior.lisp"
"/rtl/rel4/support/lognot.lisp"
"/rtl/rel4/support/near+.lisp"
"/rtl/rel4/support/logior1-proofs.lisp"
"/rtl/rel4/support/trunc.lisp"
"/rtl/rel4/support/util.lisp"
"/rtl/rel4/support/bias.lisp"
"/rtl/rel4/support/mulcat-proofs.lisp"
"/rtl/rel4/support/rtl.lisp"
"/rtl/rel4/support/lnot-proofs.lisp"
"/rtl/rel4/support/logior-proofs.lisp"
"/rtl/rel4/support/lnot.lisp"
"/rtl/rel4/support/stick.lisp"
"/rtl/rel4/support/logeqv.lisp"
"/rtl/rel4/support/logand-proofs.lisp"
"/rtl/rel4/support/mulcat.lisp"
"/rtl/rel4/support/bvecp.lisp"
"/rtl/rel4/support/bits-proofs.lisp"
"/rtl/rel4/support/away.lisp"
"/rtl/rel4/support/lop3-proofs.lisp"
"/rtl/rel4/support/stick-proofs.lisp"
"/rtl/rel4/support/ash.lisp"
"/rtl/rel4/support/merge.lisp"
"/rtl/rel4/support/logior1.lisp"
"/rtl/rel4/support/float.lisp"
"/rtl/rel4/support/lop1-proofs.lisp"
"/rtl/rel4/support/cat-def.lisp"
"/rtl/rel4/support/lop1.lisp"
"/rtl/rel4/support/bits.lisp"
"/rtl/rel4/support/bitn.lisp"
"/rtl/rel4/support/add3-proofs.lisp"
"/rtl/rel4/support/setbitn-proofs.lisp"
"/rtl/rel4/support/drnd.lisp"
"/rtl/rel4/support/lop2-proofs.lisp"
"/rtl/rel4/support/bvecp-proofs.lisp"
"/rtl/rel4/support/rtlarr.lisp"
"/rtl/rel4/support/lior-proofs.lisp"
"/rtl/rel4/support/logorc1.lisp"
"/rtl/rel4/support/near.lisp"
"/rtl/rel4/support/sumbits.lisp"
"/rtl/rel4/support/setbits.lisp"
"/rtl/rel4/support/log-proofs.lisp"
"/rtl/rel4/support/cat.lisp"
"/rtl/rel4/support/logxor.lisp"
"/rtl/rel4/support/oddr-proofs.lisp"
"/rtl/rel4/support/ireps.lisp"
"/rtl/rel4/support/cat-proofs.lisp"
"/rtl/rel4/support/ereps-proofs.lisp"
"/rtl/rel4/support/logand.lisp"
"/rtl/rel4/support/bvecp-lemmas.lisp"
"/rtl/rel4/support/log.lisp"
"/rtl/rel4/arithmetic/fl.lisp"
"/rtl/rel4/arithmetic/mod.lisp"
"/rtl/rel4/arithmetic/common-factor-defuns.lisp"
"/rtl/rel4/arithmetic/induct.lisp"
"/rtl/rel4/arithmetic/inverted-factor.lisp"
"/rtl/rel4/arithmetic/fl-proofs.lisp"
"/rtl/rel4/arithmetic/x-2xx.lisp"
"/rtl/rel4/arithmetic/negative-syntaxp.lisp"
"/rtl/rel4/arithmetic/predicate.lisp"
"/rtl/rel4/arithmetic/expt-proofs.lisp"
"/rtl/rel4/arithmetic/even-odd2-proofs.lisp"
"/rtl/rel4/arithmetic/fp2.lisp"
"/rtl/rel4/arithmetic/mod-expt.lisp"
"/rtl/rel4/arithmetic/common-factor.lisp"
"/rtl/rel4/arithmetic/nniq.lisp"
"/rtl/rel4/arithmetic/cg.lisp"
"/rtl/rel4/arithmetic/basic.lisp"
"/rtl/rel4/arithmetic/fl-hacks.lisp"
"/rtl/rel4/arithmetic/expt.lisp"
"/rtl/rel4/arithmetic/hacks.lisp"
"/rtl/rel4/arithmetic/power2p.lisp"
"/rtl/rel4/arithmetic/expo.lisp"
"/rtl/rel4/arithmetic/fl-expt.lisp"
"/rtl/rel4/arithmetic/mod-proofs.lisp"
"/rtl/rel4/arithmetic/even-odd.lisp"
"/rtl/rel4/arithmetic/expo-proofs.lisp"
"/rtl/rel4/arithmetic/even-odd2.lisp"
"/rtl/rel4/arithmetic/arith2.lisp"
"/rtl/rel4/user/decode.lisp"
"/rtl/rel4/user/bits-trunc.lisp"
"/rtl/rel4/user/brat.lisp"
"/rtl/rel4/user/setbitn.lisp"
"/rtl/rel4/user/land.lisp"
"/rtl/rel4/user/lxor.lisp"
"/rtl/rel4/user/ereps.lisp"
"/rtl/rel4/user/lior.lisp"
"/rtl/rel4/user/trunc.lisp"
"/rtl/rel4/user/bias.lisp"
"/rtl/rel4/user/lnot.lisp"
"/rtl/rel4/user/stick.lisp"
"/rtl/rel4/user/mulcat.lisp"
"/rtl/rel4/user/bvecp.lisp"
"/rtl/rel4/user/away.lisp"
"/rtl/rel4/user/logior1.lisp"
"/rtl/rel4/user/bits.lisp"
"/rtl/rel4/user/bitn.lisp"
"/rtl/rel4/user/near.lisp"
"/rtl/rel4/user/sumbits.lisp"
"/rtl/rel4/user/setbits.lisp"
"/rtl/rel4/user/cat.lisp"
"/proofstyles/completeness/stepwise-invariants-partial.lisp"
"/proofstyles/completeness/assertions-total.lisp"
"/proofstyles/completeness/generic-partial.lisp"
"/proofstyles/completeness/stepwise-invariants-total.lisp"
"/proofstyles/completeness/clock-partial.lisp"
"/proofstyles/completeness/clock-total.lisp"
"/proofstyles/completeness/generic-total.lisp"
"/proofstyles/completeness/assertions-partial.lisp"
"/proofstyles/invclock/compose/compose-c-c-total.lisp"
"/proofstyles/invclock/compose/compose-c-c-partial.lisp"
"/proofstyles/invclock/i2c/inv-to-clock.lisp"
"/proofstyles/invclock/i2c/i2c-total.lisp"
"/proofstyles/invclock/i2c/i2c-partial.lisp"
"/proofstyles/invclock/c2i/c2i-total.lisp"
"/proofstyles/invclock/c2i/c2i-partial.lisp"
"/proofstyles/invclock/c2i/clock-to-inv.lisp"
"/proofstyles/soundness/stepwise-invariants-partial.lisp"
"/proofstyles/soundness/assertions-total.lisp"
"/proofstyles/soundness/stepwise-invariants-total.lisp"
"/proofstyles/soundness/clock-partial.lisp"
"/proofstyles/soundness/clock-total.lisp"
"/proofstyles/soundness/assertions-partial.lisp"
"/proofstyles/counterexamples/memory-clearing.lisp"
"/proofstyles/counterexamples/halt-flg.lisp"
"/proofstyles/counterexamples/realistic.lisp"
"/coi/util/skip-rewrite.lisp"
"/coi/util/mv-nth.lisp"
"/coi/util/defsubtype.lisp"
"/coi/util/extra-info-test.lisp"
"/coi/util/fixequiv.lisp"
"/coi/util/ordinal-order.lisp"
"/coi/util/defdoc.lisp"
"/coi/util/nfixequiv.lisp"
"/coi/util/good-rewrite-order.lisp"
"/coi/util/rule-sets.lisp"
"/coi/util/ith.lisp"
"/coi/util/defun-support.lisp"
"/coi/util/implies.lisp"
"/coi/util/rule-sets-support.lisp"
"/coi/util/in-conclusion.lisp"
"/coi/util/syntaxp.lisp"
"/coi/util/debug.lisp"
"/coi/util/recursion-support.lisp"
"/coi/util/rewrite-equiv.lisp"
"/coi/util/ifixequiv.lisp"
"/coi/util/ifdef.lisp"
"/coi/util/table.lisp"
"/coi/util/extra-info.lisp"
"/coi/util/deffix.lisp"
"/coi/util/util-definitions.lisp"
"/coi/util/clause-processor.lisp"
"/coi/util/defun.lisp"
"/coi/util/pseudo-translate.lisp"
"/coi/termination/assuming/compiler.lisp"
"/coi/termination/assuming/zero.lisp"
"/coi/termination/assuming/complex.lisp"
"/coi/termination/assuming/compiler-proof.lisp"
"/coi/super-ihs/fast.lisp"
"/coi/super-ihs/c-functions.lisp"
"/coi/super-ihs/carry.lisp"
"/coi/super-ihs/logior-logapp-crock.lisp"
"/coi/super-ihs/meta.lisp"
"/coi/super-ihs/signed-byte-p-overflow.lisp"
"/coi/super-ihs/evenp.lisp"
"/coi/super-ihs/eric.lisp"
"/coi/super-ihs/iter-sqrt.lisp"
"/coi/super-ihs/plus-logapp-suck.lisp"
"/coi/super-ihs/super-ihs-definitions.lisp"
"/coi/super-ihs/super-ihs.lisp"
"/coi/super-ihs/logtail.lisp"
"/coi/super-ihs/loghead.lisp"
"/coi/super-ihs/inductions.lisp"
"/coi/dtrees/raw.lisp"
"/coi/dtrees/dtrees-definitions.lisp"
"/coi/dtrees/set.lisp"
"/coi/dtrees/leafp.lisp"
"/coi/dtrees/dtree-examples.lisp"
"/coi/dtrees/child.lisp"
"/coi/dtrees/deps.lisp"
"/coi/dtrees/royalp.lisp"
"/coi/dtrees/base.lisp"
"/coi/dtrees/erase.lisp"
"/coi/dtrees/equiv.lisp"
"/coi/bags/bags-definitions.lisp"
"/coi/bags/bind-free-rules.lisp"
"/coi/bags/cons.lisp"
"/coi/bags/meta.lisp"
"/coi/bags/two-level.lisp"
"/coi/bags/eric-meta.lisp"
"/coi/bags/two-level-meta.lisp"
"/coi/bags/basic.lisp"
"/coi/bags/pick-a-point.lisp"
"/coi/bags/neq.lisp"
"/coi/quantification/quantification.lisp"
"/coi/gacc/ram3.lisp"
"/coi/gacc/gacc3.lisp"
"/coi/gacc/ram2.lisp"
"/coi/gacc/list-ops-fast.lisp"
"/coi/gacc/ram.lisp"
"/coi/gacc/gax.lisp"
"/coi/gacc/mem.lisp"
"/coi/gacc/abstract-gacc.lisp"
"/coi/gacc/tr-path-connection.lisp"
"/coi/gacc/gacc.lisp"
"/coi/gacc/fr-path-connection.lisp"
"/coi/gacc/addr-range.lisp"
"/coi/gacc/list-ops.lisp"
"/coi/gacc/gacc-definitions.lisp"
"/coi/gacc/ram0.lisp"
"/coi/gacc/gacc2.lisp"
"/coi/gacc/ram2b.lisp"
"/coi/gacc/bits.lisp"
"/coi/gacc/wrap.lisp"
"/coi/gacc/finite.lisp"
"/coi/gacc/list-ops-common.lisp"
"/coi/gacc/block.lisp"
"/coi/gacc/mem-fast.lisp"
"/coi/gacc/mark.lisp"
"/coi/adviser/test.lisp"
"/coi/adviser/adviser-definitions.lisp"
"/coi/adviser/adviser.lisp"
"/coi/defpun/ack.lisp"
"/coi/defpun/defxch.lisp"
"/coi/defpun/defpun.lisp"
"/coi/defpun/defminterm.lisp"
"/coi/defpun/defpun-definitions.lisp"
"/coi/paths/paths-definitions.lisp"
"/coi/paths/cp-set.lisp"
"/coi/paths/meta.lisp"
"/coi/paths/dominates.lisp"
"/coi/paths/path.lisp"
"/coi/paths/diverge.lisp"
"/coi/paths/defs.lisp"
"/coi/paths/pm.lisp"
"/coi/paths/list-path-connection.lisp"
"/coi/paths/equiv.lisp"
"/coi/alists/bindequiv.lisp"
"/coi/alists/subkeyquiv.lisp"
"/coi/alists/preimage.lisp"
"/coi/alists/clearkey.lisp"
"/coi/alists/equiv.lisp"
"/coi/alists/alists-definitions.lisp"
"/coi/alists/deshadow.lisp"
"/coi/alists/keyquiv.lisp"
"/coi/osets/sets.lisp"
"/coi/osets/sort.lisp"
"/coi/osets/fast.lisp"
"/coi/osets/osets-definitions.lisp"
"/coi/osets/outer.lisp"
"/coi/osets/multicons.lisp"
"/coi/osets/multiappend.lisp"
"/coi/osets/instance.lisp"
"/coi/osets/primitives.lisp"
"/coi/osets/set-processor.lisp"
"/coi/osets/membership.lisp"
"/coi/osets/conversions.lisp"
"/coi/osets/computed-hints.lisp"
"/coi/osets/listsets.lisp"
"/coi/osets/quantify.lisp"
"/coi/osets/map.lisp"
"/coi/maps/maps-definitions.lisp"
"/coi/maps/maps.lisp"
"/coi/maps/typed-maps.lisp"
"/coi/symbol-fns/symbol-fns.lisp"
"/coi/symbol-fns/symbol-fns-definitions.lisp"
"/coi/records/set-domain.lisp"
"/coi/records/domain.lisp"
"/coi/records/fixedpoint.lisp"
"/coi/records/defrecord.lisp"
"/coi/records/defarray.lisp"
"/coi/records/defrecord-fast.lisp"
"/coi/records/mem-domain.lisp"
"/coi/records/records.lisp"
"/coi/records/records-definitions.lisp"
"/coi/records/fast/private.lisp"
"/coi/records/fast/memory-impl.lisp"
"/coi/records/fast/log2.lisp"
"/coi/records/fast/memory.lisp"
"/coi/records/fast/memtree.lisp"
"/coi/records/memory.lisp"
"/coi/gensym/gensym-list.lisp"
"/coi/gensym/gensym.lisp"
"/coi/defstructure/defstructure.lisp"
"/coi/defstructure/defstructure-definitions.lisp"
"/coi/nary/skip-rewrite.lisp"
"/coi/nary/nary-definitions.lisp"
"/coi/nary/ordinal-order.lisp"
"/coi/nary/nth-rules.lisp"
"/coi/nary/nary.lisp"
"/coi/nary/example.lisp"
"/coi/nary/rewrite-equal-hint.lisp"
"/coi/lists/mv-nth.lisp"
"/coi/lists/map-cons.lisp"
"/coi/lists/remove.lisp"
"/coi/lists/set.lisp"
"/coi/lists/nth-and-update-nth.lisp"
"/coi/lists/disjoint.lisp"
"/coi/lists/memberp.lisp"
"/coi/lists/subsetp.lisp"
"/coi/lists/basic.lisp"
"/coi/lists/find-index.lisp"
"/coi/lists/nth-meta2.lisp"
"/coi/lists/remove-induction.lisp"
"/coi/lists/listset-induction.lisp"
"/coi/lists/lists-definitions.lisp"
"/coi/lists/nth-meta.lisp"
"/coi/lists/repeat.lisp"
"/coi/overkill/overkill-definitions.lisp"
"/coi/overkill/bozo-ld.lisp"
"/coi/generalize/generalize.lisp"
"/coi/syntax/syntax-extensions.lisp"
"/coi/syntax/syntax.lisp"
"/coi/syntax/syntax-definitions.lisp"
"/coi/syntax/defbinding.lisp"
"/coi/syntax/auxilary.lisp"
"/coi/syntax/quine.lisp"
"/coi/syntax/defevaluator.lisp"
"/arithmetic-2/pass1/expt-helper.lisp"
"/arithmetic-2/pass1/numerator-and-denominator-helper.lisp"
"/arithmetic-2/floor-mod/floor-mod-helper.lisp"
"/arithmetic-2/floor-mod/floor-mod.lisp"
"/arithmetic-2/meta/integerp-meta.lisp"
"/arithmetic-2/meta/collect-terms-meta.lisp"
"/arithmetic-2/meta/cancel-terms-meta.lisp"
"/arithmetic-2/meta/common-meta.lisp"
"/arithmetic-2/meta/expt-helper.lisp"
"/centaur/misc/fal-graphs.lisp"
"/centaur/misc/osets-witnessing.lisp"
"/centaur/misc/smm-impl.lisp"
"/centaur/misc/equal-by-nths.lisp"
"/centaur/misc/u32-listp.lisp"
"/centaur/misc/tuplep.lisp"
"/centaur/misc/smm.lisp"
"/centaur/misc/suffixp.lisp"
"/centaur/misc/patterns.lisp"
"/centaur/misc/evaluator-metatheorems.lisp"
"/centaur/misc/interp-function-lookup.lisp"
"/centaur/misc/defapply.lisp"
"/centaur/misc/equal-sets.lisp"
"/centaur/misc/hons-alphorder-merge.lisp"
"/centaur/misc/tshell.lisp"
"/centaur/misc/alist-equiv.lisp"
"/centaur/misc/memory-mgmt-logic.lisp"
"/centaur/misc/load-stobj.lisp"
"/centaur/misc/hons-remove-dups.lisp"
"/centaur/misc/vecs-ints.lisp"
"/centaur/misc/ls.lisp"
"/centaur/misc/numlist.lisp"
"/centaur/misc/alist-defs.lisp"
"/centaur/misc/dfs-measure.lisp"
"/centaur/misc/lists.lisp"
"/centaur/misc/context-rw.lisp"
"/centaur/misc/universal-equiv.lisp"
"/centaur/misc/seed-random.lisp"
"/centaur/misc/nat-list-duplicates.lisp"
"/centaur/misc/hons-extra.lisp"
"/centaur/misc/fast-alists.lisp"
"/centaur/misc/introduce-var.lisp"
"/centaur/misc/arith-equivs.lisp"
"/centaur/misc/filter-alist.lisp"
"/centaur/misc/hons-sets.lisp"
"/centaur/misc/tailrec.lisp"
"/centaur/misc/absstobjs.lisp"
"/centaur/misc/date.lisp"
"/centaur/misc/mfc-utils.lisp"
"/centaur/vcd/esim-snapshot.lisp"
"/centaur/vcd/vcd-impl.lisp"
"/centaur/vcd/vcd-stub.lisp"
"/centaur/bitops/ash-bounds.lisp"
"/centaur/bitops/equal-by-logbitp.lisp"
"/centaur/bitops/ihs-extensions.lisp"
"/centaur/bitops/integer-length.lisp"
"/centaur/bitops/congruences.lisp"
"/centaur/bitops/extra-defs.lisp"
"/centaur/bitops/ihsext-basics.lisp"
"/centaur/bitops/install-bit.lisp"
"/centaur/bitops/bits-between.lisp"
"/centaur/bitops/bitsets.lisp"
"/centaur/bitops/part-select.lisp"
"/centaur/bitops/sign-extend.lisp"
"/centaur/bitops/rotate.lisp"
"/centaur/bitops/saturate.lisp"
"/centaur/bitops/sbitsets.lisp"
"/centaur/bitops/bitsets-opt.lisp"
"/centaur/defrstobj/typed-records.lisp"
"/centaur/defrstobj/groundwork/demo5.lisp"
"/centaur/defrstobj/groundwork/demo2.lisp"
"/centaur/defrstobj/groundwork/array-rec.lisp"
"/centaur/defrstobj/groundwork/demo4.lisp"
"/centaur/defrstobj/groundwork/demo1.lisp"
"/centaur/defrstobj/groundwork/demo3.lisp"
"/centaur/defrstobj/g-delete-keys.lisp"
"/centaur/defrstobj/def-typed-record.lisp"
"/centaur/defrstobj/defrstobj.lisp"
"/centaur/defrstobj/fancy-worseguy.lisp"
"/centaur/4v-sexpr/g-sexpr-eval.lisp"
"/centaur/4v-sexpr/svarmap.lisp"
"/centaur/4v-sexpr/onehot-rewrite.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint-rewriting.lisp"
"/centaur/4v-sexpr/sexpr-rewrites.lisp"
"/centaur/4v-sexpr/sexpr-building.lisp"
"/centaur/4v-sexpr/sexpr-vars-1pass.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint-correct.lisp"
"/centaur/4v-sexpr/sexpr-vars.lisp"
"/centaur/4v-sexpr/bitspecs.lisp"
"/centaur/4v-sexpr/compose-sexpr.lisp"
"/centaur/4v-sexpr/sexpr-eval.lisp"
"/centaur/4v-sexpr/nsexprs.lisp"
"/centaur/4v-sexpr/sexpr-loop-debug.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint.lisp"
"/centaur/4v-sexpr/sexpr-equivs.lisp"
"/centaur/4v-sexpr/sexpr-to-faig.lisp"
"/centaur/4v-sexpr/sexpr-3v.lisp"
"/centaur/4v-sexpr/4v-logic.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint-spec.lisp"
"/centaur/esim/esim-paths.lisp"
"/centaur/esim/esim-vcd.lisp"
"/centaur/esim/esim-vl.lisp"
"/centaur/esim/steps.lisp"
"/centaur/esim/esim-spec.lisp"
"/centaur/esim/stv/stv-debug.lisp"
"/centaur/esim/stv/stv-run.lisp"
"/centaur/esim/stv/stv-doc.lisp"
"/centaur/esim/stv/stv-compile.lisp"
"/centaur/esim/stv/stv-expand.lisp"
"/centaur/esim/stv/stv-top.lisp"
"/centaur/esim/stv/stv-widen.lisp"
"/centaur/esim/stv/stv-util.lisp"
"/centaur/esim/stv/stv-sim.lisp"
"/centaur/esim/esim-sexpr-support.lisp"
"/centaur/esim/follow-backwards.lisp"
"/centaur/esim/esim-sexpr.lisp"
"/centaur/esim/plist.lisp"
"/centaur/esim/esim-sexpr-correct.lisp"
"/centaur/esim/esim-sexpr-support-thms.lisp"
"/centaur/aig/witness.lisp"
"/centaur/aig/aig-vars-ext.lisp"
"/centaur/aig/misc.lisp"
"/centaur/aig/bddify-correct.lisp"
"/centaur/aig/induction.lisp"
"/centaur/aig/vuaig.lisp"
"/centaur/aig/eval-restrict.lisp"
"/centaur/aig/bddify.lisp"
"/centaur/aig/three-four.lisp"
"/centaur/aig/base.lisp"
"/centaur/aig/aiger.lisp"
"/centaur/aig/g-aig-eval.lisp"
"/centaur/tutorial/alu16-book.lisp"
"/centaur/vl/util/position.lisp"
"/centaur/vl/util/prefix-hash.lisp"
"/centaur/vl/util/commentmap.lisp"
"/centaur/vl/util/string-alists.lisp"
"/centaur/vl/util/namedb.lisp"
"/centaur/vl/util/nat-alists.lisp"
"/centaur/vl/util/gc.lisp"
"/centaur/vl/util/toposort.lisp"
"/centaur/vl/util/arithmetic.lisp"
"/centaur/vl/util/print-htmlencode.lisp"
"/centaur/vl/util/defwellformed.lisp"
"/centaur/vl/util/echars.lisp"
"/centaur/vl/util/defs.lisp"
"/centaur/vl/util/prefixp.lisp"
"/centaur/vl/util/character-list-listp.lisp"
"/centaur/vl/util/cw-unformatted.lisp"
"/centaur/vl/util/print.lisp"
"/centaur/vl/util/next-power-of-2.lisp"
"/centaur/vl/util/sum-nats.lisp"
"/centaur/vl/util/print-urlencode.lisp"
"/centaur/vl/util/intersectp-equal.lisp"
"/centaur/vl/util/osets.lisp"
"/centaur/vl/lint/xf-undefined-names.lisp"
"/centaur/vl/lint/lint.lisp"
"/centaur/vl/lint/disconnected.lisp"
"/centaur/vl/lint/xf-remove-toohard.lisp"
"/centaur/vl/lint/xf-drop-unresolved-submodules.lisp"
"/centaur/vl/lint/bit-use-set.lisp"
"/centaur/vl/lint/xf-lint-stmt-rewrite.lisp"
"/centaur/vl/lint/xf-drop-missing-submodules.lisp"
"/centaur/vl/lint/check-case.lisp"
"/centaur/vl/lint/check-namespace.lisp"
"/centaur/vl/lint/use-set-ignore.lisp"
"/centaur/vl/lint/xf-suppress-warnings.lisp"
"/centaur/vl/onehot.lisp"
"/centaur/vl/parsetree.lisp"
"/centaur/vl/primitives.lisp"
"/centaur/vl/wf-reasonable-p.lisp"
"/centaur/vl/translation.lisp"
"/centaur/vl/top.lisp"
"/centaur/vl/checkers/condcheck.lisp"
"/centaur/vl/checkers/dupeinst-check.lisp"
"/centaur/vl/checkers/use-set-report.lisp"
"/centaur/vl/checkers/multidrive-detect.lisp"
"/centaur/vl/checkers/oddexpr.lisp"
"/centaur/vl/checkers/duperhs.lisp"
"/centaur/vl/checkers/duplicate-detect.lisp"
"/centaur/vl/checkers/use-set-tool.lisp"
"/centaur/vl/checkers/leftright.lisp"
"/centaur/vl/checkers/typo-detect.lisp"
"/centaur/vl/checkers/use-set.lisp"
"/centaur/vl/checkers/selfassigns.lisp"
"/centaur/vl/checkers/portcheck.lisp"
"/centaur/vl/checkers/qmarksize-check.lisp"
"/centaur/vl/checkers/skip-detect.lisp"
"/centaur/vl/loader/find-file.lisp"
"/centaur/vl/loader/parse-expressions-def.lisp"
"/centaur/vl/loader/parse-error.lisp"
"/centaur/vl/loader/read-file.lisp"
"/centaur/vl/loader/parse-utils.lisp"
"/centaur/vl/loader/make-implicit-wires.lisp"
"/centaur/vl/loader/parse-modules.lisp"
"/centaur/vl/loader/parse-nets.lisp"
"/centaur/vl/loader/preprocessor.lisp"
"/centaur/vl/loader/parse-gates.lisp"
"/centaur/vl/loader/lexer.lisp"
"/centaur/vl/loader/parser.lisp"
"/centaur/vl/loader/parse-statements-def.lisp"
"/centaur/vl/loader/parse-insts.lisp"
"/centaur/vl/loader/loader.lisp"
"/centaur/vl/loader/parse-blockitems.lisp"
"/centaur/vl/loader/defines.lisp"
"/centaur/vl/loader/parse-expressions.lisp"
"/centaur/vl/loader/parse-expressions-error.lisp"
"/centaur/vl/loader/parse-expressions-progress.lisp"
"/centaur/vl/loader/parse-expressions-eof.lisp"
"/centaur/vl/loader/parse-ranges.lisp"
"/centaur/vl/loader/lexer-utils.lisp"
"/centaur/vl/loader/parse-expressions-tokenlist.lisp"
"/centaur/vl/loader/parse-functions.lisp"
"/centaur/vl/loader/lexer-tests.lisp"
"/centaur/vl/loader/overrides.lisp"
"/centaur/vl/loader/inject-comments.lisp"
"/centaur/vl/loader/lexer-tokens.lisp"
"/centaur/vl/loader/filemap.lisp"
"/centaur/vl/loader/parse-expressions-result.lisp"
"/centaur/vl/loader/parse-expressions-warnings.lisp"
"/centaur/vl/loader/parse-ports.lisp"
"/centaur/vl/loader/parse-statements-result.lisp"
"/centaur/vl/transforms/xf-optimize-rw.lisp"
"/centaur/vl/transforms/xf-expand-functions.lisp"
"/centaur/vl/transforms/xf-resolve-ranges.lisp"
"/centaur/vl/transforms/xf-orig.lisp"
"/centaur/vl/transforms/xf-follow-hids.lisp"
"/centaur/vl/transforms/xf-propagate.lisp"
"/centaur/vl/transforms/xf-gate-elim.lisp"
"/centaur/vl/transforms/xf-expr-simp.lisp"
"/centaur/vl/transforms/xf-weirdint-elim.lisp"
"/centaur/vl/transforms/xf-designregs.lisp"
"/centaur/vl/transforms/xf-array-indexing.lisp"
"/centaur/vl/transforms/xf-unparameterize.lisp"
"/centaur/vl/transforms/xf-subst.lisp"
"/centaur/vl/transforms/xf-oprewrite.lisp"
"/centaur/vl/transforms/xf-argresolve.lisp"
"/centaur/vl/transforms/xf-gatesplit.lisp"
"/centaur/vl/transforms/xf-blankargs.lisp"
"/centaur/vl/transforms/xf-elim-supply.lisp"
"/centaur/vl/transforms/xf-sizing.lisp"
"/centaur/vl/transforms/always/unelse.lisp"
"/centaur/vl/transforms/always/ifmerge.lisp"
"/centaur/vl/transforms/always/elimnegedge.lisp"
"/centaur/vl/transforms/always/stmttemps.lisp"
"/centaur/vl/transforms/always/stmtrewrite.lisp"
"/centaur/vl/transforms/xf-replicate-insts.lisp"
"/centaur/vl/transforms/xf-clean-selects.lisp"
"/centaur/vl/transforms/xf-clean-params.lisp"
"/centaur/vl/transforms/xf-hid-elim.lisp"
"/centaur/vl/transforms/xf-expr-split.lisp"
"/centaur/vl/transforms/xf-inline.lisp"
"/centaur/vl/transforms/occform/top.lisp"
"/centaur/vl/transforms/occform/util.lisp"
"/centaur/vl/transforms/cn-hooks.lisp"
"/centaur/vl/transforms/xf-gateredux.lisp"
"/centaur/vl/toe/toe-preliminary.lisp"
"/centaur/vl/toe/toe-verilogify.lisp"
"/centaur/vl/toe/toe-add-zdrivers.lisp"
"/centaur/vl/toe/toe-emodwire.lisp"
"/centaur/vl/toe/toe-add-res-modules.lisp"
"/centaur/vl/toe/toe-wirealist.lisp"
"/centaur/vl/toe/toe-eocc-allnames.lisp"
"/centaur/vl/toe/toe-top.lisp"
"/centaur/vl/mlib/stmt-tools.lisp"
"/centaur/vl/mlib/expr-tools.lisp"
"/centaur/vl/mlib/writer.lisp"
"/centaur/vl/mlib/namefactory.lisp"
"/centaur/vl/mlib/comment-writer.lisp"
"/centaur/vl/mlib/namemangle.lisp"
"/centaur/vl/mlib/find-item.lisp"
"/centaur/vl/mlib/sub-counts.lisp"
"/centaur/vl/mlib/rvalues.lisp"
"/centaur/vl/mlib/expr-parse.lisp"
"/centaur/vl/mlib/hierarchy.lisp"
"/centaur/vl/mlib/lvalues-mentioning.lisp"
"/centaur/vl/mlib/range-tools.lisp"
"/centaur/vl/mlib/allexprs.lisp"
"/centaur/vl/mlib/context.lisp"
"/centaur/vl/mlib/expr-building.lisp"
"/centaur/vl/mlib/warnings.lisp"
"/centaur/vl/mlib/modnamespace.lisp"
"/centaur/vl/mlib/print-context.lisp"
"/centaur/vl/mlib/expr-slice.lisp"
"/centaur/vl/mlib/print-warnings.lisp"
"/centaur/vl/mlib/welltyped.lisp"
"/centaur/vl/mlib/port-tools.lisp"
"/centaur/vl/mlib/atts.lisp"
"/centaur/vl/mlib/fmt.lisp"
"/centaur/vl/mlib/lvalues.lisp"
"/centaur/vl/mlib/remove-bad.lisp"
"/centaur/vl/mlib/clean-concats.lisp"
"/centaur/vl/mlib/ram-tools.lisp"
"/centaur/vl/mlib/ctxexprs.lisp"
"/centaur/vl/mlib/filter.lisp"
"/centaur/vl/mlib/find-module.lisp"
"/centaur/vl/mlib/hid-tools.lisp"
"/centaur/gl/g-rem.lisp"
"/centaur/gl/run-gified-cp.lisp"
"/centaur/gl/general-objects.lisp"
"/centaur/gl/g-mod.lisp"
"/centaur/gl/bfr-sat.lisp"
"/centaur/gl/g-lessthan.lisp"
"/centaur/gl/g-equal.lisp"
"/centaur/gl/g-binary-mult.lisp"
"/centaur/gl/defagg.lisp"
"/centaur/gl/gobject-types.lisp"
"/centaur/gl/g-logior.lisp"
"/centaur/gl/def-gl-clause-proc.lisp"
"/centaur/gl/g-truncate.lisp"
"/centaur/gl/gl-util.lisp"
"/centaur/gl/generic-geval.lisp"
"/centaur/gl/defapply.lisp"
"/centaur/gl/hyp-fix.lisp"
"/centaur/gl/g-binary-+.lisp"
"/centaur/gl/symbolic-arithmetic.lisp"
"/centaur/gl/glcp-templates.lisp"
"/centaur/gl/shape-spec.lisp"
"/centaur/gl/g-logbitp.lisp"
"/centaur/gl/gobjectp.lisp"
"/centaur/gl/gify-clause-proc.lisp"
"/centaur/gl/symbolic-arithmetic-fns.lisp"
"/centaur/gl/g-predicates.lisp"
"/centaur/gl/g-coerce.lisp"
"/centaur/gl/gl-misc-defs.lisp"
"/centaur/gl/eval-f-i-cp.lisp"
"/centaur/gl/always-equal-prep.lisp"
"/centaur/gl/factor-fns.lisp"
"/centaur/gl/gtypes.lisp"
"/centaur/gl/g-logand.lisp"
"/centaur/gl/g-code-char.lisp"
"/centaur/gl/general-object-thms.lisp"
"/centaur/gl/bfr.lisp"
"/centaur/gl/gtype-thms.lisp"
"/centaur/gl/g-floor.lisp"
"/centaur/gl/gl.lisp"
"/centaur/gl/bfr-aig-bddify.lisp"
"/centaur/gl/g-ash.lisp"
"/centaur/gl/g-primitives-help.lisp"
"/centaur/gl/g-if.lisp"
"/centaur/gl/auto-bindings.lisp"
"/centaur/gl/gify.lisp"
"/centaur/gl/gtests.lisp"
"/centaur/gl/ite-merge.lisp"
"/centaur/gl/rws.lisp"
"/centaur/gl/gobjectp-thms.lisp"
"/centaur/gl/gl-generic-clause-proc.lisp"
"/centaur/gl/param.lisp"
"/centaur/gl/bvecs.lisp"
"/centaur/gl/g-unary-concrete.lisp"
"/centaur/bridge/to-json.lisp"
"/centaur/bridge/top.lisp"
"/centaur/ubdds/witness.lisp"
"/centaur/ubdds/sanity-check-macros.lisp"
"/centaur/ubdds/extra-operations.lisp"
"/centaur/ubdds/core.lisp"
"/centaur/ubdds/subset.lisp"
"/centaur/ubdds/param.lisp"
"/powerlists/algebra.lisp"~
"/powerlists/sort.lisp"
"/powerlists/gray-code.lisp"
"/powerlists/merge-sort.lisp"
"/powerlists/prefix-sum.lisp"
"/powerlists/batcher-sort.lisp"
"/powerlists/algebra.lisp"
"/powerlists/simple.lisp"
"/powerlists/cla-adder.lisp"
"/powerlists/bitonic-sort.lisp"
"/ordinals/e0-ordinal.lisp"
"/ordinals/lexicographic-book.lisp"
"/ordinals/ordinal-isomorphism.lisp"
"/ordinals/ordinal-addition.lisp"
"/ordinals/proof-of-well-foundedness.lisp"
"/ordinals/ordinal-multiplication.lisp"
"/ordinals/ordinal-definitions.lisp"
"/ordinals/ordinal-exponentiation.lisp"
"/tutorial-problems/introductory-challenge-problem-4.lisp"
"/tutorial-problems/introductory-challenge-problem-4-athena.lisp"
"/xdoc/names.lisp"
"/xdoc/book-thms.lisp"
"/xdoc/top.lisp"
"/xdoc/defxdoc-raw.lisp"
"/xdoc/defsection-tests.lisp"
"/xdoc/base.lisp"
"/xdoc/book-thms-example.lisp"
"/fix-cert/test1pp.lisp"
"/fix-cert/test2.lisp"
"/fix-cert/test1bp.lisp"
"/fix-cert/test1bb.lisp"
"/fix-cert/moved/test1pp.lisp"
"/fix-cert/moved/test2.lisp"
"/fix-cert/moved/test1bp.lisp"
"/fix-cert/moved/test1bb.lisp"
"/fix-cert/moved/test1pb.lisp"
"/fix-cert/moved/test1.lisp"
"/fix-cert/moved/test1b.lisp"
"/fix-cert/moved/test1p.lisp"
"/fix-cert/test1pb.lisp"
"/fix-cert/test1.lisp"
"/fix-cert/test1b.lisp"
"/fix-cert/fix-cert.lisp"
"/fix-cert/test1p.lisp"
"/taspi/tree-score/opt-pairwise.lisp"
"/taspi/tree-score/min-length.lisp"
"/taspi/tree-score/efficient-pscores.lisp"
"/taspi/tree-score/costs.lisp"
"/taspi/tree-score/ambig-score.lisp"
"/taspi/tree-score/efficient-pscores-help.lisp"
"/taspi/tree-score/circle-scoring.lisp"
"/taspi/tree-score/pscores.lisp"
"/taspi/tree-score/fitch-scoring.lisp"
"/taspi/sets-input/tree-compat.lisp"
"/taspi/sets-input/tree-support-in-set.lisp"
"/taspi/sets-input/mct.lisp"
"/taspi/sets-input/greedy.lisp"
"/taspi/sets-input/consensus.lisp"
"/taspi/sets-input/multipolar-loose.lisp"
"/taspi/sets-input/mast.lisp"
"/taspi/single-input/taxa-based.lisp"
"/taspi/single-input/tree-stats.lisp"
"/taspi/examples/examples.lisp"
"/taspi/proofs/sets.lisp"
"/taspi/proofs/omerge-good-order.lisp"
"/taspi/proofs/fringes-taspi.lisp"
"/taspi/code/gen-helper/sets.lisp"
"/taspi/code/gen-helper/extra.lisp"
"/taspi/code/gen-helper/bdd-functions.lisp"
"/taspi/code/gen-helper/fast-lists.lisp"
"/taspi/code/fringes/fringes-guards.lisp"
"/taspi/code/fringes/fringes.lisp"
"/taspi/code/build/build-term.lisp"
"/taspi/code/build/build-term-guards.lisp"
"/taspi/code/replete/replete-guards.lisp"
"/taspi/code/replete/replete-helper.lisp"
"/taspi/code/replete/replete.lisp"
"/taspi/code/tree-manip/merge-based-sort.lisp"
"/taspi/code/tree-manip/mv-root.lisp"
"/taspi/code/tree-manip/quicksort.lisp"
"/taspi/code/tree-manip/insertion-based-sort.lisp"
"/taspi/code/tree-manip/sort-help.lisp"
"/taspi/code/gen-trees/tree-predicates.lisp"
"/taspi/code/gen-trees/btrees.lisp"
"/taspi/code/gen-trees/sets-lists-trees.lisp"
"/taspi/code/gen-trees/btrees-bdds.lisp"
"/taspi/code/sequences/align.lisp"
"/taspi/code/sequences/p-inform.lisp"
"/taspi/code/sequences/seqs.lisp"
"/taspi/code/brlens/brlens.lisp"
"/taspi/code/brlens/trees-with-brlens.lisp"
"/taspi/read-write/write-trees.lisp"
"/taspi/read-write/newick.lisp"
"/taspi/tree-distance/symm-diff.lisp"
"/taspi/tree-distance/rf.lisp"
"/taspi/tree-generation/heuristics/do-search.lisp"
"/taspi/tree-generation/heuristics/spr.lisp"
"/taspi/tree-generation/heuristics/tbr.lisp"
"/taspi/tree-generation/distance-based/naive-quartet-method.lisp"
"/taspi/tree-generation/tree-gen-helper/basics.lisp"
"/taspi/tree-generation/branch-and-bound/bandb.lisp"
"/taspi/database/entry.lisp"
"/taspi/database/filters.lisp"
"/taspi/database/db.lisp"
"/taspi/database/db-from-list.lisp"
"/taspi/database/props.lisp"
"/hints/huet-lang-algorithm-tests.lisp"
"/hints/consider-hint-tests.lisp"
"/hints/consider-hint.lisp"
"/hints/huet-lang-algorithm.lisp"
"/hints/merge-hint.lisp"
"/hints/basic-tests.lisp"
"/finite-set-theory/total-ordering.lisp"
"/finite-set-theory/osets/sets.lisp"
"/finite-set-theory/osets/sort.lisp"
"/finite-set-theory/osets/map-tests.lisp"
"/finite-set-theory/osets/difference.lisp"
"/finite-set-theory/osets/intersect.lisp"
"/finite-set-theory/osets/instance.lisp"
"/finite-set-theory/osets/primitives.lisp"
"/finite-set-theory/osets/membership.lisp"
"/finite-set-theory/osets/computed-hints.lisp"
"/finite-set-theory/osets/delete.lisp"
"/finite-set-theory/osets/cardinality.lisp"
"/finite-set-theory/osets/quantify.lisp"
"/finite-set-theory/osets/map.lisp"
"/finite-set-theory/osets/union.lisp"
"/finite-set-theory/set-theory.lisp"
"/ihs/@logops.lisp"
"/ihs/math-lemmas.lisp"
"/ihs/ihs-theories.lisp"
"/ihs/ihs-init.lisp"
"/ihs/logops-lemmas.lisp"
"/ihs/quotient-remainder-lemmas.lisp"
"/ihs/basic-definitions.lisp"
"/ihs/logops-definitions.lisp"
"/clause-processors/meta-extract-simple-test.lisp"
"/clause-processors/stobj-preservation.lisp"
"/clause-processors/nvalues-thms.lisp"
"/clause-processors/witness-cp.lisp"
"/clause-processors/decomp-hint.lisp"
"/clause-processors/autohide.lisp"
"/clause-processors/equality.lisp"
"/clause-processors/basic-examples.lisp"
"/clause-processors/instantiate.lisp"
"/clause-processors/replace-defined-consts.lisp"
"/clause-processors/replace-impl.lisp"
"/clause-processors/sublis-var-meaning.lisp"
"/clause-processors/SULFA/books/sat/check-output.lisp"
"/clause-processors/SULFA/books/sat/neq-implication.lisp"
"/clause-processors/SULFA/books/sat/convert-to-cnf.lisp"
"/clause-processors/SULFA/books/sat/recognizer.lisp"
"/clause-processors/SULFA/books/sat/user-entry-data-structure.lisp"
"/clause-processors/SULFA/books/sat/sat.lisp"
"/clause-processors/SULFA/books/sat/sat-setup.lisp"
"/clause-processors/SULFA/books/sat/local-clause-simp.lisp"
"/clause-processors/SULFA/books/bv-smt-solver/bv-lib-lemmas.lisp"
"/clause-processors/SULFA/books/bv-smt-solver/redundancy-removal.lisp"
"/clause-processors/SULFA/books/bv-smt-solver/smt.lisp"
"/clause-processors/SULFA/books/bv-smt-solver/translation.lisp"
"/clause-processors/SULFA/books/bv-smt-solver/bv-lib-definitions.lisp"
"/clause-processors/SULFA/books/clause-processors/sym-str.lisp"
"/clause-processors/SULFA/books/clause-processors/sat-clause-processor.lisp"
"/clause-processors/SULFA/books/sat-tests/test-help.lisp"
"/clause-processors/SULFA/books/sat-tests/test-incremental.lisp"
"/clause-processors/SULFA/books/sat-tests/sudoku.lisp"
"/clause-processors/SULFA/books/sat-tests/benchmark.lisp"
"/clause-processors/SULFA/books/sat-tests/tutorial.lisp"
"/clause-processors/generalize.lisp"
"/clause-processors/meta-extract-user.lisp"
"/clause-processors/multi-env-trick.lisp"
"/clause-processors/join-thms.lisp"
"/clause-processors/find-subterms.lisp"
"/clause-processors/use-by-hint.lisp"
"/clause-processors/bv-add-common.lisp"
"/clause-processors/bv-add-tests.lisp"
"/clause-processors/null-fail-hints.lisp"
"/clause-processors/just-expand.lisp"
"/clause-processors/bv-add.lisp"
"/clause-processors/term-patterns.lisp"
"/clause-processors/unify-subst.lisp"
"/defexec/ordinals/supporting-ordinals.lisp"
"/defexec/reflexive/reflexive.lisp"
"/defexec/dag-unification/list-unification-rules.lisp"
"/defexec/dag-unification/matching.lisp"
"/defexec/dag-unification/terms-dag-stobj.lisp"
"/defexec/dag-unification/terms-as-dag.lisp"
"/defexec/dag-unification/basic.lisp"
"/defexec/dag-unification/subsumption.lisp"
"/defexec/dag-unification/dags.lisp"
"/defexec/dag-unification/dag-unification-st.lisp"
"/defexec/dag-unification/terms.lisp"
"/defexec/dag-unification/dag-unification-rules.lisp"
"/defexec/dag-unification/subsumption-subst.lisp"
"/defexec/dag-unification/dag-unification-l.lisp"
"/defexec/find-path/fpst.lisp"
"/defexec/find-path/run-fpst.lisp"
"/defexec/find-path/graph/find-path2.lisp"
"/defexec/find-path/graph/linear-find-path.lisp"
"/defexec/find-path/graph/helpers.lisp"
"/defexec/find-path/graph/find-path1.lisp"
"/defexec/find-path/graph/find-path3.lisp"
"/defexec/defpun-exec/defpun-exec.lisp"
"/defexec/other-apps/misc/memos.lisp"
"/defexec/other-apps/misc/stobjsim.lisp"
"/defexec/other-apps/qsort/intermediate-program.lisp"
"/defexec/other-apps/qsort/merge-intermediate.lisp"
"/defexec/other-apps/qsort/permutations.lisp"
"/defexec/other-apps/qsort/load-extract.lisp"
"/defexec/other-apps/qsort/final-theorem.lisp"
"/defexec/other-apps/qsort/total-order.lisp"
"/defexec/other-apps/qsort/programs.lisp"
"/defexec/other-apps/qsort/first-last.lisp"
"/defexec/other-apps/qsort/spec-properties.lisp"
"/defexec/other-apps/qsort/intermediate-to-spec.lisp"
"/defexec/other-apps/records/recordsim.lisp"
"/defexec/other-apps/records/records.lisp"
"/defexec/other-apps/records/inline.lisp"
"/symbolic/tiny-triangle/tiny-triangle-correct.lisp"
"/symbolic/tiny-triangle/triangle-def.lisp"
"/symbolic/tiny-fib/fib-def.lisp"
"/symbolic/tiny-fib/defstobj+.lisp"
"/symbolic/tiny-fib/tiny.lisp"
"/symbolic/tiny-fib/tiny-rewrites.lisp"
"/symbolic/m5/utilities.lisp"
"/symbolic/m5/demo.lisp"
"/symbolic/generic/factorial-jvm-correct.lisp"
"/symbolic/generic/assertions.lisp"
"/symbolic/generic/defsimulate.lisp"
"/symbolic/generic/measures.lisp"
"/symbolic/generic/tiny-fib-correct.lisp"
"/symbolic/generic/total-correctness.lisp"
"/symbolic/generic/partial-correctness.lisp"
"/countereg-gen/type.lisp"
"/countereg-gen/num-list-fns.lisp"
"/countereg-gen/graph.lisp"
"/countereg-gen/random-state.lisp"
"/countereg-gen/random.lisp"
"/countereg-gen/utilities.lisp"
"/countereg-gen/with-timeout.lisp"
"/countereg-gen/simple-graph-array.lisp"
"/countereg-gen/splitnat.lisp"
"/countereg-gen/random-state-basis1.lisp"
"/countereg-gen/data.lisp"
"/countereg-gen/acl2s-parameter.lisp"
"/countereg-gen/basis.lisp"
"/countereg-gen/base.lisp"
"/countereg-gen/switchnat.lisp"
"/countereg-gen/main.lisp"
"/countereg-gen/mv-proof.lisp"
"/defsort/uniquep.lisp"
"/defsort/duplicated-members.lisp"
"/defsort/remove-dups.lisp"
"/defsort/generic-impl.lisp"
"/defsort/examples.lisp"
"/defsort/duplicity.lisp"
"/defsort/defsort.lisp"
"/defsort/generic.lisp"
"/str/strnatless.lisp"
"/str/strsplit.lisp"
"/str/char-case.lisp"
"/str/strrpos.lisp"
"/str/natstr.lisp"
"/str/iprefixp.lisp"
"/str/html-encode.lisp"
"/str/case-conversion.lisp"
"/str/stringify.lisp"
"/str/eqv.lisp"
"/str/isubstrp.lisp"
"/str/iless.lisp"
"/str/arithmetic.lisp"
"/str/digitp.lisp"
"/str/strval.lisp"
"/str/hexify.lisp"
"/str/fast-cat.lisp"
"/str/strsubst.lisp"
"/str/firstn-chars.lisp"
"/str/strpos.lisp"
"/str/prefix-lines.lisp"
"/str/ieqv.lisp"
"/str/istrpos.lisp"
"/str/strtok.lisp"
"/str/cat.lisp"
"/str/strline.lisp"
"/str/strprefixp.lisp"
"/str/pad.lisp"
"/str/istrprefixp.lisp"
"/cowles/acl2-crg.lisp"
"/cowles/acl2-agp.lisp"
"/cowles/acl2-asg.lisp"
"/xdoc-impl/sort.lisp"
"/xdoc-impl/display.lisp"
"/xdoc-impl/preprocess.lisp"
"/xdoc-impl/mkdir-raw.lisp"
"/xdoc-impl/save.lisp"
"/xdoc-impl/parse-xml.lisp"
"/xdoc-impl/mkdir.lisp"
"/xdoc-impl/write-acl2-xdoc.lisp"
"/xdoc-impl/autolink.lisp"
"/xdoc-impl/topics.lisp"
"/xdoc-impl/import-acl2doc.lisp"
"/xdoc-impl/fmt-to-str.lisp"
"/models/jvm/m1/sign.lisp"
"/models/jvm/m1/implementation.lisp"
"/models/jvm/m1/defsys-utilities.lisp"
"/models/jvm/m1/funny-fact.lisp"
"/models/jvm/m1/wormhole-abstraction.lisp"
"/models/jvm/m1/alternating-sum-variant.lisp"
"/models/jvm/m1/sumsq.lisp"
"/models/jvm/m1/sum.lisp"
"/models/jvm/m1/theorems-a-and-b.lisp"
"/models/jvm/m1/even-solution-2.lisp"
"/models/jvm/m1/power.lisp"
"/models/jvm/m1/defsys.lisp"
"/models/jvm/m1/div.lisp"
"/models/jvm/m1/magic.lisp"
"/models/jvm/m1/lessp.lisp"
"/models/jvm/m1/tmi-reductions.lisp"
"/models/jvm/m1/expt.lisp"
"/models/jvm/m1/find-k!.lisp"
"/models/jvm/m1/template.lisp"
"/models/jvm/m1/low-seven.lisp"
"/models/jvm/m1/fact.lisp"
"/models/jvm/m1/alternating-sum.lisp"
"/models/jvm/m1/fib.lisp"
"/models/jvm/m1/bexpt.lisp"
"/models/jvm/m1/m1.lisp"
"/models/jvm/m1/even-solution-1.lisp"
"/models/jvm/m5/partial.lisp"
"/models/jvm/m5/utilities.lisp"
"/models/jvm/m5/universal-never-returns.lisp"
"/models/jvm/m5/idemo.lisp"
"/models/jvm/m5/apprentice-state.lisp"
"/models/jvm/m5/infinite-fair-schedule.lisp"
"/models/jvm/m5/perm.lisp"
"/models/jvm/m5/isort.lisp"
"/models/jvm/m5/m5.lisp"
"/models/jvm/m5/universal.lisp"
"/models/jvm/m5/apprentice.lisp"
"/models/jvm/m5/jvm-fact-setup.lisp"
"/models/jvm/m5/demo.lisp"
"/models/jvm/m1-original/m1-story.lisp"
"/models/jvm/m1-original/problem-set-1-answers.lisp"
"/models/y86/y86-basic/py86/popcount.lisp"
"/models/y86/y86-basic/py86/py86.lisp"
"/models/y86/y86-basic/py86/py86-state.lisp"
"/models/y86/y86-basic/py86/fib.lisp"
"/models/y86/y86-basic/py86/py86-mem-init.lisp"
"/models/y86/y86-basic/y86/y86-mem-init.lisp"
"/models/y86/y86-basic/y86/y86.lisp"
"/models/y86/y86-basic/y86/y86-asm.lisp"
"/models/y86/y86-basic/common/misc-events.lisp"
"/models/y86/y86-basic/common/constants.lisp"
"/models/y86/y86-basic/common/x86-state.lisp"
"/models/y86/y86-basic/common/operations.lisp"
"/models/y86/y86-two-level/y86/y86.lisp"
"/models/y86/y86-two-level/y86/y86-asm.lisp"
"/models/y86/y86-two-level/common/arithmetic-5++.lisp"
"/models/y86/y86-two-level/common/x86-memory-low.lisp"
"/models/y86/y86-two-level/common/misc-events.lisp"
"/models/y86/y86-two-level/common/constants.lisp"
"/models/y86/y86-two-level/common/x86-state.lisp"
"/models/y86/y86-two-level/common/operations.lisp"
"/models/y86/y86-two-level-abs/examples/popcount.lisp"
"/models/y86/y86-two-level-abs/examples/popcount-demo.lisp"
"/models/y86/y86-two-level-abs/y86/y86-mem-init.lisp"
"/models/y86/y86-two-level-abs/y86/y86.lisp"
"/models/y86/y86-two-level-abs/y86/y86-asm.lisp"
"/models/y86/y86-two-level-abs/common/arithmetic-5++.lisp"
"/models/y86/y86-two-level-abs/common/x86-memory.lisp"
"/models/y86/y86-two-level-abs/common/x86-memory-low.lisp"
"/models/y86/y86-two-level-abs/common/x86-state-defabsstobj.lisp"
"/models/y86/y86-two-level-abs/common/misc-events.lisp"
"/models/y86/y86-two-level-abs/common/x86-state-concrete.lisp"
"/models/y86/y86-two-level-abs/common/x86-memory-high.lisp"
"/models/y86/y86-two-level-abs/common/constants.lisp"
"/models/y86/y86-two-level-abs/common/x86-state.lisp"
"/models/y86/y86-two-level-abs/common/operations.lisp"
"/regex/regex-exec.lisp"
"/regex/grep-command-line.lisp"
"/regex/input-list.lisp"
"/regex/defset-macros.lisp"
"/regex/regex-parse-brace.lisp"
"/regex/regex-parse-bracket.lisp"
"/regex/regex-parse.lisp"
"/regex/regex-defs.lisp"
"/regex/regex-chartrans.lisp"
"/regex/regex-fileio.lisp"
"/regex/defset-encapsulates.lisp"
"/regex/regex-ui.lisp"
"/arithmetic/inequalities.lisp"
"/arithmetic/sumlist.lisp"
"/arithmetic/mod-gcd.lisp"
"/arithmetic/nat-listp.lisp"
"/arithmetic/binomial.lisp"
"/arithmetic/equalities.lisp"
"/arithmetic/factorial.lisp"
"/bdd/cbf.lisp"
"/bdd/alu-proofs.lisp"
"/bdd/pg-theory.lisp"
"/bdd/bool-ops.lisp"
"/bdd/hamming.lisp"
"/bdd/alu.lisp"
"/bdd/bdd-primitives.lisp"
"/paco/induct.lisp"
"/paco/utilities.lisp"
"/paco/prove.lisp"
"/paco/database.lisp"
"/paco/elim-dest.lisp"
"/paco/type-set.lisp"
"/paco/foundations.lisp"
"/paco/simplify.lisp"
"/paco/output-module.lisp"
"/paco/books/proveall.lisp"
"/paco/rewrite.lisp"
"/data-structures/memories/private.lisp"
"/data-structures/memories/memory-impl.lisp"
"/data-structures/memories/log2.lisp"
"/data-structures/memories/memory.lisp"
"/data-structures/memories/memtree.lisp"
"/data-structures/list-defuns.lisp"
"/data-structures/utilities.lisp"
"/data-structures/deflist.lisp"
"/data-structures/alist-defthms.lisp"
"/data-structures/number-list-defuns.lisp"
"/data-structures/defalist.lisp"
"/data-structures/structures.lisp"
"/data-structures/alist-defuns.lisp"
"/data-structures/array1.lisp"
"/data-structures/set-defuns.lisp"
"/data-structures/list-defthms.lisp"
"/arithmetic-5/lib/basic-ops/building-blocks-helper.lisp"
"/arithmetic-5/lib/basic-ops/elim-hint.lisp"
"/arithmetic-5/lib/basic-ops/integerp-meta.lisp"
"/arithmetic-5/lib/basic-ops/default-hint.lisp"
"/arithmetic-5/lib/basic-ops/collect.lisp"
"/arithmetic-5/lib/basic-ops/simple-equalities-and-inequalities.lisp"
"/arithmetic-5/lib/basic-ops/normalize.lisp"
"/arithmetic-5/lib/basic-ops/common.lisp"
"/arithmetic-5/lib/basic-ops/remove-weak-inequalities.lisp"
"/arithmetic-5/lib/basic-ops/integerp-helper.lisp"
"/arithmetic-5/lib/basic-ops/mini-theories.lisp"
"/arithmetic-5/lib/basic-ops/dynamic-e-d.lisp"
"/arithmetic-5/lib/basic-ops/building-blocks.lisp"
"/arithmetic-5/lib/basic-ops/integerp.lisp"
"/arithmetic-5/lib/basic-ops/simplify.lisp"
"/arithmetic-5/lib/basic-ops/expt.lisp"
"/arithmetic-5/lib/basic-ops/expt-helper.lisp"
"/arithmetic-5/lib/basic-ops/simple-equalities-and-inequalities-helper.lisp"
"/arithmetic-5/lib/basic-ops/we-are-here.lisp"
"/arithmetic-5/lib/basic-ops/arithmetic-theory.lisp"
"/arithmetic-5/lib/floor-mod/logand-helper.lisp"
"/arithmetic-5/lib/floor-mod/mod-expt-fast.lisp"
"/arithmetic-5/lib/floor-mod/more-floor-mod.lisp"
"/arithmetic-5/lib/floor-mod/floor-mod.lisp"
"/arithmetic-5/lib/floor-mod/logand.lisp"
"/arithmetic-5/support/expt-helper.lisp"
"/arithmetic-5/support/basic-arithmetic.lisp"
"/arithmetic-5/support/num-and-denom-helper.lisp"
"/parallel/with-waterfall-parallelism.lisp"
"/parallel/syntax-tests.lisp"
"/parallel/proofs/ideal-speedup.lisp"
"/parallel/stress-tests.lisp"
"/parallel/matrix-multiplication-serial.lisp"
"/parallel/matrix-multiplication-parallel.lisp"
"/parallel/spec-mv-let.lisp"
"/parallel/fibonacci.lisp"
"/parallel/without-waterfall-parallelism.lisp"
"/parallel/matrix-multiplication-setup.lisp"
"/parallel/hint-tests.lisp"
"/serialize/serialize-tests.lisp"
"/serialize/unsound-read.lisp"
"/concurrent-programs/german-protocol/german.lisp"
"/concurrent-programs/bakery/properties.lisp"
"/concurrent-programs/bakery/apply-total-order.lisp"
"/concurrent-programs/bakery/lexicographic.lisp"
"/concurrent-programs/bakery/lexicographic-pos.lisp"
"/concurrent-programs/bakery/measures.lisp"
"/concurrent-programs/bakery/records.lisp"
"/concurrent-programs/bakery/properties-of-sets.lisp"
"/concurrent-programs/bakery/programs.lisp"
"/concurrent-programs/bakery/fairenv.lisp"
"/concurrent-programs/bakery/stutter2.lisp"
"/concurrent-programs/bakery/inv-persists.lisp"
"/concurrent-programs/bakery/initial-state.lisp"
"/concurrent-programs/bakery/pos-temp.lisp"
"/textbook/chap4/solutions-program-mode.lisp"
"/textbook/chap4/solutions-logic-mode.lisp"
"/textbook/chap6/selected-solutions.lisp"
"/textbook/chap10/ac-example.lisp"
"/textbook/chap10/compiler.lisp"
"/textbook/chap10/insertion-sort.lisp"
"/textbook/chap10/tree.lisp"
"/textbook/chap10/adder.lisp"
"/textbook/chap10/fact.lisp"
"/textbook/chap5/solutions.lisp"
"/textbook/chap3/programs.lisp"
"/textbook/chap11/mergesort.lisp"
"/textbook/chap11/summations-book.lisp"
"/textbook/chap11/qsort.lisp"
"/textbook/chap11/summations.lisp"
"/textbook/chap11/perm.lisp"
"/textbook/chap11/encap.lisp"
"/textbook/chap11/tautology.lisp"
"/textbook/chap11/starters.lisp"
"/textbook/chap11/xtr2.lisp"
"/textbook/chap11/how-many-soln1.lisp"
"/textbook/chap11/how-many-soln2.lisp"
"/textbook/chap11/compress.lisp"
"/textbook/chap11/finite-sets.lisp"
"/textbook/chap11/xtr.lisp"
"/add-ons/hash-stobjs.lisp"
"/quadratic-reciprocity/mersenne.lisp"
"/quadratic-reciprocity/gauss.lisp"
"/quadratic-reciprocity/euclid.lisp"
"/quadratic-reciprocity/euler.lisp"
"/quadratic-reciprocity/eisenstein.lisp"
"/quadratic-reciprocity/fermat.lisp"
"/nonstd/workshops/1999/calculus/book/map-rcfn-refinement-cdr-co-member.lisp"
"/nonstd/workshops/1999/calculus/book/riemann-defuns.lisp"
"/nonstd/workshops/1999/calculus/book/integral-rcfn.lisp"
"/nonstd/workshops/1999/calculus/book/maxlist-abslist-difflist-maps-lt.lisp"
"/nonstd/workshops/1999/calculus/book/standard-part-preserves-between.lisp"
"/nonstd/workshops/1999/calculus/book/max-and-min-attained.lisp"
"/nonstd/workshops/1999/calculus/book/fundamental-theorem-of-calculus.lisp"
"/nonstd/workshops/1999/calculus/book/between-i-close-implies-i-close.lisp"
"/nonstd/workshops/1999/calculus/book/between-limited-implies-limited.lisp"
"/nonstd/workshops/1999/calculus/book/proof-outline.lisp"
"/nonstd/workshops/1999/calculus/book/make-partition.lisp"
"/nonstd/workshops/1999/calculus/book/equal-riemann-rcfn-refinement-reduction.lisp"
"/nonstd/workshops/1999/calculus/book/riemann-rcfn-refinement-is-riemann-rcfn.lisp"
"/nonstd/workshops/1999/calculus/solutions/riemann-rcfn-helpers.lisp"
"/nonstd/workshops/1999/calculus/solutions/partition-defuns.lisp"
"/nonstd/workshops/1999/analysis/derivatives.lisp"
"/nonstd/workshops/1999/analysis/exercise8.lisp"
"/nonstd/workshops/1999/analysis/exercise1.lisp"
"/nonstd/workshops/1999/analysis/exercise4.lisp"
"/nonstd/workshops/1999/analysis/exercise5.lisp"
"/nonstd/workshops/1999/analysis/exercise3.lisp"
"/nonstd/workshops/1999/analysis/continuity.lisp"
"/nonstd/workshops/1999/analysis/exercise2.lisp"
"/nonstd/workshops/1999/analysis/exercise7.lisp"
"/nonstd/workshops/1999/analysis/exercise6.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/defderivative.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/sum-composition.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/inverse-trig-ex.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/product-composition.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/differentiator.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/inverse-composition.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/composition-elem.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/chain-composition.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/inverse-square.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/inverse-derivative.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/exp-minimal.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/ln-derivative-real.lisp"
"/nonstd/workshops/2011/reid-gamboa-differentiator/support/composition-helpers.lisp"
"/nonstd/sqrt/iter-sqrt.lisp"
"/nonstd/sqrt/no-sqrt.lisp"
"/nonstd/misc/simplify-thm.lisp"
"/nonstd/misc/integer-type-set-test.lisp"
"/nonstd/misc/file-io.lisp"
"/nonstd/misc/how-to-prove-thms.lisp"
"/nonstd/misc/evalable-printing.lisp"
"/nonstd/misc/defp.lisp"
"/nonstd/misc/defabsstobj-example-2.lisp"
"/nonstd/misc/grcd.lisp"
"/nonstd/misc/sticky-disable.lisp"
"/nonstd/misc/assert.lisp"
"/nonstd/misc/defattach-bang.lisp"
"/nonstd/misc/process-book-readme.lisp"
"/nonstd/misc/qi-correct.lisp"
"/nonstd/misc/definline.lisp"
"/nonstd/misc/congruent-stobjs-test.lisp"
"/nonstd/misc/random.lisp"
"/nonstd/misc/check-acl2-exports.lisp"
"/nonstd/misc/defabsstobj-example-3.lisp"
"/nonstd/misc/seq.lisp"
"/nonstd/misc/gentle.lisp"
"/nonstd/misc/defmac.lisp"
"/nonstd/misc/computed-hint.lisp"
"/nonstd/misc/meta-lemmas.lisp"
"/nonstd/misc/symbol-btree.lisp"
"/nonstd/misc/seqw.lisp"
"/nonstd/misc/bash.lisp"
"/nonstd/misc/sort-symbols.lisp"
"/nonstd/misc/trace-star.lisp"
"/nonstd/misc/goodstein.lisp"
"/nonstd/misc/callers-and-ancestors.lisp"
"/nonstd/misc/dijkstra-shortest-path.lisp"
"/nonstd/misc/find-lemmas.lisp"
"/nonstd/misc/records.lisp"
"/nonstd/misc/defabsstobj-example-4.lisp"
"/nonstd/misc/getprop.lisp"
"/nonstd/misc/hons-help.lisp"
"/nonstd/misc/dft.lisp"
"/nonstd/misc/equal-by-g.lisp"
"/nonstd/misc/transfinite.lisp"
"/nonstd/misc/wet.lisp"
"/nonstd/misc/beta-reduce.lisp"
"/nonstd/misc/radix.lisp"
"/nonstd/misc/total-order.lisp"
"/nonstd/misc/fast-coerce.lisp"
"/nonstd/misc/defproxy-test.lisp"
"/nonstd/misc/mult.lisp"
"/nonstd/misc/sin-cos.lisp"
"/nonstd/misc/oprof.lisp"
"/nonstd/misc/hons-tests.lisp"
"/nonstd/misc/defpun.lisp"
"/nonstd/misc/equal-by-g-help.lisp"
"/nonstd/misc/expander.lisp"
"/nonstd/misc/csort.lisp"
"/nonstd/misc/defun-plus.lisp"
"/nonstd/misc/untranslate-patterns.lisp"
"/nonstd/misc/hanoi.lisp"
"/nonstd/misc/invariants.lisp"
"/nonstd/misc/disassemble.lisp"
"/nonstd/misc/defattach-example.lisp"
"/nonstd/misc/fibonacci.lisp"
"/nonstd/misc/character-encoding-test.lisp"
"/nonstd/misc/redef-pkg.lisp"
"/nonstd/misc/priorities.lisp"
"/nonstd/misc/int-division.lisp"
"/nonstd/misc/rtl-untranslate.lisp"
"/nonstd/misc/defopener.lisp"
"/nonstd/misc/records0.lisp"
"/nonstd/misc/problem13.lisp"
"/nonstd/misc/computed-hint-rewrite.lisp"
"/nonstd/misc/dump-events.lisp"
"/nonstd/misc/simplify-defuns.lisp"
"/nonstd/misc/qi.lisp"
"/nonstd/misc/dead-events.lisp"
"/nonstd/misc/take.lisp"
"/nonstd/misc/defabsstobj-example-1.lisp"
"/nonstd/fft/eval-poly.lisp"
"/nonstd/fft/fft-omega.lisp"
"/nonstd/fft/fft-trig-with-axioms.lisp"
"/nonstd/fft/fft-trig.lisp"
"/nonstd/rtl/rel1/support/rnd.lisp"
"/nonstd/rtl/rel1/support/sticky.lisp"
"/nonstd/rtl/rel1/support/divsqrt.lisp"
"/nonstd/rtl/rel1/support/x-2xx.lisp"
"/nonstd/rtl/rel1/support/fadd/add3.lisp"
"/nonstd/rtl/rel1/support/fadd/lop3.lisp"
"/nonstd/rtl/rel1/support/fadd/top.lisp"
"/nonstd/rtl/rel1/support/fadd/lop2.lisp"
"/nonstd/rtl/rel1/support/fadd/stick.lisp"
"/nonstd/rtl/rel1/support/fadd/lop1.lisp"
"/nonstd/rtl/rel1/support/rewrite-theory.lisp"
"/nonstd/rtl/rel1/support/fp.lisp"
"/nonstd/rtl/rel1/support/odd.lisp"
"/nonstd/rtl/rel1/support/trunc.lisp"
"/nonstd/rtl/rel1/support/logdefs.lisp"
"/nonstd/rtl/rel1/support/logxor-def.lisp"
"/nonstd/rtl/rel1/support/loglemmas.lisp"
"/nonstd/rtl/rel1/support/away.lisp"
"/nonstd/rtl/rel1/support/basic.lisp"
"/nonstd/rtl/rel1/support/logxor-lemmas.lisp"
"/nonstd/rtl/rel1/support/merge.lisp"
"/nonstd/rtl/rel1/support/float.lisp"
"/nonstd/rtl/rel1/support/add.lisp"
"/nonstd/rtl/rel1/support/near.lisp"
"/nonstd/rtl/rel1/support/reps.lisp"
"/nonstd/rtl/rel1/lib1/brat.lisp"
"/nonstd/rtl/rel1/lib1/round.lisp"
"/nonstd/rtl/rel1/lib1/basic.lisp"
"/nonstd/rtl/rel1/lib1/float.lisp"
"/nonstd/rtl/rel1/lib1/bits.lisp"
"/nonstd/rtl/rel1/lib1/reps.lisp"
"/nonstd/rtl/rel1/lib3/brat.lisp"
"/nonstd/rtl/rel1/lib3/round.lisp"
"/nonstd/rtl/rel1/lib3/fadd.lisp"
"/nonstd/rtl/rel1/lib3/basic.lisp"
"/nonstd/rtl/rel1/lib3/float.lisp"
"/nonstd/rtl/rel1/lib3/bits.lisp"
"/nonstd/rtl/rel1/lib3/reps.lisp"
"/nonstd/arithmetic-2/pass1/expt-helper.lisp"
"/nonstd/arithmetic-2/pass1/numerator-and-denominator-helper.lisp"
"/nonstd/arithmetic-2/floor-mod/floor-mod-helper.lisp"
"/nonstd/arithmetic-2/floor-mod/floor-mod.lisp"
"/nonstd/arithmetic-2/meta/integerp-meta.lisp"
"/nonstd/arithmetic-2/meta/collect-terms-meta.lisp"
"/nonstd/arithmetic-2/meta/cancel-terms-meta.lisp"
"/nonstd/arithmetic-2/meta/common-meta.lisp"
"/nonstd/arithmetic-2/meta/expt-helper.lisp"
"/nonstd/powerlists/sort.lisp"
"/nonstd/powerlists/gray-code.lisp"
"/nonstd/powerlists/merge-sort.lisp"
"/nonstd/powerlists/prefix-sum.lisp"
"/nonstd/powerlists/batcher-sort.lisp"
"/nonstd/powerlists/algebra.lisp"
"/nonstd/powerlists/simple.lisp"
"/nonstd/powerlists/cla-adder.lisp"
"/nonstd/powerlists/bitonic-sort.lisp"
"/nonstd/ordinals/e0-ordinal.lisp"
"/nonstd/ordinals/lexicographic-book.lisp"
"/nonstd/ordinals/ordinal-isomorphism.lisp"
"/nonstd/ordinals/ordinal-addition.lisp"
"/nonstd/ordinals/proof-of-well-foundedness.lisp"
"/nonstd/ordinals/ordinal-multiplication.lisp"
"/nonstd/ordinals/ordinal-definitions.lisp"
"/nonstd/ordinals/ordinal-exponentiation.lisp"
"/nonstd/xdoc/names.lisp"
"/nonstd/xdoc/book-thms.lisp"
"/nonstd/xdoc/top.lisp"
"/nonstd/xdoc/defxdoc-raw.lisp"
"/nonstd/xdoc/defsection-tests.lisp"
"/nonstd/xdoc/base.lisp"
"/nonstd/xdoc/book-thms-example.lisp"
"/nonstd/finite-set-theory/total-ordering.lisp"
"/nonstd/finite-set-theory/set-theory.lisp"
"/nonstd/ihs/@logops.lisp"
"/nonstd/ihs/math-lemmas.lisp"
"/nonstd/ihs/ihs-theories.lisp"
"/nonstd/ihs/ihs-init.lisp"
"/nonstd/ihs/logops-lemmas.lisp"
"/nonstd/ihs/quotient-remainder-lemmas.lisp"
"/nonstd/ihs/basic-definitions.lisp"
"/nonstd/ihs/logops-definitions.lisp"
"/nonstd/cowles/acl2-crg.lisp"
"/nonstd/cowles/acl2-agp.lisp"
"/nonstd/cowles/acl2-asg.lisp"
"/nonstd/arithmetic/inequalities.lisp"
"/nonstd/arithmetic/sumlist.lisp"
"/nonstd/arithmetic/mod-gcd.lisp"
"/nonstd/arithmetic/nat-listp.lisp"
"/nonstd/arithmetic/binomial.lisp"
"/nonstd/arithmetic/equalities.lisp"
"/nonstd/arithmetic/factorial.lisp"
"/nonstd/bdd/cbf.lisp"
"/nonstd/bdd/alu-proofs.lisp"
"/nonstd/bdd/pg-theory.lisp"
"/nonstd/bdd/bool-ops.lisp"
"/nonstd/bdd/hamming.lisp"
"/nonstd/bdd/alu.lisp"
"/nonstd/bdd/bdd-primitives.lisp"
"/nonstd/data-structures/list-defuns.lisp"
"/nonstd/data-structures/utilities.lisp"
"/nonstd/data-structures/deflist.lisp"
"/nonstd/data-structures/alist-defthms.lisp"
"/nonstd/data-structures/number-list-defuns.lisp"
"/nonstd/data-structures/defalist.lisp"
"/nonstd/data-structures/structures.lisp"
"/nonstd/data-structures/alist-defuns.lisp"
"/nonstd/data-structures/array1.lisp"
"/nonstd/data-structures/set-defuns.lisp"
"/nonstd/data-structures/list-defthms.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/building-blocks-helper.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/elim-hint.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/integerp-meta.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/default-hint.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/collect.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/simple-equalities-and-inequalities.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/normalize.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/common.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/remove-weak-inequalities.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/integerp-helper.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/mini-theories.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/dynamic-e-d.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/building-blocks.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/integerp.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/simplify.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/expt.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/expt-helper.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/simple-equalities-and-inequalities-helper.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/we-are-here.lisp"
"/nonstd/arithmetic-5/lib/basic-ops/arithmetic-theory.lisp"
"/nonstd/arithmetic-5/lib/floor-mod/logand-helper.lisp"
"/nonstd/arithmetic-5/lib/floor-mod/mod-expt-fast.lisp"
"/nonstd/arithmetic-5/lib/floor-mod/more-floor-mod.lisp"
"/nonstd/arithmetic-5/lib/floor-mod/floor-mod.lisp"
"/nonstd/arithmetic-5/lib/floor-mod/logand.lisp"
"/nonstd/arithmetic-5/support/expt-helper.lisp"
"/nonstd/arithmetic-5/support/basic-arithmetic.lisp"
"/nonstd/arithmetic-5/support/num-and-denom-helper.lisp"
"/nonstd/nsa/inner-sums.lisp"
"/nonstd/nsa/exp-sum.lisp"
"/nonstd/nsa/next-integer.lisp"
"/nonstd/nsa/chain-rule.lisp"
"/nonstd/nsa/sqrt.lisp"
"/nonstd/nsa/complex-polar.lisp"
"/nonstd/nsa/inverse-square.lisp"
"/nonstd/nsa/derivatives.lisp"
"/nonstd/nsa/sine.lisp"
"/nonstd/nsa/alternating-series.lisp"
"/nonstd/nsa/derivatives-composition.lisp"
"/nonstd/nsa/exp.lisp"
"/nonstd/nsa/inverses.lisp"
"/nonstd/nsa/raise.lisp"
"/nonstd/nsa/inverse-derivatives.lisp"
"/nonstd/nsa/trig.lisp"
"/nonstd/nsa/continuity-product.lisp"
"/nonstd/nsa/ln.lisp"
"/nonstd/nsa/continuity.lisp"
"/nonstd/nsa/trig-approx.lisp"
"/nonstd/nsa/nsa.lisp"
"/nonstd/nsa/intervals.lisp"
"/nonstd/nsa/inverse-monotone.lisp"
"/nonstd/nsa/exp-continuous.lisp"
"/nonstd/nsa/inverse-trig.lisp"
"/nonstd/nsa/norm.lisp"
"/nonstd/meta/meta-plus-equal.lisp"
"/nonstd/meta/meta-plus-lessp.lisp"
"/nonstd/meta/term-defuns.lisp"
"/nonstd/meta/meta-times-equal.lisp"
"/nonstd/arithmetic-3/pass1/expt-helper.lisp"
"/nonstd/arithmetic-3/pass1/basic-arithmetic.lisp"
"/nonstd/arithmetic-3/pass1/num-and-denom-helper.lisp"
"/nonstd/arithmetic-3/bind-free/integerp-meta.lisp"
"/nonstd/arithmetic-3/bind-free/default-hint.lisp"
"/nonstd/arithmetic-3/bind-free/collect.lisp"
"/nonstd/arithmetic-3/bind-free/mini-theories-helper.lisp"
"/nonstd/arithmetic-3/bind-free/normalize.lisp"
"/nonstd/arithmetic-3/bind-free/common.lisp"
"/nonstd/arithmetic-3/bind-free/basic-helper.lisp"
"/nonstd/arithmetic-3/bind-free/remove-weak-inequalities.lisp"
"/nonstd/arithmetic-3/bind-free/building-blocks.lisp"
"/nonstd/arithmetic-3/bind-free/integerp.lisp"
"/nonstd/arithmetic-3/bind-free/basic.lisp"
"/nonstd/arithmetic-3/bind-free/simplify.lisp"
"/nonstd/arithmetic-3/bind-free/arithmetic-theory.lisp"
"/nonstd/arithmetic-3/floor-mod/mod-expt-fast.lisp"
"/nonstd/arithmetic-3/floor-mod/floor-mod.lisp"
"/meta/meta-plus-equal.lisp"
"/meta/meta-plus-lessp.lisp"
"/meta/term-defuns.lisp"
"/meta/meta-times-equal.lisp"
"/arithmetic-3/pass1/expt-helper.lisp"
"/arithmetic-3/pass1/basic-arithmetic.lisp"
"/arithmetic-3/pass1/num-and-denom-helper.lisp"
"/arithmetic-3/bind-free/integerp-meta.lisp"
"/arithmetic-3/bind-free/default-hint.lisp"
"/arithmetic-3/bind-free/collect.lisp"
"/arithmetic-3/bind-free/mini-theories-helper.lisp"
"/arithmetic-3/bind-free/normalize.lisp"
"/arithmetic-3/bind-free/common.lisp"
"/arithmetic-3/bind-free/basic-helper.lisp"
"/arithmetic-3/bind-free/remove-weak-inequalities.lisp"
"/arithmetic-3/bind-free/building-blocks.lisp"
"/arithmetic-3/bind-free/integerp.lisp"
"/arithmetic-3/bind-free/basic.lisp"
"/arithmetic-3/bind-free/simplify.lisp"
"/arithmetic-3/bind-free/arithmetic-theory.lisp"
"/arithmetic-3/floor-mod/mod-expt-fast.lisp"
"/arithmetic-3/floor-mod/floor-mod.lisp"))



(defvar acl2filesc
  '("/centaur/misc/fal-graphs.lisp"
"/centaur/misc/osets-witnessing.lisp"
"/centaur/misc/smm-impl.lisp"
"/centaur/misc/equal-by-nths.lisp"
"/centaur/misc/u32-listp.lisp"
"/centaur/misc/tuplep.lisp"
"/centaur/misc/smm.lisp"
"/centaur/misc/suffixp.lisp"
"/centaur/misc/patterns.lisp"
"/centaur/misc/evaluator-metatheorems.lisp"
"/centaur/misc/interp-function-lookup.lisp"
"/centaur/misc/defapply.lisp"
"/centaur/misc/equal-sets.lisp"
"/centaur/misc/hons-alphorder-merge.lisp"
"/centaur/misc/tshell.lisp"
"/centaur/misc/alist-equiv.lisp"
"/centaur/misc/memory-mgmt-logic.lisp"
"/centaur/misc/load-stobj.lisp"
"/centaur/misc/hons-remove-dups.lisp"
"/centaur/misc/vecs-ints.lisp"
"/centaur/misc/ls.lisp"
"/centaur/misc/numlist.lisp"
"/centaur/misc/alist-defs.lisp"
"/centaur/misc/dfs-measure.lisp"
"/centaur/misc/lists.lisp"
"/centaur/misc/context-rw.lisp"
"/centaur/misc/universal-equiv.lisp"
"/centaur/misc/seed-random.lisp"
"/centaur/misc/nat-list-duplicates.lisp"
"/centaur/misc/hons-extra.lisp"
"/centaur/misc/fast-alists.lisp"
"/centaur/misc/introduce-var.lisp"
"/centaur/misc/arith-equivs.lisp"
"/centaur/misc/filter-alist.lisp"
"/centaur/misc/hons-sets.lisp"
"/centaur/misc/tailrec.lisp"
"/centaur/misc/absstobjs.lisp"
"/centaur/misc/date.lisp"
"/centaur/misc/mfc-utils.lisp"
"/centaur/vcd/esim-snapshot.lisp"
"/centaur/vcd/vcd-impl.lisp"
"/centaur/vcd/vcd-stub.lisp"
"/centaur/bitops/ash-bounds.lisp"
"/centaur/bitops/equal-by-logbitp.lisp"
"/centaur/bitops/ihs-extensions.lisp"
"/centaur/bitops/integer-length.lisp"
"/centaur/bitops/congruences.lisp"
"/centaur/bitops/extra-defs.lisp"
"/centaur/bitops/ihsext-basics.lisp"
"/centaur/bitops/install-bit.lisp"
"/centaur/bitops/bits-between.lisp"
"/centaur/bitops/bitsets.lisp"
"/centaur/bitops/part-select.lisp"
"/centaur/bitops/sign-extend.lisp"
"/centaur/bitops/rotate.lisp"
"/centaur/bitops/saturate.lisp"
"/centaur/bitops/sbitsets.lisp"
"/centaur/bitops/bitsets-opt.lisp"
"/centaur/defrstobj/typed-records.lisp"
"/centaur/defrstobj/groundwork/demo5.lisp"
"/centaur/defrstobj/groundwork/demo2.lisp"
"/centaur/defrstobj/groundwork/array-rec.lisp"
"/centaur/defrstobj/groundwork/demo4.lisp"
"/centaur/defrstobj/groundwork/demo1.lisp"
"/centaur/defrstobj/groundwork/demo3.lisp"
"/centaur/defrstobj/g-delete-keys.lisp"
"/centaur/defrstobj/def-typed-record.lisp"
"/centaur/defrstobj/defrstobj.lisp"
"/centaur/defrstobj/fancy-worseguy.lisp"
"/centaur/4v-sexpr/g-sexpr-eval.lisp"
"/centaur/4v-sexpr/svarmap.lisp"
"/centaur/4v-sexpr/onehot-rewrite.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint-rewriting.lisp"
"/centaur/4v-sexpr/sexpr-rewrites.lisp"
"/centaur/4v-sexpr/sexpr-building.lisp"
"/centaur/4v-sexpr/sexpr-vars-1pass.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint-correct.lisp"
"/centaur/4v-sexpr/sexpr-vars.lisp"
"/centaur/4v-sexpr/bitspecs.lisp"
"/centaur/4v-sexpr/compose-sexpr.lisp"
"/centaur/4v-sexpr/sexpr-eval.lisp"
"/centaur/4v-sexpr/nsexprs.lisp"
"/centaur/4v-sexpr/sexpr-loop-debug.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint.lisp"
"/centaur/4v-sexpr/sexpr-equivs.lisp"
"/centaur/4v-sexpr/sexpr-to-faig.lisp"
"/centaur/4v-sexpr/sexpr-3v.lisp"
"/centaur/4v-sexpr/4v-logic.lisp"
"/centaur/4v-sexpr/sexpr-fixpoint-spec.lisp"
"/centaur/esim/esim-paths.lisp"
"/centaur/esim/esim-vcd.lisp"
"/centaur/esim/esim-vl.lisp"
"/centaur/esim/steps.lisp"
"/centaur/esim/esim-spec.lisp"
"/centaur/esim/stv/stv-debug.lisp"
"/centaur/esim/stv/stv-run.lisp"
"/centaur/esim/stv/stv-doc.lisp"
"/centaur/esim/stv/stv-compile.lisp"
"/centaur/esim/stv/stv-expand.lisp"
"/centaur/esim/stv/stv-top.lisp"
"/centaur/esim/stv/stv-widen.lisp"
"/centaur/esim/stv/stv-util.lisp"
"/centaur/esim/stv/stv-sim.lisp"
"/centaur/esim/esim-sexpr-support.lisp"
"/centaur/esim/follow-backwards.lisp"
"/centaur/esim/esim-sexpr.lisp"
"/centaur/esim/plist.lisp"
"/centaur/esim/esim-sexpr-correct.lisp"
"/centaur/esim/esim-sexpr-support-thms.lisp"
"/centaur/aig/witness.lisp"
"/centaur/aig/aig-vars-ext.lisp"
"/centaur/aig/misc.lisp"
"/centaur/aig/bddify-correct.lisp"
"/centaur/aig/induction.lisp"
"/centaur/aig/vuaig.lisp"
"/centaur/aig/eval-restrict.lisp"
"/centaur/aig/bddify.lisp"
"/centaur/aig/three-four.lisp"
"/centaur/aig/base.lisp"
"/centaur/aig/aiger.lisp"
"/centaur/aig/g-aig-eval.lisp"
"/centaur/tutorial/alu16-book.lisp"
"/centaur/vl/util/position.lisp"
"/centaur/vl/util/prefix-hash.lisp"
"/centaur/vl/util/commentmap.lisp"
"/centaur/vl/util/string-alists.lisp"
"/centaur/vl/util/namedb.lisp"
"/centaur/vl/util/nat-alists.lisp"
"/centaur/vl/util/gc.lisp"
"/centaur/vl/util/toposort.lisp"
"/centaur/vl/util/arithmetic.lisp"
"/centaur/vl/util/print-htmlencode.lisp"
"/centaur/vl/util/defwellformed.lisp"
"/centaur/vl/util/echars.lisp"
"/centaur/vl/util/defs.lisp"
"/centaur/vl/util/prefixp.lisp"
"/centaur/vl/util/character-list-listp.lisp"
"/centaur/vl/util/cw-unformatted.lisp"
"/centaur/vl/util/print.lisp"
"/centaur/vl/util/next-power-of-2.lisp"
"/centaur/vl/util/sum-nats.lisp"
"/centaur/vl/util/print-urlencode.lisp"
"/centaur/vl/util/intersectp-equal.lisp"
"/centaur/vl/util/osets.lisp"
"/centaur/vl/lint/xf-undefined-names.lisp"
"/centaur/vl/lint/lint.lisp"
"/centaur/vl/lint/disconnected.lisp"
"/centaur/vl/lint/xf-remove-toohard.lisp"
"/centaur/vl/lint/xf-drop-unresolved-submodules.lisp"
"/centaur/vl/lint/bit-use-set.lisp"
"/centaur/vl/lint/xf-lint-stmt-rewrite.lisp"
"/centaur/vl/lint/xf-drop-missing-submodules.lisp"
"/centaur/vl/lint/check-case.lisp"
"/centaur/vl/lint/check-namespace.lisp"
"/centaur/vl/lint/use-set-ignore.lisp"
"/centaur/vl/lint/xf-suppress-warnings.lisp"
"/centaur/vl/onehot.lisp"
"/centaur/vl/parsetree.lisp"
"/centaur/vl/primitives.lisp"
"/centaur/vl/wf-reasonable-p.lisp"
"/centaur/vl/translation.lisp"
"/centaur/vl/top.lisp"
"/centaur/vl/checkers/condcheck.lisp"
"/centaur/vl/checkers/dupeinst-check.lisp"
"/centaur/vl/checkers/use-set-report.lisp"
"/centaur/vl/checkers/multidrive-detect.lisp"
"/centaur/vl/checkers/oddexpr.lisp"
"/centaur/vl/checkers/duperhs.lisp"
"/centaur/vl/checkers/duplicate-detect.lisp"
"/centaur/vl/checkers/use-set-tool.lisp"
"/centaur/vl/checkers/leftright.lisp"
"/centaur/vl/checkers/typo-detect.lisp"
"/centaur/vl/checkers/use-set.lisp"
"/centaur/vl/checkers/selfassigns.lisp"
"/centaur/vl/checkers/portcheck.lisp"
"/centaur/vl/checkers/qmarksize-check.lisp"
"/centaur/vl/checkers/skip-detect.lisp"
"/centaur/vl/loader/find-file.lisp"
"/centaur/vl/loader/parse-expressions-def.lisp"
"/centaur/vl/loader/parse-error.lisp"
"/centaur/vl/loader/read-file.lisp"
"/centaur/vl/loader/parse-utils.lisp"
"/centaur/vl/loader/make-implicit-wires.lisp"
"/centaur/vl/loader/parse-modules.lisp"
"/centaur/vl/loader/parse-nets.lisp"
"/centaur/vl/loader/preprocessor.lisp"
"/centaur/vl/loader/parse-gates.lisp"
"/centaur/vl/loader/lexer.lisp"
"/centaur/vl/loader/parser.lisp"
"/centaur/vl/loader/parse-statements-def.lisp"
"/centaur/vl/loader/parse-insts.lisp"
"/centaur/vl/loader/loader.lisp"
"/centaur/vl/loader/parse-blockitems.lisp"
"/centaur/vl/loader/defines.lisp"
"/centaur/vl/loader/parse-expressions.lisp"
"/centaur/vl/loader/parse-expressions-error.lisp"
"/centaur/vl/loader/parse-expressions-progress.lisp"
"/centaur/vl/loader/parse-expressions-eof.lisp"
"/centaur/vl/loader/parse-ranges.lisp"
"/centaur/vl/loader/lexer-utils.lisp"
"/centaur/vl/loader/parse-expressions-tokenlist.lisp"
"/centaur/vl/loader/parse-functions.lisp"
"/centaur/vl/loader/lexer-tests.lisp"
"/centaur/vl/loader/overrides.lisp"
"/centaur/vl/loader/inject-comments.lisp"
"/centaur/vl/loader/lexer-tokens.lisp"
"/centaur/vl/loader/filemap.lisp"
"/centaur/vl/loader/parse-expressions-result.lisp"
"/centaur/vl/loader/parse-expressions-warnings.lisp"
"/centaur/vl/loader/parse-ports.lisp"
"/centaur/vl/loader/parse-statements-result.lisp"
"/centaur/vl/transforms/xf-optimize-rw.lisp"
"/centaur/vl/transforms/xf-expand-functions.lisp"
"/centaur/vl/transforms/xf-resolve-ranges.lisp"
"/centaur/vl/transforms/xf-orig.lisp"
"/centaur/vl/transforms/xf-follow-hids.lisp"
"/centaur/vl/transforms/xf-propagate.lisp"
"/centaur/vl/transforms/xf-gate-elim.lisp"
"/centaur/vl/transforms/xf-expr-simp.lisp"
"/centaur/vl/transforms/xf-weirdint-elim.lisp"
"/centaur/vl/transforms/xf-designregs.lisp"
"/centaur/vl/transforms/xf-array-indexing.lisp"
"/centaur/vl/transforms/xf-unparameterize.lisp"
"/centaur/vl/transforms/xf-subst.lisp"
"/centaur/vl/transforms/xf-oprewrite.lisp"
"/centaur/vl/transforms/xf-argresolve.lisp"
"/centaur/vl/transforms/xf-gatesplit.lisp"
"/centaur/vl/transforms/xf-blankargs.lisp"
"/centaur/vl/transforms/xf-elim-supply.lisp"
"/centaur/vl/transforms/xf-sizing.lisp"
"/centaur/vl/transforms/always/unelse.lisp"
"/centaur/vl/transforms/always/ifmerge.lisp"
"/centaur/vl/transforms/always/elimnegedge.lisp"
"/centaur/vl/transforms/always/stmttemps.lisp"
"/centaur/vl/transforms/always/stmtrewrite.lisp"
"/centaur/vl/transforms/xf-replicate-insts.lisp"
"/centaur/vl/transforms/xf-clean-selects.lisp"
"/centaur/vl/transforms/xf-clean-params.lisp"
"/centaur/vl/transforms/xf-hid-elim.lisp"
"/centaur/vl/transforms/xf-expr-split.lisp"
"/centaur/vl/transforms/xf-inline.lisp"
"/centaur/vl/transforms/occform/top.lisp"
"/centaur/vl/transforms/occform/util.lisp"
"/centaur/vl/transforms/cn-hooks.lisp"
"/centaur/vl/transforms/xf-gateredux.lisp"
"/centaur/vl/toe/toe-preliminary.lisp"
"/centaur/vl/toe/toe-verilogify.lisp"
"/centaur/vl/toe/toe-add-zdrivers.lisp"
"/centaur/vl/toe/toe-emodwire.lisp"
"/centaur/vl/toe/toe-add-res-modules.lisp"
"/centaur/vl/toe/toe-wirealist.lisp"
"/centaur/vl/toe/toe-eocc-allnames.lisp"
"/centaur/vl/toe/toe-top.lisp"
"/centaur/vl/mlib/stmt-tools.lisp"
"/centaur/vl/mlib/expr-tools.lisp"
"/centaur/vl/mlib/writer.lisp"
"/centaur/vl/mlib/namefactory.lisp"
"/centaur/vl/mlib/comment-writer.lisp"
"/centaur/vl/mlib/namemangle.lisp"
"/centaur/vl/mlib/find-item.lisp"
"/centaur/vl/mlib/sub-counts.lisp"
"/centaur/vl/mlib/rvalues.lisp"
"/centaur/vl/mlib/expr-parse.lisp"
"/centaur/vl/mlib/hierarchy.lisp"
"/centaur/vl/mlib/lvalues-mentioning.lisp"
"/centaur/vl/mlib/range-tools.lisp"
"/centaur/vl/mlib/allexprs.lisp"
"/centaur/vl/mlib/context.lisp"
"/centaur/vl/mlib/expr-building.lisp"
"/centaur/vl/mlib/warnings.lisp"
"/centaur/vl/mlib/modnamespace.lisp"
"/centaur/vl/mlib/print-context.lisp"
"/centaur/vl/mlib/expr-slice.lisp"
"/centaur/vl/mlib/print-warnings.lisp"
"/centaur/vl/mlib/welltyped.lisp"
"/centaur/vl/mlib/port-tools.lisp"
"/centaur/vl/mlib/atts.lisp"
"/centaur/vl/mlib/fmt.lisp"
"/centaur/vl/mlib/lvalues.lisp"
"/centaur/vl/mlib/remove-bad.lisp"
"/centaur/vl/mlib/clean-concats.lisp"
"/centaur/vl/mlib/ram-tools.lisp"
"/centaur/vl/mlib/ctxexprs.lisp"
"/centaur/vl/mlib/filter.lisp"
"/centaur/vl/mlib/find-module.lisp"
"/centaur/vl/mlib/hid-tools.lisp"
"/centaur/gl/g-rem.lisp"
"/centaur/gl/run-gified-cp.lisp"
"/centaur/gl/general-objects.lisp"
"/centaur/gl/g-mod.lisp"
"/centaur/gl/bfr-sat.lisp"
"/centaur/gl/g-lessthan.lisp"
"/centaur/gl/g-equal.lisp"
"/centaur/gl/g-binary-mult.lisp"
"/centaur/gl/defagg.lisp"
"/centaur/gl/gobject-types.lisp"
"/centaur/gl/g-logior.lisp"
"/centaur/gl/def-gl-clause-proc.lisp"
"/centaur/gl/g-truncate.lisp"
"/centaur/gl/gl-util.lisp"
"/centaur/gl/generic-geval.lisp"
"/centaur/gl/defapply.lisp"
"/centaur/gl/hyp-fix.lisp"
"/centaur/gl/g-binary-+.lisp"
"/centaur/gl/symbolic-arithmetic.lisp"
"/centaur/gl/glcp-templates.lisp"
"/centaur/gl/shape-spec.lisp"
"/centaur/gl/g-logbitp.lisp"
"/centaur/gl/gobjectp.lisp"
"/centaur/gl/gify-clause-proc.lisp"
"/centaur/gl/symbolic-arithmetic-fns.lisp"
"/centaur/gl/g-predicates.lisp"
"/centaur/gl/g-coerce.lisp"
"/centaur/gl/gl-misc-defs.lisp"
"/centaur/gl/eval-f-i-cp.lisp"
"/centaur/gl/always-equal-prep.lisp"
"/centaur/gl/factor-fns.lisp"
"/centaur/gl/gtypes.lisp"
"/centaur/gl/g-logand.lisp"
"/centaur/gl/g-code-char.lisp"
"/centaur/gl/general-object-thms.lisp"
"/centaur/gl/bfr.lisp"
"/centaur/gl/gtype-thms.lisp"
"/centaur/gl/g-floor.lisp"
"/centaur/gl/gl.lisp"
"/centaur/gl/bfr-aig-bddify.lisp"
"/centaur/gl/g-ash.lisp"
"/centaur/gl/g-primitives-help.lisp"
"/centaur/gl/g-if.lisp"
"/centaur/gl/auto-bindings.lisp"
"/centaur/gl/gify.lisp"
"/centaur/gl/gtests.lisp"
"/centaur/gl/ite-merge.lisp"
"/centaur/gl/rws.lisp"
"/centaur/gl/gobjectp-thms.lisp"
"/centaur/gl/gl-generic-clause-proc.lisp"
"/centaur/gl/param.lisp"
"/centaur/gl/bvecs.lisp"
"/centaur/gl/g-unary-concrete.lisp"
"/centaur/bridge/to-json.lisp"
"/centaur/bridge/top.lisp"
"/centaur/ubdds/witness.lisp"
"/centaur/ubdds/sanity-check-macros.lisp"
"/centaur/ubdds/extra-operations.lisp"
"/centaur/ubdds/core.lisp"
"/centaur/ubdds/subset.lisp"
"/centaur/ubdds/param.lisp"))
