!{\src2tex{textfont=tt}}
!!****f* ABINIT/fermi
!! NAME
!! fermi
!!
!! FUNCTION
!! Calculate the Fermi level and occupation numbers
!! (This routine should be cleaned !!)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG, RShaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  en(nk,nb,ns)=KS energies, for different k points, bands and spins
!!  fixmom=if differ from -99.99d0, fix the magnetic moment (in Bohr magneton)
!!  hdr=header of previously read file, containing many variables
!!  nb=number of bands
!!  nk=number of k points
!!  ns=number of spins (should be changed to nsppol)
!!  wtk(nk)=weights for k points (input variable)
!!  occ(nk,nb,ns)= occupations numbers for each k-point, band and spin
!!
!! OUTPUT
!!  nbv(ns)=number of valence bands (for each spin)
!!  fermie=Fermi energy
!!
!! SIDE EFFECTS
!!  nel= at input, if nel==0, recalculate nelect from occupation numbers
!!  occ(nk,nb,ns)=occupation numbers, for each k point, each band and spin
!!
!! TODO
!!  check the value of nel from calling routine
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      newocc
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine fermi(hdr,nb,nk,fixmom,ns,wtk,en,occ,nel,nbv,&
& fermie,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_14occeig
 use interfaces_lib01hidempi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!MG060926 added new dimension to take into account the valence band index for each spin
!scalars
 integer,intent(in) :: max_band_proc,min_band_proc,nb,nk,ns
 integer,intent(inout) :: nel
 real(dp),intent(in) :: fixmom
 real(dp),intent(out) :: fermie
 logical,intent(in) :: parallelism_is_on_bands
 type(MPI_type),intent(in) :: mpi_enreg
 type(hdr_type),intent(in) :: hdr
!arrays
 integer,intent(out) :: nbv(ns)
 real(dp),intent(in) :: en(nk,min_band_proc:max_band_proc,ns),wtk(nk)
 real(dp),intent(inout) :: occ(nk,min_band_proc:max_band_proc,ns)

!Local variables-------------------------------
!scalars
 integer :: ib,ier,ik,index,is,master,me,spaceComm
 real(dp) :: cbot,cnorm,diff,entropy,nelect,vtop
 character(len=500) :: message
!arrays
 integer :: nbandt(nk*ns)
 real(dp) :: condbottom(ns),condbottom1(ns),doccdet(nb*nk*ns),eigent(nb*nk*ns)
 real(dp) :: n(ns),occt(nb*nk*ns),valencetop(ns),valencetop1(ns),wtk_norm(nk)

! *************************************************************************

 cnorm=one/sum(wtk(:))
 call xcomm_init(mpi_enreg,spaceComm)
!Init me
 call xme_init(mpi_enreg,me)
!Init master
 call xmaster_init(mpi_enreg,master)
     
 cnorm=1.0/sum(wtk(:))
 do ik=1,nk
  wtk_norm(ik)=wtk(ik)*cnorm
 end do

 n(:)=zero
 do ik=1,nk
  do ib=1,nb
   if(parallelism_is_on_bands)then
    if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
   end if
   do is=1,ns
    n(is)=n(is)+wtk_norm(ik)*occ(ik,ib,is)
   end do
  end do
 end do
 if(parallelism_is_on_bands) call xsum_mpi(n,spaceComm,ier)
 if (nel==0) then 
  nel=int(sum(n))
  !MG the following is to avoid problem in newocc, if fermi is (unlikely) called with nel==0 
  nelect=nel
 else
  !check the input value nel with the calculated one
  !warning if difference is small, stop if too large 
  nelect=nel
  diff=(nelect-sum(n))
  if (abs(diff)< 0.1) then 
   write(message,'(a,f8.5)')&
&  ' fermi : input and calculated number of electrons differ by ',diff 
   call wrtout(6,message,'COLL')
  else if (abs(diff)< 0.3) then 
   write(message,'(3a,f8.5)')&
&  ' fermi : COMMENT - ',ch10,&
&  ' input and calculated number of electrons differ by ',diff 
   call wrtout(6,message,'COLL')
  else 
   write(message,'(3a,f8.5)')&
&  ' fermi : ERROR - ',ch10,&
&  ' input and calculated number of electrons differ by ',diff 
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if
 end if  

 write(message,'(a,i5)')' total number of electrons = ',nel
 call wrtout(6,message,'COLL')
 if (ns==2) then 
  write(message,'(2a,5x,2(f8.4,2x))')&
& ' up and down electrons= ',ch10,(n(is),is=1,ns)
  call wrtout(6,message,'COLL')
 end if

 if (ns==1) then 
  nbv=nel/2
 else 
  !MG060926 should take into account the case in which there are two bands with 
  !         the same spin index close to the gap
  nbv=int(n)
  write(message,'(a,2i8)')' maximum occupied band index for spin up and down= ',nbv  
  call wrtout(6,message,'COLL')
 end if

 if(hdr%occopt<3.or.hdr%occopt>7) then

!MG060914 added loop over spin
!MG060926 added new dimension in nbv to take into account the valence band index for each spin
  do is=1,ns

   if(min_band_proc<nbv(is))then
    valencetop1(is)=en(1,min_band_proc,is)
   else
    valencetop1(is)=zero
   end if
  if(max_band_proc>nbv(is))then
    condbottom1(is)=en(1,max_band_proc,is)     
   else
   condbottom1=1.0e10
   end if

   
   do ik=1,nk
    do ib=1,nbv(is)
     if(parallelism_is_on_bands)then
      if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
     end if
     if(valencetop1(is)<en(ik,ib,is)) valencetop1(is)=en(ik,ib,is)
    end do
    do ib=nbv(is)+1,nb
     if(parallelism_is_on_bands)then
      if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
     end if
     if(condbottom1(is)>en(ik,ib,is)) condbottom1(is)=en(ik,ib,is)
    end do
   end do ! ib
  end do ! ik

  if(mpi_enreg%nproc>1.and.parallelism_is_on_bands)then
   do is=1,ns
    call xmin_mpi_dpv(condbottom1(is),condbottom(is),spaceComm,ier)
    call xmax_mpi_dpv(valencetop1(is),valencetop(is),spaceComm,ier)
   end do
  else
   condbottom(:)=condbottom1(:)
   valencetop(:)=valencetop1(:)
  end if
  !MG060914 using maxval and minval to output the effective valencetop and condbottom   
  vtop=maxval(valencetop)
  cbot=minval(condbottom)
  write(message,'(a,f6.2,2a,f6.2)')&
&  ' top of valence       [eV] ',vtop*Ha_eV,ch10,&
&  ' bottom of conduction [eV] ',cbot*Ha_eV
  call wrtout(6,message,'COLL')
  if (ns==2) then 
   if(abs(vtop-minval(valencetop))>tol6)then 
    write(message,'(a,i2)')' top of valence is spin ',maxloc(valencetop)
    call wrtout(6,message,'COLL')
   end if
   if(abs(cbot-maxval(condbottom))>tol6)then 
    write(message,'(a,i2)')' bottom of conduction is spin ',minloc(condbottom)
    call wrtout(6,message,'COLL')
   end if
  end if

  fermie=(vtop+cbot)/2 
  if(abs(cbot-vtop)<1.d-4) fermie=vtop ! to avoid error on the last digit

 else ! occopt

  index=0
  do is=1,ns
   do ik=1,nk
    do ib=1,nb
     if(parallelism_is_on_bands)then
      if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
     end if
     index=index+1
     !storage is eigent(mband*nkpt*nsppol)
     eigent(index)=en(ik,ib,is)
    end do
   end do
  end do
  nbandt(:)=nb
!MG060914 minor BUG: in version 5.2.2 we were calling newocc using nspinor=nsspol 
!  call newocc(doccdet,eigent,entropy,fermie,-99.99d0,nb,nbandt,&
!&  nelect,nk,ns,ns,occt,hdr%occopt,1,&
!&  hdr%stmbias,hdr%tphysel,hdr%tsmear,wtk_norm)
!New version
  write(message,'(a,f8.5)')' fermi : calling newocc with fixmom = ',fixmom
  call wrtout(6,message,'COLL')

  call newocc(doccdet,eigent,entropy,fermie,fixmom,nb,nbandt,&
&  nelect,nk,hdr%nspinor,ns,occt,hdr%occopt,1,&
&  hdr%stmbias,hdr%tphysel,hdr%tsmear,wtk_norm)
  index=0
  do is=1,ns
   do ik=1,nk
    do ib=1,nb
      if(parallelism_is_on_bands)then
       if(minval(abs(mpi_enreg%proc_distrb(ib,:,:)-mpi_enreg%me))/=0) cycle
      end if
     index=index+1
     if(abs(occt(index)-occ(ik,ib,is))>1.d-2) then
      write(message,'(3a,i5,a,i5,a,i3,2a,f6.3)')&
&      ' fermi: WARNING - ',ch10,&
&      ' Occupation number of band ',ib,' for kpt ',ik,' spin ',is,ch10,&
       ' is changed with respect to KSS file:',occt(index)-occ(ik,ib,is)
       call wrtout(6,message,'COLL')
     end if
     occ(ik,ib,is)=occt(index)
    end do
   end do
  end do
 end if

 write(message,'(a,f6.2,a)')' Fermi energy         [eV] ',fermie*Ha_eV,ch10
 call wrtout(6,message,'COLL')
 
end subroutine fermi
!!***
