!{\src2tex{textfont=tt}}
!!****f* ABINIT/clcqpg
!! NAME
!! clcqpg
!!
!! FUNCTION
!! Calculate |q+G| for each q and G
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, RS)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  gvec(3,npwx)=integer coordinates of plane waves
!!  npwx=number of plane waves
!!  nq=number of q points
!!  q(3,nq)=coordinates of q points
!!
!! OUTPUT
!!  qpg(npwx,nq)=norm of q+G vector
!!  qpg_dot_qpg=(q+G).(q+G_prime) needed for Hybertsen-Louie plasmon pole and Linden Horsh
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine clcqpg(npwx,npwc,gvec,q,nq,b1,b2,b3,qpg,qratio)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => clcqpg
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: npwc,npwx,nq
!arrays
 integer,intent(in) :: gvec(3,npwx)
 real(dp),intent(in) :: b1(3),b2(3),b3(3),q(3,nq)
 real(dp),intent(out) :: qpg(npwx,nq),qratio(npwc,npwc,nq)

!Local variables ------------------------------
!scalars
 integer :: ig,igp,ii,iq
 real(dp) :: qpg_dot_qpgp
!arrays
 real(dp) :: gppq(3),gpq(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: vlngth
#endif
!End of the abilint section

 qpg(:,:)=0
 qratio(:,:,:)=0
 do iq=1,nq
  do ig=1,npwx
   gpq(1)=gvec(1,ig)+q(1,iq)
   gpq(2)=gvec(2,ig)+q(2,iq)
   gpq(3)=gvec(3,ig)+q(3,iq)
   qpg(ig,iq)=vlngth(gpq,b1,b2,b3)
  end do

!  RS: following lines added for the GPP model of Hybertsen and Louie and Linden Horsh
  do ig=1,npwc
   gpq(1)=gvec(1,ig)+q(1,iq)
   gpq(2)=gvec(2,ig)+q(2,iq)
   gpq(3)=gvec(3,ig)+q(3,iq)
   do igp=1,npwc
    gppq(1)=gvec(1,igp)+q(1,iq)
    gppq(2)=gvec(2,igp)+q(2,iq)
    gppq(3)=gvec(3,igp)+q(3,iq)
    qpg_dot_qpgp=0
    do ii=1,3
     qpg_dot_qpgp=qpg_dot_qpgp+&
&     (gpq(1)*b1(ii) +gpq(2)*b2(ii) +gpq(3)*b3(ii))*&
&     (gppq(1)*b1(ii)+gppq(2)*b2(ii)+gppq(3)*b3(ii))
    end do

! Now calculate (q+G).(q+G")/|q+G|^2    ! qratio  --> used in ppm2
! when |q+G|^2 and (q+G).(q+G") are both zero
! set (q+G).(q+G")/|q+G|^2 = 1
! when |q+G|^2 is zero and |q+G"| is not zero
! set (q+G).(q+G")/|q+G|^2 = 0

    if(qpg(ig,iq)<0.001) then
     if(qpg(igp,iq)<0.001)then
!     q=0,G=G"=0
      qratio(ig,igp,iq)=1.0
     else
!     q=0,G=0,G"!=0
!     qratio1(ig,igp,iq)=0.0
!     qratio2(ig,igp,iq)=1.0
      qratio(ig,igp,iq)=0.0
     end if
    else if(qpg(igp,iq)<0.001)then
!     q=0,G=!0,G"=0
     qratio(ig,igp,iq)=0.0
    else
     qratio(ig,igp,iq)=qpg_dot_qpgp/(qpg(ig,iq)*qpg(ig,iq))
     end if
   end do
  end do
 end do

end subroutine clcqpg
!!***
