# -*- Autoconf -*-
#
# Copyright (c) 2005-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2007/04/03 07:12:02 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([ABI_OPTIONS_DEFINE],
[

 dnl
 dnl --enable arguments
 dnl

 AC_ARG_ENABLE(64bit-flags,
  AC_HELP_STRING([--enable-64bit-flags],
   [Use 64-bit flags with all compilers (default: no)]))
 AC_SUBST(enable_64bit_flags)

 AC_ARG_ENABLE(cclock,
  AC_HELP_STRING([--enable-cclock],
   [Use C clock for timings (default: no)]))
 AC_SUBST(enable_cclock)

 AC_ARG_ENABLE(config-file,
  AC_HELP_STRING([--enable-config-file],
   [Read options from config files (default: yes)]))
 AC_SUBST(enable_config_file)

 AC_ARG_ENABLE(debug,
  AC_HELP_STRING([--enable-debug],
   [Turn-on debug mode (default: no)]))
 AC_SUBST(enable_debug)

 AC_ARG_ENABLE(fc-wrapper,
  AC_HELP_STRING([--enable-fc-wrapper],
   [Wrap Fortran compiler calls (default: None)]))
 AC_SUBST(enable_fc_wrapper)

 AC_ARG_ENABLE(extlibs,
  AC_HELP_STRING([--enable-extlibs],
   [Allow user-specified external libraries (default: yes)]))
 AC_SUBST(enable_extlibs)

 AC_ARG_ENABLE(fftw,
  AC_HELP_STRING([--enable-fftw],
   [Enable use of the FFTW library - developers only (default: no)]))
 AC_SUBST(enable_fftw)

 AC_ARG_ENABLE(fftw-threads,
  AC_HELP_STRING([--enable-fftw-threads],
   [Enable use of the threaded FFTW library - developers only (default: no)]))
 AC_SUBST(enable_fftw_threads)

 AC_ARG_ENABLE(fortran-interfaces,
  AC_HELP_STRING([--enable-fortran-interfaces],
   [Activate Fortran interfaces for all routines (default: yes)]))
 AC_SUBST(enable_fortran_interfaces)

 AC_ARG_ENABLE(bigdft,
  AC_HELP_STRING([--enable-bigdft],
   [Activate internal support for the BigDFT library (default: no)]))
 AC_SUBST(enable_bigdft)

 AC_ARG_ENABLE(linalg,
  AC_HELP_STRING([--enable-linalg],
   [Activate internal support for the linear algebra libraries (BLAS and LAPACK) (default: yes)]))
 AC_SUBST(enable_linalg)

 AC_ARG_ENABLE(mpi,
  AC_HELP_STRING([--enable-mpi],
   [Enable MPI support (default: yes)]))
 AC_SUBST(enable_mpi)

 AC_ARG_ENABLE(mpi-fft,
  AC_HELP_STRING([--enable-mpi-fft],
   [Enable MPI FFT (under development) (default: no)]))
 AC_SUBST(enable_mpi_fft)

 AC_ARG_ENABLE(mpi-io,
  AC_HELP_STRING([--enable-mpi-io],
   [Enable MPI I/O (under development) (default: no)]))
 AC_SUBST(enable_mpi_io)

 AC_ARG_ENABLE(mpi-trace,
  AC_HELP_STRING([--enable-mpi-trace],
   [Enable MPI time tracing (default: no)]))
 AC_SUBST(enable_mpi_trace)

 AC_ARG_ENABLE(netcdf,
  AC_HELP_STRING([--enable-netcdf],
   [Activate support for the NetCDF library (default: no)]))
 AC_SUBST(enable_netcdf)

 AC_ARG_ENABLE(etsf-io,
  AC_HELP_STRING([--enable-etsf-io],
   [Activate support for the ETSF I/O library (default: no)]))
 AC_SUBST(enable_etsf_io)

 AC_ARG_ENABLE(etsf-xc,
  AC_HELP_STRING([--enable-etsf-xc],
   [Activate support for the ETSF XC library (default: no)]))
 AC_SUBST(enable_etsf_xc)

 AC_ARG_ENABLE(smart-config,
  AC_HELP_STRING([--enable-smart-config],
   [Activate advanced configuration features (default: no)]))
 AC_SUBST(enable_smart_config)

 AC_ARG_ENABLE(stdin,
  AC_HELP_STRING([--enable-stdin],
   [Tell ABINIT to read file lists from standard input (default: yes)]))
 AC_SUBST(enable_stdin)

 AC_ARG_ENABLE(tricks,
  AC_HELP_STRING([--enable-tricks],
   [Use tips and tricks for compilers (default: yes)]))
 AC_SUBST(enable_tricks)

 AC_ARG_ENABLE(xmlf90,
  AC_HELP_STRING([--enable-xmlf90],
   [Activate support for the XMLF90 library (default: no)]))
 AC_SUBST(enable_xmlf90)

 dnl
 dnl --with arguments
 dnl

 AC_ARG_WITH(config-file,
  AC_HELP_STRING([--with-config-file],
   [Specify config file to read options from (default: None)]))
 AC_SUBST(with_config_file)

 AC_ARG_WITH(cppflags,
  AC_HELP_STRING([--with-cppflags],
   [Set-up preprocessing options (default: None)]))
 AC_SUBST(with_cppflags)

 AC_ARG_WITH(cc-ldflags,
  AC_HELP_STRING([--with-cc-ldflags],
   [Append flags when calling the C linker (default: None)]))
 AC_SUBST(with_cc_ldflags)

 AC_ARG_WITH(cc-optflags,
  AC_HELP_STRING([--with-cc-optflags],
   [Set-up optimization of C routines (default: None)]))
 AC_SUBST(with_cc_optflags)

 AC_ARG_WITH(cxx-ldflags,
  AC_HELP_STRING([--with-cxx-ldflags],
   [Append flags when calling the C++ linker (default: None)]))
 AC_SUBST(with_cxx_ldflags)

 AC_ARG_WITH(cxx-optflags,
  AC_HELP_STRING([--with-cxx-optflags],
   [Set-up optimization of C++ routines (default: None)]))
 AC_SUBST(with_cxx_optflags)

 AC_ARG_WITH(fftw-ldflags,
  AC_HELP_STRING([--with-fftw-ldflags],
   [LDFLAGS for the FFTW library (default: None)]))
 AC_SUBST(with_fftw_ldflags)

 AC_ARG_WITH(fc-ldflags,
  AC_HELP_STRING([--with-fc-ldflags],
   [Append flags when calling the Fortran linker (default: None)]))
 AC_SUBST(with_fc_ldflags)

 AC_ARG_WITH(fc-optflags,
  AC_HELP_STRING([--with-fc-optflags],
   [Set-up optimization of Fortran routines (default: None)]))
 AC_SUBST(with_fc_optflags)

 AC_ARG_WITH(linalg-ldflags,
  AC_HELP_STRING([--with-linalg-ldflags],
   [LDFLAGS for the linear algebra libraries (BLAS and LAPACK) (default: None)]))
 AC_SUBST(with_linalg_ldflags)

 AC_ARG_WITH(linalg-type,
  AC_HELP_STRING([--with-linalg-type],
   [See ~abinit/doc/config/build-config.ac for information (default: None)]))
 AC_SUBST(with_linalg_type)

 AC_ARG_WITH(mpi-prefix,
  AC_HELP_STRING([--with-mpi-prefix],
   [Prefix for the MPI installation (default: None)]))
 AC_SUBST(with_mpi_prefix)

 AC_ARG_WITH(mpi-cpp,
  AC_HELP_STRING([--with-mpi-cpp],
   [Full path to the MPI C preprocessor (default: None)]))
 AC_SUBST(with_mpi_cpp)

 AC_ARG_WITH(mpi-cppflags,
  AC_HELP_STRING([--with-mpi-cppflags],
   [MPI preprocessing options for parallel code (default: None)]))
 AC_SUBST(with_mpi_cppflags)

 AC_ARG_WITH(mpi-cc,
  AC_HELP_STRING([--with-mpi-cc],
   [Full path to the MPI C compiler (default: None)]))
 AC_SUBST(with_mpi_cc)

 AC_ARG_WITH(mpi-cflags,
  AC_HELP_STRING([--with-mpi-cflags],
   [MPI compile options for C parallel code (default: None)]))
 AC_SUBST(with_mpi_cflags)

 AC_ARG_WITH(mpi-cc-ldflags,
  AC_HELP_STRING([--with-mpi-cc-ldflags],
   [MPI link options for C parallel code (default: None)]))
 AC_SUBST(with_mpi_cc_ldflags)

 AC_ARG_WITH(mpi-cxx,
  AC_HELP_STRING([--with-mpi-cxx],
   [Full path to the MPI C++ compiler (default: None)]))
 AC_SUBST(with_mpi_cxx)

 AC_ARG_WITH(mpi-cxxflags,
  AC_HELP_STRING([--with-mpi-cxxflags],
   [MPI compile options for C++ parallel code (default: None)]))
 AC_SUBST(with_mpi_cxxflags)

 AC_ARG_WITH(mpi-cxx-ldflags,
  AC_HELP_STRING([--with-mpi-cxx-ldflags],
   [MPI link options for C++ parallel code (default: None)]))
 AC_SUBST(with_mpi_cxx_ldflags)

 AC_ARG_WITH(mpi-fc,
  AC_HELP_STRING([--with-mpi-fc],
   [Full path to the MPI Fortran 90 compiler (default: None)]))
 AC_SUBST(with_mpi_fc)

 AC_ARG_WITH(mpi-fcflags,
  AC_HELP_STRING([--with-mpi-fcflags],
   [MPI compile options for Fortran parallel code (default: None)]))
 AC_SUBST(with_mpi_fcflags)

 AC_ARG_WITH(mpi-fc-ldflags,
  AC_HELP_STRING([--with-mpi-fc-ldflags],
   [MPI link options for Fortran parallel code (default: None)]))
 AC_SUBST(with_mpi_fc_ldflags)

 AC_ARG_WITH(mpi-run,
  AC_HELP_STRING([--with-mpi-run],
   [Full path to the mpirun program (default: None)]))
 AC_SUBST(with_mpi_run)

 AC_ARG_WITH(bigdft-include,
  AC_HELP_STRING([--with-bigdft-include],
   [Include path for the BigDFT library (when external support) (default: None)]))
 AC_SUBST(with_bigdft_include)

 AC_ARG_WITH(bigdft-ldflags,
  AC_HELP_STRING([--with-bigdft-ldflags],
   [LDFLAGS for the BigDFT library (when external support) (default: None)]))
 AC_SUBST(with_bigdft_ldflags)

 AC_ARG_WITH(netcdf-include,
  AC_HELP_STRING([--with-netcdf-include],
   [Include path for the NetCDF library (default: None)]))
 AC_SUBST(with_netcdf_include)

 AC_ARG_WITH(netcdf-ldflags,
  AC_HELP_STRING([--with-netcdf-ldflags],
   [LDFLAGS for the NetCDF library (default: None)]))
 AC_SUBST(with_netcdf_ldflags)

 AC_ARG_WITH(etsf-io-include,
  AC_HELP_STRING([--with-etsf-io-include],
   [Include path for the ETSF I/O library (default: None)]))
 AC_SUBST(with_etsf_io_include)

 AC_ARG_WITH(etsf-io-ldflags,
  AC_HELP_STRING([--with-etsf-io-ldflags],
   [LDFLAGS for the ETSF I/O library (default: None)]))
 AC_SUBST(with_etsf_io_ldflags)

 AC_ARG_WITH(etsf-xc-include,
  AC_HELP_STRING([--with-etsf-xc-include],
   [Include path for the ETSF XC library (default: None)]))
 AC_SUBST(with_etsf_xc_include)

 AC_ARG_WITH(etsf-xc-ldflags,
  AC_HELP_STRING([--with-etsf-xc-ldflags],
   [LDFLAGS for the ETSF XC library (default: None)]))
 AC_SUBST(with_etsf_xc_ldflags)

 AC_ARG_WITH(xmlf90-include,
  AC_HELP_STRING([--with-xmlf90-include],
   [Include path for the XMLF90 library (default: None)]))
 AC_SUBST(with_xmlf90_include)

 AC_ARG_WITH(xmlf90-ldflags,
  AC_HELP_STRING([--with-xmlf90-ldflags],
   [LDFLAGS for the XMLF90 library (default: None)]))
 AC_SUBST(with_xmlf90_ldflags)
]) # ABI_OPTIONS_DEFINE



# ABI_OPTIONS_INIT()
# ------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_INIT],
[

 dnl
 dnl --enable arguments
 dnl

 if test "${enable_64bit_flags}" = ""; then
  enable_64bit_flags="no"
 fi
 if test "${enable_cclock}" = ""; then
  enable_cclock="no"
 fi
 if test "${enable_config_file}" = ""; then
  enable_config_file="yes"
 fi
 if test "${enable_debug}" = ""; then
  enable_debug="no"
 fi
 if test "${enable_extlibs}" = ""; then
  enable_extlibs="yes"
 fi
 if test "${enable_fftw}" = ""; then
  enable_fftw="no"
 fi
 if test "${enable_fftw_threads}" = ""; then
  enable_fftw_threads="no"
 fi
 if test "${enable_fortran_interfaces}" = ""; then
  enable_fortran_interfaces="yes"
 fi
 if test "${enable_bigdft}" = ""; then
  enable_bigdft="no"
 fi
 if test "${enable_linalg}" = ""; then
  enable_linalg="yes"
 fi
 if test "${enable_mpi}" = ""; then
  enable_mpi="yes"
 fi
 if test "${enable_mpi_fft}" = ""; then
  enable_mpi_fft="no"
 fi
 if test "${enable_mpi_io}" = ""; then
  enable_mpi_io="no"
 fi
 if test "${enable_mpi_trace}" = ""; then
  enable_mpi_trace="no"
 fi
 if test "${enable_netcdf}" = ""; then
  enable_netcdf="no"
 fi
 if test "${enable_etsf_io}" = ""; then
  enable_etsf_io="no"
 fi
 if test "${enable_etsf_xc}" = ""; then
  enable_etsf_xc="no"
 fi
 if test "${enable_smart_config}" = ""; then
  enable_smart_config="no"
 fi
 if test "${enable_stdin}" = ""; then
  enable_stdin="yes"
 fi
 if test "${enable_tricks}" = ""; then
  enable_tricks="yes"
 fi
 if test "${enable_xmlf90}" = ""; then
  enable_xmlf90="no"
 fi

 dnl
 dnl --with arguments
 dnl

]) # ABI_OPTIONS_INIT



# ABI_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_BACKUP],
[

 dnl
 dnl --enable arguments
 dnl
 cmd_enable_64bit_flags="${enable_64bit_flags}"
 cmd_enable_cclock="${enable_cclock}"
 cmd_enable_config_file="${enable_config_file}"
 cmd_enable_debug="${enable_debug}"
 cmd_enable_fc_wrapper="${enable_fc_wrapper}"
 cmd_enable_extlibs="${enable_extlibs}"
 cmd_enable_fftw="${enable_fftw}"
 cmd_enable_fftw_threads="${enable_fftw_threads}"
 cmd_enable_fortran_interfaces="${enable_fortran_interfaces}"
 cmd_enable_bigdft="${enable_bigdft}"
 cmd_enable_linalg="${enable_linalg}"
 cmd_enable_mpi="${enable_mpi}"
 cmd_enable_mpi_fft="${enable_mpi_fft}"
 cmd_enable_mpi_io="${enable_mpi_io}"
 cmd_enable_mpi_trace="${enable_mpi_trace}"
 cmd_enable_netcdf="${enable_netcdf}"
 cmd_enable_etsf_io="${enable_etsf_io}"
 cmd_enable_etsf_xc="${enable_etsf_xc}"
 cmd_enable_smart_config="${enable_smart_config}"
 cmd_enable_stdin="${enable_stdin}"
 cmd_enable_tricks="${enable_tricks}"
 cmd_enable_xmlf90="${enable_xmlf90}"

 dnl
 dnl --with arguments
 dnl
 cmd_with_config_file="${with_config_file}"
 cmd_with_cppflags="${with_cppflags}"
 cmd_with_cc_ldflags="${with_cc_ldflags}"
 cmd_with_cc_optflags="${with_cc_optflags}"
 cmd_with_cxx_ldflags="${with_cxx_ldflags}"
 cmd_with_cxx_optflags="${with_cxx_optflags}"
 cmd_with_fftw_ldflags="${with_fftw_ldflags}"
 cmd_with_fc_ldflags="${with_fc_ldflags}"
 cmd_with_fc_optflags="${with_fc_optflags}"
 cmd_with_linalg_ldflags="${with_linalg_ldflags}"
 cmd_with_linalg_type="${with_linalg_type}"
 cmd_with_mpi_prefix="${with_mpi_prefix}"
 cmd_with_mpi_cpp="${with_mpi_cpp}"
 cmd_with_mpi_cppflags="${with_mpi_cppflags}"
 cmd_with_mpi_cc="${with_mpi_cc}"
 cmd_with_mpi_cflags="${with_mpi_cflags}"
 cmd_with_mpi_cc_ldflags="${with_mpi_cc_ldflags}"
 cmd_with_mpi_cxx="${with_mpi_cxx}"
 cmd_with_mpi_cxxflags="${with_mpi_cxxflags}"
 cmd_with_mpi_cxx_ldflags="${with_mpi_cxx_ldflags}"
 cmd_with_mpi_fc="${with_mpi_fc}"
 cmd_with_mpi_fcflags="${with_mpi_fcflags}"
 cmd_with_mpi_fc_ldflags="${with_mpi_fc_ldflags}"
 cmd_with_mpi_run="${with_mpi_run}"
 cmd_with_bigdft_include="${with_bigdft_include}"
 cmd_with_bigdft_ldflags="${with_bigdft_ldflags}"
 cmd_with_netcdf_include="${with_netcdf_include}"
 cmd_with_netcdf_ldflags="${with_netcdf_ldflags}"
 cmd_with_etsf_io_include="${with_etsf_io_include}"
 cmd_with_etsf_io_ldflags="${with_etsf_io_ldflags}"
 cmd_with_etsf_xc_include="${with_etsf_xc_include}"
 cmd_with_etsf_xc_ldflags="${with_etsf_xc_ldflags}"
 cmd_with_xmlf90_include="${with_xmlf90_include}"
 cmd_with_xmlf90_ldflags="${with_xmlf90_ldflags}"

 dnl
 dnl Prefix
 dnl
 if test "${prefix}" != "NONE"; then
  cmd_prefix="${prefix}"
 fi
]) # ABI_OPTIONS_BACKUP



# ABI_OPTIONS_RESTORE()
# ---------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_RESTORE],
[

 dnl
 dnl --enable arguments
 dnl

 if test "${cmd_enable_64bit_flags}" != ""; then
  enable_64bit_flags="${cmd_enable_64bit_flags}"
 fi

 if test "${cmd_enable_cclock}" != ""; then
  enable_cclock="${cmd_enable_cclock}"
 fi

 if test "${cmd_enable_config_file}" != ""; then
  enable_config_file="${cmd_enable_config_file}"
 fi

 if test "${cmd_enable_debug}" != ""; then
  enable_debug="${cmd_enable_debug}"
 fi

 if test "${cmd_enable_fc_wrapper}" != ""; then
  enable_fc_wrapper="${cmd_enable_fc_wrapper}"
 fi

 if test "${cmd_enable_extlibs}" != ""; then
  enable_extlibs="${cmd_enable_extlibs}"
 fi

 if test "${cmd_enable_fftw}" != ""; then
  enable_fftw="${cmd_enable_fftw}"
 fi

 if test "${cmd_enable_fftw_threads}" != ""; then
  enable_fftw_threads="${cmd_enable_fftw_threads}"
 fi

 if test "${cmd_enable_fortran_interfaces}" != ""; then
  enable_fortran_interfaces="${cmd_enable_fortran_interfaces}"
 fi

 if test "${cmd_enable_bigdft}" != ""; then
  enable_bigdft="${cmd_enable_bigdft}"
 fi

 if test "${cmd_enable_linalg}" != ""; then
  enable_linalg="${cmd_enable_linalg}"
 fi

 if test "${cmd_enable_mpi}" != ""; then
  enable_mpi="${cmd_enable_mpi}"
 fi

 if test "${cmd_enable_mpi_fft}" != ""; then
  enable_mpi_fft="${cmd_enable_mpi_fft}"
 fi

 if test "${cmd_enable_mpi_io}" != ""; then
  enable_mpi_io="${cmd_enable_mpi_io}"
 fi

 if test "${cmd_enable_mpi_trace}" != ""; then
  enable_mpi_trace="${cmd_enable_mpi_trace}"
 fi

 if test "${cmd_enable_netcdf}" != ""; then
  enable_netcdf="${cmd_enable_netcdf}"
 fi

 if test "${cmd_enable_etsf_io}" != ""; then
  enable_etsf_io="${cmd_enable_etsf_io}"
 fi

 if test "${cmd_enable_etsf_xc}" != ""; then
  enable_etsf_xc="${cmd_enable_etsf_xc}"
 fi

 if test "${cmd_enable_smart_config}" != ""; then
  enable_smart_config="${cmd_enable_smart_config}"
 fi

 if test "${cmd_enable_stdin}" != ""; then
  enable_stdin="${cmd_enable_stdin}"
 fi

 if test "${cmd_enable_tricks}" != ""; then
  enable_tricks="${cmd_enable_tricks}"
 fi

 if test "${cmd_enable_xmlf90}" != ""; then
  enable_xmlf90="${cmd_enable_xmlf90}"
 fi

 dnl
 dnl --with arguments
 dnl

 if test "${cmd_with_config_file}" != ""; then
  with_config_file="${cmd_with_config_file}"
 fi

 if test "${cmd_with_cppflags}" != ""; then
  with_cppflags="${cmd_with_cppflags}"
 fi

 if test "${cmd_with_cc_ldflags}" != ""; then
  with_cc_ldflags="${cmd_with_cc_ldflags}"
 fi

 if test "${cmd_with_cc_optflags}" != ""; then
  with_cc_optflags="${cmd_with_cc_optflags}"
 fi

 if test "${cmd_with_cxx_ldflags}" != ""; then
  with_cxx_ldflags="${cmd_with_cxx_ldflags}"
 fi

 if test "${cmd_with_cxx_optflags}" != ""; then
  with_cxx_optflags="${cmd_with_cxx_optflags}"
 fi

 if test "${cmd_with_fftw_ldflags}" != ""; then
  with_fftw_ldflags="${cmd_with_fftw_ldflags}"
 fi

 if test "${cmd_with_fc_ldflags}" != ""; then
  with_fc_ldflags="${cmd_with_fc_ldflags}"
 fi

 if test "${cmd_with_fc_optflags}" != ""; then
  with_fc_optflags="${cmd_with_fc_optflags}"
 fi

 if test "${cmd_with_linalg_ldflags}" != ""; then
  with_linalg_ldflags="${cmd_with_linalg_ldflags}"
 fi

 if test "${cmd_with_linalg_type}" != ""; then
  with_linalg_type="${cmd_with_linalg_type}"
 fi

 if test "${cmd_with_mpi_prefix}" != ""; then
  with_mpi_prefix="${cmd_with_mpi_prefix}"
 fi

 if test "${cmd_with_mpi_cpp}" != ""; then
  with_mpi_cpp="${cmd_with_mpi_cpp}"
 fi

 if test "${cmd_with_mpi_cppflags}" != ""; then
  with_mpi_cppflags="${cmd_with_mpi_cppflags}"
 fi

 if test "${cmd_with_mpi_cc}" != ""; then
  with_mpi_cc="${cmd_with_mpi_cc}"
 fi

 if test "${cmd_with_mpi_cflags}" != ""; then
  with_mpi_cflags="${cmd_with_mpi_cflags}"
 fi

 if test "${cmd_with_mpi_cc_ldflags}" != ""; then
  with_mpi_cc_ldflags="${cmd_with_mpi_cc_ldflags}"
 fi

 if test "${cmd_with_mpi_cxx}" != ""; then
  with_mpi_cxx="${cmd_with_mpi_cxx}"
 fi

 if test "${cmd_with_mpi_cxxflags}" != ""; then
  with_mpi_cxxflags="${cmd_with_mpi_cxxflags}"
 fi

 if test "${cmd_with_mpi_cxx_ldflags}" != ""; then
  with_mpi_cxx_ldflags="${cmd_with_mpi_cxx_ldflags}"
 fi

 if test "${cmd_with_mpi_fc}" != ""; then
  with_mpi_fc="${cmd_with_mpi_fc}"
 fi

 if test "${cmd_with_mpi_fcflags}" != ""; then
  with_mpi_fcflags="${cmd_with_mpi_fcflags}"
 fi

 if test "${cmd_with_mpi_fc_ldflags}" != ""; then
  with_mpi_fc_ldflags="${cmd_with_mpi_fc_ldflags}"
 fi

 if test "${cmd_with_mpi_run}" != ""; then
  with_mpi_run="${cmd_with_mpi_run}"
 fi

 if test "${cmd_with_bigdft_include}" != ""; then
  with_bigdft_include="${cmd_with_bigdft_include}"
 fi

 if test "${cmd_with_bigdft_ldflags}" != ""; then
  with_bigdft_ldflags="${cmd_with_bigdft_ldflags}"
 fi

 if test "${cmd_with_netcdf_include}" != ""; then
  with_netcdf_include="${cmd_with_netcdf_include}"
 fi

 if test "${cmd_with_netcdf_ldflags}" != ""; then
  with_netcdf_ldflags="${cmd_with_netcdf_ldflags}"
 fi

 if test "${cmd_with_etsf_io_include}" != ""; then
  with_etsf_io_include="${cmd_with_etsf_io_include}"
 fi

 if test "${cmd_with_etsf_io_ldflags}" != ""; then
  with_etsf_io_ldflags="${cmd_with_etsf_io_ldflags}"
 fi

 if test "${cmd_with_etsf_xc_include}" != ""; then
  with_etsf_xc_include="${cmd_with_etsf_xc_include}"
 fi

 if test "${cmd_with_etsf_xc_ldflags}" != ""; then
  with_etsf_xc_ldflags="${cmd_with_etsf_xc_ldflags}"
 fi

 if test "${cmd_with_xmlf90_include}" != ""; then
  with_xmlf90_include="${cmd_with_xmlf90_include}"
 fi

 if test "${cmd_with_xmlf90_ldflags}" != ""; then
  with_xmlf90_ldflags="${cmd_with_xmlf90_ldflags}"
 fi

 dnl
 dnl Prefix
 dnl
 if test "${cmd_prefix}" != ""; then
  prefix="${cmd_prefix}"
 fi
]) # ABI_OPTIONS_RESTORE
