/**
	Functions for hiding and showing twisty divs.

	Change Log:
	
	2004-12-26 Arthur Ryman <ryman@ca.ibm.com>
	- created
*/

// id prefix for divs that are twisty heads
var twisty_head = "twisty-head-";

// id prefix for divs that are twisty bodies
var twisty_body = "twisty-body-";

// Hides all twisty body divs and shows all heads
function hideAll() {
	displayAll("block", "none");
}

// Shows all twisty body divs and hides all heads 
function showAll() {
	displayAll("none", "block");
}

// Sets the display style of all twisty divs.
function displayAll(head, body) {

	var divs = document.getElementsByTagName("div");
	var n = divs.length;
	for (i = 0; i < n; i++) {
		var div = divs[i];
		var id = div.id;
		if (id.indexOf(twisty_head) == 0) {
			div.style.display = head;
		}
		if (id.indexOf(twisty_body) == 0) {
			div.style.display = body;
		}
	}
}

// Shows the named twisty body div and hides the head.
function show(name) {
	display(name, "none", "block");
}

// Hides the named twisty body div and shows the head.
function hide(name) {
	display(name, "block", "none");
}

// Sets the display style the named twisty head and body divs.
function display(name, head, body) {

	displayId(twisty_head + name, head);
	displayId(twisty_body + name, body);
}

// Sets the display style of the identified element.
function displayId(id, display) {

	var element = document.getElementById(id);
	if (element != null) {
		element.style.display = display;
	}
}
