#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2021 Anna Lea
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Agatha Christie: The ABC Murders
# send your bug reports to contact@dotslashplay.it
###

script_version=20240623.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='agatha-christie-the-abc-murders'
GAME_NAME='Agatha Christie: The ABC Murders'

ARCHIVE_BASE_INTL_0_NAME='gog_agatha_christie_the_abc_murders_2.2.0.4.sh'
ARCHIVE_BASE_INTL_0_MD5='271dab525be57f2783622bbbeb30c7c1'
ARCHIVE_BASE_INTL_0_SIZE='2700000'
ARCHIVE_BASE_INTL_0_VERSION='1.0-gog2.2.0.4'
ARCHIVE_BASE_INTL_0_URL='https://www.gog.com/game/agatha_christie_the_abc_murders'

ARCHIVE_BASE_PL_0_NAME='gog_agatha_christie_the_abc_murders_polish_2.2.0.4.sh'
ARCHIVE_BASE_PL_0_MD5='a9e8e3dcc65e651302e06abbd1446fe6'
ARCHIVE_BASE_PL_0_SIZE='2700000'
ARCHIVE_BASE_PL_0_VERSION='1.0-gog2.2.0.4'
ARCHIVE_BASE_PL_0_URL='https://www.gog.com/game/agatha_christie_the_abc_murders'

ARCHIVE_BASE_RU_0_NAME='gog_agatha_christie_the_abc_murders_russian_2.2.0.4.sh'
ARCHIVE_BASE_RU_0_MD5='0becf882ba0e8ae4609c3e771236670c'
ARCHIVE_BASE_RU_0_SIZE='2700000'
ARCHIVE_BASE_RU_0_VERSION='1.0-gog2.2.0.4'
ARCHIVE_BASE_RU_0_URL='https://www.gog.com/game/agatha_christie_the_abc_murders'

UNITY3D_NAME='The ABC Murders'
UNITY3D_PLUGINS='
ScreenSelector.so'
## TODO: Check if the Steam libraries are required.
UNITY3D_PLUGINS="$UNITY3D_PLUGINS
libCSteamworks.so
libsteam_api.so"

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_L10N_FILES="
${UNITY3D_NAME}_Data/Managed
${UNITY3D_NAME}_Data/mainData
${UNITY3D_NAME}_Data/resources.assets
${UNITY3D_NAME}_Data/level*"

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_INTL="${PKG_L10N_ID}-intl"
PKG_L10N_ID_PL="${PKG_L10N_ID}-pl"
PKG_L10N_ID_RU="${PKG_L10N_ID}-ru"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_INTL='English, French, German, Spanish, Italian and Portuguese localizations'
PKG_L10N_DESCRIPTION_PL='Polish localization'
PKG_L10N_DESCRIPTION_RU='Russian localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_L10N_ID $PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
