#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Sexy Brutale
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220417.2

# Set game-specific variables

GAME_ID='the-sexy-brutale'
GAME_NAME='The Sexy Brutale'

ARCHIVE_BASE_1='setup_the_sexy_brutale_gog-2_(40574).exe'
ARCHIVE_BASE_1_MD5='ff1e34c2727d01a9f16a1c6d1acedd8e'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='2600000'
ARCHIVE_BASE_1_VERSION='1.0-gog40574'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_sexy_brutale'

ARCHIVE_BASE_0='setup_the_sexy_brutale_gog-1_(11101).exe'
ARCHIVE_BASE_0_MD5='6d94492d797e199c1e67b05dabbc52e5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_the_sexy_brutale_gog-1_(11101)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='3158c4b5d6e9eafb9c4d1a79812601e0'
ARCHIVE_BASE_0_PART1_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='3400000'
ARCHIVE_BASE_0_VERSION='1.0-gog11101'

UNITY3D_NAME='tsb'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/mono
${UNITY3D_NAME}_data/plugins"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_data"
# Keep compatibility with old installers structure
CONTENT_PATH_DEFAULT_0='app'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/CGS/TSB'
CONFIG_FILES='userdata/*.gd'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

# Enforce a consistent Unity3D name

(
	content_path=$(content_path_default)
	unity3d_name=$(unity3d_name)
	alternative_name='the sexy brutale'
	cd "${PLAYIT_WORKDIR}/gamedata/${content_path}"
	if [ -e "${alternative_name}.exe" ]; then
		mv "${alternative_name}.exe" "${unity3d_name}.exe"
	fi
	if [ -e "${alternative_name}_data" ]; then
		mv "${alternative_name}_data" "${unity3d_name}_data"
	fi
)

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
