#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Solar 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20231001.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='solar-2'
GAME_NAME='Solar 2'

ARCHIVE_BASE_0_NAME='solar2-linux-1.10_1409159048.tar.gz'
ARCHIVE_BASE_0_MD5='243918907eea486fdc820b7cac0c260b'
ARCHIVE_BASE_0_SIZE='130000'
ARCHIVE_BASE_0_VERSION='1.10-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/solar-2'

## TODO: Check if we could run this game using the system-provided Mono runtime, instead of the shipped binaries.

CONTENT_PATH_DEFAULT='Solar2'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib"
## TODO: Check if some shipped libraries could be replaced with system-provided ones.
CONTENT_LIBS_BIN_FILES='
libmad.so.0
libmad.so.0.2.1
libmikmod.so.2
libmikmod.so.2.0.4
libmono-2.0.so
libmono-2.0.so.1
libopenal.so.1
libopenal.so.1.13.0
libSDL_mixer-1.2.so.0
libSDL_mixer-1.2.so.0.10.1'
CONTENT_GAME_BIN_FILES='
Solar2.bin.x86
display.txt'
CONTENT_GAME_DATA_FILES='
Solar2.exe
*.dll
*.config
mono
Languages
MonoContent'

USER_PERSISTENT_DIRECTORIES='
Languages'
USER_PERSISTENT_FILES='
display.txt'

APP_MAIN_EXE='Solar2.bin.x86'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libFLAC.so.8
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL-1.2.so.0
libstdc++.so.6
libvorbisfile.so.3'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include icons

ARCHIVE_OPTIONAL_ICONS_0_NAME='solar-2_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_0_MD5='d8f8557a575cb5b5824d72718428cd33'
ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/resources/solar-2/'
archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS'
## TODO: The library should provide a function to check if a given optional archive has been provided.
if [ -n "$(archive_path 'ARCHIVE_ICONS' 2>/dev/null || true)" ]; then
	CONTENT_ICONS_DATA_PATH='.'
	CONTENT_ICONS_DATA_FILES='
	16x16
	32x32
	48x48
	64x64'
	archive_extraction 'ARCHIVE_ICONS'
	content_inclusion 'ICONS_DATA' 'PKG_DATA' "$(path_icons)"
fi

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
