#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
set -o errexit

###
# Pavilion
# send your bug reports to contact@dotslashplay.it
###

script_version=20230625.1

# Set game-specific variables

GAME_ID='pavilion'
GAME_NAME='Pavilion'

ARCHIVE_HUMBLE='Pavilion_Linux_v1.31'
ARCHIVE_HUMBLE_URL='https://www.humblebundle.com/store/pavilion'
ARCHIVE_HUMBLE_MD5='82fb0659f230ab2b01e79aeb80df1ec3'
ARCHIVE_HUMBLE_SIZE='1900000'
ARCHIVE_HUMBLE_VERSION='1.31-humble1'
ARCHIVE_HUMBLE_TYPE='zip'

ARCHIVE_DOC_PATH='Pavilion Linux(v1.31)'
ARCHIVE_DOC_FILES='RELEASE_NOTES.txt'

ARCHIVE_GAME_BIN_PATH='Pavilion Linux(v1.31)'
ARCHIVE_GAME_BIN_FILES='pavilion.x86 pavilion_Data/Mono pavilion_Data/Plugins'

ARCHIVE_GAME_DATA_PATH='Pavilion Linux(v1.31)'
ARCHIVE_GAME_DATA_FILES='pavilion_Data'

DATA_DIRS='./logs'

APP_MAIN_TYPE='native'
APP_MAIN_EXE='pavilion.x86'
APP_MAIN_ICON='pavilion_Data/Resources/UnityPlayer.png'
# Common Unity3D tweaks
APP_MAIN_PRERUN='# Work around Unity3D poor support for non-US locales
export LANG=C'
# Use a per-session dedicated file for logs
# shellcheck disable=SC2016
APP_MAIN_OPTIONS='-logFile ./logs/$(date +%F-%R).log'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_LIGHTING_ID $PKG_DATA_ID glibc libstdc++ glx libudev1 xcursor libxrandr alsa"

# Load common functions

target_version='2.12'

if [ -z "$PLAYIT_LIB2" ]; then
	: "${XDG_DATA_HOME:="$HOME/.local/share"}"
	for path in\
		"$PWD"\
		"$XDG_DATA_HOME/play.it"\
		'/usr/local/share/games/play.it'\
		'/usr/local/share/play.it'\
		'/usr/share/games/play.it'\
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Get game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Clean up temporary files

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
