#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cube Escape
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220306.4

# Set game-specific variables

GAME_ID='cube-escape'
GAME_NAME='Cube Escape'

ARCHIVE_BASE_0='setup_cube_escape_collection_1.0_(43930).exe'
ARCHIVE_BASE_0_MD5='bd5035262ff2b9adc3a1887d8168ebaf'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='130000'
ARCHIVE_BASE_0_VERSION='1.0-gog43930'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/cube_escape_collection'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
adobe?air
cube?escape?collection.exe'
ARCHIVE_GAME_DATA_FILES='
*.swf
meta-inf
mimetype
cube-escape-translations.xml
icons'
ARCHIVE_GAME0_BIN_PATH="${CONTENT_PATH_DEFAULT}/app"
ARCHIVE_GAME0_BIN_FILES='
adobe?air'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='cube escape collection.exe'
APP_MAIN_ICON='cube escape collection.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/Documents/Rusty Lake/CubeEscapeCollection'
DATA_DIRS='./userdata'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
