      SUBROUTINE CURVPS (SIGS, PRIN)
C*****
C  COMPUTES PRINCIPAL STRESSES OR STRAINS AND ANGLE OF MAXIMUM.
C*****
      REAL SIGS(3), PRIN(4)
C
      TEMP = SIGS(1) - SIGS(2)
      PRIN(4) = SQRT( (TEMP/2.0)**2 + SIGS(3)**2 )
      DELTA = ( SIGS(1) + SIGS(2) ) / 2.0
      PRIN(2) = DELTA + PRIN(4)
      PRIN(3) = DELTA - PRIN(4)
      DELTA = 2.0 * SIGS(3)
      IF( ABS(DELTA).LT.1.0E-15 .AND. ABS(TEMP).LT.1.0E-15 ) GO TO 100
      PRIN(1) = ATAN2( DELTA, TEMP )*28.6478898E0
      RETURN
C
  100 PRIN(1) = 0.0
      RETURN
      END
