/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Html3_2DocDesc
extends HtmlDocDesc {
    private static Map stSupportedElements;

    public Html3_2DocDesc() {
        this.supportedElements = stSupportedElements;
        this.init();
    }

    private static void addAddressElement(List list) {
        String string = "address";
        ArrayList<String> arrayList = new ArrayList<String>(36);
        arrayList.addAll(list);
        arrayList.add("p");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addAElement(List list) {
        String string = "a";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, null);
        htmlTagDesc.setAttributes(new String[]{"name", "href", "rel", "rev", "title"});
        htmlTagDesc.setExcludedContent(new String[]{"a"});
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addAppletElement(HtmlAttributeDesc htmlAttributeDesc, List list) {
        String string = "applet";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(9);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "codebase");
        arrayList.add(new HtmlAttributeDesc("code", null, 1));
        Html3_2DocDesc.addSimpleAttribute(arrayList, "alt");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "name");
        arrayList.add(new HtmlAttributeDesc("width", null, 1));
        arrayList.add(new HtmlAttributeDesc("height", null, 1));
        arrayList.add(htmlAttributeDesc);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "hspace");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "vspace");
        ArrayList<String> arrayList2 = new ArrayList<String>(36);
        arrayList2.addAll(list);
        arrayList2.add("param");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, arrayList2, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addAreaElement() {
        String string = "area";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(5);
        arrayList.add(new HtmlAttributeDesc("shape", new String[]{"rect", "circle", "poly"}, 1));
        Html3_2DocDesc.addSimpleAttribute(arrayList, "coords");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "href");
        arrayList.add(new HtmlAttributeDesc("nohref", new String[]{"nohref"}, 4));
        arrayList.add(new HtmlAttributeDesc("alt", null, 1));
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addBaseElement() {
        String string = "base";
        ArrayList arrayList = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "href");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addBasefontElement() {
        String string = "basefont";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, null);
        htmlTagDesc.setAttributes(new String[]{"size"});
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addBlockquoteElement(List list) {
        String string = "blockquote";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addBodyElement(List list) {
        String string = "body";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, null);
        htmlTagDesc.setAttributes(new String[]{"bgcolor", "text", "link", "vlink", "alink", "background"});
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addBrElement() {
        String string = "br";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addCaptionElement(List list, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "caption";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(1);
        arrayList.add(htmlAttributeDesc);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addCenterElement(List list) {
        String string = "center";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addDdElement(List list) {
        String string = "dd";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, list, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addDirElement(List list) {
        String string = "dir";
        ArrayList arrayList = new ArrayList(1);
        Html3_2DocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addDivElement(List list, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "div";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(1);
        arrayList.add(htmlAttributeDesc);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addDlElement() {
        String string = "dl";
        ArrayList arrayList = new ArrayList(2);
        Html3_2DocDesc.addStringsToList(new String[]{"dt", "dd"}, arrayList);
        ArrayList arrayList2 = new ArrayList(1);
        Html3_2DocDesc.addSelfAttribute(arrayList2, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, arrayList2);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addDtElement(List list) {
        String string = "dt";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, list, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addFontElement(List list) {
        String string = "font";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, null);
        htmlTagDesc.setAttributes(new String[]{"size", "color"});
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addFormElement(List list) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(3);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "action");
        arrayList.add(new HtmlAttributeDesc("method", null, 5));
        arrayList.add(new HtmlAttributeDesc("enctype", null, 5));
        ArrayList arrayList2 = new ArrayList(list.size());
        arrayList2.addAll(list);
        Html3_2DocDesc.removeStringsFromList(arrayList2, new String[]{"form"});
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("form", true, true, arrayList2, arrayList);
        stSupportedElements.put("form", htmlTagDesc);
    }

    private static void addHeadElement() {
        String string = "head";
        String[] stringArray = new String[]{"script", "style", "meta", "link"};
        ArrayList<String> arrayList = new ArrayList<String>(7);
        arrayList.add("title");
        arrayList.add("isindex");
        arrayList.add("base");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, false, false, arrayList, null);
        stSupportedElements.put(string, htmlTagDesc);
        Html3_2DocDesc.addStringsToList(stringArray, arrayList);
    }

    private static void addHrElement(HtmlAttributeDesc htmlAttributeDesc) {
        String string = "hr";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(4);
        arrayList.add(htmlAttributeDesc);
        Html3_2DocDesc.addSelfAttribute(arrayList, "noshade");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "size");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "width");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addImgElement(HtmlAttributeDesc htmlAttributeDesc) {
        String string = "img";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(10);
        Html3_2DocDesc.addRequiredAttribute(arrayList, "src");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "alt");
        arrayList.add(htmlAttributeDesc);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "height");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "width");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "border");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "hspace");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "vspace");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "usemap");
        Html3_2DocDesc.addSelfAttribute(arrayList, "ismap");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addInputElement(HtmlAttributeDesc htmlAttributeDesc) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(8);
        arrayList.add(new HtmlAttributeDesc("type", new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image"}, 5));
        Html3_2DocDesc.addSimpleAttribute(arrayList, "name");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "value");
        Html3_2DocDesc.addSelfAttribute(arrayList, "checked");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "size");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "maxlength");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "src");
        arrayList.add(htmlAttributeDesc);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("input", true, true, null, arrayList);
        stSupportedElements.put("input", htmlTagDesc);
    }

    private static void addIsindexElement() {
        ArrayList arrayList = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "prompt");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("isindex", true, false, null, arrayList);
        stSupportedElements.put("isindex", htmlTagDesc);
    }

    private static void addLiElement(List list) {
        ArrayList arrayList = new ArrayList(2);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "type");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "value");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("li", true, false, list, arrayList);
        stSupportedElements.put("li", htmlTagDesc);
    }

    private static void addLinkElement() {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("link", true, false, null, null);
        htmlTagDesc.setAttributes(new String[]{"href", "rel", "rev", "title"});
        stSupportedElements.put("link", htmlTagDesc);
    }

    private static void addMapElement() {
        ArrayList arrayList = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "name");
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("area");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("map", true, true, arrayList2, arrayList);
        stSupportedElements.put("map", htmlTagDesc);
    }

    private static void addMenuElement(List list) {
        ArrayList arrayList = new ArrayList(1);
        Html3_2DocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("menu", true, true, list, arrayList);
        stSupportedElements.put("menu", htmlTagDesc);
    }

    private static void addMetaElement() {
        ArrayList arrayList = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "http-equiv");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "name");
        Html3_2DocDesc.addRequiredAttribute(arrayList, "content");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("meta", true, false, null, arrayList);
        stSupportedElements.put("meta", htmlTagDesc);
    }

    private static void addOlElement(List list) {
        ArrayList arrayList = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "type");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "start");
        Html3_2DocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ol", true, true, list, arrayList);
        stSupportedElements.put("ol", htmlTagDesc);
    }

    private static void addOptionElement() {
        ArrayList arrayList = new ArrayList(2);
        Html3_2DocDesc.addSelfAttribute(arrayList, "selected");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "value");
        ArrayList<HtmlSpecialToken> arrayList2 = new ArrayList<HtmlSpecialToken>(1);
        arrayList2.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("option", true, true, arrayList2, arrayList);
        stSupportedElements.put("option", htmlTagDesc);
    }

    private static void addPElement(HtmlAttributeDesc htmlAttributeDesc, List list) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(1);
        arrayList.add(htmlAttributeDesc);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("p", true, false, list, arrayList);
        stSupportedElements.put("p", htmlTagDesc);
    }

    private static void addParamElement() {
        ArrayList arrayList = new ArrayList(2);
        Html3_2DocDesc.addRequiredAttribute(arrayList, "name");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "value");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("param", true, false, null, arrayList);
        stSupportedElements.put("param", htmlTagDesc);
    }

    private static void addPreElement(List list) {
        ArrayList arrayList = new ArrayList(1);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "width");
        ArrayList arrayList2 = new ArrayList(35);
        arrayList2.addAll(list);
        Html3_2DocDesc.removeStringsFromList(arrayList2, new String[]{"img", "big", "small", "sub", "sup", "font"});
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("pre", true, true, arrayList2, arrayList);
        stSupportedElements.put("pre", htmlTagDesc);
    }

    private static void addScriptElement() {
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("script", true, true, arrayList, null);
        stSupportedElements.put("script", htmlTagDesc);
    }

    private static void addSelectElement() {
        ArrayList arrayList = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "name");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "size");
        Html3_2DocDesc.addSelfAttribute(arrayList, "multiple");
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("option");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("select", true, true, arrayList2, arrayList);
        stSupportedElements.put("select", htmlTagDesc);
    }

    private static void addStyleElement() {
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("style", true, true, arrayList, null);
        stSupportedElements.put("style", htmlTagDesc);
    }

    private static void addTableElement() {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(5);
        arrayList.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4));
        Html3_2DocDesc.addSimpleAttribute(arrayList, "width");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "border");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "cellspacing");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "cellpadding");
        ArrayList<String> arrayList2 = new ArrayList<String>(2);
        arrayList2.add("caption");
        arrayList2.add("tr");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("table", true, true, arrayList2, arrayList);
        stSupportedElements.put("table", htmlTagDesc);
    }

    private static void addTextareaElement() {
        ArrayList arrayList = new ArrayList(3);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "name");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "rows");
        Html3_2DocDesc.addSimpleAttribute(arrayList, "cols");
        ArrayList<HtmlSpecialToken> arrayList2 = new ArrayList<HtmlSpecialToken>(1);
        arrayList2.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("textarea", true, true, arrayList2, arrayList);
        stSupportedElements.put("textarea", htmlTagDesc);
    }

    private static void addTdElement(List list, List list2) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("td", true, false, list, list2);
        stSupportedElements.put("td", htmlTagDesc);
    }

    private static void addThElement(List list, List list2) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("th", true, false, list, list2);
        stSupportedElements.put("th", htmlTagDesc);
    }

    private static void addTitleElement() {
        String string = "title";
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, null);
        stSupportedElements.put(string, htmlTagDesc);
    }

    private static void addTrElement(HtmlAttributeDesc htmlAttributeDesc, HtmlAttributeDesc htmlAttributeDesc2) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(2);
        arrayList.add(htmlAttributeDesc);
        arrayList.add(htmlAttributeDesc2);
        ArrayList<String> arrayList2 = new ArrayList<String>(2);
        arrayList2.add("th");
        arrayList2.add("td");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("tr", true, false, arrayList2, arrayList);
        stSupportedElements.put("tr", htmlTagDesc);
    }

    private static void addUlElement(List list) {
        ArrayList arrayList = new ArrayList(2);
        Html3_2DocDesc.addSimpleAttribute(arrayList, "type");
        Html3_2DocDesc.addSelfAttribute(arrayList, "compact");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ul", true, true, list, arrayList);
        stSupportedElements.put("ul", htmlTagDesc);
    }

    static {
        HtmlTagDesc htmlTagDesc;
        String string;
        int n;
        stSupportedElements = new HashMap(280);
        String[] stringArray = new String[]{"tt", "i", "b", "u", "strike", "big", "small", "sub", "sup"};
        String[] stringArray2 = new String[]{"em", "strong", "dfn", "code", "samp", "kbd", "var", "cite"};
        String[] stringArray3 = new String[]{"a", "img", "applet", "font", "basefont", "br", "script", "map"};
        String[] stringArray4 = new String[]{"input", "select", "textarea"};
        String[] stringArray5 = new String[]{"ul", "ol", "dir", "menu"};
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(35);
        Html3_2DocDesc.addStringsToList(stringArray, arrayList);
        Html3_2DocDesc.addStringsToList(stringArray2, arrayList);
        Html3_2DocDesc.addStringsToList(stringArray3, arrayList);
        Html3_2DocDesc.addStringsToList(stringArray4, arrayList);
        arrayList.add(HtmlSpecialToken.PCDATA);
        ArrayList arrayList2 = new ArrayList(20);
        Html3_2DocDesc.addStringsToList(stringArray5, arrayList2);
        String[] stringArray6 = new String[]{"p", "pre", "dl", "div", "center", "blockquote", "form", "isindex", "hr", "table"};
        Html3_2DocDesc.addStringsToList(stringArray6, arrayList2);
        ArrayList arrayList3 = new ArrayList(30);
        arrayList3.addAll(arrayList2);
        arrayList3.addAll(arrayList);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, null);
            stSupportedElements.put(string, htmlTagDesc);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, null);
            stSupportedElements.put(string, htmlTagDesc);
        }
        Html3_2DocDesc.addFontElement(arrayList);
        Html3_2DocDesc.addBasefontElement();
        Html3_2DocDesc.addBrElement();
        ArrayList<Object> arrayList4 = new ArrayList<Object>(100);
        Html3_2DocDesc.addStringsToList(headings, arrayList4);
        arrayList4.addAll(arrayList);
        arrayList4.addAll(arrayList2);
        arrayList4.add("address");
        Html3_2DocDesc.addBodyElement(arrayList4);
        Html3_2DocDesc.addAddressElement(arrayList);
        HtmlAttributeDesc htmlAttributeDesc = new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4);
        Html3_2DocDesc.addDivElement(arrayList4, htmlAttributeDesc);
        Html3_2DocDesc.addCenterElement(arrayList4);
        Html3_2DocDesc.addAElement(arrayList);
        Html3_2DocDesc.addMapElement();
        Html3_2DocDesc.addAreaElement();
        Html3_2DocDesc.addLinkElement();
        HtmlAttributeDesc htmlAttributeDesc2 = new HtmlAttributeDesc("align", new String[]{"top", "middle", "bottom", "left", "right"}, 4);
        Html3_2DocDesc.addImgElement(htmlAttributeDesc2);
        Html3_2DocDesc.addAppletElement(htmlAttributeDesc2, arrayList);
        Html3_2DocDesc.addParamElement();
        Html3_2DocDesc.addHrElement(htmlAttributeDesc);
        Html3_2DocDesc.addPElement(htmlAttributeDesc, arrayList);
        ArrayList<HtmlAttributeDesc> arrayList5 = new ArrayList<HtmlAttributeDesc>(1);
        arrayList5.add(htmlAttributeDesc);
        for (n = 0; n < headings.length; ++n) {
            string = headings[n];
            htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, arrayList5);
            stSupportedElements.put(string, htmlTagDesc);
        }
        Html3_2DocDesc.addPreElement(arrayList);
        Html3_2DocDesc.addBlockquoteElement(arrayList4);
        Html3_2DocDesc.addDlElement();
        Html3_2DocDesc.addDtElement(arrayList);
        Html3_2DocDesc.addDdElement(arrayList3);
        ArrayList<String> arrayList6 = new ArrayList<String>(1);
        arrayList6.add("li");
        Html3_2DocDesc.addOlElement(arrayList6);
        Html3_2DocDesc.addUlElement(arrayList6);
        Html3_2DocDesc.addDirElement(arrayList6);
        Html3_2DocDesc.addMenuElement(arrayList6);
        Html3_2DocDesc.addLiElement(arrayList3);
        Html3_2DocDesc.addFormElement(arrayList4);
        Html3_2DocDesc.addInputElement(htmlAttributeDesc2);
        Html3_2DocDesc.addSelectElement();
        Html3_2DocDesc.addOptionElement();
        Html3_2DocDesc.addTableElement();
        HtmlAttributeDesc htmlAttributeDesc3 = new HtmlAttributeDesc("valign", new String[]{"top", "middle", "bottom"}, 4);
        Html3_2DocDesc.addTrElement(htmlAttributeDesc, htmlAttributeDesc3);
        ArrayList<HtmlAttributeDesc> arrayList7 = new ArrayList<HtmlAttributeDesc>(7);
        Html3_2DocDesc.addSelfAttribute(arrayList7, "nowrap");
        Html3_2DocDesc.addSimpleAttribute(arrayList7, "rowspan");
        Html3_2DocDesc.addSimpleAttribute(arrayList7, "colspan");
        arrayList7.add(htmlAttributeDesc);
        arrayList7.add(htmlAttributeDesc3);
        Html3_2DocDesc.addSimpleAttribute(arrayList7, "width");
        Html3_2DocDesc.addSimpleAttribute(arrayList7, "height");
        Html3_2DocDesc.addThElement(arrayList4, arrayList7);
        Html3_2DocDesc.addTdElement(arrayList4, arrayList7);
        Html3_2DocDesc.addCaptionElement(arrayList, htmlAttributeDesc3);
        Html3_2DocDesc.addHeadElement();
        Html3_2DocDesc.addTitleElement();
        Html3_2DocDesc.addIsindexElement();
        Html3_2DocDesc.addBaseElement();
        Html3_2DocDesc.addMetaElement();
        Html3_2DocDesc.addScriptElement();
        Html3_2DocDesc.addStyleElement();
        string = "html";
        ArrayList<String> arrayList8 = new ArrayList<String>(2);
        arrayList8.add("head");
        arrayList8.add("body");
        htmlTagDesc = new HtmlTagDesc(string, false, false, arrayList8, null);
        htmlTagDesc.setAttributes(new String[]{"version"});
        stSupportedElements.put(string, htmlTagDesc);
    }
}

