/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import java.util.concurrent.TimeUnit;

public class AutoFormattingTime {
    private static final double NANOSECONDS_PER_SECOND = 1.0E9;
    private final int width;
    private final int precision;
    private final long nanoTime;

    public AutoFormattingTime(long nanoTime, int width, int precision) {
        if (width < -1) {
            throw new IllegalArgumentException("Width " + width + " must be >= -1");
        }
        if (precision < 0) {
            throw new IllegalArgumentException("Precision " + precision + " must be >= 0");
        }
        this.width = width;
        this.nanoTime = nanoTime;
        this.precision = precision;
    }

    public AutoFormattingTime(long nanoTime) {
        this(nanoTime, 6, 1);
    }

    public AutoFormattingTime(double timeInSeconds, int width, int precision) {
        this(AutoFormattingTime.secondsToNano(timeInSeconds), width, precision);
    }

    public AutoFormattingTime(double timeInSeconds) {
        this(timeInSeconds, 6, 1);
    }

    private String getFormatString() {
        StringBuilder b = new StringBuilder("%");
        if (this.width != -1) {
            b.append(this.width);
        }
        b.append(".").append(this.precision).append("f %s");
        return b.toString();
    }

    public long getTimeInNanoSeconds() {
        return this.nanoTime;
    }

    public double getTimeInSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(this.getTimeInNanoSeconds());
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String toString() {
        double unitTime = this.getTimeInSeconds();
        String unit = "s";
        if (unitTime > 120.0) {
            unitTime /= 60.0;
            unit = "m";
            if (unitTime > 120.0) {
                unitTime /= 60.0;
                unit = "h";
                if (unitTime > 100.0) {
                    unitTime /= 24.0;
                    unit = "d";
                    if (unitTime > 20.0) {
                        unitTime /= 7.0;
                        unit = "w";
                    }
                }
            }
        }
        return String.format(this.getFormatString(), unitTime, unit);
    }

    private static long secondsToNano(double timeInSeconds) {
        return (long)(1.0E9 * timeInSeconds);
    }
}

