/*
 * Copyright (C) CNRS, INRIA, Université Bordeaux 1, Télécom SudParis
 * See COPYING in top-level directory.
 */

#ifndef __starpu_EV_CODES_H__
#define __starpu_EV_CODES_H__

/* This file defines the event codes that are used by the example
 * module.
 */
#include "ev_codes.h"

/* 7-bits event codes prefix. This identifies the module and thus should be
 * unique.
 * The 0x0? prefix is reserved for eztrace internal use. Thus you can
 * use any prefix between 0x80 and 0xff.
 */
#define starpu_EVENTS_ID    0x10
#define EZTRACE_STARPU_EVENTS_ID SYSTEM_MODULE_ID(starpu_EVENTS_ID)
#define starpu_PREFIX       GENERATE_SYSTEM_MODULE_PREFIX(EZTRACE_STARPU_EVENTS_ID)

/* Define various event codes used by the example module
 * The 2 most significant bytes should correspond to the module id,
 * as below:
 */

// Internals
#define EZTRACE_starpu__starpu_driver_start_job (starpu_PREFIX | 0x0002)
#define EZTRACE_starpu__starpu_driver_end_job (starpu_PREFIX | 0x0004)

// API

#define EZTRACE_starpu_starpu_cublas_init_41 (starpu_PREFIX | 0x29)
#define EZTRACE_starpu_starpu_cublas_init_42 (starpu_PREFIX | 0x2a)
#define EZTRACE_starpu_starpu_cublas_shutdown_43 (starpu_PREFIX | 0x2b)
#define EZTRACE_starpu_starpu_cublas_shutdown_44 (starpu_PREFIX | 0x2c)
#define EZTRACE_starpu_starpu_init_47 (starpu_PREFIX | 0x2f)
#define EZTRACE_starpu_starpu_init_48 (starpu_PREFIX | 0x30)
#define EZTRACE_starpu_starpu_pause_49 (starpu_PREFIX | 0x31)
#define EZTRACE_starpu_starpu_pause_50 (starpu_PREFIX | 0x32)
#define EZTRACE_starpu_starpu_resume_51 (starpu_PREFIX | 0x33)
#define EZTRACE_starpu_starpu_resume_52 (starpu_PREFIX | 0x34)
#define EZTRACE_starpu_starpu_shutdown_53 (starpu_PREFIX | 0x35)
#define EZTRACE_starpu_starpu_shutdown_54 (starpu_PREFIX | 0x36)
#define EZTRACE_starpu_starpu_data_unregister_79 (starpu_PREFIX | 0x4f)
#define EZTRACE_starpu_starpu_data_unregister_80 (starpu_PREFIX | 0x50)
#define EZTRACE_starpu_starpu_data_unregister_no_coherency_81 (starpu_PREFIX | 0x51)
#define EZTRACE_starpu_starpu_data_unregister_no_coherency_82 (starpu_PREFIX | 0x52)
#define EZTRACE_starpu_starpu_data_unregister_submit_83 (starpu_PREFIX | 0x53)
#define EZTRACE_starpu_starpu_data_unregister_submit_84 (starpu_PREFIX | 0x54)
#define EZTRACE_starpu_starpu_data_invalidate_85 (starpu_PREFIX | 0x55)
#define EZTRACE_starpu_starpu_data_invalidate_86 (starpu_PREFIX | 0x56)
#define EZTRACE_starpu_starpu_data_invalidate_submit_87 (starpu_PREFIX | 0x57)
#define EZTRACE_starpu_starpu_data_invalidate_submit_88 (starpu_PREFIX | 0x58)
#define EZTRACE_starpu_starpu_data_acquire_91 (starpu_PREFIX | 0x5b)
#define EZTRACE_starpu_starpu_data_acquire_92 (starpu_PREFIX | 0x5c)
#define EZTRACE_starpu_starpu_data_acquire_on_node_93 (starpu_PREFIX | 0x5d)
#define EZTRACE_starpu_starpu_data_acquire_on_node_94 (starpu_PREFIX | 0x5e)
#define EZTRACE_starpu_starpu_data_acquire_cb_95 (starpu_PREFIX | 0x5f)
#define EZTRACE_starpu_starpu_data_acquire_cb_96 (starpu_PREFIX | 0x60)
#define EZTRACE_starpu_starpu_data_acquire_on_node_cb_97 (starpu_PREFIX | 0x61)
#define EZTRACE_starpu_starpu_data_acquire_on_node_cb_98 (starpu_PREFIX | 0x62)
#define EZTRACE_starpu_starpu_data_release_99 (starpu_PREFIX | 0x63)
#define EZTRACE_starpu_starpu_data_release_100 (starpu_PREFIX | 0x64)
#define EZTRACE_starpu_starpu_data_release_on_node_101 (starpu_PREFIX | 0x65)
#define EZTRACE_starpu_starpu_data_release_on_node_102 (starpu_PREFIX | 0x66)
#define EZTRACE_starpu_starpu_data_request_allocation_105 (starpu_PREFIX | 0x69)
#define EZTRACE_starpu_starpu_data_request_allocation_106 (starpu_PREFIX | 0x6a)
#define EZTRACE_starpu_starpu_malloc_on_node_183 (starpu_PREFIX | 0xb7)
#define EZTRACE_starpu_starpu_malloc_on_node_184 (starpu_PREFIX | 0xb8)
#define EZTRACE_starpu_starpu_free_on_node_185 (starpu_PREFIX | 0xb9)
#define EZTRACE_starpu_starpu_free_on_node_186 (starpu_PREFIX | 0xba)
#define EZTRACE_starpu_starpu_mpi_isend_311 (starpu_PREFIX | 0x137)
#define EZTRACE_starpu_starpu_mpi_isend_312 (starpu_PREFIX | 0x138)
#define EZTRACE_starpu_starpu_mpi_irecv_313 (starpu_PREFIX | 0x139)
#define EZTRACE_starpu_starpu_mpi_irecv_314 (starpu_PREFIX | 0x13a)
#define EZTRACE_starpu_starpu_mpi_send_315 (starpu_PREFIX | 0x13b)
#define EZTRACE_starpu_starpu_mpi_send_316 (starpu_PREFIX | 0x13c)
#define EZTRACE_starpu_starpu_mpi_recv_317 (starpu_PREFIX | 0x13d)
#define EZTRACE_starpu_starpu_mpi_recv_318 (starpu_PREFIX | 0x13e)
#define EZTRACE_starpu_starpu_mpi_isend_detached_319 (starpu_PREFIX | 0x13f)
#define EZTRACE_starpu_starpu_mpi_isend_detached_320 (starpu_PREFIX | 0x140)
#define EZTRACE_starpu_starpu_mpi_irecv_detached_321 (starpu_PREFIX | 0x141)
#define EZTRACE_starpu_starpu_mpi_irecv_detached_322 (starpu_PREFIX | 0x142)
#define EZTRACE_starpu_starpu_mpi_wait_323 (starpu_PREFIX | 0x143)
#define EZTRACE_starpu_starpu_mpi_wait_324 (starpu_PREFIX | 0x144)
#define EZTRACE_starpu_starpu_mpi_test_325 (starpu_PREFIX | 0x145)
#define EZTRACE_starpu_starpu_mpi_test_326 (starpu_PREFIX | 0x146)
#define EZTRACE_starpu_starpu_mpi_barrier_327 (starpu_PREFIX | 0x147)
#define EZTRACE_starpu_starpu_mpi_barrier_328 (starpu_PREFIX | 0x148)
#define EZTRACE_starpu_starpu_mpi_init_329 (starpu_PREFIX | 0x149)
#define EZTRACE_starpu_starpu_mpi_init_330 (starpu_PREFIX | 0x14a)
#define EZTRACE_starpu_starpu_mpi_initialize_331 (starpu_PREFIX | 0x14b)
#define EZTRACE_starpu_starpu_mpi_initialize_332 (starpu_PREFIX | 0x14c)
#define EZTRACE_starpu_starpu_mpi_initialize_extended_333 (starpu_PREFIX | 0x14d)
#define EZTRACE_starpu_starpu_mpi_initialize_extended_334 (starpu_PREFIX | 0x14e)
#define EZTRACE_starpu_starpu_mpi_shutdown_335 (starpu_PREFIX | 0x14f)
#define EZTRACE_starpu_starpu_mpi_shutdown_336 (starpu_PREFIX | 0x150)
#define EZTRACE_starpu_starpu_mpi_get_data_on_node_337 (starpu_PREFIX | 0x151)
#define EZTRACE_starpu_starpu_mpi_get_data_on_node_338 (starpu_PREFIX | 0x152)
#define EZTRACE_starpu_starpu_mpi_get_data_on_node_detached_339 (starpu_PREFIX | 0x153)
#define EZTRACE_starpu_starpu_mpi_get_data_on_node_detached_340 (starpu_PREFIX | 0x154)
#define EZTRACE_starpu_starpu_mpi_redux_data_341 (starpu_PREFIX | 0x155)
#define EZTRACE_starpu_starpu_mpi_redux_data_342 (starpu_PREFIX | 0x156)
#define EZTRACE_starpu_starpu_mpi_scatter_detached_343 (starpu_PREFIX | 0x157)
#define EZTRACE_starpu_starpu_mpi_scatter_detached_344 (starpu_PREFIX | 0x158)
#define EZTRACE_starpu_starpu_mpi_gather_detached_345 (starpu_PREFIX | 0x159)
#define EZTRACE_starpu_starpu_mpi_gather_detached_346 (starpu_PREFIX | 0x15a)
#define EZTRACE_starpu_starpu_mpi_isend_detached_unlock_tag_347 (starpu_PREFIX | 0x15b)
#define EZTRACE_starpu_starpu_mpi_isend_detached_unlock_tag_348 (starpu_PREFIX | 0x15c)
#define EZTRACE_starpu_starpu_mpi_irecv_detached_unlock_tag_349 (starpu_PREFIX | 0x15d)
#define EZTRACE_starpu_starpu_mpi_irecv_detached_unlock_tag_350 (starpu_PREFIX | 0x15e)
#define EZTRACE_starpu_starpu_mpi_isend_array_detached_unlock_tag_351 (starpu_PREFIX | 0x15f)
#define EZTRACE_starpu_starpu_mpi_isend_array_detached_unlock_tag_352 (starpu_PREFIX | 0x160)
#define EZTRACE_starpu_starpu_mpi_irecv_array_detached_unlock_tag_353 (starpu_PREFIX | 0x161)
#define EZTRACE_starpu_starpu_mpi_irecv_array_detached_unlock_tag_354 (starpu_PREFIX | 0x162)
#define EZTRACE_starpu_starpu_mpi_comm_amounts_retrieve_355 (starpu_PREFIX | 0x163)
#define EZTRACE_starpu_starpu_mpi_comm_amounts_retrieve_356 (starpu_PREFIX | 0x164)
#define EZTRACE_starpu_starpu_mpi_cache_flush_357 (starpu_PREFIX | 0x165)
#define EZTRACE_starpu_starpu_mpi_cache_flush_358 (starpu_PREFIX | 0x166)
#define EZTRACE_starpu_starpu_mpi_cache_flush_all_data_359 (starpu_PREFIX | 0x167)
#define EZTRACE_starpu_starpu_mpi_cache_flush_all_data_360 (starpu_PREFIX | 0x168)
#define EZTRACE_starpu_starpu_mpi_data_register_361 (starpu_PREFIX | 0x169)
#define EZTRACE_starpu_starpu_mpi_data_register_362 (starpu_PREFIX | 0x16a)
#define EZTRACE_starpu_starpu_sched_ctx_add_workers_411 (starpu_PREFIX | 0x19b)
#define EZTRACE_starpu_starpu_sched_ctx_add_workers_412 (starpu_PREFIX | 0x19c)
#define EZTRACE_starpu_starpu_sched_ctx_remove_workers_413 (starpu_PREFIX | 0x19d)
#define EZTRACE_starpu_starpu_sched_ctx_remove_workers_414 (starpu_PREFIX | 0x19e)
#define EZTRACE_starpu_starpu_sched_ctx_delete_415 (starpu_PREFIX | 0x19f)
#define EZTRACE_starpu_starpu_sched_ctx_delete_416 (starpu_PREFIX | 0x1a0)
#define EZTRACE_starpu_starpu_sched_ctx_set_inheritor_417 (starpu_PREFIX | 0x1a1)
#define EZTRACE_starpu_starpu_sched_ctx_set_inheritor_418 (starpu_PREFIX | 0x1a2)
#define EZTRACE_starpu_starpu_sched_ctx_set_context_419 (starpu_PREFIX | 0x1a3)
#define EZTRACE_starpu_starpu_sched_ctx_set_context_420 (starpu_PREFIX | 0x1a4)
#define EZTRACE_starpu_starpu_sched_ctx_get_context_421 (starpu_PREFIX | 0x1a5)
#define EZTRACE_starpu_starpu_sched_ctx_get_context_422 (starpu_PREFIX | 0x1a6)
#define EZTRACE_starpu_starpu_sched_ctx_stop_task_submission_423 (starpu_PREFIX | 0x1a7)
#define EZTRACE_starpu_starpu_sched_ctx_stop_task_submission_424 (starpu_PREFIX | 0x1a8)
#define EZTRACE_starpu_starpu_sched_ctx_finished_submit_425 (starpu_PREFIX | 0x1a9)
#define EZTRACE_starpu_starpu_sched_ctx_finished_submit_426 (starpu_PREFIX | 0x1aa)
#define EZTRACE_starpu_starpu_sched_ctx_create_worker_collection_461 (starpu_PREFIX | 0x1cd)
#define EZTRACE_starpu_starpu_sched_ctx_create_worker_collection_462 (starpu_PREFIX | 0x1ce)
#define EZTRACE_starpu_starpu_sched_ctx_delete_worker_collection_463 (starpu_PREFIX | 0x1cf)
#define EZTRACE_starpu_starpu_sched_ctx_delete_worker_collection_464 (starpu_PREFIX | 0x1d0)
#define EZTRACE_starpu_starpu_sched_ctx_get_worker_collection_465 (starpu_PREFIX | 0x1d1)
#define EZTRACE_starpu_starpu_sched_ctx_get_worker_collection_466 (starpu_PREFIX | 0x1d2)
#define EZTRACE_starpu_starpu_prefetch_task_input_on_node_495 (starpu_PREFIX | 0x1ef)
#define EZTRACE_starpu_starpu_prefetch_task_input_on_node_496 (starpu_PREFIX | 0x1f0)
#define EZTRACE_starpu_starpu_malloc_521 (starpu_PREFIX | 0x209)
#define EZTRACE_starpu_starpu_malloc_522 (starpu_PREFIX | 0x20a)
#define EZTRACE_starpu_starpu_free_523 (starpu_PREFIX | 0x20b)
#define EZTRACE_starpu_starpu_free_524 (starpu_PREFIX | 0x20c)
#define EZTRACE_starpu_starpu_malloc_flags_525 (starpu_PREFIX | 0x20d)
#define EZTRACE_starpu_starpu_malloc_flags_526 (starpu_PREFIX | 0x20e)
#define EZTRACE_starpu_starpu_free_flags_527 (starpu_PREFIX | 0x20f)
#define EZTRACE_starpu_starpu_free_flags_528 (starpu_PREFIX | 0x210)
#define EZTRACE_starpu_starpu_tag_wait_537 (starpu_PREFIX | 0x219)
#define EZTRACE_starpu_starpu_tag_wait_538 (starpu_PREFIX | 0x21a)
#define EZTRACE_starpu_starpu_tag_wait_array_539 (starpu_PREFIX | 0x21b)
#define EZTRACE_starpu_starpu_tag_wait_array_540 (starpu_PREFIX | 0x21c)
#define EZTRACE_starpu_starpu_tag_notify_from_apps_541 (starpu_PREFIX | 0x21d)
#define EZTRACE_starpu_starpu_tag_notify_from_apps_542 (starpu_PREFIX | 0x21e)
#define EZTRACE_starpu_starpu_task_init_547 (starpu_PREFIX | 0x223)
#define EZTRACE_starpu_starpu_task_init_548 (starpu_PREFIX | 0x224)
#define EZTRACE_starpu_starpu_task_clean_549 (starpu_PREFIX | 0x225)
#define EZTRACE_starpu_starpu_task_clean_550 (starpu_PREFIX | 0x226)
#define EZTRACE_starpu_starpu_task_create_551 (starpu_PREFIX | 0x227)
#define EZTRACE_starpu_starpu_task_create_552 (starpu_PREFIX | 0x228)
#define EZTRACE_starpu_starpu_task_destroy_553 (starpu_PREFIX | 0x229)
#define EZTRACE_starpu_starpu_task_destroy_554 (starpu_PREFIX | 0x22a)
#define EZTRACE_starpu_starpu_task_submit_555 (starpu_PREFIX | 0x22b)
#define EZTRACE_starpu_starpu_task_submit_556 (starpu_PREFIX | 0x22c)
#define EZTRACE_starpu_starpu_task_submit_to_ctx_557 (starpu_PREFIX | 0x22d)
#define EZTRACE_starpu_starpu_task_submit_to_ctx_558 (starpu_PREFIX | 0x22e)
#define EZTRACE_starpu_starpu_task_wait_559 (starpu_PREFIX | 0x22f)
#define EZTRACE_starpu_starpu_task_wait_560 (starpu_PREFIX | 0x230)
#define EZTRACE_starpu_starpu_task_wait_for_all_561 (starpu_PREFIX | 0x231)
#define EZTRACE_starpu_starpu_task_wait_for_all_562 (starpu_PREFIX | 0x232)
#define EZTRACE_starpu_starpu_task_wait_for_all_in_ctx_563 (starpu_PREFIX | 0x233)
#define EZTRACE_starpu_starpu_task_wait_for_all_in_ctx_564 (starpu_PREFIX | 0x234)
#define EZTRACE_starpu_starpu_task_wait_for_no_ready_565 (starpu_PREFIX | 0x235)
#define EZTRACE_starpu_starpu_task_wait_for_no_ready_566 (starpu_PREFIX | 0x236)
#define EZTRACE_starpu_starpu_task_nready_567 (starpu_PREFIX | 0x237)
#define EZTRACE_starpu_starpu_task_nready_568 (starpu_PREFIX | 0x238)
#define EZTRACE_starpu_starpu_task_nsubmitted_569 (starpu_PREFIX | 0x239)
#define EZTRACE_starpu_starpu_task_nsubmitted_570 (starpu_PREFIX | 0x23a)
#define EZTRACE_starpu_starpu_codelet_init_571 (starpu_PREFIX | 0x23b)
#define EZTRACE_starpu_starpu_codelet_init_572 (starpu_PREFIX | 0x23c)
#define EZTRACE_starpu_starpu_codelet_display_stats_573 (starpu_PREFIX | 0x23d)
#define EZTRACE_starpu_starpu_codelet_display_stats_574 (starpu_PREFIX | 0x23f)
#define EZTRACE_starpu_starpu_parallel_task_barrier_init_577 (starpu_PREFIX | 0x241)
#define EZTRACE_starpu_starpu_parallel_task_barrier_init_578 (starpu_PREFIX | 0x242)
#define EZTRACE_starpu_starpu_parallel_task_barrier_init_n_579 (starpu_PREFIX | 0x243)
#define EZTRACE_starpu_starpu_parallel_task_barrier_init_n_580 (starpu_PREFIX | 0x244)
#define EZTRACE_starpu_starpu_task_dup_581 (starpu_PREFIX | 0x245)
#define EZTRACE_starpu_starpu_task_dup_582 (starpu_PREFIX | 0x246)
#define EZTRACE_starpu_starpu_task_bundle_create_587 (starpu_PREFIX | 0x24b)
#define EZTRACE_starpu_starpu_task_bundle_create_588 (starpu_PREFIX | 0x24c)
#define EZTRACE_starpu_starpu_task_bundle_insert_589 (starpu_PREFIX | 0x24d)
#define EZTRACE_starpu_starpu_task_bundle_insert_590 (starpu_PREFIX | 0x24e)
#define EZTRACE_starpu_starpu_task_bundle_remove_591 (starpu_PREFIX | 0x24f)
#define EZTRACE_starpu_starpu_task_bundle_remove_592 (starpu_PREFIX | 0x250)
#define EZTRACE_starpu_starpu_task_bundle_close_593 (starpu_PREFIX | 0x251)
#define EZTRACE_starpu_starpu_task_bundle_close_594 (starpu_PREFIX | 0x252)
#define EZTRACE_starpu_starpu_create_sync_task_595 (starpu_PREFIX | 0x253)
#define EZTRACE_starpu_starpu_create_sync_task_596 (starpu_PREFIX | 0x254)
#define EZTRACE_starpu_starpu_execute_on_each_worker_691 (starpu_PREFIX | 0x2b3)
#define EZTRACE_starpu_starpu_execute_on_each_worker_692 (starpu_PREFIX | 0x2b4)
#define EZTRACE_starpu_starpu_execute_on_each_worker_ex_693 (starpu_PREFIX | 0x2b5)
#define EZTRACE_starpu_starpu_execute_on_each_worker_ex_694 (starpu_PREFIX | 0x2b6)
#define EZTRACE_starpu_starpu_execute_on_specific_workers_695 (starpu_PREFIX | 0x2b7)
#define EZTRACE_starpu_starpu_execute_on_specific_workers_696 (starpu_PREFIX | 0x2b8)
#define EZTRACE_starpu_starpu_data_cpy_697 (starpu_PREFIX | 0x2b9)
#define EZTRACE_starpu_starpu_data_cpy_698 (starpu_PREFIX | 0x2ba)

#endif	/* __starpu_EV_CODES_H__ */
