/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class TerminateInstancesRequestMarshaller
implements Marshaller<Request<TerminateInstancesRequest>, TerminateInstancesRequest> {
    public Request<TerminateInstancesRequest> marshall(TerminateInstancesRequest terminateInstancesRequest) {
        if (terminateInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "TerminateInstances");
        request.addParameter("Version", "2013-10-15");
        if (terminateInstancesRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)terminateInstancesRequest.isDryRun()));
        }
        List<String> instanceIdsList = terminateInstancesRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        return request;
    }
}

