/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ms" locale.
 */
public class LocalizedNamesImpl_ms extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MY",
        "ID",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "NL",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "TD",
        "CV",
        "KY",
        "CX",
        "CL",
        "CN",
        "CC",
        "CO",
        "KM",
        "CG",
        "CK",
        "CP",
        "HR",
        "CU",
        "CD",
        "DK",
        "DG",
        "DM",
        "EA",
        "EC",
        "SV",
        "AE",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "PT",
        "FJ",
        "PH",
        "FI",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GE",
        "GG",
        "GH",
        "GI",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "IN",
        "HN",
        "HK",
        "HU",
        "IC",
        "IS",
        "IM",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IL",
        "IT",
        "JM",
        "JE",
        "JP",
        "DE",
        "DJ",
        "JO",
        "CM",
        "CA",
        "KZ",
        "KH",
        "KE",
        "MH",
        "SB",
        "CY",
        "KI",
        "CR",
        "KW",
        "KG",
        "LA",
        "LV",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LB",
        "LU",
        "MO",
        "MK",
        "MG",
        "MA",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "ME",
        "MX",
        "EG",
        "MF",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "MP",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "CI",
        "PG",
        "PY",
        "FR",
        "PE",
        "PN",
        "PL",
        "PR",
        "QA",
        "QO",
        "CF",
        "CZ",
        "DO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "EH",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "KR",
        "SN",
        "ES",
        "CS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "GS",
        "LK",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TA",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "GB",
        "UM",
        "UY",
        "KP",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "GR",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AE", "Emiriah Arab Bersatu");
    namesMap.put("AG", "Antigua dan Barbuda");
    namesMap.put("BA", "Bosnia dan Herzegovina");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Cocos (Keeling) Islands");
    namesMap.put("CD", "Democratic Republic of the Congo");
    namesMap.put("CF", "Republik Afrika Tengah");
    namesMap.put("CG", "Congo");
    namesMap.put("CI", "Pantai Gading");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Cina");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CS", "Serbia dan Montenegro");
    namesMap.put("CY", "Kibris");
    namesMap.put("CZ", "Republik Czech");
    namesMap.put("DE", "Jerman");
    namesMap.put("DJ", "Jibouti");
    namesMap.put("DO", "Republik Dominican");
    namesMap.put("DZ", "Aljazair");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Barat");
    namesMap.put("ES", "Sepanyol");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("FR", "Perancis");
    namesMap.put("GR", "Yunani");
    namesMap.put("GW", "Guinea Bissau");
    namesMap.put("HU", "Hungari");
    namesMap.put("IN", "Hindia");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JP", "Jepun");
    namesMap.put("KH", "Kemboja");
    namesMap.put("KN", "Saint Kitts dan Nevis");
    namesMap.put("KP", "Utara Korea");
    namesMap.put("KR", "Selatan Korea");
    namesMap.put("LB", "Lubnan");
    namesMap.put("LU", "Luksembourg");
    namesMap.put("MA", "Maghribi");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kepulauan Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "Macao");
    namesMap.put("MV", "Maldiv");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NL", "Belanda");
    namesMap.put("PH", "Filipina");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinian Territory");
    namesMap.put("PT", "Feringgi");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kepulauan Solomon");
    namesMap.put("SG", "Singapura");
    namesMap.put("SL", "Siera Leon");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome dan Principe");
    namesMap.put("TD", "Cad");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad dan Tobago");
    namesMap.put("UM", "United States Minor Outlying Islands");
    namesMap.put("US", "Amerika Syarikat");
    namesMap.put("VA", "Vatican");
    namesMap.put("VC", "Saint Vincent dan Grenadines");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Selatan");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AE": "Emiriah Arab Bersatu",
        "AG": "Antigua dan Barbuda",
        "BA": "Bosnia dan Herzegovina",
        "CA": "Kanada",
        "CC": "Cocos (Keeling) Islands",
        "CD": "Democratic Republic of the Congo",
        "CF": "Republik Afrika Tengah",
        "CG": "Congo",
        "CI": "Pantai Gading",
        "CL": "Cile",
        "CM": "Kamerun",
        "CN": "Cina",
        "CR": "Kosta Rika",
        "CS": "Serbia dan Montenegro",
        "CY": "Kibris",
        "CZ": "Republik Czech",
        "DE": "Jerman",
        "DJ": "Jibouti",
        "DO": "Republik Dominican",
        "DZ": "Aljazair",
        "EG": "Mesir",
        "EH": "Sahara Barat",
        "ES": "Sepanyol",
        "FK": "Falkland Islands",
        "FR": "Perancis",
        "GR": "Yunani",
        "GW": "Guinea Bissau",
        "HU": "Hungari",
        "IN": "Hindia",
        "IT": "Itali",
        "JM": "Jamaika",
        "JP": "Jepun",
        "KH": "Kemboja",
        "KN": "Saint Kitts dan Nevis",
        "KP": "Utara Korea",
        "KR": "Selatan Korea",
        "LB": "Lubnan",
        "LU": "Luksembourg",
        "MA": "Maghribi",
        "MG": "Madagaskar",
        "MH": "Kepulauan Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MO": "Macao",
        "MV": "Maldiv",
        "MX": "Meksiko",
        "MZ": "Mozambik",
        "NL": "Belanda",
        "PH": "Filipina",
        "PN": "Pitcairn",
        "PS": "Palestinian Territory",
        "PT": "Feringgi",
        "SA": "Arab Saudi",
        "SB": "Kepulauan Solomon",
        "SG": "Singapura",
        "SL": "Siera Leon",
        "SR": "Surinam",
        "ST": "Sao Tome dan Principe",
        "TD": "Cad",
        "TJ": "Tadjikistan",
        "TR": "Turki",
        "TT": "Trinidad dan Tobago",
        "UM": "United States Minor Outlying Islands",
        "US": "Amerika Syarikat",
        "VA": "Vatican",
        "VC": "Saint Vincent dan Grenadines",
        "YE": "Yaman",
        "ZA": "Afrika Selatan"
    };
  }-*/;
}
