/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.server.DefaultVisitor;
import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.MessageCatalogFactory;
import com.google.gwt.i18n.server.MessageFormatUtils;
import com.google.gwt.i18n.server.MessageInterface;
import com.google.gwt.i18n.server.MessageInterfaceVisitor;
import com.google.gwt.i18n.server.MessageTranslation;
import com.google.gwt.i18n.server.MessageVisitor;
import com.google.gwt.i18n.server.Parameter;
import com.google.gwt.i18n.shared.GwtLocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class PropertyCatalogFactory
implements MessageCatalogFactory {
    static final String SELECTOR_BOILERPLATE_1 = "# Lines of the form key[form|form]=msg are for alternate forms of";
    static final String SELECTOR_BOILERPLATE_2 = "# the message according to Plural Count and Selector entries above.";
    static final String STRINGMAP_BOILERPLATE_1 = "# Lines of the form key[entry]=msg are for individual entries, and";
    static final String STRINGMAP_BOILERPLATE_2 = "# the line without [] lists the entries, separated by commas.";

    public String getExtension() {
        return ".properties";
    }

    public MessageCatalogFactory.Writer getWriter(MessageCatalogFactory.Context context, String fileName) {
        PrintWriter pw = context.createTextFile(fileName, "UTF-8");
        if (pw == null) {
            return null;
        }
        PropertiesWriter writer = new PropertiesWriter(pw);
        return writer;
    }

    private static class PropertiesWriter
    extends DefaultVisitor
    implements MessageCatalogFactory.Writer {
        private final PrintWriter writer;
        private String baseKey;

        private static String stringJoin(String joiner, String ... values) {
            StringBuilder buf = new StringBuilder();
            boolean needsJoiner = false;
            for (String value : values) {
                if (needsJoiner) {
                    buf.append(joiner);
                } else {
                    needsJoiner = true;
                }
                buf.append(value);
            }
            return buf.toString();
        }

        public PropertiesWriter(PrintWriter writer) {
            this.writer = writer;
        }

        public void close() throws IOException {
            this.writer.close();
        }

        public void endMessage(Message msg, MessageTranslation trans) {
            this.baseKey = null;
        }

        public MessageInterfaceVisitor visitClass() {
            return this;
        }

        public MessageVisitor visitMessage(Message msg, MessageTranslation trans) {
            String meaning;
            this.writer.println();
            String description = msg.getDescription();
            if (description != null) {
                this.writer.println("# Description: " + description);
            }
            if ((meaning = msg.getMeaning()) != null) {
                this.writer.println("# Meaning: " + meaning);
            }
            List<Parameter> params = msg.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                Parameter param = params.get(i);
                this.writer.print("#   " + i + " - " + param.getName());
                if (param.isAnnotationPresent(Messages.PluralCount.class)) {
                    this.writer.print(", Plural Count");
                }
                if (param.isAnnotationPresent(Messages.Select.class)) {
                    this.writer.print(", Selector");
                }
                if (param.isAnnotationPresent(Messages.Example.class)) {
                    Messages.Example exampleAnnot = param.getAnnotation(Messages.Example.class);
                    this.writer.print(", Example: " + exampleAnnot.value());
                }
                this.writer.println();
            }
            int[] selectorIndices = msg.getSelectorParameterIndices();
            if (selectorIndices.length > 0) {
                if (selectorIndices[0] >= 0) {
                    this.writer.println(PropertyCatalogFactory.SELECTOR_BOILERPLATE_1);
                    this.writer.println(PropertyCatalogFactory.SELECTOR_BOILERPLATE_2);
                } else {
                    this.writer.println(PropertyCatalogFactory.STRINGMAP_BOILERPLATE_1);
                    this.writer.println(PropertyCatalogFactory.STRINGMAP_BOILERPLATE_2);
                }
            }
            this.baseKey = this.quoteKey(msg.getKey());
            this.writer.println(this.baseKey + "=" + this.propertiesMessage(msg.getMessageStyle(), msg.getDefaultMessage()));
            return this;
        }

        public void visitMessageInterface(MessageInterface msgIntf, GwtLocale sourceLocale) {
            this.writer.println("# Messages from " + msgIntf.getQualifiedName());
            this.writer.println("# Source locale " + sourceLocale);
        }

        public void visitTranslation(String[] formNames, boolean isDefault, MessageFormatUtils.MessageStyle style, String msg) {
            if (isDefault) {
                return;
            }
            if (msg == null) {
                msg = "";
            }
            String key = this.baseKey;
            key = key + "[" + PropertiesWriter.stringJoin("|", formNames) + "]";
            this.writer.println(key + "=" + this.propertiesMessage(style, msg));
        }

        private String propertiesMessage(MessageFormatUtils.MessageStyle style, String msg) {
            if (msg == null) {
                return "";
            }
            return this.quoteValue(msg);
        }

        private String quoteKey(String str) {
            str = str.replace("\\", "\\\\");
            str = str.replace(" ", "\\ ");
            return this.quoteSpecial(str);
        }

        private String quoteSpecial(String str) {
            return str.replaceAll("([\f\t\n\r$!=:#])", "\\\\$1");
        }

        private String quoteValue(String str) {
            if ((str = str.replace("\\", "\\\\")).startsWith(" ")) {
                int n;
                for (n = 0; n < str.length() && str.charAt(n) == ' '; ++n) {
                }
                str = str.substring(n);
                while (n-- > 0) {
                    str = "\\ " + str;
                }
            }
            return this.quoteSpecial(str);
        }
    }
}

