/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SCENE_H__
#define __SCENE_H__

#include <QtGui>
#include "qzion.h"

class Scene : public QObject
{
Q_OBJECT

private:
    QZionAbstractCanvas *canvas;
    QTimeLine timeline;
    QZionObject *target;
    int initX, finalX;
    QList<QZionObject *> objects;

public:
    Scene(QZionAbstractCanvas *canvas);
    void add(QZionObject *obj, bool mouseEvents=false);

public Q_SLOTS:
    void valueChanged(qreal);
    void mousePressEvent(QZionObject *, QMouseEvent*);
};

#endif
