#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Generate .h file for TCG code generation.
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012-2014, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out


def generate(events, backend):
    out('/* This file is autogenerated by tracetool, do not edit. */',
        '/* You must include this file after the inclusion of helper.h */',
        '',
        '#ifndef TRACE__GENERATED_TCG_TRACERS_H',
        '#define TRACE__GENERATED_TCG_TRACERS_H',
        '',
        '#include <stdint.h>',
        '',
        '#include "trace.h"',
        '#include "exec/helper-proto.h"',
        '',
        )

    for e in events:
        # just keep one of them
        if "tcg-trans" not in e.properties:
            continue

        # get the original event definition
        e = e.original.original

        out('static inline void %(name_tcg)s(%(args)s)',
            '{',
            name_tcg=e.api(e.QEMU_TRACE_TCG),
            args=e.args)

        if "disable" not in e.properties:
            out('    %(name_trans)s(%(argnames_trans)s);',
                '    gen_helper_%(name_exec)s(%(argnames_exec)s);',
                name_trans=e.event_trans.api(e.QEMU_TRACE),
                name_exec=e.event_exec.api(e.QEMU_TRACE),
                argnames_trans=", ".join(e.event_trans.args.names()),
                argnames_exec=", ".join(e.event_exec.args.names()))

        out('}')

    out('',
        '#endif /* TRACE__GENERATED_TCG_TRACERS_H */')
