#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Generate .h for event description.
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out


def begin(events):
    out('/* This file is autogenerated by tracetool, do not edit. */',
        '',
        '#ifndef TRACE__GENERATED_EVENTS_H',
        '#define TRACE__GENERATED_EVENTS_H',
        '',
        '#include <stdbool.h>',
        ''
        )

    # event identifiers
    out('typedef enum {')

    for e in events:
        out('    TRACE_%s,' % e.name.upper())

    out('    TRACE_EVENT_COUNT',
        '} TraceEventID;',
        )

    # static state
    for e in events:
        if 'disable' in e.properties:
            enabled = 0
        else:
            enabled = 1
        out('#define TRACE_%s_ENABLED %d' % (e.name.upper(), enabled))

    out('#include "trace/event-internal.h"',
        '',
        '#endif  /* TRACE__GENERATED_EVENTS_H */',
        )
