/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QEdje.
 *
 * QEdje is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QEdje is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QEdje.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <QtGui>
#include <QtCore>

#include <qzion.h>
#include <qedje.h>

#include "viewer.h"


int main(int argc, char **argv)
{
    QApplication app(argc, argv);

    Viewer viewer;
    QString filename;
    QString group;
    QStringList args = app.arguments();

    if (args.size() >= 2) {
        filename = args.at(1);
    } else {
        filename = QFileDialog::getOpenFileName(&viewer,
                                                "Choose a file",
                                                QDir::current().path(),
                                                "Edje files (*.edj)");
    }

    if (!viewer.load(filename))
        return -1;

    viewer.resize(400, 400);
    viewer.show();

    if (args.size() >= 3){
        group = args.at(2);
        viewer.setGroup(group);
    }

    return app.exec();
}
