{
  "https://shibboleth-upenn-jams.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://emp193.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Heather Tufts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "heather.tufts@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.zimride.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Zimride, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Zimride, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.zimride.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jason Rosenfeld", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jason@zimride.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDMjCCAhqgAwIBAgIJALHS3L4r3O8gMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3d3dy56aW1yaWRlLmNvbTAeFw0wOTEyMjMyMTA0MDdaFw0xMjEyMjIyMTA0\nMDdaMBoxGDAWBgNVBAMTD3d3dy56aW1yaWRlLmNvbTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBALekemUM1SMHdb8S6D/t4UOb1zOEPTdIBlalJt54soWy\nKomuW4Pj/MqtXu5TiW0EBgXhLK2hvAF5OTMgi2DmegX8rbX4Jz++D+1eYU7F12gj\n3GE0N7Tyi3MUTVknN5T0VlCe76y5xGPbzuyiQLYT+GzD72Sdwv3CUxEKR2ZNVZbx\n7fITgfmR0kNDtqBfwNQLFAX3bi+3blqh0wnPb2CO5YizQ2t966GtePWBHlh2CjrI\nrD2k5l+H3YpL3LM4w6T2FKDXU56rAgAn+iMdWTD5A7roy9n1cSjb9llcZhFCtIJ6\nxdlR729baxZ5qlyalMOLFpb/qtsYqbyeelpAbo3klhECAwEAAaN7MHkwHQYDVR0O\nBBYEFHaFq6OjhJ20qwXkS7ZWkZW+JlbnMEoGA1UdIwRDMEGAFHaFq6OjhJ20qwXk\nS7ZWkZW+JlbnoR6kHDAaMRgwFgYDVQQDEw93d3cuemltcmlkZS5jb22CCQCx0ty+\nK9zvIDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAL8NIMBPZgqFOF\nsR/m+c175/IetIKKcLtYxVh3ux6Op4uXmV1nCg1+/zdh6HXZQFALSIw/MIAI1vKY\ndv7PsIPZUh7uJIJoJBsxkLLpEpBmJMNxPuJOYfyX+EfIF5r1h7WBzI02XT552hfh\nKorYUVwk4cxSSCyQOUgMlbCwFpmrm3pf2nV+EtfXSNK8qzJHYkf7RXqTyUFIcFn1\n8puMz4r4BCddIfpSop9+bImir0waOEJt5SFBIKDhkBIroCK0blEGDnpNC4Uh9SfH\ng+AK//pH5g02ng5dUQQOYETY75O3yMo5LoMHcsBgVxqENAXJKh5u2LvlvqApUIWE\n4rZ5DpaO", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.zimride.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.zimride.com/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://pretrip.travel.ucla.edu/shibboleth/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian Kim", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bkim@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Hemkant Patil", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hpatil@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Belinda Borden", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bborden@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibboleth-wustl-csm.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://netutil.internet2.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "techsupport@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFmzCCBIOgAwIBAgICAfUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDMxMzE5MjEwOFoXDTExMDMx\nNDE5MjEwOFowIDEeMBwGA1UEAxMVbmV0dXRpbC5pbnRlcm5ldDIuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2MPK88VasqNP7nyH5PPN9Q6aup07\nzbLLdVzmz5WHTOq+RYwr/obulctF5EDZz/Q5g6N9w17kMqjegliVk69rJSfI1Y2u\nxFQ72qaGfVJ94PYjfRtF9F1amOyDz67vKYgjM8ggiRHKeYSffwqR/VLQpcu+FnEC\ngRpptBvpDlY0gk+5YoyY78dkPSfeWe495vJqtu+31EE3ezJHTWhKF4lQGfQltdIw\nejYY3ZzqUyGlO8ZHQFAHCqIlrdFTMcklDlT/cMyrKHv7Xaf+OJhVH5OkDJDPr/8z\n0NQJM6v6ZjkI5MxzGXso44+MO1OBZgl6XN1sji4B3FKPVR1qfCOffRA9JQIDAQAB\no4ICpzCCAqMwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYw\nFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSRH2oLDdW8KtMt3U175Ilt\nEH993DB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkG\nA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMT\nIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcB\nAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEF\nBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlo\ndHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2Vl\nY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMB\nBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAgBgNVHREEGTAXghVuZXR1dGlsLmlu\ndGVybmV0Mi5lZHUwDQYJKoZIhvcNAQEFBQADggEBAE0vP5JXYqECgNO/Gak6TIi6\nbhon2d+TgjKKjLK2E5z+k6MBbIK8+q7g928mSKkm0oFBzZXcrjkZ2IlFqr9s8y3/\nl/okVOikGRNWaMB3I1GsLeXu0dRuAwiQ8JQaKZv1sEkgYyEZVEcjx28vYVwCLD61\niD+yUDZWP/MTTwObsQgw0bO7gi27IST6sODcTtfaEOA6Ejz1F91ZmUYVDjOwY0Gl\n30zBGuLeSBlWRMWId8oYbncXTGctmyJybkFOkmxaJZGayV/tmdXmCWDpK/f3to5H\njMwUKDSZRv2aB/77/DUNf+SQ2PDY2B3gK8dw9XQK6K6+WQ6+hDsbykDVzmRhsEc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://netutil1.internet2.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://netutil2.internet2.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://netutil2.internet2.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://netutil1.internet2.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://netutil2.internet2.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://netutil1.internet2.edu/Shibboleth.sso/SAML2/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth.umich.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Michigan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Michigan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.umich.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Liam Hoekenga", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@umich.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Mark Montague", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@umich.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "University of Michigan Webmaster Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "webmaster@umich.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://kualidev.adcom.uci.edu/kuali-dev": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uci.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Josh Drummond", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jdrummon@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Josh Drummond", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jdrummon@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://go.francisella.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://shibboleth-upenn-csm.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://cnics.cirg.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Svend Sorensen", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "svends@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Bill Lober", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "lober@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHzCCBAegAwIBAgICAnwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgzMTE4MTkzOFoXDTExMDkw\nMTE4MTkzOFowJDEiMCAGA1UEAxMZY25pY3MuY2lyZy53YXNoaW5ndG9uLmVkdTCB\nnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAz+X22U5HVo7wO1QOwHnVvY0VZ3h9\nDrWXpX4jT07zQRajkiixxnWEromS+U2JL3nditsAl9R7yiZaJydLFLjC2AhHkPPQ\nB1KnQTz6x2JQjnya4a8srbhl89fb5tf5fBEWztzLw8OS8XZkqU+8ETfqE6catqdp\n2DSxJ9qOEGRg5LUCAwEAAaOCAqswggKnMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMB\nAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQU\nRZ7ETmkIuIGu1gVhm3qmfHK4q14wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2T\nuufKY0WhWqRYMFYxCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRl\ncmF0aW9uMSkwJwYDVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0\neYIBADCBsgYIKwYBBQUHAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNv\nbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1j\nZXJ0cy5wN2IwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1Ud\nHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25j\ncmwyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0g\nBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21t\nb25jYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwJAYDVR0R\nBB0wG4IZY25pY3MuY2lyZy53YXNoaW5ndG9uLmVkdTANBgkqhkiG9w0BAQUFAAOC\nAQEANOJjehWAe2EgFG09L3qsYOWYWjWscxT2GRUQe5TyLpILjdNZCix4rbEMjGmX\nztsDNbZc5F6K3d15deJrbAWiTr96XZAVciqBlAt9R3Ku56PbCry5lZd9+r1P6kxE\nm/upgsfUM/bBi942My31kXPtjqMwSEIlb9Or+uPCN+wKm/wz9vt4IvFIENeEzHjt\n3Fs2/8zHrN2O2q3cObg8J5ZoAMR20cS5yB5U9fkBFiy2box0tzTEcTdkSJgsI1eW\ni18xIzi333IrcFwtjSItARR1S66DVclDHiWfMVUcCViGTRZutJLdRAmrX3tm9bbr\nJMGsfi19kdSBHe1ty5jTRuft+g==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cnics.cirg.washington.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cnics.cirg.washington.edu/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://ersqa.ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Steven Hunter", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Steven.Hunter@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Munish Malik", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Munish.Malik@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Barbara Vanden Borre", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Barbara.VandenBorre@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "http://p-pio-project01.ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Carla Raffetto", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Carla.Raffetto@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jon Bertsch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Jon.Bertsch@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jim Kassenbrock", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Jim.Kassenbrock@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://dev-alfresco.nau.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Northern Arizona University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Northern Arizona University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://home.nau.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Mark Steddom", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mark.steddom@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Ahsan Imam", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ahsan.imam@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://idp.uhd.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFhzCCBG+gAwIBAgICAnowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgyMTIwNDcyOVoXDTExMDgy\nMjIwNDcyOVowFjEUMBIGA1UEAxMLaWRwLnVoZC5lZHUwggEiMA0GCSqGSIb3DQEB\nAQUAA4IBDwAwggEKAoIBAQCXANvM7GAZ9lbBlQxrSYzdSngBVqjwJWepCJQOZOY2\nsysuOvM6OAmTgP3+9NzbuRTaPkbKyxEI+fHCxl4YbMD3vNYD1agieivSJ1Sxa5n9\n7UwIexyfetqfrsgcy8HFuh6hRJj3zTL9+rhRMcguvCFT+aogyCEzHV5ZgS/NWcy3\nTTs6fP/PSa2uPJwKPGibpuj7K5DDaxrp4rTegqrqyOxYqn2JfywTi+TSoCaZOZ9r\nnspIqCMfiOqf/N44zb7bpffzbfkaM4jAqrRM94hCKb88y+/pXO90Ezb7wlrLRAe8\niGNTDRC11GaPYCSFykb2SPbeqh4EFm1BmZ3swwI3Dse1AgMBAAGjggKdMIICmTAO\nBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcD\nAQYIKwYBBQUHAwIwHQYDVR0OBBYEFAymWRX9CrGNIR81JTA0cQ85HMTkMH4GA1Ud\nIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEc\nMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24g\nQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8G\nCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRw\nOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2Vy\ndHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNv\nbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/\noD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggr\nBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9wcmFjdGljZXMucGRmMBYGA1UdEQQPMA2CC2lkcC51aGQuZWR1MA0GCSqGSIb3\nDQEBBQUAA4IBAQAH1tZnvuuVasLUG/x6oY8YRmDlgqK2uL4IOzIuqw7qKvFOvN+S\nkiMJRzQK/8lwtGUF9yP69vt0VgHkpTOZDmCZGem5vLsUmOJZ/xDEZZJ+c7VWe4wO\nWjDn6/akYS3N/Kyd1XuTYBIWG+jzccE5Zp5kQvzpAFSVbLOhwgo0JAatSukfPrXp\nmSMXUM67ZsVTadJo6qIS2LGQkhdluiYLjWev7q9/OLooTUjHS6tnGENUsNeij3l+\nSo9WUk9WIGlwwGLAu283BOzg2fnsTgpZuS2tbQNFpt9JkyBX/SJqCsENb7egtR+s\nDsG2jmpHLN3WP5yEgfJp1TVN8M0eGEiaePvO", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.uhd.edu/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Vince Esquivel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "esquivelv@uhd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Grace Davila", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "davilag@uhd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://idp.uhd.edu/idp/error.jsp", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.uhd.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFhzCCBG+gAwIBAgICAnowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgyMTIwNDcyOVoXDTExMDgy\nMjIwNDcyOVowFjEUMBIGA1UEAxMLaWRwLnVoZC5lZHUwggEiMA0GCSqGSIb3DQEB\nAQUAA4IBDwAwggEKAoIBAQCXANvM7GAZ9lbBlQxrSYzdSngBVqjwJWepCJQOZOY2\nsysuOvM6OAmTgP3+9NzbuRTaPkbKyxEI+fHCxl4YbMD3vNYD1agieivSJ1Sxa5n9\n7UwIexyfetqfrsgcy8HFuh6hRJj3zTL9+rhRMcguvCFT+aogyCEzHV5ZgS/NWcy3\nTTs6fP/PSa2uPJwKPGibpuj7K5DDaxrp4rTegqrqyOxYqn2JfywTi+TSoCaZOZ9r\nnspIqCMfiOqf/N44zb7bpffzbfkaM4jAqrRM94hCKb88y+/pXO90Ezb7wlrLRAe8\niGNTDRC11GaPYCSFykb2SPbeqh4EFm1BmZ3swwI3Dse1AgMBAAGjggKdMIICmTAO\nBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcD\nAQYIKwYBBQUHAwIwHQYDVR0OBBYEFAymWRX9CrGNIR81JTA0cQ85HMTkMH4GA1Ud\nIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEc\nMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24g\nQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8G\nCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRw\nOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2Vy\ndHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNv\nbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/\noD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggr\nBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9wcmFjdGljZXMucGRmMBYGA1UdEQQPMA2CC2lkcC51aGQuZWR1MA0GCSqGSIb3\nDQEBBQUAA4IBAQAH1tZnvuuVasLUG/x6oY8YRmDlgqK2uL4IOzIuqw7qKvFOvN+S\nkiMJRzQK/8lwtGUF9yP69vt0VgHkpTOZDmCZGem5vLsUmOJZ/xDEZZJ+c7VWe4wO\nWjDn6/akYS3N/Kyd1XuTYBIWG+jzccE5Zp5kQvzpAFSVbLOhwgo0JAatSukfPrXp\nmSMXUM67ZsVTadJo6qIS2LGQkhdluiYLjWev7q9/OLooTUjHS6tnGENUsNeij3l+\nSo9WUk9WIGlwwGLAu283BOzg2fnsTgpZuS2tbQNFpt9JkyBX/SJqCsENb7egtR+s\nDsG2jmpHLN3WP5yEgfJp1TVN8M0eGEiaePvO", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.uhd.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Houston-Downtown", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Houston-Downtown", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uhd.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://pesp01.dpi.state.nc.us/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "North Carolina Department of Public Instruction", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "North Carolina Department of Public Instruction", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.dpi.state.nc.us/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Julien Alhour", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jalhour@dpi.state.nc.us", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFnTCCBIWgAwIBAgICAqAwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAxMzE3NTkxNloXDTExMTAx\nNDE3NTkxNlowITEfMB0GA1UEAxMWcGVzcDAxLmRwaS5zdGF0ZS5uYy51czCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM0pS/ZvBJT5yHIHA8/RYn7sWmDQ\nlYrNVn0nvw6dtV6MK/yKQybpYyIw9gBIQqDbn12rOMGOvh5hVU9zs2DvwOK3Rj+g\nsfx/bg4HCYwD1LzIfYq+PLblCpocVzTnGiy9igwRCTrqq0vH03jtkB2bZgacVkG9\nXp4lc/OYo3GaM0/hR25GsCvJPshVXT5KFaenf9l2pfo05W6f3zvA7A4EreVe8C5J\nROHrsz2EFm+IsPzvtwpvtqE1RdqxycKtICdQ6xIugO2AjwNzAXwPgvN1p8XBrDXh\nSuDvLSYfsVxnAbF2HmOHxWteCeiFRRb4fs6pAuBaFynUjuWlAk9klx3HKcECAwEA\nAaOCAqgwggKkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQW\nMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUE16kkkBNd2s4jj+pWRZG\n5LNsNc8wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJ\nBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQD\nEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUH\nAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYB\nBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5\naHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9l\nZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4j\nAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwIQYDVR0RBBowGIIWcGVzcDAxLmRw\naS5zdGF0ZS5uYy51czANBgkqhkiG9w0BAQUFAAOCAQEAAFVCw+7YDagfbfiIik8o\nmZWke4kl7eUOshzDKIBkZW4fydzWAyUbiVi9h2uqeLt8VTcUBbERwFM7SNpkXFrV\nVjkqxXT9HnY1nSjYL2cesgrWFpVaJMHyK9mUBfhwjLFUwzga2I+jWnBRix4kOrvT\nOf47yu04zXFoYCw16s3GC1HoHlyOo9Jc6B4Sfn0KbqSb4QeRb0DQV2HMIYdxdvOT\nKqAO3MoCGobkKIHzpZ7Y+Q58o6lyV8TPmD3MGpcWkPyi0CSHRz5Yso/vwKUDqLoB\nfH25XazHIQvT9RWpmuv6jdS2D8SfnnSuWjChpx6PUZ0zX29eKeWV9P4Zd6F30v4v\nNg==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://pesp01.dpi.state.nc.us/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://pesp01.dpi.state.nc.us/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://mon-backup.ncren.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIGGTCCBQGgAwIBAgICAq4wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx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\nbuOj7ajJ5qJ/Yv82NOfPqxt1z4JciTqmIuex6Nw=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }, 
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFmTCCBIGgAwIBAgICArIwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTExODIwMDYyOVoXDTExMTEx\nOTIwMDYyOVowHzEdMBsGA1UEAxMUbW9uLWJhY2t1cC5uY3Jlbi5uZXQwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDasuGrp7FzDIZkxkyKIma0bKnj/d4P\nt342bLnWVnEyAs6S+PFlFy9tyoooLWkuQzN9v3J6Gi/ckf4a4C5nvVF03QmGaOXg\n9Hpfib7Ea+IGAcjRt6zZCx2IOaPGenD+Yw7JhvHGJPhPWJUYY780Prxk+qg/VS1q\nFOxesTX5AQrXf0Oez/jbUKDQ1KeVEJ4HQOYcol75nym6K9nnS76D7Cj+lQUY+Tnq\nSSh7JIPRXb5PoR0a3N2Mcmk0devjKz3BtpHkD8uWf0jT3SNs1hU6EAvXHRlL1e6c\nCedcP9Nq6eyC9GOt2+CbMyWARk5mga90tvBpRb5GZhwUC0uZXe7wfAlnAgMBAAGj\nggKmMIICojAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAU\nBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFMACiAAJ44H3EjxI2GEYYN9F\nLLMpMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYD\nVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMg\nSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEB\nBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUF\nBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9i\ncmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0\ndHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVj\ncmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEE\nAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMB8GA1UdEQQYMBaCFG1vbi1iYWNrdXAu\nbmNyZW4ubmV0MA0GCSqGSIb3DQEBBQUAA4IBAQCR1Vz7WKguxFMLObe4jyqnU4m1\nMnB6bCIYKliK/DoLSY97gWataNDPvqQ8+8j25CsF+drJagIZEhaA1tzVY5tH3vYR\n0XzQUzcdHJJiA39spaMgkRScNx5wHJW1bos/J/dwbi3wqOJbyzD2A7elbaqn5C36\nRk9SoBfzpjT0Ghv9PBt7w9XrdEoWNes5hVwEB21fv2tLaDvMPKzRLRtMDGYAFpmI\nif4BiYlG7tcxo7VgwykH6x3PETg59belALDf0KBJw9aFX7XMcHM+5PJV59A0Bkeb\nM9+EQMcwbFl7c/H/47pq8f3cMXGND/ILYU+lyb2Vx16TVk7GIWqnEczrmG+3", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mon-backup.ncren.net/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mon-backup.ncren.net/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:msu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Michigan State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Michigan State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.msu.edu/home/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matt Kolb", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mk@msu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Matt Kolb", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mk@msu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "John Callaghan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jpc@msu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jim Green", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jfgreen@msu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ehsaweb.wusm.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFGTCCBAGgAwIBAgICAmwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgwNzE3NTIwMloXDTExMDgw\nODE3NTIwMlowITEfMB0GA1UEAxMWZWhzYXdlYi53dXNtLnd1c3RsLmVkdTCBnzAN\nBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAwySBDJeE7cdErQGstGr0dFa1dX2s0ULq\nZ4O1b8P9Rf0cbCRcjcZRiaKxhNSuPoqGQ6BHjiwecnxFvNdxSzu6l8k0ZO6oSJ9n\nMlUDMAZ3PoxkmUerN8BlL8QJAM5GAjefXv/kPIZD1wLrGxtHKGgkLjQWu1An9Jcx\nJkbaBMxYu+MCAwEAAaOCAqgwggKkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8E\nAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUs1LU\nOMSECVdZHi9gLL6uXGmqz00wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufK\nY0WhWqRYMFYxCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0\naW9uMSkwJwYDVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIB\nADCBsgYIKwYBBQUHAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1v\nbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0\ncy5wN2IwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSB\nhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwy\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcw\nVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25j\nYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwIQYDVR0RBBow\nGIIWZWhzYXdlYi53dXNtLnd1c3RsLmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAKc55\nyzgqG+49zWac8rN+bdJYYe6H6oUinQXNTazpr+NfFECMSDRsPRFK0NO4yDPiJFcX\nSF6yJVAqx0g75jsUQdFrVHNgKWSQGtfmTBOOkpEBES/tfBFNnIirvh2wIBt4TZ32\nN32fWvzVcq/k+GPuWccm6ecxaZLTZVxampwWVqxc/e6d5jZSD86pqq+wio6HOaop\nltUYWUdYQ7zMNk+7O51ynX9+Qjah667q0OFAe3bDuf4BuBx1iRy/nxaldEPqkY+m\nU9qSMtc+cVjjo26GxRtowzecVkFJ/+dSWwpAzE5VXIdyVhryr348iS72Pr+c390F\ncQP2sKXtkadC5Bs9dQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ehsaweb.wusm.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ehsaweb.wusm.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ehsaweb.wusm.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ehsaweb.wusm.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://proxy.ohiolink.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDxDCCAqwCCQDfrUQSbrl1bjANBgkqhkiG9w0BAQUFADCBozELMAkGA1UEBhMC\nVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYDVQQKEwhP\naGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlvbjEbMBkG\nA1UEAxMScHJveHkub2hpb2xpbmsuZWR1MR4wHAYJKoZIhvcNAQkBFg9lc2hpY2tz\nQG9hci5uZXQwHhcNMTAwMjAxMTUxMDUyWhcNMTMwMTMxMTUxMDUyWjCBozELMAkG\nA1UEBhMCVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYD\nVQQKEwhPaGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlv\nbjEbMBkGA1UEAxMScHJveHkub2hpb2xpbmsuZWR1MR4wHAYJKoZIhvcNAQkBFg9l\nc2hpY2tzQG9hci5uZXQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDS\nUds+Cl+zzW1BKXDuwRptr/a0FSWJlY1mdNcS1qpJQwGZgUyzwuXKUgVo/Mmwkr5q\n4/1/Qlr9jApQNUaYbzujdFoCTYZ6TA4i4Wd3rfzbZkiLvMwbMTWi0YQfCu6Q1bkh\n7kkRBiFixA4HuESNTuZlpNTppAI6acUeMQQ69aNpbm5zvISI8NvKb42jKt2PHWjV\nFIPzOfzvhWs0M/x759wWMV+r6TsqfVkKjXKMB7hxEzdjTf0ttbpMfC8thDQbz5NZ\nzIeA3XE5GFoD19/tbEDBMs9FRZpi1pObjMYyZAuPX/6iYWmnDX5MGM/ZEaOUjwB+\nf1DMgEz4eWRFZiNpsqW/AgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAExMi9S825cz\nIQ1gf3p+PX4YkUrUhH92f3JeX/NldyA/7ZBWCdt4cWGZ2izUdJsq6W0LZZTJ9Qjr\nTEg/EtgEL/RMEIz52YDXxtM+o9+PDEqBk/BC46ULDo+sJ9szTlmmEP1z4BxTIIry\nLQV/SRz5GiW6cEMwwXvr8wx8U+polk+SduYSgtTO6mofkIWxKmSeL4LqPfbrIB6a\n12MP5H/OvtNSbqLTedRfJefxGqDmqn5Ias/pW/ZGYU1oY20bT1qL6LqjNSzCFxLO\ne7vWtJ3IHcu89hAkwkvKW4SKchucYu/DkyBwG2HaWohrwxOOlTgllrXDj3pZrQcG\nXlRmGG2r7d4=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://proxy.ohiolink.edu:9100/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://proxy.ohiolink.edu:9100/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://indigo01.apple.com/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.apple.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Yuemin Yu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itunesu-shib@group.apple.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.tools.ucla.net/shibboleth/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Michael Van Norman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mvn@ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Michael Van Norman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mvn@ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "noc@ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "urn:mace:incommon:asu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Arizona State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Arizona State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.asu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Scott Banks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Scott.Banks@asu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "UTO EDNA Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ednateam@asu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "UTO EDNA Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ednateam@asu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibboleth.turnitin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Iparadigms, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Iparadigms, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.iparadigms.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "David Wu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "davidw@iparadigms.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:buffalo.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University At Buffalo, The State University of New York", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "The State University of New York at Buffalo", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.buffalo.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Joel W. Murphy", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jmurphy@buffalo.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "EIS Auth Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "auth-support@buffalo.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Charles Dunn", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "chuck@buffalo.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "EIS Auth Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "auth-support@buffalo.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "UB/CIT Web Login Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "weblogin-support@buffalo.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://spaces.umbc.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.umbc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jason Griego", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jcgriego@umbc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Paul Riddle", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "paulr@umbc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://jhutickets.universitytickets.com/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "UniversityTickets", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "UniversityTickets", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://universitytickets.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "UniversityTickets Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@universitytickets.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Gordon Capreol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gcapreol@universitytickets.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://www-shib.stanford.edu/shibboleth/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.stanford.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bruce Vincent", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bvincent@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Scotty Logan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "swl@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://idp.sfsu.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDGzCCAgOgAwIBAgIUaVXwsxeZ7HtpgzDRqkb/SXmxNCUwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwLnNmc3UuZWR1MB4XDTEwMDExMjE3NTg0OVoXDTMw\nMDExMjE3NTg0OVowFzEVMBMGA1UEAxMMaWRwLnNmc3UuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnM2TW44FPEMlaZShdBub38iLLGtpvvtTZVvC\ntLo6xRQx0YCPYIQua2hxjf5lYFMe2KlwehxuCfujsTbegBX8TNg86NaN2s5iTFk7\nQ7BKY0o1UGEHhmELKZx/BVSH1AB0qwk1ZF9jGyynTITRwRGsr1yLvFM3aTH1tB4s\niMpTTp7U4HfWcfCsAepxVJw8o8Nvgujgi6E8Mh4emTz+PdNmx0cgpiu7EpvruUEk\nELlHifyFRhCCBUeOtxgsJXvXgqIYxLlxcz7aGnsylTCgX8fN2WABkJte90Cv06EU\nmkCnB4x8pKLxSfVkLDRDImpqPwnTjmizD6neSRQ5ano4qdAm9wIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAuc2ZzdS5lZHWGI2h0dHBzOi8vaWRwLnNmc3UuZWR1L2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBT7bbal9a/eJjoYsQd6Stdkk9D6uTANBgkq\nhkiG9w0BAQUFAAOCAQEAB2UmDPQkEVR8YPNCUZS2+XjA5Pw7vdswtZpqLbN4x2RG\nAFnaUFs4Qw5/9RScVOdfuSKjbB32LSJzOTLUc2LA2zUhAcieprD9wBcW2gIVnpPC\nPQxMSI7vD7YuF6erW/qFh+gZwBod/PPmP30wy4uDAcWfW09f79wWv67v8ePXS/PA\nWw8M8pNXffLcYo8NAdTY1ZddhYsqcAduFzL4Q0u/+QpV4K2qpMOK57sJ/4GuI0i4\nTF+IPVqP9ibO/PX7scYZDBm8wGCQ3G3UwADAQxJlSTJzyP7PthgH3ublYb3IbrY6\nOQKTDUHTSx//VpESlGrhleDG/BalOfbtxZka2UF05A==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.sfsu.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Supakit Kiatrungrit", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "supakitk@sfsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Joellen Fung", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jfung@sfsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Technical support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "systems@sfsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.sfsu.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.sfsu.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.sfsu.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.sfsu.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDGzCCAgOgAwIBAgIUaVXwsxeZ7HtpgzDRqkb/SXmxNCUwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwLnNmc3UuZWR1MB4XDTEwMDExMjE3NTg0OVoXDTMw\nMDExMjE3NTg0OVowFzEVMBMGA1UEAxMMaWRwLnNmc3UuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnM2TW44FPEMlaZShdBub38iLLGtpvvtTZVvC\ntLo6xRQx0YCPYIQua2hxjf5lYFMe2KlwehxuCfujsTbegBX8TNg86NaN2s5iTFk7\nQ7BKY0o1UGEHhmELKZx/BVSH1AB0qwk1ZF9jGyynTITRwRGsr1yLvFM3aTH1tB4s\niMpTTp7U4HfWcfCsAepxVJw8o8Nvgujgi6E8Mh4emTz+PdNmx0cgpiu7EpvruUEk\nELlHifyFRhCCBUeOtxgsJXvXgqIYxLlxcz7aGnsylTCgX8fN2WABkJte90Cv06EU\nmkCnB4x8pKLxSfVkLDRDImpqPwnTjmizD6neSRQ5ano4qdAm9wIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAuc2ZzdS5lZHWGI2h0dHBzOi8vaWRwLnNmc3UuZWR1L2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBT7bbal9a/eJjoYsQd6Stdkk9D6uTANBgkq\nhkiG9w0BAQUFAAOCAQEAB2UmDPQkEVR8YPNCUZS2+XjA5Pw7vdswtZpqLbN4x2RG\nAFnaUFs4Qw5/9RScVOdfuSKjbB32LSJzOTLUc2LA2zUhAcieprD9wBcW2gIVnpPC\nPQxMSI7vD7YuF6erW/qFh+gZwBod/PPmP30wy4uDAcWfW09f79wWv67v8ePXS/PA\nWw8M8pNXffLcYo8NAdTY1ZddhYsqcAduFzL4Q0u/+QpV4K2qpMOK57sJ/4GuI0i4\nTF+IPVqP9ibO/PX7scYZDBm8wGCQ3G3UwADAQxJlSTJzyP7PthgH3ublYb3IbrY6\nOQKTDUHTSx//VpESlGrhleDG/BalOfbtxZka2UF05A==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.sfsu.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.sfsu.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "San Francisco State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "San Francisco State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sfsu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://go.nwrce.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://portal.stage.calstate.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Office of the Chancellor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Office of the Chancellor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.calstate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Marcus Mizushima", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "iamadmin@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Gabriel Sroka", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "iamadmin@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://portal.stage.calstate.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDADCCAeigAwIBAgIJAKvF8KnK9Ry9MA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE2Nvd2V3dndzd2ViMDIuY3N1Y28wHhcNMDkxMTIzMjMxMjQzWhcNMTkxMTIx\nMjMxMjQzWjAeMRwwGgYDVQQDExNjb3dld3Z3c3dlYjAyLmNzdWNvMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqov7mp82T5Kzn4f7/59uDftwpWQl40DD\nSrwOCylUnvCQOBB7gg6RwLrcGT9hPnpBBlDvO83e0Wvmr1+ooDdNTYhUsSCPjKQ2\n9eCq2d7ZjaYQBA9BKzNAFrtYuceTyKMlOrzc7CYv6dHjUFEUelBQUpxicXmObgUk\nbQjir0Wepqs/OJxgIh+T5rRuXS8+wPj1pFTjrcVKcgQxzQu9UNkpUmzuTw4hJB+R\neqiBEBgOYpIry/a10j8WTIkDY8nZjyamAOFMm2T+FE4yvldRiJIGxpXVdTP0aokK\nNWtpFKv/NRO2Iy6E5xl2b74YJuX2/HXVnuxDqWJDU48cLF8iyigs2wIDAQABo0Ew\nPzAeBgNVHREEFzAVghNjb3dld3Z3c3dlYjAyLmNzdWNvMB0GA1UdDgQWBBTAJd2B\nsPGXaMbAfH/L+MhocbiHbTANBgkqhkiG9w0BAQUFAAOCAQEAFBcrDb2pjnbuVAND\nc6ybEcvAkzHTSlDV9fsReKPKHsc19ZXcQmvUKkrns4qmzHQJxprgysLlh1Pgp5RV\n/c9O5JA+kRX3RS1rmBkXaqD19RH2+Zc7DfYMCqqmGCD/rjSXHyq0CnzXnH4g9GAZ\nTRlro1Shf3xcUb4u656UOMHgdgvYpK7G5f1FBk8J68Fn51ZzSMubn9csjxLNpaan\ngXXcNKwD22Rn2QgfTqbQFpbcNoFc0Pho7RBGSEOONjwifBy4pLymalMc7LtdCo9A\nCJZ+DNhz3cSytDrLoweyQ9DNPaj/nJRibrx7+BSLgKWUcN/s3DikDqewi7WTsvR6\nF5g9UA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://portal.stage.calstate.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://portal.stage.calstate.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://portal.stage.calstate.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://portal.stage.calstate.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://gis.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFBzCCA++gAwIBAgICAoMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkwMzE3NTU0MFoXDTExMDkw\nNDE3NTU0MFowGDEWMBQGA1UEAxMNZ2lzLnd1c3RsLmVkdTCBnzANBgkqhkiG9w0B\nAQEFAAOBjQAwgYkCgYEAvJN0rwCMSxUGz9FNgViSAPw3nGQgEX9BMLUOgt50+EVq\nKvaNXug93R/RSa8JtFydOWMNqsFKFHorPkagrYScCxy35NiFE0uRUSTBQj3MxjHf\nbqP6qMVI2mJANBQgjpuBKAZXRNhFUg5m+iOAPtx6E1Q7fFPjR2j8scJs+tCj0XMC\nAwEAAaOCAp8wggKbMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1Ud\nJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUDxp2k5JAITSAnKTV\n4Toli9ULRw0wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYx\nCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYD\nVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYB\nBQUHAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYI\nKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2g\nO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2Ny\nbC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEE\nAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwGAYDVR0RBBEwD4INZ2lzLnd1\nc3RsLmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAs96oK5nRhYcprDm01jMvVSjUnRdw\nFTig4k2amSMD4GIM3e9U24shWLw3NeXnnY0tMarXiUFuJ46Og3OBtjeG6rkk4SZt\ndORGXNWqLVFdlUy2gUJANdMomPMvzNHrSCTYe/X9fZCq7EMkxdfaI/WLKUl1pgjA\naFiaekGNwrTMB/7B+vmVGlFHHVXC8TCPp5vw0IESGqgEoYH2Gh1dG+HCnUZMP/u6\nB3UnrXJQ0UdQ7pajCHU1VLdLv8m4jOYrpjlrxVV2ceWSH4BavQt00Z5obEuH2p5Y\nM1LYpyuE6/0y/Oqqw7vgk0P7V0nwfIK+lCEmP3b9Gdos2W8v/PgxkMiDng==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://gis.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://gis.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://gis.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://gis.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://ctsabbc.uth.tmc.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Texas Health Science Center At Houston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Texas Health Science Center At Houston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uth.tmc.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Fagon Istre", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Fagon.M.Istre@uth.tmc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "OAC Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@uth.tmc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDADCCAeigAwIBAgIJAJaiYQTj7FJ7MA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE2N0c2FiYmMudXRoLnRtYy5lZHUwHhcNMDkwMzIwMDgxNjMwWhcNMTkwMzE4\nMDgxNjMwWjAeMRwwGgYDVQQDExNjdHNhYmJjLnV0aC50bWMuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAviHX2Y48UW+wM8H2fGNJSoaENAXJkgID\n+/zZytL0IzvKoy0IlNai/GpkWbYP3Ree6T3YOvZ4wq3b/+KsMCXfFMutkXeAxJ7q\nY9+g9hPlV/ocDhOBxluz3mtO6FL9L1Xh0EIItEQLkbEEqMbAIfnf1hEoteJUo02V\nji9yWC1EpAqq8hhzkpmfI+0cao6DpNQ6ZsEVkO0OCWwv0/2/NwGK9gj5L1aQpyYU\nGdlsIHa0buTRi4L5Gux6oK1vFrQ/kdAhaA89k5INI/K8veKr0udqacYwkeFRKs+E\ngP6rXN3ZT3Qf8+6qs70FvNzIFx6jzf3A79hQM82u0RptFKaShIirtwIDAQABo0Ew\nPzAeBgNVHREEFzAVghNjdHNhYmJjLnV0aC50bWMuZWR1MB0GA1UdDgQWBBQAISNx\nfvgHw+drUdczCtZ5Rh6liTANBgkqhkiG9w0BAQUFAAOCAQEAqSNBEnKNC2VuGDSA\nrQZik+0qQb+Mrsvuwgr5AZy5B6zBuEPjixeUy6pLJNrC1NLC3kphiGczno4l/ZSh\nibO7evEh2Iel5yIujs9QhY2HwioJDYnIkA7PegcDCowZdt95aZ/F0QHcCrR6mO/o\nZIbllhfeJjyThgAq/hEnzCFwNX6e7KIX4WXfinsRg/TnJaY3qGvslvwyNj3KA6ZM\nH+HtJYLVweMn1QdfPCRHi8stm6Bq4VXI808Y5GL3CSVY3BVfwvwSerFsG1gnZs7N\njFETksl3dj/ldSTIxVSrWbgBPnjnrl4krdxPQhDHEBsz7zfNKP9/gIj5B59V5/da\niPsxBA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML2/ECP"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc.uth.tmc.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://authenticate.bvdep.com/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Safari Books Online", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Safari Books Online", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.safaribooksonline.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Peter Buelens", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pb@bvdep.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Peter Buelens", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pb@bvdep.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Peter Buelens", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pb@bvdep.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibboleth.andrew.cmu.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIExDCCA6ygAwIBAgIJAP4ClGMnqudqMA0GCSqGSIb3DQEBBQUAMIGcMQswCQYD\nVQQGEwJVUzEVMBMGA1UECBMMUGVubnN5bHZhbmlhMRMwEQYDVQQHEwpQaXR0c2J1\ncmdoMRgwFgYDVQQKEw9DYXJuZWdpZSBNZWxsb24xGzAZBgNVBAsTEkNvbXB1dGlu\nZyBTZXJ2aWNlczEqMCgGA1UEAxMhQ2FybmVnaWUgTWVsbG9uIElkZW50aXR5IFBy\nb3ZpZGVyMB4XDTEwMDExMzIwMTI1OVoXDTEyMDExMzIwMTI1OVowgZwxCzAJBgNV\nBAYTAlVTMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWExEzARBgNVBAcTClBpdHRzYnVy\nZ2gxGDAWBgNVBAoTD0Nhcm5lZ2llIE1lbGxvbjEbMBkGA1UECxMSQ29tcHV0aW5n\nIFNlcnZpY2VzMSowKAYDVQQDEyFDYXJuZWdpZSBNZWxsb24gSWRlbnRpdHkgUHJv\ndmlkZXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC3B2Vv7k2LjG+i\n8LZCqQluZS08iU1kTnnclLz/OQHMPyJ9agiitK0PpVhsqOjMOZzbl+8xWX5EzsRN\nzYICfRPz3GuR9zBTLcVrHpe/iW5WC4DesN0Kop0zNZm+tJKrKfR9DWrC2O/R9YCD\nxr8gB7ZfHCGDKkPxTn2w0PkINEIRRsnhRDZ/O2fDIE5A5SxA7ju4y59HOREpMKib\noNAN8qg4gWROyu9G32eBjaelDdF7mPyLTZoEdswpWTWFWaUcL57D7Eg9ymmTskW+\nq0/BvnJOeP6ZshMn+r2NKMPk8fXyqboTkKwbHdxRu6gokOw/gSSLP57MmQRxbuQa\n8FHhHjCTAgMBAAGjggEFMIIBATAdBgNVHQ4EFgQUeIinvzWeb+dCBoabnQAMxQOQ\nW84wgdEGA1UdIwSByTCBxoAUeIinvzWeb+dCBoabnQAMxQOQW86hgaKkgZ8wgZwx\nCzAJBgNVBAYTAlVTMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWExEzARBgNVBAcTClBp\ndHRzYnVyZ2gxGDAWBgNVBAoTD0Nhcm5lZ2llIE1lbGxvbjEbMBkGA1UECxMSQ29t\ncHV0aW5nIFNlcnZpY2VzMSowKAYDVQQDEyFDYXJuZWdpZSBNZWxsb24gSWRlbnRp\ndHkgUHJvdmlkZXKCCQD+ApRjJ6rnajAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEB\nBQUAA4IBAQBHRy62mzquDwGyCGRlTL3BkUYsIaEpWC3vDkc49QGD53kvk3mYvNdt\nsX8p5fw6oMCJDj1LJkZPnMH3XfCWIAfx78PeIXK9cOczBjdD6AhJgY9SjJywLj6F\nsvKV19DtKWApkqtTSf9Ri15Qj6vmapUPqdwOoSnXE8BhRJ5cR90j/EosudHsiN6R\nlFwum4qrdFzLCcDTmoGvEKMiaDBck6nZ+f0W25AU9iSq7eJ8CNj/VPI011LCjVMs\nc5b/2BqyelYgwNr1qImQRv22UPPFg3O9fU0N66D0Mfnr8m7Bta35nk75z3IH6p4S\nQwSKdOyYNp3WOhrHL0VgfsSlj6W3l8Aq", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth.andrew.cmu.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Russell J. Yount", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rjy@cmu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Craig Miron", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cmiron@cmu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Shibboleth Support Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth-team@andrew.cmu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://shibboleth.andrew.cmu.edu/error", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.andrew.cmu.edu/idp/profile/SAML2/POST/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIExDCCA6ygAwIBAgIJAP4ClGMnqudqMA0GCSqGSIb3DQEBBQUAMIGcMQswCQYD\nVQQGEwJVUzEVMBMGA1UECBMMUGVubnN5bHZhbmlhMRMwEQYDVQQHEwpQaXR0c2J1\ncmdoMRgwFgYDVQQKEw9DYXJuZWdpZSBNZWxsb24xGzAZBgNVBAsTEkNvbXB1dGlu\nZyBTZXJ2aWNlczEqMCgGA1UEAxMhQ2FybmVnaWUgTWVsbG9uIElkZW50aXR5IFBy\nb3ZpZGVyMB4XDTEwMDExMzIwMTI1OVoXDTEyMDExMzIwMTI1OVowgZwxCzAJBgNV\nBAYTAlVTMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWExEzARBgNVBAcTClBpdHRzYnVy\nZ2gxGDAWBgNVBAoTD0Nhcm5lZ2llIE1lbGxvbjEbMBkGA1UECxMSQ29tcHV0aW5n\nIFNlcnZpY2VzMSowKAYDVQQDEyFDYXJuZWdpZSBNZWxsb24gSWRlbnRpdHkgUHJv\ndmlkZXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC3B2Vv7k2LjG+i\n8LZCqQluZS08iU1kTnnclLz/OQHMPyJ9agiitK0PpVhsqOjMOZzbl+8xWX5EzsRN\nzYICfRPz3GuR9zBTLcVrHpe/iW5WC4DesN0Kop0zNZm+tJKrKfR9DWrC2O/R9YCD\nxr8gB7ZfHCGDKkPxTn2w0PkINEIRRsnhRDZ/O2fDIE5A5SxA7ju4y59HOREpMKib\noNAN8qg4gWROyu9G32eBjaelDdF7mPyLTZoEdswpWTWFWaUcL57D7Eg9ymmTskW+\nq0/BvnJOeP6ZshMn+r2NKMPk8fXyqboTkKwbHdxRu6gokOw/gSSLP57MmQRxbuQa\n8FHhHjCTAgMBAAGjggEFMIIBATAdBgNVHQ4EFgQUeIinvzWeb+dCBoabnQAMxQOQ\nW84wgdEGA1UdIwSByTCBxoAUeIinvzWeb+dCBoabnQAMxQOQW86hgaKkgZ8wgZwx\nCzAJBgNVBAYTAlVTMRUwEwYDVQQIEwxQZW5uc3lsdmFuaWExEzARBgNVBAcTClBp\ndHRzYnVyZ2gxGDAWBgNVBAoTD0Nhcm5lZ2llIE1lbGxvbjEbMBkGA1UECxMSQ29t\ncHV0aW5nIFNlcnZpY2VzMSowKAYDVQQDEyFDYXJuZWdpZSBNZWxsb24gSWRlbnRp\ndHkgUHJvdmlkZXKCCQD+ApRjJ6rnajAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEB\nBQUAA4IBAQBHRy62mzquDwGyCGRlTL3BkUYsIaEpWC3vDkc49QGD53kvk3mYvNdt\nsX8p5fw6oMCJDj1LJkZPnMH3XfCWIAfx78PeIXK9cOczBjdD6AhJgY9SjJywLj6F\nsvKV19DtKWApkqtTSf9Ri15Qj6vmapUPqdwOoSnXE8BhRJ5cR90j/EosudHsiN6R\nlFwum4qrdFzLCcDTmoGvEKMiaDBck6nZ+f0W25AU9iSq7eJ8CNj/VPI011LCjVMs\nc5b/2BqyelYgwNr1qImQRv22UPPFg3O9fU0N66D0Mfnr8m7Bta35nk75z3IH6p4S\nQwSKdOyYNp3WOhrHL0VgfsSlj6W3l8Aq", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.andrew.cmu.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Carnegie Mellon University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Carnegie Mellon University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.cmu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://aptestbed.wt.nac.uci.edu:47917/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uci.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Max Garrick", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mgarrick@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHTCCBAWgAwIBAgICAl0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDczMDE4MzQzNFoXDTExMDcz\nMTE4MzQzNFowIzEhMB8GA1UEAxMYYXB0ZXN0YmVkLnd0Lm5hYy51Y2kuZWR1MIGf\nMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCwrnxELLotF/55PWX1hFvYKN+fpoFY\nGy9ceh3aEYFLXxit6eNXLzZrdokSx2WqX7p0UgfB0IA5DauN0koTe/llfamx5D08\nMUI9I86I5nFvsZBDuxGUDJ99dILDSEpZ1DJ13+BFb9w0Rn80fpq+yrKDlZyGnfUH\n2M4eyePGkkZxQQIDAQABo4ICqjCCAqYwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB\n/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBTq\nBKL4GILHyKzHId2XtQQ+CehfWjB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO6\n58pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVy\nYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5\nggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29t\nbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNl\ncnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0f\nBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNy\nbDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAE\nVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1v\nbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAjBgNVHREE\nHDAaghhhcHRlc3RiZWQud3QubmFjLnVjaS5lZHUwDQYJKoZIhvcNAQEFBQADggEB\nAA4fsZdww4MbqfDXx62WbQNG3pY3IUw0GgB93gtAxvU13oVMvYet73Yan+XQFc3+\n4sARfK2/IT0HJNJyRDuCBMJQkgfzpRb2I9gid52WSU9EGpb/mL/ow4ys7Ms2yhk7\nRpGFeApiKWfxT2YyvHjGFgRZ6g9HgKSQpaJoWZA/8E0+FIDOhUj5+2cZpA6Wf9nJ\nn2lOJiWwZjBJoZywlkp4MgQJdhYpKptY4oeF2BGlCf3gXWAbIyLGvPAOiZ3+w7o6\n0VmoUnL70P7CL8597DJCoNozO/qgMoNvco3eq/wgsCm8dzod2ELYWcQ5u2kTPS8v\nD0jTI6/uKk4akdF8ZRAkNak=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aptestbed.wt.nac.uci.edu:47917/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aptestbed.wt.nac.uci.edu:47917/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aptestbed.wt.nac.uci.edu:47917/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aptestbed.wt.nac.uci.edu:47917/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://uat68.learn.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Learn.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Learn.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://learn.com/learncenter.asp?id=178409", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ulises Castillo", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ulises.castillo@learn.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ehsappdev1.stanford.edu/shb": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.stanford.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "David Chaskelmann", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dchask@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Palle Nielsen", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pnielsen@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://ucready-win.berkeley.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.berkeley.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Karin Bliman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kbliman@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://wl-shib.eservices.virginia.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.virginia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@Virginia.EDU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "ITC Microsystems", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itc-microsystems@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Hamp Carruth", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ehc@Virginia.EDU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://tools.nwrce.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://sp.eblib.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Ebooks Corporation Limited", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Ebook Library - EBL", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ebookscorporation.com/index.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Dean Herbert", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dean.herbert@eblib.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Drew Watson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "drew.watson@eblib.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Kari Paulson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kari.paulson@eblib.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKTCCAhGgAwIBAgIJALqnKM6pLkNwMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDHNwLmVibGliLmNvbTAeFw0xMDAyMTEwNTM0MDRaFw0xNTA4MDQwNTM0MDRa\nMBcxFTATBgNVBAMTDHNwLmVibGliLmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJZV6beFb089RwJMkMg36np2UzRbUVrL8sIzBWNt01pFzDyYxhM/\np0B768wQrXbMWBE9iK1LZctH8q9La2Pkzeh5k285Me3HpFD3jtvGNekhvQSlOQUU\ngzz9vZZaftSTl4Ik+ExCKEQQYK9nSxjiXJTEPIARpSYvHEXJzx0f5lHofMsmipcB\ncJyEDNKl/ZAxyjwB0Sd27Jf4g1hR9NcWs7qotgEfoV288KVuFMJmK21FPTpwODzO\nSjIBCDb0I1eYaE69ztGfxT8h5Xx5GbxGVB9C3y8QxYGv8gz8GT6HoroOtFII1eRT\ndkvvNDJuHrnO6GM2LuS7iwihTtupKPkhTNUCAwEAAaN4MHYwHQYDVR0OBBYEFOO2\nFIOQFaY9Ba0RpGoM+w7TJZ/zMEcGA1UdIwRAMD6AFOO2FIOQFaY9Ba0RpGoM+w7T\nJZ/zoRukGTAXMRUwEwYDVQQDEwxzcC5lYmxpYi5jb22CCQC6pyjOqS5DcDAMBgNV\nHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCQ+GwyE39IJwGwgorBlRZDbZ7i\noqSVMdisQ6hGjY6CmwZphiRemdk9nZHFUu+y9UGulRGH38F0/OPPBDLHCTL8DQiF\n86SPRdSrZYLiKlOjPjp9LlLo2qatv0rydifJXPnLSUjSce2/Bt9+lNncgx+dmqYZ\nhKgEsDAyqsXZ+jSdnDBbn6W8w5OFfYXS5KcWhdb9bcdTpoWwqSXP2jr1Z7q7KcVQ\nmGcjWn0WcHv8NnPhkJ9GYrGlOgzDowjsAlaxHSRsuEozjrX0bSD9KOEwhnuCkCvp\nX2Z7oPraBw9viS3veLbISqB2b3t3nm4Pc+LSdrkfOq53zEjQyyRAYbZ4AuQT", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://sp.eblib.com/Shibboleth.sso"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:uci.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uci.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian Roode", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bgroode@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "NACS Response Center", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "nacs@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Chris Peters", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cjpeters@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ezproxy.musc.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Medical University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Medical University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.musc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matthew Gregg", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "webmaster@musc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://stwidp01.okstate.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Oklahoma State University Main Campus", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Oklahoma State University Main Campus", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://osu.okstate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "BJ Hoffman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bj.hoffman@okstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://aiswiki.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFkzCCBHugAwIBAgICAqswDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTEwMjE5NTYwOFoXDTExMTEw\nMzE5NTYwOFowHDEaMBgGA1UEAxMRYWlzd2lraS53dXN0bC5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDVhjZwaSxpYxdzUJ8xrlhtgNmKgogQpLhO\nam+ZAm+D/6UL4w0Ib0e90836TI+2JRNx34JqdXag2Tk0N17gYpHG6MG+fly8VksR\nL0rHidZBkUQUltxc47jBJkm1UK+a6ggMLJEKTpdaSFq3JVRVb9kgcPO9CxD5XPex\nV5hwvSB3iTNcDxJ4PMXUgH0XUUbdq3k2241C1stwPZ2kDu1nbGrDvh13HE1SQzan\nYqqBNQYjhkLqk7aB95yw42+Qc3W8/s4XOfDzohhffpipwyoKW1jFP+RjF/g01Wsl\nqe8lx1PUdbMGD0GO5lI4sylGpqDaAlWkLz+z8x8o/IAxGaG06F6BAgMBAAGjggKj\nMIICnzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggr\nBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFK98Q8J+IhbB7+fBH9t5M2DIpYLf\nMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQG\nEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5D\nb21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGl\nMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAC\nhkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlk\nZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6\nLy9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxz\nLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEw\nRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9wcmFjdGljZXMucGRmMBwGA1UdEQQVMBOCEWFpc3dpa2kud3VzdGwu\nZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQBu7FBKEGhi548z/8qDtUJj27NZhmoJiV0B\nuEussm/kBWpKZMwLisBfJ/otYZSTVp9VPJ2U6EiFPBBdHX3cSaJG1g/eSHu0Tg7j\n1495jEdmVLAyzi0MAejiFEc1EDjP8Ao/bH8I2tHO+gA4ahHbVYxByHtNHkcqCw1n\nt6Az1Hc55YgU5SktfOpkMmZtDPpB13EeUUUKvuzqGCYf+OpGnue7EIA5KDHgJNYl\nfS7jVrXaqrrfKLYM9ldFO9ZctcZ/Cz4+gmx8v5uUpCWhTXLqynuNVGV16A7LBBnD\nwHNqxq34+AjTE9SSNkR9FFiAFgw/ZhmSr3bd8kEM3OZuHOwArd5O", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswiki.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswiki.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswiki.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswiki.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:unc.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFhzCCBG+gAwIBAgICAe8wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDIyNTIwMDk1OFoXDTExMDIy\nNjIwMDk1OFowFjEUMBIGA1UEAxMLc3NvLnVuYy5lZHUwggEiMA0GCSqGSIb3DQEB\nAQUAA4IBDwAwggEKAoIBAQCu1p/809RspIbkBHMOAhfjOms1j6yhKSoqKMrQeX05\nWh0acNGG5SYM5TIXlThOqxWY52m2HwnOEa0umRnLjEQgKK1lnRqOs2LQNo5iRLab\nB+pqpd4m1zgVkp1u1LRb0F/qE0TXE0l2DkJrNCGoIhamvNgBoxTwVcs9f2bKy8RD\nrPx/tyh5XYd8/X4nRw7bUXUXBFCF6GNTAhYpKGMdUHsbpfuXM+sVyXVZO0cxnGA7\n/AcWMp4BHNdilRX54uJ4ioAwECh4Dxw60VZeeENYjDW9JsARgoGuda0FLrrZfOex\nAMfZXGrvUDbko16TccPwZWiXyylbMuBuzo2sq+J6aK5tAgMBAAGjggKdMIICmTAO\nBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcD\nAQYIKwYBBQUHAwIwHQYDVR0OBBYEFPKCIKxtSzTD/XZx+QLN/i085COsMH4GA1Ud\nIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEc\nMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24g\nQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8G\nCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRw\nOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2Vy\ndHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNv\nbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/\noD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggr\nBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9wcmFjdGljZXMucGRmMBYGA1UdEQQPMA2CC3Nzby51bmMuZWR1MA0GCSqGSIb3\nDQEBBQUAA4IBAQA3DbkUR0xEze5txCdposWIn+RBWLkpTq+hYK6EayBG76vynije\nVC8tXemkNTinFPcW/cuUulWsJgBtT55ajBkUP2L4/kH27WvvMUzW0nrLRdBppd7F\nYKFassxm8UU1jqmWUIAynubusA9dJ2Ws4/OSrdqSL904yGLKbK06sOjdo239FOHg\nQJk1vexQtA7TDBWatsFTJTVCLU+/AlAsP/DLu5IMU4CmerxdB/WiZ/rdkZftkIMJ\n4Np5f2XpRKMi8ON4d1zN8lNOfFtVbR4dOrLCkuFdJlPiyku4ZBZaWie7e0H6vGll\nG/XQk8xkLEawJyH2ctbDT/xkaichJRXE2eQO", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://sso.unc.edu:7443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "UNC ITRC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "help@unc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "UNC Identity Management", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idman@unc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://sso.unc.edu/idp/error.jsp", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.unc.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.unc.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.unc.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.unc.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFhzCCBG+gAwIBAgICAe8wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDIyNTIwMDk1OFoXDTExMDIy\nNjIwMDk1OFowFjEUMBIGA1UEAxMLc3NvLnVuYy5lZHUwggEiMA0GCSqGSIb3DQEB\nAQUAA4IBDwAwggEKAoIBAQCu1p/809RspIbkBHMOAhfjOms1j6yhKSoqKMrQeX05\nWh0acNGG5SYM5TIXlThOqxWY52m2HwnOEa0umRnLjEQgKK1lnRqOs2LQNo5iRLab\nB+pqpd4m1zgVkp1u1LRb0F/qE0TXE0l2DkJrNCGoIhamvNgBoxTwVcs9f2bKy8RD\nrPx/tyh5XYd8/X4nRw7bUXUXBFCF6GNTAhYpKGMdUHsbpfuXM+sVyXVZO0cxnGA7\n/AcWMp4BHNdilRX54uJ4ioAwECh4Dxw60VZeeENYjDW9JsARgoGuda0FLrrZfOex\nAMfZXGrvUDbko16TccPwZWiXyylbMuBuzo2sq+J6aK5tAgMBAAGjggKdMIICmTAO\nBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcD\nAQYIKwYBBQUHAwIwHQYDVR0OBBYEFPKCIKxtSzTD/XZx+QLN/i085COsMH4GA1Ud\nIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEc\nMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24g\nQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8G\nCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRw\nOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2Vy\ndHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNv\nbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/\noD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggr\nBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9wcmFjdGljZXMucGRmMBYGA1UdEQQPMA2CC3Nzby51bmMuZWR1MA0GCSqGSIb3\nDQEBBQUAA4IBAQA3DbkUR0xEze5txCdposWIn+RBWLkpTq+hYK6EayBG76vynije\nVC8tXemkNTinFPcW/cuUulWsJgBtT55ajBkUP2L4/kH27WvvMUzW0nrLRdBppd7F\nYKFassxm8UU1jqmWUIAynubusA9dJ2Ws4/OSrdqSL904yGLKbK06sOjdo239FOHg\nQJk1vexQtA7TDBWatsFTJTVCLU+/AlAsP/DLu5IMU4CmerxdB/WiZ/rdkZftkIMJ\n4Np5f2XpRKMi8ON4d1zN8lNOfFtVbR4dOrLCkuFdJlPiyku4ZBZaWie7e0H6vGll\nG/XQk8xkLEawJyH2ctbDT/xkaichJRXE2eQO", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://sso.unc.edu:7443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://sso.unc.edu:7443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of North Carolina at Chapel Hill", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of North Carolina at Chapel Hill", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.unc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://cilogon.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uiuc.edu/index.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Terry Fleury", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tfleury@illinois.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Michael Grady", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "m-grady@illinois.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jim Basney", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jbasney@ncsa.illinois.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://cilogon.org/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDVDCCAjygAwIBAgIJAI4ktgTnvdBvMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\nBAMTC2NpbG9nb24ub3JnMB4XDTEwMDEyODE3MzYwNFoXDTEzMDEyNzE3MzYwNFow\nFjEUMBIGA1UEAxMLY2lsb2dvbi5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQCU2+Mqs1OhxQRdrJ+W19BUgquVG/3rxd9EDzwGOWBkO+awCXtRe50p\nLGVXYF/ylNXeAdF2LHICKHB35i/ZNnXj9Y+llarHiTyrrSmYa3OA0Q2YEzSsv6o6\nrk4+SysmnFPLggVbFnqmtCRn7bwAodonhWWfVqwBj+GkO3RoedfCYhfsiKJOTioN\nBc1VXlNlxBeAVYuJuhDzCQnSn+IhLnqKWXpnq2exZfeOG+yfUQB31BONSnCWadFW\nODgybq5q+D4IDFeW+2LmQGNVCjUnB7RTGwRWgj2AHusySohpwDCha1eIqXb+FNGA\nifI2PEgCS69NgBJNMaAvAAjcEUugK0bfAgMBAAGjgaQwgaEwDgYDVR0PAQH/BAQD\nAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAJBgNVHRMEAjAAMB0G\nA1UdDgQWBBS6KexHniS9+CMFdNlM/DILrMQ3AjBGBgNVHSMEPzA9gBS6KexHniS9\n+CMFdNlM/DILrMQ3AqEapBgwFjEUMBIGA1UEAxMLY2lsb2dvbi5vcmeCCQCOJLYE\n573QbzANBgkqhkiG9w0BAQUFAAOCAQEAS4U3vwFFyjsezayUJcVm6PW40HIJW3iV\nqaNv/8dwPFKtX03C3XEMnexFegnZ4cYSTAc5fdpAxaEZjnhTsKsA5aFKHlF1uUYn\n5beFDAbLDn5AlJamBoYn3s8ZOa0x9A1FdrDLSLTUqc1BH1Hz8MRFR/NsD/LdI1I5\n5tIY6A/0lAlOgq/+iRyAzc/NZloHRJriiysJzRLWq1oF2VlW0fgkF7v1tf7oBZjq\nSPTVAuw69SbXBXnaHQXN2DnsdUhepjQTumKi+S1sZhAMW9nVNFXVBkehfr5NUFR+\n8QVxZNy6yZE12GjQMJc6YbNQ8kiC2gzqTimid0/2DzSakuhgAMacNg==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cilogon.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cilogon.org/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cilogon.org/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cilogon.org/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cilogon.org/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://aiswikitest.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "zTest_Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://aiswikitest.wustl.edu/Shibboleth.sso/DS"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://aiswikitest.wustl.edu/Shibboleth.sso/WAYF"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFFzCCA/+gAwIBAgICAnMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgxNzE4MTMxMloXDTExMDgx\nODE4MTMxMlowIDEeMBwGA1UEAxMVYWlzd2lraXRlc3Qud3VzdGwuZWR1MIGfMA0G\nCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlvpCak9jouIQ+MirUdMh41OenlUIQiAEW\nHFfuyTDhx80ecWQLldnwz3v1HFyFgNYgpCfanihUxdWHvwm2ytgvsEzyqkTJ8rI4\n/5g6Yn3WgLVcm+pV/Zh8gkWyQ2QQF6KmwYGmyKwCw4J6MwLSOqy0kb3gh6kriQ4v\nH9PwNzwiJQIDAQABo4ICpzCCAqMwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQC\nMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBTzJadb\nN51V7xWh/YfomWDe/VdLMDB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pj\nRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRp\nb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEA\nMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9u\nY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRz\nLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGF\nMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBV\nMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNh\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAgBgNVHREEGTAX\nghVhaXN3aWtpdGVzdC53dXN0bC5lZHUwDQYJKoZIhvcNAQEFBQADggEBAIHbMry6\nIwV6hVwqDsIumuyB5rgPJvdiruSSS3wNgR7LIdMGe1I7MX4e3waaLqeIJ/ZQcOmS\nU9ElzTYDTMGpLm/1Ytc1ZQVfE5RgW92DEw+sP/Wt92BLXcM/SeyTZ8AkqwpYCvLo\nRLqEBaHM8HaSUOeXHukp5A4vX+N78V49p/2Dq/p+o+/6TObdh6eQEVkPRBwx97zk\nRyCLb7yujxHlBYE1L7jsIaHFKQ2KpaTKP/LYm3U8n9WdTg4cVtJcjppfaNCCRVcL\n0TiuWQ7WJF/E/LR4Cy89ZEACamaF1Z+yfKrqkd2ythdu8hZrTuRrbigYqgmy89vb\nReFuM40SXkDmm5w=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswikitest.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswikitest.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswikitest.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://aiswikitest.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://idm.it.utsa.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKDCCAhCgAwIBAgIVAIm8iebcALQTq84UE4AvzlgKieaAMA0GCSqGSIb3DQEB\nBQUAMBoxGDAWBgNVBAMTD2lkbS5pdC51dHNhLmVkdTAeFw0wOTAxMjMxOTM3Mjha\nFw0yOTAxMjMxOTM3MjhaMBoxGDAWBgNVBAMTD2lkbS5pdC51dHNhLmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANOsKHxRDUp3WNFrCwi+c4NjNzVP\nDW+jX4dC6mz9AGxvVmKUVSozFl2pQpQAvG3Qc95Ou68ylnm6MNxAwOlaBfjLy3Xb\nN//T7AVJl2iEsQv5EzZ85iyDOb+ih6U2+WK2WxQVYLVNGKdvqZSLkZ4VJw8j1PVf\nq7wPKWV6y2++Jkhz+3/KG24UpdJ+ja0ipBB8ZhONba+CD7Tw9xD5FBUEhTUGQs/H\nyDArojsyGNVBlriSIFxK3VLab1KzOrwAD55B8yATDg5/X9Gvxvy8RhUjwhOnj+wx\nIvA8cuzYHKmFrYMhw5MedFVvCxqMmbkadWaOWVn15kzuI4laecjM+QxiLn0CAwEA\nAaNlMGMwQgYDVR0RBDswOYIPaWRtLml0LnV0c2EuZWR1hiZodHRwczovL2lkbS5p\ndC51dHNhLmVkdS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUcD2eJNEbgvmbSn57\nAU9miq3KM/gwDQYJKoZIhvcNAQEFBQADggEBAL+y6u4qvPx7+nQN71UP+nXqInkO\nLmELPK+uxZo/+03KSutQkq/ymU+GK2pdaLR8jvDAiBzC/RoheWk8kF4MoIUjIxFC\nDkALegQvA+HioqBhSBnU2AeSrUfV3lDhQ7mIRrhBONFHf3qvKRTyUO7waZJtLWvo\nT6C6aoDNtUaStiR4SLZ3TeFK6ha9uxsgG09YW/Zze1Qt9bTclLICbhqgeeLqMLgj\nME5BRC6w5hN37trvZnAijYuFllMZtFl41igv9dyKU5zuguK1NLSSa+RiHTORIDYb\nmWNvmsYec7Jd9q6GnUX3lVUrGz5X5/7UL2GPTh7Ups8kZW2Rt20pIT4PIJA=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idm.it.utsa.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "OIT Unix Group", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "unix@utsa.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://idm.it.utsa.edu/idp/shibboleth", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idm.it.utsa.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idm.it.utsa.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idm.it.utsa.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idm.it.utsa.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKDCCAhCgAwIBAgIVAIm8iebcALQTq84UE4AvzlgKieaAMA0GCSqGSIb3DQEB\nBQUAMBoxGDAWBgNVBAMTD2lkbS5pdC51dHNhLmVkdTAeFw0wOTAxMjMxOTM3Mjha\nFw0yOTAxMjMxOTM3MjhaMBoxGDAWBgNVBAMTD2lkbS5pdC51dHNhLmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANOsKHxRDUp3WNFrCwi+c4NjNzVP\nDW+jX4dC6mz9AGxvVmKUVSozFl2pQpQAvG3Qc95Ou68ylnm6MNxAwOlaBfjLy3Xb\nN//T7AVJl2iEsQv5EzZ85iyDOb+ih6U2+WK2WxQVYLVNGKdvqZSLkZ4VJw8j1PVf\nq7wPKWV6y2++Jkhz+3/KG24UpdJ+ja0ipBB8ZhONba+CD7Tw9xD5FBUEhTUGQs/H\nyDArojsyGNVBlriSIFxK3VLab1KzOrwAD55B8yATDg5/X9Gvxvy8RhUjwhOnj+wx\nIvA8cuzYHKmFrYMhw5MedFVvCxqMmbkadWaOWVn15kzuI4laecjM+QxiLn0CAwEA\nAaNlMGMwQgYDVR0RBDswOYIPaWRtLml0LnV0c2EuZWR1hiZodHRwczovL2lkbS5p\ndC51dHNhLmVkdS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUcD2eJNEbgvmbSn57\nAU9miq3KM/gwDQYJKoZIhvcNAQEFBQADggEBAL+y6u4qvPx7+nQN71UP+nXqInkO\nLmELPK+uxZo/+03KSutQkq/ymU+GK2pdaLR8jvDAiBzC/RoheWk8kF4MoIUjIxFC\nDkALegQvA+HioqBhSBnU2AeSrUfV3lDhQ7mIRrhBONFHf3qvKRTyUO7waZJtLWvo\nT6C6aoDNtUaStiR4SLZ3TeFK6ha9uxsgG09YW/Zze1Qt9bTclLICbhqgeeLqMLgj\nME5BRC6w5hN37trvZnAijYuFllMZtFl41igv9dyKU5zuguK1NLSSa+RiHTORIDYb\nmWNvmsYec7Jd9q6GnUX3lVUrGz5X5/7UL2GPTh7Ups8kZW2Rt20pIT4PIJA=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idm.it.utsa.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idm.it.utsa.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Texas at San Antonio", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Texas at San Antonio", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.utsa.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:stonybrook.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stony Brook University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stony Brook University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sunysb.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Sanjay Kapur", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Sanjay.Kapur@stonybrook.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Brian Heller", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Brian.Heller@stonybrook.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibidp.colostate.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDhjCCAm6gAwIBAgIESuds8jANBgkqhkiG9w0BAQUFADCBhDELMAkGA1UEBhMCVVMxCzAJBgNV\nBAgTAkNPMRUwEwYDVQQHEwxGb3J0IENvbGxpbnMxIjAgBgNVBAoTGUNvbG9yYWRvIFN0YXRlIFVu\naXZlcnNpdHkxDTALBgNVBAsTBEFDTlMxHjAcBgNVBAMTFXNoaWJpZHAuY29sb3N0YXRlLmVkdTAe\nFw0wOTEwMjcyMTU4MTBaFw0xMjEwMjYyMTU4MTBaMIGEMQswCQYDVQQGEwJVUzELMAkGA1UECBMC\nQ08xFTATBgNVBAcTDEZvcnQgQ29sbGluczEiMCAGA1UEChMZQ29sb3JhZG8gU3RhdGUgVW5pdmVy\nc2l0eTENMAsGA1UECxMEQUNOUzEeMBwGA1UEAxMVc2hpYmlkcC5jb2xvc3RhdGUuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoTE1kTlXGS2mt7QD8D1uatKcox0pC5+aZGek19tV\n0Hd2PUTzieIHAkNtlq+4fnH1MnrAkOMTblYkrvj4hbUaOnCnTwjsZueEVXNyy4isWUPJ7NEYRURN\n75aNNztGvJPR4OcOE76aJ+gKIbkzhMDfgIizSjTm0hEAq73oRFutfnhS31Udwrc8UEqP330yy5Qa\nfUYl7voaWn23r+yVpGApDwgCcI1Q45QxPR4RbYJw5YOmCE3KHM3kuodCnS9U38ZRktCY6CPbtjC8\nQyuAq8Ngh85qgnWyxn3UhE9dQx2Vsnl3IuV97IpddjNCfGVl9+Qoc3L8+vhPSq96ZAuu6oO3aQID\nAQABMA0GCSqGSIb3DQEBBQUAA4IBAQBBY1VxQVyXgEA7H5a8DlOPh+9RP4yiW4HW+r0mX9sm/Xvm\nJ7CWsVKq+/LJ9vZGq2qAXb7lOCVFoWk+eQZ0HXfklP7+IpZlK656wyvLTh9+OIm/6UYb/ES9tGO/\nQIqQkTtz81zemEt1y/S8nVmLG6Wz9mbA8LBQUZRXFwrQ22ZFe+/25FzACPcm4twkKGUc8OffCNQF\no0mIgeZTa+yf7Y4CVNGhMPf9BrtupAHNUIKNQymBAmMk4qRrgptPx7NwgdRwgjS6T7TERkbZUOhC\njEdNmTbclqUYTiexXEyZMHf8nGYPuanLiPEMAvqqqQGriyzmAAze3UPlrUHOcvQzz1kJ", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibidp.colostate.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Randy Miotke", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@colostate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Kevin Swab", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@colostate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Scott Baily", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@colostate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibidp.colostate.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibidp.colostate.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDhjCCAm6gAwIBAgIESuds8jANBgkqhkiG9w0BAQUFADCBhDELMAkGA1UEBhMCVVMxCzAJBgNV\nBAgTAkNPMRUwEwYDVQQHEwxGb3J0IENvbGxpbnMxIjAgBgNVBAoTGUNvbG9yYWRvIFN0YXRlIFVu\naXZlcnNpdHkxDTALBgNVBAsTBEFDTlMxHjAcBgNVBAMTFXNoaWJpZHAuY29sb3N0YXRlLmVkdTAe\nFw0wOTEwMjcyMTU4MTBaFw0xMjEwMjYyMTU4MTBaMIGEMQswCQYDVQQGEwJVUzELMAkGA1UECBMC\nQ08xFTATBgNVBAcTDEZvcnQgQ29sbGluczEiMCAGA1UEChMZQ29sb3JhZG8gU3RhdGUgVW5pdmVy\nc2l0eTENMAsGA1UECxMEQUNOUzEeMBwGA1UEAxMVc2hpYmlkcC5jb2xvc3RhdGUuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoTE1kTlXGS2mt7QD8D1uatKcox0pC5+aZGek19tV\n0Hd2PUTzieIHAkNtlq+4fnH1MnrAkOMTblYkrvj4hbUaOnCnTwjsZueEVXNyy4isWUPJ7NEYRURN\n75aNNztGvJPR4OcOE76aJ+gKIbkzhMDfgIizSjTm0hEAq73oRFutfnhS31Udwrc8UEqP330yy5Qa\nfUYl7voaWn23r+yVpGApDwgCcI1Q45QxPR4RbYJw5YOmCE3KHM3kuodCnS9U38ZRktCY6CPbtjC8\nQyuAq8Ngh85qgnWyxn3UhE9dQx2Vsnl3IuV97IpddjNCfGVl9+Qoc3L8+vhPSq96ZAuu6oO3aQID\nAQABMA0GCSqGSIb3DQEBBQUAA4IBAQBBY1VxQVyXgEA7H5a8DlOPh+9RP4yiW4HW+r0mX9sm/Xvm\nJ7CWsVKq+/LJ9vZGq2qAXb7lOCVFoWk+eQZ0HXfklP7+IpZlK656wyvLTh9+OIm/6UYb/ES9tGO/\nQIqQkTtz81zemEt1y/S8nVmLG6Wz9mbA8LBQUZRXFwrQ22ZFe+/25FzACPcm4twkKGUc8OffCNQF\no0mIgeZTa+yf7Y4CVNGhMPf9BrtupAHNUIKNQymBAmMk4qRrgptPx7NwgdRwgjS6T7TERkbZUOhC\njEdNmTbclqUYTiexXEyZMHf8nGYPuanLiPEMAvqqqQGriyzmAAze3UPlrUHOcvQzz1kJ", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Colorado State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Colorado State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.colostate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://isds-flu.cirg.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Svend Sorensen", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "svends@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDWzCCAkOgAwIBAgIJAKqBfk9g5U5jMA0GCSqGSIb3DQEBBQUAMCcxJTAjBgNV\nBAMTHGlzZHMtZmx1LmNpcmcud2FzaGluZ3Rvbi5lZHUwHhcNMDkxMjE2MTg1ODU5\nWhcNMTIxMjE1MTg1ODU5WjAnMSUwIwYDVQQDExxpc2RzLWZsdS5jaXJnLndhc2hp\nbmd0b24uZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxDdDjt4X\nS+E4QwZTidk1bE7Dh7ddajCtS3WEiTCOdn1zTfKiho+0+BIWwJ7Duaa5/tjdVEcP\nTMNxC8oyEi6892DZM6wPzFSW5XeVSXHM1H0dgpS6zaO7iUU//XcjoPpltV3IWDqq\nRXN7B6cysu3JHi+XROCLB+O4v/rxyzpsFCz5qyEBcHHIviraMDeSepPwM1OU8M9R\nopNg2V/S+Hd+V6AO26wfdw6FqBTERcWPkfNOmR9gXlfjrqbBY+I2luWjtbTmTSSI\n7cDH2FcOJe3YQ1M6At4jqhAbfr95eNXIqcpLPsP3ezwk6t5brx29T3mfLU5uPCiU\nF1VNVxAHpZdedQIDAQABo4GJMIGGMB0GA1UdDgQWBBRrlfMTI77V+4QHrpaVvMU/\nEdgYxjBXBgNVHSMEUDBOgBRrlfMTI77V+4QHrpaVvMU/EdgYxqErpCkwJzElMCMG\nA1UEAxMcaXNkcy1mbHUuY2lyZy53YXNoaW5ndG9uLmVkdYIJAKqBfk9g5U5jMAwG\nA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAG+XKcPMOpgWrOREb6+55Glv\ndFKZJrXuIYyAk/8Uq0Ibmju4P7Ber0aXP88awuyLOEVlmbTuVjal5a6SxMEarN5E\nNECQ5rGD8VitHv3D5PwWxmv57+/HEMqUbyQlESikXsycL78YSHNBvYCXmg5AQYiX\nGyKmBs5zHSDBrYkQkK8p9N5yQwrpnPVsb8zx4fiBrT58MgRCpGl9qB3yhBt37bwt\nbNBvec2etizCaYvaGc6u9Q/Q/FHOHYBQFxG9AKOQ0gxoxXbnNev5lWG3IKCiLned\nDeJolKWtjsnPgRv3xAd9b/6Bpjra8nP1WrVbGrHHszDJoHbL2AtxjYFta2KCTko=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://isds-flu.cirg.washington.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://isds-flu.cirg.washington.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://shibdemo.itc.virginia.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.virginia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Hamp Carruth", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ehc@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shib.uthscsa.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKzCCAhOgAwIBAgIUOBCFT1ioD0RKc/AB856Jnvb79kEwDQYJKoZIhvcNAQEF\nBQAwGzEZMBcGA1UEAxMQc2hpYi51dGhzY3NhLmVkdTAeFw0wOTEwMTkxNTUwMDha\nFw0yOTEwMTkxNTUwMDhaMBsxGTAXBgNVBAMTEHNoaWIudXRoc2NzYS5lZHUwggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCWW8cEBcuG3QBhlSVu7WSbvxAw\n8QLM51Dpg/QsJvUes6hjZGetH/WV9u6LjlCGc6sVr5uXpd0IFkpvVFikLszqlOrH\np62jO8uomSAlI5nDjG51HAd2lGYx+aTO+ioc5BU9RnMo/VA6VcBsySGlTbWEbf59\nu87fvyTktNRjPOr5mMztZsrb5twYy3e4XfdFTiWJYIccZvjfsZZOwa7vu+JnfUl2\nM2q2jsO/dgCMk2nIAcYOYKEd5F0exwY4qjFHUCPm8s315I9+RZBPFGVB+Y77Rg2e\nVS4Q+9CoTTFLY2LZ4isR3a0RbBr+2TFqMv0ES0aUt3YC8sqWOvxiIhclvCHXAgMB\nAAGjZzBlMEQGA1UdEQQ9MDuCEHNoaWIudXRoc2NzYS5lZHWGJ2h0dHBzOi8vc2hp\nYi51dGhzY3NhLmVkdS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUqadoMe9LA6OA\nNuWMvOkr+fZCuwowDQYJKoZIhvcNAQEFBQADggEBAGWZjR5NFsdiB+IY1eb89+zQ\ntxFy3a8Jct9Dv+nRePNOc5YCF0FLx+BRYfc4L0+yGxhAjyq3XlRe7e4YVpQ/Qy0e\ndqFClRLNXYAVXku2/8zkGNVh+wMDpxOiILoKN1wi+wQ8WnnS7iQPiT2h9ypnrvbf\nRDu+MTSSlVM/XbDOUxtoLWV0YnhhFksN6cseeqW5sUK+4pbj9as+PgTLSt+pxLzY\nWNfu12cY6+Qjam6zo6qiYXfqrvqoVvWf971mJWgf7APZqdp5GrLpMqQoa3XSgfQ6\nsZemi2r9GnG7yy/S/oAW5ZJjeHjRkp+4IBAjCVy8XmRkqx9Lbvq/eincPQjhDjQ=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shib.uthscsa.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian Purcell", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "purcell@uthscsa.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "http://ims.uthscsa.edu/TechSuppt/HelpDesk.aspx", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.uthscsa.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.uthscsa.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.uthscsa.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.uthscsa.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKzCCAhOgAwIBAgIUOBCFT1ioD0RKc/AB856Jnvb79kEwDQYJKoZIhvcNAQEF\nBQAwGzEZMBcGA1UEAxMQc2hpYi51dGhzY3NhLmVkdTAeFw0wOTEwMTkxNTUwMDha\nFw0yOTEwMTkxNTUwMDhaMBsxGTAXBgNVBAMTEHNoaWIudXRoc2NzYS5lZHUwggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCWW8cEBcuG3QBhlSVu7WSbvxAw\n8QLM51Dpg/QsJvUes6hjZGetH/WV9u6LjlCGc6sVr5uXpd0IFkpvVFikLszqlOrH\np62jO8uomSAlI5nDjG51HAd2lGYx+aTO+ioc5BU9RnMo/VA6VcBsySGlTbWEbf59\nu87fvyTktNRjPOr5mMztZsrb5twYy3e4XfdFTiWJYIccZvjfsZZOwa7vu+JnfUl2\nM2q2jsO/dgCMk2nIAcYOYKEd5F0exwY4qjFHUCPm8s315I9+RZBPFGVB+Y77Rg2e\nVS4Q+9CoTTFLY2LZ4isR3a0RbBr+2TFqMv0ES0aUt3YC8sqWOvxiIhclvCHXAgMB\nAAGjZzBlMEQGA1UdEQQ9MDuCEHNoaWIudXRoc2NzYS5lZHWGJ2h0dHBzOi8vc2hp\nYi51dGhzY3NhLmVkdS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUqadoMe9LA6OA\nNuWMvOkr+fZCuwowDQYJKoZIhvcNAQEFBQADggEBAGWZjR5NFsdiB+IY1eb89+zQ\ntxFy3a8Jct9Dv+nRePNOc5YCF0FLx+BRYfc4L0+yGxhAjyq3XlRe7e4YVpQ/Qy0e\ndqFClRLNXYAVXku2/8zkGNVh+wMDpxOiILoKN1wi+wQ8WnnS7iQPiT2h9ypnrvbf\nRDu+MTSSlVM/XbDOUxtoLWV0YnhhFksN6cseeqW5sUK+4pbj9as+PgTLSt+pxLzY\nWNfu12cY6+Qjam6zo6qiYXfqrvqoVvWf971mJWgf7APZqdp5GrLpMqQoa3XSgfQ6\nsZemi2r9GnG7yy/S/oAW5ZJjeHjRkp+4IBAjCVy8XmRkqx9Lbvq/eincPQjhDjQ=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shib.uthscsa.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shib.uthscsa.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Texas Health Science Center At San Antonio", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Texas Health Science Center At San Antonio", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uthscsa.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://comanage.internet2.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Michael R. Gettes", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gettes@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:psu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Pennsylvania State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Penn State", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.psu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Technical Staff", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "root@aset.psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Steven Kellogg", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kellogg@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Mark Miller", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "max@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Penn State ITS Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "helpdesk@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://istest.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFDTCCA/WgAwIBAgICAlMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxNTE3NTUyNloXDTExMDcx\nNjE3NTUyNlowGzEZMBcGA1UEAxMQaXN0ZXN0Lnd1c3RsLmVkdTCBnzANBgkqhkiG\n9w0BAQEFAAOBjQAwgYkCgYEAxN9v4IZVnQ7NlIXXJ8oSC0/VBkW5c4pgoa4lqcZk\nsdLNeN1l2HNXRFpQKwvm6zWM/Oana7kCohWkyTyqZeriYBTPPwr94xWg323cYqlH\nqvAGzu2QuzSs9cmKuiadGQJgEfgJXm0xA7rT+uKvEopBzjgH+uwj3hVgzlci5HHz\nEZkCAwEAAaOCAqIwggKeMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0G\nA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUvJhisOuRHYRI\ng7NfExUUYOJW24wwfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRY\nMFYxCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkw\nJwYDVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYI\nKwYBBQUHAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5p\nbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2Iw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/\noD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsr\nBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwGwYDVR0RBBQwEoIQaXN0\nZXN0Lnd1c3RsLmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAShplUJb6XP4+bmlqlYGv\nsqWBl0uyosGfBmSWae6ll9AQkGtsc7jEc4ZSs+Mbd6LAQlKedzzTX2G6Q/pKhxpX\npT/tpHMmPI/2YbfntTR5YfJohl4IzjN6aA326aO2W1FCmEmWU05TTwt9JpGq9HPw\n+V6aaxuZAXd0HEoxTqMD/YaA6QwTZQjGNWBn9JTJOsIAng4OFyDJ9sd59P377Vh4\nKNDGxGR1eM9HZPCj1twgR2wkJu3YiEXJMl8V/ZvgbA3AOseZJaGE09s/Jig6HPJI\n5qm6c0do51HOvAeShHCjxQxw+8pEMrTjp9wHQOT/Vxwteyflj+GzVA+IxUYPcP6Z\nHQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://istest.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://istest.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://istest.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://istest.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://ucready-win-dev.berkeley.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.berkeley.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Karin Bliman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kbliman@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://www.digitalmeasures.com/shibboleth-sp/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Digital Measures", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Digital Measures", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.digitalmeasures.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Digital Measures", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "info@digitalmeasures.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIEwTCCA6mgAwIBAgIJAI9+wkih8GQMMA0GCSqGSIb3DQEBBQUAMIGbMQswCQYD\nVQQGEwJVUzESMBAGA1UECBMJV2lzY29uc2luMRIwEAYDVQQHEwlNaWx3YXVrZWUx\nGTAXBgNVBAoTEERpZ2l0YWwgTWVhc3VyZXMxIDAeBgNVBAMTF3d3dy5kaWdpdGFs\nbWVhc3VyZXMuY29tMScwJQYJKoZIhvcNAQkBFhh0ZWNoQGRpZ2l0YWxtZWFzdXJl\ncy5jb20wHhcNMDkxMjAyMTg1NTAzWhcNMTkxMTMwMTg1NTAzWjCBmzELMAkGA1UE\nBhMCVVMxEjAQBgNVBAgTCVdpc2NvbnNpbjESMBAGA1UEBxMJTWlsd2F1a2VlMRkw\nFwYDVQQKExBEaWdpdGFsIE1lYXN1cmVzMSAwHgYDVQQDExd3d3cuZGlnaXRhbG1l\nYXN1cmVzLmNvbTEnMCUGCSqGSIb3DQEJARYYdGVjaEBkaWdpdGFsbWVhc3VyZXMu\nY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApdU5Pa3MRsljSruF\n+oUUNr7KAUeRh8kJRdvHQIUQKDrLUrgGDJxVFEd4kAO0jd+cljJ+Ks8blQtZpqz3\n8HBpwDV1p5Vh+pne0p6lUCiUY9ZhqC7b6nZhuZMJGsROfYcnzS4fYrLV8MmTJ4hU\nCDfyIXCLIlNAwuOwRLWJ6Kg3C9vOdP72z0BWxGzFUsNMSixWVSl5hcehkPskezLd\nsHZFC1bfTWrmIuVdvKRp1XWnqC0Ha6HyAXfkKosWg9f71KCMwpTKqXwtj47cXMgA\nwmShTH8OwQ1C2rXxVPWzNjfE5xFI/7Fo26mftzQGwkJ2laaRbioygZhGgpfEP1Mk\nZ0a0swIDAQABo4IBBDCCAQAwHQYDVR0OBBYEFHyhAmBoAKyaxI2a6+6vknnzbtI0\nMIHQBgNVHSMEgcgwgcWAFHyhAmBoAKyaxI2a6+6vknnzbtI0oYGhpIGeMIGbMQsw\nCQYDVQQGEwJVUzESMBAGA1UECBMJV2lzY29uc2luMRIwEAYDVQQHEwlNaWx3YXVr\nZWUxGTAXBgNVBAoTEERpZ2l0YWwgTWVhc3VyZXMxIDAeBgNVBAMTF3d3dy5kaWdp\ndGFsbWVhc3VyZXMuY29tMScwJQYJKoZIhvcNAQkBFhh0ZWNoQGRpZ2l0YWxtZWFz\ndXJlcy5jb22CCQCPfsJIofBkDDAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUA\nA4IBAQAeUkRH04tZvqAcBCxmQyRdIDEvBw8+IG6zzL8Ap4dJLSBc4D9uUZtIq8Xu\nZDnrOcQ9O2Udsno523aONEOsiCTazJRhNJKTGkXXeQiJhGnzXmOokkIeGJI9efNJ\n4GAVI9ZrxEh+ZgKQpLuZpCO+d/RwKqtbOJWL8u4QccYH2stK1dO4M6yUe7b9PnwP\nF2HUBMtW7B3xfRZyy1qQTpJ3oVp2nPTDtStIioPuqB1y+sl76jR503ABPnz77wyV\nvh8D4o/W5q32axmmKH3s85TeSyUoQ4RS7/NgsjYQI7lnODeVSgWcUl1+c+NfPNiu\n1vpIbPTlEVEvmNPl69Zi3A9T7I/p", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.digitalmeasures.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.digitalmeasures.com/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://hdxdev.core.umbc.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.umbc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Paul Riddle", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "paulr@umbc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.nclive.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "NC Live", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "NC Live", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.nclive.org/authhome.phtml", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Scott Ross", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "scott@nclive.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFjTCCBHWgAwIBAgICAoswDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkxODE3NTU0OVoXDTExMDkx\nOTE3NTU0OVowGTEXMBUGA1UEAxMOd2ViLm5jbGl2ZS5vcmcwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDDT7Vn9xW54KvWI/2DawQ0EyNOU4VLEVL4traX\nTqZCklGE6vovxgzOI3Nd2VJDAfsDe7PrcYCOGWCLXdSJgh5exBU8yAKnUk4Vje2s\nRmEv+sQpG0OVLlQjTF0Pb8BK1JtCngLWVRCqVXOGyrAelfeT5sGjDMzhcyITlkf7\njsfJ21mS23Hm2zQWJh1SIkFq8YHXeZPXdT8ZABlezmhZnmnr2zUvIgIHC+a6acRA\nyGw0GQjSqSl7ON+nX6FoStiVposcS0G4PELxtYqgL2ee30aNjqm8deJZjuWPGhsg\nvI+1Ito89U83lDaI70ot2KjsOeLYbY9Gj2Bd+iaC9Fa1ZAqtAgMBAAGjggKgMIIC\nnDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggrBgEF\nBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFJYNVktaROPvdmEHRSwpIyHcggKfMH4G\nA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJV\nUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21t\nb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGi\nME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAChkNo\ndHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2Uv\nY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9p\nbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNy\nbDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBC\nBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9wcmFjdGljZXMucGRmMBkGA1UdEQQSMBCCDndlYi5uY2xpdmUub3JnMA0G\nCSqGSIb3DQEBBQUAA4IBAQA6ExvKKfOBwopou6iDhkbSPvnBhokjNVKwGU5YFzBd\nc+HC1xnz3NdbLnwx2O/31N+Kr+5FSCwcPzoAf5wWGss7tu8YAiWqkWcA1lLYPZYH\ntd5YfkhZhKTjf1fbwW49+HTRU2JLj5SjlDj3gJNyUoQ4Y3aivVon+jeF+/U4v0gr\nEb/GKHGqPeZBrXcjqLZJBo9Mpd1vythSYKLkhfZofRHAJe7nFm3MbYjc3zKWr+jf\nplJBqOm0KjL6adGVeGhyvEafBxoMVbzuaEPtdyGHcJpG/xvJpfPu+/Gb2EePMTeF\nqyqIn3P8O/Mii0SvHj5PoiEd7Q4ktYBJn7kJ18ZgglmH", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.nclive.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.nclive.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-2.baylor.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDSDCCAjCgAwIBAgIVAJwrpZTSCIpBHJObNPrSziMptCxsMA0GCSqGSIb3DQEB\nBQUAMCIxIDAeBgNVBAMTF3NoaWJib2xldGgtMi5iYXlsb3IuZWR1MB4XDTA4MTAx\nMDE1NTE1MloXDTI4MTAxMDE1NTE1MlowIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC0y\nLmJheWxvci5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxLhS3\nFaukoY9w6xx2ScH9t+VBKN3SgpoNCtlSTA+c+EzlFN1U8JT/TM7frLCW5hw9iCZE\nskLYrWlp6h//hukAf6O+WVNrDD3KnCF3Tnf29Rvf0xM0Xe8Vu7l/O87B6UA5a8+L\nCw1+7OGBX5Ji6PB/sBDbCCs76G/EA4PqbHFomS03z7Qo8vJaAF5eEoq14FPt154G\n+1mL4MUzrDIB4obFZqFRkJgh8dl13cDFsew5hMQbRVMHnOKIBPspaHJauYHK15SB\n5WRCUdkkn/+cfriS2w+LXPttPryaZNelNmwAEcDdY8WBE6fKRU1O2aYSXt6fPdlB\n5ood0aDV4RjWJ5uTAgMBAAGjdTBzMFIGA1UdEQRLMEmCF3NoaWJib2xldGgtMi5i\nYXlsb3IuZWR1hi5odHRwczovL3NoaWJib2xldGgtMi5iYXlsb3IuZWR1L2lkcC9z\naGliYm9sZXRoMB0GA1UdDgQWBBTCaiA6Ojg47/4ar0uw2B3+ATl8DDANBgkqhkiG\n9w0BAQUFAAOCAQEAmQ+aPuw0MMuCKdkpBJslXyNI+lKUqdnY/aaMsOwN2M1TGiOL\npi5thbpX5CTte366j/F+vePY2cQjte2z8h5bZTPr9/v9HaEQqon3uX6cANlXd0CB\nqojrtBlaiI5Ij7xYoO0uqbh2jXs6gJ58DVOHma20spm+qELlaD+lqaTIA1Ge5rma\nJtRoJmSugC0tc/E1FuSWyRkdzxra1ZZjakUbEZBYO0x5STmrFWZ0E6ewMLu6u/X2\nwp8io5JHRYH74kW3WeXaR0/hi2wiaVBsOACQ75dFrlJZTb4oMWGothemjzQV3K3Q\nxXawYVydT5jy18eqkAFFtBDOlRVFXEqY/oOetw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth-2.baylor.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Tommy Roberson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tommy_roberson@baylor.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Becky King", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "becky_king@baylor.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Ray Nazzario", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ray_nazzario@baylor.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth-2.baylor.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth-2.baylor.edu/idp/profile/SAML2/POST/SSO"
          }
        ], 
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDSDCCAjCgAwIBAgIVAJwrpZTSCIpBHJObNPrSziMptCxsMA0GCSqGSIb3DQEB\nBQUAMCIxIDAeBgNVBAMTF3NoaWJib2xldGgtMi5iYXlsb3IuZWR1MB4XDTA4MTAx\nMDE1NTE1MloXDTI4MTAxMDE1NTE1MlowIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC0y\nLmJheWxvci5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxLhS3\nFaukoY9w6xx2ScH9t+VBKN3SgpoNCtlSTA+c+EzlFN1U8JT/TM7frLCW5hw9iCZE\nskLYrWlp6h//hukAf6O+WVNrDD3KnCF3Tnf29Rvf0xM0Xe8Vu7l/O87B6UA5a8+L\nCw1+7OGBX5Ji6PB/sBDbCCs76G/EA4PqbHFomS03z7Qo8vJaAF5eEoq14FPt154G\n+1mL4MUzrDIB4obFZqFRkJgh8dl13cDFsew5hMQbRVMHnOKIBPspaHJauYHK15SB\n5WRCUdkkn/+cfriS2w+LXPttPryaZNelNmwAEcDdY8WBE6fKRU1O2aYSXt6fPdlB\n5ood0aDV4RjWJ5uTAgMBAAGjdTBzMFIGA1UdEQRLMEmCF3NoaWJib2xldGgtMi5i\nYXlsb3IuZWR1hi5odHRwczovL3NoaWJib2xldGgtMi5iYXlsb3IuZWR1L2lkcC9z\naGliYm9sZXRoMB0GA1UdDgQWBBTCaiA6Ojg47/4ar0uw2B3+ATl8DDANBgkqhkiG\n9w0BAQUFAAOCAQEAmQ+aPuw0MMuCKdkpBJslXyNI+lKUqdnY/aaMsOwN2M1TGiOL\npi5thbpX5CTte366j/F+vePY2cQjte2z8h5bZTPr9/v9HaEQqon3uX6cANlXd0CB\nqojrtBlaiI5Ij7xYoO0uqbh2jXs6gJ58DVOHma20spm+qELlaD+lqaTIA1Ge5rma\nJtRoJmSugC0tc/E1FuSWyRkdzxra1ZZjakUbEZBYO0x5STmrFWZ0E6ewMLu6u/X2\nwp8io5JHRYH74kW3WeXaR0/hi2wiaVBsOACQ75dFrlJZTb4oMWGothemjzQV3K3Q\nxXawYVydT5jy18eqkAFFtBDOlRVFXEqY/oOetw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Baylor University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Baylor University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.baylor.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://miller-lab.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Matthew Radey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "marad@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://www.internet2.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "IJ Kim", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ij@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFFzCCA/+gAwIBAgICARMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDMwNDIxMzcwMVoXDTEwMDMw\nNTIxMzcwMVowHDEaMBgGA1UEAxMRd3d3LmludGVybmV0Mi5lZHUwgZ8wDQYJKoZI\nhvcNAQEBBQADgY0AMIGJAoGBAL6YNg+bKtrsFXscmSNBEpGC4o87K95axWgMuPS1\nGT04vYATp9gFJN/k6sNedi0tYkdTs6ct3fIiqtT3fwxBMVFL74O4Ms41VQuCEM+v\nwzGzoX59PepmwBEpL8MVBCRjoPo7I+/fjH6i4qDLI/2RCARQsyL4An6rIHWdKYzz\n+S85AgMBAAGjggKrMIICpzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAd\nBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFAOdomwuiJLm\n0ZA4pivgxh0HCb8EMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqk\nWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEp\nMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgboG\nCCsGAQUFBwEBBIGtMIGqMIGnBggrBgEFBQcwAoaBmmh0dHA6Ly9pbmNvbW1vbmNh\nMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5w\nN2IKCQlDQSBJc3N1ZXJzIC0gVVJJOmh0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1Ud\nHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25j\ncmwyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0g\nBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21t\nb25jYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHAYDVR0R\nBBUwE4IRd3d3LmludGVybmV0Mi5lZHUwDQYJKoZIhvcNAQEFBQADggEBAKQRgpnT\nVQpW1cW5XzQXMQAwhWgiPOarRSOjVUAf4h6/ZoUzCQMNS1k0EX9TWmSdSu89S/bw\nu2e3A5abgABulX+rsSgx7GARSCn1w1m2bwAm2cAvjcCrY4tl6VwNy5kVBXh/dzRK\nNvHSWV6uw4yNSsfo90WJhgySE12mH0j8inSsDD9x1Gs03NKsRR4ynhXhhWFVf7Jo\nDvZNhRUx8AqjeARw/u1czzfrJ5jO+2oxC9PRw+ZjThS3ZWTS3p8WKmw4PfoRqBbb\nHbmI8YJAgVCaKyUllnkjVfz2+vJWFnFJ8+HeeILd/0NAql05VqnWBYX/vdfrpTxA\nwdskRbmftyLM/lM=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.internet2.edu/Shibboleth.shire"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.internet2.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.internet2.edu/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://idp.utsystem.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDLDCCAhSgAwIBAgIVANsuFgw2Z5XryWlzufSAgriNo5pDMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEGlkcC51dHN5c3RlbS5lZHUwHhcNMDkwNjIwMjEyNzIy\nWhcNMjkwNjIwMjEyNzIyWjAbMRkwFwYDVQQDExBpZHAudXRzeXN0ZW0uZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiUJ9hGEJw0EIBIL2InLhCsZZ\n7maurudIUPt9NVQxPFHI7DwhTXwEjhYbTCnNYHS1JjEdnqzYLZitKfLYMkxPapVu\nfEDVBoLCnabRjKuOjLgIraYX5/rdvzgJPGAn7chL76ut5S3EuQNQ7LDD0KWR71qH\ny3TjZD3RXImFCRXvjLOlZR9+jVA1bKLzcafWUyHTv9wW8s/EyN+33ghOwRNzuH9W\n4ZUvUU2/22MYDlHwbCmwfvF8cYoHfk9WK+fgN+5BGGk+YJvjTAdek6tqeLPsFcR5\ncxvDwjyq00sZPb/xDRCTEgtx3StEYSEXqU1Z62/uHmlZ/oeFW21j59ls/CRp3wID\nAQABo2cwZTBEBgNVHREEPTA7ghBpZHAudXRzeXN0ZW0uZWR1hidodHRwczovL2lk\ncC51dHN5c3RlbS5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFErG8hS4tDz7\n5KwTs0pGvgb1DeR7MA0GCSqGSIb3DQEBBQUAA4IBAQAO4uo9SuOK3/uLJozn+W0L\nMymzQ6OLLZHuOX2lr/+2+I4YXzp8uqdwp8M7+GVlKDU+7JVEfFl+d7mtPrtThdYz\naSjip2XjOQdaE/+vY/oD/G750YAZsxOsWQQKPZIC4LClHjLz2H36Wc8nuTKxZzV+\nFLOa1rOT3iYnL2rY+Mzqet3mwz/yoPq8M1/0J/HtvEWyhRkt7SBPnoNZbMt0y33H\nDbzkGdzI4NTA/flqEuAXBrjkg64qktKR7YTkFRWvy1pl44MqiVmP5nvZgVZZmRYg\nBaqXA+v1pIIo2tL8IuUiQxH1KsnDCXE/F74PcEu2CDCVKEgaVEB1v6tGFZwYr2V7", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.utsystem.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Network Admin", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "netadmin@utsystem.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Paul Caskey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pcaskey@utsystem.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "help@utsystem.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://idm.utsystem.edu/error.html", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.utsystem.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.utsystem.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.utsystem.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.utsystem.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDLDCCAhSgAwIBAgIVANsuFgw2Z5XryWlzufSAgriNo5pDMA0GCSqGSIb3DQEB\nBQUAMBsxGTAXBgNVBAMTEGlkcC51dHN5c3RlbS5lZHUwHhcNMDkwNjIwMjEyNzIy\nWhcNMjkwNjIwMjEyNzIyWjAbMRkwFwYDVQQDExBpZHAudXRzeXN0ZW0uZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiUJ9hGEJw0EIBIL2InLhCsZZ\n7maurudIUPt9NVQxPFHI7DwhTXwEjhYbTCnNYHS1JjEdnqzYLZitKfLYMkxPapVu\nfEDVBoLCnabRjKuOjLgIraYX5/rdvzgJPGAn7chL76ut5S3EuQNQ7LDD0KWR71qH\ny3TjZD3RXImFCRXvjLOlZR9+jVA1bKLzcafWUyHTv9wW8s/EyN+33ghOwRNzuH9W\n4ZUvUU2/22MYDlHwbCmwfvF8cYoHfk9WK+fgN+5BGGk+YJvjTAdek6tqeLPsFcR5\ncxvDwjyq00sZPb/xDRCTEgtx3StEYSEXqU1Z62/uHmlZ/oeFW21j59ls/CRp3wID\nAQABo2cwZTBEBgNVHREEPTA7ghBpZHAudXRzeXN0ZW0uZWR1hidodHRwczovL2lk\ncC51dHN5c3RlbS5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFErG8hS4tDz7\n5KwTs0pGvgb1DeR7MA0GCSqGSIb3DQEBBQUAA4IBAQAO4uo9SuOK3/uLJozn+W0L\nMymzQ6OLLZHuOX2lr/+2+I4YXzp8uqdwp8M7+GVlKDU+7JVEfFl+d7mtPrtThdYz\naSjip2XjOQdaE/+vY/oD/G750YAZsxOsWQQKPZIC4LClHjLz2H36Wc8nuTKxZzV+\nFLOa1rOT3iYnL2rY+Mzqet3mwz/yoPq8M1/0J/HtvEWyhRkt7SBPnoNZbMt0y33H\nDbzkGdzI4NTA/flqEuAXBrjkg64qktKR7YTkFRWvy1pl44MqiVmP5nvZgVZZmRYg\nBaqXA+v1pIIo2tL8IuUiQxH1KsnDCXE/F74PcEu2CDCVKEgaVEB1v6tGFZwYr2V7", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.utsystem.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.utsystem.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Texas System", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Texas System", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.utsystem.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:uab.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Alabama at Birmingham", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Alabama at Birmingham", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uab.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Landy Manderson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "landy@uab.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "UABIT User Services", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "UserServices@uab.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Robert Cloud", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "recloud@uab.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "urn:mace:incommon:rutgers.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Rutgers, The State University of New Jersey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Rutgers, The State University of New Jersey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.rutgers.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Charles Hedrick", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hedrick@rutgers.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:columbia.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Columbia University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Columbia University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.columbia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Andrew Johnston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "andrew@columbia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rama Balasubramanian", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rb2684@columbia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://staging.dreamspark.com/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Microsoft", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Microsoft", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.microsoft.com/en/us/default.aspx", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian Conte", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "v-bconte@microsoft.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Scott Blackwell", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Scott.Blackwell@microsoft.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://ucready-qa.berkeley.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.berkeley.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Karin Bliman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kbliman@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFIzCCBAugAwIBAgICAhkwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUxNTE4NDAyOVoXDTExMDUx\nNjE4NDAyOVowJjEkMCIGA1UEAxMbdWNyZWFkeS13aW4tcWEuYmVya2VsZXkuZWR1\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCcSo+yS0oAPy3gdjDBa6hJSstD\nkQKpE79ICtr7IWzr/CHv3C4QgIeszjOVtSdh8MagaWN+4baYpCjPCPyguiRSHmsE\nehIB7F4rtTjEfGc25G1sbCxLOCJOx10rF6PhoKv/nwkiUmgUQbaldEYio37PKZwx\n4lqme1QjPUr6PiChSwIDAQABo4ICrTCCAqkwDgYDVR0PAQH/BAQDAgWgMAwGA1Ud\nEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQW\nBBT1399UiHlVJtxzIGP8qdg4hZ+6XzB+BgNVHSMEdzB1gBSTLchhGK1j45tls53d\njZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZl\nZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9y\naXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2lu\nY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2Nh\nLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYD\nVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1v\nbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNV\nHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNv\nbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAmBgNV\nHREEHzAdght1Y3JlYWR5LXdpbi1xYS5iZXJrZWxleS5lZHUwDQYJKoZIhvcNAQEF\nBQADggEBAC4vpBGnf0fCA8cRaYtihXNfll0Zlvxkl+n1Qsyxm4MIskrMJkVpKtUV\nHZfUdMEukCSa/VZo94L6/dc64OLtmR/PRvPLLhIXxhews5vGEst03xVuvEEIyHWY\n9L+8+E9ac7JKiQYg8bj1clAZWmWbpS5zA0uP1Viv+hUc5LuICFriDkdAEHhgtxpe\nnVDZ2j2I8N29Sals6q7rUyrJ+qkYvIZR+8i4oyBLfC4K/hACRm/zN5lgNdGSbyXm\nsY0ifnm99EzFEQlBYOUsVPH9UxmZfWXqnJgTsGwTqNYG9c/agoUDJEZf0UFrlYE8\njW+jEwXnXt5XC4Eao7BXv/IET2jcuCM=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ucready-qa.berkeley.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ucready-qa.berkeley.edu/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-ufl-csm.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFszCCBJugAwIBAgICAnAwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgxMjE3NTQ0MFoXDTExMDgx\nMzE3NTQ0MFowLDEqMCgGA1UEAxMhc2hpYmJvbGV0aC11ZmwtY3NtLnN5bXBsaWNp\ndHkuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAphrTqfSDOmbM\nGW2N9poghTN2Z3he7dcupbTkoea04XZsrP33VS165iXrl+2Y1+qiH1seSJkEX2+y\ndsmhHwqgrlzxReHxwc3uw+IC2KgPzeMiDpblZ0xYynpKvBWhqislu11H/S5OeGN3\nuaTOmnU4WMU/L9Qq/dgdR4c04vfguoRYX/Ed+fqgk2utmyXiwWsApescwfORSR1X\nGq4znKB205t7vo2fWEVsSMk0yIB8tdY1dNC6T7mtqQ6Sfzyp6xh0oEtmybLV0c7X\nQXsY9R/P5VmjxprtWxIp1+Xv3b6pfyLKAzqYX8bXBe1T6bhnkTevPiW76dzGSSIq\nSZyn6Ucd9QIDAQABo4ICszCCAq8wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQC\nMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBS5OQID\n2BAXA90uVaAEOKkCtqi4aTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pj\nRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRp\nb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEA\nMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9u\nY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRz\nLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGF\nMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBV\nMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNh\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAsBgNVHREEJTAj\ngiFzaGliYm9sZXRoLXVmbC1jc20uc3ltcGxpY2l0eS5jb20wDQYJKoZIhvcNAQEF\nBQADggEBAK9ADnWge/Z3zywqsYyilMeg0loq03cEhwPtHGdCyBO734bKUwB7ekTr\n5DLiMXtuB4iJv+E9A/j/Um6qAv7HFyrHR6bst0A7F1zHTQa0IgQrM6r+N7R5OHEv\nRfclZUIP4eYQwnwDyfEKaXTym5cE2k/JC6a9wygFi8CUBss230RmVUWBFFadEng6\nbvUtKlQDJUzl7Zzr1aiHZpdNaTU9haxMT8U5HmcMrJzGN+pBi8G2Zia1/Jt32EY6\nxNXXlNqPcsJlT1Gk6mK23TgkYXpvzugkAAxv/xnLtKnwgLzWT9icLnIl21iR871i\n8VOL2mTyYxnqX2xPL1hYgsxvPBr256M=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shibboleth-ufl-csm.symplicity.com/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shibboleth-ufl-csm.symplicity.com/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:nih.gov": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "National Institutes of Health", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "National Institutes of Health", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.nih.gov/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Debbie Bucci", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bucci@mail.nih.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "NIH ISC Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "NIHISCSupport@mail.nih.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "NIH Federation Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "NIHFederationTechnicalSupport@mail.nih.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://idp.incommonfederation.org/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFKTCCBBGgAwIBAgICAOowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA3MTIwNjE1MjgyN1oXDTA5MTIw\nNjE1MjgyN1owJTEjMCEGA1UEAxMaaWRwLmluY29tbW9uZmVkZXJhdGlvbi5vcmcw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMsS3N7wt4yxSxx8yeb08b7go2Nm\nHpKR754gn60sUNhiep1jI3s7kALvK+OTN//fBOf3thTOJDF2k6GC3cj9b0nALPoJ\ngv1/DLsEuCLdndbCVlyBNhG/xxB+kcIkjl/olTH9hO3XSFBFNA0JQbgqbQ/8mqmb\n5nPEqNM4c/td1h/PAgMBAAGjggK0MIICsDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0T\nAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYE\nFB7//2MNy4fSWlaLofsdoJssBz8eMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2N\nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVk\nZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3Jp\ndHmCAQAwgboGCCsGAQUFBwEBBIGtMIGqMIGnBggrBgEFBQcwAoaBmmh0dHA6Ly9p\nbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9j\nYS1jZXJ0cy5wN2IKCQlDQSBJc3N1ZXJzIC0gVVJJOmh0dHA6Ly9pbmNvbW1vbmNh\nMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5w\nN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8v\naW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5j\ncmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRw\nOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5w\nZGYwJQYDVR0RBB4wHIIaaWRwLmluY29tbW9uZmVkZXJhdGlvbi5vcmcwDQYJKoZI\nhvcNAQEFBQADggEBAHHyY6qs7hO1x0l+UQaO+Um0UH42afl0ZjTk/KFKh/PxgiTu\ntQmf9QBWSOjoOp9F2k3DVMb+2wDVItvPCVC42scmuIfJ/Pz2OFJEvw/LcaeJePNF\nGFh1JlsaAnd8Qz5pf8gyz5tWgVm/v/pdT8tu2uGPK07T+EcQhmsUP2zmkS3BTHnB\nanLUxamn4rqe5KHRkV/dJ7Ikm0r37R/pXCQu1d/aF9thZQ2GB8/uxYxLlqNN379F\nl7vmn2me4bqIfd/ViFaPDz2J9Sw4475aZHzZpMq2SDuhNKecatEVZrpFrrvXBUOV\nqofWkuCJKHd3rr2lhILwUcsDMZUbPW2o1v+Hiy4=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.incommonfederation.org:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Tech Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "techsupport@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "idpsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.incommonfederation.org/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.incommonfederation.org/idp/profile/Shibboleth/SSO"
          }
        ], 
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFKTCCBBGgAwIBAgICAOowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA3MTIwNjE1MjgyN1oXDTA5MTIw\nNjE1MjgyN1owJTEjMCEGA1UEAxMaaWRwLmluY29tbW9uZmVkZXJhdGlvbi5vcmcw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMsS3N7wt4yxSxx8yeb08b7go2Nm\nHpKR754gn60sUNhiep1jI3s7kALvK+OTN//fBOf3thTOJDF2k6GC3cj9b0nALPoJ\ngv1/DLsEuCLdndbCVlyBNhG/xxB+kcIkjl/olTH9hO3XSFBFNA0JQbgqbQ/8mqmb\n5nPEqNM4c/td1h/PAgMBAAGjggK0MIICsDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0T\nAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYE\nFB7//2MNy4fSWlaLofsdoJssBz8eMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2N\nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVk\nZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3Jp\ndHmCAQAwgboGCCsGAQUFBwEBBIGtMIGqMIGnBggrBgEFBQcwAoaBmmh0dHA6Ly9p\nbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9j\nYS1jZXJ0cy5wN2IKCQlDQSBJc3N1ZXJzIC0gVVJJOmh0dHA6Ly9pbmNvbW1vbmNh\nMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5w\nN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8v\naW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5j\ncmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRw\nOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5w\nZGYwJQYDVR0RBB4wHIIaaWRwLmluY29tbW9uZmVkZXJhdGlvbi5vcmcwDQYJKoZI\nhvcNAQEFBQADggEBAHHyY6qs7hO1x0l+UQaO+Um0UH42afl0ZjTk/KFKh/PxgiTu\ntQmf9QBWSOjoOp9F2k3DVMb+2wDVItvPCVC42scmuIfJ/Pz2OFJEvw/LcaeJePNF\nGFh1JlsaAnd8Qz5pf8gyz5tWgVm/v/pdT8tu2uGPK07T+EcQhmsUP2zmkS3BTHnB\nanLUxamn4rqe5KHRkV/dJ7Ikm0r37R/pXCQu1d/aF9thZQ2GB8/uxYxLlqNN379F\nl7vmn2me4bqIfd/ViFaPDz2J9Sw4475aZHzZpMq2SDuhNKecatEVZrpFrrvXBUOV\nqofWkuCJKHd3rr2lhILwUcsDMZUbPW2o1v+Hiy4=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "InCommon LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "InCommon Operations", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.incommon.org", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://www.marinegenomics.org/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.clemson.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kyle Peacock", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kpeacoc@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jill Gemmill", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gemmill@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Barry Johnson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cyclist@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://reset.moodle.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Lucian DiPeso", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ldipeso@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibidp.cit.cornell.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDSDCCAjCgAwIBAgIVAOZ8NfBem6sHcI7F39sYmD/JG4YDMA0GCSqGSIb3DQEB\nBQUAMCIxIDAeBgNVBAMTF3NoaWJpZHAuY2l0LmNvcm5lbGwuZWR1MB4XDTA5MTEy\nMzE4NTI0NFoXDTI5MTEyMzE4NTI0NFowIjEgMB4GA1UEAxMXc2hpYmlkcC5jaXQu\nY29ybmVsbC5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCTURo9\n90uuODo/5ju3GZThcT67K3RXW69jwlBwfn3png75Dhyw9Xa50RFv0EbdfrojH1P1\n9LyfCjubfsm9Z7FYkVWSVdPSvQ0BXx7zQxdTpE9137qj740tMJr7Wi+iWdkyBQS/\nbCNhuLHeNQor6NXZoBgX8HvLy4sCUb/4v7vbp90HkmP3FzJRDevzgr6PVNqWwNqp\ntZ0vQHSF5D3iBNbxq3csfRGQQyVi729XuWMSqEjPhhkf1UjVcJ3/cG8tWbRKw+W+\nOIm71k+99kOgg7IvygndzzaGDVhDFMyiGZ4njMzEJT67sEq0pMuuwLMlLE/86mSv\nuGwO2Qacb1ckzjodAgMBAAGjdTBzMFIGA1UdEQRLMEmCF3NoaWJpZHAuY2l0LmNv\ncm5lbGwuZWR1hi5odHRwczovL3NoaWJpZHAuY2l0LmNvcm5lbGwuZWR1L2lkcC9z\naGliYm9sZXRoMB0GA1UdDgQWBBSQgitoP2/rJMDepS1sFgM35xw19zANBgkqhkiG\n9w0BAQUFAAOCAQEAaFrLOGqMsbX1YlseO+SM3JKfgfjBBL5TP86qqiCuq9a1J6B7\nYv+XYLmZBy04EfV0L7HjYX5aGIWLDtz9YAis4g3xTPWe1/bjdltUq5seRuksJjyb\nprGI2oAv/ShPBOyrkadectHzvu5K6CL7AxNTWCSXswtfdsuxcKo65tO5TRO1hWlr\n7Pq2F+Oj2hOvcwC0vOOjlYNe9yRE9DjJAzv4rrZUg71R3IEKNjfOF80LYPAFD2Sp\np36uB6TmSYl1nBmS5LgWF4EpEuODPSmy4sIV6jl1otuyI/An2dOcNqcgu7tYEXLX\nC8N6DXggDWPtPRdpk96UW45huvXudpZenrcd7A==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibidp.cit.cornell.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Andrea Beesing", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "amb3@cornell.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Steve Edgar", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "se10@cornell.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Joy Veronneau", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jv11@cornell.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibidp.cit.cornell.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibidp.cit.cornell.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDSDCCAjCgAwIBAgIVAOZ8NfBem6sHcI7F39sYmD/JG4YDMA0GCSqGSIb3DQEB\nBQUAMCIxIDAeBgNVBAMTF3NoaWJpZHAuY2l0LmNvcm5lbGwuZWR1MB4XDTA5MTEy\nMzE4NTI0NFoXDTI5MTEyMzE4NTI0NFowIjEgMB4GA1UEAxMXc2hpYmlkcC5jaXQu\nY29ybmVsbC5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCTURo9\n90uuODo/5ju3GZThcT67K3RXW69jwlBwfn3png75Dhyw9Xa50RFv0EbdfrojH1P1\n9LyfCjubfsm9Z7FYkVWSVdPSvQ0BXx7zQxdTpE9137qj740tMJr7Wi+iWdkyBQS/\nbCNhuLHeNQor6NXZoBgX8HvLy4sCUb/4v7vbp90HkmP3FzJRDevzgr6PVNqWwNqp\ntZ0vQHSF5D3iBNbxq3csfRGQQyVi729XuWMSqEjPhhkf1UjVcJ3/cG8tWbRKw+W+\nOIm71k+99kOgg7IvygndzzaGDVhDFMyiGZ4njMzEJT67sEq0pMuuwLMlLE/86mSv\nuGwO2Qacb1ckzjodAgMBAAGjdTBzMFIGA1UdEQRLMEmCF3NoaWJpZHAuY2l0LmNv\ncm5lbGwuZWR1hi5odHRwczovL3NoaWJpZHAuY2l0LmNvcm5lbGwuZWR1L2lkcC9z\naGliYm9sZXRoMB0GA1UdDgQWBBSQgitoP2/rJMDepS1sFgM35xw19zANBgkqhkiG\n9w0BAQUFAAOCAQEAaFrLOGqMsbX1YlseO+SM3JKfgfjBBL5TP86qqiCuq9a1J6B7\nYv+XYLmZBy04EfV0L7HjYX5aGIWLDtz9YAis4g3xTPWe1/bjdltUq5seRuksJjyb\nprGI2oAv/ShPBOyrkadectHzvu5K6CL7AxNTWCSXswtfdsuxcKo65tO5TRO1hWlr\n7Pq2F+Oj2hOvcwC0vOOjlYNe9yRE9DjJAzv4rrZUg71R3IEKNjfOF80LYPAFD2Sp\np36uB6TmSYl1nBmS5LgWF4EpEuODPSmy4sIV6jl1otuyI/An2dOcNqcgu7tYEXLX\nC8N6DXggDWPtPRdpk96UW45huvXudpZenrcd7A==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibidp.cit.cornell.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibidp.cit.cornell.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Cornell University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Cornell University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.cornell.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:rochester.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Rochester", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Rochester", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.rochester.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Charles Yanaitis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "charles.yanaitis@rochester.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Sean Singh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "sean.singh@rochester.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Sean Singh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "sean.singh@rochester.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://alfresco.nau.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Northern Arizona University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Northern Arizona University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://home.nau.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Mark Steddom", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mark.steddom@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Ahsan Imam", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ahsan.imam@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:musc.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Medical University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Medical University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.musc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Richard Gadsden", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gadsden@musc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Joshua Staples", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "staplesj@musc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://secure.career.ucla.edu/sp/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Career HelpDesk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ccadmin@career.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Ren mao", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rmao@career.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Joel Bellon", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jbellon@career.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://wiki.clemson.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.clemson.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Barry Johnson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hbj@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Kathy Wright", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kewrig@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Jill Gemmill", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gemmill@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHDCCAgSgAwIBAgIJAPSKZ75YpLvBMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEHdpa2kuY2xlbXNvbi5lZHUwHhcNMDgxMTA2MjAxNzEzWhcNMTgxMTA0MjAx\nNzEzWjAbMRkwFwYDVQQDExB3aWtpLmNsZW1zb24uZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAuejzfYPLJmtRwf+KD41bgT0d/BtLVEqXJhHOIG+P\nUWAyJtel+QYWMqLSuByRHxaSBAropIiKGDIVqk9M0gO1NWgLfVggY4qJCxUDi7/W\n2iF9jU3vsOcmJQGbTxd10ZNet/BVS4adJKccyNK59xRgfseS6iIve0Y3HY/Nmu5e\ny/IM00kQQk3E5jAwRxu6JLhWyQXYq19keHjFwE3aYPpmMg0OFhCZRjIMD0HP7cFb\nwa+lnG0zmbJgpUmpg5c3iyWfhxOFtlL+rNihDB709Ti/a8yLAu6ShaoUrPNmZXuK\nv7/bwj/OE0HFNw9rKhIyALxeWupsAvYM2e2fmIeQWVqSWwIDAQABo2MwYTBABgNV\nHREEOTA3ghB3aWtpLmNsZW1zb24uZWR1hiNodHRwczovL3dpa2kuY2xlbXNvbi5l\nZHUvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUAZNFPiVlNnKKfNyx8yd3gKkrT3UwDQYJ\nKoZIhvcNAQEFBQADggEBAFgxrdH1hLRx+2xlmUfiyJt82VJiIXuRp0sgk/Buyjcj\nTZjU1RMWRasnmXJh6RsirP000IOZ7mK2NWnTlY2zbGWiIqifhiQpn+SqLiL2Fbww\n1cM9fNdI1lXtamIo9m5DGsnN39AirezbwgjMGnW2tHUrw/KYqjDYui9nRhBOE4BB\nD7r3vVW8CJH/sbId/wKyb27H1Ep/9k5l+wr82kOCvtM4Fr2CCArFbablgOykyKA/\nd1rQlfU/3tgwReVT9tHUVAt4vubiHbHvvH5j5o/WRdXJMNiLBzmmMdi8+m5vT4NF\n2XiCrPad9FnZZWLdPApSsmp4N9vhJKaJWAEB+Po1ud4=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://wiki.clemson.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:starkstate.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stark State College of Technology", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stark State College of Technology", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.starkstate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Josh Bresaw", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jbresaw@starkstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Geoff Starnes", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gstarnes@starkstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://emp037.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Heather Tufts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "heather.tufts@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://wiki.cis-qas.brown.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Brown University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Brown University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.brown.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Shibboleth Administrator", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idm-shib-admin@brown.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibtest.campus.stonybrook.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stony Brook University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stony Brook University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sunysb.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Sanjay Kapur", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Sanjay.Kapur@stonybrook.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Brian Heller", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Brian.Heller@stonybrook.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://its-tiefighter.lsu.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Louisiana State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Louisiana State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.lsu.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Quang Le", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "qle3@lsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDCTCCAfGgAwIBAgIJAIeVP4kx8uExMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFml0cy10aWVmaWdodGVyLmxzdS5lZHUwHhcNMDkwOTE4MjE1OTM0WhcNMTkw\nOTE2MjE1OTM0WjAhMR8wHQYDVQQDExZpdHMtdGllZmlnaHRlci5sc3UuZWR1MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAox0+jxwn91BZ9EldgFvjR/TG\nPzng2JvI3SLesrwmfGraSIG9L5I41BDP1+8NKVgXykD2o3Lsg+0WF2tgsmqyD8gu\nL7xJXC8R7c84fuDMTeZh08wtfjUKAZ5JC4ZHErQ24JYkjdR21Nx6XW05gFzGGs/T\nHoF/kwfYY8VDRw6H2UkNuXbMq4T0Xi3oZorC7Fm66KqMPIiraZ9b3AtTnEFrDrb+\n1cl0TfqrsRGEZJeGxxVJQfIUzFOC+W/uCqtsu19FGh6Nl5npuwPitQLDJV1LjVZd\nFAG/B7CdCOuCd1YE7JqIgy6Pvw4G/xkA8RsUDG6iFtEuWeVksfCKwEPZ527pqQID\nAQABo0QwQjAhBgNVHREEGjAYghZpdHMtdGllZmlnaHRlci5sc3UuZWR1MB0GA1Ud\nDgQWBBQHTHDF/FCI37styekmVNlCkDRxOTANBgkqhkiG9w0BAQUFAAOCAQEAoweA\nClueM7VjQQw+oPdlKl5yL2cQRso9W2RcCP52G6CzvC6CiZ4tDAXeHL6ziBIwtjY9\n3m8iKr6WLZ8nfy97QHSM064vpo2BqVgWTuwOO/2u+9K1koFG53TnuRWej8rmkHr0\nQYIs5eZcxRzum5iOooBsopvHi0JLIfK2P2ZoXIEqym4NBotl14o0L8A4K5h4asd6\nD6a7WpU0hGuyBwEzahroDmUQSmCHa6sI0txf0feJqM0JBd3/aPVciu7RVyYrLsgy\n2JLMhhrZhbT2W2BIfzZagvaAXWsQKONpN25ut6ZGDU30VZtHUxoQ+nTYp6YPZXgO\n3PNiOFfZFJk7Lk5Liw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/SAML2/ECP"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://its-tiefighter.lsu.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth.fullerton.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHTCCBAWgAwIBAgICAiMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUyOTE4MjkyM1oXDTExMDUz\nMDE4MjkyM1owIzEhMB8GA1UEAxMYc2hpYmJvbGV0aC5mdWxsZXJ0b24uZWR1MIGf\nMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC9KRT9dYGUHDgmp2h1Sawi3tSZVtYy\naud/18ePQAfiVrq4ldGhUCz1eG6hDFGQHf5saHRsQMBrM59ghNn1D34QIOgkjLcT\npHmVaTfRLa4HkG6NTDfiF0GAIuoYWdTraXUX9L0cUYQSBxlqO8i1IdrOVG+LSv/6\n+AqSEa7u6+kLgwIDAQABo4ICqjCCAqYwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB\n/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQJ\n03m0157zbkqXYHYOlCezQM5TezB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO6\n58pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVy\nYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5\nggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29t\nbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNl\ncnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0f\nBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNy\nbDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAE\nVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1v\nbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAjBgNVHREE\nHDAaghhzaGliYm9sZXRoLmZ1bGxlcnRvbi5lZHUwDQYJKoZIhvcNAQEFBQADggEB\nAGOJaWQApOSDQ0ShpKLwRBO0xP3Ib0jRIBaJTizkz/hoqVaEXT6y2T7zkOEV8eTY\n03/j8ZPe2LiQPvoxy7jUu5j9bzuW1nxkLo2kvUmcIzesFeSvETTTq+Mwg+FIbRFf\nm49aR/3xX6qqmDMBqnJHX3XW7KjPR03C+4Q5mqPkxUPL0kydfH7fnQd8tT3ibSs7\n2OUmRcImynx9DkWx9UXxySSBxUAvgVexahfixhpR0/BSMto/ZQAeUO9fzIOqJekB\n1hC7XMCLLFaG1FUq/1689iZopiegVVWQcWI7u6jDepl9LIdeYl68zxW04cSI4nvr\nlxm5OkGfxyyCrC3a5/HXcpI=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth.fullerton.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "James O'Dell", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jodell@fullerton.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.fullerton.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.fullerton.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.fullerton.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.fullerton.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHTCCBAWgAwIBAgICAiMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUyOTE4MjkyM1oXDTExMDUz\nMDE4MjkyM1owIzEhMB8GA1UEAxMYc2hpYmJvbGV0aC5mdWxsZXJ0b24uZWR1MIGf\nMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC9KRT9dYGUHDgmp2h1Sawi3tSZVtYy\naud/18ePQAfiVrq4ldGhUCz1eG6hDFGQHf5saHRsQMBrM59ghNn1D34QIOgkjLcT\npHmVaTfRLa4HkG6NTDfiF0GAIuoYWdTraXUX9L0cUYQSBxlqO8i1IdrOVG+LSv/6\n+AqSEa7u6+kLgwIDAQABo4ICqjCCAqYwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB\n/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQJ\n03m0157zbkqXYHYOlCezQM5TezB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO6\n58pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVy\nYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5\nggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29t\nbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNl\ncnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0f\nBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNy\nbDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAE\nVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1v\nbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAjBgNVHREE\nHDAaghhzaGliYm9sZXRoLmZ1bGxlcnRvbi5lZHUwDQYJKoZIhvcNAQEFBQADggEB\nAGOJaWQApOSDQ0ShpKLwRBO0xP3Ib0jRIBaJTizkz/hoqVaEXT6y2T7zkOEV8eTY\n03/j8ZPe2LiQPvoxy7jUu5j9bzuW1nxkLo2kvUmcIzesFeSvETTTq+Mwg+FIbRFf\nm49aR/3xX6qqmDMBqnJHX3XW7KjPR03C+4Q5mqPkxUPL0kydfH7fnQd8tT3ibSs7\n2OUmRcImynx9DkWx9UXxySSBxUAvgVexahfixhpR0/BSMto/ZQAeUO9fzIOqJekB\n1hC7XMCLLFaG1FUq/1689iZopiegVVWQcWI7u6jDepl9LIdeYl68zxW04cSI4nvr\nlxm5OkGfxyyCrC3a5/HXcpI=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.fullerton.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.fullerton.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Fullerton", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Fullerton", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.fullerton.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://emp095.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Heather Tufts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "heather.tufts@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFCzCCA/OgAwIBAgICAZUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDgxMjE4NDgxM1oXDTEwMDgx\nMzE4NDgxM1owGjEYMBYGA1UEAxMPcGVvcGxlYWRtaW4uY29tMIGfMA0GCSqGSIb3\nDQEBAQUAA4GNADCBiQKBgQDdAujQPFfA3SJbvATaV3ZOyrU0pR+XTYxt1YscwGWB\n65oJpinlJVt8EX6Wv57UiRd1qNUmvxOKzQy+yMRBsc4g+whvaeumiLgz2Qlhp8g1\nSNsR/gmVYPLOLNzmVPrX7XNKNli5+DOqtq5F4+9ou8bwqiqzRFy+lPWYLgYMvegh\n/wIDAQABo4ICoTCCAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQ2Nt7DOvqITu4x\nRqumCysoiZP7WTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgw\nVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAn\nBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggr\nBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+g\nPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysG\nAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9wZW9w\nbGVhZG1pbi5jb20wDQYJKoZIhvcNAQEFBQADggEBADiiC7+8367p+Rgdzpiul67Y\nrci//XYMt5eklnWSDDnILTxCmnZ/9qBnpARjzIIyUToU8qR53F8UHjpp3SAzLgxA\nCiQWSIWOzoqAJHKfKeQNID51wKLH5BP+6YD52+Q8ufjZgpYierKqLcJqtf+WaQGX\n36kVQP38uI3zK7jHnr28mN5OCEyKPAV+4Rs2KwxG+6rQ/NjBM+W0Y/k34Uguk2XM\nMOvH3xJ+SwsQJBcjigErJwsl1zOZxlvHEg8/p719H/dK8ZbZROHw2z5LMoCdwMmf\nIFJDINAoOBl+1Mb5A0xgbbDpQbh1/+KLgd+rOdA1ko6m0o4bfxAQHuM8M7xJsSc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://jobs.odu.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cs095.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://training095.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://test40.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-uchicago.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "noc@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ptatrain.travel.ucla.edu/shibboleth/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian Kim", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bkim@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Hemkant Patil", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hpatil@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Belinda Borden", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bborden@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://idp.princeton.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDLzCCAhegAwIBAgIUMfmaP7flCY4+d5Gnju4bntgM57wwDQYJKoZIhvcNAQEF\nBQAwHDEaMBgGA1UEAxMRaWRwLnByaW5jZXRvbi5lZHUwHhcNMDkxMDMwMTI1MTM5\nWhcNMjkxMDMwMTI1MTM5WjAcMRowGAYDVQQDExFpZHAucHJpbmNldG9uLmVkdTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJE0moHwKJGyg9z94dvN0HCB\nklHGPvRdIB0nvzAJxo9KaF81zFaqHpvprwNEoB3Pfy18hIbtnDSv/sV/j6pnKnBw\nXXsf7QJOOF81klkGHZh4C9VnjUL5ok9Ahx1zPgaLcCgvZeGRG7DiRPnOgxVzuwoB\nWFnEWBCoLaqcZUl2njnawRB+LXt8mO+HPhsMO8c7ASJ50hF/l9cGaCs3ucEcwp9d\nFoxSiVy2TMyatszHTHZknaqVyqR+WNCxE/Jpcwfi1oq6k3V5T372GE8WTKclgvpg\nIYV8ISROBHpVlYz9v3N0nnpOn+Io6zuUOS3YNmuX52vaSciaYNoPcmBxYMEG2jcC\nAwEAAaNpMGcwRgYDVR0RBD8wPYIRaWRwLnByaW5jZXRvbi5lZHWGKGh0dHBzOi8v\naWRwLnByaW5jZXRvbi5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFPQsLxgr\nW14zmCfogqfOscaIPOtoMA0GCSqGSIb3DQEBBQUAA4IBAQAqkhYwrjjwi31OYkDK\njeKyss835BrdLVTqqEfssT3lvYW/SGyRMLCr2hS21p9zbt8dJO67C9RYEjJ/05p2\nKeo+ZQj3ehOP80/phxk0r+Je/fNdpO/HbQG9/DfcYp5sLUXk9koYrXrOHq6KnkVh\nrmikDRb9izfU9nDttB8hWGLiX0WhIvk9xkIAW5ueyL5QxcQmRYNcaT3BUpjkGiBu\nFEsLXa42F1nmdBDGrI2woHNEr2diujL5EOxqIsunquUXuu2dFuNtqA0HRK6wj32b\nfsZT9KwTEdLv/oAbgQ8zlVXErx54GJFg1ksGAJY3lsGY+XdvcUaKuVD2IWOrbCtP\nqZfT", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.princeton.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Steven Niedzwiecki", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "steven@princeton.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Security and Data Protection", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "sdp@princeton.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.princeton.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.princeton.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.princeton.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.princeton.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDLzCCAhegAwIBAgIUMfmaP7flCY4+d5Gnju4bntgM57wwDQYJKoZIhvcNAQEF\nBQAwHDEaMBgGA1UEAxMRaWRwLnByaW5jZXRvbi5lZHUwHhcNMDkxMDMwMTI1MTM5\nWhcNMjkxMDMwMTI1MTM5WjAcMRowGAYDVQQDExFpZHAucHJpbmNldG9uLmVkdTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJE0moHwKJGyg9z94dvN0HCB\nklHGPvRdIB0nvzAJxo9KaF81zFaqHpvprwNEoB3Pfy18hIbtnDSv/sV/j6pnKnBw\nXXsf7QJOOF81klkGHZh4C9VnjUL5ok9Ahx1zPgaLcCgvZeGRG7DiRPnOgxVzuwoB\nWFnEWBCoLaqcZUl2njnawRB+LXt8mO+HPhsMO8c7ASJ50hF/l9cGaCs3ucEcwp9d\nFoxSiVy2TMyatszHTHZknaqVyqR+WNCxE/Jpcwfi1oq6k3V5T372GE8WTKclgvpg\nIYV8ISROBHpVlYz9v3N0nnpOn+Io6zuUOS3YNmuX52vaSciaYNoPcmBxYMEG2jcC\nAwEAAaNpMGcwRgYDVR0RBD8wPYIRaWRwLnByaW5jZXRvbi5lZHWGKGh0dHBzOi8v\naWRwLnByaW5jZXRvbi5lZHUvaWRwL3NoaWJib2xldGgwHQYDVR0OBBYEFPQsLxgr\nW14zmCfogqfOscaIPOtoMA0GCSqGSIb3DQEBBQUAA4IBAQAqkhYwrjjwi31OYkDK\njeKyss835BrdLVTqqEfssT3lvYW/SGyRMLCr2hS21p9zbt8dJO67C9RYEjJ/05p2\nKeo+ZQj3ehOP80/phxk0r+Je/fNdpO/HbQG9/DfcYp5sLUXk9koYrXrOHq6KnkVh\nrmikDRb9izfU9nDttB8hWGLiX0WhIvk9xkIAW5ueyL5QxcQmRYNcaT3BUpjkGiBu\nFEsLXa42F1nmdBDGrI2woHNEr2diujL5EOxqIsunquUXuu2dFuNtqA0HRK6wj32b\nfsZT9KwTEdLv/oAbgQ8zlVXErx54GJFg1ksGAJY3lsGY+XdvcUaKuVD2IWOrbCtP\nqZfT", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.princeton.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Princeton University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Princeton University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.princeton.edu/index.shtml", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "http://research.ucgrid.org/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kejian Jin", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kjin@ats.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Kejian Jin", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kjin@ats.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "UC Grid Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "atshpc@ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "urn:mace:incommon:berkeley.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.berkeley.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jeff McCullough", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jeffmc@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Karl Grose", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "karlgrose@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ctsabbc-test.uth.tmc.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Texas Health Science Center At Houston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Texas Health Science Center At Houston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uth.tmc.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "OAC Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@uth.tmc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Fagon Istre", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Fagon.M.Istre@uth.tmc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHjCCAgagAwIBAgIJANKz/cehEiBhMA0GCSqGSIb3DQEBBQUAMCgxJjAkBgNV\nBAMTHWN0c2FiYmMtdGVzdC5zaGlzLnV0aC50bWMuZWR1MB4XDTA5MDMyMDEwMzYx\nNVoXDTE5MDMxODEwMzYxNVowKDEmMCQGA1UEAxMdY3RzYWJiYy10ZXN0LnNoaXMu\ndXRoLnRtYy5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDatxCN\nDiKpnEIJp6WT2lQTbKRYsKE2SW7No+QSMi2ALGsQxXMAXe0QsczdcPOnrwEumRsa\neQyi0N1GJG0ieSfosuYlvJzY1Ic4oYpOvzvCdl2OCBEz3jP+3wAGMVBNteSPagkh\nGuUrV562Zm6EL44uROqdZJGMt1VblzEkMVa0m7yS70LB4UTxzi7C6j+pQoUZQBwp\njNRURjdGcOrHthSwzQS30Z4e7xriyd26YjE457s0ZFFQKjhhB1fQ1widVx66ByBi\nDAgFUg8seWy7QZEcCRgpau8IodrRdhcYUzZuZFzspXfIunUkt8z5zm3rX/23+HbY\nA7n3LYNC7+cNEEN1AgMBAAGjSzBJMCgGA1UdEQQhMB+CHWN0c2FiYmMtdGVzdC5z\naGlzLnV0aC50bWMuZWR1MB0GA1UdDgQWBBQ8pVA50wtJrbEMUQiDSA8aOiraADAN\nBgkqhkiG9w0BAQUFAAOCAQEAbeeel31EXuK/LZWxqtJjGLGyrOlc50qzJQ3DTlm1\n0mFA4o1LpIWvWocThWXJ9HNBj+B4I5ekVo/I2U3jvGBMBld/i17ZQHelrZV43wU9\ndJMh2i9YTeFDBjoothoSocC9zhVaiIftF04Oc4CFAW2wGeiJR1Inl7W24p5QbV01\n2m7UXl842lTgGEPq8pe+yQdJ0C2/8JpSJX7UsPYs8Mc8NrKbvDRUffTaPEcXUa6u\nmJM0k6HAe/mbc+pAD9IcKP1BLdSEVvWCqSfDrnTzqs9tGSLnFrNybeZvTrA0GjjW\nFDahCvoIglsrn2CBFyVhSRvzWlaqa/ZgpN0erBx0FdFyuQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/SAML2/ECP"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ctsabbc-test.uth.tmc.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://mit.illiad.oclc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Online Computer Library Center Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Online Computer Library Center Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.oclc.org", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Don Hamparian", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@oclc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jason Zavar", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@oclc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://mit.illiad.oclc.org/Shibboleth.sso/Login"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFlzCCBH+gAwIBAgICAkowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxMDE3NTY1NVoXDTExMDcx\nMTE3NTY1NVowHjEcMBoGA1UEAxMTbWl0LmlsbGlhZC5vY2xjLm9yZzCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKZpjLsATe5x4RwEumuP19CtPe81CAkl\n2lCYch1Rx1NNAuKPB45/JhxkbXmudQOvxTJWJv7hnDQ43z3A4BJdBYDj9c0BjvqF\ntSIezx8jyhBjK+OezQ0bD5J7Inf+H8OFum2nHyP2FBYylKsD5BB+psO1wPHUl6PJ\nvBugaxSVAPn4CKUlfu/VijUZlhFO7240CABPtFwS+iGq/d6XjlI7XWDDh4ni9bti\nQ28B21jknHqiqDNcI/iPyrxXT8IUiV56L6eBOk75gqmUsfPI+Wfmw477T/0XD9vP\nDos88j1dCL0L1wLKVtv0LrxepJgm79k6dhqPWxu6WK3eMJxlhE17KQ0CAwEAAaOC\nAqUwggKhMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQG\nCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUC+iLw1Wzf8hV1fWuWtHVSlg9\nf7QwfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNV\nBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJ\nbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEE\ngaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUH\nMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2Jy\naWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0\ncDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNy\nbHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQB\nATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHgYDVR0RBBcwFYITbWl0LmlsbGlhZC5v\nY2xjLm9yZzANBgkqhkiG9w0BAQUFAAOCAQEAdr2I3445DjzIumlYKrRwpvXlEgK6\nJUMR36Wqtj6abLGRHgkNidfyozJhjI2wk5NIyrOjWsVNoruyJX0o7fIsOXDtV/tk\nQ++lFcd9lkTzKtQmy3TwF5OUpV5n+qNaC0g2d4/aWK8KPUsjMtVwUHSG9i4K1/dE\nxriPkTC2JJI1FVcyFVcnACjZkGsvo3QEq5hkYuFLjTDe9vU67PGYTgnmhpJ2UYES\n1p5TvdAmi54SdpBdBOYPv2T7qvdMrNNCC0TPzZvls6jcu1kKFRst64xwg+d+ltJm\nY1DS1xGgPhEi1jdZUjiJoxAVhUK2fX+sOboc6ZU4prpZ/bF14Dy1ztAsqw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mit.illiad.oclc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mit.illiad.oclc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://catalysttools.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Collaborative Platforms", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "teg-cp@cac.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Catalyst IT", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "catalyst-it@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://shibboleth-business-buffalo.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://pqshibboleth.proquest.com:9443/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.proquest.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Chad Roberts, Software Developer Lead, ProQuest (Ann Arbor, MI)", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "chad.roberts@proquest.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://erst1.ais.ucla.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Wen Tang", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "wtang@ais.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "David Lee", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dlee@ais.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "AIS Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hd@ais.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFlTCCBH2gAwIBAgICAqwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTEwNTE5NTg0NFoXDTExMTEw\nNjE5NTg0NFowHTEbMBkGA1UEAxMSZXJzdDEuYWlzLnVjbGEuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1afiAKBMIqFq7tYVueyTppaG2qrdHMIg\nePmSLK8XJBH/r1SPskaTIs5zXJ5CHhqGUrq4eXFWeUnZL77mPTLUCk24NAF/m3DI\nGca1In1EmepUiU28P4nus9GHEn+yA22Bb7ZtEN72eNMT2Og1DbLSFQMrrhRv4BFS\noA3SG+MJYIvFqgFed1GE4629kHx6LyfxBTyjLdtnNuoOzUOqstmnd54ejT3GwWRQ\nJgmQgmLUvsRKIWtV3lhVlnc6mJHDlnxGRM6s9a+wZnhgs51gXllDqW6TYR3ptIz3\ni62811hmedXFXcApkEqwDPa+M56oskpQiOrO8xHn/eYHBax37hO6MwIDAQABo4IC\npDCCAqAwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYI\nKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQ5XFl8ACZT/Trtm0T41IK78BQF\nKTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UE\nBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIElu\nQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSB\npTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcw\nAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJp\nZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRw\nOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Js\ncy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEB\nMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAdBgNVHREEFjAUghJlcnN0MS5haXMudWNs\nYS5lZHUwDQYJKoZIhvcNAQEFBQADggEBALNvvLbz9gdKe3nluRCRr24S2NQipAoP\nOkMo07XKccJx8eXe3bL6dgQn+DC2DU3cwoj5uJFPmNKFRj/4lYvYUwR8W4djYFa0\nBYTteR2bp4MQbWzyigwS7xkI1qSNV0InFBNS744MOVVtlGyqiv5proHQUnLXzczk\nqaGLwNLnv8GsnaRr6qJcrxiWrCJ51Y4k3BPsZp2KGjzJ8iWVbT2ZRU8UjWXXI7nl\nv5bL9ohWP1BvaJBZlnIpy3JHrLr5UtW8NIfuq8qUIRWj/c8Xe04X7nGuqhEP3k38\nXc9GSkgJ1DfwD9X2djBHLrWTW+eUssmoKEUlta8UgXRGca8ireV9Unc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://erst1.ais.ucla.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://erst1.ais.ucla.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://erst1.ais.ucla.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://erst1.ais.ucla.edu/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:nau.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Northern Arizona University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Northern Arizona University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://home.nau.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Mark Steddom", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mark.steddom@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Ahsan Imam", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ahsan.imam@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Christopher Michels", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "christopher.michels@nau.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "UCOP DataCenter HelpDesk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ucopdatacenter.helpdesk@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Munish Malik", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "aig@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Paul Weiss", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Paul.Weiss@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "urn:mace:incommon:idp.protectnetwork.org": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "9Star Research Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "ProtectNetwork", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.protectnetwork.org", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Tech Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "incommon@protectnetwork.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Kaustav Ghoshal", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kaustav@9starresearch.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Simon Lee", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "simon.lee@9starresearch.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.protectnetwork.org/protectnetwork-idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.protectnetwork.org/protectnetwork-idp/profile/SAML2/POST/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFKTCCBBGgAwIBAgICAXkwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDcxNTE0NTgwNVoXDTEwMDcx\nNjE0NTgwNVowKTEnMCUGA1UEAxMeaW5jb21tb24tYWEucHJvdGVjdG5ldHdvcmsu\nb3JnMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC2Ymh3z58gH2IR7na6dVdj\noJnuMoB1OreRl6Sv9OZTHQv5PMV30mZrlFMU4feiF4UINhBkgaBrLGXC0hDNNodI\n91hhY9gpiJZPjLlxvCT9zUCBAVvoKzJujev098kBgm8l44LLpFKRB+8DGeGV2n9Q\no6qERUXLlQ8oR82ZgEqQJQIDAQABo4ICsDCCAqwwDgYDVR0PAQH/BAQDAgWgMAwG\nA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1Ud\nDgQWBBQb9vrc/mK8Cux5u9KLvGjqjBywPjB+BgNVHSMEdzB1gBSTLchhGK1j45tl\ns53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9u\nIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0\naG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDov\nL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRz\nL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCB\njQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNv\nbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBe\nBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9p\nbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAp\nBgNVHREEIjAggh5pbmNvbW1vbi1hYS5wcm90ZWN0bmV0d29yay5vcmcwDQYJKoZI\nhvcNAQEFBQADggEBAFQCRL5jJpjF7ygte2umrmumCMHXh2KTKmQveucj6Vbkyv6X\nhj/3ormC1RTgPTTaN7rfTCt5Yxa/JJ/La9BVLryNuMU4L6RdQREZKPLuVPq55ELg\ncC1Br9juDk7p57cSuoNxCYce2q9eu7lO/mNyutwcg6n0PCSQGOQYxfnL7gQczUdm\nCBsV96+ymXh6CF5uaKbc+elQAugKcmxkFvtH7fOG7zZYmlGbZ08V+vGoWWqVAN82\n0Aj/gT0dpO4eF03FBl/VkRWGpnXCEZcIP6kXYxfYFP7kDEDg7DzX39G2YyjWBLip\n57x1+qQ10dWSVo0rl0Ep2leRhwhcWf1lzadqD0k=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://incommon-aa.protectnetwork.org/protectnetwork-idp/profile/SAML1/SOAP/ArtifactResolution"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:uiuc.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uiuc.edu/index.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Mike Grady", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "m-grady@uiuc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Mike Grady", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "m-grady@uiuc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://spaces.ais.ucla.edu/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Albert Wu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "albertwu@ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Warren Leung", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "wleung@ais.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Carl Uebelhart", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cuebelhart@ais.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibezproxy.campus.stonybrook.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stony Brook University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stony Brook University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sunysb.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian Heller", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Brian.Heller@stonybrook.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://emp114.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Thomas Valdez", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "thomas.valdez@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://sog.cac.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Distributed Systems Applications Engineering", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ds-apps@cac.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:case.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Case Western Reserve University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Case Western Reserve University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.cwru.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jeremy Smith", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jeremy.smith@case.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "David Kovacic", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "david.kovacic@case.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://login.ufl.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFizCCBHOgAwIBAgICAjswDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcwNjE3MjYwMFoXDTExMDcw\nNzE3MjYwMFowGDEWMBQGA1UEAxMNbG9naW4udWZsLmVkdTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBAM0UpxKZsVYXooE258HArCHoMjkcmX1ft5IcZicL\n3k2Xb6kMzX3LhTP6WQbompjxGJwiLIGrtKivnlC1HAaJBlUazJ9453l+2K3epnfP\nOkdM48Q7euyVA8pHZCiLcbl4qVi6XHgB+m/6rwBcqQrJOjiYBdbAKWUkzG8r9sqc\nYk8OLaMSAi9cBMYIwpgr3n2i0I0n7DW6XRtWHcmhLiVpWvD7+IpiJ68lcYhI0Z4Y\nOQa1SVE876w42+Gkgfn0RBL0rLZweunEsrZqMjQZiMhWrzpyDIvX9RBcOUXhDO3n\nkHLpCcBIxU2c/hS7C+axIdXWaLREXz8fQ2q7Yn4J7z9oIysCAwEAAaOCAp8wggKb\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUI7NPnfC0TKNmP4JluutfdT5YsjIwfgYD\nVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYTAlVT\nMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNvbW1v\nbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUwgaIw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKGQ2h0\ndHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9j\nZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2lu\nY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3Js\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIG\nCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL3ByYWN0aWNlcy5wZGYwGAYDVR0RBBEwD4INbG9naW4udWZsLmVkdTANBgkq\nhkiG9w0BAQUFAAOCAQEAS6+cRugGp9cHAMiuDBw1pLN8YHBFJpxU4n4ibS0uVTn0\nihw69BiOPj11HzNSCt6mKbu8gg5jlDbj3pXm1I5oABmOVpjkh/+7VU6BA5hKg/Ux\n0mOTzNbs3JFFYJ86+sYuTEZjkSrCTHT3h7edCMULg/yTd/wQ9wEibHAXoasFqLDm\nBhmokdEUQOL1F/wspvFwzVtgsTZrSoHRShWYYsavME/DBy3+Pi3X1QcNBm6utmKV\nXUTzLg3LUp+iFAxzrI9oUL11iehqR+ddrDrgz1/pixLTPD2Y1EJttptdbxh0VJYH\nFgeueyzjrt/lIVNDdMWgg7IHhJjaaqG2GRL8Aa4nhQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://login.ufl.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Michael Conlon", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mconlon@ufl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Eli Ben-Shoshan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ebs@ufl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Fran McDonell", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "fran@ufl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Warren Curry", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "whcurry@ufl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://login.ufl.edu/error.html", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.ufl.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.ufl.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFizCCBHOgAwIBAgICAjswDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcwNjE3MjYwMFoXDTExMDcw\nNzE3MjYwMFowGDEWMBQGA1UEAxMNbG9naW4udWZsLmVkdTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBAM0UpxKZsVYXooE258HArCHoMjkcmX1ft5IcZicL\n3k2Xb6kMzX3LhTP6WQbompjxGJwiLIGrtKivnlC1HAaJBlUazJ9453l+2K3epnfP\nOkdM48Q7euyVA8pHZCiLcbl4qVi6XHgB+m/6rwBcqQrJOjiYBdbAKWUkzG8r9sqc\nYk8OLaMSAi9cBMYIwpgr3n2i0I0n7DW6XRtWHcmhLiVpWvD7+IpiJ68lcYhI0Z4Y\nOQa1SVE876w42+Gkgfn0RBL0rLZweunEsrZqMjQZiMhWrzpyDIvX9RBcOUXhDO3n\nkHLpCcBIxU2c/hS7C+axIdXWaLREXz8fQ2q7Yn4J7z9oIysCAwEAAaOCAp8wggKb\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUI7NPnfC0TKNmP4JluutfdT5YsjIwfgYD\nVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYTAlVT\nMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNvbW1v\nbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUwgaIw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKGQ2h0\ndHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9j\nZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2lu\nY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3Js\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIG\nCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL3ByYWN0aWNlcy5wZGYwGAYDVR0RBBEwD4INbG9naW4udWZsLmVkdTANBgkq\nhkiG9w0BAQUFAAOCAQEAS6+cRugGp9cHAMiuDBw1pLN8YHBFJpxU4n4ibS0uVTn0\nihw69BiOPj11HzNSCt6mKbu8gg5jlDbj3pXm1I5oABmOVpjkh/+7VU6BA5hKg/Ux\n0mOTzNbs3JFFYJ86+sYuTEZjkSrCTHT3h7edCMULg/yTd/wQ9wEibHAXoasFqLDm\nBhmokdEUQOL1F/wspvFwzVtgsTZrSoHRShWYYsavME/DBy3+Pi3X1QcNBm6utmKV\nXUTzLg3LUp+iFAxzrI9oUL11iehqR+ddrDrgz1/pixLTPD2Y1EJttptdbxh0VJYH\nFgeueyzjrt/lIVNDdMWgg7IHhJjaaqG2GRL8Aa4nhQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://login.ufl.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://login.ufl.edu/idp/profile/SAML1/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Florida", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Florida", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ufl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:carleton.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Carleton College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Carleton College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.carleton.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Matthew Bockol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mbockol@carleton.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://northwestern.ares.atlas-sys.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Atlas Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Atlas Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.atlas-sys.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Curtis Poston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cposton@atlas-sys.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Kathy Poston", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kposton@atlas-sys.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://northwestern.ares.atlas-sys.com/ares/Shibboleth.sso/Login"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDZDCCAkygAwIBAgIJAOY74ZY0rkL2MA0GCSqGSIb3DQEBBQUAMCoxKDAmBgNV\nBAMTH25vcnRod2VzdGVybi5hcmVzLmF0bGFzLXN5cy5jb20wHhcNMTAwMjE3MTUx\nMzUwWhcNMTMwMjE2MTUxMzUwWjAqMSgwJgYDVQQDEx9ub3J0aHdlc3Rlcm4uYXJl\ncy5hdGxhcy1zeXMuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\n0vK4YJ6A2RJqEjElnI2u8rW8FnkebX5bzWHaoLVWfbSgD4YWSpQcclZXv5xDcmeY\norYt0WYoCDrEJ8o+X/r7NJUKDDb4DG7O21tBDL4xQ0S3kj432Mfq1HWnk/JZ361M\nHctkWIIkSdoswfP/4O3KVGtMShA80J77r9NeKa4O+fKPLlTTwwLxcpX0oe8ROCfZ\nIVyVj46Xi8+MxWOPrECtjlsP7tx+SlIQ0IV6arItkA1CcnQ/rBrLLPNFOcsQ0CDm\nVi4dzOIoqa2hEE/iJSKTrV0hHDSfe5gLmhhy7ar+KXvxiaBONKF67k/2Kj9blFw5\nJntB4gClMkFyZBSx63d6EQIDAQABo4GMMIGJMB0GA1UdDgQWBBSCS/dy7loh9x7N\n8mOacJ+kW/9q4jBaBgNVHSMEUzBRgBSCS/dy7loh9x7N8mOacJ+kW/9q4qEupCww\nKjEoMCYGA1UEAxMfbm9ydGh3ZXN0ZXJuLmFyZXMuYXRsYXMtc3lzLmNvbYIJAOY7\n4ZY0rkL2MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAE+n0D46FBWh\n5JBvxAdURmrnW3/px4Lz7apfd+X0+DnJj5XLXJa6AwutUfo/fyTLtnW8NryDcq9m\nOTvuP1eRfaV942wdn+y0+vK9MuKhvdLeLp6lgB8AjL7qf/URcfaALz06XCFji4o8\ns74WGSUr3kdRpE+q2DWRB9sofhZr3qJ0PvNJvJhFOVyKWDY/mbvwRrw6R593bQly\n+Wlyjf1NCDtBpp8X4C7sfTMsgV5hUP9DV646tnnXMswF3jb/TOcyS+Mv8KqgCL8u\nONAz7wodoY9Wx0gbc+l3JAG0uR9qPSHylck0zU+P++1xmdN0rQcA/HtwTRH7qYeX\neyJBVb37hCQ=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://northwestern.ares.atlas-sys.com/ares/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://northwestern.ares.atlas-sys.com/ares/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://moodle.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brian McFarlane", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "samspade@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://comanage.psu.edu/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Pennsylvania State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Penn State", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.psu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Chris Hubing", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cjh@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Phil Devan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pmd@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Rich Cropp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rac@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://cms.psu.edu/Shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Pennsylvania State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Penn State", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.psu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Andy Fisher", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "anf107@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Terry O'Heron", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tno1@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "urn:mace:incommon:iu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Indiana University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Indiana University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.indiana.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Alan Walsh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "alwalsh@indiana.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rahul Doshi", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rdoshi@indiana.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth-uci.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:apple.com": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.apple.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Yuemin Yu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itunesu-shib@group.apple.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://eauthext.dev.nsf.gov:443": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "National Science Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "National Science Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.nsf.gov/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "David Lotts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dlotts@nsf.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Bill Altmire", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "waltmire@nsf.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Research.gov Help desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rgov@nsf.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://xerxes.calstate.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Office of the Chancellor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Office of the Chancellor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.calstate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Marcus Mizushima", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "iamadmin@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "David Walker", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dwalker@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://xerxes.calstate.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIC5TCCAc2gAwIBAgIJALUCoyiCZtLcMA0GCSqGSIb3DQEBBQUAMBUxEzARBgNV\nBAMTCmNvd2V3eGVzMDEwHhcNMDkxMjIxMTYxNDE4WhcNMTkxMjE5MTYxNDE4WjAV\nMRMwEQYDVQQDEwpjb3dld3hlczAxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAqwUGOnQ0lSUABWetC3JDXX/m9cwqomB4ZYWMCHL3R3CNnYkZZUXz5WR1\n5/hfR5mN+uEEpGNhw+4c6wsH5XwoNjamUzWcAPfLTvoGjIpiWc6+xsMThQ0aF8rw\nqjsLauKLEfXRM5z69Zkp4GekDYlcA3n523wUPyOpjr0xPR97Js869rSQVtDgRFZh\n4ZFBYYioqfFTBKI7MeB7qAjbcvOZwQ3+euWC2pRVxrFuaJbsTuKZl4ofXtx8h5ns\nVDH46KYzLXYVsZiSeNUJrwAr+IqyIhdC7iy/BPPgiU0gC0XsuqM2bHc5WNKDGYWM\nYU/zNSuJNR4/I2pVH6kZEelbFfLf7wIDAQABozgwNjAVBgNVHREEDjAMggpjb3dl\nd3hlczAxMB0GA1UdDgQWBBQGVeMJjX3fYAPmmbCX/k08u2OuczANBgkqhkiG9w0B\nAQUFAAOCAQEAd7iRjBb+WgL/quVQ8NXE/hDpNVLupihsvcl9lDwrlnB604+W8T4u\n7Kz4wDVK4KXWX6rIjvpweFhXYdksqhhnejuiG+vnxmtCZ5vrzZ5EeBsqNo4nX3Fz\nSVU+KGSYBOdlAnV6CcAQBbFABVyJtdFUNPopX1gRWehFsGJmLzHqrp5WLQzqjjDF\nfBXnobzEPfpzI/TqFDR49Z31nDovLWtN13vOLhLdWg+krTpeq38tB+RuNsq3SlQi\nLHQsaukyQGqFha3EDN0AHc8R4QfJ3doitN4DLAgI8IFcQKvkIDFBVMmS02v58JFK\n5AX5HRLbOCTI3UMvrGzzpTqYGgNOdgz+Ng==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://xerxes.calstate.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://xerxes.calstate.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://xerxes.calstate.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://xerxes.calstate.edu/Shibboleth.sso/SAML2/ECP"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-mba-olin-csm.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ermsp.ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Munish Malik", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "aig@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "UCOP DataCenter HelpDesk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ucopdatacenter.helpdesk@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://ucready-dev.berkeley.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Berkeley", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.berkeley.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Adam Cohen", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "adamcohen@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://vegitron.eplt.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Patrick Michaud", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pmichaud@washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth.uams.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIF6DCCA9ACAQEwDQYJKoZIhvcNAQEFBQAwgbkxCzAJBgNVBAYTAlVTMREwDwYD\nVQQIEwhBcmthbnNhczEUMBIGA1UEBxMLTGl0dGxlIFJvY2sxNDAyBgNVBAoTK1Vu\naXZlcnNpdHkgb2YgQXJrYW5zYXMgZm9yIE1lZGljYWwgU2NpZW5jZXMxCzAJBgNV\nBAsTAklUMRwwGgYDVQQDExNzaGliYm9sZXRoLnVhbXMuZWR1MSAwHgYJKoZIhvcN\nAQkBFhFrYXBvd2VsbEB1YW1zLmVkdTAeFw0xMDAxMjEyMDIwMTlaFw0yMDAxMTky\nMDIwMTlaMIG5MQswCQYDVQQGEwJVUzERMA8GA1UECBMIQXJrYW5zYXMxFDASBgNV\nBAcTC0xpdHRsZSBSb2NrMTQwMgYDVQQKEytVbml2ZXJzaXR5IG9mIEFya2Fuc2Fz\nIGZvciBNZWRpY2FsIFNjaWVuY2VzMQswCQYDVQQLEwJJVDEcMBoGA1UEAxMTc2hp\nYmJvbGV0aC51YW1zLmVkdTEgMB4GCSqGSIb3DQEJARYRa2Fwb3dlbGxAdWFtcy5l\nZHUwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQD5Hc8JIuSngcQzhmkZ\nhjJy5R1d/7zlBNEHuBrHw21UE1y7lpVAJUAk1wDj4twxLjrkzTuWcClvr+8DU+ov\nKvd8as3UmxcLtUdzpgDPGNggLyyNn5kdJP0Ds0eQ7RzIVMOq4tU87eL0TjIFY6Kg\n4898Now4GKkcb+D13d+a3mXWSUAi1HfnUtKoAwZIj1awc/P7C5lO+sq+rgB4+EAl\nTcjB+vS1puUbk+eKBLWfp4iQfwpmRVtTRhQT/fDxvvebbW/in2GoRUDLHsgkxLLk\ncIVPw965w3bek93EOj/nJeZ8FtGgByQhIONOyXWgLgIzSb6q+r0aO7cGYOeTD2fd\nckJxFIu6lrk25pdWE7heUCwmFiOpG5i4Dn/Zyfbk5Mf2rrEOimzNLQGMXoXrSo2x\nw8Md5hQTa2hgkEhOAqYCYVeZEkpPJkj9yeYvnYF1pOvzRvUVbje93SV9Mp1Umt4A\nkmGR7PWBYnRO+ibspy5KTt2wZvwm8Nnz9FMa4KY93/HdS55OYPzUZ0U6J1Qb66Co\njjD0/7DAKNWyP2rDxor1HAP94tYwkkM5N/nmGh7rp5/ky0UYN46dVruLozO6CvC0\nHL4Jv3oAByDM3mA9zEWUFnPLGSel87N6Bghp7y+NSbop6QxDThgKJom3BZdoFrRd\nIVpTEW1a4Bkx0n4/HN+wVSuaiQIDAQABMA0GCSqGSIb3DQEBBQUAA4ICAQAVSKZp\nWRiiI/GMwP8J1qLpPYps9GAg8K3SSamNTZjFb4Bx1U9BX2oVfhFzWUHlkEZ4I9Kn\npHy1DoajsUMXGihIAW7nE4QB7Scg0/j72qWD8RTYJf45LOMmYjwaFzh6nx8ZW8nr\njQFlZ3FZqrdxRlc09QGj+/1EAB8zsl1TwY5LLHKXmxrrzxgcjlEJQj5W1QsxY+cp\nqR7U2FTIUHWPYIuk32j+4D0cADEgSPRoWQvhQ4yv6ObXnnysmQyL80vMy4qWRkQW\nEZzValhP7+c1HlX/3ZFE5oyfa4MIArxQ2cD6wCxhGLauMOCAGkWw2OBSTsNrAQ9k\nZ5w7ZkB+dkZjTLbMpXEBEjInQraA6daFGpHn0XZWt0yUrPv8yuwrPZPEhCulnCwz\njPT8ic+thGwdiyXVouxToFoDS+IHHhQXkH4tNTZSVK8g8do5V5mxSJLq2QiySAKj\n8HCKUSg+5YT9hghvD/DZg7AIG7x15WB7tguybmEZ0ZQTMbXfxW8++ennnMv0YB08\n0TcaZVLkzfGqpa7LViMTg+DMOxrbxDPyWwmJYIp1wctIwD/0Mt1GLO24SCpsL0Xi\n/oQmUfmngWJ89KOYIv/FBO1yVwq3LUuwc1bDS+6zYsmOTIdNTjl+HGmq07Nu5IEV\n5CGF3Xf3OCIcIPuFxeF6aJA+h9o82twJq3mwpw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth.uams.edu/idp/profile/SAML2/POST/SSO"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Keith A. Powell", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kapowell@uams.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Greg A. Freeman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gfreeman@uams.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Steve W. Cochran", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "CochranStephenW@uams.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.uams.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.uams.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIF6DCCA9ACAQEwDQYJKoZIhvcNAQEFBQAwgbkxCzAJBgNVBAYTAlVTMREwDwYD\nVQQIEwhBcmthbnNhczEUMBIGA1UEBxMLTGl0dGxlIFJvY2sxNDAyBgNVBAoTK1Vu\naXZlcnNpdHkgb2YgQXJrYW5zYXMgZm9yIE1lZGljYWwgU2NpZW5jZXMxCzAJBgNV\nBAsTAklUMRwwGgYDVQQDExNzaGliYm9sZXRoLnVhbXMuZWR1MSAwHgYJKoZIhvcN\nAQkBFhFrYXBvd2VsbEB1YW1zLmVkdTAeFw0xMDAxMjEyMDIwMTlaFw0yMDAxMTky\nMDIwMTlaMIG5MQswCQYDVQQGEwJVUzERMA8GA1UECBMIQXJrYW5zYXMxFDASBgNV\nBAcTC0xpdHRsZSBSb2NrMTQwMgYDVQQKEytVbml2ZXJzaXR5IG9mIEFya2Fuc2Fz\nIGZvciBNZWRpY2FsIFNjaWVuY2VzMQswCQYDVQQLEwJJVDEcMBoGA1UEAxMTc2hp\nYmJvbGV0aC51YW1zLmVkdTEgMB4GCSqGSIb3DQEJARYRa2Fwb3dlbGxAdWFtcy5l\nZHUwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQD5Hc8JIuSngcQzhmkZ\nhjJy5R1d/7zlBNEHuBrHw21UE1y7lpVAJUAk1wDj4twxLjrkzTuWcClvr+8DU+ov\nKvd8as3UmxcLtUdzpgDPGNggLyyNn5kdJP0Ds0eQ7RzIVMOq4tU87eL0TjIFY6Kg\n4898Now4GKkcb+D13d+a3mXWSUAi1HfnUtKoAwZIj1awc/P7C5lO+sq+rgB4+EAl\nTcjB+vS1puUbk+eKBLWfp4iQfwpmRVtTRhQT/fDxvvebbW/in2GoRUDLHsgkxLLk\ncIVPw965w3bek93EOj/nJeZ8FtGgByQhIONOyXWgLgIzSb6q+r0aO7cGYOeTD2fd\nckJxFIu6lrk25pdWE7heUCwmFiOpG5i4Dn/Zyfbk5Mf2rrEOimzNLQGMXoXrSo2x\nw8Md5hQTa2hgkEhOAqYCYVeZEkpPJkj9yeYvnYF1pOvzRvUVbje93SV9Mp1Umt4A\nkmGR7PWBYnRO+ibspy5KTt2wZvwm8Nnz9FMa4KY93/HdS55OYPzUZ0U6J1Qb66Co\njjD0/7DAKNWyP2rDxor1HAP94tYwkkM5N/nmGh7rp5/ky0UYN46dVruLozO6CvC0\nHL4Jv3oAByDM3mA9zEWUFnPLGSel87N6Bghp7y+NSbop6QxDThgKJom3BZdoFrRd\nIVpTEW1a4Bkx0n4/HN+wVSuaiQIDAQABMA0GCSqGSIb3DQEBBQUAA4ICAQAVSKZp\nWRiiI/GMwP8J1qLpPYps9GAg8K3SSamNTZjFb4Bx1U9BX2oVfhFzWUHlkEZ4I9Kn\npHy1DoajsUMXGihIAW7nE4QB7Scg0/j72qWD8RTYJf45LOMmYjwaFzh6nx8ZW8nr\njQFlZ3FZqrdxRlc09QGj+/1EAB8zsl1TwY5LLHKXmxrrzxgcjlEJQj5W1QsxY+cp\nqR7U2FTIUHWPYIuk32j+4D0cADEgSPRoWQvhQ4yv6ObXnnysmQyL80vMy4qWRkQW\nEZzValhP7+c1HlX/3ZFE5oyfa4MIArxQ2cD6wCxhGLauMOCAGkWw2OBSTsNrAQ9k\nZ5w7ZkB+dkZjTLbMpXEBEjInQraA6daFGpHn0XZWt0yUrPv8yuwrPZPEhCulnCwz\njPT8ic+thGwdiyXVouxToFoDS+IHHhQXkH4tNTZSVK8g8do5V5mxSJLq2QiySAKj\n8HCKUSg+5YT9hghvD/DZg7AIG7x15WB7tguybmEZ0ZQTMbXfxW8++ennnMv0YB08\n0TcaZVLkzfGqpa7LViMTg+DMOxrbxDPyWwmJYIp1wctIwD/0Mt1GLO24SCpsL0Xi\n/oQmUfmngWJ89KOYIv/FBO1yVwq3LUuwc1bDS+6zYsmOTIdNTjl+HGmq07Nu5IEV\n5CGF3Xf3OCIcIPuFxeF6aJA+h9o82twJq3mwpw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.uams.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Arkansas for Medical Sciences", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Arkansas for Medical Sciences", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uams.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:odu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFnTCCBIWgAwIBAgICARwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDMxOTE5MDYxNFoXDTEwMDMy\nMDE5MDYxNFowHTEbMBkGA1UEAxMSc2hpYmJvbGV0aC5vZHUuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA+BwDkdKLPDpcF/Sl8c+N8R2s7HG0Yotu\nuuJonzoaVhaLITbHQ9dxbF4y9dUJRFTb9KXzuRB9HI1Gc1AugFquLN09gSsUH/80\nEBx3V2PA3yh9oj8jT+VPeR52Y+x2JvTlTXCJE85gto+6M3jc/jxLKu0sBa/hPMEi\n2Lf6eN8wMiykcAjFQy45eD6W3UbhWIdFdIJzBOHbc5Lw2QFL7eh+J1eW49hDAxg1\nNp0rwk7TafXskBN2AQ6xpd/+NNsVSdUIGL79ys4UMyIFRh4bkpPxTh7K3NenqQ4z\nrlLEReIy4Gwv/xP9MsBIT5zTFpP7m80JRylQD7AY1r4ltOI9UaYfpwIDAQABo4IC\nrDCCAqgwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYI\nKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSQLfgOPlsbjl3bNhl+3y5b6eHo\noTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UE\nBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIElu\nQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIG6BggrBgEFBQcBAQSB\nrTCBqjCBpwYIKwYBBQUHMAKGgZpodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiCgkJQ0EgSXNz\ndWVycyAtIFVSSTpodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9\noDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9j\ncmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYB\nBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMB0GA1UdEQQWMBSCEnNoaWJi\nb2xldGgub2R1LmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAGI507zxebncyRIHehRR0\nNW53bXZ7AzWeDX9N7l10aUTPiQcLr1wsLcTfveDiWAAMUEtOwsM6jGucAg6x/lCS\n48aQfXx/9IA5CYV+ZPUlVgKNI3mnmD62+TyX77m6gqR2HRaElHpDvBrppM7MIHGF\ngp1K20EM9EgJWN+kcjaq3VfoYUNZgZFHyK3xTpKVEOMXZx5hq0Cd0YsoEZ1cS5BY\nI0d49jJnMYqCJAkwR8FZ6cPjn7fAZnCvvgs/2bkIpavKa4wSG6WwlQQCJkOy+wzW\nTpO/yauENUQhA4Uk57B0g3c8WrCS8gNTHDli9Hv4cWjp5jRQXrZJJTOPOR0l3L8T\n3w==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }, 
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIE0zCCA7ugAwIBAgIJAMn+w6uDKAKBMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMIVmlyZ2luaWExEDAOBgNVBAcTB05vcmZvbGsxIDAe\nBgNVBAoTF09sZCBEb21pbmlvbiBVbml2ZXJzaXR5MQ0wCwYDVQQLEwRPQ0NTMRsw\nGQYDVQQDExJzaGliYm9sZXRoLm9kdS5lZHUxHzAdBgkqhkiG9w0BCQEWEHRkZXJn\nZW5zQG9kdS5lZHUwHhcNMTAwMTAxMjE1MDM4WhcNMTMwMTMwMjE1MDM4WjCBoTEL\nMAkGA1UEBhMCVVMxETAPBgNVBAgTCFZpcmdpbmlhMRAwDgYDVQQHEwdOb3Jmb2xr\nMSAwHgYDVQQKExdPbGQgRG9taW5pb24gVW5pdmVyc2l0eTENMAsGA1UECxMET0ND\nUzEbMBkGA1UEAxMSc2hpYmJvbGV0aC5vZHUuZWR1MR8wHQYJKoZIhvcNAQkBFhB0\nZGVyZ2Vuc0BvZHUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nlBO4vpFW9ikY90LlmdDGqdRXU4YVSEMQQKUvXBVb6NZpsN5FassFhtqE83WckPF8\nviFjZDOfKdTsJ2oWp5DsjH36kqEoLgS2JoUdVD3MjZ5GxZ5r2ZfBccWXL/kmu4Wv\nByeHj+Fa8ehwagmZ4CXC5Oxd+WYsz4dd5t6lD0PO7Od4RS0sysDCIDC/KTso8p7p\nDDG/vpPbzuwfkxdM8FG3w+3aShgj2N4rnhorrnDkPFzJ4MHrjo0rq359TI8gt8Vx\nI/SW4qN2s2v9O6TDS0YF/qIWU/mIk7/z2F+hF9sC7VD4FC3WqFu3nFm7rTu7tCi0\nIXbC4hX9+xIl6EvhOfapUwIDAQABo4IBCjCCAQYwHQYDVR0OBBYEFIreB34Ia3x6\nl/xVA9jXPGWly38cMIHWBgNVHSMEgc4wgcuAFIreB34Ia3x6l/xVA9jXPGWly38c\noYGnpIGkMIGhMQswCQYDVQQGEwJVUzERMA8GA1UECBMIVmlyZ2luaWExEDAOBgNV\nBAcTB05vcmZvbGsxIDAeBgNVBAoTF09sZCBEb21pbmlvbiBVbml2ZXJzaXR5MQ0w\nCwYDVQQLEwRPQ0NTMRswGQYDVQQDExJzaGliYm9sZXRoLm9kdS5lZHUxHzAdBgkq\nhkiG9w0BCQEWEHRkZXJnZW5zQG9kdS5lZHWCCQDJ/sOrgygCgTAMBgNVHRMEBTAD\nAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQBwmJQ0x1E2tEw5INt+Oo0ZbNExxloPDtGX\nF494Kah7sK1JfbwYjvQt+Mr21IoBon6DhAxUgUMioErjNlx/O61YfvvrxM0beOqe\nRcbiehzolNXZoDc/BpOIyg2Mnts0Oq1W1iqdboG8o/C1hO6QDkDEqs54wzW3IwiB\n6he6+IMkfZU21LFQrtXY97M3MWzazAZSZuiEz/o/xCRC1KAkgETKqPLUj61YiLWK\nRsTSoA0uK8ON9te+ae9yVj8t2PWaPkYgjnP4p5yWEYhEogrSdDr75ncNoD7H9YEl\nj3zAHdA4Cb/2GuXsNgP1vuj5oSKruQenypnVtxFix/Ad2fxsAgyB", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth.odu.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Todd Dergenski", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tdergens@odu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Technical Support Center", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "occshelp@odu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Todd Dergenski", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tdergens@odu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "http://shibboleth.odu.edu/error.html", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.odu.edu/idp/profile/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.odu.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.odu.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.odu.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFnTCCBIWgAwIBAgICARwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDMxOTE5MDYxNFoXDTEwMDMy\nMDE5MDYxNFowHTEbMBkGA1UEAxMSc2hpYmJvbGV0aC5vZHUuZWR1MIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA+BwDkdKLPDpcF/Sl8c+N8R2s7HG0Yotu\nuuJonzoaVhaLITbHQ9dxbF4y9dUJRFTb9KXzuRB9HI1Gc1AugFquLN09gSsUH/80\nEBx3V2PA3yh9oj8jT+VPeR52Y+x2JvTlTXCJE85gto+6M3jc/jxLKu0sBa/hPMEi\n2Lf6eN8wMiykcAjFQy45eD6W3UbhWIdFdIJzBOHbc5Lw2QFL7eh+J1eW49hDAxg1\nNp0rwk7TafXskBN2AQ6xpd/+NNsVSdUIGL79ys4UMyIFRh4bkpPxTh7K3NenqQ4z\nrlLEReIy4Gwv/xP9MsBIT5zTFpP7m80JRylQD7AY1r4ltOI9UaYfpwIDAQABo4IC\nrDCCAqgwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYI\nKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSQLfgOPlsbjl3bNhl+3y5b6eHo\noTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UE\nBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIElu\nQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIG6BggrBgEFBQcBAQSB\nrTCBqjCBpwYIKwYBBQUHMAKGgZpodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiCgkJQ0EgSXNz\ndWVycyAtIFVSSTpodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9\noDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9j\ncmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYB\nBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMB0GA1UdEQQWMBSCEnNoaWJi\nb2xldGgub2R1LmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAGI507zxebncyRIHehRR0\nNW53bXZ7AzWeDX9N7l10aUTPiQcLr1wsLcTfveDiWAAMUEtOwsM6jGucAg6x/lCS\n48aQfXx/9IA5CYV+ZPUlVgKNI3mnmD62+TyX77m6gqR2HRaElHpDvBrppM7MIHGF\ngp1K20EM9EgJWN+kcjaq3VfoYUNZgZFHyK3xTpKVEOMXZx5hq0Cd0YsoEZ1cS5BY\nI0d49jJnMYqCJAkwR8FZ6cPjn7fAZnCvvgs/2bkIpavKa4wSG6WwlQQCJkOy+wzW\nTpO/yauENUQhA4Uk57B0g3c8WrCS8gNTHDli9Hv4cWjp5jRQXrZJJTOPOR0l3L8T\n3w==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }, 
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIE0zCCA7ugAwIBAgIJAMn+w6uDKAKBMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMIVmlyZ2luaWExEDAOBgNVBAcTB05vcmZvbGsxIDAe\nBgNVBAoTF09sZCBEb21pbmlvbiBVbml2ZXJzaXR5MQ0wCwYDVQQLEwRPQ0NTMRsw\nGQYDVQQDExJzaGliYm9sZXRoLm9kdS5lZHUxHzAdBgkqhkiG9w0BCQEWEHRkZXJn\nZW5zQG9kdS5lZHUwHhcNMTAwMTAxMjE1MDM4WhcNMTMwMTMwMjE1MDM4WjCBoTEL\nMAkGA1UEBhMCVVMxETAPBgNVBAgTCFZpcmdpbmlhMRAwDgYDVQQHEwdOb3Jmb2xr\nMSAwHgYDVQQKExdPbGQgRG9taW5pb24gVW5pdmVyc2l0eTENMAsGA1UECxMET0ND\nUzEbMBkGA1UEAxMSc2hpYmJvbGV0aC5vZHUuZWR1MR8wHQYJKoZIhvcNAQkBFhB0\nZGVyZ2Vuc0BvZHUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nlBO4vpFW9ikY90LlmdDGqdRXU4YVSEMQQKUvXBVb6NZpsN5FassFhtqE83WckPF8\nviFjZDOfKdTsJ2oWp5DsjH36kqEoLgS2JoUdVD3MjZ5GxZ5r2ZfBccWXL/kmu4Wv\nByeHj+Fa8ehwagmZ4CXC5Oxd+WYsz4dd5t6lD0PO7Od4RS0sysDCIDC/KTso8p7p\nDDG/vpPbzuwfkxdM8FG3w+3aShgj2N4rnhorrnDkPFzJ4MHrjo0rq359TI8gt8Vx\nI/SW4qN2s2v9O6TDS0YF/qIWU/mIk7/z2F+hF9sC7VD4FC3WqFu3nFm7rTu7tCi0\nIXbC4hX9+xIl6EvhOfapUwIDAQABo4IBCjCCAQYwHQYDVR0OBBYEFIreB34Ia3x6\nl/xVA9jXPGWly38cMIHWBgNVHSMEgc4wgcuAFIreB34Ia3x6l/xVA9jXPGWly38c\noYGnpIGkMIGhMQswCQYDVQQGEwJVUzERMA8GA1UECBMIVmlyZ2luaWExEDAOBgNV\nBAcTB05vcmZvbGsxIDAeBgNVBAoTF09sZCBEb21pbmlvbiBVbml2ZXJzaXR5MQ0w\nCwYDVQQLEwRPQ0NTMRswGQYDVQQDExJzaGliYm9sZXRoLm9kdS5lZHUxHzAdBgkq\nhkiG9w0BCQEWEHRkZXJnZW5zQG9kdS5lZHWCCQDJ/sOrgygCgTAMBgNVHRMEBTAD\nAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQBwmJQ0x1E2tEw5INt+Oo0ZbNExxloPDtGX\nF494Kah7sK1JfbwYjvQt+Mr21IoBon6DhAxUgUMioErjNlx/O61YfvvrxM0beOqe\nRcbiehzolNXZoDc/BpOIyg2Mnts0Oq1W1iqdboG8o/C1hO6QDkDEqs54wzW3IwiB\n6he6+IMkfZU21LFQrtXY97M3MWzazAZSZuiEz/o/xCRC1KAkgETKqPLUj61YiLWK\nRsTSoA0uK8ON9te+ae9yVj8t2PWaPkYgjnP4p5yWEYhEogrSdDr75ncNoD7H9YEl\nj3zAHdA4Cb/2GuXsNgP1vuj5oSKruQenypnVtxFix/Ad2fxsAgyB", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.odu.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.odu.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Old Dominion University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Old Dominion University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://web.odu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://streamer.ohiolink.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDyjCCArICCQCA4T/cGsXztTANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYDVQQKEwhP\naGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlvbjEeMBwG\nA1UEAxMVc3RyZWFtZXIub2hpb2xpbmsuZWR1MR4wHAYJKoZIhvcNAQkBFg9lc2hp\nY2tzQG9hci5uZXQwHhcNMTAwMjAxMTUxMDU4WhcNMTMwMTMxMTUxMDU4WjCBpjEL\nMAkGA1UEBhMCVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREw\nDwYDVQQKEwhPaGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNh\ndGlvbjEeMBwGA1UEAxMVc3RyZWFtZXIub2hpb2xpbmsuZWR1MR4wHAYJKoZIhvcN\nAQkBFg9lc2hpY2tzQG9hci5uZXQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQCdfu8O/DkjvHV8p1PeE33FWgWcfjU+JqehHX3voGk2GjN1gTPxxtmPVapl\nOZHN4Bb+0WSDWuln7nH6BOfxinWqRtww09XrfQEQJLQ/gn5bWs9vfzmohUz12hTW\ndKH6x3T7+ub37/1a93p0gU+Q1MbJj9BzCSZBhi7K0QEbHNHiP1v+NzmDRCI3BNEM\nFtVtN+MouZr8ie1gJhwRzUJo+y6YsjErBoN6wBFYPgnwSVYhAR83n/NDyrXjiirY\n6SfNCu4LqE0yoCFvDIZFimbLa3ctZl+I7ffvg9IVomxc+7uX2qY9jkVUfhBnGPwu\njtxpWPSq0aiqiww0AfPKQ2nzbC4RAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAHY5\nGQx/UPZ3Z/8t4O6sP6ZHSQpYZECtJpjp1SlyAGeBv0V+a1e6+NoFel3amvv4zJcY\nlj9wiH53KNgi+cGAEUo3cKDpw19SoVlJOH5I5rqS5FHlni/3M3J+pa3RaAzHuOg0\n//Zs2MTFT/TA5f1bHpFQJgLB0AeONBCSSz4K7UX0P+8OQVLgSFbh2+XTBiOvtz6S\n2mI8iLMTbq/zTaPL8Rg5b0JcpsA0NJ6UQHRCq+Pdw/xci7DNsttbFIRC1NGOuVYr\nGGed+6ekyQUBDXCbVzoZljCZW8BPgGbGUmzbEQyj9CAbx955G6Bh6pQIKwvWIzZR\nxB+X/eX4tWYNSU6eJR0=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://streamer.ohiolink.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://streamer.ohiolink.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://streamer.ohiolink.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://streamer.ohiolink.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://streamer.ohiolink.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://streamer.ohiolink.edu/Shibboleth.sso/SAML2/ECP"
          }
        ]
      }
    ]
  }, 
  "https://nbo.universitytickets.com/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "UniversityTickets", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "UniversityTickets", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://universitytickets.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Gordon Capreol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gcapreol@universitytickets.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "UniversityTickets Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@universitytickets.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://sseweb3q.ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Munish Malik", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Munish.Malik@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "AIG", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "aig@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFLTCCBBWgAwIBAgICAOUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA3MTEyMDIxMDgzMFoXDTA4MTEx\nOTIxMDgzMFowNTELMAkGA1UEBhMCVVMxDTALBgNVBAoTBFVDT1AxFzAVBgNVBAMT\nDnNzZXFhLnVjb3AuZWR1MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCXVevc\nN7IYhaIDSe8MHjf7vNHH9TPIiekRnLwbMU3psFIKeMb4uA3ifFXfh9/qfvtCcwn5\nNDC61neFVvLkU6uvbmsTvCyEfBkoabAxrQ54e0Z6QaL8ugXz+3Pw9k70+8Y8zp9S\n4+3SvfaUPGiVsTw3dcl8Ch9iPa8Tpdxp47AfBwIDAQABo4ICqDCCAqQwDgYDVR0P\nAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsG\nAQUFBwMCMB0GA1UdDgQWBBTrVmTQ0pYfMqTet0mKgYZEUk+J4TB+BgNVHSMEdzB1\ngBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNV\nBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRp\nZmljYXRpb24gQXV0aG9yaXR5ggEAMIG6BggrBgEFBQcBAQSBrTCBqjCBpwYIKwYB\nBQUHMAKGgZpodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiCgkJQ0EgSXNzdWVycyAtIFVSSTpo\ndHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2Uv\nY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9p\nbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNy\nbDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBC\nBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9wcmFjdGljZXMucGRmMBkGA1UdEQQSMBCCDnNzZXFhLnVjb3AuZWR1MA0G\nCSqGSIb3DQEBBQUAA4IBAQCFhqkFmF5EXpuZ7d9vQHVTB7HO6EXIYFcbYUespDRS\nH/6YV2K+Hr86NdPcScaVDHPYXvSEP5bFuG3mWMJYrOErMdFdXTZirAQA4mPB6aBq\nJaPKhu9Csjvo+ivmURG/UhIpFfh4fn8C7E6EyZ8XlBOftjhQs8cQqHYpfHAbVLUZ\nsqD0SCkaZG9ro0IFmnldTDG5xzddSn/vlYjAoxpyb5rbbbq6QNzjyfJeFa3mp8+n\ntqsM7pxVvId8Dh5hRkTzzmdHw1o1HpiVmrNCiJq2tY1bGqeeqC8FFJyvDMZuOaTu\npsG/l8Pu3seGi4HTZzh2dAgguq27VZnzzYVkTuhlsC14", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://sseweb3q.ucop.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:ucmerced.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Merced", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Merced", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucmerced.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Greg Fellin", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gfellin@ucmerced.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Brian Koehmstedt", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bkoehmstedt@ucmerced.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Faust Gorham", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "fgorham@ucmerced.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://shibboleth.uic.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Chicago", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Chicago", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uic.edu/index.html/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Robert Goldstein", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bobg@uic.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Roberto Ullfig", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rullfig@uic.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "James O'Leary", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "joleary@uic.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://login.wustl.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFCzCCA/OgAwIBAgICAlQwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxNTE3NTUyN1oXDTExMDcx\nNjE3NTUyN1owGjEYMBYGA1UEAxMPbG9naW4ud3VzdGwuZWR1MIGfMA0GCSqGSIb3\nDQEBAQUAA4GNADCBiQKBgQDjy1V+HXMkpn6Hizx/VxEDiD5IBK5JWuLg7wDN/AQ0\nGF0KAmSY7wWFKGltr8ONDk2/1XwywHHDHzAg62s9+kNiG4igLv9b/+3SsizNyjr5\nYkYzPzm4LUVjAGuidJFhLMJqpGk+jUX7jQtUxYcJtpposqWCd7FYiUj4HDz9XAQf\nkQIDAQABo4ICoTCCAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBTND5OUnZuc/ulj\nKtvjdSOt8z71tDB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgw\nVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAn\nBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggr\nBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+g\nPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysG\nAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9sb2dp\nbi53dXN0bC5lZHUwDQYJKoZIhvcNAQEFBQADggEBAIDqxNd131FYYJpg01x5pRkx\njawEs9wGCHX5Oh55DyjVdcjnTmqTlzXFR/EGiRUH6H4AwhjEa0fpFUwYQ7fcwT4E\n8ZLLAILymq1CZ3/L6x4HjTSbvBHIzgvQMrKhYUfKx1SVJz1YwjzXYZnRiBj+zkDA\nV5tcc57czvz2o7xqaDxZFLK3AsxTDInTFmgnoT07PbEW2CFsaQ5Xp5Pj9H963HJa\n7WrdMDtiyHUAzlaqQ2Z91fSd5jQEMGz5XWbU4HDPTAH7k0pU+nHrTTnMcWeBCDei\nk8P3qY4Tw/Uw14wL+RwQGNE4R8FtgwGF8P/Q5wTAi5q/P3k3DqGxw8pMbW4S3Bk=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://login.wustl.edu/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://connect.wustl.edu/selfservice/", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.wustl.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.wustl.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFCzCCA/OgAwIBAgICAlQwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxNTE3NTUyN1oXDTExMDcx\nNjE3NTUyN1owGjEYMBYGA1UEAxMPbG9naW4ud3VzdGwuZWR1MIGfMA0GCSqGSIb3\nDQEBAQUAA4GNADCBiQKBgQDjy1V+HXMkpn6Hizx/VxEDiD5IBK5JWuLg7wDN/AQ0\nGF0KAmSY7wWFKGltr8ONDk2/1XwywHHDHzAg62s9+kNiG4igLv9b/+3SsizNyjr5\nYkYzPzm4LUVjAGuidJFhLMJqpGk+jUX7jQtUxYcJtpposqWCd7FYiUj4HDz9XAQf\nkQIDAQABo4ICoTCCAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBTND5OUnZuc/ulj\nKtvjdSOt8z71tDB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgw\nVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAn\nBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggr\nBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+g\nPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysG\nAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9sb2dp\nbi53dXN0bC5lZHUwDQYJKoZIhvcNAQEFBQADggEBAIDqxNd131FYYJpg01x5pRkx\njawEs9wGCHX5Oh55DyjVdcjnTmqTlzXFR/EGiRUH6H4AwhjEa0fpFUwYQ7fcwT4E\n8ZLLAILymq1CZ3/L6x4HjTSbvBHIzgvQMrKhYUfKx1SVJz1YwjzXYZnRiBj+zkDA\nV5tcc57czvz2o7xqaDxZFLK3AsxTDInTFmgnoT07PbEW2CFsaQ5Xp5Pj9H963HJa\n7WrdMDtiyHUAzlaqQ2Z91fSd5jQEMGz5XWbU4HDPTAH7k0pU+nHrTTnMcWeBCDei\nk8P3qY4Tw/Uw14wL+RwQGNE4R8FtgwGF8P/Q5wTAi5q/P3k3DqGxw8pMbW4S3Bk=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://login.wustl.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://login.wustl.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://idp.caltech.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDJzCCAg+gAwIBAgIUC0Z5A7Hz0aGgHdvfgWBw/TW939IwDQYJKoZIhvcNAQEF\nBQAwGjEYMBYGA1UEAxMPaWRwLmNhbHRlY2guZWR1MB4XDTEwMDIwNDAwMzgxNFoX\nDTMwMDIwNDAwMzgxNFowGjEYMBYGA1UEAxMPaWRwLmNhbHRlY2guZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjUfvISEj5BkXO8k4dKr7C1NdlDIs\nosNxbjP39/8oVwgGaMSnkfMhY6xct9gnxTzCRXe49MU+UyVRlljTqTeIJf8VG0K2\naPSRk9xpzWje/fEkUHgpOjLDM0TNB2tWIQbHQwHz7HsuB/Au870PBMv4EfVz4us8\nyTmYvY2ZJPe192BnIbNyLub138HXjr7TrLBxMg7KulnanGnN75UrVjueRzAvFZlE\nlAZ+shDsjVYAoceEaFn7TF37ehVdjbXwOegtu+vU0kjjCS3cQUXXOs1Ojz6Vood/\noP1SOisW3bEhboKMUCWEcDckUXHVd/qCekbUsJEt5KAK6Gmf5Ygha748kQIDAQAB\no2UwYzBCBgNVHREEOzA5gg9pZHAuY2FsdGVjaC5lZHWGJmh0dHBzOi8vaWRwLmNh\nbHRlY2guZWR1L2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBRlqKQBRnVFASGfdigd\na/ihuq365zANBgkqhkiG9w0BAQUFAAOCAQEAck8P9JfpOWTpgc4LCyaY3WiJFIGe\nWT25D+6Gj7ADxj7+o2UZCcB2sI5LvyFJaetQSB/7p0F+hmU8/csunwoWARnbOcJt\nSmbyiJQ6eKUXOklOEqxEpGZRa2MbRwukfVx+v6U3N75JxoyuNfqC/G3tKzOIo4qz\nuxiE+1ntesuGTmWuLx9dIKILJ6XuD/rmGSkeKWljLC1jNQEjHioskqIFhcF1JxDv\nqnn8IBfnaoc4GX6AV3fEHifdQEOu7GdicUeA8o+cKqddCZf1PoUTSPby1NcFeDO6\nPPYq4pWYGD1Sc8SOXB+99YOD8hJObGIcskF0VRwv1Kg7rrTBqPLic7kcRA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.caltech.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Zailo Leite", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "zleite@caltech.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "RuthAnne Bevier", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ruthanne@caltech.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://idp.caltech.edu/idp/profile/error", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.caltech.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDJzCCAg+gAwIBAgIUC0Z5A7Hz0aGgHdvfgWBw/TW939IwDQYJKoZIhvcNAQEF\nBQAwGjEYMBYGA1UEAxMPaWRwLmNhbHRlY2guZWR1MB4XDTEwMDIwNDAwMzgxNFoX\nDTMwMDIwNDAwMzgxNFowGjEYMBYGA1UEAxMPaWRwLmNhbHRlY2guZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjUfvISEj5BkXO8k4dKr7C1NdlDIs\nosNxbjP39/8oVwgGaMSnkfMhY6xct9gnxTzCRXe49MU+UyVRlljTqTeIJf8VG0K2\naPSRk9xpzWje/fEkUHgpOjLDM0TNB2tWIQbHQwHz7HsuB/Au870PBMv4EfVz4us8\nyTmYvY2ZJPe192BnIbNyLub138HXjr7TrLBxMg7KulnanGnN75UrVjueRzAvFZlE\nlAZ+shDsjVYAoceEaFn7TF37ehVdjbXwOegtu+vU0kjjCS3cQUXXOs1Ojz6Vood/\noP1SOisW3bEhboKMUCWEcDckUXHVd/qCekbUsJEt5KAK6Gmf5Ygha748kQIDAQAB\no2UwYzBCBgNVHREEOzA5gg9pZHAuY2FsdGVjaC5lZHWGJmh0dHBzOi8vaWRwLmNh\nbHRlY2guZWR1L2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBRlqKQBRnVFASGfdigd\na/ihuq365zANBgkqhkiG9w0BAQUFAAOCAQEAck8P9JfpOWTpgc4LCyaY3WiJFIGe\nWT25D+6Gj7ADxj7+o2UZCcB2sI5LvyFJaetQSB/7p0F+hmU8/csunwoWARnbOcJt\nSmbyiJQ6eKUXOklOEqxEpGZRa2MbRwukfVx+v6U3N75JxoyuNfqC/G3tKzOIo4qz\nuxiE+1ntesuGTmWuLx9dIKILJ6XuD/rmGSkeKWljLC1jNQEjHioskqIFhcF1JxDv\nqnn8IBfnaoc4GX6AV3fEHifdQEOu7GdicUeA8o+cKqddCZf1PoUTSPby1NcFeDO6\nPPYq4pWYGD1Sc8SOXB+99YOD8hJObGIcskF0VRwv1Kg7rrTBqPLic7kcRA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.caltech.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California Institute of Technology", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California Institute of Technology", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.caltech.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://shibboleth-nw.symplicity.com/sso": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth.liberty.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFnTCCBIWgAwIBAgICAo0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkyMTE3NTUxMVoXDTExMDky\nMjE3NTUxMVowITEfMB0GA1UEAxMWc2hpYmJvbGV0aC5saWJlcnR5LmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL4WlYMz5ZI6v9BrZaYZmP+unBPC\ngo+xykfr7MnLCgjcGbLX3Pv6LAFKN7r+WZDGZuh0FJF8GiXJYm0EkgSj5gSfjLWa\nJs6pa4E+77smRq//CXOlUSjdj0yMLlhw67g32N34BncIa+hJQEofWjLgODRxmOPU\nGr6TEquiZPGE4EguEhHJybD9W3XQoqiWzuRAbF/Y3ENuWSdU4c3Cpovp6m7l9s27\nTzB4aUwtWaMfi5gMznFHtJ3xleGZtM6djByKSh6L8f1Kkkf5jNudEaLFS+jN/8CB\nMA03PubfrPckCc67WHU7o7AT96wGiU9S+bQoaearevlJdMItk5bZivEk3VMCAwEA\nAaOCAqgwggKkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQW\nMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUsEBbmaJdTRPucQIA1UZ5\n24HKp88wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJ\nBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQD\nEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUH\nAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYB\nBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5\naHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9l\nZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4j\nAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwIQYDVR0RBBowGIIWc2hpYmJvbGV0\naC5saWJlcnR5LmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAUgrkwYTlq4QCsMw3dw9j\nMPVrXljSgRglsQXvnYTybTsIgDK3tAngo+XY2Q7CowR2o1aZrwqqQNHivC59pxdU\n/p2JcF5+GcjCRrguGA7EKoOlcavFWjBfLjR0ONocj+6KTp7/zOQkMsMQiflXTEpf\nkVAVYIaI8N4ngDuBUNxcem70kWpFMD232gpPo8sQI8aNWr9X22xecVq/Eyvm3oRg\nCcrMeFRZ4F4jEKr8ne5MDqZUYnoobG7kujz0OB3Z5WZJXu5NmO3StW3q4qr86Ac9\nUMzBe/HxtnCEGjfV0ViJgKSrmbnLQdj4R2JOOpQ8kDUx7afvKASWpjfb9Sa27dLD\nmw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth.liberty.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "William Canterbury", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "wbcanterbury@liberty.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.liberty.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.liberty.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.liberty.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFnTCCBIWgAwIBAgICAo0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkyMTE3NTUxMVoXDTExMDky\nMjE3NTUxMVowITEfMB0GA1UEAxMWc2hpYmJvbGV0aC5saWJlcnR5LmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL4WlYMz5ZI6v9BrZaYZmP+unBPC\ngo+xykfr7MnLCgjcGbLX3Pv6LAFKN7r+WZDGZuh0FJF8GiXJYm0EkgSj5gSfjLWa\nJs6pa4E+77smRq//CXOlUSjdj0yMLlhw67g32N34BncIa+hJQEofWjLgODRxmOPU\nGr6TEquiZPGE4EguEhHJybD9W3XQoqiWzuRAbF/Y3ENuWSdU4c3Cpovp6m7l9s27\nTzB4aUwtWaMfi5gMznFHtJ3xleGZtM6djByKSh6L8f1Kkkf5jNudEaLFS+jN/8CB\nMA03PubfrPckCc67WHU7o7AT96wGiU9S+bQoaearevlJdMItk5bZivEk3VMCAwEA\nAaOCAqgwggKkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQW\nMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUsEBbmaJdTRPucQIA1UZ5\n24HKp88wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJ\nBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQD\nEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUH\nAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYB\nBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5\naHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9l\nZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4j\nAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwIQYDVR0RBBowGIIWc2hpYmJvbGV0\naC5saWJlcnR5LmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAUgrkwYTlq4QCsMw3dw9j\nMPVrXljSgRglsQXvnYTybTsIgDK3tAngo+XY2Q7CowR2o1aZrwqqQNHivC59pxdU\n/p2JcF5+GcjCRrguGA7EKoOlcavFWjBfLjR0ONocj+6KTp7/zOQkMsMQiflXTEpf\nkVAVYIaI8N4ngDuBUNxcem70kWpFMD232gpPo8sQI8aNWr9X22xecVq/Eyvm3oRg\nCcrMeFRZ4F4jEKr8ne5MDqZUYnoobG7kujz0OB3Z5WZJXu5NmO3StW3q4qr86Ac9\nUMzBe/HxtnCEGjfV0ViJgKSrmbnLQdj4R2JOOpQ8kDUx7afvKASWpjfb9Sa27dLD\nmw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Liberty University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Liberty University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.liberty.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://test-auth.galegroup.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Cengage Learning", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Cengage Learning", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.cengage.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Eugene Kiel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Eugene.Kiel@cengage.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "John Marx", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "John.Marx@cengage.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jayashree Ravi", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Jayashree.Ravi@cengage.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://etextb.ohiolink.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibboleth-wustl-sgms.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://acadinfo.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFETCCA/mgAwIBAgICAlAwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxNTE3NTUyMVoXDTExMDcx\nNjE3NTUyMVowHTEbMBkGA1UEAxMSYWNhZGluZm8ud3VzdGwuZWR1MIGfMA0GCSqG\nSIb3DQEBAQUAA4GNADCBiQKBgQDvKVzUNPG0QAw8ueBmBdDKOJOZtXnNwrygf1XV\nhyiMmWQWUVmt1I6+KPhYVxP5XUGU8AbyQQz4EBo4kEOhlouEILuqUHL0JZOAp1+x\nwBVBiupCiPgNgyAUp16Ty7uow0kcsQWqtkKNkXRJIgupPZIWyJGFY4DL/SgfYuSJ\n5XtUzwIDAQABo4ICpDCCAqAwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAw\nHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSA67jhRkUo\nh5lD6D2mN+wE3flU4DB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFa\npFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24x\nKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGy\nBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2Ex\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3\nYjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGC\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5j\nb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMG\nCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAdBgNVHREEFjAUghJh\nY2FkaW5mby53dXN0bC5lZHUwDQYJKoZIhvcNAQEFBQADggEBAJlIdG4DAHjTuXtJ\n5iw7ql1VfNaC+g1M3uLbH3DDrbPgXPV6dPz6IXotssDcV0Nr6HGhA/MaPVhRwFOq\nHNltoghGj+BgI/iYle7aS6NH6jFDx/sIi5/qskMTWcXGxVEglx9CMGoqOt7dtoLS\nBTwTvRqQjaNiod7Qt26vh5zMjym4hYEZ4fKy3XWzDeH0elP5weJkgdCooBC6efFy\nt8P/yzTFkOYt/mISrYpePnZztajP7k0jCkLTcmEg52rhHFznXPndO6xShsDkNriU\nc89UjhysEIk1bPXU37JZkjAHYVwdl0++1FqBQM/yx8szknN5wMSsCcwVp3qoF+5j\n6CqHxOs=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://acadinfo.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://acadinfo.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://acadinfo.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://acadinfo.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:osu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Ohio State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Ohio State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.osu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Scott Cantor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cantor.2@osu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Authentication Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "webauth-admin@lists.acs.ohio-state.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Technology Support Center", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "8help@osu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://tg-dxpres1.oh.gale.com/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Cengage Learning", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Cengage Learning", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.cengage.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Daniel Steinberg", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "daniel.steinberg@cengage.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rajesh Govindjarahan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rajesh.govindharajan@photoinfotech.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://mon.ncren.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFizCCBHOgAwIBAgICAqkwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAzMDE5MTQxOFoXDTExMTAz\nMTE5MTQxOFowGDEWMBQGA1UEAxMNbW9uLm5jcmVuLm5ldDCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBAOQmUZ0izrOgVHSbx5Qy7VjvkKb5SXLuuAUJ46wY\nCsx6mEXBAEsIx5xZVu8hcF5eopqfRE5KhBnkDoEMlZoYM4hXJbyfdczosxlM+JNi\n30/r0ns8O9bjyl+ngbb0fJjRnhC9iyfGqTWtEXRUzi5kAV2gvPxykuKmYmr9lK1Q\nwXvR1C5naCZ85QAV1PuXCxLL3b5ZNqaSxLtv1kOyCmOTeTv6nGUX9lxhW3pwburS\ntpMxjsYF0F/cRs20UYOTHv2EaZF4USgxSne6kMZmspcUXP6iSUHLLe4jLNRd/6va\ncsBJ7Jwh0CyS/8vBtd+77abm9qTzJT5vBDOp9B2HVWJ5FC0CAwEAAaOCAp8wggKb\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUURK4RgnEFmbPfbMXKT/FC16TaWcwfgYD\nVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYTAlVT\nMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNvbW1v\nbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUwgaIw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKGQ2h0\ndHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9j\nZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2lu\nY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3Js\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIG\nCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL3ByYWN0aWNlcy5wZGYwGAYDVR0RBBEwD4INbW9uLm5jcmVuLm5ldDANBgkq\nhkiG9w0BAQUFAAOCAQEACNarEiHIawi6wORht/sybB64P+pr8nx2tdcKGYsOSrM6\nfhczdXR+piShSnV6RlDFDNSQSjY8M0eZiOmwWJKrVI1vuWVjrbjCp1+0Qk9MXaGa\nqv7EXDg6JJBNXxm7/Hgplmp5CZm9h8kcgnnaD5gkasgy0cAzlMrm+CP+TYrLrjVU\nLzsciUXgKMgapFgNQMQPtxoUjKqz95btjF4AEaxohVV2SDeUNJt3P/B3uYCJcuaO\noIAO5itk/Kjg3GBQYbA/aL1Me0NhyCVJLaBXsaWL7efxpJqNOIFHBFthoQoaksqU\nIV0/qQTbnIdkdqMgrNb7sdKMrGUp7p36de7uMlZrnw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mon.ncren.net/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mon.ncren.net/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://illqashib01.illiad.oclc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Online Computer Library Center Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Online Computer Library Center Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.oclc.org", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Don Hamparian", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@oclc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jason Zavar", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@oclc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://illqashib01.illiad.oclc.org/Shibboleth.sso/Login"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDWDCCAkCgAwIBAgIJAN1vriKC/OSiMA0GCSqGSIb3DQEBBQUAMCYxJDAiBgNV\nBAMTG2lsbHFhc2hpYjAxLmlsbGlhZC5vY2xjLm9yZzAeFw0wOTEyMDExNjI4NDVa\nFw0xMjExMzAxNjI4NDVaMCYxJDAiBgNVBAMTG2lsbHFhc2hpYjAxLmlsbGlhZC5v\nY2xjLm9yZzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANtoOR3FbO/M\nI9ekR4GBqi9Vw5RQwEeZGACtgFfwB3ccPiF8HWE1EMvNRev7kVn2zUio/pP4aJXW\njkaxVQajlPiiADbQ5kO/bEXtifz60G0LU2TA3lk9oM2yxbLRfSsRxgLKEMvJAbPX\noclIwFmhyWkM5LMUvFfqyKW4xnlIKbAaWZDER/xKvqqKSUi6d9wLvHXF5ThEJLOH\nvNJ/2zISt0gn64KwMXwIYcvdhba4/y5sS+MhUNwazOOmp9K3QAleUrNgcEBtdRU3\ndtItQXh6jk4V9ttOotxXn1W+X0at5IX/rDOLnkpKpdKP1yNqWbMaoKLJDDVkDAqy\nhD7NXxrjbn8CAwEAAaOBiDCBhTAdBgNVHQ4EFgQU5eua51pcS4QJyOdun5AivemQ\nPeIwVgYDVR0jBE8wTYAU5eua51pcS4QJyOdun5AivemQPeKhKqQoMCYxJDAiBgNV\nBAMTG2lsbHFhc2hpYjAxLmlsbGlhZC5vY2xjLm9yZ4IJAN1vriKC/OSiMAwGA1Ud\nEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAFShkKrxuy0PuUt5ZkuRwZfLiUp5\nHnjOX/ZL8/ALG2ppwW4GULYnAXbA0f783vAGCThzreTGNRjWbYzDAbYrQxG1+/fx\nMp+/Dcg1XYuCXFcMQKHMexqgI1leIG0hexCX9s9Zk9FivudIj+6jgpf+Upge+zD9\ns5NpgP8eRQQF24ignuGIsY0t90bOcBHTmxtbr8v4NTckRApzQmYcZGBYFflFJNCF\n++Gt0YaCplUw9WlqcpE1x8Uw5xrASJy6bxQFAEj8C9cLd+o0uPqBPgB0UcM8NBn8\nyjdI5ctFodlc0HKsl3PHEGv1dfIPheLJsYB0QK3yiTy4rSxX1yR0DGwp8ag=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://illqashib01.illiad.oclc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://illqashib01.illiad.oclc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://cstest.cac.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "SMVTT Technology Initiatives", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "smvtt-ti@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://atyourserviceonline.ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Munish Malik", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Munish.Malik@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Donna Yamasaki", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Donna.Yamasaki@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "urn:mace:incommon:stanford.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.stanford.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Shibboleth Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth-team@lists.stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://apps1.co.internet2.edu/simplesaml/module.php/saml/sp/metadata.php/default-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Michael Gettes", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gettes@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFnTCCBIWgAwIBAgICAoUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkwODE3NTkzNloXDTExMDkw\nOTE3NTkzNlowITEfMB0GA1UEAxMWYXBwczEuY28uaW50ZXJuZXQyLmVkdTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAO1EOiyiAt59b84u+HE6JdWRBBS6\n40Ob+n4rbpqxZkJ7fyyqT2NoWyZj3RpFJeQy0x8oj4jtayZZOBqp5jr8IUNhteDI\nna7TZR/8oTt1jVQc+vFbiYFp3yytJ9gIM9FYGSreMc+CMVBhqOH347t1LozD4CzO\nXg6NeMySAQkIqQPMPkyGdo/su5ETmjMmOHUxKkcbKfwynH3c6ClOcAvKLBDCZApY\nrp4qsyx8LqeOhf/PYRLShQ5hFoSIVTokdjhtxac6+tq9INSuES+cRHvuD966kD4Y\n6ohbZaN48c/1tYss9H/UGE9ghF6NQLXmKovO7/7rDlEdkzqegC/AlSvTqpcCAwEA\nAaOCAqgwggKkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQW\nMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUWoGu9xI7hDtAYQ5GiZnI\nnAH3ttowfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJ\nBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQD\nEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUH\nAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYB\nBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5\naHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9l\nZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4j\nAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwIQYDVR0RBBowGIIWYXBwczEuY28u\naW50ZXJuZXQyLmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAsmikl7wc3MqJSqOpMpO8\nT4PeI+GYZgzxo5BZsJaqYtZzV6E1JJ54SnrFn5POxACjMq3OyCmaKnJyHaLEYyz3\n7ZPKpJhZQKrgETA/9xeYp4qr3ZzZzBMgzPSwKUH7qR6hfD7S7eaWrbxwvMLENkFw\nzB+fCwFZrv9AObkkDZReWpnoRgDRTaN2kXebbDAfJFRUdLLTHyoEaIrSxWFou01+\nh3njfVnlF/JFUyfigiEwPNgi5DCLdUvmpB0TEeK2LFtq6uA/YxywNZfehFNZt8UQ\nf8I8ypF2PrrGNqZ1Y4cufE+10CT20m9eTaNtvITJV2x9SX4FF9k5EzrPRuQqLG8S\now==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apps1.co.internet2.edu/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apps1.co.internet2.edu/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp"
          }
        ]
      }
    ]
  }, 
  "https://uc-stage.trondent.com/shibboleth/incommon/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Trondent Development Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Trondent Development Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.trondent.com/tdc/default.jsp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Trondent Network Operations", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "netops@trondent.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Trondent Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@trondent.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Jeff McCombs", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jmccombs@trondent.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://ehsctweb1.stanford.edu/shb": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.stanford.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "David Chaskelmann", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dchask@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Palle Nielsen", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pnielsen@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://idp.calpoly.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFjzCCBHegAwIBAgICAiowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDYwOTE3NTMwOFoXDTExMDYx\nMDE3NTMwOFowGjEYMBYGA1UEAxMPaWRwLmNhbHBvbHkuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwLl+pB0EAHnxoNAwBhKxKdoQLrFNxl4g+2iV\n1LZLFiwRogOnotgL5Axh2aaLgAMdV/s0+N6rd0oBpogTYpuLbWqKSJ9Gv5rSu8SV\nSOlU+ghwUjiliR+QWrW54zu/5wRv3cKwZ8wv7SuIv422rESbDuNB/COkyi4xoQou\nybpCJbAHvwxcLrJ0ak2YurYqLnackfeezuwaiMIpXPPD5hJwPrQRo85L3NTV4cpv\nqV0jAeEDkuayaFcBiQIBjPxVKMdmTshtsCQapy52KHQ6iPYj/yre7LQReERuHd9y\nSwP6c5BMdOLBaAjvxF97Sq8PMtod2xM0i9KBWxxAKb4k4n1/mQIDAQABo4ICoTCC\nAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQWe94hL8RqkOuP3J/Xpix81JTJyzB+\nBgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMC\nVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29t\nbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCB\nojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZD\naHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdl\nL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8v\naW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5j\ncmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQw\nQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9pZHAuY2FscG9seS5lZHUw\nDQYJKoZIhvcNAQEFBQADggEBALgqqr5an6EMKSpNFMiYVU2kmvtS515HCKByGAym\nv3kjlpGBHqoTnMoVJRFWXV6b8Ma7NGss8cQjm8YQJAi6zeZK8QOqvY2mj+CjCpTF\nZO65YGjywL5/r9JOYQ1plPrgs1tMZGptZeEPefBu/YwhLSt0OuRs/pDMgZJclUg8\nJmkKjQvqPnSnQ5kVYlZ4N0Nnz4cONzP+U1KQ9uZfYwNlIpEk3mgInZ22yNy2NfbH\nXwwy436vetMATqtiJOWr0NIPFqVewydudgsQr+gSoouIVOTkZgOJfz4q0BSS3sQE\nHTHoDnyLj506U+AQpHYmhIGZ+ffbSOaf9oxR9Z3eaE1CUAo=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.calpoly.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Identity Management Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "identity-management@calpoly.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Dan Malone", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dmalone@calpoly.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.calpoly.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.calpoly.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.calpoly.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.calpoly.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFjzCCBHegAwIBAgICAiowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDYwOTE3NTMwOFoXDTExMDYx\nMDE3NTMwOFowGjEYMBYGA1UEAxMPaWRwLmNhbHBvbHkuZWR1MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwLl+pB0EAHnxoNAwBhKxKdoQLrFNxl4g+2iV\n1LZLFiwRogOnotgL5Axh2aaLgAMdV/s0+N6rd0oBpogTYpuLbWqKSJ9Gv5rSu8SV\nSOlU+ghwUjiliR+QWrW54zu/5wRv3cKwZ8wv7SuIv422rESbDuNB/COkyi4xoQou\nybpCJbAHvwxcLrJ0ak2YurYqLnackfeezuwaiMIpXPPD5hJwPrQRo85L3NTV4cpv\nqV0jAeEDkuayaFcBiQIBjPxVKMdmTshtsCQapy52KHQ6iPYj/yre7LQReERuHd9y\nSwP6c5BMdOLBaAjvxF97Sq8PMtod2xM0i9KBWxxAKb4k4n1/mQIDAQABo4ICoTCC\nAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQWe94hL8RqkOuP3J/Xpix81JTJyzB+\nBgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMC\nVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29t\nbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCB\nojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZD\naHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdl\nL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8v\naW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5j\ncmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQw\nQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9pZHAuY2FscG9seS5lZHUw\nDQYJKoZIhvcNAQEFBQADggEBALgqqr5an6EMKSpNFMiYVU2kmvtS515HCKByGAym\nv3kjlpGBHqoTnMoVJRFWXV6b8Ma7NGss8cQjm8YQJAi6zeZK8QOqvY2mj+CjCpTF\nZO65YGjywL5/r9JOYQ1plPrgs1tMZGptZeEPefBu/YwhLSt0OuRs/pDMgZJclUg8\nJmkKjQvqPnSnQ5kVYlZ4N0Nnz4cONzP+U1KQ9uZfYwNlIpEk3mgInZ22yNy2NfbH\nXwwy436vetMATqtiJOWr0NIPFqVewydudgsQr+gSoouIVOTkZgOJfz4q0BSS3sQE\nHTHoDnyLj506U+AQpHYmhIGZ+ffbSOaf9oxR9Z3eaE1CUAo=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.calpoly.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.calpoly.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California Polytechnic State University-San Luis Obispo", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California Polytechnic State University-San Luis Obispo", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.calpoly.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://www.refworks.com/shibboleth/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "RefWorks, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "RefWorks, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://refworks.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Norman Kenney", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "nkenney@refworks.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth-washington.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://snapp.ncren.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFjzCCBHegAwIBAgICArkwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTIxMDE5NTkxM1oXDTExMTIx\nMTE5NTkxM1owGjEYMBYGA1UEAxMPc25hcHAubmNyZW4ubmV0MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyqE+FNAh3YmILJ7rI9k01Qm+6rAMtMXyXKAj\nU0rj3JS4hp/nh4EITINdnQrXEvWxNiOfRKa+BfQAYMsHORx8Oj1/bb5MV2GEaJKU\nZu88H3aWThQ5T/8QoZyxq0zsT92XasTVBkNPXI8Fb/RvQyAMdXwvkHDyuvI+ThW5\nDIywCtbR1oOcM215zlJyiNMOP8LoAfCNwpzPdrS9xXv/655dhVbGX50fiY/FrBkG\nQFUDR78N+odfo1DSaDRqaPN/GzqOmYs3l9vUweLTXCGZULtInoLUsoNkxIzXoUaB\nPDZ/fwi+BWIr8WCG4MRU6PTyYlEZUxJj1I5JFJpRS28VCOENIQIDAQABo4ICoTCC\nAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBRCdedRdkBdtNZqJH3hWtzGZxlSVzB+\nBgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMC\nVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29t\nbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCB\nojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZD\naHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdl\nL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8v\naW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5j\ncmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQw\nQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9zbmFwcC5uY3Jlbi5uZXQw\nDQYJKoZIhvcNAQEFBQADggEBAHuVMh+Aa2/NHN/u3fyKoAvGw4TmZpXQE85CcRpI\nUm/FS3SSAiKFdoqCaiZenCDbNCfM3JT+7qK6f3GF1rLvRr3vyel3Yn9yh9A9+XM9\nEl3t3xciIIUGGeS5H5B+zifp7QrjOl7gtrHPTRXPoF8oKXZyrS4sE20pZY9IYow7\nwKTGycGrdSvADdOCmsaC+WuKafQ/BPvFrqzRgkc324DV9J6nipUSoOAxT/FFu8gm\nWOm/xt8mebqU8rl51Uv9sY0QUXiOqZk2f9ily3aXFjrw1ze9PYah9pIc3XAs9TqP\npO0qsIXGn7DqLkdxP4Oqsw+maiWIwFbOndYO089k3IhbaPI=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://snapp.ncren.net/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://snapp.ncren.net/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://wikitest.internet2.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "techsupport@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFGTCCBAGgAwIBAgICAXAwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDcwMTE3MTU0M1oXDTEwMDcw\nMjE3MTU0M1owITEfMB0GA1UEAxMWd2lraXRlc3QuaW50ZXJuZXQyLmVkdTCBnzAN\nBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEArcBJE+GIXj7MVX524hy/Y99P5lOsdVus\n5vRZnse2sAbL366J+YKGFQWZ8HLJKpA8cc7aqFnlUSorXfvKrmInHwc9j/N7HiHO\n8LMsHeLTnqf8B8ved8BazkgfzE4DtdtER6djJk9q8+aew+jk0RL697ZssMJkC3Dz\noXdw7ivFeD0CAwEAAaOCAqgwggKkMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8E\nAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUmFoU\nnA5EQQGBDJHdIskSnZ1QrgwwfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufK\nY0WhWqRYMFYxCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0\naW9uMSkwJwYDVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIB\nADCBsgYIKwYBBQUHAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1v\nbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0\ncy5wN2IwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSB\nhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwy\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcw\nVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25j\nYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwIQYDVR0RBBow\nGIIWd2lraXRlc3QuaW50ZXJuZXQyLmVkdTANBgkqhkiG9w0BAQUFAAOCAQEAcg+Q\nz1/Yofaz1PRRtrfrDNZTcnoAvmtanT5dm1LDylRsccfXhAeA/KSVkufaY8K/qd2o\nPNEvCdo229sRNLZR+rRJpr18T0YKyly5aYdBabwg1yydOygAZ1Ikm6AE7ensygyM\n8qWIAjPSzIoGgyFtAD6f1WrOfawocFFwm/QER/cpWdlz3w1YwEynPYifBOpvFL3+\n6JzTP52Ql+DtYr3OKj815FX8QNs6t6bUUXBdOxc2UzJVyp0VVyf2V5xuxMo1IyFL\ncTS5bnNvWI04g9y0ggB+jrR7bHC6wgHI5AR2BpEmhSqYCzttrtf0wpYi36NMRJiZ\ntXnoQNPE8k4A5JNpig==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://wikitest.internet2.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://wikitest.internet2.edu/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://emp510.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Heather Tufts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "heather.tufts@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFCzCCA/OgAwIBAgICAZUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDgxMjE4NDgxM1oXDTEwMDgx\nMzE4NDgxM1owGjEYMBYGA1UEAxMPcGVvcGxlYWRtaW4uY29tMIGfMA0GCSqGSIb3\nDQEBAQUAA4GNADCBiQKBgQDdAujQPFfA3SJbvATaV3ZOyrU0pR+XTYxt1YscwGWB\n65oJpinlJVt8EX6Wv57UiRd1qNUmvxOKzQy+yMRBsc4g+whvaeumiLgz2Qlhp8g1\nSNsR/gmVYPLOLNzmVPrX7XNKNli5+DOqtq5F4+9ou8bwqiqzRFy+lPWYLgYMvegh\n/wIDAQABo4ICoTCCAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQ2Nt7DOvqITu4x\nRqumCysoiZP7WTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgw\nVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAn\nBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggr\nBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+g\nPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysG\nAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9wZW9w\nbGVhZG1pbi5jb20wDQYJKoZIhvcNAQEFBQADggEBADiiC7+8367p+Rgdzpiul67Y\nrci//XYMt5eklnWSDDnILTxCmnZ/9qBnpARjzIIyUToU8qR53F8UHjpp3SAzLgxA\nCiQWSIWOzoqAJHKfKeQNID51wKLH5BP+6YD52+Q8ufjZgpYierKqLcJqtf+WaQGX\n36kVQP38uI3zK7jHnr28mN5OCEyKPAV+4Rs2KwxG+6rQ/NjBM+W0Y/k34Uguk2XM\nMOvH3xJ+SwsQJBcjigErJwsl1zOZxlvHEg8/p719H/dK8ZbZROHw2z5LMoCdwMmf\nIFJDINAoOBl+1Mb5A0xgbbDpQbh1/+KLgd+rOdA1ko6m0o4bfxAQHuM8M7xJsSc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.nyucareers.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cs510.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://training510.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://test43.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://ucastage.sumtotalsystems.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sumtotalsystems.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bharathy Mohan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bmohan@sumtotalsystems.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://db-backup.ncren.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIGFzCCBP+gAwIBAgICAq0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTExMzE5NTU1NloXDTExMTEx\nNDE5NTU1NlowHjEcMBoGA1UEAxMTZGItYmFja3VwLm5jcmVuLm5ldDCCAaIwDQYJ\nKoZIhvcNAQEBBQADggGPADCCAYoCggGBAKJda1rSWnITfaGfRuzNOiJAFvqeJCDG\neKN1QosV1c4/B8/Sg6U51+2zUh5Lp3Rr/y4akHFC4g3KIVkfm9Zs+AfDcbyst8tn\nCj62PFxw8fMSECLCu6XMFZ0t5hSaI+uQezDMcJefiDBdSbNcO+IpdSo6LmaX7aTQ\nQyCzFBT79hAbcWGqIrwOZy3VMiLqi3In+pdjpMr4/zLr7PCJ6X3DB2HNHcjwKZp4\nlSdBNyJeL0w1yqwfb7UEF5sW7V/Wwc9xuiFQQGQnKM2WVIXaMBEJp0rW7I/g6vQs\nktqXtT0SjILakm1qBvnqMIyGUIJImIcRUeOLMEYTT56qQxRbTIy9b4MPNRdm5hIQ\n540GXuC/u0suRlhpjmFOtn1UUuEdAo8PKhe36zwpsquiT6J51U8qrE3+HtmJd7VR\ngoy8UrOXD+DCdND4P3Sd4al9IRuhN/EB+s9swt7ccKREL4HbcgFe12pFUXa+f8cc\nhdeZ7ZokzWw3aeCJrGW3QVb9dwCpmWXCdwIDAQABo4ICpTCCAqEwDgYDVR0PAQH/\nBAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUF\nBwMCMB0GA1UdDgQWBBQxduYTDnRw9nlmwuAwP7fVZn+L6DB+BgNVHSMEdzB1gBST\nLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoT\nE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmlj\nYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcw\nAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJp\nZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29t\nbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNl\ncnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwx\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0\ndHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVj\ncmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEW\nNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3Rp\nY2VzLnBkZjAeBgNVHREEFzAVghNkYi1iYWNrdXAubmNyZW4ubmV0MA0GCSqGSIb3\nDQEBBQUAA4IBAQC6CeGyOmOfQcS4rKp7bEc5J2Siy3xKi3jxWQVvOsBtrooCBErF\nLMxyCVC+HOf0/ZB6TmPpxF8iogyjCc5/IY/r0o2wEs4e1222vQqBSA/SEQ8MFQWS\n4bY2UxCqQcHHd+bnBkdndEHsfPwdamIkbRINes/LW6fITXpIkf5gdqvayk2Q7Zli\ncqZVyf+CDUvwXL+r86qxQJRY2RHWBT37CoxoRsyluGDs29ToDw66ZQXiHCSKzYfn\n685wqFJ/ATAfOKUeVKF0gT+50ucoNYCDP0dBTyDe48PYaLO/X+jYEjvl7rx9XiO6\niBZwWl1QkWaS1EKzZ3Huf/CvOj3Frh0elGdy", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }, 
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFlzCCBH+gAwIBAgICArEwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTExODIwMDYyM1oXDTExMTEx\nOTIwMDYyM1owHjEcMBoGA1UEAxMTZGItYmFja3VwLm5jcmVuLm5ldDCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBANCeOMvAQwAF0GmkQ1KSESgNmeqyGfxo\nznQyifhbRIHIcbp7COXqkNmVcpSKYTgHLQe5hbr3PfPAuzSoWuU/jPEtMrhxb9J6\ngPYVMJAJxWkKFBi1BXecjlgpL9k1UXHkuDO0nGrtu8YU+j6OR3YDJ5FDln0ZS5tT\nMpdJulwFQqsRjNUFFTWTivdMks8uO0BO0f9gRC/ZSRSgIqmOeWy64AoIZQJUIz3e\n1T70mIYRosWvq478V3PkZny/jPjPdJijmF4hScTblLnCgAgHSKa3EniVBJyGAWto\nDCWeXleRhzU+U8n9nZuUY4by2aySutD01JgtK6NdRfv3QZRwALy2LlMCAwEAAaOC\nAqUwggKhMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQG\nCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQU0QdPuS1GH8yKKD/tOaYBbqwJ\njqIwfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNV\nBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJ\nbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEE\ngaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUH\nMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2Jy\naWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0\ncDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNy\nbHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQB\nATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHgYDVR0RBBcwFYITZGItYmFja3VwLm5j\ncmVuLm5ldDANBgkqhkiG9w0BAQUFAAOCAQEABCwVeiDKv8fF7ulTRSoSbH8Q3llO\nxY7ugiSmQRcwEwllFsCPPBlNipeMP6Z6V5uuu7Zo1HaQ3bMBV5BAUJSaagqc4m/j\n3b1uwXJEZ6H5vBmxhe1IN+jXOcCXNYMMWwB18P8mU5BMePdIEIXG0By+CANITNlU\n5/R5ShZE9wGkAOgokdR1HEL5XeVJ2Y2guHLftUQ50vXf6HMjr7VoarJL7AjFtYCX\nJL69GJS/a8TpAYRDM4Q1X2w4M98hMfUnSNmikaInlF9Uini8CEzYHmBVYXkWgnAf\nBQE1hJcS+NEiCsLf00sRwUheamEDw3ZpcqK1MjNaxsQdLjqWwaCtsAMVKA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://db-backup.ncren.net/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://db-backup.ncren.net/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://www.intelligentriver.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.clemson.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Barry Johnson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hbj@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Kyle Peacock", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kpeacoc@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHTCCBAWgAwIBAgICAaAwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDgyMTE4MTMwM1oXDTEwMDgy\nMjE4MTMwM1owIzEhMB8GA1UEAxMYd3d3LmludGVsbGlnZW50cml2ZXIub3JnMIGf\nMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDnMuvBQ2fe9fBGKxmDB2TtxwZs3Jqy\nMfjjprjLtYlG/3MRHmDtVT/t45D8cogmooJnkP/xf1ps3zNtQT/V12g2f6tSmcRE\n7HUY0rVt/1G5QNFnnZMhmc/t07EiwAFK0vT3VF68HwgzgTm1Oc/alxMxIR/RRcry\nLuLUCP8Cezxz4QIDAQABo4ICqjCCAqYwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB\n/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBT6\noxcz+PUFOfSg+OrZ/FVA8CXe8jB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO6\n58pjRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVy\nYXRpb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5\nggEAMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29t\nbW9uY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNl\ncnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0f\nBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNy\nbDIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAE\nVzBVMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1v\nbmNhLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAjBgNVHREE\nHDAaghh3d3cuaW50ZWxsaWdlbnRyaXZlci5vcmcwDQYJKoZIhvcNAQEFBQADggEB\nAE+YLgBlhcHgqvGaPU6iJtgknqi0BaIBW4PqrPJbyvRZY93QdthK2KdXRN25hM9F\n7FRm+Oz08uSUaStJG5pt6p4l5JE3nwAX3+LWlFZX3JRkdx87oldrrM7PYq73wtEQ\n2f9AQRR8yiptHR/R5PgbOgjrZypYtDA/qbDPHFOXoW4iTs/aFiwrsXLlrvwfSWsQ\n5sX4VLLwoor93QsWVSiE5fmGlz+lyUJfNAg7n5R9RKwr8bubApBORahwDXKl9pTz\ngJsJ3Do+Fg6nH0EGj6SdLoFeChkKoBW9ftNwdNlMEUEGjfml/XxSaax36QGnyaon\n8TEkIYNxRKaeWjSIpMQ4MB0=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.intelligentriver.org/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.intelligentriver.org/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://www.intelligentriver.org/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://www.intelligentriver.org/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://www.intelligentriver.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://www.intelligentriver.org/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "7", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "http://www.intelligentriver.org/Shibboleth.sso/SAML2/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://edspace-test.mcnc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFmzCCBIOgAwIBAgICApUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAwMjE3NTMwMFoXDTExMTAw\nMzE3NTMwMFowIDEeMBwGA1UEAxMVZWRzcGFjZS10ZXN0Lm1jbmMub3JnMIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA9rhd4P9iyuqvc742MMSxVxVKULwR\nIe3G4wY/qVA34r4hbxypd7n+G82UVI7jqYkQ2D88ylOZwJPtbbChd2DrS6o5MuWi\nUl1dW3/9xYFSrQ+TNtx3VoffJR32wydzRPt3ZKhPGu+oVwMoIO+FNiGJnBq5H2S0\nSlCc4gGK/QMHKasNGfKYWvhIIaGpkid8RlVH5n3CA92aW1ak+M9R/ZU1h7tgH6U2\nx+CKHY/3EIslpkzwaWsn52IVjugmXmeBG1RBG+lM7WUoK5TkCaU9beJAVIfNYdph\nmxQuZBokNG8zwLLUpYih19Ramx/NqCWh67DJCGTZQycHiP/2JKI0sjxayQIDAQAB\no4ICpzCCAqMwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYw\nFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSZQ88M/TcaUdnfiOmCZQmn\nvXayvjB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkG\nA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMT\nIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcB\nAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEF\nBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlo\ndHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2Vl\nY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMB\nBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAgBgNVHREEGTAXghVlZHNwYWNlLXRl\nc3QubWNuYy5vcmcwDQYJKoZIhvcNAQEFBQADggEBADvQ7lEUqI1Ga0txoyrwMUHG\n8/NfMx6k4Eflb2E20vxG1UNrPz/x4ske60YMgKpzQVVMN/sJ8ETK0DKeZujp8Uf8\noPbmHM8Zy5XW3lpxgjBHWvZDNKw9hJx3KDt66J229aw6bPAHp1Plp2Z4zUa2Z7uW\n8JPKwAQTQspemWhiIzxZvInIYV7i2PGLBoY7wnK1UorOfOcEG4I9Dby8eM68ohUI\nkWoWWvkzUKe8Fe9o+I4EQF56mv+uuXhGxATNvAgCSY1D350m5DkTdvDhd2shi/49\nuQxK0ZHpBDetEhaXaolcRoGOnD1ZWgv64DlSgS95vKlFEXzckno/RJLkWWhY4sQ=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://edspace-test.mcnc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://edspace-test.mcnc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://www.iths.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Justin Prosser", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jprosser@washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://deimos.apple.com/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.apple.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Yuemin Yu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itunesu-shib@group.apple.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shib.lynda.com/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Lynda.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Lynda.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.lynda.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Mike Flynn", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mflynn@lynda.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFjTCCBHWgAwIBAgICAlYwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxNjE3NTYwOFoXDTExMDcx\nNzE3NTYwOFowGTEXMBUGA1UEAxMOc2hpYi5seW5kYS5jb20wggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDErsgujNMSGD5Xqf0/yywU0L4Dj+INoeft8Jvp\nkQCM/WLEtshu6cACcFKsGvTFmNgxsB34M3X5gTZYe8e5FZPoUD7DvHOXGGPj/F2+\nry9/oSP898UmiEj3ulTFmxDPMYIBnIDHeKuHdKzFH3vDvaUjY+1S2nM89WhWXOM5\nJUFW81COu0G2HCJIi1hawTDeLs1cukcjVEZbc/JALsb52W5pSNeo3F8TFvQ0oHuK\n8Law1dLbt2wwo8oq8IU51yHWTXUQ0OMa+6i5gEuPfm/9jET95UigVN97EGkd7sD3\nYvcu+r+FMyh/dr+NZQ1tWKj+Ew+zDq4nZCuQkShrTS8p/2rvAgMBAAGjggKgMIIC\nnDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggrBgEF\nBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFB1eG7TklyzL086VUT9rRTSIxPF3MH4G\nA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJV\nUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21t\nb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGi\nME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAChkNo\ndHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2Uv\nY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9p\nbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNy\nbDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBC\nBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9wcmFjdGljZXMucGRmMBkGA1UdEQQSMBCCDnNoaWIubHluZGEuY29tMA0G\nCSqGSIb3DQEBBQUAA4IBAQBSw5nTyai6gfDZ5yjXaK9h1apTOMpENEnyMDhKg/Ec\nGefI+RaI5dedPTpIw1+kfn60+pf+WqerGz7nMIZjz+DdSDAeKTDpAD+tafYlaz1U\nG6NT2jWHsUHzNQvMVLR5sUunuHZY8nEXUBRbcPDG/Pw9w9O1CQlZ3Z9HWTDnYak9\nfSITE342EgeHB/ntH8CzwSqBLJgqDnFS3Ua0pJ73Fg8ppiW+jDB7Zt4LrhwnDmjD\n6pWa3M5fEtdGDjcmCY96yq5sN4kQPc81dqx8P3OChIDc/vRz1x142kwjZ2fsI0af\nzf5fedKS5bPvaLcRbsZVeXVH06H5EYqP7ZpL0l9rCnyZ", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib.lynda.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib.lynda.com/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib.lynda.com/Shibboleth.sso"
          }
        ]
      }
    ]
  }, 
  "https://www.nescent.org/webapps/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Duke University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Duke University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.duke.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jon Auman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itadmin@nescent.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Jon Auman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itadmin@nescent.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jon Auman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itadmin@nescent.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIC/TCCAeWgAwIBAgIJAP5RKbewFsTAMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3d3dy5uZXNjZW50Lm9yZzAeFw0wOTExMjMyMTU1MDNaFw0xOTExMjEyMTU1\nMDNaMBoxGDAWBgNVBAMTD3d3dy5uZXNjZW50Lm9yZzCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAJW/kBWaraLDhZW7GkbvpWBymdvzT2NrkDk2Kl1NXSpa\nzUzLt1jiBixOgDG37M/DJdGQG4pvozk3446awuFlzN6dUnma7H5RoHx3NYSnJGJl\n5hSh3p1yzaEKeTIySqdZKkstgNdUvfRRDInurRRwndXPe50Fm3DFV5z7xdCCCgl8\nMYscWSNs6Kni03NycAs9YhIIsSpS/TuHX6BaFP++/HWhJSKd/qu9HZgVvwSj/MBF\nV/Gq8wB9NNqqXSURkVazlNstnlVZTGaz9RIMQGwcXuv0Qa0HhSk3FTxMMczQvvtH\nRYRgoQAyhbLmL1JP7tJ9KAdV/YhkV54qi9hk4mL6Rm0CAwEAAaNGMEQwIwYDVR0R\nBBwwGoIPd3d3Lm5lc2NlbnQub3Jnhgd3ZWJhcHBzMB0GA1UdDgQWBBRdPVL8vF+p\n1/9euxzDDOCiiXr2yzANBgkqhkiG9w0BAQUFAAOCAQEAlNVlQ2q8Fwrd2MYUm81y\nUNwuebClwZ+6wohYQEyxN0//UguQqLbZ9QtUi9mrZpwhl9o9RX2LliiH6SusD9dn\nSGjxfVGbZc/OvXzMQi1ACsuIXcCZU02PvCXZHlg+YGyRo0HpFcxnJbT2z17KasK5\nHCjGXM8DJG39gLvXcG0xSL6ObDyX0zIlOuuZpofD3uQxKt/JatWr5mx7nSaT7GBG\niAjRLi87Fmp0vu3HmintcTSQek1rPGoSuNGRd2JZ6kQlQ5MTLi9FpYDLazqg7sqF\nh1NDMkXbswUhf1JSn1mBpmcQmeOvWgyHm3bzKdQMpiFFRf2LDBcAYKDAq6YPWCH5\nCA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.nescent.org/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://journals.ohiolink.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://rt.umbc.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.umbc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Paul Riddle", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "paulr@umbc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://cdb.iths.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Justin Prosser", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jprosser@washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:unoh.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Northwestern Ohio", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Northwestern Ohio", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://unoh.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jeremy Brinkman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jbrinkman@unoh.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://idp.purdue.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Purdue University Main Campus", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Purdue University Main Campus", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.purdue.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Purdue Identity and Access Management", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "accounts@purdue.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://carmenwiki.osu.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Ohio State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Ohio State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.osu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Scott Cantor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cantor.2@osu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Travis Ritter", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ritter.18@osu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OIT Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "8help@osu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibboleth-nyu.symplicity.com/sso": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "noc@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "http://collab.sscnet.ucla.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Caroline Tam", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "caroline@ssc.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Mike Franks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "franks@ssc.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "SSC Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "help@ssc.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://getz.internet2.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Techical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "techsupport@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "IJ Kim", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ij@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://ucitps.ucsd.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-San Diego", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-San Diego", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucsd.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "ACT Help Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "acthelp@ucsd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Joe Pomianek", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "joe@ucsd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Matthew Elder", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "m1elder@ucsd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://eauth.acpt.research.gov:9443/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "National Science Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "National Science Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.nsf.gov/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bill Altmire", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "waltmire@nsf.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "David Lotts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dlotts@nsf.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Research.gov Help desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rgov@nsf.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://edspace-test-03.mcnc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFoTCCBImgAwIBAgICAogwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkxNjE3NTg1M1oXDTExMDkx\nNzE3NTg1M1owIzEhMB8GA1UEAxMYZWRzcGFjZS10ZXN0LTAzLm1jbmMub3JnMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu1iesWxsWthvg4g8LVJaensC\nmVNqNggubKBaSq9ByiE3ymnmNFMiIFKCa6mm1B5GcgzEj683tCfZtEymOHh0mFia\n1/duWlHDuf8yCdNedqcNH9AaHn+4Gqi9C/mqAR6mGwtkyMBGTM92l83sn2HBf9qk\nVb+kRiJKwtuQfRoFBNw3wNvywMuFcrVHeD2fHROIRaOaNOfh8/FFLA5aQDs0QkmR\noY6Mt0wDRZsmmjhSQAQkE6b5GFCG2jal7rpn7nZ8MXWg1tXkPtEiZTatBbbaRcI9\ny+KtN8JesWndMtYE5VAuzAiRNQiYp4RmNbmlc8TGVVghsJU9XmTF0ms7hir8JQID\nAQABo4ICqjCCAqYwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0l\nBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBTtHNAGDW3e3NeMuhhl\njkUvo/lT4zB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjEL\nMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNV\nBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEF\nBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggr\nBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7\nhjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3Js\nL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQB\nriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAjBgNVHREEHDAaghhlZHNwYWNl\nLXRlc3QtMDMubWNuYy5vcmcwDQYJKoZIhvcNAQEFBQADggEBADT/iJ3QFbf8iChs\naV5f9NIlhMj+b2K/AiENZrq2WM3j9YQpph4SmvUYaopPDonf87U2Ir+a7B+97DhW\nsM8Yws1sGIgLFEC+9bTqbwPHcNIgYRSox1q7nJ6b+nFKbZyXZU3Z8Iw9ks3G+l34\n0k6KT2nikZO5UUcEt6vU00VZzEgvOPXOAcIDwRLt8aHxP6kZEeK6T3OFPHxiTuvj\nHy4aGQrkvSGO7u2nMu4NlfH5da6cdoqI+/TawO/1fd4LE0DTpMg/SFNfQQonKiGn\nRAmJGU9eWSZecWiKOwbw9VxguCr1BPuBBz+DkSNXjhrm/VT2n5jig8vnJP/ggzGL\n+gsI9CU=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://edspace-test-03.mcnc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://edspace-test-03.mcnc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://edspace-test-01.mcnc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFoTCCBImgAwIBAgICAjIwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDYxOTE3NTU0MloXDTExMDYy\nMDE3NTU0MlowIzEhMB8GA1UEAxMYZWRzcGFjZS10ZXN0LTAxLm1jbmMub3JnMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu5kmpT4vpvM/4+yDbx48J1NM\np5Gadrn356Ra6RAKMfFJPyOBMK6jZB6f7XJPExdcDnAQMS+peUqN93tNE7SKVvbo\nSLtCyXD2MW29VYBOx5ppmFlJwBeec/EWJ8OL3WTWG16oE5cNY+43JdReLZNDXV/8\nuXQUIut370jeMyIqpjIdYiaWmTwGq6zBZYOSl3dlhHQ6IEpNg8BVhcP8s7jVRV7o\n5y4eZVPcHou6xyjQ4J92n8maFbtHj8oxHJ0veMgAG8g8UefbZEsLKLAqmrQgRpVu\nkncpN6e86xnIXi+/u4/1GNicEU++DoLHtIg9jWp2CfZUN5+yiXx0a9S2bYVdAQID\nAQABo4ICqjCCAqYwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0l\nBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQvslSBF59U94ATbyis\nKHXaxCllGDB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjEL\nMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNV\nBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEF\nBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggr\nBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7\nhjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3Js\nL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQB\nriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAjBgNVHREEHDAaghhlZHNwYWNl\nLXRlc3QtMDEubWNuYy5vcmcwDQYJKoZIhvcNAQEFBQADggEBAFli9PTKFBu960QA\ntPV0+DnqAylgRT3iyUFBRs7uDfqz7/5rkQA7mUmHyXOe5rQX+ZJbMZi6lzWMTJQN\n+DjmvdOJCalabAMumipFDQ2a1Ype9QA93xMIOIkATtCPuHTJqMOajjMn/lBGf+uS\nECuNk9pzGmBOqaUWnKEEZfbHSTedLXcTzMG0kUBU669Ehd9i1+a4n2WIfzJ9sYm2\nbKV2MG30QDYI4OaamH0xH9sIEwwfEuhzvpbq/JDp/iXGMD61qcqFtd6XOIlykt/H\n8ZKPnbf4aTvxF82ByRLsL1+q3PtrG6oDMkQ/sQ4R20yGcyqJmz+Q21S8CXY4Aibt\n71vbazQ=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://edspace-test-01.mcnc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://edspace-test-01.mcnc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://www.omnilert.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Omnilert, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Omnilert, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.omnilert.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Niclas Gustavsson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "nick@omnilert.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFDTCCA/WgAwIBAgICAdgwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MTIwNDIwMDkxM1oXDTEwMTIw\nNTIwMDkxM1owGzEZMBcGA1UEAxMQd3d3Lm9tbmlsZXJ0Lm5ldDCBnzANBgkqhkiG\n9w0BAQEFAAOBjQAwgYkCgYEAn1ty+PZBoIj4hBES8WyxzqOy6CjQEMYH93AtZOOA\nQ0BLIMCHuLL6VI0kdhlI9TDKNHQwQg+UtY+FWlLbW3TPxvYbrpWMBupGL9CV+6LI\nY+qdQALu1B/F3mWvMDYxt5uT59OnpCmQWdpv4+jje/DmFJw/2bsJF6wBUxSor/Nf\n6d8CAwEAAaOCAqIwggKeMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0G\nA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUD5hZ/0Fl9rix\nua07wGN2uvnUtvQwfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRY\nMFYxCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkw\nJwYDVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYI\nKwYBBQUHAQEEgaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5p\nbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2Iw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/\noD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3Jn\nL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsr\nBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwGwYDVR0RBBQwEoIQd3d3\nLm9tbmlsZXJ0Lm5ldDANBgkqhkiG9w0BAQUFAAOCAQEA0RBRVCJ28djkkZuB3Fpl\nNFG4RcDl2o4Q5sjEELRWc+VjJnM3vWQtCXrBjihPAcdaHyqj36ocx8S+drFbZNio\n7Lwhzi9j/P6b2qYFAnGDXrvoiR1x14ks25OU83OOBr/6p6O8+feCm1kePwmgNUSR\nz+bc2h02a2T2FED6+gQi50vBWUO1F/+CaRsf8xxEUt3swxiNjyJNdaubQfQrZMbe\noWHn52Pyl2P278tY26B4AAqrbyYEIG2r9LtkylNW8qGKAdfv5j6M6Qsa2XgrvlvA\n8s35LCMU4VczWhkyJ6zQSU6XnS4Jiy5spXONEqSYgm6KazfZoFlrhtfyX04vVaF+\n8g==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.omnilert.net/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.omnilert.net/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.omnilert.net/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.omnilert.net/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.omnilert.net/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.omnilert.net/Shibboleth.sso/SAML2/ECP"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:ucla.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Albert Wu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "albertwu@ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Datta Mahabalagiri", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "datta@ais.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth.csuchico.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFGzCCBAOgAwIBAgICAgwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUwMTE2NTUxOFoXDTExMDUw\nMjE2NTUxOFowIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC5jc3VjaGljby5lZHUwgZ8w\nDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALLz5MPOM+UZdDp0+eIxLN45E8eebqRp\n/vPAtH+7+qdkD07kPhosMdQWNXK0cs4fvtkBPXzYnNsS3LvBL0SxBQIRPrWY37VL\nGLpldGJukfmRxvAgsfuDDYwp9xKyHk/h+n9ptD/58eSwPDwJu9fJmiNV0iIGA1XQ\n98MI6lVTi6TnAgMBAAGjggKpMIICpTAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/\nBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFPd4\nNg7xy2F6Zkap6lhe1vNEKIOiMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rn\nymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJh\ndGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmC\nAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21t\nb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2Vy\ndHMucDdiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3Js\nMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARX\nMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9u\nY2EuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMCIGA1UdEQQb\nMBmCF3NoaWJib2xldGguY3N1Y2hpY28uZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQCc\nMnWydUHTtxIKboj9a6ycZDUrBC2Hx4StyFWpTF7mQoIYhbN3Mk7SWSny/k3eHWLo\nf7zyMYQzYgHklusRDNHKtEOIni2B71LuAxeAAJul7POcF+OcSow0KXNUh4amALg4\nFeViVK/M4ordpbJ31976Fo8q2FQ8FbF9dN6yn0khGpDCzMgAlKAZLAGbykKCeTRd\n/2W23OOd6Jb94N2g63ZlcagoQz4F2d3ER4v6cfCQ4u2FiyNI7iOYEbOS1s0iuVtG\nqYSjsTcTPHY2iP4nn3zNPbNSh3AjS6yteQqt3HeGNuaPOZT+6IXLPb7I93tuS1lf\nrERJHh2BwFv6qmMYJzLn", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shibboleth.csuchico.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "David Fuhs", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dfuhs@csuchico.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.csuchico.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.csuchico.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.csuchico.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.csuchico.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFGzCCBAOgAwIBAgICAgwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUwMTE2NTUxOFoXDTExMDUw\nMjE2NTUxOFowIjEgMB4GA1UEAxMXc2hpYmJvbGV0aC5jc3VjaGljby5lZHUwgZ8w\nDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALLz5MPOM+UZdDp0+eIxLN45E8eebqRp\n/vPAtH+7+qdkD07kPhosMdQWNXK0cs4fvtkBPXzYnNsS3LvBL0SxBQIRPrWY37VL\nGLpldGJukfmRxvAgsfuDDYwp9xKyHk/h+n9ptD/58eSwPDwJu9fJmiNV0iIGA1XQ\n98MI6lVTi6TnAgMBAAGjggKpMIICpTAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/\nBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFPd4\nNg7xy2F6Zkap6lhe1vNEKIOiMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rn\nymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJh\ndGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmC\nAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21t\nb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2Vy\ndHMucDdiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3Js\nMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARX\nMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9u\nY2EuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMCIGA1UdEQQb\nMBmCF3NoaWJib2xldGguY3N1Y2hpY28uZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQCc\nMnWydUHTtxIKboj9a6ycZDUrBC2Hx4StyFWpTF7mQoIYhbN3Mk7SWSny/k3eHWLo\nf7zyMYQzYgHklusRDNHKtEOIni2B71LuAxeAAJul7POcF+OcSow0KXNUh4amALg4\nFeViVK/M4ordpbJ31976Fo8q2FQ8FbF9dN6yn0khGpDCzMgAlKAZLAGbykKCeTRd\n/2W23OOd6Jb94N2g63ZlcagoQz4F2d3ER4v6cfCQ4u2FiyNI7iOYEbOS1s0iuVtG\nqYSjsTcTPHY2iP4nn3zNPbNSh3AjS6yteQqt3HeGNuaPOZT+6IXLPb7I93tuS1lf\nrERJHh2BwFv6qmMYJzLn", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.csuchico.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shibboleth.csuchico.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Chico", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Chico", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.csuchico.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://data.scps.virginia.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.virginia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@Virginia.EDU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jeffrey Wolford", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jw2w@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rick Downs", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rtd2m@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.mcnc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://www.mcnc.org/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFiTCCBHGgAwIBAgICAkkwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcwOTE3NTM0MVoXDTExMDcx\nMDE3NTM0MVowFzEVMBMGA1UEAxMMd3d3Lm1jbmMub3JnMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEArXq6Oo4EtwNAqxIdBomb6tIUuK9rMozMUxDECM6y\nNBkzASAy2fYpmVx2stpwwTvpl21XHMqNavFzaDQHflF86gWwNIeEBbCDzE2pTj7z\neR9aPP25WIELTtit0+K5+ti4M0CsCIU+C+qFItsGhsn60TXe51J1YegEGOwSz3u5\neeRSjTfgnlH+lpZNvTfG7uvPVVTDJmLa6nhjIqyUHuj5Z/TI4F0X3N5bSAKKN2yD\nyURsGzo8o2tR91F3+g1tU3RMna/bRADMcTLdnjB7uT6FB7ueKjat03O+Ckj7pbhN\nlOZTo4C6WLR1yCiFlzqldcvTLrkA2UjIcvXsE5jw4ndxhwIDAQABo4ICnjCCApow\nDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUH\nAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSlP8OIMNN3oH5xvv7YbX6kFK098jB+BgNV\nHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0\ncDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2Nl\ncnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5j\nb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmww\nP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYI\nKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvcHJhY3RpY2VzLnBkZjAXBgNVHREEEDAOggx3d3cubWNuYy5vcmcwDQYJKoZI\nhvcNAQEFBQADggEBAFE4/p4/9Es9PWEeYCyljdpXFC/yutVZlt/t3nOmaItgEfqU\n8O+BlIxnH9UYRLkL9gt2YpLGwvJ3ukGHIxMTr8ktHFoTPU2ivntYmHe4lFbabxoP\nPbLbMcX+HHQzGLN4IASAXCuVfxr6TZbleihqWBeqYUwkXw1gksZUmrKwzyWm4ssP\nBC3zd6/7onuiQLi97dYFw7N5lDocdOfGrEiHLgZIaGgmx1edktGbVoUfPWk94yPg\nwRC11rzU4hYKsgU3kTpDShF/LndS1K1DOPTTU4uS5ldt08ZzRM1i3BmXAn1P2i7c\n7ZK/A+7pvPlqpt6n/gVI7LV+fYPyvBtAQVxnMPY=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.mcnc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.mcnc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth.studentclearinghouse.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "National Student Clearinghouse", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "National Student Clearinghouse", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.studentclearinghouse.org/default.asp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Doug Falk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "falk@studentclearinghouse.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Tim Bornholtz", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tim@bornholtz.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Lan Qian", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "qian@nslc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://collab.cic.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uiuc.edu/index.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Marko Stojkovic", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mstojkov@staff.cic.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Russ Snyder", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rwsnyder@staff.cic.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Tim Newcomb", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tdnewk@staff.cic.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://ucsso.travelprefs.com": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Trondent Development Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Trondent Development Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.trondent.com/tdc/default.jsp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Network Operations", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "netops@trondent.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jeff McCombs", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jmccombs@trondent.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Trondent Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@trondent.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://downloads.channel8.msdn.com/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Microsoft", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Microsoft", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.microsoft.com/en/us/default.aspx", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "DreamSpark Engineering Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dsengt@microsoft.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "DreamSpark Engineering Team", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dsengt@microsoft.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Scott Blackwell", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "scott.blackwell@microsoft.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://k20.internet2.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "techsupport@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIC+jCCAeKgAwIBAgIJAKm+zsWSo7BzMA0GCSqGSIb3DQEBBQUAMBwxGjAYBgNV\nBAMTEWsyMC5pbnRlcm5ldDIuZWR1MB4XDTA5MTEyODExMzM1NFoXDTE5MTEyNjEx\nMzM1NFowHDEaMBgGA1UEAxMRazIwLmludGVybmV0Mi5lZHUwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDfC8cEhLoi57hF/9xbHXds/A3D1JCsuq6rGYvB\nEHsKEhcx68qwB6+dLSQ+VK0FuZdb2jKdHTvDSrX6wLfGMlAcAHbNDWG8YPgG9rOj\nGzmXtMqaH/iXNbuVtmxA4b5ddPNq8R4wxpYNupqqlcAu91B8H98wnnMtYqVXs/G/\nCBsFe3+HpvwBc2trt6/PPTbwBQN9dWQ6hSacd8ljrs0HlpGbyMTMBddsv63XcicV\nodnGU36vDZCemaCq+E5CotrH1nJmfO076qq4qgbpwNI1OO2nt78DYvqCqzCDM32K\nut+/tJTmCZNHOdFKsnlFdq6EQMGXxQChmWvZ/xJyS5N+0z0lAgMBAAGjPzA9MBwG\nA1UdEQQVMBOCEWsyMC5pbnRlcm5ldDIuZWR1MB0GA1UdDgQWBBTo5kQdd3ZIAx5o\nYDFzBMsnnN/6AzANBgkqhkiG9w0BAQUFAAOCAQEAbd4m8UhmhFJbDQ7YoNAjMgXW\n+8lQPWoM0Apw4IpsZqDw8WuM2oRjzox4vo7Yn79MBaJMsdd+91XsX+ToAmy+SuRG\n9NRdcQKACNFGGVkYKfPjJ/AAOIAodPsSd0ddHclkoYnaLgAjlwXmG3khGA2rYIAt\nRqmjc7cryuORjkf9h5yUQvQKl/qi6Hv/5JNsTIAnxmkq6itKR20aiVBaKERAMTET\nFeKcUT3HObTuIUhJGdD7Vcvj485rCS/55nrvGyA05Z+gu+kB5batJQFH/s64GFsr\neAce5p5WU2H/Sbm6G+2lx1qqarMDegkHYh/itS5ihi4K7mLCqaHFn8bWNrxUVg==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20dev.internet2.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20dev.internet2.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20dev.internet2.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20dev.internet2.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20.internet2.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20.internet2.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "7", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20.internet2.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "8", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://k20.internet2.edu/Shibboleth.sso/SAML2/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://imp40.sumtotalsystems.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sumtotalsystems.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bharathy Mohan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bmohan@sumtotalsystems.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shib.ucanr.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucdavis.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bryon Noel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bjnoel@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Karl Krist", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kakrist@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "urn:mace:incommon:unr.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Nevada, Reno", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Nevada, Reno", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.unr.edu/content/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Derek Eiler", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "derek@unr.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jeff Springer", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jeffs@unr.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://ebooks.ohiolink.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDxjCCAq4CCQD28y8CJTcDDTANBgkqhkiG9w0BAQUFADCBpDELMAkGA1UEBhMC\nVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYDVQQKEwhP\naGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlvbjEcMBoG\nA1UEAxMTZWJvb2tzLm9oaW9saW5rLmVkdTEeMBwGCSqGSIb3DQEJARYPZXNoaWNr\nc0BvYXIubmV0MB4XDTEwMDIwMTE1MTAyN1oXDTEzMDEzMTE1MTAyN1owgaQxCzAJ\nBgNVBAYTAlVTMQ0wCwYDVQQIEwRPaGlvMREwDwYDVQQHEwhDb2x1bWJ1czERMA8G\nA1UEChMIT2hpb0xJTksxIjAgBgNVBAsUGVNlY3VyaXR5ICYgQXV0aGVudGljYXRp\nb24xHDAaBgNVBAMTE2Vib29rcy5vaGlvbGluay5lZHUxHjAcBgkqhkiG9w0BCQEW\nD2VzaGlja3NAb2FyLm5ldDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\nAMfwiApCJXnv/RKb7bUxZf2U29srENF7+5iHHxD/U+eLVlxjUhcdN8zGDefMF1q/\n0ILQxzyxfZ9JulCG+Y0bc4UMgsYa0Y9VMirWdb19PzzzZsjwYvc4vpVdpNmrI16b\n5UdN0L+lQy2vH//jBCezQ6TP4LL+iI9E/uX0NV9PSs9P/32Q6VypaLh2uMNdrqh6\nN3d+F1tv4kEhogLzTa3Db87a0SOQZdhhcT16+PcRrto7bK9zptAPVI42A/NiICzB\nGvp8QRzS4YtlwKLpETIpTsh8m3n99Dvvh6LAb36dpqMoyKSD95Dtm0VhoKThGuqk\naARZYK2hAumNBJBP4uBGF9kCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAiiHheynE\nsyqZoLx4Rjl+tOfQAXwAVT3kOeFF3pB9h67UplqyeKBVAGLZNEU5+r15UJ1X6m0c\nMt9tsCKnydkDDUmffBclokGh2o+zigpO9qtFkVOTms9gpaShSemJaTX5zhYGq0iS\n/5BFS3GS5Ft0wuMJ1dF3dRFRpneN85rXgvfU/N7F0kytBNkuWOqxsNk5ymzp98e/\ntZrzYRmyCAeBYJ842lwASWsCnFYjR2oPIYk/uPpp7ddhExtoHUq4Qvj2yfZvWjIz\nar/l2hgyK/eBaqXKFIWblZOGp3J2PfVgjRducDqG9K39wyZYT/bEgXJfHm3k0Xnf\nzuOEynhiSz9yCQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ebooks.ohiolink.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ebooks.ohiolink.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ebooks.ohiolink.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ebooks.ohiolink.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ebooks.ohiolink.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ebooks.ohiolink.edu/Shibboleth.sso/SAML2/ECP"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-richmond.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "noc@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:ucr.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Riverside", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Riverside", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucr.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Russ Harvey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "russ.harvey@ucr.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Mike Kennedy", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mikek@ucr.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Steve Hock", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shock@ucr.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://drc.ohiolink.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDwDCCAqgCCQDFF7ZQ/j/YLDANBgkqhkiG9w0BAQUFADCBoTELMAkGA1UEBhMC\nVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYDVQQKEwhP\naGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlvbjEZMBcG\nA1UEAxMQZHJjLm9oaW9saW5rLmVkdTEeMBwGCSqGSIb3DQEJARYPZXNoaWNrc0Bv\nYXIubmV0MB4XDTEwMDIwMTE1MTAyMVoXDTEzMDEzMTE1MTAyMVowgaExCzAJBgNV\nBAYTAlVTMQ0wCwYDVQQIEwRPaGlvMREwDwYDVQQHEwhDb2x1bWJ1czERMA8GA1UE\nChMIT2hpb0xJTksxIjAgBgNVBAsUGVNlY3VyaXR5ICYgQXV0aGVudGljYXRpb24x\nGTAXBgNVBAMTEGRyYy5vaGlvbGluay5lZHUxHjAcBgkqhkiG9w0BCQEWD2VzaGlj\na3NAb2FyLm5ldDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANcn61m2\nW7JdxyihI2+VTUv1uzPqYzouza0ZD0Q1pP9iXNcFK1b+cswJ2UKEtwt1cis6/KXS\nTA7+aVrWUlT6HQeXXdn+pYUlKapUZNctVwZfJq6hTajL+SXTC76YU+nfBVexak/4\nSMy460QiEl+Svh0rkZUVUknsDXEAwQK8m+drZMji8SI86EIMc3mkPr5rno9Lmy4C\nlX3nduYnHmjvsPe9NickeNo22WN/qbcy7LrWVBzW3iwhmUUqnAyDUTylHbIl4BuY\nWIkfUGQLcBf2DMmI6SOIj/jwLazn+FllkE0HXhUZJYRC5TTBUAGNo/x8NDVKA40y\n0WxuRGL9QKPjHFkCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEABgClsknXPNsY+tbb\n7c+jR++APph2pb08xegLJXU+A6s/0UCnAJVjLvwPHLq3EfIFQSKeMO3PiRHXOItR\nfXGtSJyMzlZcWNVtiE3dymRi//DcL8g6pd/WYf0DCG0iKOeLvbu6tQffCT68U0kr\nCWDiwZ1angZCkQ/oxMWidTzk5wQN4ckhWJUusAQYuIdmN4R8L8lGJDmiex7U2jkw\nVD4aVDeBggM5zQ03O+aTGf5VWXraAXIyJ4ZEHRJPvd4vzxx7/ve6m+8i97ru49pu\ntXZU1klec5C+tE4yRjZpBgIOHnYLpA1g+Z/r4q67wIMSeRG40fxUC6j/B4k3xMWa\n61BgzA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://drc.ohiolink.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://drc.ohiolink.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://drc.ohiolink.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://drc.ohiolink.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://drc.ohiolink.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://drc.ohiolink.edu/Shibboleth.sso/SAML2/ECP"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:ucdavis.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucdavis.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Infrastructure Systems Management", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "sysadmin@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Middleware Shibboleth Group", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibadmin@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://northwestern.illiad.oclc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Online Computer Library Center Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Online Computer Library Center Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.oclc.org", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Don Hamparian", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@oclc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jason Zavar", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@oclc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://northwestern.illiad.oclc.org/Shibboleth.sso/Login"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDWzCCAkOgAwIBAgIJANAywmmS8MDhMA0GCSqGSIb3DQEBBQUAMCcxJTAjBgNV\nBAMTHG5vcnRod2VzdGVybi5pbGxpYWQub2NsYy5vcmcwHhcNMDkxMTEwMjIyMDAz\nWhcNMTIxMTA5MjIyMDAzWjAnMSUwIwYDVQQDExxub3J0aHdlc3Rlcm4uaWxsaWFk\nLm9jbGMub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqxlZPI7A\nBMf+FYL6aP7fSH+CQdgDCtvkkE4gCZRP3yyDagIj2dbWZa3QXgpspB+T9FBOrF0G\njjMvUHO+EscXlZcGZaDdqk6mvNkdJCyR5XoU6Cz08ci777L6VA3qDGJMp/dcrfzt\nOXqNHwEJs9JauC/u/oQCn77YuJISHUEt7zeR4+CRGoedLNbuOMs60VQ+eKbRs5Vm\nMIjlEQvW/EKdDK0m7H1REi1oC+uAsP3YPKfptYEJl7RwOh3t4y8Mf/zouSTuKeeD\nUp0NFuIXVRAJEuQ5XGkBOQvA19oQlH0cRtRvMMleF2BlXBUYMZwv82ZNFJ0rlYw2\nEzTVi0D5ad/8qwIDAQABo4GJMIGGMB0GA1UdDgQWBBTYydoes4kkBTqtOsiSCt/x\nfdysfTBXBgNVHSMEUDBOgBTYydoes4kkBTqtOsiSCt/xfdysfaErpCkwJzElMCMG\nA1UEAxMcbm9ydGh3ZXN0ZXJuLmlsbGlhZC5vY2xjLm9yZ4IJANAywmmS8MDhMAwG\nA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAGDMlLiLUHrhoEVzXZjAHi6e\nhA8ekZ4aT5kpQxfMuRb72Tqh2AAE08+2+ty/G8cEvNgWPgrzqZZodWPn8OffcNxd\n34sMZV2EFP5T2EYwyfgsO1YkPfe4faI0IppjlCiBag9XWFDWPyWupmbNV+OpchLb\nSNwHmktDfB0pl/W/NO6do8K41p74hKA96VVRMWFlHZ1BG1MZjZQ+RsW9khkMPaac\n/kmEt9G4WAyFuYOIJ1EwMq5kMHHB7pOEiQodkFeWUZVVHuyriKKVaEEBB4Y4YmjG\nj22kl0ntodYDQdLTXJKucg8VgJpsGFZq8JcEe4aGCds54tjbgJ7W2/XKiRdXKes=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://northwestern.illiad.oclc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://northwestern.illiad.oclc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://vcl.calstate.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Office of the Chancellor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Office of the Chancellor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.calstate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Marcus Mizushima", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "iamadmin@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Gabriel Sroka", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "iamadmin@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://vcl.calstate.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFGzCCBAOgAwIBAgIJAMAtBE27wTVRMA0GCSqGSIb3DQEBBQUAMIG5MQswCQYD\nVQQGEwJVUzELMAkGA1UECBMCQ0ExEzARBgNVBAcTCkxvbmcgQmVhY2gxJDAiBgNV\nBAoTG0NhbGlmb3JuaWEgU3RhdGUgVW5pdmVyc2l0eTEhMB8GA1UECxMYT2ZmaWNl\nIG9mIHRoZSBDaGFuY2VsbG9yMRkwFwYDVQQDExB2Y2wuY2Fsc3RhdGUuZWR1MSQw\nIgYJKoZIhvcNAQkBFhVpYW1hZG1pbkBjYWxzdGF0ZS5lZHUwHhcNMTAwMjE5MTY0\nMDA1WhcNMTMwMjE4MTY0MDA1WjCBuTELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNB\nMRMwEQYDVQQHEwpMb25nIEJlYWNoMSQwIgYDVQQKExtDYWxpZm9ybmlhIFN0YXRl\nIFVuaXZlcnNpdHkxITAfBgNVBAsTGE9mZmljZSBvZiB0aGUgQ2hhbmNlbGxvcjEZ\nMBcGA1UEAxMQdmNsLmNhbHN0YXRlLmVkdTEkMCIGCSqGSIb3DQEJARYVaWFtYWRt\naW5AY2Fsc3RhdGUuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nn1Svr7Bhg/lRjWg7W5FSLZdZuxpXsbvGilc41OusxLtZPueRI4ZpxL9yjnYYzcM5\nRBG5FY4mVbTDFAydqifKDesnPKjf6SkhZ8EGRZ9sPKNzvI+u0rzGic4NPaWszs6l\nVYEXwXARdlPi2Yh1gymZ+dOZ2/8qxWQOeJK/66LfEh1xlQ8qWXmRWOEkgZNESRgN\n0vjoPfUtS8/4Z+qfWmvfgCxH0AfQf/RvoO60iuTrnpndm7D0ozMSsizxOePcAjh7\n0LQ0vmGJpvx5M2+jYVQfopf3KqO2/wd4Nm3jHn/bNevST2lNZpHJEWACewwr7a6o\nM3SFEHuHwE7ahnND8lYEBQIDAQABo4IBIjCCAR4wHQYDVR0OBBYEFCXs0iGTsWs4\nREH3CuvW8AhiIiETMIHuBgNVHSMEgeYwgeOAFCXs0iGTsWs4REH3CuvW8AhiIiET\noYG/pIG8MIG5MQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEzARBgNVBAcTCkxv\nbmcgQmVhY2gxJDAiBgNVBAoTG0NhbGlmb3JuaWEgU3RhdGUgVW5pdmVyc2l0eTEh\nMB8GA1UECxMYT2ZmaWNlIG9mIHRoZSBDaGFuY2VsbG9yMRkwFwYDVQQDExB2Y2wu\nY2Fsc3RhdGUuZWR1MSQwIgYJKoZIhvcNAQkBFhVpYW1hZG1pbkBjYWxzdGF0ZS5l\nZHWCCQDALQRNu8E1UTAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAB\nYtoZQAoo4cg/8yyjbio8jDjUIohq25WspzVKmFNX7rJmBvYC98UGzeJKw/gInO64\nXv7A13bbzGBRHwMxN9KVjMw6/r3iCu8iI4pjby1aehRaXHBQANdWvzhEBc3R0XRY\nf1pTLJCKCN3dU4VJAnw4G1HfCoEaj3yR3401UoChAmQM1vfieyjASPOjOcegZn0p\nS3fFQdQXfbvTCaqSfKdQKF8ggemcRoxIAH0ZR90RPTg/xZyvKPOKb8mbVW9SkhfV\nxLpRip8ia6eB41EYgvA74wZG/utGW2m1y/sLf0OGiy+tPkJNrq1LxfPkkySLAdRn\n8NmnlD0g/wfwl7CJLhOy", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://vcl.calstate.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://vcl.calstate.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://vcl.calstate.edu/Shibboleth.sso/SAML2/ECP"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://vcl.calstate.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:tamu.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Texas A & M University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Texas A & M University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.tamu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Xavier Chapa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "xchapa@tamu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Xavier Chapa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "xchapa@tamu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "urn:mace:incommon:rock.k12.nc.us": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFlzCCBH+gAwIBAgICAgcwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDQzMDE3NDc1NloXDTExMDUw\nMTE3NDc1NlowHjEcMBoGA1UEAxMTc2hpYi5yb2NrLmsxMi5uYy51czCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJQWXc1ZGPqo178kEkPjlgOn0xYL7ZgG\nVsPSiLOSLy9La4zsDGS4xmFs1KUXIq2/RFulywuQNmVvxblXyB2Du9BDnM8/u6Vu\nIfCUx24XZt56gtTlnkb90aSi9DfjBwVSFftxfOcT6VlalU86XjwPfB0SmiZIyz7X\nJh1mKwNfo+o1FyKXTrOASrssEAkxetjR6Lzcle0Pg6tsd0Zl0TUjQqG14L42tY15\nwgyElbY+dlA7I2QvFjjSm0Pkce6lpRRmKogie+5tPq4+xwg2sSFguas0Un2PE9Qy\nJzVEvG0edPiYVe+nCM4L5KvStbr5WaF5ADHaNbeBtqLUyQvB450kb3cCAwEAAaOC\nAqUwggKhMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQG\nCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUruM5s76Piz3hAqGOEkjj+R5z\nJIowfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNV\nBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJ\nbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEE\ngaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUH\nMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2Jy\naWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0\ncDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNy\nbHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQB\nATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHgYDVR0RBBcwFYITc2hpYi5yb2NrLmsx\nMi5uYy51czANBgkqhkiG9w0BAQUFAAOCAQEAir8tmZbDFXlbj3JcpCEB8DZ5WWBE\nT3OoJsYj17YDeedxr59411sBFFbgFDavelruim14RLb49OtUtv+FiuMLwO5pIEZq\nLvMhQYdNQCP8g/8YtGcOfsIHOUaNsM/tHU1dGe/lRK4XzmcMJt4/6oO+1BsKb8zs\nrcN6doZxG6EelZNbov9ZngKGCbvdW/ZwFf6Kjt0xA6B3Q5+wqQpXyVczK3gi+lCa\ngg2gXxXrSgrQA8H1tQAgLAIgyTOFf6dnAoub1BTbXiJv+IneI40hHtVtFb9eTQEg\nZqxDMqqSp5YTIIBY9YPs36Y+gpRUZ2HPlRRg9B9ha95ly7BRnMhdIng0TQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Lee Cummings", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "lcummings@rock.k12.nc.us", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Lee Cummings", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "lca@rock.k12.nc.us", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.rock.k12.nc.us/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.rock.k12.nc.us/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.rock.k12.nc.us/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.rock.k12.nc.us/idp/profile/SAML2/POST-SimpleSign/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFlzCCBH+gAwIBAgICAgcwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDQzMDE3NDc1NloXDTExMDUw\nMTE3NDc1NlowHjEcMBoGA1UEAxMTc2hpYi5yb2NrLmsxMi5uYy51czCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJQWXc1ZGPqo178kEkPjlgOn0xYL7ZgG\nVsPSiLOSLy9La4zsDGS4xmFs1KUXIq2/RFulywuQNmVvxblXyB2Du9BDnM8/u6Vu\nIfCUx24XZt56gtTlnkb90aSi9DfjBwVSFftxfOcT6VlalU86XjwPfB0SmiZIyz7X\nJh1mKwNfo+o1FyKXTrOASrssEAkxetjR6Lzcle0Pg6tsd0Zl0TUjQqG14L42tY15\nwgyElbY+dlA7I2QvFjjSm0Pkce6lpRRmKogie+5tPq4+xwg2sSFguas0Un2PE9Qy\nJzVEvG0edPiYVe+nCM4L5KvStbr5WaF5ADHaNbeBtqLUyQvB450kb3cCAwEAAaOC\nAqUwggKhMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQG\nCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUruM5s76Piz3hAqGOEkjj+R5z\nJIowfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNV\nBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJ\nbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEE\ngaUwgaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUH\nMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2Jy\naWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0\ncDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNy\nbHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQB\nATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHgYDVR0RBBcwFYITc2hpYi5yb2NrLmsx\nMi5uYy51czANBgkqhkiG9w0BAQUFAAOCAQEAir8tmZbDFXlbj3JcpCEB8DZ5WWBE\nT3OoJsYj17YDeedxr59411sBFFbgFDavelruim14RLb49OtUtv+FiuMLwO5pIEZq\nLvMhQYdNQCP8g/8YtGcOfsIHOUaNsM/tHU1dGe/lRK4XzmcMJt4/6oO+1BsKb8zs\nrcN6doZxG6EelZNbov9ZngKGCbvdW/ZwFf6Kjt0xA6B3Q5+wqQpXyVczK3gi+lCa\ngg2gXxXrSgrQA8H1tQAgLAIgyTOFf6dnAoub1BTbXiJv+IneI40hHtVtFb9eTQEg\nZqxDMqqSp5YTIIBY9YPs36Y+gpRUZ2HPlRRg9B9ha95ly7BRnMhdIng0TQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shib.rock.k12.nc.us:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Rockingham County Schools", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Rockingham County Schools", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.rock.k12.nc.us/rockingham/site/default.asp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://datajr.scps.virginia.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.virginia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jeffrey Wolford", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jw2w@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rick Downs", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rtd2m@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://db-demo.grnoc.iu.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Indiana University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Indiana University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.indiana.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "A.J. Ragusa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "aragusa@grnoc.iu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://db-demo.grnoc.iu.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFmTCCBIGgAwIBAgICAoowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkxNzE3NTU0M1oXDTExMDkx\nODE3NTU0M1owHzEdMBsGA1UEAxMUZGItZGVtby5ncm5vYy5pdS5lZHUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCmBy3iYrw30sbc+gSpXa+oI8eXvcAU\nPDZD//Ol1Cvw4O4l1KXXiExLedD4qIV6wT+B7uFdZLcQxKxWZt/vy/JN+dy0JJEn\nABGQd8F4kDf3pjalR+u7geJxFy8M2vhFRau5juGIk6/F43gGSlVT34cCQkhIKu1X\nU9hHt1iKPMXQdNDkM3wCrSW83DxuO/KC4KmG7raoInGg0l+fGvYN9eJfdauypH02\nF3nJjxwypyi2l5+k9wQs+W0cfLzvpXoVImsrkNvYtvl1arFAyrvUWpSKt6qyNphd\nTAMEn1R3ZTsAroX+TMO8NHT/U+rtimZ3Avd+x4jeRXHrjDZ5onfdf1IbAgMBAAGj\nggKmMIICojAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAU\nBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFNNEQwzZPWei74H3c7wpJ1/G\n+3rkMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYD\nVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMg\nSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEB\nBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUF\nBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9i\ncmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0\ndHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVj\ncmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEE\nAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMB8GA1UdEQQYMBaCFGRiLWRlbW8uZ3Ju\nb2MuaXUuZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQCe+2wSS97e9beAktKVe5JoFRXB\nzftLSxlsmw6MpTHoJfbKNDjl+4783uWiqzYZtYOw1vP1vxTEwX6MToGy160rgRzy\npp7RLO9UFQYxLaT2/stpHO+Z5wMWKdGwbp7ERecFPwIgjCT8vNtj6AMmvWbNYrfF\npMrwgHvNXMp9ZcI2uU5itCi56tcmYUvg+GS8ox+URHHQlAZWOgW8QzRjBYSlJvYB\nuxbBj7Qt9v0Hsty8koyDdudLXjsLdf0iLUe0oLi3iBLQTigjDwm/xg3bqT69OmcV\nFWVDqdEq+9onz3ny87iZNDe2ekEGGpKkNJYBx71WjvcGrqdrmBGjMNYz+5Xs", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://db-demo.grnoc.iu.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://db-demo.grnoc.iu.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://db-demo.grnoc.iu.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://db-demo.grnoc.iu.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://avalon.cns.ohiou.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Ohio University Main Campus", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Ohio University Main Campus", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiou.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "David Alexander", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "alexandd@ohio.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "OIT Service Desk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "servicedesk@ohio.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://ucaction-test.ucdavis.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucdavis.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Lowell Valiant", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "lavaliant@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKjCCAhKgAwIBAgIJAO1yrLVGmVYHMA0GCSqGSIb3DQEBBQUAMCwxKjAoBgNV\nBAMTIWF2aHItamF2YXRzdHZtLnRvdS50My51Y2RhdmlzLmVkdTAeFw0xMDAxMjgx\nODAwMzlaFw0yMDAxMjYxODAwMzlaMCwxKjAoBgNVBAMTIWF2aHItamF2YXRzdHZt\nLnRvdS50My51Y2RhdmlzLmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAKwZ5YO6nYD7QpUaM5WOvGdK+2FvcAn3AwcjQacPe2y0RIzcEV91+2vYQlYF\n/pTNay0w4EfPskXvXm8Sb31eZ/ayd5KjrENKd8ddqVmJG8TFZu0mVf2tH1yFKrv5\n4AzGi3N2WvhMSQAVlvpIzbxr3WH1WqcfL3RDIQ/jkbe7lGlpw8WiZZ2KZG2C/kkf\nZ11Sd8zn/zRTEQD6bX59ZcrwhVMg8syh9OS+HZXVkBl4znhFAwLHYy3T0QzavN1f\n+yuFiadKD391t5ExcxWPL/HyWWzLW8XCHds8aSzsfAw1LH55lcxDFmxCA5rDSopV\nI74Buf3GMzDyh7j3J8U+6hae+0MCAwEAAaNPME0wLAYDVR0RBCUwI4IhYXZoci1q\nYXZhdHN0dm0udG91LnQzLnVjZGF2aXMuZWR1MB0GA1UdDgQWBBTT8bK/EhEJ5ouz\n24vmHJQ4DXGjvzANBgkqhkiG9w0BAQUFAAOCAQEAc4RZQ/k5mvCP5F6or3cnQZFK\n5GBYYz/Q3UPZDUtNW/BIpNM2QOqhsHT8y/H/Ym3sIWxG7YjoqWsZDm1nOYjSWPGS\ntboX4LDVKZ+PwMFg3hj68D9Isl0lweRN3e/lNQkU4Uj5ydcI++6q1DznNzC83qkZ\n82iT1hSqznta6srE87r8oMR5WMvv7n4xvm/EpIBluM0E0KGu6QTnWGNgjm1B02fF\nqB+qxRwHYRZcZjVrZgqu+o4GZ0ufv82PL+DVfZX2jlX7i2Ad8EIuSqm2ZW2LKroz\n+QYLkFsA2IFU5o3JVrEufLmMvREskUIIW8X00LJd2X0Y6PChpqQjL/uvfbcqGQ==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ucaction-test.ucdavis.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ucaction-test.ucdavis.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ucaction-test.ucdavis.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://ucaction-test.ucdavis.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:sc.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bill Crayton", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bcrayton@sc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Bill Crayton", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bcrayton@sc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Roger Truesdale", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rogert@mailbox.sc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://us1.ready-qa.kuali.org/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Kuali Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "The Kuali Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.kuali.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ryan Means", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rmeans@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFDDCCA/SgAwIBAgIJAJSQPubR1nAYMA0GCSqGSIb3DQEBBQUAMIG0MQswCQYD\nVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8GA1UEBxMIQmVya2VsZXkx\nEzARBgNVBAoTClVDQmVya2VsZXkxDDAKBgNVBAsTA0lTVDEfMB0GA1UEAxMWdXMx\nLnJlYWR5LXFhLmt1YWxpLm9yZzE5MDcGCSqGSIb3DQEJARYqa3VhbGlyZWFkeS10\nZWNoLXN1cHBvcnRAbGlzdHMuYmVya2VsZXkuZWR1MB4XDTEwMDEyNzE5NDQwMVoX\nDTEwMDIyNjE5NDQwMVowgbQxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9y\nbmlhMREwDwYDVQQHEwhCZXJrZWxleTETMBEGA1UEChMKVUNCZXJrZWxleTEMMAoG\nA1UECxMDSVNUMR8wHQYDVQQDExZ1czEucmVhZHktcWEua3VhbGkub3JnMTkwNwYJ\nKoZIhvcNAQkBFiprdWFsaXJlYWR5LXRlY2gtc3VwcG9ydEBsaXN0cy5iZXJrZWxl\neS5lZHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDHWdwiHLz2ALzM\nyhHbTjquIcerl+pNyXrY6WnMNyzRaAGsP/HEOHAJKu55CD0F5v5ItLxRc6YyMuH9\nTpWtQcMIczm+xmCzU5HlaFzLon2Sqa1SPcsWKhjxWJgGUR6S0zNzYIO/pRDb0Ij3\nMffHEblQYbQYT0CVBl8hVtlM0x3sfElhN7xFAFIoB+n/OBPTosEcMvqmlYY47uJo\nzjEf5kJghdB3oWqjHnzt/FDEzmpkJjkgGLmfs7jVHTChwViO5YqtdX8biwzUnKV1\n93+EVC5gz5/IahEM88+X49MhuCeueGT3YF1KPROb7GUf+UnaeFIjPYjjuvQcTa/E\nJDwr8P3RAgMBAAGjggEdMIIBGTAdBgNVHQ4EFgQUICH6yJmnSBavjNAIcY5OTqbT\nW0UwgekGA1UdIwSB4TCB3oAUICH6yJmnSBavjNAIcY5OTqbTW0WhgbqkgbcwgbQx\nCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMREwDwYDVQQHEwhCZXJr\nZWxleTETMBEGA1UEChMKVUNCZXJrZWxleTEMMAoGA1UECxMDSVNUMR8wHQYDVQQD\nExZ1czEucmVhZHktcWEua3VhbGkub3JnMTkwNwYJKoZIhvcNAQkBFiprdWFsaXJl\nYWR5LXRlY2gtc3VwcG9ydEBsaXN0cy5iZXJrZWxleS5lZHWCCQCUkD7m0dZwGDAM\nBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAHjaB9n2CkNdaobN4Sl+YX\nJp7D1Cn9/J1m7AWK05pz9Ipe+DhoFNScTczptYhpAubgf5j+xkaJ1jx1pDF8/qQ7\nhqZCnFJacYeo4BQIU0B6gqRoKMoL4Q7xsRcXPp9Gs6qrOcA15kZNfoASr0E6A/5g\np60nyf4r4xGxJ0gaN7PLrEZ25lmbD5LrgGj/DNe5+PBTTWZvcoBmL1CIO64kaSng\nsDRIb6sTrDsX6OfwVyQPnQpOhAF72KqO10F8uvVRsQU+SYnKje56drU7JZIhpGlK\neYikK8PJiLHQARTKnrD1iAvU3AvPVKulWZSTlrPyhvZOw/qYX4gcoL1DSwpHphCY", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://us1.ready-qa.kuali.org/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://us1.ready-qa.kuali.org/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://idp.csusm.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHzCCAgegAwIBAgIURBObONYB1aVZUkchbN9Vm7i8Il4wDQYJKoZIhvcNAQEF\nBQAwGDEWMBQGA1UEAxMNaWRwLmNzdXNtLmVkdTAeFw0wOTA4MjQxNzQ1MDZaFw0y\nOTA4MjQxNzQ1MDZaMBgxFjAUBgNVBAMTDWlkcC5jc3VzbS5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCNxuYDajoiDXTQ4TvPcWGZy167mRRwlH1i\nrfxHV90o0XHKoL/FTJ3sh/Zj7S/7bCTPVB8mEXmIeTfGURUkwM8dSVeVLpX3j8jz\nDdtVhEGBxQUPtZsQPWt7vP+mk+w5t85nA8ShbKmvPNVS1kFBfb9+EYVVBwaN8aXH\nf0jXKVnt041DxOAXWGz958SaIetTVqa/P6XsBz6E9heulp3CgXSBLBlBQ/EKYcPz\n+NtLYG5iKbH9u6ka3zfTbefsZ1W/7fe8j416TgZdgUaKN7GNsgU9O/jCqHkGVURt\npN9/rtkN0feQhpcW8ZKWN727zmqbUIka6kPA8N0h8IVEMpgvzYCTAgMBAAGjYTBf\nMD4GA1UdEQQ3MDWCDWlkcC5jc3VzbS5lZHWGJGh0dHBzOi8vaWRwLmNzdXNtLmVk\ndS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUUWLdnhv2ZxtBMXDDAlaFWeDgDaYw\nDQYJKoZIhvcNAQEFBQADggEBAEuAj7CnXZppeRZ149EiZ4T54Gq6GNlIFzWfoD8Z\nsxiIOxcJbM/lJ9rXGtHwV5RE1cxNXncLMfA7XAtDoRtHIDQ+KL0JEd7hqjZFz2/1\njNXMxjNO8oQnTEqtwuo6yH8fKuAxHGAoLK1/ZXOC4MV4Gj265hhR2vUOp7WzRWKk\nIUnVPqjV3HQd+eTL4yQQM1s4NANaMsCoQ/u0C/j5C92ERrYmKZ3axgVh5iuEMcRI\nnoZH8nkxLFKIpQhm5kJlWq5YOKrdyTUF9lF7lD3YqacBcK/gctKBxbAmHwPqn2kc\nerUVBDmnMbYvO+WkO29HAl4Q0MbsXjQOm0C8cdFfI7gnehE=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.csusm.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "April Grommo", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "agrommo@csusm.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jonathan Fischer", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jfischer@csusm.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csusm.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csusm.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csusm.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHzCCAgegAwIBAgIURBObONYB1aVZUkchbN9Vm7i8Il4wDQYJKoZIhvcNAQEF\nBQAwGDEWMBQGA1UEAxMNaWRwLmNzdXNtLmVkdTAeFw0wOTA4MjQxNzQ1MDZaFw0y\nOTA4MjQxNzQ1MDZaMBgxFjAUBgNVBAMTDWlkcC5jc3VzbS5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCNxuYDajoiDXTQ4TvPcWGZy167mRRwlH1i\nrfxHV90o0XHKoL/FTJ3sh/Zj7S/7bCTPVB8mEXmIeTfGURUkwM8dSVeVLpX3j8jz\nDdtVhEGBxQUPtZsQPWt7vP+mk+w5t85nA8ShbKmvPNVS1kFBfb9+EYVVBwaN8aXH\nf0jXKVnt041DxOAXWGz958SaIetTVqa/P6XsBz6E9heulp3CgXSBLBlBQ/EKYcPz\n+NtLYG5iKbH9u6ka3zfTbefsZ1W/7fe8j416TgZdgUaKN7GNsgU9O/jCqHkGVURt\npN9/rtkN0feQhpcW8ZKWN727zmqbUIka6kPA8N0h8IVEMpgvzYCTAgMBAAGjYTBf\nMD4GA1UdEQQ3MDWCDWlkcC5jc3VzbS5lZHWGJGh0dHBzOi8vaWRwLmNzdXNtLmVk\ndS9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUUWLdnhv2ZxtBMXDDAlaFWeDgDaYw\nDQYJKoZIhvcNAQEFBQADggEBAEuAj7CnXZppeRZ149EiZ4T54Gq6GNlIFzWfoD8Z\nsxiIOxcJbM/lJ9rXGtHwV5RE1cxNXncLMfA7XAtDoRtHIDQ+KL0JEd7hqjZFz2/1\njNXMxjNO8oQnTEqtwuo6yH8fKuAxHGAoLK1/ZXOC4MV4Gj265hhR2vUOp7WzRWKk\nIUnVPqjV3HQd+eTL4yQQM1s4NANaMsCoQ/u0C/j5C92ERrYmKZ3axgVh5iuEMcRI\nnoZH8nkxLFKIpQhm5kJlWq5YOKrdyTUF9lF7lD3YqacBcK/gctKBxbAmHwPqn2kc\nerUVBDmnMbYvO+WkO29HAl4Q0MbsXjQOm0C8cdFfI7gnehE=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.csusm.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, San Marcos", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, San Marcos", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.csusm.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://vcl.ncsu.edu/sp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "North Carolina State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "North Carolina State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ncsu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Charles Brabec", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "brabec@ncsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://urizen2.cac.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jim Fox", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "fox@washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFITCCBAmgAwIBAgICAo4wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkyMjE3NTQyM1oXDTExMDky\nMzE3NTQyM1owJTEjMCEGA1UEAxMadXJpemVuMi5jYWMud2FzaGluZ3Rvbi5lZHUw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANmoX5JWhcoyxIFN1IqKmN3k4aSH\nYBRnn6NV8ZRbM5kaLFNftVG2iudOIMXdFDI0jC3If3El6+1JBEi5VopCDRCKThpw\nyUysJU4gyDlSTIGb8wFLpcc7o5BvpLlz9rZCUmXdHbYHxyJZNyi6ZE2cRDjCTMo/\nnvEtfHlCPIyM68pvAgMBAAGjggKsMIICqDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0T\nAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYE\nFHjeHd1No+0GU0hyYyxoIC0PZww8MH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2N\nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVk\nZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3Jp\ndHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5j\nb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2Et\nY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNV\nHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9u\nY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1Ud\nIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29t\nbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMCUGA1Ud\nEQQeMByCGnVyaXplbjIuY2FjLndhc2hpbmd0b24uZWR1MA0GCSqGSIb3DQEBBQUA\nA4IBAQBs1r9/kBveUyIBx/XcQg3W4ytGJTMZ6mIU88qjgbIYIeUe8/ItyngDzWUs\ndVBJTJXlYY/eaGwUuwzeEXitszdR9fh+h6jYaaoUAeZB8AHUKUpunWZ06qa842tu\ngGsOvZIIKKZh8dGCahLR2dcrLWUOe/RINV6sQvCO2iOnpIsYvBHyztwiBXNk44cd\n7ObSwiGyjb0j7qsP8+A4a2kqa0Q76pN76Pn+n9bwbLCEOPRpwm0vQSt321fr4WUJ\n0kdapwrnVVlnu/odrtH2N8PekbbrD3w6gYDtq4d8dpNEw5Zx1VB+Qk4rcGlQeVx4\n5Mg/2Dc5CH4WDn5xxaHSE/Z+9Scg", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://urizen2.cac.washington.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://urizen2.cac.washington.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://urizen2.cac.washington.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://urizen2.cac.washington.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-uww-sgms.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth-carleton-jams.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://itarch.stanford.edu/shibboleth/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Stanford University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.stanford.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bruce Vincent", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bvincent@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Scotty Logan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "swl@stanford.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:mlml.calstate.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFFzCCA/+gAwIBAgICAaUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDkwMjE4MTI0NloXDTEwMDkw\nMzE4MTI0NlowIDEeMBwGA1UEAxMVaWRwLW1sbWwuY2Fsc3RhdGUuZWR1MIGfMA0G\nCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC3+H/xWSJk24Zn3Y+uN6QtEjp1e054Y8eA\nZaCX8i7IqdD61q4B8AojKYFqzMshq5OyoZh4RXOkluohwRgn8FJD5AUuCiFx4G7w\nTZWx6cYimaw1pUv0625c4a5bn7LMAegevY49K9juDNIUtUVMhBNPW+17f6iMBPa2\nSmM53YcLqQIDAQABo4ICpzCCAqMwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQC\nMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQoC+H+\njQcA9IWSfHw5h2dpweRfsDB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pj\nRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRp\nb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEA\nMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9u\nY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRz\nLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGF\nMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBV\nMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNh\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAgBgNVHREEGTAX\nghVpZHAtbWxtbC5jYWxzdGF0ZS5lZHUwDQYJKoZIhvcNAQEFBQADggEBABobAEBq\nFaLOCsj/mLeLWtGGcoh1V5r16vT3a/abrg5/12w1THq9xJEfNc/GFkGRSeroV5pS\nAuPkWXgLGyCoCcY5CprrthPN+aJq4p9G6Ljsx+wNTLIRWLqCPMXIQHml1JX1SqA/\nnRIRAdQHNOBSK4rOmfl45i3OpFullmOpMj0lZPRL8M4mglG1PaOlx4314jDDEth6\n7P5tMsoElM2QA43ldwT+aCvknU0YLWUvVxdXLJIDzXKWgbtAZYp1TZPlW2s22qAH\n8JuIwo+QqnMjByIC4F++0uubHEDpAgwDCIJiAbEYy7QofDueMYuJNVWm6QGLQqEQ\nd2Vb+76A+Pjiz20=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp-mlml.calstate.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Jeff Arlt", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jarlt@mlml.calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "John Witkowski", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jwitkowski@mlml.calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "Marcus M. Mizushima", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mmizushima@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Gabriel Sroka", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gsroka@calstate.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp-mlml.calstate.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp-mlml.calstate.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp-mlml.calstate.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp-mlml.calstate.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFFzCCA/+gAwIBAgICAaUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDkwMjE4MTI0NloXDTEwMDkw\nMzE4MTI0NlowIDEeMBwGA1UEAxMVaWRwLW1sbWwuY2Fsc3RhdGUuZWR1MIGfMA0G\nCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC3+H/xWSJk24Zn3Y+uN6QtEjp1e054Y8eA\nZaCX8i7IqdD61q4B8AojKYFqzMshq5OyoZh4RXOkluohwRgn8FJD5AUuCiFx4G7w\nTZWx6cYimaw1pUv0625c4a5bn7LMAegevY49K9juDNIUtUVMhBNPW+17f6iMBPa2\nSmM53YcLqQIDAQABo4ICpzCCAqMwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQC\nMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQoC+H+\njQcA9IWSfHw5h2dpweRfsDB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pj\nRaFapFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRp\nb24xKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEA\nMIGyBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9u\nY2ExLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRz\nLnA3YjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGF\nMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBV\nMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNh\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAgBgNVHREEGTAX\nghVpZHAtbWxtbC5jYWxzdGF0ZS5lZHUwDQYJKoZIhvcNAQEFBQADggEBABobAEBq\nFaLOCsj/mLeLWtGGcoh1V5r16vT3a/abrg5/12w1THq9xJEfNc/GFkGRSeroV5pS\nAuPkWXgLGyCoCcY5CprrthPN+aJq4p9G6Ljsx+wNTLIRWLqCPMXIQHml1JX1SqA/\nnRIRAdQHNOBSK4rOmfl45i3OpFullmOpMj0lZPRL8M4mglG1PaOlx4314jDDEth6\n7P5tMsoElM2QA43ldwT+aCvknU0YLWUvVxdXLJIDzXKWgbtAZYp1TZPlW2s22qAH\n8JuIwo+QqnMjByIC4F++0uubHEDpAgwDCIJiAbEYy7QofDueMYuJNVWm6QGLQqEQ\nd2Vb+76A+Pjiz20=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp-mlml.calstate.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp-mlml.calstate.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Moss Landing Marine Laboratories", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Moss Landing Marine Laboratories", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mlml.calstate.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://usd-shibboleth.usd.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of South Dakota", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of South Dakota", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.usd.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jason Askew", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaskew@usd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Don Ticknor", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "dticknor@usd.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://sp.csd.sc.edu/shibboleth/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of South Carolina", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bill Crayton", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bcrayton@sc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Bill Crayton", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bcrayton@sc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Roger Truesdale", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rogert@mailbox.sc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.cic.psu.edu/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Pennsylvania State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Penn State", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.psu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Chris Hubing", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cjh@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Phil Devan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "pmd@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rich Cropp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rac@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://idp.csus.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFiTCCBHGgAwIBAgICAp8wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAxMzE3NTkwOFoXDTExMTAx\nNDE3NTkwOFowFzEVMBMGA1UEAxMMaWRwLmNzdXMuZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAsK3s8yjwINisx1tBv8/BaXvdawmKEnpOzAkz5G8H\ncca8nP1Rlp+tSXFTcnm8fdMj10TO1XLNbF6xOYtFXZ2pZykRz6tBeM4cxNUPLafP\nYQTCkKRZ7OXXqhacnZ7X2nUl+6JZYZpNAAjAl5pX0jznXCltQzHUx0DCE4z0CTny\nmVQ+6Q9Ou2w4giJEVEtgFvtUZFccxBM7ifV376GeRQKz83OMwWcvQZNvbHthbxc/\n1+Xhv4XgJhYMqXHYNG5Fkg4rX/dAsQHff4Ncdh+cCjGSzCQvxvKZNENFIwPPV2Cw\n1LXJEGy5R8dnG5KTZ9pmoF6whN7+70GUBxUJ3ENsiBqvvQIDAQABo4ICnjCCApow\nDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUH\nAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQA+XJi1NGtvakAmNAlHsMDqC2G7jB+BgNV\nHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0\ncDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2Nl\ncnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5j\nb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmww\nP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYI\nKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvcHJhY3RpY2VzLnBkZjAXBgNVHREEEDAOggxpZHAuY3N1cy5lZHUwDQYJKoZI\nhvcNAQEFBQADggEBAFglriksNFsyek2Q8Cmtkr98MAVA7Hw9IcNkoZ8d886nPcud\nATOziI1uHF/eavbd0n7voFgk3zOTnNTPpGKdiFvhqCx4PvsRm4UFuKcrU1Pl1OoY\nKivxKK2xGYlmJDEqbLu+k8Puta1AGfMNJq54xdv8bTKJMkxlR8ATJA7DlJd2YYy1\n0KLNf6rTBgNvL4EndNGD7sUHXyGsNea7ERSdYhP1VbC703V6dn6Qinhm2qwthgm3\nehMZ8k1NjYWDUUWO3GzrWr0L7ay9XgMSr6/5A3L2IVBaaPbhC2/XAVAl+YLpqaDw\nZGqHp4D/LP3T5x1Tr5iE1zNrNAVeaetMeqA2PGI=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.csus.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Brennan Pike", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idm@csus.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://idp.csus.edu/idp/error.jsp", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csus.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csus.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csus.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.csus.edu/idp/profile/Shibboleth/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFiTCCBHGgAwIBAgICAp8wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAxMzE3NTkwOFoXDTExMTAx\nNDE3NTkwOFowFzEVMBMGA1UEAxMMaWRwLmNzdXMuZWR1MIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAsK3s8yjwINisx1tBv8/BaXvdawmKEnpOzAkz5G8H\ncca8nP1Rlp+tSXFTcnm8fdMj10TO1XLNbF6xOYtFXZ2pZykRz6tBeM4cxNUPLafP\nYQTCkKRZ7OXXqhacnZ7X2nUl+6JZYZpNAAjAl5pX0jznXCltQzHUx0DCE4z0CTny\nmVQ+6Q9Ou2w4giJEVEtgFvtUZFccxBM7ifV376GeRQKz83OMwWcvQZNvbHthbxc/\n1+Xhv4XgJhYMqXHYNG5Fkg4rX/dAsQHff4Ncdh+cCjGSzCQvxvKZNENFIwPPV2Cw\n1LXJEGy5R8dnG5KTZ9pmoF6whN7+70GUBxUJ3ENsiBqvvQIDAQABo4ICnjCCApow\nDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUH\nAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQA+XJi1NGtvakAmNAlHsMDqC2G7jB+BgNV\nHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCBojBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZDaHR0\ncDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2Nl\ncnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8vaW5j\nb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmww\nP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQwQgYI\nKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvcHJhY3RpY2VzLnBkZjAXBgNVHREEEDAOggxpZHAuY3N1cy5lZHUwDQYJKoZI\nhvcNAQEFBQADggEBAFglriksNFsyek2Q8Cmtkr98MAVA7Hw9IcNkoZ8d886nPcud\nATOziI1uHF/eavbd0n7voFgk3zOTnNTPpGKdiFvhqCx4PvsRm4UFuKcrU1Pl1OoY\nKivxKK2xGYlmJDEqbLu+k8Puta1AGfMNJq54xdv8bTKJMkxlR8ATJA7DlJd2YYy1\n0KLNf6rTBgNvL4EndNGD7sUHXyGsNea7ERSdYhP1VbC703V6dn6Qinhm2qwthgm3\nehMZ8k1NjYWDUUWO3GzrWr0L7ay9XgMSr6/5A3L2IVBaaPbhC2/XAVAl+YLpqaDw\nZGqHp4D/LP3T5x1Tr5iE1zNrNAVeaetMeqA2PGI=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.csus.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.csus.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Sacramento", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Sacramento", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.csus.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:lbl.gov": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFDzCCA/egAwIBAgICAQowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDIyNjIxMDY1OVoXDTEwMDIy\nNjIxMDY1OVowGDEWMBQGA1UEAxMNbG9naW4ubGJsLmdvdjCBnzANBgkqhkiG9w0B\nAQEFAAOBjQAwgYkCgYEAv8BTqaDaMakSF3Pz0j0C2SSfKjIQnuPtHKkIulx0TmGe\nlhAx7bajbSMLSwxAoeprNQOmM97hlNQb/VEGtt1Tey9jK5qaA7E7iEiqB50FY5lr\n4snbWN1vgrKj86WBGPd3vwdCL/Rfd77PAa7H0MwvQk/FPbbnRnb7w5UxxeK7FxsC\nAwEAAaOCAqcwggKjMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1Ud\nJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUL8ePWOyiQ1yTqoni\nlE+3PskSqw4wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYx\nCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYD\nVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBugYIKwYB\nBQUHAQEEga0wgaowgacGCCsGAQUFBzAChoGaaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YgoJ\nCUNBIElzc3VlcnMgLSBVUkk6aHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGF\nMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBV\nMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNh\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAYBgNVHREEETAP\ngg1sb2dpbi5sYmwuZ292MA0GCSqGSIb3DQEBBQUAA4IBAQA6kww3iR6787BsSf/W\nmnooYfkIIvsf4WVtBpa1gRrJQE/E/yCBlMXbsZNeFR9yZI52UCdHTY88Qlzjo23r\nlBP9y6GiX8RIegiJK1ZEMnJ5uAGbxHRKQoEOgwRFeKSGb+9WyCV4UZyNUaJDid2G\nQjYwpmICNgLdWMQHWt68WEzLU6YLbRZdZaIbNBxkSXL5JsIQ+JqdhkM45O4zauXQ\n9poN+kUXsP/k0OT6lSWywGlP5X4NlC6DOa+a3mQZACq9GsQrIJ6/H58J4vJjXc7Z\n7mLiqP95E3qXd3mp2KoH+qIgPLlh6VYAg8mirld+sgN45HtAAy5C9XywmIqoiSyM\n0srQ", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }, 
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHzCCAgegAwIBAgIUWaUNclZjoQfm4ab+ttJmW3Oqs7swDQYJKoZIhvcNAQEF\nBQAwGDEWMBQGA1UEAxMNbG9naW4ubGJsLmdvdjAeFw0wODEwMzEyMzM2MjVaFw0y\nODEwMzEyMzM2MjVaMBgxFjAUBgNVBAMTDWxvZ2luLmxibC5nb3YwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCUWmS996rDiCDoR0+O6MM5ufJlH6JYK9vv\n1AHR29TrZXIv4xkddf8KdTEgXfS7nimbrqKO+rNnt4dvYGfG/BH2jyFhZH48EZMA\n7xzBqp9OTr4uG0J1b286ychnlZAkgqtich4FCQOkhSKWbt9XSudcsWNqSG/VRN9r\nWfqI16q74IFLm8ATUJDkTn+sG29rJcDTqADDlbA8gP3qBHXrPypfmEZChCnEpoUJ\n82w8KjwbyrRIUtOnFBkZsj8XD1Hlv6vASHXxgc7nAYP9zxXSlBFfg1oSMuyWZSXC\nvRmXb32H9I8wO+/8KvzmndzZzU1yw+KZcaMhxfTFUAwxfCDfHyZjAgMBAAGjYTBf\nMD4GA1UdEQQ3MDWCDWxvZ2luLmxibC5nb3aGJGh0dHBzOi8vbG9naW4ubGJsLmdv\ndi9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUm7bprLeALfsJXQkGskKJIbn7o00w\nDQYJKoZIhvcNAQEFBQADggEBAC7pPx/biv1uaWXHd77M0HS03VP5oazpjD8yt9TO\nkFST/Q3Jtsg3anxCfqaP/R2vcad8H722vFDZwGflImbZg3DNhF6Mj/pt3CuGpnIg\n7+6mXRTDNzaTKya4wX8RZdNMZ129n4LO+IVgjXZBBpGyNkPbu5D1dXuvsOdWH81B\n//GRSpTRrm0DB2rN6refGeRfHB7ZMVeWQVJFwr+51X+6OitKHLG6/xPqURI+x3mA\njMIMRq4HkXJG3HRnSAxxmy5CPoslaIvJEXvV1WGUe/1jSqCKfdVSf1SeN2KqfQyj\nXHl1TMy82/4cFm7JOZXiJx32LIlICdpcBIGU7dFwHmiVYJc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://login.lbl.gov:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "James Lee", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jelee@lbl.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Greg Haverkamp", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gahaverkamp@lbl.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "James Lee", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jelee@lbl.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "http://login.lbl.gov/incommon/error.html", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.lbl.gov/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.lbl.gov/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.lbl.gov/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://login.lbl.gov/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFDzCCA/egAwIBAgICAQowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDIyNjIxMDY1OVoXDTEwMDIy\nNjIxMDY1OVowGDEWMBQGA1UEAxMNbG9naW4ubGJsLmdvdjCBnzANBgkqhkiG9w0B\nAQEFAAOBjQAwgYkCgYEAv8BTqaDaMakSF3Pz0j0C2SSfKjIQnuPtHKkIulx0TmGe\nlhAx7bajbSMLSwxAoeprNQOmM97hlNQb/VEGtt1Tey9jK5qaA7E7iEiqB50FY5lr\n4snbWN1vgrKj86WBGPd3vwdCL/Rfd77PAa7H0MwvQk/FPbbnRnb7w5UxxeK7FxsC\nAwEAAaOCAqcwggKjMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1Ud\nJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUL8ePWOyiQ1yTqoni\nlE+3PskSqw4wfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYx\nCzAJBgNVBAYTAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYD\nVQQDEyBJbkNvbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBugYIKwYB\nBQUHAQEEga0wgaowgacGCCsGAQUFBzAChoGaaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YgoJ\nCUNBIElzc3VlcnMgLSBVUkk6aHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGF\nMIGCMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBV\nMFMGCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNh\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAYBgNVHREEETAP\ngg1sb2dpbi5sYmwuZ292MA0GCSqGSIb3DQEBBQUAA4IBAQA6kww3iR6787BsSf/W\nmnooYfkIIvsf4WVtBpa1gRrJQE/E/yCBlMXbsZNeFR9yZI52UCdHTY88Qlzjo23r\nlBP9y6GiX8RIegiJK1ZEMnJ5uAGbxHRKQoEOgwRFeKSGb+9WyCV4UZyNUaJDid2G\nQjYwpmICNgLdWMQHWt68WEzLU6YLbRZdZaIbNBxkSXL5JsIQ+JqdhkM45O4zauXQ\n9poN+kUXsP/k0OT6lSWywGlP5X4NlC6DOa+a3mQZACq9GsQrIJ6/H58J4vJjXc7Z\n7mLiqP95E3qXd3mp2KoH+qIgPLlh6VYAg8mirld+sgN45HtAAy5C9XywmIqoiSyM\n0srQ", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }, 
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHzCCAgegAwIBAgIUWaUNclZjoQfm4ab+ttJmW3Oqs7swDQYJKoZIhvcNAQEF\nBQAwGDEWMBQGA1UEAxMNbG9naW4ubGJsLmdvdjAeFw0wODEwMzEyMzM2MjVaFw0y\nODEwMzEyMzM2MjVaMBgxFjAUBgNVBAMTDWxvZ2luLmxibC5nb3YwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCUWmS996rDiCDoR0+O6MM5ufJlH6JYK9vv\n1AHR29TrZXIv4xkddf8KdTEgXfS7nimbrqKO+rNnt4dvYGfG/BH2jyFhZH48EZMA\n7xzBqp9OTr4uG0J1b286ychnlZAkgqtich4FCQOkhSKWbt9XSudcsWNqSG/VRN9r\nWfqI16q74IFLm8ATUJDkTn+sG29rJcDTqADDlbA8gP3qBHXrPypfmEZChCnEpoUJ\n82w8KjwbyrRIUtOnFBkZsj8XD1Hlv6vASHXxgc7nAYP9zxXSlBFfg1oSMuyWZSXC\nvRmXb32H9I8wO+/8KvzmndzZzU1yw+KZcaMhxfTFUAwxfCDfHyZjAgMBAAGjYTBf\nMD4GA1UdEQQ3MDWCDWxvZ2luLmxibC5nb3aGJGh0dHBzOi8vbG9naW4ubGJsLmdv\ndi9pZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUm7bprLeALfsJXQkGskKJIbn7o00w\nDQYJKoZIhvcNAQEFBQADggEBAC7pPx/biv1uaWXHd77M0HS03VP5oazpjD8yt9TO\nkFST/Q3Jtsg3anxCfqaP/R2vcad8H722vFDZwGflImbZg3DNhF6Mj/pt3CuGpnIg\n7+6mXRTDNzaTKya4wX8RZdNMZ129n4LO+IVgjXZBBpGyNkPbu5D1dXuvsOdWH81B\n//GRSpTRrm0DB2rN6refGeRfHB7ZMVeWQVJFwr+51X+6OitKHLG6/xPqURI+x3mA\njMIMRq4HkXJG3HRnSAxxmy5CPoslaIvJEXvV1WGUe/1jSqCKfdVSf1SeN2KqfQyj\nXHl1TMy82/4cFm7JOZXiJx32LIlICdpcBIGU7dFwHmiVYJc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://login.lbl.gov:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://login.lbl.gov:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Lawrence Berkeley National Laboratory", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Lawrence Berkeley National Laboratory", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.lbl.gov/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://shibtest.icts.uiowa.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Iowa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Iowa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uiowa.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Adam Harding", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "adam-harding@uiowa.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Ben Rogers", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ben-rogers@uiowa.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://catullus.sonnet.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "David Jones", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "drj2@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Brian McFarlane", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "samspade@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://psl-230.ucdavis.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucdavis.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Tom Poage", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tfpoage@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://sso.csumb.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFizCCBHOgAwIBAgICApswDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAwOTE3MDgzMloXDTExMTAx\nMDE3MDgzMlowGDEWMBQGA1UEAxMNc3NvLmNzdW1iLmVkdTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBALN8+nYi1O6eOdWM45pGEgSG/K94eRIYWJybavJx\n42YE6ekJGSPPmU92L+M5E+ESFUu+oXy0YWfEvOuI5PSoRvfBjeS6jMofcnHRnzvv\n+vfoEQdIKjkDiTp/tB/9ggX9V6MWxpP+hXB7wgqv7V+0R4FMs6lcHONqRdNrfdE0\nK6teorVEiWiJq8CJuUHzGq6Jxt1YArVrFn8CcZsPgy0B218Q0xDj5mp9wwQAi6ax\n6FaPPuKUgbPOYv8VzovwLaCZxFo9su0oOSW+GxQnCqeMgkOZCLQTCaNY7wdeNXp+\n2gn7mvC67O4uWf6ZJRIUobzLU7lo18Dm8X6MqPLUiR4SgqUCAwEAAaOCAp8wggKb\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUC6KlCB98bz+RaJydZyq3ZqyNXKswfgYD\nVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYTAlVT\nMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNvbW1v\nbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUwgaIw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKGQ2h0\ndHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9j\nZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2lu\nY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3Js\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIG\nCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL3ByYWN0aWNlcy5wZGYwGAYDVR0RBBEwD4INc3NvLmNzdW1iLmVkdTANBgkq\nhkiG9w0BAQUFAAOCAQEADINiuOQSVU3QnFlJEDsUNFZQf7LEhoj1S2NDNwALQ8Q6\nrKG/CDg1V5ves3tX8xwsM8FhW+KPJR1wKd6QnxsQvt+BEGxSV1jsOhpQjKa0oDmQ\n9Sn+YdfJn9f3iTn17B6tgZI5ngOY6HkZnhGtYrQ0KJ24hNBMQs7CqTYbA1eDxXaS\nVlrb/LPwut26OfziQnj+97HTDz4ex2pTkzOuskC7csDQDX4elWGMjYJIDN2dswZI\nNZkp1RZ6ac9X9y7eu9yI5eZGL8Oc9o5btU0A02TwZAheryrarsITh4FLKtVgivk2\nhrxoBGH+jmibPK4kGAdYItS9gF2QBBH+wRoIBWdBkw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://sso.csumb.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Isaac Davis-King", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idavis-king@csumb.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.csumb.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.csumb.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.csumb.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://sso.csumb.edu/idp/profile/SAML2/POST/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFizCCBHOgAwIBAgICApswDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAwOTE3MDgzMloXDTExMTAx\nMDE3MDgzMlowGDEWMBQGA1UEAxMNc3NvLmNzdW1iLmVkdTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBALN8+nYi1O6eOdWM45pGEgSG/K94eRIYWJybavJx\n42YE6ekJGSPPmU92L+M5E+ESFUu+oXy0YWfEvOuI5PSoRvfBjeS6jMofcnHRnzvv\n+vfoEQdIKjkDiTp/tB/9ggX9V6MWxpP+hXB7wgqv7V+0R4FMs6lcHONqRdNrfdE0\nK6teorVEiWiJq8CJuUHzGq6Jxt1YArVrFn8CcZsPgy0B218Q0xDj5mp9wwQAi6ax\n6FaPPuKUgbPOYv8VzovwLaCZxFo9su0oOSW+GxQnCqeMgkOZCLQTCaNY7wdeNXp+\n2gn7mvC67O4uWf6ZJRIUobzLU7lo18Dm8X6MqPLUiR4SgqUCAwEAAaOCAp8wggKb\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUC6KlCB98bz+RaJydZyq3ZqyNXKswfgYD\nVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYTAlVT\nMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNvbW1v\nbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUwgaIw\nTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKGQ2h0\ndHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9j\nZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2lu\nY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3Js\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIG\nCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24u\nb3JnL3ByYWN0aWNlcy5wZGYwGAYDVR0RBBEwD4INc3NvLmNzdW1iLmVkdTANBgkq\nhkiG9w0BAQUFAAOCAQEADINiuOQSVU3QnFlJEDsUNFZQf7LEhoj1S2NDNwALQ8Q6\nrKG/CDg1V5ves3tX8xwsM8FhW+KPJR1wKd6QnxsQvt+BEGxSV1jsOhpQjKa0oDmQ\n9Sn+YdfJn9f3iTn17B6tgZI5ngOY6HkZnhGtYrQ0KJ24hNBMQs7CqTYbA1eDxXaS\nVlrb/LPwut26OfziQnj+97HTDz4ex2pTkzOuskC7csDQDX4elWGMjYJIDN2dswZI\nNZkp1RZ6ac9X9y7eu9yI5eZGL8Oc9o5btU0A02TwZAheryrarsITh4FLKtVgivk2\nhrxoBGH+jmibPK4kGAdYItS9gF2QBBH+wRoIBWdBkw==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://sso.csumb.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://sso.csumb.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "California State University, Monterey Bay", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "California State University, Monterey Bay", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://csumb.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://ers.ucop.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California - Office of the President", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucop.edu/welcome.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Steven Hunter", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Steven.Hunter@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Munish Malik", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Munish.Malik@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Barbara Vanden Borre", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Barbara.VandenBorre@ucop.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://weblogin.pennkey.upenn.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFITCCBAmgAwIBAgICAoEwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDkwMTE0NTAzN1oXDTExMDkw\nMjE0NTAzN1owJTEjMCEGA1UEAxMad2VibG9naW4ucGVubmtleS51cGVubi5lZHUw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBALP9NGpryb+AO7WI073PRyFf/Ubj\n/6BdnQ4eyGWCQXdIBm3o6n2ebXl5a4ILivng66NIXB5PRYcrRPzjWnwIhySKc9ha\nnI9KISm8gDBZmsWH0co+E7XSmx8Qk29K4z8CmS5/9QjFsWqzd/j6vKKwIrzpgQ3D\nmtclQuC9xSaoJtEbAgMBAAGjggKsMIICqDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0T\nAQH/BAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYE\nFAHrEeQAS2Sbb1oJGYXx6hiHHasSMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2N\nk7rnymNFoVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVk\nZXJhdGlvbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3Jp\ndHmCAQAwgbIGCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5j\nb21tb25jYTEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2Et\nY2VydHMucDdiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNV\nHR8EgYUwgYIwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9u\nY3JsMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1Ud\nIARXMFUwUwYLKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29t\nbW9uY2EuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMCUGA1Ud\nEQQeMByCGndlYmxvZ2luLnBlbm5rZXkudXBlbm4uZWR1MA0GCSqGSIb3DQEBBQUA\nA4IBAQAim2fbrN+fASgiKbyS4CQFig8QlDq3/mgNYNXGMPFeXSz5UArbp1IhkoKN\nAqWd5dvw421Y9SI1qYfj4tw/dTAnEWu4U/TdFxSXUz0O++Fxybpgr5fm9Oyr6oqK\nSPpFy2FbXIDs2sPrLBReSN+2YP6rd5l7q4R5aiE9ssrxSPwNlH4R7BJ1c7lxKjKM\nTpUm/dcj6YHTIdgr6UFbZSWXIZncKZtb1y2QFAY+j2It2PX69zmVB7BMsK7AuFUw\nglyXhqM+eD6g7/Ir5lXcFdmhYM3vkadOFUjANmGUNbFZwp+s3xsgnAiQ75IbFVDF\nothoG4ur7QyTlqI1EgkVbZVBaSaZ", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://weblogin.pennkey.upenn.edu/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "UPenn WebLogin Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "weblogin-help@isc.upenn.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "UPenn WebLogin Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "weblogin-help@isc.upenn.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "UPenn WebLogin Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "weblogin-help@isc.upenn.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Pennsylvania", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Pennsylvania", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.upenn.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "urn:mace:incommon:davie.k12.nc.us": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Davie County Schools", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Davie County Schools", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.davie.k12.nc.us/Admin/index.cfm", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Eddie Greene", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "greenee@davie.k12.nc.us", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Butch Rooney", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rooneyb@davie.k12.nc.us", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Mary Orr", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "orrm@davie.k12.nc.us", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://tools.ncren.net/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFjzCCBHegAwIBAgICAqowDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAzMDE5MTQxOVoXDTExMTAz\nMTE5MTQxOVowGjEYMBYGA1UEAxMPdG9vbHMubmNyZW4ubmV0MIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEArHENlV/+qM5UF6kmzRro31h8cXVdziGWyfuA\nhUahCaglBtBBuwui5WCgvg8lB1wE5Eg2UXt9o3T/VKKxRDFkYYnNEZ/WeAABw6El\niLG7LVbjRgnz0bX7SVM/kvkkMY/M4MDxpLFaFdtNm3oZXgSoQ9MgsMZVSrRMOtsx\nGYPGP69jVdhc+js7KlqrgsC/hsWaJFkCLvg054ZmozyjzA9/gP6D9IdGKfp3M9nB\nzctwPTuOQOI0aMvRLmgKN7K+pgFEJl8Y1T+YFC9Cih3ix+ajUngDvOJFHJSJYb0j\nVR3Z48YwekJHku7eNTwTlmUnV1a5MbqWny2OIlnqJ7Us2ShWuwIDAQABo4ICoTCC\nAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYB\nBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBR3P2auUJJo4/Yb9ZmVed54RggFmzB+\nBgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkGA1UEBhMC\nVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29t\nbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcBAQSBpTCB\nojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEFBQcwAoZD\naHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdl\nL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlodHRwOi8v\naW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5j\ncmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMBBAEBMEQw\nQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg90b29scy5uY3Jlbi5uZXQw\nDQYJKoZIhvcNAQEFBQADggEBAC99T5WBucNWrEFYnY2gXq4fIjkmZzK3WWXW+SDd\nLiWC+UQ+X4Ki5OLKPL/FOCj1Okhi9kCYXDxiq/241Bg0LyhjXpsvs5Rm0TSRVyMs\nrdajSUqOwKH1ULStn0yB/OGHWeKfjsdpdmJcyCHQaFWo6lSFJpztuhJi2S6hy+WX\nxVmn89SotzCtbsbkobkzNKQSrSOCj55xVTCn8WTMXTaX64KIV7UjfsoaiV1gbd1M\nr0YtuHpDurol3+SyN48qArUDKMn6hrJLMkPZzsC/CVj4uBZrCFIba4qQH3Y/zguS\nW3ZPI1L1AviRoACgy0LTUmUYgpp5lWrfz8OO5uanQFCGV/4=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://tools.ncren.net/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://tools.ncren.net/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://e5demo.onthehub.com/Incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "E-academy, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "E-academy, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.e-academy.com/index.cfm", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Islam Gomaa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "InCommon@e-academy.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Islam Gomaa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "InCommon@e-academy.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Islam Gomaa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "InCommon@e-academy.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDJTCCAg2gAwIBAgIJANgRSJVLM53yMA0GCSqGSIb3DQEBBQUAMB4xHDAaBgNV\nBAMTE2U1ZGVtby5vblRoZUh1Yi5jb20wHhcNMTAwMjE3MjIwNTMzWhcNMTMwMjE2\nMjIwNTMzWjAeMRwwGgYDVQQDExNlNWRlbW8ub25UaGVIdWIuY29tMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAycrEtnlOCkIN96yPhS0PcIVY5vPeY1Jv\n+UjTt9GesIniyup7Y5zazoi0qijxh15mZOPKSCtAq5zR0WbE8q+9hJ05e2DMAVLr\nknJPxAqz5SuY+wV0Zo/ZprYlNHrsY36eBfvmYW53qeWfw2LiutLy7frnNusGyOfB\nR7FFJmyPDNOpgc5TMoSZAytDYCNn8f6kYJjzV5ikzyZ9zQoYHs3UZ3p2pRoaTgOU\nZeX8FNbm5ej07HrugFLm6LOHZUKxhMucEBi69Y3ik6qTo8tGFU+AFrZe7k0vnWuQ\nNoU97XalAmMax080Q1PiRBk88rSEQTx0rY6WH5NJTvmOeCaH/mhmgQIDAQABo2Yw\nZDBDBgNVHREEPDA6ghNlNWRlbW8ub25UaGVIdWIuY29thiNodHRwczovL2U1ZGVt\nby5vblRoZUh1Yi5jb20vQUFJVGVzdDAdBgNVHQ4EFgQUHI1mReD5CXBWP4yzs+GJ\nijeWfswwDQYJKoZIhvcNAQEFBQADggEBAIKk2WMNM26GqUJqsG9xK65YQW3/rP97\neaYn34OptGXvJRRvqkPDQWEwKBKnU0Rm9y+itLGIyR1pB2LYU1Q5B0Yy1yGf7wU+\nMYW5xAtX/NTavQ7EenSA+6vGCFAAjaadVF3vhq1UdpNNGzuNYRJNzwURJ6jXzW3W\n3XQ1XZDN63Of5NczPzOnNIB9vEnGr0Lavgcwa5jrq5EKSWlwHOM99aPvbS+yGXdH\n2l8LN+gIlYmE2LFyithGf6D8T9I6dm5eLlIN3cwe6CJYe8qXGH5njBdgxrIjFzfl\npNkHpTcYV1wma11MZT6x+8cpYKNMUp5uKtXA/pHXhXas2LKQWb0bgAA=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://e5demo.onthehub.com"
          }
        ]
      }
    ]
  }, 
  "https://sso.brown.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Brown University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Brown University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.brown.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Brown University Shibboleth Administrator", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idm-shib-admin@brown.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:muohio.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Miami University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Miami University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.muohio.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Dirk Tepe", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tepeds@muohio.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://iam.psu.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Pennsylvania State University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Penn State", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.psu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "James Vuccolo", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jvuccolo@psu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFAzCCA+ugAwIBAgICAqMwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MTAyMDE3NTQ1OFoXDTExMTAy\nMTE3NTQ1OFowFjEUMBIGA1UEAxMLaWFtLnBzdS5lZHUwgZ8wDQYJKoZIhvcNAQEB\nBQADgY0AMIGJAoGBAKslsQC+w+5X+e0icrUo6miHGjVBK0sDF3fEgItpc5SWx3me\nc0ycG+oDUg7t1AWNeN1q7vaM2cThMIKLu5PRJiB/GZKs1zlohH2kkliwz9fgAe0m\nSNXToZIJusltAPkUNr0zkUpd0xHxfawIyuzM7Yb5VglhGq0gCtatBuiL0N5jAgMB\nAAGjggKdMIICmTAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUE\nFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFGat/839cVUt/Up801ES\n+/YCrsYqMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQsw\nCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UE\nAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUF\nBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsG\nAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuG\nOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwv\nZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGu\nIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25m\nZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMBYGA1UdEQQPMA2CC2lhbS5wc3Uu\nZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQDC8z2FSpfgzNC1XTe2cwWr/hee4I6oXprP\nwxFCYYNoridGEUzbhCHcgiDYj06qHfQUDfJ8gV8/wD0htklFgs04NY0KAOBAeGVL\nAZdd7JI0f6EY2j0ZeHpfRPhDg//BlB61WZiG7aNqJYq9/U7H99w1JYaxs8HGWQec\nCeueg4zpKgBk1grhf35pc2j+x9qF51mfv8ixA7mZI1AIwG1huHXADL+SXYlXDzAF\nS3ivVZQMzMSqm6fgENa00qOGbGjkCIj4GG88b7a3vEhI9YRl+T5oMghhsuovWskW\nmOnVZiht1xDbkY2+/MI/QOp+AjFjaAXvljq5okqzUw3QvI2SXK1j", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://iam.psu.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://iam.psu.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://aquamarine.apple.com/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Apple Computer, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.apple.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Yuemin Yu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "itunesu-shib@group.apple.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://us1.ready-staging.kuali.org/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Kuali Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "The Kuali Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.kuali.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Ryan Means", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rmeans@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFGzCCBAOgAwIBAgIJAKS6g2h0OikRMA0GCSqGSIb3DQEBBQUAMIG5MQswCQYD\nVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8GA1UEBxMIQmVya2VsZXkx\nEzARBgNVBAoTClVDQmVya2VsZXkxDDAKBgNVBAsTA0lTVDEkMCIGA1UEAxMbdXMx\nLnJlYWR5LXN0YWdpbmcua3VhbGkub3JnMTkwNwYJKoZIhvcNAQkBFiprdWFsaXJl\nYWR5LXRlY2gtc3VwcG9ydEBsaXN0cy5iZXJrZWxleS5lZHUwHhcNMTAwMTI3MTk0\nODE5WhcNMTAwMjI2MTk0ODE5WjCBuTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCkNh\nbGlmb3JuaWExETAPBgNVBAcTCEJlcmtlbGV5MRMwEQYDVQQKEwpVQ0JlcmtlbGV5\nMQwwCgYDVQQLEwNJU1QxJDAiBgNVBAMTG3VzMS5yZWFkeS1zdGFnaW5nLmt1YWxp\nLm9yZzE5MDcGCSqGSIb3DQEJARYqa3VhbGlyZWFkeS10ZWNoLXN1cHBvcnRAbGlz\ndHMuYmVya2VsZXkuZWR1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\n1lsGG2tmB308ilw1GFn2ElCsAEBbtNwEHZvbMEdn1YFFpwZ1Rmttwq+wKbW4P3+l\n1Zww99A7KR2iZAclJzPl4ADh5xBkL5GepGNcrYmC3bK5eD71hqPSta8E9AflkTZD\nFHuI+3KiKK0uJQXOrAJ6eylC7f8FM/I0yuS/rzP+umSiaiyI/bIdqwFDdW2T93BJ\ncAFAGGPPcb2Uzezc6fU6897pQjHbtRTrfw51zQyrKVqManBMqQaKzmxOBNxvygJu\nrb1p/vNRlYeFQBdWkm+83NL+ltJRPHK+LvCzPW8L17SxwHl8v3WFB7vKtEtPzp81\ne8hEIzOBFI9mxK2s841E/QIDAQABo4IBIjCCAR4wHQYDVR0OBBYEFHk82GqzxFKz\nRIuxO48SNfaV4O7PMIHuBgNVHSMEgeYwgeOAFHk82GqzxFKzRIuxO48SNfaV4O7P\noYG/pIG8MIG5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8G\nA1UEBxMIQmVya2VsZXkxEzARBgNVBAoTClVDQmVya2VsZXkxDDAKBgNVBAsTA0lT\nVDEkMCIGA1UEAxMbdXMxLnJlYWR5LXN0YWdpbmcua3VhbGkub3JnMTkwNwYJKoZI\nhvcNAQkBFiprdWFsaXJlYWR5LXRlY2gtc3VwcG9ydEBsaXN0cy5iZXJrZWxleS5l\nZHWCCQCkuoNodDopETAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCv\n90m2FEpxdvpT43XIr7w2z5RyFmzSQ1PuqsU/DhE37pD2bDH7W05504/wmR+m045B\nHmoZHSn0Ap2FJ0ULPPc3P8g2QE+F0XB5/NwVecpxbyFFdhkWsVu4zZEjP5YJGJZ9\nXpnhUBEqVKdNXPYv/Ll2GTKKXmsvaPC0bUloNpV9mR+gdsPzkI/OdYQCV0WlsMNQ\n5lgY9aQ7r6SNkeRTdV94d3NO/0mRkeZCw8J2uQtUgbJrYQJbyt27BRA48lwHw4C5\nDdRIpDR1HDD1mqXZU+LS9XDwr3tHFsn7iXC5uW6V9oMT2tWJjd8kX/laogUdQYWc\nIEimW7XVfmty/sZTardI", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://us1.ready-staging.kuali.org/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://us1.ready-staging.kuali.org/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://www.indianactsi.org": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Indiana University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Indiana University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.indiana.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Rahul Doshi", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rdoshi@indiana.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:ohiolink.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDxjCCAq4CCQDlSky+B2NqwzANBgkqhkiG9w0BAQUFADCBpDELMAkGA1UEBhMC\nVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYDVQQKEwhP\naGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlvbjEcMBoG\nA1UEAxMTYXV0aGRiLm9oaW9saW5rLmVkdTEeMBwGCSqGSIb3DQEJARYPZXNoaWNr\nc0BvYXIubmV0MB4XDTEwMDIwMTE1MjU0M1oXDTEzMDEzMTE1MjU0M1owgaQxCzAJ\nBgNVBAYTAlVTMQ0wCwYDVQQIEwRPaGlvMREwDwYDVQQHEwhDb2x1bWJ1czERMA8G\nA1UEChMIT2hpb0xJTksxIjAgBgNVBAsUGVNlY3VyaXR5ICYgQXV0aGVudGljYXRp\nb24xHDAaBgNVBAMTE2F1dGhkYi5vaGlvbGluay5lZHUxHjAcBgkqhkiG9w0BCQEW\nD2VzaGlja3NAb2FyLm5ldDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\nALK7YRvebxVsCmyP+++BDUUsZQfpKmTWqAahES4jOqeiRNroYOPgH2zk7GA1Xc46\nL12XMJCfQ/4du6wD2ojrV4bblhaYBQOx/46mbtJDwfRG2uxTg875vkrxo3haRqbO\nf0Ur6HAdjzGwuO2rPHCcl3JGom6DMWibgiE5KJY+qepguo+31lozAvqpt+r7xAGU\nJI70iyBedKvQSMcxm/S0LpCQ9IAHvvtKaogVWxFsCQPm/KlTgHO70z3Q1w4uU9la\nHzyK5v0ubeSoC2yJnxl3oG9O66Q5K8zx9pN7tHw38A3z3jPton/l8y8WsMsCdqFQ\nGUKXEy/arXx1ZvdRVQrBGD0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAD+6CTEaJ\nzs5MiqQUWQJLXAJ0+u1SgYmPiEWe6a0oBsmU5xpdC74ZBYfRlAn5s7Oni9RC+vU0\nwproGCSO33ISM0iT09SZ4N2XapQ75p4EF9CffzRDRB7L3WiHKBrF+wGld9R3PHs4\nih1FLlAyfnVz5tTSotu6mzhHZLnnAx6KV+Tc7yZeB86LXIACScBbD5uJZK6snLzQ\ncYZwaxpFtbiVQDZZuA4I+vUkpuK2QVLgAOuyKG7naPMtb2UvjqGBW097m5uxjHAP\nT9LKck5LS0EE1zfTwYgS1UZ+bQ9YS7x28lVVrJtdNcAYQEnnZ7NdKKI17xJjipio\nE/HVpGNqJPcT3g==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://authdb.ohiolink.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "E. Stuart Hicks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "eshicks@oar.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Celeste Feather", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "celeste@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "OhioLINK Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@ohiolink.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://authdb.ohiolink.edu/shibboleth/"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://authdb.ohiolink.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://authdb.ohiolink.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://authdb.ohiolink.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDxjCCAq4CCQDlSky+B2NqwzANBgkqhkiG9w0BAQUFADCBpDELMAkGA1UEBhMC\nVVMxDTALBgNVBAgTBE9oaW8xETAPBgNVBAcTCENvbHVtYnVzMREwDwYDVQQKEwhP\naGlvTElOSzEiMCAGA1UECxQZU2VjdXJpdHkgJiBBdXRoZW50aWNhdGlvbjEcMBoG\nA1UEAxMTYXV0aGRiLm9oaW9saW5rLmVkdTEeMBwGCSqGSIb3DQEJARYPZXNoaWNr\nc0BvYXIubmV0MB4XDTEwMDIwMTE1MjU0M1oXDTEzMDEzMTE1MjU0M1owgaQxCzAJ\nBgNVBAYTAlVTMQ0wCwYDVQQIEwRPaGlvMREwDwYDVQQHEwhDb2x1bWJ1czERMA8G\nA1UEChMIT2hpb0xJTksxIjAgBgNVBAsUGVNlY3VyaXR5ICYgQXV0aGVudGljYXRp\nb24xHDAaBgNVBAMTE2F1dGhkYi5vaGlvbGluay5lZHUxHjAcBgkqhkiG9w0BCQEW\nD2VzaGlja3NAb2FyLm5ldDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\nALK7YRvebxVsCmyP+++BDUUsZQfpKmTWqAahES4jOqeiRNroYOPgH2zk7GA1Xc46\nL12XMJCfQ/4du6wD2ojrV4bblhaYBQOx/46mbtJDwfRG2uxTg875vkrxo3haRqbO\nf0Ur6HAdjzGwuO2rPHCcl3JGom6DMWibgiE5KJY+qepguo+31lozAvqpt+r7xAGU\nJI70iyBedKvQSMcxm/S0LpCQ9IAHvvtKaogVWxFsCQPm/KlTgHO70z3Q1w4uU9la\nHzyK5v0ubeSoC2yJnxl3oG9O66Q5K8zx9pN7tHw38A3z3jPton/l8y8WsMsCdqFQ\nGUKXEy/arXx1ZvdRVQrBGD0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAD+6CTEaJ\nzs5MiqQUWQJLXAJ0+u1SgYmPiEWe6a0oBsmU5xpdC74ZBYfRlAn5s7Oni9RC+vU0\nwproGCSO33ISM0iT09SZ4N2XapQ75p4EF9CffzRDRB7L3WiHKBrF+wGld9R3PHs4\nih1FLlAyfnVz5tTSotu6mzhHZLnnAx6KV+Tc7yZeB86LXIACScBbD5uJZK6snLzQ\ncYZwaxpFtbiVQDZZuA4I+vUkpuK2QVLgAOuyKG7naPMtb2UvjqGBW097m5uxjHAP\nT9LKck5LS0EE1zfTwYgS1UZ+bQ9YS7x28lVVrJtdNcAYQEnnZ7NdKKI17xJjipio\nE/HVpGNqJPcT3g==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://authdb.ohiolink.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://authdb.ohiolink.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "OhioLink", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohiolink.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://pcard.finance.ucla.edu/shibboleth/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Hemkant Patil", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hpatil@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Brian Kim", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bkim@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "AP HelpDesk", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ap@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "urn:mace:incommon:duke.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFkzCCBHugAwIBAgICAbIwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDkxOTE4MTExNVoXDTEwMDky\nMDE4MTExNVowHDEaMBgGA1UEAxMRc2hpYi5vaXQuZHVrZS5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZLnQ/SNUArYDHOXG9bqiCcAFgR0c6PRIB\nQgKSG8xS+gZGYKLBko8XiB1k4NQSmf+OPrJUk2uWyqVhF1RgabYnHK9HuQcF7uV0\nVkOkMVX8VAWl96ltzm+R7GVLh30+YjAZMBzoFTPHXbww++ntmMrxQ3YMNYq7hNwB\nJWnNUpFqNHqR2rtdmSu3If8XO39tnJiPyEp/mstVVzU7O2ltOXe8M5mtrjEXHohq\nMxLR3/Nyeb46SvqLDr1kTa+v6BnD1tZlujuR5ArN3a7aNJGN/q/xaXCEg5OVSl7W\nu36x9VkvMHPJytJ7eDGhBxshReiwZJb+dIDb0DPOssKIJegkjminAgMBAAGjggKj\nMIICnzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggr\nBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFKs6ASVxYi5YHvK45Bc0Is8E9VXs\nMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQG\nEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5D\nb21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGl\nMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAC\nhkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlk\nZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6\nLy9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxz\nLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEw\nRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9wcmFjdGljZXMucGRmMBwGA1UdEQQVMBOCEXNoaWIub2l0LmR1a2Uu\nZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQCf66Rd9fSCcrC6wq4VYAyC451Oamzfj9Xy\nSJzXbntT5TvDhxZrvEaBKE8HZK94ncwvd9BmgZucfW3SVkPwJjrWBiVD9waUyoyv\nKywQ/UjB0Hhf1LP2SHedtKeMH4NvatA40Udf3DZUqdf9rtjer9gcUgahx0iHWKX0\ns6C4rpghXJuZ1U/Iu5+r0uGIqFfvgf00vJpJ0bo0ExnEynetfN/4MudmKHMv0RRT\nSL/7kkDOvYdwAer+PKXkHWXzEJLA8uuvjDSpfyMubJQP+P6L2BvtKLMirckMiIAG\nlFB8YmSPRPc1VCtXe/LbLmG51ge3ykYpT+/r3ckhtnOuDMB4cbO1", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://shib.oit.duke.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Shilen Patel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idmstech@duke.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Shilen Patel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "idmstech@duke.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.oit.duke.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.oit.duke.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.oit.duke.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shib.oit.duke.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFkzCCBHugAwIBAgICAbIwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDkxOTE4MTExNVoXDTEwMDky\nMDE4MTExNVowHDEaMBgGA1UEAxMRc2hpYi5vaXQuZHVrZS5lZHUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZLnQ/SNUArYDHOXG9bqiCcAFgR0c6PRIB\nQgKSG8xS+gZGYKLBko8XiB1k4NQSmf+OPrJUk2uWyqVhF1RgabYnHK9HuQcF7uV0\nVkOkMVX8VAWl96ltzm+R7GVLh30+YjAZMBzoFTPHXbww++ntmMrxQ3YMNYq7hNwB\nJWnNUpFqNHqR2rtdmSu3If8XO39tnJiPyEp/mstVVzU7O2ltOXe8M5mtrjEXHohq\nMxLR3/Nyeb46SvqLDr1kTa+v6BnD1tZlujuR5ArN3a7aNJGN/q/xaXCEg5OVSl7W\nu36x9VkvMHPJytJ7eDGhBxshReiwZJb+dIDb0DPOssKIJegkjminAgMBAAGjggKj\nMIICnzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAUBggr\nBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFKs6ASVxYi5YHvK45Bc0Is8E9VXs\nMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBWMQswCQYDVQQG\nEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcGA1UEAxMgSW5D\nb21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsGAQUFBwEBBIGl\nMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8GCCsGAQUFBzAC\nhkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlk\nZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9oDuGOWh0dHA6\nLy9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxz\nLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYBBAGuIwEEAQEw\nRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9wcmFjdGljZXMucGRmMBwGA1UdEQQVMBOCEXNoaWIub2l0LmR1a2Uu\nZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQCf66Rd9fSCcrC6wq4VYAyC451Oamzfj9Xy\nSJzXbntT5TvDhxZrvEaBKE8HZK94ncwvd9BmgZucfW3SVkPwJjrWBiVD9waUyoyv\nKywQ/UjB0Hhf1LP2SHedtKeMH4NvatA40Udf3DZUqdf9rtjer9gcUgahx0iHWKX0\ns6C4rpghXJuZ1U/Iu5+r0uGIqFfvgf00vJpJ0bo0ExnEynetfN/4MudmKHMv0RRT\nSL/7kkDOvYdwAer+PKXkHWXzEJLA8uuvjDSpfyMubJQP+P6L2BvtKLMirckMiIAG\nlFB8YmSPRPc1VCtXe/LbLmG51ge3ykYpT+/r3ckhtnOuDMB4cbO1", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shib.oit.duke.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://shib.oit.duke.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Duke University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Duke University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.duke.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://emp274.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Thomas Valdez", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "thomas.valdez@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Heather Tufts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "heather.tufts@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFCzCCA/OgAwIBAgICAZUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDgxMjE4NDgxM1oXDTEwMDgx\nMzE4NDgxM1owGjEYMBYGA1UEAxMPcGVvcGxlYWRtaW4uY29tMIGfMA0GCSqGSIb3\nDQEBAQUAA4GNADCBiQKBgQDdAujQPFfA3SJbvATaV3ZOyrU0pR+XTYxt1YscwGWB\n65oJpinlJVt8EX6Wv57UiRd1qNUmvxOKzQy+yMRBsc4g+whvaeumiLgz2Qlhp8g1\nSNsR/gmVYPLOLNzmVPrX7XNKNli5+DOqtq5F4+9ou8bwqiqzRFy+lPWYLgYMvegh\n/wIDAQABo4ICoTCCAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQ2Nt7DOvqITu4x\nRqumCysoiZP7WTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgw\nVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAn\nBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggr\nBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+g\nPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysG\nAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9wZW9w\nbGVhZG1pbi5jb20wDQYJKoZIhvcNAQEFBQADggEBADiiC7+8367p+Rgdzpiul67Y\nrci//XYMt5eklnWSDDnILTxCmnZ/9qBnpARjzIIyUToU8qR53F8UHjpp3SAzLgxA\nCiQWSIWOzoqAJHKfKeQNID51wKLH5BP+6YD52+Q8ufjZgpYierKqLcJqtf+WaQGX\n36kVQP38uI3zK7jHnr28mN5OCEyKPAV+4Rs2KwxG+6rQ/NjBM+W0Y/k34Uguk2XM\nMOvH3xJ+SwsQJBcjigErJwsl1zOZxlvHEg8/p719H/dK8ZbZROHw2z5LMoCdwMmf\nIFJDINAoOBl+1Mb5A0xgbbDpQbh1/+KLgd+rOdA1ko6m0o4bfxAQHuM8M7xJsSc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://jobs.ufl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cs274.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://training274.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://test42.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "urn:mace:incommon:internet2.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHTCCBAWgAwIBAgICAQ0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDIyODIxMTg1MVoXDTEwMDIy\nODIxMTg1MVowHzEdMBsGA1UEAxMUb3JpZ2luLmludGVybmV0Mi5lZHUwgZ8wDQYJ\nKoZIhvcNAQEBBQADgY0AMIGJAoGBAPVmhDcRQHvtJ4OMyo9NlJT8/5Cl85040fLJ\npli+S+2+6ijWZGThHLkD19PLY85ocKp9lKkMShE6URGyxaQrf93CPyD4gd/aYIqU\nqoHSwvj9hu3UGd+dsLFbL4407hj2ELa4Asq/ox4/MPGgSzTM0d9mQtUdGOYa3XY2\nJeSmGWWRAgMBAAGjggKuMIICqjAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIw\nADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFNWWyl5+\nbV1RxZM5xCST13tH+AeBMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNF\noVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlv\nbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAw\ngboGCCsGAQUFBwEBBIGtMIGqMIGnBggrBgEFBQcwAoaBmmh0dHA6Ly9pbmNvbW1v\nbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0\ncy5wN2IKCQlDQSBJc3N1ZXJzIC0gVVJJOmh0dHA6Ly9pbmNvbW1vbmNhMi5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0G\nA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21t\nb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYD\nVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5j\nb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHwYD\nVR0RBBgwFoIUb3JpZ2luLmludGVybmV0Mi5lZHUwDQYJKoZIhvcNAQEFBQADggEB\nAGrV1Zdj5FM8FgKHbNO62r5ZaE2NlYLwDy1EYKWov2knbT9JHvYx+MH46xL7vCwX\nR/gFNOZ2bQAPWVlRwA/vgOcRaUCiY16EoXYRlPtV5iheGgZmf6t5cwekNM0fTE9r\nkHYyIGXQeH5nXzckOlBLqMQvla3qr8AjIYDS/bGAlUnLipo0jb30RucpKQVMa72U\nKae26sd7MUM7apEXibOIZ0ulHD18Bx3cwkEbNzjqO7Fhie4eHP7YLfZ4qqiwHIan\naDAvd3cq7kfauomnRFfk5m6If5r8CARRt/9ddJQJ2fR+UTVgq4Y0vrArC1RWlHCU\nfNWyS+DPScAAr7W2Ia1K8T8=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://origin.internet2.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Tech Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "techsupport@internet2.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://origin.internet2.edu/error.html", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://origin.internet2.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://origin.internet2.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://origin.internet2.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://origin.internet2.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFHTCCBAWgAwIBAgICAQ0wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDIyODIxMTg1MVoXDTEwMDIy\nODIxMTg1MVowHzEdMBsGA1UEAxMUb3JpZ2luLmludGVybmV0Mi5lZHUwgZ8wDQYJ\nKoZIhvcNAQEBBQADgY0AMIGJAoGBAPVmhDcRQHvtJ4OMyo9NlJT8/5Cl85040fLJ\npli+S+2+6ijWZGThHLkD19PLY85ocKp9lKkMShE6URGyxaQrf93CPyD4gd/aYIqU\nqoHSwvj9hu3UGd+dsLFbL4407hj2ELa4Asq/ox4/MPGgSzTM0d9mQtUdGOYa3XY2\nJeSmGWWRAgMBAAGjggKuMIICqjAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIw\nADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFNWWyl5+\nbV1RxZM5xCST13tH+AeBMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNF\noVqkWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlv\nbjEpMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAw\ngboGCCsGAQUFBwEBBIGtMIGqMIGnBggrBgEFBQcwAoaBmmh0dHA6Ly9pbmNvbW1v\nbmNhMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0\ncy5wN2IKCQlDQSBJc3N1ZXJzIC0gVVJJOmh0dHA6Ly9pbmNvbW1vbmNhMi5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0G\nA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMS5pbmNvbW1vbmZl\nZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMD+gPaA7hjlodHRwOi8vaW5jb21t\nb25jcmwyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYD\nVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBEMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5j\nb21tb25jYS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL3ByYWN0aWNlcy5wZGYwHwYD\nVR0RBBgwFoIUb3JpZ2luLmludGVybmV0Mi5lZHUwDQYJKoZIhvcNAQEFBQADggEB\nAGrV1Zdj5FM8FgKHbNO62r5ZaE2NlYLwDy1EYKWov2knbT9JHvYx+MH46xL7vCwX\nR/gFNOZ2bQAPWVlRwA/vgOcRaUCiY16EoXYRlPtV5iheGgZmf6t5cwekNM0fTE9r\nkHYyIGXQeH5nXzckOlBLqMQvla3qr8AjIYDS/bGAlUnLipo0jb30RucpKQVMa72U\nKae26sd7MUM7apEXibOIZ0ulHD18Bx3cwkEbNzjqO7Fhie4eHP7YLfZ4qqiwHIan\naDAvd3cq7kfauomnRFfk5m6If5r8CARRt/9ddJQJ2fR+UTVgq4Y0vrArC1RWlHCU\nfNWyS+DPScAAr7W2Ia1K8T8=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://origin.internet2.edu:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://origin.internet2.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Internet2", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.internet2.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://us1.ready.kuali.org/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "The Kuali Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "The Kuali Foundation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.kuali.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kai Hsieh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kchsieh@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Ryan Means", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rmeans@berkeley.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFAzCCA+ugAwIBAgIJALL/AS7Ovt88MA0GCSqGSIb3DQEBBQUAMIGxMQswCQYD\nVQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTERMA8GA1UEBxMIQmVya2VsZXkx\nEzARBgNVBAoTClVDQmVya2VsZXkxDDAKBgNVBAsTA0lTVDEcMBoGA1UEAxMTdXMx\nLnJlYWR5Lmt1YWxpLm9yZzE5MDcGCSqGSIb3DQEJARYqa3VhbGlyZWFkeS10ZWNo\nLXN1cHBvcnRAbGlzdHMuYmVya2VsZXkuZWR1MB4XDTEwMDEyNzE5NTUwM1oXDTEw\nMDIyNjE5NTUwM1owgbExCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlh\nMREwDwYDVQQHEwhCZXJrZWxleTETMBEGA1UEChMKVUNCZXJrZWxleTEMMAoGA1UE\nCxMDSVNUMRwwGgYDVQQDExN1czEucmVhZHkua3VhbGkub3JnMTkwNwYJKoZIhvcN\nAQkBFiprdWFsaXJlYWR5LXRlY2gtc3VwcG9ydEBsaXN0cy5iZXJrZWxleS5lZHUw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCyRyOkrgqiSVUDk9RbevgJ\nVikcP+S7D/IFGxxvtThfwogoZ9lMICwmQPe0i1XpAvzsEZZUngq2CfqyCOwoHu0b\nSGkZDR9GZJncpk/woiq5kUeazTJw8/hgLfmhzd9PQz1bWZ7wu0GIxZx6bFCyAJXk\nxajQeWD5ospMX530vSpjJpOeDQJ9Y48MGs5itc6cme7vrJd0qgu4tk084Rf+79S5\nP28BISQI7k5PAq6oqLvyqVFebPpPBzIocBl5o7D2TVbSzC8nm1i71TcqJ6bxD7zb\ncPsnnp7TAfy/eK+qsRFHWci569uZ31BFLxoS+03hjp4f8U1VBxpgJi1RV2wcpO3D\nAgMBAAGjggEaMIIBFjAdBgNVHQ4EFgQUs1tNiRsZ7oxMSgoUdYLNmc1wHtowgeYG\nA1UdIwSB3jCB24AUs1tNiRsZ7oxMSgoUdYLNmc1wHtqhgbekgbQwgbExCzAJBgNV\nBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMREwDwYDVQQHEwhCZXJrZWxleTET\nMBEGA1UEChMKVUNCZXJrZWxleTEMMAoGA1UECxMDSVNUMRwwGgYDVQQDExN1czEu\ncmVhZHkua3VhbGkub3JnMTkwNwYJKoZIhvcNAQkBFiprdWFsaXJlYWR5LXRlY2gt\nc3VwcG9ydEBsaXN0cy5iZXJrZWxleS5lZHWCCQCy/wEuzr7fPDAMBgNVHRMEBTAD\nAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCZ7/ZfAelgwTlVRbKebH0Ni8Uq+Evu6KE9\nrC1RXKjj6wdFDLJGW5rq6c4FHDh2NFaO4yBIZizYzfTtu8BcTV7gOxgOg/JmZfZO\nxXL8sT4PHLMJXAuRxpNyZEuuAlpRewbfifv7/CiYimHaPz1+3h8wvqABXqDcSewH\nkrXNM3cqpL+4Os0X92BTuYS1YIf0KdB8upEcCDCUV+oCThVmeQ0i/VumPe5Qau9x\ntS90xUZsyUUv5AxA8b3OOvvLolD9gD7Dv504LWdbwL8JBpHJSEOON9oqYxTUJu3u\npgh3qG63QeVrl0Jew9N39nw6sAu3cwmAT44GzEczlm4sOBzjzNgw", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://us1.ready.kuali.org/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://us1.ready.kuali.org/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://emp219.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Thomas Valdez", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "thomas.valdez@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:lafayette.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Lafayette College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Lafayette College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.lafayette.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bob Bailey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "baileyb@lafayette.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://training.express.ucla.edu/shibboleth/incommon": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Hemkant Patil", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hpatil@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Hemkant Patil", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hpatil@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Travel Accounting", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "travel@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://shibboleth.chadwyck.co.uk/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.proquest.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Geoff Leach, Software Team Leader, ProQuest (Cambridge, UK)", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "geoff.leach@proquest.co.uk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Douglas Hall, Assistant IT Manager, ProQuest (Cambridge, UK)", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "douglas.hall@proquest.co.uk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://pqshibboleth.proquest.com:9443": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.proquest.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Chad Roberts, Software Developer Lead, ProQuest (Ann Arbor, MI)", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "chad.roberts@proquest.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://emp255.peopleadmin.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "PeopleAdmin, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.peopleadmin.com/index.php?option=com_frontpage&Itemid=105", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Heather Tufts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "heather.tufts@peopleadmin.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFCzCCA/OgAwIBAgICAZUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA4MDgxMjE4NDgxM1oXDTEwMDgx\nMzE4NDgxM1owGjEYMBYGA1UEAxMPcGVvcGxlYWRtaW4uY29tMIGfMA0GCSqGSIb3\nDQEBAQUAA4GNADCBiQKBgQDdAujQPFfA3SJbvATaV3ZOyrU0pR+XTYxt1YscwGWB\n65oJpinlJVt8EX6Wv57UiRd1qNUmvxOKzQy+yMRBsc4g+whvaeumiLgz2Qlhp8g1\nSNsR/gmVYPLOLNzmVPrX7XNKNli5+DOqtq5F4+9ou8bwqiqzRFy+lPWYLgYMvegh\n/wIDAQABo4ICoTCCAp0wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBQ2Nt7DOvqITu4x\nRqumCysoiZP7WTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgw\nVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAn\nBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggr\nBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBP\nBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+g\nPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysG\nAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29t\nbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAaBgNVHREEEzARgg9wZW9w\nbGVhZG1pbi5jb20wDQYJKoZIhvcNAQEFBQADggEBADiiC7+8367p+Rgdzpiul67Y\nrci//XYMt5eklnWSDDnILTxCmnZ/9qBnpARjzIIyUToU8qR53F8UHjpp3SAzLgxA\nCiQWSIWOzoqAJHKfKeQNID51wKLH5BP+6YD52+Q8ufjZgpYierKqLcJqtf+WaQGX\n36kVQP38uI3zK7jHnr28mN5OCEyKPAV+4Rs2KwxG+6rQ/NjBM+W0Y/k34Uguk2XM\nMOvH3xJ+SwsQJBcjigErJwsl1zOZxlvHEg8/p719H/dK8ZbZROHw2z5LMoCdwMmf\nIFJDINAoOBl+1Mb5A0xgbbDpQbh1/+KLgd+rOdA1ko6m0o4bfxAQHuM8M7xJsSc=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://www.wustlcareers.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://cs255.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://training255.peopleadmin.com/Shibboleth.sso/SAML2/POST"
          }
        ]
      }
    ]
  }, 
  "https://imp39.sumtotalsystems.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sumtotalsystems.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bharathy Mohan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bmohan@sumtotalsystems.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://rwt.refworks.com/shibboleth/testshib/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "RefWorks, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "RefWorks, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://refworks.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Norman Kenney", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "nkenney@refworks.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:usf.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of South Florida", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of South Florida", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.usf.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Eric Pierce", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "epierce@usf.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:mit.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Massachusetts Institute of Technology", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Massachusetts Institute of Technology", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://web.mit.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Touchstone Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "touchstone-support@mit.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth-olin-wustl-csm.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://brownbearstickets.universitytickets.com/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "UniversityTickets", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "UniversityTickets", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://universitytickets.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Gordon Capreol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gcapreol@universitytickets.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "UniversityTickets Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@universitytickets.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.myidentit-e.com/shibboleth/incommon/sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Identit-E, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Identit-E, LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://myidentit-e.com/defaultstatic/default.htm", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Josh DePeau", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jdepeau@dstewart.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://www.ohsu.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHDCCAgSgAwIBAgIVAKiKGs+N1BpUHsMJYEAJU0TUP6QMMA0GCSqGSIb3DQEB\nBQUAMBcxFTATBgNVBAMTDHd3dy5vaHN1LmVkdTAeFw0wOTExMTcyMjUwNTJaFw0y\nOTExMTcyMjUwNTJaMBcxFTATBgNVBAMTDHd3dy5vaHN1LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBALghy62gm5RH9WP/KL0b+haTbG1H6sSYngn5\nBAFt3N/ETXm0FXf43XG3aCCuhAQQeHumEkebZZkJJxRDy7VBLiYDCrodTwZjG3Ux\nTMrErx+yrfgPcp4GyOFXcsdGUmlK7q+Z9VT9nFFgxoXkCwJ+E9kccmvREnWnuFxZ\ncyU7TU2KO9YbNkgmo6wOUOCStGfUKWgVNZdyuOpZPtY5RIxQM60mCd1XgwhReSAH\n3nU75XVrONn5vrYzCxFtandaJDfggrN2KTZE3t5UGNtFVK8WTR/hjCIaI8ibfpZn\nwcQtcrNjzGib3gS5mQlOGtKXYesb4sLbOTFky3gKrWM0nNoDq70CAwEAAaNfMF0w\nPAYDVR0RBDUwM4IMd3d3Lm9oc3UuZWR1hiNodHRwczovL3d3dy5vaHN1LmVkdS9p\nZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUb/kidTpnbE/d8egtfWTwn3CVKAIwDQYJ\nKoZIhvcNAQEFBQADggEBAIYzjl2+3amoiguDweqoRwmfxnmd0rNijcOcvp0FJCUw\n3vn/0UbsbeXOxKz6cncAY/tmJOUZ1MSK/7s7NVECWjtNwmx5Im7N/FXdNcEYEcMl\nW/6gWu6ZwUAgXaV/8klbrTGX3NWJ5jJsWQwHqA1yY9wba58okkWOjoIjI070IsHj\nudBseAs0D9Q9aL0OofrcQLcNdaGsJzLilDVM/UU7cSCwKATWuuLJGKgNlepjyq5Q\nz2lDp/HktHga9plFDjee7YRsH4N/9e1Z+3mKzs9QRANCAfDeTz9iFo8lJqo4sRdp\nSHajk3KEnqZKbsvlZC70uJpwvS9dn3E0G9esB/ps3tM=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://www.ohsu.edu/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Alex Bakman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bakmana@ohsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Damon Gentry", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gentryd@ohsu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://www.ohsu.edu/idp/error.jsp", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://www.ohsu.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://www.ohsu.edu/idp/profile/SAML2/POST/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDHDCCAgSgAwIBAgIVAKiKGs+N1BpUHsMJYEAJU0TUP6QMMA0GCSqGSIb3DQEB\nBQUAMBcxFTATBgNVBAMTDHd3dy5vaHN1LmVkdTAeFw0wOTExMTcyMjUwNTJaFw0y\nOTExMTcyMjUwNTJaMBcxFTATBgNVBAMTDHd3dy5vaHN1LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBALghy62gm5RH9WP/KL0b+haTbG1H6sSYngn5\nBAFt3N/ETXm0FXf43XG3aCCuhAQQeHumEkebZZkJJxRDy7VBLiYDCrodTwZjG3Ux\nTMrErx+yrfgPcp4GyOFXcsdGUmlK7q+Z9VT9nFFgxoXkCwJ+E9kccmvREnWnuFxZ\ncyU7TU2KO9YbNkgmo6wOUOCStGfUKWgVNZdyuOpZPtY5RIxQM60mCd1XgwhReSAH\n3nU75XVrONn5vrYzCxFtandaJDfggrN2KTZE3t5UGNtFVK8WTR/hjCIaI8ibfpZn\nwcQtcrNjzGib3gS5mQlOGtKXYesb4sLbOTFky3gKrWM0nNoDq70CAwEAAaNfMF0w\nPAYDVR0RBDUwM4IMd3d3Lm9oc3UuZWR1hiNodHRwczovL3d3dy5vaHN1LmVkdS9p\nZHAvc2hpYmJvbGV0aDAdBgNVHQ4EFgQUb/kidTpnbE/d8egtfWTwn3CVKAIwDQYJ\nKoZIhvcNAQEFBQADggEBAIYzjl2+3amoiguDweqoRwmfxnmd0rNijcOcvp0FJCUw\n3vn/0UbsbeXOxKz6cncAY/tmJOUZ1MSK/7s7NVECWjtNwmx5Im7N/FXdNcEYEcMl\nW/6gWu6ZwUAgXaV/8klbrTGX3NWJ5jJsWQwHqA1yY9wba58okkWOjoIjI070IsHj\nudBseAs0D9Q9aL0OofrcQLcNdaGsJzLilDVM/UU7cSCwKATWuuLJGKgNlepjyq5Q\nz2lDp/HktHga9plFDjee7YRsH4N/9e1Z+3mKzs9QRANCAfDeTz9iFo8lJqo4sRdp\nSHajk3KEnqZKbsvlZC70uJpwvS9dn3E0G9esB/ps3tM=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://www.ohsu.edu/idp/profile/SAML1/SOAP/ArtifactResolution"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://www.ohsu.edu/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Oregon Health & Science University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Oregon Health & Science University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ohsu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://uc.sumtotalsystems.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "SumTotal Systems, Inc.", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.sumtotalsystems.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bharathy Mohan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bmohan@sumtotalsystems.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:ucsc.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Santa Cruz", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Santa Cruz", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucsc.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jeffrey Crawford", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jeffreyc@ucsc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Eric Goodman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ericg@ucsc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://federation.nelnet.net": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "NG Web Solutions", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "NG Web Solutions", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ngwebsolutions.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jim Grace", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Jim.Grace@ngwebsolutions.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "John Muniz", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "John.Muniz@ngwebsolutions.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Phil Knight", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Phil.Knight@ngwebsolutions.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://spaces.lafayette.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Lafayette College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Lafayette College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.lafayette.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "John O'Keefe", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "okeefej@lafayette.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Bob Bailey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "baileyb@lafayette.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://training.eqm.ucla.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Los Angeles", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucla.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "George Rodgers", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "grodgers@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Annoushka Shojania", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ashojani@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "George Rodgers", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "grodgers@finance.ucla.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "https://dev.ucanr.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucdavis.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bryon Noel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bjnoel@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Karl Krist", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kakrist@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://apdev.nacs.uci.edu:47917/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California-Irvine", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uci.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Max Garrick", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mgarrick@uci.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFETCCA/mgAwIBAgICAiwwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDYxMTE3NTI0OVoXDTExMDYx\nMjE3NTI0OVowHTEbMBkGA1UEAxMSYXBkZXYubmFjcy51Y2kuZWR1MIGfMA0GCSqG\nSIb3DQEBAQUAA4GNADCBiQKBgQDA1A+LMuacPAuOYLnOd/rSoN4g06H+8SJJAcqd\nXHg+LJWvKRT87R8MiKD1UxG/mmmize4jUEXswtiIW9m7q6CM+dEprIjCNOP1WSZ1\ngAmhH2nbTdBYFTTeW6OqYnmlSnM5jOoQewu8DP2gkyquwjUe00xG/SBslm5KRR5Q\nJBcWVQIDAQABo4ICpDCCAqAwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAw\nHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBSi1ZRy5gRM\nIznfD12UJGWx474Y5TB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFa\npFgwVjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24x\nKTAnBgNVBAMTIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGy\nBggrBgEFBQcBAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2Ex\nLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3\nYjBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJh\ndGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGC\nMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5v\ncmcvY3JsL2VlY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5j\nb21tb25mZWRlcmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMG\nCysGAQQBriMBBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmlu\nY29tbW9uZmVkZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAdBgNVHREEFjAUghJh\ncGRldi5uYWNzLnVjaS5lZHUwDQYJKoZIhvcNAQEFBQADggEBABMVyxMArFywa2zm\nK9GeVlURz3CLjhzCFfUaAExJngC95qXNij6grDAQSFXmUq+AkwrrN/ReQ8KIZm33\nMZObtpKCWoaX5iE9NipRmBsL6b+IXD7wjK93iggu0+7z7Q5yMTyM8agPvqys+I37\nvpj7r12hEbMC6zn6S7ZcUaNcsHW/d7aS0EI9g5yulwRJGp2jgExHxlNqMJQx2Q1j\nMA3EIkrKyAEbyvHK60ra/Kxlt0GhDQnAUI/bi9UUxfcChUzWwA8ol3Y5TVCPEFr6\nJFe6Wu6Mt2abguBYfR5HQHB9stzdRqCR8AI1j0oK6qVkcc0aPgrK/3paVJmuq/jo\nKPQ9WOM=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apdev.nacs.uci.edu:47917/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apdev.nacs.uci.edu:47917/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apdev.nacs.uci.edu:47917/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apdev.nacs.uci.edu:47917/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apdev.nacs.uci.edu:47917/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://apdev.nacs.uci.edu:47917/Shibboleth.sso/SAML2/ECP"
          }
        ]
      }
    ]
  }, 
  "https://idp.pitt.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKTCCAhGgAwIBAgIJAK/m2puIvEaPMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDGlkcC5waXR0LmVkdTAeFw0xMDAyMjQyMTE1NDRaFw0xMzAyMjMyMTE1NDRa\nMBcxFTATBgNVBAMTDGlkcC5waXR0LmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAPf6lCv9nQN+Fn7ebs+68OhI804i1tn4STw9D9guwsE7Me1bGd4F\nFcIIniLFpt2rj8mmgtZ2klLNiAQlnx/GXpn/76BjSj4YvMEzW/dMmaBIP76bAnQ7\ncKmbFk8leBYGaunz6tqZWmaUFxEGr5ahleS4YWe+dVX86P3+/waPhiXklNeLLM2W\nZNa1dEDbvMbSuXFKuFWtiaayIiACIhi02pzIVBc/VO7z/uZKkN4g87wGVrlvwSmU\neI2jchW+CggBVQttF1TNBd+HTHb3J+MONZBGrWA4ZGXhlzFXeP9/PqmrpxRR2soW\nqryVCPr5EsIgJzQVSUXdgDXlrtpR4LZbdpcCAwEAAaN4MHYwHQYDVR0OBBYEFLKs\n08YJmnk/5jSuFpS3fjD6EZMqMEcGA1UdIwRAMD6AFLKs08YJmnk/5jSuFpS3fjD6\nEZMqoRukGTAXMRUwEwYDVQQDEwxpZHAucGl0dC5lZHWCCQCv5tqbiLxGjzAMBgNV\nHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQBR8/mBNuAza6eX2kPXul2zVRzr\nksZQsPuShBYEp+FN84/gvg55sY2ZOLkGVH55toyyMcouhepsCtqZg/qHsxAv2qaG\npUNRzRlUBhr5WjMQSmGC1SxeFO8EIZCv/prDi8jvARJwC85Q4mixs/mR8Ys0GWFk\nYhVUcKSUzBNlGJdSYl4CDXWt+e6EVvnyWvAmk4psrqlXeGzBxhSjHrJGQqEDuBjZ\nRf8ZaY9CbLGbOm/g++Szj1E+1s1cyiBQ5D316JimJ3U5Io2NHV+nSUdYOC8256+j\ndalrcnm0K9z3483QueZhUmPtapzeJz617znahr+cgz1fLZJTtP34AmIUOiVu", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.pitt.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Christopher Keslar", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "crk4@pitt.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Anthony Jones", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "abj@pitt.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "EJ Monti", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ejmonti@pitt.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "error_url": "https://idp.pitt.edu/idp/error.jsp", 
        "single_sign_on_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.pitt.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.pitt.edu/idp/profile/SAML2/Redirect/SSO"
          }, 
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.pitt.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.pitt.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDKTCCAhGgAwIBAgIJAK/m2puIvEaPMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDGlkcC5waXR0LmVkdTAeFw0xMDAyMjQyMTE1NDRaFw0xMzAyMjMyMTE1NDRa\nMBcxFTATBgNVBAMTDGlkcC5waXR0LmVkdTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAPf6lCv9nQN+Fn7ebs+68OhI804i1tn4STw9D9guwsE7Me1bGd4F\nFcIIniLFpt2rj8mmgtZ2klLNiAQlnx/GXpn/76BjSj4YvMEzW/dMmaBIP76bAnQ7\ncKmbFk8leBYGaunz6tqZWmaUFxEGr5ahleS4YWe+dVX86P3+/waPhiXklNeLLM2W\nZNa1dEDbvMbSuXFKuFWtiaayIiACIhi02pzIVBc/VO7z/uZKkN4g87wGVrlvwSmU\neI2jchW+CggBVQttF1TNBd+HTHb3J+MONZBGrWA4ZGXhlzFXeP9/PqmrpxRR2soW\nqryVCPr5EsIgJzQVSUXdgDXlrtpR4LZbdpcCAwEAAaN4MHYwHQYDVR0OBBYEFLKs\n08YJmnk/5jSuFpS3fjD6EZMqMEcGA1UdIwRAMD6AFLKs08YJmnk/5jSuFpS3fjD6\nEZMqoRukGTAXMRUwEwYDVQQDEwxpZHAucGl0dC5lZHWCCQCv5tqbiLxGjzAMBgNV\nHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQBR8/mBNuAza6eX2kPXul2zVRzr\nksZQsPuShBYEp+FN84/gvg55sY2ZOLkGVH55toyyMcouhepsCtqZg/qHsxAv2qaG\npUNRzRlUBhr5WjMQSmGC1SxeFO8EIZCv/prDi8jvARJwC85Q4mixs/mR8Ys0GWFk\nYhVUcKSUzBNlGJdSYl4CDXWt+e6EVvnyWvAmk4psrqlXeGzBxhSjHrJGQqEDuBjZ\nRf8ZaY9CbLGbOm/g++Szj1E+1s1cyiBQ5D316JimJ3U5Io2NHV+nSUdYOC8256+j\ndalrcnm0K9z3483QueZhUmPtapzeJz617znahr+cgz1fLZJTtP34AmIUOiVu", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "artifact_resolution_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
            "location": "https://idp.pitt.edu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
          }
        ]
      }
    ], 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Pittsburgh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Pittsburgh", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.pitt.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }
  }, 
  "https://moodle4.lafayette.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Lafayette College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Lafayette College", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.lafayette.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Bob Bailey", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "baileyb@lafayette.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:clemson.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Clemson University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.clemson.edu", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Kyle Peacock", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kpeacoc@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Barry Johnson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hbj@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Barry Johnson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "hbj@clemson.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:umbc.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Maryland Baltimore County", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.umbc.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Jason Griego", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jcgriego@umbc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Paul Riddle", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "paulr@umbc.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://pbsvid.itc.virginia.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.virginia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Hamp Carruth", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ehc@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Jim Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Jim Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@Virginia.EDU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibsp.itc.virginia.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Virginia", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.virginia.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "James Jokl", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "jaj@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Hamp Carruth", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "ehc@virginia.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://monk.lis.illinois.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Illinois at Urbana-Champaign", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.uiuc.edu/index.html", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Mike Grady", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "m-grady@illinois.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
          "extension_elements": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://monk.lis.illinois.edu/Shibboleth.sso/DS"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
              "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
              "location": "https://monk.library.illinois.edu/Shibboleth.sso/DS"
            }
          ]
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFmzCCBIOgAwIBAgICAm8wDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDgxMTE3NTIwN1oXDTExMDgx\nMjE3NTIwN1owIDEeMBwGA1UEAxMVbW9uay5saXMuaWxsaW5vaXMuZWR1MIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzsOP/HJV+o0N2Lk/UJCG32/K1yMo\nGdJE8vSeYVJinZAZP2yHXSb5EF7z/22+W7wQLQeB8/JFNyWgEwtvIzo2Sxfa7Bgl\nIz60mQdMVTs+YWdu4kBUe/JcXTYkMCWP6gyfTK9Z96B+9qrnT2YPXT+XOa6zTUB+\n7oC/HppG8+L2Ff3WZOc9rWVsZlj2XZBgK1uTODtPDLClGVTt0t3iVgRKwA5/qsPH\nZC0iV/w/7UYSPzjf+/qELQH+RhZVmbLKO5ZYinvX/NKCQv9kJGKsXFeh2aLyC9+w\nmuH1OUaI5ZOGjETQs5JQH6fK+ESKKTcmx9zLmanorBUqfXoOY10Ckdu+xwIDAQAB\no4ICpzCCAqMwDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYDVR0lBBYw\nFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB0GA1UdDgQWBBStitDT+31hEp/Tg5vGLzhK\nYDYUVTB+BgNVHSMEdzB1gBSTLchhGK1j45tls53djZO658pjRaFapFgwVjELMAkG\nA1UEBhMCVVMxHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMT\nIEluQ29tbW9uIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMIGyBggrBgEFBQcB\nAQSBpTCBojBPBggrBgEFBQcwAoZDaHR0cDovL2luY29tbW9uY2ExLmluY29tbW9u\nZmVkZXJhdGlvbi5vcmcvYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjBPBggrBgEF\nBQcwAoZDaHR0cDovL2luY29tbW9uY2EyLmluY29tbW9uZmVkZXJhdGlvbi5vcmcv\nYnJpZGdlL2NlcnRzL2NhLWNlcnRzLnA3YjCBjQYDVR0fBIGFMIGCMD+gPaA7hjlo\ndHRwOi8vaW5jb21tb25jcmwxLmluY29tbW9uZmVkZXJhdGlvbi5vcmcvY3JsL2Vl\nY3Jscy5jcmwwP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDIuaW5jb21tb25mZWRl\ncmF0aW9uLm9yZy9jcmwvZWVjcmxzLmNybDBeBgNVHSAEVzBVMFMGCysGAQQBriMB\nBAEBMEQwQgYIKwYBBQUHAgEWNmh0dHA6Ly9pbmNvbW1vbmNhLmluY29tbW9uZmVk\nZXJhdGlvbi5vcmcvcHJhY3RpY2VzLnBkZjAgBgNVHREEGTAXghVtb25rLmxpcy5p\nbGxpbm9pcy5lZHUwDQYJKoZIhvcNAQEFBQADggEBAKVuaysDfwRjO71fyRQTVii9\n2v7IO5iW2Pjj+DHCbRiNHzII9TsiltUcH7RfenhJhU1tvs0gsrCwN6YJMG50YGmg\nmGaZ5YYGmt6br/pdEZdu/tpFszMEhbIY9ZEbVBHpXO7CC7GJb+ZeKwOisbu2SfCA\nP3lAdE3dWLfDQ/ag/7/04S54hrtwdtggWO8l4OZl4cwhuohDxxD74t+3MMw+mYVn\nbZ0DIWTf47zsjuaRRGkxyqiknVMB4fprfBQxVg/FX7/euUw+ad2M3RZW6bcw31zb\ncgBTiOcqQ+TfiYKvAr9X4a+AY/ZkzRF1exnFm+khbYpKiHn5k7znZ2e5jZGJySY=", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.lis.illinois.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.lis.illinois.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.lis.illinois.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.lis.illinois.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.lis.illinois.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.lis.illinois.edu/Shibboleth.sso/SAML2/ECP"
          }, 
          {
            "index": "7", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.library.illinois.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "8", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.library.illinois.edu/Shibboleth.sso/SAML/Artifact"
          }, 
          {
            "index": "9", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.library.illinois.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "10", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.library.illinois.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "11", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://monk.library.illinois.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }
        ]
      }
    ]
  }, 
  "https://sympa.ucdavis.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of California, Davis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.ucdavis.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Data Center ISM", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "sysadmin@ucdavis.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIC3DCCAcSgAwIBAgIJAIFDjqbyOTwoMA0GCSqGSIb3DQEBBQUAMBIxEDAOBgNV\nBAMTB3Blbm55LTIwHhcNMDkxMjE1MDAzMDI5WhcNMTkxMjEzMDAzMDI5WjASMRAw\nDgYDVQQDEwdwZW5ueS0yMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nzNxqF3UUKgmojN35FGL9SdymCzuvFDPWLYT6ANryruKt2TDBdQsBje9ESggVlawX\notwlOFQIf5Dt8IN0TLlVgG/cwxZptw35F4tL4oPAwuXoSuvKb6OQwMcZYOknghI1\nk9NcNZT4Tbps4XbR7d2kBGUdBWK3DjDkHNGZDGkL/SaJ/ARi73Va7zyjgcPJTQRS\n9tFto0Q7NdextAc89gixsp/HHSBV7fg1L/GbQ5BdmVajYru59oW2RsfNghAt6Ic9\nVkl61YRK9zcfboE05N/Ie2Iwu6dgAB7J6+Vm/GiKGQEwrf4xbHZpFw9X/XDaN+5q\nHvmrUaVDOGYQdAYBWZYRvQIDAQABozUwMzASBgNVHREECzAJggdwZW5ueS0yMB0G\nA1UdDgQWBBTEi1+yHsUWMDEuWac4+4WArWO/HTANBgkqhkiG9w0BAQUFAAOCAQEA\nrO5x+64t/HANwfaFjt6Dv+EcWZF0z/aeZD9Qnxx7u70ZNOXSPhhbEPgcekR51X/y\nARexOwNKmtDS7o2Q1bPDzeJYGDZpTl89Mlhsmu7T3kHFpr/kKV2p+SvDaJ77fCeE\n1lT06ExNLPmfR7h6yiXc+whCr7A0XM44X85RTSZyvTi31p2KBWnLxzahYElCYrl5\nzFYEesp/fHpkteyIbWQst4oLzXbDpHIwoodc5et66EWNVhGyb8bPnBT4I7cLfMtT\nK5HNoZKzYO6nGV2YTldPtW1AVwBjmVv0F/DRfLzUsUntf39szdXLCyiDrrEgjTMU\nlDYwEcuHlogzMEIVanR5HA==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://sympa.ucdavis.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://sympa.ucdavis.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://sympa.ucdavis.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://sympa.ucdavis.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }
        ]
      }
    ]
  }, 
  "https://shib-sp-test.www.umich.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Michigan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Michigan", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.umich.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Liam Hoekenga", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth@umich.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFpTCCBI2gAwIBAgICAiAwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUyNzE5MzcyMFoXDTExMDUy\nODE5MzcyMFowJTEjMCEGA1UEAxMac2hpYi1zcC10ZXN0Lnd3dy51bWljaC5lZHUw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDzw76y6tC9mLqjG7gACBef\nbowx7BOCY8ASdBJ8fkm2p7l39iggBqfCw4v7V7NyZIOnNr+iqN+j51Xoi1Bayjjl\n4f83ZK7i9jhEt9eHp4sUMcvjJ4CUXO+dd8zVlAW/PTTe+s2a8oDRmmi6mma5quCC\nc/faoyWWjYf11KEw1sptaJzOvMdYhDe2mimCA93/Oq7mXrXas5TqTxCkTGtOG0bM\nSA8ZEFMjY42x/dNRz/11HuMdfMqeP5PCDvoxFVC5PY9oaGji4FmYgip5H9XlQy/C\n3mUs1wIoJz/vW7mlHzKt7FG5K1/hTAMo6cQjp1SssszuueAzkCrPhHJ0LEATGw4N\nAgMBAAGjggKsMIICqDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNV\nHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFG8eB0C9pUxJjVyA\nXjQyGT2NEQOEMH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqkWDBW\nMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEpMCcG\nA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIGCCsG\nAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEuaW5j\nb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiME8G\nCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0aW9u\nLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIwP6A9\noDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9yZy9j\ncmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNvbW1v\nbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYLKwYB\nBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5jb21t\nb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMCUGA1UdEQQeMByCGnNoaWIt\nc3AtdGVzdC53d3cudW1pY2guZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQAmWrg8q4fh\nDXoYapsfBgACx7BFpJfxwQHfoVVY54arBwHCze2yb2I+pX+gboZ9Hdo7fHZ2R4ZB\nRgPOJCYkHURA4A6WJVcg3rQqk4CR2ytJrsaaMt9H6tObJBbPHEaY4zo+ujZKNiaj\nwfwpnfkRyflpc+Kv7jsX7nE55tVw6mHF14nmWdSxVZwqyIKxufD5IHW0o3eFsAWr\nTRZl8AKbv5WR+4xLyp8d7GzHVBXcJ8j64QOBsamgBeQMLIwOZHMq6VkVH7xSk4Ko\ncoFtyWrw6SAxPYmgAUpto9fE9qGFbmdAixcqCJF1YHdmNY8xIRpO+ixiw0hgvBMq\nyahoTz7DQsah", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib-sp-test.www.umich.edu/Shibboleth.sso/SAML/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib-sp-test.www.umich.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib-sp-test.www.umich.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib-sp-test.www.umich.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "5", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib-sp-test.www.umich.edu/Shibboleth.sso/SAML2/ECP"
          }, 
          {
            "index": "6", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://shib-sp-test.www.umich.edu/Shibboleth.sso/SAML/Artifact"
          }
        ]
      }
    ]
  }, 
  "https://connect.wustl.edu/shibboleth-sp": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Washington University in St. Louis", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.wustl.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Ken Koch", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "Ken.Koch@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Daniel Zweifel", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "danz@wustl.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFDzCCA/egAwIBAgICAlEwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcxNTE3NTUyMloXDTExMDcx\nNjE3NTUyMlowHDEaMBgGA1UEAxMRY29ubmVjdC53dXN0bC5lZHUwgZ8wDQYJKoZI\nhvcNAQEBBQADgY0AMIGJAoGBALv6IL3RCwCSX5wbnWEVgvC0ZRA9pRtoAKM9fUQP\ncC0oib/cSZ/ko5NsrvKbesSILC3G3y4Lc8nsscAX4gqmky6mnBD9WhUBmX5DmdGq\nlGk9jUlSnPs8f0wWFSlReZQUMINLnxGCsBWnS46sS9xT1y6Y2yZaE1Qxe4M8odlP\nKTxPAgMBAAGjggKjMIICnzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAd\nBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwHQYDVR0OBBYEFHiWvEMPD40C\n/lENApmCd/skH99+MH4GA1UdIwR3MHWAFJMtyGEYrWPjm2Wznd2Nk7rnymNFoVqk\nWDBWMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTSW5Db21tb24gRmVkZXJhdGlvbjEp\nMCcGA1UEAxMgSW5Db21tb24gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCAQAwgbIG\nCCsGAQUFBwEBBIGlMIGiME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTEu\naW5jb21tb25mZWRlcmF0aW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdi\nME8GCCsGAQUFBzAChkNodHRwOi8vaW5jb21tb25jYTIuaW5jb21tb25mZWRlcmF0\naW9uLm9yZy9icmlkZ2UvY2VydHMvY2EtY2VydHMucDdiMIGNBgNVHR8EgYUwgYIw\nP6A9oDuGOWh0dHA6Ly9pbmNvbW1vbmNybDEuaW5jb21tb25mZWRlcmF0aW9uLm9y\nZy9jcmwvZWVjcmxzLmNybDA/oD2gO4Y5aHR0cDovL2luY29tbW9uY3JsMi5pbmNv\nbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMuY3JsMF4GA1UdIARXMFUwUwYL\nKwYBBAGuIwEEAQEwRDBCBggrBgEFBQcCARY2aHR0cDovL2luY29tbW9uY2EuaW5j\nb21tb25mZWRlcmF0aW9uLm9yZy9wcmFjdGljZXMucGRmMBwGA1UdEQQVMBOCEWNv\nbm5lY3Qud3VzdGwuZWR1MA0GCSqGSIb3DQEBBQUAA4IBAQB9VP9l4eevqu2BujXK\nyduOpCc9qpJxLzpI45TIgKylSq0ji8+gsKwT9CAm0hLIqENsuQulvjrCnqzP0dG+\nS/eZffT7jzVocvV0UGExcWt1w/VyO5zhsH2PgSJnAKVgBxex8M6Q/lxqG/sqtVww\ngn3efXSzUSevpcQeD3xbUwuHePIA36PQE3tbWVrtvVM0sb3zkRExgYjrzy2SFZqn\nJci/tCnhrG3BtvQz3dXkNQvIu7v5GweogT5zllXpmsJA1PmmUk4rTLeav4s0LEC4\nGeURNfKkoI6tOjH61z1u6NS3RBot+SIqS9ypO/4wtUxlThdYJU+ECpGIIJ7n6YsA\nThDg", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://connect.wustl.edu/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://connect.wustl.edu/Shibboleth.sso/SAML2/POST-SimpleSign"
          }, 
          {
            "index": "3", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://connect.wustl.edu/Shibboleth.sso/SAML2/Artifact"
          }, 
          {
            "index": "4", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://connect.wustl.edu/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "http://dram.nyu.edu/dram": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "New York University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "New York University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.nyu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Thomas Cunningham", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "tom@nyu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Rick Ochoa", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "rick@nyu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Gary Chapman", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "gary.chapman@nyu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth-umbc.symplicity.com/sso": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "noc@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "urn:mace:incommon:umn.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Minnesota", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Minnesota", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www1.umn.edu/twincities/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Christopher Bongaarts", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "cab@tc.umn.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Kevin O'Rourke", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "kor@tc.umn.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://shibboleth.vcu.edu/idp/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Virginia Commonwealth University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Virginia Commonwealth University", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.vcu.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "JE Fritz", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "fritz@vcu.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.vcu.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.vcu.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://shibboleth.vcu.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIDOzCCAiOgAwIBAgIJAMkP0cy6Mj6OMA0GCSqGSIb3DQEBBQUAMB0xGzAZBgNV\nBAMTEnNoaWJib2xldGgudmN1LmVkdTAeFw0wOTEwMzAxMzM0MjFaFw0xMjEwMjkx\nMzM0MjFaMB0xGzAZBgNVBAMTEnNoaWJib2xldGgudmN1LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAL4gIuA1ljlDh/jlffYhbTRMsfGFErcWrejd\n5UA2FvUEL14+PPzpHq6+8HHZL1TYW5WnRq4dpuvHUxOfSxt5gom9bl3SUa3pAFsk\nhKcXqOwZzvPPVo0Rp7iZguVjkiZBlSYXo3cP4bfMuNrfvDTCAFvxa8fZN8yxclVL\nBg7yXKh6gPbVN9VST3KG/mExI7yghNFnxJgh1xsfl4idJCvKb+V3IuD8hdWiS7hp\nQ+mcn+1rA+TQarXODC5rf/JilvWaRvh6cwMHw35sBownzI44h/L1vfHimiPGXvo7\noroZ7NGUK1j0G6GolK7ixBHjQZZGUv7O2X/4Rj+NaIFkf+KnNIECAwEAAaN+MHww\nHQYDVR0OBBYEFFb2M0GvEkqM6CsDMAgoGdxe/022ME0GA1UdIwRGMESAFFb2M0Gv\nEkqM6CsDMAgoGdxe/022oSGkHzAdMRswGQYDVQQDExJzaGliYm9sZXRoLnZjdS5l\nZHWCCQDJD9HMujI+jjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQBl\nRNsX0fk9l9EeZa8AHpPcxk3eQaW8r4MT+o57LXtBDZEvKFc8fRws09Ptkyg9CETv\n5uT7GQZ0HEFZyONJHsQy8Q1Etr4Q7I5J9EAxokBG4kFAn7Jcp1LHf5zHlWVhDsR+\nLMhDmHPuyDGqN8pVU/47MA0hFGILpckRY6q4j7L3aXyet0ImyPVlgJUoMXRso7vN\nUw8mKyvL8HT3iZ42D8wENFNhA3nck2RDX3K1nv0qCbNF+FlnUDTy7i6EnH4U2aoe\nmYJ3G1FBVt0b8LdS0XisQ9pY3kpuQqspN4SFrJUDi6luNLdH8/YguSB0uf2Pdyyj\nKUd8anrB7gIglUS1bz6F", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ]
      }
    ]
  }, 
  "https://shibboleth-upenn-sgms.symplicity.com/sso/": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth-nyu-sgms.symplicity.com/sso": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "Symplicity Corporation", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.symplicity.com", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Symplicity NOC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shib@symplicity.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://mcncweb.mcnc.org/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "MCNC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.mcnc.org/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "MCNC Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@mcnc.org", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ], 
    "spsso": [
      {
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
        "key_descriptor": [
          {
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFkTCCBHmgAwIBAgICAkQwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDcwOTE3NTMxNFoXDTExMDcx\nMDE3NTMxNFowGzEZMBcGA1UEAxMQbWNuY3dlYi5tY25jLm9yZzCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBALrWKa43RC3j7OhD7ehT2o12jYbrH1UIf4BS\n5mio02zjEa+5xvUSeaMuZ3eosdDzKrIdXhxolfTXnHAkuEklgaPsi0yFukxZgCzH\nnycEkZi5nLvXqO2mJp0eS9pqFVhyX3MBy2TVI9kJf/aqwiJ10LXheyIDPA08pWco\nRMNFnYaH0PUnRTBuNp2MKyZK7tHdE5xGsWrxQpuqueJdpdvNVclYWhDNygZxhjC2\nVOpxAmGWev43QU8TMmTAU9fYbrUuh7n05soDX+Rf646LHyLM/JADrr3UmYq5DEN8\nmz3UHvpvNjtKks5WtOnsauyIYrpqI29UUDnTehUP/H/18qstMrsCAwEAAaOCAqIw\nggKeMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsG\nAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUxG+1elJpd82ifiOUIpXjFdXE1D8w\nfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYT\nAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNv\nbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUw\ngaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKG\nQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRn\nZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDov\nL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMu\nY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBE\nMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL3ByYWN0aWNlcy5wZGYwGwYDVR0RBBQwEoIQbWNuY3dlYi5tY25jLm9y\nZzANBgkqhkiG9w0BAQUFAAOCAQEAYd8L/PmS7V6X3oH4+uLf8+QW0WPLKH/g4etd\nvZAvIF5bCQVQ27e/+nMurpGIoKPsAY0Dpnf1BTScgtqYAjm6j2W/vaxiURcgRpn5\nYQhZ/fst+22c0ZltrBsrnlDy+XYk8Fh4epDwZZrNYflr3830BX2xDFawKt+L9VSv\nAqdDfmVAbidUgVwVBiL+wGPkoEm2glH2lXeEbWJoZaiVox9MB7bNC+xswXjHCZZj\ngLIjhe277efkWephiB/mDxf1V/LOLz3Qsp2RiPvRBkHIOGe8N3rNyX/qM0jCBLfT\nZevAeIqJqx/o2fA/EhcJKedV8Z08cbwvcJCGdwOqm4Rbk3bd2Q==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "assertion_consumer_service": [
          {
            "index": "1", 
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mcncweb.mcnc.org/Shibboleth.sso/SAML2/POST"
          }, 
          {
            "index": "2", 
            "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
            "location": "https://mcncweb.mcnc.org/Shibboleth.sso/SAML/POST"
          }
        ]
      }
    ]
  }, 
  "https://cat-dev-tools1.cac.washington.edu/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "University of Washington", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.washington.edu/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Collaborative Platforms", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "teg-cp@cac.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Catalyst IT", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "catalyst-it@u.washington.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }
    ]
  }, 
  "https://federation.nih.gov/FederationGateway": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "National Institutes of Health", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "National Institutes of Health", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.nih.gov/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Debbie Bucci@mail.nih.gov", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "bucci@mail.nih.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "NIH ISC Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "NIHISCSupport@mail.nih.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }, 
      {
        "given_name": {
          "text": "NIH Federation Technical Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "NIHFederationTechnicalSupport@mail.nih.gov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ]
  }, 
  "https://shibboleth.illumina.csa.com/shibboleth": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "organization": {
      "organization_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
        }
      ], 
      "organization_display_name": [
        {
          "lang": "en", 
          "text": "ProQuest LLC", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
        }
      ], 
      "organization_url": [
        {
          "lang": "en", 
          "text": "http://www.proquest.com/", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
        }
      ], 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
    }, 
    "contact_person": [
      {
        "given_name": {
          "text": "Shibboleth Illumina Tech", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth.illumina.tech@proquest.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Shibboleth Illumina Admin", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "shibboleth.illumina.admin@proquest.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "CSA Illumina Support", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "support@csa.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "support"
      }
    ]
  }, 
  "urn:mace:incommon:humboldt.edu": {
    "valid_until": "2010-03-23T23:00:00Z", 
    "attribute_authority": [
      {
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "protocol_support_enumeration": "urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFkTCCBHmgAwIBAgICAiUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUyOTE4NDY0OFoXDTExMDUz\nMDE4NDY0OFowGzEZMBcGA1UEAxMQaWRwLmh1bWJvbGR0LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAIobfOptbMRmZfxAr5j5iDpNzctKRRn+f105\nqejIvk2diU5AYo5pDNcbEBEixdV0ikWwqHh2PH2D2FvpQDikQU7CPcLHCcuSbviy\npIyJIuGM1cfnirzFSkCjhgKqIjgTEKkCJzZgNKFqikWnEGf3ptn27z3H0GRZCC+B\n5ahmBJSO17iBuyQ71Qp+3pH2Pq0ffoOpRuTutfQUpsM2Qw1t5AG7j1F/fvw3vzrc\nHxwlWpyuDtcOlSiCezrcIJdx7ejK+G0aoqihe8HuHrD2Wg7vmRFsC/N9/S+7A+sV\n+uAaxI1JSt0M+twXDiMuPvcdlh82kiEB56njXsDcJm5UrskYR5ECAwEAAaOCAqIw\nggKeMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsG\nAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUKdif1++SY7RXkOHiEkduH4q/e/Yw\nfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYT\nAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNv\nbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUw\ngaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKG\nQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRn\nZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDov\nL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMu\nY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb25jcmwyLmluY29tbW9uZmVkZXJhdGlv\nbi5vcmcvY3JsL2VlY3Jscy5jcmwwXgYDVR0gBFcwVTBTBgsrBgEEAa4jAQQBATBE\nMEIGCCsGAQUFBwIBFjZodHRwOi8vaW5jb21tb25jYS5pbmNvbW1vbmZlZGVyYXRp\nb24ub3JnL3ByYWN0aWNlcy5wZGYwGwYDVR0RBBQwEoIQaWRwLmh1bWJvbGR0LmVk\ndTANBgkqhkiG9w0BAQUFAAOCAQEAOcwPpeqe61hu63uwC9PVYZNOyxzc2f2h0ii/\nSNLOlbbolZfxMKbuxLXcYCpy1IXxlzBx4hieTRYTksHehIHcDK2dM52F1AMumRo3\nEMSh1TTRn9Z6xK9ACypa3Ah42+qdvCXDT3je/DCQK4gkTlXd9KE2hv06IemHD9V+\nEo7yhlY9Nd2oOVWCLV6+hNqrR56gio6b0SWf97B1LAlkPTW0iLaldmLui1dW6EV0\n8pWQYq0T+m/F/Hzj730ntKD9AYN+VBCYxIPKXNPqBsKkBqNO8622mYNPcS5rbfUj\nMA1WuRhoHwRbAV7L/wak8BuONBWFl1zr3+/hOj3F1/Xpeomhag==", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                  }, 
                  "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                }
              ], 
              "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
            }, 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
          }
        ], 
        "attribute_service": [
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
            "location": "https://idp.humboldt.edu:8443/idp/profile/SAML2/SOAP/AttributeQuery"
          }
        ]
      }
    ], 
    "contact_person": [
      {
        "given_name": {
          "text": "Mark Hendricks", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "mark.hendricks@humboldt.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "administrative"
      }, 
      {
        "given_name": {
          "text": "Peter Johnson", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "peter.johnson@humboldt.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }, 
      {
        "given_name": {
          "text": "Systems Group", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
        }, 
        "email_address": [
          {
            "text": "sysadmin@humboldt.edu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
        "contact_type": "technical"
      }
    ], 
    "idpsso": [
      {
        "protocol_support_enumeration": "urn:mace:shibboleth:1.0 urn:oasis:names:tc:SAML:1.1:protocol urn:oasis:names:tc:SAML:2.0:protocol", 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
        "single_sign_on_service": [
          {
            "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.humboldt.edu/idp/profile/Shibboleth/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.humboldt.edu/idp/profile/SAML2/POST/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.humboldt.edu/idp/profile/SAML2/POST-SimpleSign/SSO"
          }, 
          {
            "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
            "location": "https://idp.humboldt.edu/idp/profile/SAML2/Redirect/SSO"
          }
        ], 
        "extensions": {
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
        }, 
        "key_descriptor": [
          {
            "use": "signing", 
            "key_info": {
              "x509_data": [
                {
                  "x509_certificate": {
                    "text": "MIIFkTCCBHmgAwIBAgICAiUwDQYJKoZIhvcNAQEFBQAwVjELMAkGA1UEBhMCVVMx\nHDAaBgNVBAoTE0luQ29tbW9uIEZlZGVyYXRpb24xKTAnBgNVBAMTIEluQ29tbW9u\nIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA5MDUyOTE4NDY0OFoXDTExMDUz\nMDE4NDY0OFowGzEZMBcGA1UEAxMQaWRwLmh1bWJvbGR0LmVkdTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAIobfOptbMRmZfxAr5j5iDpNzctKRRn+f105\nqejIvk2diU5AYo5pDNcbEBEixdV0ikWwqHh2PH2D2FvpQDikQU7CPcLHCcuSbviy\npIyJIuGM1cfnirzFSkCjhgKqIjgTEKkCJzZgNKFqikWnEGf3ptn27z3H0GRZCC+B\n5ahmBJSO17iBuyQ71Qp+3pH2Pq0ffoOpRuTutfQUpsM2Qw1t5AG7j1F/fvw3vzrc\nHxwlWpyuDtcOlSiCezrcIJdx7ejK+G0aoqihe8HuHrD2Wg7vmRFsC/N9/S+7A+sV\n+uAaxI1JSt0M+twXDiMuPvcdlh82kiEB56njXsDcJm5UrskYR5ECAwEAAaOCAqIw\nggKeMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsG\nAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUKdif1++SY7RXkOHiEkduH4q/e/Yw\nfgYDVR0jBHcwdYAUky3IYRitY+ObZbOd3Y2TuufKY0WhWqRYMFYxCzAJBgNVBAYT\nAlVTMRwwGgYDVQQKExNJbkNvbW1vbiBGZWRlcmF0aW9uMSkwJwYDVQQDEyBJbkNv\nbW1vbiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIBADCBsgYIKwYBBQUHAQEEgaUw\ngaIwTwYIKwYBBQUHMAKGQ2h0dHA6Ly9pbmNvbW1vbmNhMS5pbmNvbW1vbmZlZGVy\nYXRpb24ub3JnL2JyaWRnZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwTwYIKwYBBQUHMAKG\nQ2h0dHA6Ly9pbmNvbW1vbmNhMi5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2JyaWRn\nZS9jZXJ0cy9jYS1jZXJ0cy5wN2IwgY0GA1UdHwSBhTCBgjA/oD2gO4Y5aHR0cDov\nL2luY29tbW9uY3JsMS5pbmNvbW1vbmZlZGVyYXRpb24ub3JnL2NybC9lZWNybHMu\nY3JsMD+gPaA7hjlodHRwOi8vaW5jb21tb