/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/SchemaTypesDoc/CInstanceOperationDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/InstanceOperationXml.h"

using namespace Caf;

void InstanceOperationXml::add(
	const SmartPtrCInstanceOperationDoc instanceOperationDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstanceOperationXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(instanceOperationDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string operationNameVal = instanceOperationDoc->getOperationName();
		CAF_CM_VALIDATE_STRING(operationNameVal);
		thisXml->addAttribute("operationName", operationNameVal);

		const std::string monikerVal = instanceOperationDoc->getMoniker();
		CAF_CM_VALIDATE_STRING(monikerVal);
		thisXml->addAttribute("moniker", monikerVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCInstanceOperationDoc InstanceOperationXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstanceOperationXml", "parse");

	SmartPtrCInstanceOperationDoc instanceOperationDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string operationNameStrVal =
			thisXml->findRequiredAttribute("operationName");
		const std::string operationNameVal = operationNameStrVal;

		const std::string monikerStrVal =
			thisXml->findRequiredAttribute("moniker");
		const std::string monikerVal = monikerStrVal;

		instanceOperationDoc.CreateInstance();
		instanceOperationDoc->initialize(
			operationNameVal,
			monikerVal);
	}
	CAF_CM_EXIT;

	return instanceOperationDoc;
}

