/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml.css;

import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLElement;
import org.w3c.dom.Element;

public class CSSRule {
    private String selector;
    private SelectorType type;
    protected Map<String, String> properties;

    public CSSRule(String string, String string2) {
        this.properties = new HashMap<String, String>();
        this.properties.put(string, string2);
    }

    public CSSRule(String string, String string2, String string3) {
        this.setSelector(string);
        this.properties = new HashMap<String, String>();
        this.properties.put(string2, string3);
    }

    public CSSRule(String string, Map<String, String> map) {
        this.setSelector(string);
        this.properties = map;
    }

    public void setSelector(String string) {
        switch (string.charAt(0)) {
            case '*': {
                this.type = SelectorType.ALL;
                break;
            }
            case '.': {
                this.type = SelectorType.CLASS_ATTRIBUTE;
                break;
            }
            case '#': {
                this.type = SelectorType.ID_ATTRIBUTE;
                break;
            }
            default: {
                this.type = SelectorType.ELEMENT_NAME;
            }
        }
        this.selector = this.type == SelectorType.ELEMENT_NAME ? string : string.substring(1);
    }

    public boolean matches(Element element) {
        boolean bl = false;
        block0 : switch (this.type) {
            case ALL: {
                bl = true;
                break;
            }
            case ELEMENT_NAME: {
                String string = element.getLocalName();
                bl = string.equals(this.selector);
                break;
            }
            case CLASS_ATTRIBUTE: {
                String[] stringArray;
                String string = element.getAttribute("class");
                if (string == null) break;
                for (String string2 : stringArray = string.split(" ")) {
                    if (!string2.equals(this.selector)) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case ID_ATTRIBUTE: {
                String string = element.getAttribute("id");
                bl = string != null && string.equals(this.selector);
                break;
            }
        }
        return bl;
    }

    public boolean matches(IXMLElement iXMLElement) {
        boolean bl = false;
        block0 : switch (this.type) {
            case ALL: {
                bl = true;
                break;
            }
            case ELEMENT_NAME: {
                String string = iXMLElement.getName();
                bl = string != null && string.equals(this.selector);
                break;
            }
            case CLASS_ATTRIBUTE: {
                String[] stringArray;
                String string = iXMLElement.getAttribute("class");
                if (string == null) break;
                for (String string2 : stringArray = string.split(" ")) {
                    if (!string2.equals(this.selector)) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case ID_ATTRIBUTE: {
                String string = iXMLElement.getAttribute("id");
                bl = string != null && string.equals(this.selector);
                break;
            }
        }
        return bl;
    }

    public void apply(Element element) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (element.hasAttribute(entry.getKey())) continue;
            element.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void apply(IXMLElement iXMLElement) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (iXMLElement.hasAttribute(entry.getKey())) continue;
            iXMLElement.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return "CSSRule[" + this.selector + this.properties + "]";
    }

    private static enum SelectorType {
        ALL,
        ELEMENT_NAME,
        CLASS_ATTRIBUTE,
        ID_ATTRIBUTE;

    }
}

