// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1/web_detection.proto

package vision

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Relevant information for the image from the Internet.
type WebDetection struct {
	// Deduced entities from similar images on the Internet.
	WebEntities []*WebDetection_WebEntity `protobuf:"bytes,1,rep,name=web_entities,json=webEntities" json:"web_entities,omitempty"`
	// Fully matching images from the Internet.
	// Can include resized copies of the query image.
	FullMatchingImages []*WebDetection_WebImage `protobuf:"bytes,2,rep,name=full_matching_images,json=fullMatchingImages" json:"full_matching_images,omitempty"`
	// Partial matching images from the Internet.
	// Those images are similar enough to share some key-point features. For
	// example an original image will likely have partial matching for its crops.
	PartialMatchingImages []*WebDetection_WebImage `protobuf:"bytes,3,rep,name=partial_matching_images,json=partialMatchingImages" json:"partial_matching_images,omitempty"`
	// Web pages containing the matching images from the Internet.
	PagesWithMatchingImages []*WebDetection_WebPage `protobuf:"bytes,4,rep,name=pages_with_matching_images,json=pagesWithMatchingImages" json:"pages_with_matching_images,omitempty"`
	// The visually similar image results.
	VisuallySimilarImages []*WebDetection_WebImage `protobuf:"bytes,6,rep,name=visually_similar_images,json=visuallySimilarImages" json:"visually_similar_images,omitempty"`
	// Best guess text labels for the request image.
	BestGuessLabels []*WebDetection_WebLabel `protobuf:"bytes,8,rep,name=best_guess_labels,json=bestGuessLabels" json:"best_guess_labels,omitempty"`
}

func (m *WebDetection) Reset()                    { *m = WebDetection{} }
func (m *WebDetection) String() string            { return proto.CompactTextString(m) }
func (*WebDetection) ProtoMessage()               {}
func (*WebDetection) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *WebDetection) GetWebEntities() []*WebDetection_WebEntity {
	if m != nil {
		return m.WebEntities
	}
	return nil
}

func (m *WebDetection) GetFullMatchingImages() []*WebDetection_WebImage {
	if m != nil {
		return m.FullMatchingImages
	}
	return nil
}

func (m *WebDetection) GetPartialMatchingImages() []*WebDetection_WebImage {
	if m != nil {
		return m.PartialMatchingImages
	}
	return nil
}

func (m *WebDetection) GetPagesWithMatchingImages() []*WebDetection_WebPage {
	if m != nil {
		return m.PagesWithMatchingImages
	}
	return nil
}

func (m *WebDetection) GetVisuallySimilarImages() []*WebDetection_WebImage {
	if m != nil {
		return m.VisuallySimilarImages
	}
	return nil
}

func (m *WebDetection) GetBestGuessLabels() []*WebDetection_WebLabel {
	if m != nil {
		return m.BestGuessLabels
	}
	return nil
}

// Entity deduced from similar images on the Internet.
type WebDetection_WebEntity struct {
	// Opaque entity ID.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId" json:"entity_id,omitempty"`
	// Overall relevancy score for the entity.
	// Not normalized and not comparable across different image queries.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
	// Canonical description of the entity, in English.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
}

func (m *WebDetection_WebEntity) Reset()                    { *m = WebDetection_WebEntity{} }
func (m *WebDetection_WebEntity) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebEntity) ProtoMessage()               {}
func (*WebDetection_WebEntity) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

func (m *WebDetection_WebEntity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *WebDetection_WebEntity) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *WebDetection_WebEntity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Metadata for online images.
type WebDetection_WebImage struct {
	// The result image URL.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// (Deprecated) Overall relevancy score for the image.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
}

func (m *WebDetection_WebImage) Reset()                    { *m = WebDetection_WebImage{} }
func (m *WebDetection_WebImage) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebImage) ProtoMessage()               {}
func (*WebDetection_WebImage) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 1} }

func (m *WebDetection_WebImage) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *WebDetection_WebImage) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

// Metadata for web pages.
type WebDetection_WebPage struct {
	// The result web page URL.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// (Deprecated) Overall relevancy score for the web page.
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
	// Title for the web page, may contain HTML markups.
	PageTitle string `protobuf:"bytes,3,opt,name=page_title,json=pageTitle" json:"page_title,omitempty"`
	// Fully matching images on the page.
	// Can include resized copies of the query image.
	FullMatchingImages []*WebDetection_WebImage `protobuf:"bytes,4,rep,name=full_matching_images,json=fullMatchingImages" json:"full_matching_images,omitempty"`
	// Partial matching images on the page.
	// Those images are similar enough to share some key-point features. For
	// example an original image will likely have partial matching for its
	// crops.
	PartialMatchingImages []*WebDetection_WebImage `protobuf:"bytes,5,rep,name=partial_matching_images,json=partialMatchingImages" json:"partial_matching_images,omitempty"`
}

func (m *WebDetection_WebPage) Reset()                    { *m = WebDetection_WebPage{} }
func (m *WebDetection_WebPage) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebPage) ProtoMessage()               {}
func (*WebDetection_WebPage) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 2} }

func (m *WebDetection_WebPage) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *WebDetection_WebPage) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *WebDetection_WebPage) GetPageTitle() string {
	if m != nil {
		return m.PageTitle
	}
	return ""
}

func (m *WebDetection_WebPage) GetFullMatchingImages() []*WebDetection_WebImage {
	if m != nil {
		return m.FullMatchingImages
	}
	return nil
}

func (m *WebDetection_WebPage) GetPartialMatchingImages() []*WebDetection_WebImage {
	if m != nil {
		return m.PartialMatchingImages
	}
	return nil
}

// Label to provide extra metadata for the web detection.
type WebDetection_WebLabel struct {
	// Label for extra metadata.
	Label string `protobuf:"bytes,1,opt,name=label" json:"label,omitempty"`
	// The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
	// For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
}

func (m *WebDetection_WebLabel) Reset()                    { *m = WebDetection_WebLabel{} }
func (m *WebDetection_WebLabel) String() string            { return proto.CompactTextString(m) }
func (*WebDetection_WebLabel) ProtoMessage()               {}
func (*WebDetection_WebLabel) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 3} }

func (m *WebDetection_WebLabel) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *WebDetection_WebLabel) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func init() {
	proto.RegisterType((*WebDetection)(nil), "google.cloud.vision.v1.WebDetection")
	proto.RegisterType((*WebDetection_WebEntity)(nil), "google.cloud.vision.v1.WebDetection.WebEntity")
	proto.RegisterType((*WebDetection_WebImage)(nil), "google.cloud.vision.v1.WebDetection.WebImage")
	proto.RegisterType((*WebDetection_WebPage)(nil), "google.cloud.vision.v1.WebDetection.WebPage")
	proto.RegisterType((*WebDetection_WebLabel)(nil), "google.cloud.vision.v1.WebDetection.WebLabel")
}

func init() { proto.RegisterFile("google/cloud/vision/v1/web_detection.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 505 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x94, 0xd1, 0x8b, 0xd3, 0x4e,
	0x10, 0xc7, 0x49, 0x7b, 0x77, 0xbf, 0x76, 0xdb, 0x1f, 0x7a, 0xcb, 0xe9, 0x85, 0xa8, 0x50, 0xf4,
	0xa5, 0x88, 0x26, 0xdc, 0xf9, 0xa8, 0x4f, 0xa7, 0x87, 0x1c, 0x28, 0xd4, 0x28, 0x1c, 0xfa, 0xb2,
	0x6e, 0x92, 0x35, 0x1d, 0xd8, 0x66, 0x43, 0x76, 0xd3, 0xd2, 0xff, 0xc4, 0xbf, 0xca, 0xbf, 0xc7,
	0x47, 0x99, 0xdd, 0x8d, 0x94, 0xeb, 0x1d, 0xd4, 0x43, 0x7c, 0x9b, 0x99, 0xcc, 0xf7, 0xf3, 0xdd,
	0x9d, 0x0c, 0x4b, 0x9e, 0x96, 0x4a, 0x95, 0x52, 0x24, 0xb9, 0x54, 0x6d, 0x91, 0x2c, 0x41, 0x83,
	0xaa, 0x92, 0xe5, 0x49, 0xb2, 0x12, 0x19, 0x2b, 0x84, 0x11, 0xb9, 0x01, 0x55, 0xc5, 0x75, 0xa3,
	0x8c, 0xa2, 0xf7, 0x5d, 0x6f, 0x6c, 0x7b, 0x63, 0xd7, 0x1b, 0x2f, 0x4f, 0xa2, 0x87, 0x9e, 0xc1,
	0x6b, 0x48, 0x78, 0x55, 0x29, 0xc3, 0x51, 0xa4, 0x9d, 0xea, 0xf1, 0x8f, 0x01, 0x19, 0x5f, 0x8a,
	0xec, 0x4d, 0x07, 0xa3, 0x1f, 0xc8, 0x18, 0xe9, 0xa2, 0x32, 0x60, 0x40, 0xe8, 0x30, 0x98, 0xf4,
	0xa7, 0xa3, 0xd3, 0x38, 0xbe, 0x9e, 0x1e, 0x6f, 0x6a, 0x31, 0x39, 0x47, 0xdd, 0x3a, 0x1d, 0xad,
	0x7c, 0x08, 0x42, 0x53, 0x46, 0x8e, 0xbe, 0xb5, 0x52, 0xb2, 0x05, 0x37, 0xf9, 0x1c, 0xaa, 0x92,
	0xc1, 0x82, 0x97, 0x42, 0x87, 0x3d, 0x8b, 0x7e, 0xbe, 0x2b, 0xfa, 0x02, 0x55, 0x29, 0x45, 0xd4,
	0x7b, 0x4f, 0xb2, 0x25, 0x4d, 0x05, 0x39, 0xae, 0x79, 0x63, 0x80, 0x6f, 0x7b, 0xf4, 0x6f, 0xe3,
	0x71, 0xcf, 0xd3, 0xae, 0xd8, 0x00, 0x89, 0x6a, 0x0c, 0xd8, 0x0a, 0xcc, 0x7c, 0xcb, 0x69, 0xcf,
	0x3a, 0x3d, 0xdb, 0xd5, 0x69, 0x86, 0x46, 0xc7, 0x96, 0x77, 0x09, 0x66, 0xbe, 0x7d, 0xa3, 0x25,
	0xe8, 0x96, 0x4b, 0xb9, 0x66, 0x1a, 0x16, 0x20, 0x79, 0xd3, 0xf9, 0x1c, 0xdc, 0xea, 0x46, 0x1d,
	0xed, 0xa3, 0x83, 0x79, 0x9b, 0xcf, 0xe4, 0x30, 0x13, 0xda, 0xb0, 0xb2, 0x15, 0x5a, 0x33, 0xc9,
	0x33, 0x21, 0x75, 0x38, 0xf8, 0x33, 0x83, 0x77, 0xa8, 0x4a, 0xef, 0x20, 0xe7, 0x2d, 0x62, 0x6c,
	0xae, 0xa3, 0xaf, 0x64, 0xf8, 0x7b, 0x1d, 0xe8, 0x03, 0x32, 0xb4, 0x0b, 0xb5, 0x66, 0x50, 0x84,
	0xc1, 0x24, 0x98, 0x0e, 0xd3, 0x81, 0x2b, 0x5c, 0x14, 0xf4, 0x88, 0xec, 0xeb, 0x5c, 0x35, 0x22,
	0xec, 0x4d, 0x82, 0x69, 0x2f, 0x75, 0x09, 0x9d, 0x90, 0x51, 0x21, 0x74, 0xde, 0x40, 0x8d, 0x46,
	0x61, 0xdf, 0x8a, 0x36, 0x4b, 0xd1, 0x29, 0x19, 0x74, 0xf7, 0xa3, 0x77, 0x49, 0xbf, 0x6d, 0xa4,
	0x47, 0x63, 0x78, 0x3d, 0x35, 0xfa, 0xde, 0x23, 0xff, 0xf9, 0xe1, 0xef, 0xaa, 0xa1, 0x8f, 0x08,
	0xc1, 0xdf, 0xc4, 0x0c, 0x18, 0x29, 0xfc, 0x41, 0x86, 0x58, 0xf9, 0x84, 0x85, 0x1b, 0xb7, 0x7b,
	0xef, 0x1f, 0x6c, 0xf7, 0xfe, 0xdf, 0xdb, 0xee, 0xe8, 0xdc, 0x8e, 0xd3, 0xfe, 0x3d, 0x1c, 0x84,
	0x5d, 0x06, 0x3f, 0x1c, 0x97, 0xd0, 0x27, 0xe4, 0x7f, 0xc9, 0xab, 0xb2, 0xc5, 0x61, 0xe4, 0xaa,
	0x70, 0x63, 0x1a, 0xa6, 0xe3, 0xae, 0xf8, 0x5a, 0x15, 0xe2, 0xac, 0x21, 0x51, 0xae, 0x16, 0x37,
	0x9c, 0xe8, 0xec, 0x70, 0xf3, 0x48, 0x33, 0x7c, 0x81, 0x66, 0xc1, 0x97, 0x57, 0xbe, 0xb9, 0x54,
	0x48, 0x8a, 0x55, 0x53, 0x26, 0xa5, 0xa8, 0xec, 0xfb, 0x94, 0xb8, 0x4f, 0xbc, 0x06, 0x7d, 0xf5,
	0x11, 0x7c, 0xe9, 0xa2, 0x9f, 0x41, 0x90, 0x1d, 0xd8, 0xde, 0x17, 0xbf, 0x02, 0x00, 0x00, 0xff,
	0xff, 0x1c, 0xe5, 0x3e, 0x5b, 0x2f, 0x05, 0x00, 0x00,
}
