; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mips-linux-gnu -march=mips -mcpu=mips32 | FileCheck %s --check-prefixes=CHECK,CHECK-BE
; RUN: llc < %s -mtriple=mipsel-linux-gnu -march=mipsel -mcpu=mips32 | FileCheck %s --check-prefixes=CHECK,CHECK-LE

declare i8 @llvm.fshl.i8(i8, i8, i8)
declare i16 @llvm.fshl.i16(i16, i16, i16)
declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i64 @llvm.fshl.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

declare i8 @llvm.fshr.i8(i8, i8, i8)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i32 @llvm.fshr.i32(i32, i32, i32)
declare i64 @llvm.fshr.i64(i64, i64, i64)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)

; General case - all operands can be variables.

define i16 @fshl_i16(i16 %x, i16 %y, i16 %z) {
; CHECK-LABEL: fshl_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 65535
; CHECK-NEXT:    sll $2, $4, 16
; CHECK-NEXT:    or $1, $2, $1
; CHECK-NEXT:    andi $2, $6, 15
; CHECK-NEXT:    sllv $1, $1, $2
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    srl $2, $1, 16
  %f = call i16 @llvm.fshl.i16(i16 %x, i16 %y, i16 %z)
  ret i16 %f
}

define i32 @fshl_i32(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: fshl_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $6, 31
; CHECK-NEXT:    sllv $1, $4, $1
; CHECK-NEXT:    srl $2, $5, 1
; CHECK-NEXT:    not $3, $6
; CHECK-NEXT:    andi $3, $3, 31
; CHECK-NEXT:    srlv $2, $2, $3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $1, $2
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %f
}

; Verify that weird types are minimally supported.
declare i37 @llvm.fshl.i37(i37, i37, i37)
define i37 @fshl_i37(i37 %x, i37 %y, i37 %z) {
; CHECK-BE-LABEL: fshl_i37:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    addiu $sp, $sp, -40
; CHECK-BE-NEXT:    .cfi_def_cfa_offset 40
; CHECK-BE-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    .cfi_offset 31, -4
; CHECK-BE-NEXT:    .cfi_offset 19, -8
; CHECK-BE-NEXT:    .cfi_offset 18, -12
; CHECK-BE-NEXT:    .cfi_offset 17, -16
; CHECK-BE-NEXT:    .cfi_offset 16, -20
; CHECK-BE-NEXT:    move $16, $7
; CHECK-BE-NEXT:    move $17, $6
; CHECK-BE-NEXT:    move $18, $5
; CHECK-BE-NEXT:    move $19, $4
; CHECK-BE-NEXT:    lw $4, 56($sp)
; CHECK-BE-NEXT:    lw $5, 60($sp)
; CHECK-BE-NEXT:    addiu $6, $zero, 0
; CHECK-BE-NEXT:    jal __umoddi3
; CHECK-BE-NEXT:    addiu $7, $zero, 37
; CHECK-BE-NEXT:    not $1, $3
; CHECK-BE-NEXT:    andi $2, $3, 63
; CHECK-BE-NEXT:    not $4, $2
; CHECK-BE-NEXT:    srl $5, $18, 1
; CHECK-BE-NEXT:    sllv $6, $19, $2
; CHECK-BE-NEXT:    srlv $4, $5, $4
; CHECK-BE-NEXT:    andi $5, $1, 63
; CHECK-BE-NEXT:    srl $7, $16, 5
; CHECK-BE-NEXT:    sll $8, $17, 27
; CHECK-BE-NEXT:    or $7, $8, $7
; CHECK-BE-NEXT:    srl $8, $7, 1
; CHECK-BE-NEXT:    srlv $9, $8, $5
; CHECK-BE-NEXT:    andi $1, $1, 32
; CHECK-BE-NEXT:    move $10, $9
; CHECK-BE-NEXT:    movn $10, $zero, $1
; CHECK-BE-NEXT:    or $4, $6, $4
; CHECK-BE-NEXT:    sllv $6, $18, $2
; CHECK-BE-NEXT:    andi $3, $3, 32
; CHECK-BE-NEXT:    movn $4, $6, $3
; CHECK-BE-NEXT:    sll $7, $7, 31
; CHECK-BE-NEXT:    sll $2, $16, 27
; CHECK-BE-NEXT:    srl $11, $2, 1
; CHECK-BE-NEXT:    or $2, $4, $10
; CHECK-BE-NEXT:    movn $6, $zero, $3
; CHECK-BE-NEXT:    or $3, $11, $7
; CHECK-BE-NEXT:    srlv $3, $3, $5
; CHECK-BE-NEXT:    not $4, $5
; CHECK-BE-NEXT:    sll $5, $8, 1
; CHECK-BE-NEXT:    sllv $4, $5, $4
; CHECK-BE-NEXT:    or $3, $4, $3
; CHECK-BE-NEXT:    movn $3, $9, $1
; CHECK-BE-NEXT:    or $3, $6, $3
; CHECK-BE-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    addiu $sp, $sp, 40
;
; CHECK-LE-LABEL: fshl_i37:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    addiu $sp, $sp, -40
; CHECK-LE-NEXT:    .cfi_def_cfa_offset 40
; CHECK-LE-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    .cfi_offset 31, -4
; CHECK-LE-NEXT:    .cfi_offset 19, -8
; CHECK-LE-NEXT:    .cfi_offset 18, -12
; CHECK-LE-NEXT:    .cfi_offset 17, -16
; CHECK-LE-NEXT:    .cfi_offset 16, -20
; CHECK-LE-NEXT:    move $16, $7
; CHECK-LE-NEXT:    move $17, $6
; CHECK-LE-NEXT:    move $18, $5
; CHECK-LE-NEXT:    move $19, $4
; CHECK-LE-NEXT:    lw $4, 56($sp)
; CHECK-LE-NEXT:    lw $5, 60($sp)
; CHECK-LE-NEXT:    addiu $6, $zero, 37
; CHECK-LE-NEXT:    jal __umoddi3
; CHECK-LE-NEXT:    addiu $7, $zero, 0
; CHECK-LE-NEXT:    not $1, $2
; CHECK-LE-NEXT:    andi $3, $2, 63
; CHECK-LE-NEXT:    not $4, $3
; CHECK-LE-NEXT:    srl $5, $19, 1
; CHECK-LE-NEXT:    sllv $6, $18, $3
; CHECK-LE-NEXT:    srlv $4, $5, $4
; CHECK-LE-NEXT:    andi $5, $1, 63
; CHECK-LE-NEXT:    srl $7, $17, 5
; CHECK-LE-NEXT:    sll $8, $16, 27
; CHECK-LE-NEXT:    or $7, $8, $7
; CHECK-LE-NEXT:    srl $8, $7, 1
; CHECK-LE-NEXT:    srlv $9, $8, $5
; CHECK-LE-NEXT:    andi $1, $1, 32
; CHECK-LE-NEXT:    move $10, $9
; CHECK-LE-NEXT:    movn $10, $zero, $1
; CHECK-LE-NEXT:    or $4, $6, $4
; CHECK-LE-NEXT:    sllv $6, $19, $3
; CHECK-LE-NEXT:    andi $2, $2, 32
; CHECK-LE-NEXT:    movn $4, $6, $2
; CHECK-LE-NEXT:    sll $7, $7, 31
; CHECK-LE-NEXT:    sll $3, $17, 27
; CHECK-LE-NEXT:    srl $11, $3, 1
; CHECK-LE-NEXT:    or $3, $4, $10
; CHECK-LE-NEXT:    movn $6, $zero, $2
; CHECK-LE-NEXT:    or $2, $11, $7
; CHECK-LE-NEXT:    srlv $2, $2, $5
; CHECK-LE-NEXT:    not $4, $5
; CHECK-LE-NEXT:    sll $5, $8, 1
; CHECK-LE-NEXT:    sllv $4, $5, $4
; CHECK-LE-NEXT:    or $2, $4, $2
; CHECK-LE-NEXT:    movn $2, $9, $1
; CHECK-LE-NEXT:    or $2, $6, $2
; CHECK-LE-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    addiu $sp, $sp, 40
  %f = call i37 @llvm.fshl.i37(i37 %x, i37 %y, i37 %z)
  ret i37 %f
}

; extract(concat(0b1110000, 0b1111111) << 2) = 0b1000011

declare i7 @llvm.fshl.i7(i7, i7, i7)
define i7 @fshl_i7_const_fold() {
; CHECK-LABEL: fshl_i7_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 67
  %f = call i7 @llvm.fshl.i7(i7 112, i7 127, i7 2)
  ret i7 %f
}

define i8 @fshl_i8_const_fold_overshift_1() {
; CHECK-LABEL: fshl_i8_const_fold_overshift_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 128
  %f = call i8 @llvm.fshl.i8(i8 255, i8 0, i8 15)
  ret i8 %f
}

define i8 @fshl_i8_const_fold_overshift_2() {
; CHECK-LABEL: fshl_i8_const_fold_overshift_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 120
  %f = call i8 @llvm.fshl.i8(i8 15, i8 15, i8 11)
  ret i8 %f
}

define i8 @fshl_i8_const_fold_overshift_3() {
; CHECK-LABEL: fshl_i8_const_fold_overshift_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 0
  %f = call i8 @llvm.fshl.i8(i8 0, i8 225, i8 8)
  ret i8 %f
}

; With constant shift amount, this is 'extr'.

define i32 @fshl_i32_const_shift(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_i32_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 23
; CHECK-NEXT:    sll $2, $4, 9
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 9)
  ret i32 %f
}

; Check modulo math on shift amount.

define i32 @fshl_i32_const_overshift(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_i32_const_overshift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 23
; CHECK-NEXT:    sll $2, $4, 9
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 41)
  ret i32 %f
}

; 64-bit should also work.

define i64 @fshl_i64_const_overshift(i64 %x, i64 %y) {
; CHECK-BE-LABEL: fshl_i64_const_overshift:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    srl $1, $6, 23
; CHECK-BE-NEXT:    sll $2, $5, 9
; CHECK-BE-NEXT:    or $2, $2, $1
; CHECK-BE-NEXT:    sll $1, $6, 9
; CHECK-BE-NEXT:    srl $3, $7, 23
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    or $3, $3, $1
;
; CHECK-LE-LABEL: fshl_i64_const_overshift:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    sll $1, $7, 9
; CHECK-LE-NEXT:    srl $2, $6, 23
; CHECK-LE-NEXT:    or $2, $2, $1
; CHECK-LE-NEXT:    srl $1, $7, 23
; CHECK-LE-NEXT:    sll $3, $4, 9
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    or $3, $3, $1
  %f = call i64 @llvm.fshl.i64(i64 %x, i64 %y, i64 105)
  ret i64 %f
}

; This should work without any node-specific logic.

define i8 @fshl_i8_const_fold() {
; CHECK-LABEL: fshl_i8_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 128
  %f = call i8 @llvm.fshl.i8(i8 255, i8 0, i8 7)
  ret i8 %f
}

; Repeat everything for funnel shift right.

; General case - all operands can be variables.

define i16 @fshr_i16(i16 %x, i16 %y, i16 %z) {
; CHECK-LABEL: fshr_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $5, 65535
; CHECK-NEXT:    sll $2, $4, 16
; CHECK-NEXT:    or $1, $2, $1
; CHECK-NEXT:    andi $2, $6, 15
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    srlv $2, $1, $2
  %f = call i16 @llvm.fshr.i16(i16 %x, i16 %y, i16 %z)
  ret i16 %f
}

define i32 @fshr_i32(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: fshr_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi $1, $6, 31
; CHECK-NEXT:    srlv $1, $5, $1
; CHECK-NEXT:    sll $2, $4, 1
; CHECK-NEXT:    not $3, $6
; CHECK-NEXT:    andi $3, $3, 31
; CHECK-NEXT:    sllv $2, $2, $3
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %z)
  ret i32 %f
}

; Verify that weird types are minimally supported.
declare i37 @llvm.fshr.i37(i37, i37, i37)
define i37 @fshr_i37(i37 %x, i37 %y, i37 %z) {
; CHECK-BE-LABEL: fshr_i37:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    addiu $sp, $sp, -40
; CHECK-BE-NEXT:    .cfi_def_cfa_offset 40
; CHECK-BE-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; CHECK-BE-NEXT:    .cfi_offset 31, -4
; CHECK-BE-NEXT:    .cfi_offset 19, -8
; CHECK-BE-NEXT:    .cfi_offset 18, -12
; CHECK-BE-NEXT:    .cfi_offset 17, -16
; CHECK-BE-NEXT:    .cfi_offset 16, -20
; CHECK-BE-NEXT:    move $16, $7
; CHECK-BE-NEXT:    move $17, $6
; CHECK-BE-NEXT:    move $18, $5
; CHECK-BE-NEXT:    move $19, $4
; CHECK-BE-NEXT:    lw $4, 56($sp)
; CHECK-BE-NEXT:    lw $5, 60($sp)
; CHECK-BE-NEXT:    addiu $6, $zero, 0
; CHECK-BE-NEXT:    jal __umoddi3
; CHECK-BE-NEXT:    addiu $7, $zero, 37
; CHECK-BE-NEXT:    addiu $1, $3, 27
; CHECK-BE-NEXT:    andi $2, $1, 63
; CHECK-BE-NEXT:    not $3, $2
; CHECK-BE-NEXT:    srl $4, $16, 5
; CHECK-BE-NEXT:    sll $5, $17, 27
; CHECK-BE-NEXT:    or $4, $5, $4
; CHECK-BE-NEXT:    sll $5, $4, 1
; CHECK-BE-NEXT:    sll $6, $16, 27
; CHECK-BE-NEXT:    srlv $6, $6, $2
; CHECK-BE-NEXT:    sllv $3, $5, $3
; CHECK-BE-NEXT:    not $5, $1
; CHECK-BE-NEXT:    andi $7, $5, 63
; CHECK-BE-NEXT:    sll $8, $18, 1
; CHECK-BE-NEXT:    sllv $8, $8, $7
; CHECK-BE-NEXT:    andi $5, $5, 32
; CHECK-BE-NEXT:    move $9, $8
; CHECK-BE-NEXT:    movn $9, $zero, $5
; CHECK-BE-NEXT:    or $3, $3, $6
; CHECK-BE-NEXT:    srlv $2, $4, $2
; CHECK-BE-NEXT:    andi $1, $1, 32
; CHECK-BE-NEXT:    movn $3, $2, $1
; CHECK-BE-NEXT:    srl $4, $18, 31
; CHECK-BE-NEXT:    sll $6, $19, 1
; CHECK-BE-NEXT:    or $4, $6, $4
; CHECK-BE-NEXT:    or $3, $9, $3
; CHECK-BE-NEXT:    movn $2, $zero, $1
; CHECK-BE-NEXT:    sllv $1, $4, $7
; CHECK-BE-NEXT:    not $4, $7
; CHECK-BE-NEXT:    lui $6, 32767
; CHECK-BE-NEXT:    ori $6, $6, 65535
; CHECK-BE-NEXT:    and $6, $18, $6
; CHECK-BE-NEXT:    srlv $4, $6, $4
; CHECK-BE-NEXT:    or $1, $1, $4
; CHECK-BE-NEXT:    movn $1, $8, $5
; CHECK-BE-NEXT:    or $2, $1, $2
; CHECK-BE-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    addiu $sp, $sp, 40
;
; CHECK-LE-LABEL: fshr_i37:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    addiu $sp, $sp, -40
; CHECK-LE-NEXT:    .cfi_def_cfa_offset 40
; CHECK-LE-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; CHECK-LE-NEXT:    .cfi_offset 31, -4
; CHECK-LE-NEXT:    .cfi_offset 19, -8
; CHECK-LE-NEXT:    .cfi_offset 18, -12
; CHECK-LE-NEXT:    .cfi_offset 17, -16
; CHECK-LE-NEXT:    .cfi_offset 16, -20
; CHECK-LE-NEXT:    move $16, $7
; CHECK-LE-NEXT:    move $17, $6
; CHECK-LE-NEXT:    move $18, $5
; CHECK-LE-NEXT:    move $19, $4
; CHECK-LE-NEXT:    lw $4, 56($sp)
; CHECK-LE-NEXT:    lw $5, 60($sp)
; CHECK-LE-NEXT:    addiu $6, $zero, 37
; CHECK-LE-NEXT:    jal __umoddi3
; CHECK-LE-NEXT:    addiu $7, $zero, 0
; CHECK-LE-NEXT:    addiu $1, $2, 27
; CHECK-LE-NEXT:    andi $2, $1, 63
; CHECK-LE-NEXT:    not $3, $2
; CHECK-LE-NEXT:    srl $4, $17, 5
; CHECK-LE-NEXT:    sll $5, $16, 27
; CHECK-LE-NEXT:    or $4, $5, $4
; CHECK-LE-NEXT:    sll $5, $4, 1
; CHECK-LE-NEXT:    sll $6, $17, 27
; CHECK-LE-NEXT:    srlv $6, $6, $2
; CHECK-LE-NEXT:    sllv $3, $5, $3
; CHECK-LE-NEXT:    not $5, $1
; CHECK-LE-NEXT:    andi $7, $5, 63
; CHECK-LE-NEXT:    sll $8, $19, 1
; CHECK-LE-NEXT:    sllv $8, $8, $7
; CHECK-LE-NEXT:    andi $5, $5, 32
; CHECK-LE-NEXT:    move $9, $8
; CHECK-LE-NEXT:    movn $9, $zero, $5
; CHECK-LE-NEXT:    or $3, $3, $6
; CHECK-LE-NEXT:    srlv $4, $4, $2
; CHECK-LE-NEXT:    andi $1, $1, 32
; CHECK-LE-NEXT:    movn $3, $4, $1
; CHECK-LE-NEXT:    srl $2, $19, 31
; CHECK-LE-NEXT:    sll $6, $18, 1
; CHECK-LE-NEXT:    or $6, $6, $2
; CHECK-LE-NEXT:    or $2, $9, $3
; CHECK-LE-NEXT:    movn $4, $zero, $1
; CHECK-LE-NEXT:    sllv $1, $6, $7
; CHECK-LE-NEXT:    not $3, $7
; CHECK-LE-NEXT:    lui $6, 32767
; CHECK-LE-NEXT:    ori $6, $6, 65535
; CHECK-LE-NEXT:    and $6, $19, $6
; CHECK-LE-NEXT:    srlv $3, $6, $3
; CHECK-LE-NEXT:    or $1, $1, $3
; CHECK-LE-NEXT:    movn $1, $8, $5
; CHECK-LE-NEXT:    or $3, $1, $4
; CHECK-LE-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    addiu $sp, $sp, 40
  %f = call i37 @llvm.fshr.i37(i37 %x, i37 %y, i37 %z)
  ret i37 %f
}

; extract(concat(0b1110000, 0b1111111) >> 2) = 0b0011111

declare i7 @llvm.fshr.i7(i7, i7, i7)
define i7 @fshr_i7_const_fold() {
; CHECK-LABEL: fshr_i7_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 31
  %f = call i7 @llvm.fshr.i7(i7 112, i7 127, i7 2)
  ret i7 %f
}

define i8 @fshr_i8_const_fold_overshift_1() {
; CHECK-LABEL: fshr_i8_const_fold_overshift_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 254
  %f = call i8 @llvm.fshr.i8(i8 255, i8 0, i8 15)
  ret i8 %f
}

define i8 @fshr_i8_const_fold_overshift_2() {
; CHECK-LABEL: fshr_i8_const_fold_overshift_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 225
  %f = call i8 @llvm.fshr.i8(i8 15, i8 15, i8 11)
  ret i8 %f
}

define i8 @fshr_i8_const_fold_overshift_3() {
; CHECK-LABEL: fshr_i8_const_fold_overshift_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 255
  %f = call i8 @llvm.fshr.i8(i8 0, i8 255, i8 8)
  ret i8 %f
}

; With constant shift amount, this is 'extr'.

define i32 @fshr_i32_const_shift(i32 %x, i32 %y) {
; CHECK-LABEL: fshr_i32_const_shift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 9
; CHECK-NEXT:    sll $2, $4, 23
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 9)
  ret i32 %f
}

; Check modulo math on shift amount. 41-32=9.

define i32 @fshr_i32_const_overshift(i32 %x, i32 %y) {
; CHECK-LABEL: fshr_i32_const_overshift:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl $1, $5, 9
; CHECK-NEXT:    sll $2, $4, 23
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    or $2, $2, $1
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 41)
  ret i32 %f
}

; 64-bit should also work. 105-64 = 41.

define i64 @fshr_i64_const_overshift(i64 %x, i64 %y) {
; CHECK-BE-LABEL: fshr_i64_const_overshift:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    srl $1, $5, 9
; CHECK-BE-NEXT:    sll $2, $4, 23
; CHECK-BE-NEXT:    or $2, $2, $1
; CHECK-BE-NEXT:    srl $1, $6, 9
; CHECK-BE-NEXT:    sll $3, $5, 23
; CHECK-BE-NEXT:    jr $ra
; CHECK-BE-NEXT:    or $3, $3, $1
;
; CHECK-LE-LABEL: fshr_i64_const_overshift:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    srl $1, $7, 9
; CHECK-LE-NEXT:    sll $2, $4, 23
; CHECK-LE-NEXT:    or $2, $2, $1
; CHECK-LE-NEXT:    srl $1, $4, 9
; CHECK-LE-NEXT:    sll $3, $5, 23
; CHECK-LE-NEXT:    jr $ra
; CHECK-LE-NEXT:    or $3, $3, $1
  %f = call i64 @llvm.fshr.i64(i64 %x, i64 %y, i64 105)
  ret i64 %f
}

; This should work without any node-specific logic.

define i8 @fshr_i8_const_fold() {
; CHECK-LABEL: fshr_i8_const_fold:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    addiu $2, $zero, 254
  %f = call i8 @llvm.fshr.i8(i8 255, i8 0, i8 7)
  ret i8 %f
}

define i32 @fshl_i32_shift_by_bitwidth(i32 %x, i32 %y) {
; CHECK-LABEL: fshl_i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $4
  %f = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 32)
  ret i32 %f
}

define i32 @fshr_i32_shift_by_bitwidth(i32 %x, i32 %y) {
; CHECK-LABEL: fshr_i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $2, $5
  %f = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 32)
  ret i32 %f
}

define <4 x i32> @fshl_v4i32_shift_by_bitwidth(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshl_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    move $2, $4
; CHECK-NEXT:    move $3, $5
; CHECK-NEXT:    move $4, $6
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    move $5, $7
  %f = call <4 x i32> @llvm.fshl.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

define <4 x i32> @fshr_v4i32_shift_by_bitwidth(<4 x i32> %x, <4 x i32> %y) {
; CHECK-LABEL: fshr_v4i32_shift_by_bitwidth:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw $5, 28($sp)
; CHECK-NEXT:    lw $4, 24($sp)
; CHECK-NEXT:    lw $3, 20($sp)
; CHECK-NEXT:    lw $2, 16($sp)
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
  %f = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 32, i32 32, i32 32, i32 32>)
  ret <4 x i32> %f
}

