; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32
define i32 @add_i32(i32 %x, i32 %y) {
; MIPS32-LABEL: add_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $2, $4, $5
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %z = add i32 %x, %y
  ret i32 %z
}

define signext i8 @add_i8_sext(i8 signext %a, i8 signext %b) {
; MIPS32-LABEL: add_i8_sext:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $1, $5, $4
; MIPS32-NEXT:    sll $1, $1, 24
; MIPS32-NEXT:    sra $2, $1, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i8 %b, %a
  ret i8 %add
}

define zeroext i8 @add_i8_zext(i8 zeroext %a, i8 zeroext %b) {
; MIPS32-LABEL: add_i8_zext:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $1, $5, $4
; MIPS32-NEXT:    andi $2, $1, 255
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i8 %b, %a
  ret i8 %add
}

define i8 @add_i8_aext(i8 %a, i8 %b) {
; MIPS32-LABEL: add_i8_aext:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $2, $5, $4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i8 %b, %a
  ret i8 %add
}

define signext i16 @add_i16_sext(i16 signext %a, i16 signext %b) {
; MIPS32-LABEL: add_i16_sext:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $1, $5, $4
; MIPS32-NEXT:    sll $1, $1, 16
; MIPS32-NEXT:    sra $2, $1, 16
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i16 %b, %a
  ret i16 %add
}

define zeroext i16 @add_i16_zext(i16 zeroext %a, i16 zeroext %b) {
; MIPS32-LABEL: add_i16_zext:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $1, $5, $4
; MIPS32-NEXT:    andi $2, $1, 65535
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i16 %b, %a
  ret i16 %add
}

define i16 @add_i16_aext(i16 %a, i16 %b) {
; MIPS32-LABEL: add_i16_aext:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $2, $5, $4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i16 %b, %a
  ret i16 %add
}

define i64 @add_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: add_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addu $2, $6, $4
; MIPS32-NEXT:    sltu $3, $2, $4
; MIPS32-NEXT:    addu $1, $7, $5
; MIPS32-NEXT:    andi $3, $3, 1
; MIPS32-NEXT:    addu $3, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i64 %b, %a
  ret i64 %add
}

define i128 @add_i128(i128 %a, i128 %b) {
; MIPS32-LABEL: add_i128:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    move $8, $4
; MIPS32-NEXT:    move $3, $5
; MIPS32-NEXT:    move $4, $6
; MIPS32-NEXT:    addiu $1, $sp, 16
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    addiu $1, $sp, 20
; MIPS32-NEXT:    lw $6, 0($1)
; MIPS32-NEXT:    addiu $1, $sp, 24
; MIPS32-NEXT:    lw $5, 0($1)
; MIPS32-NEXT:    addiu $1, $sp, 28
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    addu $2, $2, $8
; MIPS32-NEXT:    sltu $8, $2, $8
; MIPS32-NEXT:    addu $3, $6, $3
; MIPS32-NEXT:    andi $8, $8, 1
; MIPS32-NEXT:    addu $3, $3, $8
; MIPS32-NEXT:    sltu $6, $3, $6
; MIPS32-NEXT:    addu $4, $5, $4
; MIPS32-NEXT:    andi $6, $6, 1
; MIPS32-NEXT:    addu $4, $4, $6
; MIPS32-NEXT:    sltu $5, $4, $5
; MIPS32-NEXT:    addu $1, $1, $7
; MIPS32-NEXT:    andi $5, $5, 1
; MIPS32-NEXT:    addu $5, $1, $5
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i128 %b, %a
  ret i128 %add
}

define i32 @add_imm(i32 %a) {
; MIPS32-LABEL: add_imm:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $2, $4, 3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i32 %a, 3
  ret i32 %add
}

define i32 @add_negative_imm(i32 %a) {
; MIPS32-LABEL: add_negative_imm:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $2, $4, -3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i32 %a, -3
  ret i32 %add
}

define i32 @add_not_imm32SExt16(i32 %a) {
; MIPS32-LABEL: add_not_imm32SExt16:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 65535
; MIPS32-NEXT:    addu $2, $4, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = add i32 %a, 65535
  ret i32 %add
}

declare { i32, i1 } @llvm.uadd.with.overflow.i32(i32, i32)
define void @uadd_with_overflow(i32 %lhs, i32 %rhs, i32* %padd, i1* %pcarry_flag) {
; MIPS32-LABEL: uadd_with_overflow:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addu $1, $4, $5
; MIPS32-NEXT:    sltu $2, $1, $5
; MIPS32-NEXT:    andi $2, $2, 1
; MIPS32-NEXT:    sb $2, 0($7)
; MIPS32-NEXT:    sw $1, 0($6)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
  %res = call { i32, i1 } @llvm.uadd.with.overflow.i32(i32 %lhs, i32 %rhs)
  %carry_flag = extractvalue { i32, i1 } %res, 1
  %add = extractvalue { i32, i1 } %res, 0
  store i1 %carry_flag, i1* %pcarry_flag
  store i32 %add, i32* %padd
  ret void
}
