// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  ellint_1
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>


// Test data for k=-0.90000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.3381508715713370e-16
const testcase_ellint_1<double>
data001[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.0000000000000000 },
  { 0.17525427376115024, -0.90000000000000002, 0.17453292519943295 },
  { 0.35492464591297446, -0.90000000000000002, 0.34906585039886590 },
  { 0.54388221416157112, -0.90000000000000002, 0.52359877559829882 },
  { 0.74797400423532490, -0.90000000000000002, 0.69813170079773179 },
  { 0.97463898451966458, -0.90000000000000002, 0.87266462599716477 },
  { 1.2334463254523440, -0.90000000000000002, 1.0471975511965976 },
  { 1.5355247765594913, -0.90000000000000002, 1.2217304763960306 },
  { 1.8882928567775121, -0.90000000000000002, 1.3962634015954636 },
  { 2.2805491384227703, -0.90000000000000002, 1.5707963267948966 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1175183168766718e-16
const testcase_ellint_1<double>
data002[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.0000000000000000 },
  { 0.17510154241338899, -0.80000000000000004, 0.17453292519943295 },
  { 0.35365068839779390, -0.80000000000000004, 0.34906585039886590 },
  { 0.53926804409084550, -0.80000000000000004, 0.52359877559829882 },
  { 0.73587926028070361, -0.80000000000000004, 0.69813170079773179 },
  { 0.94770942970071170, -0.80000000000000004, 0.87266462599716477 },
  { 1.1789022995388236, -0.80000000000000004, 1.0471975511965976 },
  { 1.4323027881876009, -0.80000000000000004, 1.2217304763960306 },
  { 1.7069629739121674, -0.80000000000000004, 1.3962634015954636 },
  { 1.9953027776647296, -0.80000000000000004, 1.5707963267948966 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.5930208052157665e-16
const testcase_ellint_1<double>
data003[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.0000000000000000 },
  { 0.17496737466916723, -0.69999999999999996, 0.17453292519943295 },
  { 0.35254687535677925, -0.69999999999999996, 0.34906585039886590 },
  { 0.53536740275997119, -0.69999999999999996, 0.52359877559829882 },
  { 0.72603797651684454, -0.69999999999999996, 0.69813170079773179 },
  { 0.92698296348313458, -0.69999999999999996, 0.87266462599716477 },
  { 1.1400447527693316, -0.69999999999999996, 1.0471975511965976 },
  { 1.3657668117194073, -0.69999999999999996, 1.2217304763960306 },
  { 1.6024686895959159, -0.69999999999999996, 1.3962634015954636 },
  { 1.8456939983747236, -0.69999999999999996, 1.5707963267948966 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3664899092028927e-16
const testcase_ellint_1<double>
data004[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.0000000000000000 },
  { 0.17485154362988359, -0.59999999999999998, 0.17453292519943295 },
  { 0.35160509865544326, -0.59999999999999998, 0.34906585039886590 },
  { 0.53210652578446138, -0.59999999999999998, 0.52359877559829882 },
  { 0.71805304664485659, -0.59999999999999998, 0.69813170079773179 },
  { 0.91082759030195970, -0.59999999999999998, 0.87266462599716477 },
  { 1.1112333229323361, -0.59999999999999998, 1.0471975511965976 },
  { 1.3191461190365270, -0.59999999999999998, 1.2217304763960306 },
  { 1.5332022105084773, -0.59999999999999998, 1.3962634015954636 },
  { 1.7507538029157526, -0.59999999999999998, 1.5707963267948966 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.1201497220602069e-16
const testcase_ellint_1<double>
data005[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.0000000000000000 },
  { 0.17475385514035785, -0.50000000000000000, 0.17453292519943295 },
  { 0.35081868470101585, -0.50000000000000000, 0.34906585039886590 },
  { 0.52942862705190574, -0.50000000000000000, 0.52359877559829882 },
  { 0.71164727562630314, -0.50000000000000000, 0.69813170079773179 },
  { 0.89824523594227768, -0.50000000000000000, 0.87266462599716477 },
  { 1.0895506700518851, -0.50000000000000000, 1.0471975511965976 },
  { 1.2853005857432931, -0.50000000000000000, 1.2217304763960306 },
  { 1.4845545520549484, -0.50000000000000000, 1.3962634015954636 },
  { 1.6857503548125963, -0.50000000000000000, 1.5707963267948966 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.0617918857203532e-16
const testcase_ellint_1<double>
data006[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.0000000000000000 },
  { 0.17467414669441528, -0.40000000000000002, 0.17453292519943295 },
  { 0.35018222772483443, -0.40000000000000002, 0.34906585039886590 },
  { 0.52729015917508737, -0.40000000000000002, 0.52359877559829882 },
  { 0.70662374407341244, -0.40000000000000002, 0.69813170079773179 },
  { 0.88859210497602170, -0.40000000000000002, 0.87266462599716477 },
  { 1.0733136290471379, -0.40000000000000002, 1.0471975511965976 },
  { 1.2605612170157061, -0.40000000000000002, 1.2217304763960306 },
  { 1.4497513956433439, -0.40000000000000002, 1.3962634015954636 },
  { 1.6399998658645112, -0.40000000000000002, 1.5707963267948966 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.3361874537309281e-16
const testcase_ellint_1<double>
data007[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.0000000000000000 },
  { 0.17461228653000099, -0.30000000000000004, 0.17453292519943295 },
  { 0.34969146102798415, -0.30000000000000004, 0.34906585039886590 },
  { 0.52565822873726320, -0.30000000000000004, 0.52359877559829882 },
  { 0.70284226512408532, -0.30000000000000004, 0.69813170079773179 },
  { 0.88144139195111182, -0.30000000000000004, 0.87266462599716477 },
  { 1.0614897067260520, -0.30000000000000004, 1.0471975511965976 },
  { 1.2428416824174218, -0.30000000000000004, 1.2217304763960306 },
  { 1.4251795877015927, -0.30000000000000004, 1.3962634015954636 },
  { 1.6080486199305128, -0.30000000000000004, 1.5707963267948966 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2156475739151676e-16
const testcase_ellint_1<double>
data008[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.0000000000000000 },
  { 0.17456817290292809, -0.19999999999999996, 0.17453292519943295 },
  { 0.34934315932086801, -0.19999999999999996, 0.34906585039886590 },
  { 0.52450880529443988, -0.19999999999999996, 0.52359877559829882 },
  { 0.70020491009844876, -0.19999999999999996, 0.69813170079773179 },
  { 0.87651006649967955, -0.19999999999999996, 0.87266462599716477 },
  { 1.0534305870298994, -0.19999999999999996, 1.0471975511965976 },
  { 1.2308975521670784, -0.19999999999999996, 1.2217304763960306 },
  { 1.4087733584990738, -0.19999999999999996, 1.3962634015954636 },
  { 1.5868678474541660, -0.19999999999999996, 1.5707963267948966 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.1735566504509650e-16
const testcase_ellint_1<double>
data009[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.0000000000000000 },
  { 0.17454173353063659, -0.099999999999999978, 0.17453292519943295 },
  { 0.34913506721468091, -0.099999999999999978, 0.34906585039886590 },
  { 0.52382550016538942, -0.099999999999999978, 0.52359877559829882 },
  { 0.69864700854177020, -0.099999999999999978, 0.69813170079773179 },
  { 0.87361792586964870, -0.099999999999999978, 0.87266462599716477 },
  { 1.0487386319621683, -0.099999999999999978, 1.0471975511965976 },
  { 1.2239913752078757, -0.099999999999999978, 1.2217304763960306 },
  { 1.3993423113684049, -0.099999999999999978, 1.3962634015954636 },
  { 1.5747455615173562, -0.099999999999999978, 1.5707963267948966 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.1203697876423452e-16
const testcase_ellint_1<double>
data010[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.0000000000000000 },
  { 0.17453292519943292, 0.0000000000000000, 0.17453292519943295 },
  { 0.34906585039886584, 0.0000000000000000, 0.34906585039886590 },
  { 0.52359877559829870, 0.0000000000000000, 0.52359877559829882 },
  { 0.69813170079773168, 0.0000000000000000, 0.69813170079773179 },
  { 0.87266462599716477, 0.0000000000000000, 0.87266462599716477 },
  { 1.0471975511965974, 0.0000000000000000, 1.0471975511965976 },
  { 1.2217304763960304, 0.0000000000000000, 1.2217304763960306 },
  { 1.3962634015954631, 0.0000000000000000, 1.3962634015954636 },
  { 1.5707963267948966, 0.0000000000000000, 1.5707963267948966 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.1735566504509650e-16
const testcase_ellint_1<double>
data011[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.0000000000000000 },
  { 0.17454173353063659, 0.10000000000000009, 0.17453292519943295 },
  { 0.34913506721468091, 0.10000000000000009, 0.34906585039886590 },
  { 0.52382550016538942, 0.10000000000000009, 0.52359877559829882 },
  { 0.69864700854177020, 0.10000000000000009, 0.69813170079773179 },
  { 0.87361792586964870, 0.10000000000000009, 0.87266462599716477 },
  { 1.0487386319621683, 0.10000000000000009, 1.0471975511965976 },
  { 1.2239913752078757, 0.10000000000000009, 1.2217304763960306 },
  { 1.3993423113684049, 0.10000000000000009, 1.3962634015954636 },
  { 1.5747455615173562, 0.10000000000000009, 1.5707963267948966 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2156475739151676e-16
const testcase_ellint_1<double>
data012[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.0000000000000000 },
  { 0.17456817290292809, 0.19999999999999996, 0.17453292519943295 },
  { 0.34934315932086801, 0.19999999999999996, 0.34906585039886590 },
  { 0.52450880529443988, 0.19999999999999996, 0.52359877559829882 },
  { 0.70020491009844876, 0.19999999999999996, 0.69813170079773179 },
  { 0.87651006649967955, 0.19999999999999996, 0.87266462599716477 },
  { 1.0534305870298994, 0.19999999999999996, 1.0471975511965976 },
  { 1.2308975521670784, 0.19999999999999996, 1.2217304763960306 },
  { 1.4087733584990738, 0.19999999999999996, 1.3962634015954636 },
  { 1.5868678474541660, 0.19999999999999996, 1.5707963267948966 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.3361874537309281e-16
const testcase_ellint_1<double>
data013[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.0000000000000000 },
  { 0.17461228653000099, 0.30000000000000004, 0.17453292519943295 },
  { 0.34969146102798415, 0.30000000000000004, 0.34906585039886590 },
  { 0.52565822873726320, 0.30000000000000004, 0.52359877559829882 },
  { 0.70284226512408532, 0.30000000000000004, 0.69813170079773179 },
  { 0.88144139195111182, 0.30000000000000004, 0.87266462599716477 },
  { 1.0614897067260520, 0.30000000000000004, 1.0471975511965976 },
  { 1.2428416824174218, 0.30000000000000004, 1.2217304763960306 },
  { 1.4251795877015927, 0.30000000000000004, 1.3962634015954636 },
  { 1.6080486199305128, 0.30000000000000004, 1.5707963267948966 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 5.4157225142938039e-16
const testcase_ellint_1<double>
data014[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.0000000000000000 },
  { 0.17467414669441528, 0.39999999999999991, 0.17453292519943295 },
  { 0.35018222772483443, 0.39999999999999991, 0.34906585039886590 },
  { 0.52729015917508737, 0.39999999999999991, 0.52359877559829882 },
  { 0.70662374407341244, 0.39999999999999991, 0.69813170079773179 },
  { 0.88859210497602170, 0.39999999999999991, 0.87266462599716477 },
  { 1.0733136290471379, 0.39999999999999991, 1.0471975511965976 },
  { 1.2605612170157061, 0.39999999999999991, 1.2217304763960306 },
  { 1.4497513956433439, 0.39999999999999991, 1.3962634015954636 },
  { 1.6399998658645112, 0.39999999999999991, 1.5707963267948966 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.1201497220602069e-16
const testcase_ellint_1<double>
data015[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.0000000000000000 },
  { 0.17475385514035785, 0.50000000000000000, 0.17453292519943295 },
  { 0.35081868470101585, 0.50000000000000000, 0.34906585039886590 },
  { 0.52942862705190574, 0.50000000000000000, 0.52359877559829882 },
  { 0.71164727562630314, 0.50000000000000000, 0.69813170079773179 },
  { 0.89824523594227768, 0.50000000000000000, 0.87266462599716477 },
  { 1.0895506700518851, 0.50000000000000000, 1.0471975511965976 },
  { 1.2853005857432931, 0.50000000000000000, 1.2217304763960306 },
  { 1.4845545520549484, 0.50000000000000000, 1.3962634015954636 },
  { 1.6857503548125963, 0.50000000000000000, 1.5707963267948966 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3664899092028927e-16
const testcase_ellint_1<double>
data016[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.0000000000000000 },
  { 0.17485154362988359, 0.60000000000000009, 0.17453292519943295 },
  { 0.35160509865544326, 0.60000000000000009, 0.34906585039886590 },
  { 0.53210652578446138, 0.60000000000000009, 0.52359877559829882 },
  { 0.71805304664485659, 0.60000000000000009, 0.69813170079773179 },
  { 0.91082759030195970, 0.60000000000000009, 0.87266462599716477 },
  { 1.1112333229323361, 0.60000000000000009, 1.0471975511965976 },
  { 1.3191461190365270, 0.60000000000000009, 1.2217304763960306 },
  { 1.5332022105084775, 0.60000000000000009, 1.3962634015954636 },
  { 1.7507538029157526, 0.60000000000000009, 1.5707963267948966 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.5930208052157665e-16
const testcase_ellint_1<double>
data017[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.0000000000000000 },
  { 0.17496737466916723, 0.69999999999999996, 0.17453292519943295 },
  { 0.35254687535677925, 0.69999999999999996, 0.34906585039886590 },
  { 0.53536740275997119, 0.69999999999999996, 0.52359877559829882 },
  { 0.72603797651684454, 0.69999999999999996, 0.69813170079773179 },
  { 0.92698296348313458, 0.69999999999999996, 0.87266462599716477 },
  { 1.1400447527693316, 0.69999999999999996, 1.0471975511965976 },
  { 1.3657668117194073, 0.69999999999999996, 1.2217304763960306 },
  { 1.6024686895959159, 0.69999999999999996, 1.3962634015954636 },
  { 1.8456939983747236, 0.69999999999999996, 1.5707963267948966 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1175183168766718e-16
const testcase_ellint_1<double>
data018[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.0000000000000000 },
  { 0.17510154241338899, 0.80000000000000004, 0.17453292519943295 },
  { 0.35365068839779390, 0.80000000000000004, 0.34906585039886590 },
  { 0.53926804409084550, 0.80000000000000004, 0.52359877559829882 },
  { 0.73587926028070361, 0.80000000000000004, 0.69813170079773179 },
  { 0.94770942970071170, 0.80000000000000004, 0.87266462599716477 },
  { 1.1789022995388236, 0.80000000000000004, 1.0471975511965976 },
  { 1.4323027881876009, 0.80000000000000004, 1.2217304763960306 },
  { 1.7069629739121674, 0.80000000000000004, 1.3962634015954636 },
  { 1.9953027776647296, 0.80000000000000004, 1.5707963267948966 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 3.8945813740035884e-16
const testcase_ellint_1<double>
data019[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.0000000000000000 },
  { 0.17525427376115024, 0.89999999999999991, 0.17453292519943295 },
  { 0.35492464591297446, 0.89999999999999991, 0.34906585039886590 },
  { 0.54388221416157112, 0.89999999999999991, 0.52359877559829882 },
  { 0.74797400423532490, 0.89999999999999991, 0.69813170079773179 },
  { 0.97463898451966458, 0.89999999999999991, 0.87266462599716477 },
  { 1.2334463254523440, 0.89999999999999991, 1.0471975511965976 },
  { 1.5355247765594910, 0.89999999999999991, 1.2217304763960306 },
  { 1.8882928567775117, 0.89999999999999991, 1.3962634015954636 },
  { 2.2805491384227703, 0.89999999999999991, 1.5707963267948966 },
};
const double toler019 = 2.5000000000000020e-13;

template<typename Tp, unsigned int Num>
  void
  test(const testcase_ellint_1<Tp> (&data)[Num], Tp toler)
  {
    bool test __attribute__((unused)) = true;
    const Tp eps = std::numeric_limits<Tp>::epsilon();
    Tp max_abs_diff = -Tp(1);
    Tp max_abs_frac = -Tp(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
      {
	const Tp f = std::ellint_1(data[i].k, data[i].phi);
	const Tp f0 = data[i].f0;
	const Tp diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Tp(10) * eps
	 && std::abs(f) > Tp(10) * eps)
	  {
	    const Tp frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  return 0;
}
