from __future__ import absolute_import
import os
import json

HERE = os.path.dirname(__file__)


def get_customizations():
    for f in os.listdir(HERE):
        if not f.endswith("json"):
            continue
        yield os.path.join(HERE, f)


def find_customization(path_or_name):
    if not path_or_name.endswith(".json"):
        path_or_name += ".json"
    if not os.path.exists(path_or_name):
        # trying relative
        rpath = os.path.join(HERE, path_or_name)
        if not os.path.exists(rpath):
            return None
        path_or_name = rpath
    return path_or_name


def get_customization(path_or_name):
    path = find_customization(path_or_name)
    if path is None:
        raise IOError("Can't find the customization file %r" % path_or_name)
    with open(path) as f:
        return json.loads(f.read())
