/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/OperationBanner.ui")]
public class OperationBanner : Adw.Bin
{
  [GtkChild]
  unowned Adw.Banner banner;
  [GtkChild]
  unowned Gtk.ProgressBar progress;

  OperationWrapper wrapper;

  construct {
    wrapper = new OperationWrapper(DejaDup.OperationWatcher.get_instance(), this);
    wrapper.cancel_stops = true;

    wrapper.bind_property("active", banner, "revealed", BindingFlags.SYNC_CREATE);
    wrapper.bind_property("active", progress, "visible", BindingFlags.SYNC_CREATE);
    wrapper.bind_property("summary", banner, "title", BindingFlags.SYNC_CREATE);
    wrapper.bind_property("button-label", banner, "button-label", BindingFlags.SYNC_CREATE);
    wrapper.bind_property("fraction", progress, "fraction", BindingFlags.SYNC_CREATE);

    wrapper.notify["button-suggested"].connect(handle_button_suggested_change);
    wrapper.notify["error-mode"].connect(handle_error_mode_change);

    wrapper.pulse.connect(progress.pulse);
  }

  // #############
  // Helpers
  // #############

  [GtkCallback]
  void on_button_clicked()
  {
    wrapper.click();
  }

  void handle_button_suggested_change()
  {
    if (wrapper.button_suggested)
      banner.button_style = Adw.BannerButtonStyle.SUGGESTED;
    else
      banner.button_style = Adw.BannerButtonStyle.DEFAULT;
  }

  void handle_error_mode_change()
  {
    if (wrapper.error_mode)
      banner.add_css_class("error");
    else
      banner.remove_css_class("error");
  }
}
