% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoduration.R
\name{all.equal.nanoduration}
\alias{all.equal.nanoduration}
\alias{all.equal,nanoduration-method}
\title{Test if Two Objects are (Nearly) Equal}
\usage{
\method{all.equal}{nanoduration}(
  target,
  current,
  tolerance = sqrt(.Machine$double.eps),
  scale = NULL,
  countEQ = FALSE,
  formatFUN = function(err, what) format(err),
  ...,
  check.attributes = TRUE
)

\S4method{all.equal}{nanoduration}(
  target,
  current,
  tolerance = sqrt(.Machine$double.eps),
  scale = NULL,
  countEQ = FALSE,
  formatFUN = function(err, what) format(err),
  ...,
  check.attributes = TRUE
)
}
\arguments{
\item{target, current}{\code{nanoduration} arguments to be compared}

\item{tolerance}{numeric >= 0. Differences smaller than
\code{tolerance} are not reported.  The default value is close
to \code{1.5e-8}.}

\item{scale}{\code{NULL} or numeric > 0, typically of length 1 or
\code{length(target)}.  See \sQuote{Details}.}

\item{countEQ}{logical indicating if the \code{target == current} cases should be
counted when computing the mean (absolute or relative)
differences.  The default, \code{FALSE} may seem misleading in
cases where \code{target} and \code{current} only differ in a few
places; see the extensive example.}

\item{formatFUN}{a \code{function} of two arguments, \code{err}, the relative, absolute
or scaled error, and \code{what}, a character string indicating
the _kind_ of error; maybe used, e.g., to format relative and
absolute errors differently.}

\item{...}{further arguments for different methods}

\item{check.attributes}{logical indicating if the \code{attributes} of \code{target}
and \code{current} (other than the names) should be compared.}
}
\description{
Compare \code{target} and \code{current} testing \sQuote{near
equality}.  If they are different, comparison is still made to
some extent, and a report of the differences is returned.  Do not
use \code{all.equal} directly in \code{if} expressions---either
use \code{isTRUE(all.equal(....))} or \code{\link{identical}} if
appropriate.
}
\seealso{
\code{\link{identical}}, \code{\link{isTRUE}},
    \code{\link{==}}, and \code{\link{all}} for exact equality
    testing.
}
