/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2019 Felix Singer <felix.singer@9elements.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU General Public License for more details.
 */

#include <soc/gpio.h>

#ifndef GPIO_H
#define GPIO_H

static const struct pad_config gpio_table[] = {
	// ********************************
	// ******* GPIO Group North *******
	// ********************************
	// *GPIO
	_PAD_CFG_STRUCT(GPIO_0,		0x04000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_1,		0x04000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_2,		0x04000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_3,		0x04000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_4,		0x04000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_5,		0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_6,		0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_7,		0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_8,		0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_9,		0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_10,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_11,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_12,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_13,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_14,	0x44000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_15,	0x44000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_16,	0x40880102,	0x00024000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_17,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_18,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_19,	0x44000201,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_20,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_21,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_22,	0x44000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_23,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_24,	0x44000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_25,	0x44000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_26,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_27,	0x44000201,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_28,	0x44000102,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_29,	0x44000102,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_30,	0x44000102,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_31,	0x44000102,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_32,	0x44000102,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_33,	0x44000102,	0x00000000),

	// PWM0
	_PAD_CFG_STRUCT(GPIO_34,	0x44000400,	0x00001000),

	// PWM1
	_PAD_CFG_STRUCT(GPIO_35,	0x44000400,	0x00001000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_36,	0x44000201,	0x00000000),

	// PWM3
	_PAD_CFG_STRUCT(GPIO_37,	0x04000400,	0x00001000),

	// LPSS_UART0_RXD
	_PAD_CFG_STRUCT(GPIO_38,	0x44000402,	0x00023100),

	// LPSS_UART0_TXD
	_PAD_CFG_STRUCT(GPIO_39,	0x44000400,	0x00003100),

	// LPSS_UART0_RTS_N
	_PAD_CFG_STRUCT(GPIO_40,	0x44000400,	0x00003100),

	// LPSS_UART0_CTS_N
	_PAD_CFG_STRUCT(GPIO_41,	0x44000402,	0x00023100),

	// LPSS_UART1_RXD
	_PAD_CFG_STRUCT(GPIO_42,	0x44000402,	0x00023100),

	// LPSS_UART1_TXD
	_PAD_CFG_STRUCT(GPIO_43,	0x44000400,	0x0001f100),

	// LPSS_UART1_RTS_N
	_PAD_CFG_STRUCT(GPIO_44,	0x44000400,	0x00003100),

	// LPSS_UART1_CTS_N
	_PAD_CFG_STRUCT(GPIO_45,	0x44000402,	0x0001c100),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_46,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_47,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_48,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_49,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_62,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_63,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_64,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_65,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_66,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_67,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_68,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_69,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_70,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_71,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_72,	0x44000200,	0x00001000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_73,	0x44000200,	0x00001000),

	// *JTAG_TCK
	_PAD_CFG_STRUCT(TCK,		0x44000400,	0x00c3d000),

	// *JTAG_TRST_N
	_PAD_CFG_STRUCT(TRST_B,		0x44000400,	0x00c3d000),

	// *JTAG_TMS
	_PAD_CFG_STRUCT(TMS,		0x44000400,	0x00c3f000),

	// *JTAG_TDI
	_PAD_CFG_STRUCT(TDI,		0x44000400,	0x00c3f000),

	// *JTAG_PMODE
	_PAD_CFG_STRUCT(CX_PMODE,	0x44000400,	0x00c3c000),

	// *JTAG_PREQ_N
	_PAD_CFG_STRUCT(CX_PREQ_B,	0x44000402,	0x00c3f000),

	// *JTAGX
	_PAD_CFG_STRUCT(JTAGX,		0x44000402,	0x00c3f000),

	// *JTAG_PRDY_N
	_PAD_CFG_STRUCT(CX_PRDY_B,	0x44000402,	0x0043f000),

	// *JTAG_TDO
	_PAD_CFG_STRUCT(TDO,		0x44000400,	0x0043f000),

	// GPIO
	_PAD_CFG_STRUCT(CNV_BRI_DT,	0x44000201,	0x0003d000),

	// GPIO
	_PAD_CFG_STRUCT(CNV_BRI_RSP,	0x44000201,	0x00002400),

	// GPIO
	_PAD_CFG_STRUCT(CNV_RGI_DT,	0x44000201,	0x00000000),

	// RESERVED
//	_PAD_CFG_STRUCT(CNV_RGI_RSP,	0xffffffff,	0xffffffff),

	// GPIO
	_PAD_CFG_STRUCT(SVID0_ALERT_B,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(SVID0_DATA,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(SVID0_CLK,	0x44000100,	0x00000000),


	// ************************************
	// ******* GPIO Group NorthWest *******
	// ************************************
	// *DDI0_DDC_SDA
	_PAD_CFG_STRUCT(GPIO_187,	0x44000400,	0x0001f000),

	// *DDI0_DDC_SCL
	_PAD_CFG_STRUCT(GPIO_188,	0x44000400,	0x0001f000),

	// *DDI1_DDC_SDA
	_PAD_CFG_STRUCT(GPIO_189,	0x44000400,	0x00002c00),

	// *DDI1_DDC_SCL
	_PAD_CFG_STRUCT(GPIO_190,	0x44000400,	0x00002c00),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_191,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_192,	0x44000100,	0x00000000),

	// *PNL0_VDDEN
	_PAD_CFG_STRUCT(GPIO_193,	0x44000400,	0x00005000),

	// *PNL0_BKLTEN
	_PAD_CFG_STRUCT(GPIO_194,	0x44000400,	0x00005000),

	// *PNL0_BKLTCTL
	_PAD_CFG_STRUCT(GPIO_195,	0x44000400,	0x00005000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_196,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_197,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_198,	0x44000100,	0x00000000),

	// DDI1_HPD
	_PAD_CFG_STRUCT(GPIO_199,	0x44000800,	0x00003000),

	// DDI0_HPD
	_PAD_CFG_STRUCT(GPIO_200,	0x44000802,	0x00003000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_201,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_202,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_203,	0x44000102,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_204,	0x44000102,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(PMC_SPI_FS0,	0x44000102,	0x00000000),

	// DDI2_HPD
	_PAD_CFG_STRUCT(PMC_SPI_FS1,	0x44000802,	0x00003000),

	// GPIO
	_PAD_CFG_STRUCT(PMC_SPI_FS2,	0x44000102,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(PMC_SPI_RXD,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(PMC_SPI_TXD,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(PMC_SPI_CLK,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(PMIC_PWRGOOD,	0x44000203,	0x00002400),

	// GPIO
	_PAD_CFG_STRUCT(PMIC_RESET_B,	0x44000102,	0x0003c000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_213,	0x44000201,	0x00003000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_214,	0x44000102,	0x00003300),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_215,	0x44000100,	0x00003300),

	// *THERMTRIP_N
	_PAD_CFG_STRUCT(PMIC_THERMTRIP_B,	0x44000400,	0x00003000),

	// GPIO
	_PAD_CFG_STRUCT(PMIC_STDBY,	0x44000201,	0x00001000),

	// *PROCHOT_N
	_PAD_CFG_STRUCT(PROCHOT_B,	0x44000402,	0x00023000),

	// RESERVED
//	_PAD_CFG_STRUCT(PMIC_I2C_SCL,	0xffffffff,	0xffffffff),

	// RESERVED
//	_PAD_CFG_STRUCT(PMIC_I2C_SDA,	0xffffffff,	0xffffffff),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_74,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_75,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_76,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_77,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_78,	0x44000100,	0x00000000),

	// AVS_DMIC_CLK_A1
	_PAD_CFG_STRUCT(GPIO_79,	0x44000400,	0x0003d000),

	// AVS_DMIC_CLK_B1
	_PAD_CFG_STRUCT(GPIO_80,	0x44000400,	0x0003d000),

	// AVS_DMIC_DATA_1
	_PAD_CFG_STRUCT(GPIO_81,	0x44000400,	0x00025200),

	// AVS_DMIC_CLK_AB2
	_PAD_CFG_STRUCT(GPIO_82,	0x44000400,	0x0003d000),

	// AVS_DMIC_DATA_2
	_PAD_CFG_STRUCT(GPIO_83,	0x44000400,	0x00025200),

	// AVS_I2S2_MCLK
	_PAD_CFG_STRUCT(GPIO_84,	0x44000400,	0x00001000),

	// AVS_I2S2_BCLK
	_PAD_CFG_STRUCT(GPIO_85,	0x44000400,	0x0001d200),

	// AVS_I2S2_WS_SYNC
	_PAD_CFG_STRUCT(GPIO_86,	0x44000402,	0x0001d200),

	// AVS_I2S2_SDI
	_PAD_CFG_STRUCT(GPIO_87,	0x44000402,	0x0001f200),

	// AVS_I2S2_SDO
	_PAD_CFG_STRUCT(GPIO_88,	0x44000400,	0x0001c200),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_89,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_90,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_91,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_92,	0x44000100,	0x00000000),

	// *FST_SPI_CS0_N
	_PAD_CFG_STRUCT(GPIO_97,	0x44000402,	0x0003fc00),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_98,	0x44000100,	0x00000000),

	// *FST_SPI_MOSI_IO0
	_PAD_CFG_STRUCT(GPIO_99,	0x44000400,	0x0003fc00),

	// *FST_SPI_MISO_IO1
	_PAD_CFG_STRUCT(GPIO_100,	0x44000402,	0x0003fc00),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_101,	0x44000100,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_102,	0x44000100,	0x00000000),

	// *FST_SPI_CLK
	_PAD_CFG_STRUCT(GPIO_103,	0x44000400,	0x0003fc00),

	// *n/a
	_PAD_CFG_STRUCT(FST_SPI_CLK_FB,	0x44000400,	0x0003c000),

	// SIO_SPI_0_CLK
	_PAD_CFG_STRUCT(GPIO_104,	0x44000400,	0x0001d200),

	// SIO_SPI_0_FS0
	_PAD_CFG_STRUCT(GPIO_105,	0x44000400,	0x0001f200),

	// SIO_SPI_0_FS1
	_PAD_CFG_STRUCT(GPIO_106,	0x44000400,	0x0001f200),

	// SIO_SPI_0_RXD
	_PAD_CFG_STRUCT(GPIO_109,	0x44000402,	0x0001f200),

	// SIO_SPI_0_TXD
	_PAD_CFG_STRUCT(GPIO_110,	0x44000400,	0x0001f200),

	// SIO_SPI_1_CLK
	_PAD_CFG_STRUCT(GPIO_111,	0x44000400,	0x00001000),

	// SIO_SPI_1_FS0
	_PAD_CFG_STRUCT(GPIO_112,	0x44000400,	0x00001000),

	// SIO_SPI_1_FS1
	_PAD_CFG_STRUCT(GPIO_113,	0x44000400,	0x00001000),

	// SIO_SPI_1_RXD
	_PAD_CFG_STRUCT(GPIO_116,	0x44000402,	0x0001d000),

	// SIO_SPI_1_TXD
	_PAD_CFG_STRUCT(GPIO_117,	0x44000400,	0x00001000),

	// SIO_SPI_2_CLK
	_PAD_CFG_STRUCT(GPIO_118,	0x44000400,	0x00001000),

	// SIO_SPI_2_FS0
	_PAD_CFG_STRUCT(GPIO_119,	0x44000400,	0x00001000),

	// SIO_SPI_2_FS1
	_PAD_CFG_STRUCT(GPIO_120,	0x44000400,	0x00001000),

	// SIO_SPI_2_FS2
	_PAD_CFG_STRUCT(GPIO_121,	0x44000400,	0x00001000),

	// SIO_SPI_2_RXD
	_PAD_CFG_STRUCT(GPIO_122,	0x44000400,	0x00001000),

	// SIO_SPI_2_TXD
	_PAD_CFG_STRUCT(GPIO_123,	0x44000400,	0x00001000),


	// *******************************
	// ******* GPIO Group West *******
	// *******************************
	// LPSS_I2C0_SDA
	_PAD_CFG_STRUCT(GPIO_124,	0x44000402,	0x00012700),

	// LPSS_I2C0_SCL
	_PAD_CFG_STRUCT(GPIO_125,	0x44000402,	0x00012700),

	// LPSS_I2C1_SDA
	_PAD_CFG_STRUCT(GPIO_126,	0x44000402,	0x00012700),

	// LPSS_I2C1_SCL
	_PAD_CFG_STRUCT(GPIO_127,	0x44000402,	0x00012700),

	// LPSS_I2C2_SDA
	_PAD_CFG_STRUCT(GPIO_128,	0x44000402,	0x00012700),

	// LPSS_I2C2_SCL
	_PAD_CFG_STRUCT(GPIO_129,	0x44000402,	0x00012700),

	// LPSS_I2C3_SDA
	_PAD_CFG_STRUCT(GPIO_130,	0x44000402,	0x00012700),

	// LPSS_I2C3_SCL
	_PAD_CFG_STRUCT(GPIO_131,	0x44000402,	0x00012700),

	// LPSS_I2C4_SDA
	_PAD_CFG_STRUCT(GPIO_132,	0x44000402,	0x00012700),

	// LPSS_I2C4_SCL
	_PAD_CFG_STRUCT(GPIO_133,	0x44000402,	0x00012700),

	// LPSS_I2C5_SDA
	_PAD_CFG_STRUCT(GPIO_134,	0x44000402,	0x0001f200),

	// LPSS_I2C5_SCL
	_PAD_CFG_STRUCT(GPIO_135,	0x44000402,	0x0001f200),

	// LPSS_I2C6_SDA
	_PAD_CFG_STRUCT(GPIO_136,	0x44000402,	0x0001f200),

	// LPSS_I2C6_SCL
	_PAD_CFG_STRUCT(GPIO_137,	0x44000402,	0x0001f200),

	// LPSS_I2C7_SDA
	_PAD_CFG_STRUCT(GPIO_138,	0x44000402,	0x00006700),

	// LPSS_I2C7_SCL
	_PAD_CFG_STRUCT(GPIO_139,	0x44000402,	0x00006700),

	// AVS_I2S6_BCLK
	_PAD_CFG_STRUCT(GPIO_146,	0x44000800,	0x0003d000),

	// AVS_I2S6_WS_SYNC
	_PAD_CFG_STRUCT(GPIO_147,	0x44000800,	0x0003d000),

	// AVS_I2S6_SDI
	_PAD_CFG_STRUCT(GPIO_148,	0x44000802,	0x0003d000),

	// AVS_I2S6_SDO
	_PAD_CFG_STRUCT(GPIO_149,	0x44000800,	0x0003d000),

	// AVS_I2S5_BCLK
	_PAD_CFG_STRUCT(GPIO_150,	0x44000800,	0x0001d200),

	// AVS_I2S5_WS_SYNC
	_PAD_CFG_STRUCT(GPIO_151,	0x44000800,	0x0001d200),

	// AVS_I2S5_SDI
	_PAD_CFG_STRUCT(GPIO_152,	0x44000802,	0x0001d200),

	// AVS_I2S5_SDO
	_PAD_CFG_STRUCT(GPIO_153,	0x44000800,	0x0001c200),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_154,	0x44000102,	0x00000000),

	// SPKR
	_PAD_CFG_STRUCT(GPIO_155,	0x44000800,	0x0003d000),

	// *PCIE_CLKREQ0_N
	_PAD_CFG_STRUCT(GPIO_209,	0x44000400,	0x00001000),

	// *PCIE_CLKREQ1_N
	_PAD_CFG_STRUCT(GPIO_210,	0x44000400,	0x00001000),

	// *PCIE_CLKREQ2_N
	_PAD_CFG_STRUCT(GPIO_211,	0x44000400,	0x00001000),

	// *PCIE_CLKREQ3_N
	_PAD_CFG_STRUCT(GPIO_212,	0x44000400,	0x00001000),

	// *OSC_CLK_OUT_0
	_PAD_CFG_STRUCT(OSC_CLK_OUT_0,	0x44000400,	0x00001000),

	// *OSC_CLK_OUT_1
	_PAD_CFG_STRUCT(OSC_CLK_OUT_1,	0x44000400,	0x00001000),

	// *OSC_CLK_OUT_2
	_PAD_CFG_STRUCT(OSC_CLK_OUT_2,	0x44000400,	0x00001000),

	// *OSC_CLK_OUT_3
	_PAD_CFG_STRUCT(OSC_CLK_OUT_3,	0x44000400,	0x00001000),

	// GPIO
	_PAD_CFG_STRUCT(OSC_CLK_OUT_4,	0x44000100,	0x00000000),

	// *GPIO
	_PAD_CFG_STRUCT(PMU_AC_PRESENT,	0x44000102,	0x00000000),

	// GPIO
	_PAD_CFG_STRUCT(PMU_BATLOW_B,	0x44000102,	0x00000000),

	// *PMU_PLTRST_N
	_PAD_CFG_STRUCT(PMU_PLTRST_B,	0x44000400,	0x0003c000),

	// *PMU_PWRBTN_N
	_PAD_CFG_STRUCT(PMU_PWRBTN_B,	0x44000402,	0x0003f000),

	// *PMU_RSTBTN_N
	_PAD_CFG_STRUCT(PMU_RESETBUTTON_B,	0x44000402,	0x0003c000),

	// *PMU_SLP_S0_N
	_PAD_CFG_STRUCT(PMU_SLP_S0_B,	0x44000400,	0x0003c000),

	// *PMU_SLP_S3_N
	_PAD_CFG_STRUCT(PMU_SLP_S3_B,	0x44000400,	0x0003c000),

	// *PMU_SLP_S4_N
	_PAD_CFG_STRUCT(PMU_SLP_S4_B,	0x44000400,	0x0003c000),

	// *PMU_SUSCLK
	_PAD_CFG_STRUCT(PMU_SUSCLK,	0x44000400,	0x0003c000),

	// *GPIO
	_PAD_CFG_STRUCT(PMU_WAKE_B,	0x44000201,	0x0003f000),

	// *SUS_STAT_B
	_PAD_CFG_STRUCT(SUS_STAT_B,	0x44000400,	0x0003c000),

	// GPIO
	_PAD_CFG_STRUCT(SUSPWRDNACK,	0x44000102,	0x00000000),


	// ************************************
	// ******* GPIO Group SouthWest *******
	// ************************************
	// PCIE_WAKE0_N
	_PAD_CFG_STRUCT(GPIO_205,	0x44000402,	0x00000000),

	// PCIE_WAKE1_N
	_PAD_CFG_STRUCT(GPIO_206,	0x44000402,	0x00000000),

	// PCIE_WAKE2_N
	_PAD_CFG_STRUCT(GPIO_207,	0x44000402,	0x00000000),

	// PCIE_WAKE3_N
	_PAD_CFG_STRUCT(GPIO_208,	0x44000402,	0x00000000),

	// *EMMC_CLK
	_PAD_CFG_STRUCT(GPIO_156,	0x44000402,	0x00005000),

	// *EMMC_D0
	_PAD_CFG_STRUCT(GPIO_157,	0x44000402,	0x00023000),

	// *EMMC_D1
	_PAD_CFG_STRUCT(GPIO_158,	0x44000402,	0x00023000),

	// *EMMC_D2
	_PAD_CFG_STRUCT(GPIO_159,	0x44000402,	0x00023000),

	// *EMMC_D3
	_PAD_CFG_STRUCT(GPIO_160,	0x44000402,	0x00023000),

	// *EMMC_D4
	_PAD_CFG_STRUCT(GPIO_161,	0x44000402,	0x00023000),

	// *EMMC_D5
	_PAD_CFG_STRUCT(GPIO_162,	0x44000402,	0x00023000),

	// *EMMC_D6
	_PAD_CFG_STRUCT(GPIO_163,	0x44000402,	0x00023000),

	// *EMMC_D7
	_PAD_CFG_STRUCT(GPIO_164,	0x44000402,	0x00023000),

	// *EMMC_CMD
	_PAD_CFG_STRUCT(GPIO_165,	0x44000402,	0x00023000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_166,	0x44000300,	0x00001000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_167,	0x44000102,	0x00023000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_168,	0x44000100,	0x00023000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_169,	0x44000200,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_170,	0x44000201,	0x00003000),

	// *GPIO
	_PAD_CFG_STRUCT(GPIO_171,	0x44000201,	0x00003000),

	// SDCARD_CLK
	_PAD_CFG_STRUCT(GPIO_172,	0x44000400,	0x00021100),

	// n/a
	_PAD_CFG_STRUCT(GPIO_179,	0x44000400,	0x00001000),

	// SDCARD_D0
	_PAD_CFG_STRUCT(GPIO_173,	0x44000402,	0x00023100),

	// SDCARD_D1
	_PAD_CFG_STRUCT(GPIO_174,	0x44000402,	0x00023000),

	// SDCARD_D2
	_PAD_CFG_STRUCT(GPIO_175,	0x44000402,	0x00023000),

	// SDCARD_D3
	_PAD_CFG_STRUCT(GPIO_176,	0x44000402,	0x00023000),

	// SDCARD_CD_B
	_PAD_CFG_STRUCT(GPIO_177,	0x44000402,	0x00003000),

	// SDCARD_CMD
	_PAD_CFG_STRUCT(GPIO_178,	0x44000402,	0x00023100),

	// SDCARD_LVL_WP
	_PAD_CFG_STRUCT(GPIO_186,	0x44000402,	0x00003000),

	// *EMMC_RCLK
	_PAD_CFG_STRUCT(GPIO_182,	0x44000400,	0x0001d000),

	// GPIO
	_PAD_CFG_STRUCT(GPIO_183,	0x44000200,	0x00001000),

	// SMB_ALERT_N
	_PAD_CFG_STRUCT(SMB_ALERTB,	0x44000402,	0x0003f000),

	// SMB_CLK
	_PAD_CFG_STRUCT(SMB_CLK,	0x44000402,	0x0003f000),

	// SMB_DATA
	_PAD_CFG_STRUCT(SMB_DATA,	0x44000402,	0x0003f000),

	// LPC_ILB_SERIRQ
	_PAD_CFG_STRUCT(LPC_ILB_SERIRQ,	0x44000402,	0x0003f000),

	// LPC_CLKOUT0
	_PAD_CFG_STRUCT(LPC_CLKOUT0,	0x44000400,	0x00020100),

	// LPC_CLKOUT1
	_PAD_CFG_STRUCT(LPC_CLKOUT1,	0x44000400,	0x00020100),

	// LPC_AD0
	_PAD_CFG_STRUCT(LPC_AD0,	0x44000402,	0x00023100),

	// LPC_AD1
	_PAD_CFG_STRUCT(LPC_AD1,	0x44000402,	0x00023100),

	// LPC_AD2
	_PAD_CFG_STRUCT(LPC_AD2,	0x44000402,	0x00023100),

	// LPC_AD3
	_PAD_CFG_STRUCT(LPC_AD3,	0x44000402,	0x00023100),

	// LPC_CLKRUNB
	_PAD_CFG_STRUCT(LPC_CLKRUNB,	0x44000400,	0x00023100),

	// LPC_FRAMEB
	_PAD_CFG_STRUCT(LPC_FRAMEB,	0x44000400,	0x00023100),
};

#endif
